<?php

namespace App\Repository;

use App\Entity\Mindmap;
use App\Entity\User;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Common\Persistence\ManagerRegistry;

class MindmapRepository extends ServiceEntityRepository
{
    protected $entity="App:Mindmap";

    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Mindmap::class);
    }

    public function getMindmapgroups(User $user) {
        $groups=$user->getGroups();
        $mygroups=[];
        
        // Partage aux groupes
        foreach($groups as $group) {
            $tmp[$group->getId()] =
                $this->getEntityManager()->createQueryBuilder()
                     ->select('s')
                     ->from($this->entity,'s')
                     ->from('App:Group','g')
                     ->where('g.id=:id')
                     ->andWhere('g MEMBER OF s.groups')
                     ->andWhere('s.user!=:user')
                     ->setParameter('id',$group->getId())
                     ->setParameter('user',$user)
                     ->getQuery()->getResult();


            foreach($tmp[$group->getId()] as $my) {
                if(!in_array($my,$mygroups)) {
                    array_push($mygroups,$my);
                }
            }                     
        }

        // Partage utilisateur
        $tmp =
            $this->getEntityManager()->createQueryBuilder()
                 ->select('s')
                 ->from($this->entity,'s')
                 ->andWhere(':user MEMBER OF s.users')
                 ->andWhere('s.user!=:user')
                 ->setParameter('user',$user)
                 ->getQuery()->getResult();
        foreach($tmp as $my) {
            if(!in_array($my,$mygroups)) {
                array_push($mygroups,$my);
            }
        }

        return $mygroups;
    }    

    public function getMindmapgroupreaders(User $user,$mygroups) {
        $groups=$user->getGroups();
        $mygroupreaders=[];

        // Partage aux groupes
        foreach($groups as $group) {
            $tmp[$group->getId()] =
                $this->getEntityManager()->createQueryBuilder()
                     ->select('s')
                     ->from($this->entity,'s')
                     ->from('App:Group','g')
                     ->where('g.id=:id')
                     ->andWhere('g MEMBER OF s.groupreaders')
                     ->andWhere('s.user!=:user')
                     ->setParameter('id',$group->getId())
                     ->setParameter('user',$user)
                     ->getQuery()->getResult();

            foreach($tmp[$group->getId()] as $my) {
                if(!in_array($my,$mygroups)&&!in_array($my,$mygroupreaders)) {
                    array_push($mygroupreaders,$my);
                }
            }                     
        }

        // Partage utilisateur
        $tmp =
            $this->getEntityManager()->createQueryBuilder()
                 ->select('s')
                 ->from($this->entity,'s')
                 ->andWhere(':user MEMBER OF s.userreaders')
                 ->andWhere('s.user!=:user')
                 ->setParameter('user',$user)
                 ->getQuery()->getResult();
        foreach($tmp as $my) {
            if(!in_array($my,$mygroups)&&!in_array($my,$mygroupreaders)) {
                array_push($mygroupreaders,$my);
            }
        }

        return $mygroupreaders;
    }      
}
