<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Scrum
 *
 * @ORM\Table(name="scrumcolumn")
 * @ORM\Entity(repositoryClass="App\Repository\ScrumcolumnRepository")
 * 
 */
class Scrumcolumn
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @ORM\Column(name="size", type="integer")
     */
    private $size;

    /**
     * @ORM\ManyToOne(targetEntity="Scrum", inversedBy="scrumcolumns")
     */
    private $scrum;
        
    /**
     * @ORM\OneToMany(targetEntity="Scrumwidget", mappedBy="scrumcolumn", cascade={"persist"}, orphanRemoval=true)
     * @ORM\OrderBy({"roworder" = "ASC"})
     */
    private $scrumwidgets;

    public function __construct()
    {
        $this->scrumwidgets = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getRoworder(): ?int
    {
        return $this->roworder;
    }

    public function setRoworder(int $roworder): self
    {
        $this->roworder = $roworder;

        return $this;
    }

    public function getSize(): ?int
    {
        return $this->size;
    }

    public function setSize(int $size): self
    {
        $this->size = $size;

        return $this;
    }

    public function getScrum(): ?Scrum
    {
        return $this->scrum;
    }

    public function setScrum(?Scrum $scrum): self
    {
        $this->scrum = $scrum;

        return $this;
    }

    /**
     * @return Collection|Scrumwidget[]
     */
    public function getScrumwidgets(): Collection
    {
        return $this->scrumwidgets;
    }

    public function addScrumwidget(Scrumwidget $scrumwidget): self
    {
        if (!$this->scrumwidgets->contains($scrumwidget)) {
            $this->scrumwidgets[] = $scrumwidget;
            $scrumwidget->setScrumcolumn($this);
        }

        return $this;
    }

    public function removeScrumwidget(Scrumwidget $scrumwidget): self
    {
        if ($this->scrumwidgets->contains($scrumwidget)) {
            $this->scrumwidgets->removeElement($scrumwidget);
            // set the owning side to null (unless already changed)
            if ($scrumwidget->getScrumcolumn() === $this) {
                $scrumwidget->setScrumcolumn(null);
            }
        }

        return $this;
    }

}
