<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Filesystem\Filesystem;

class HomeController extends AbstractController
{
    public function home()
    {
        // Forcer la connexion
        return $this->redirect($this->generateUrl('app_homeuser'));
    }

    public function homeuser()
    {
        $em = $this->getDoctrine()->getManager();
        $user=$this->getUser();

        // Mes scrums / pads
        $myscrums=[];
        $myscrumgroups=[];
        $myscrumgroupwriters=[];
        $myscrumgroupreaders=[];
        
        $mywhiteboards=[];
        $mywhiteboardgroups=[];
        $mywhiteboardgroupwriters=[];
        $mywhiteboardgroupreaders=[];

        $mywordclouds=[];
        $mywordcloudgroups=[];
        $mywordcloudgroupwriters=[];
        $mywordcloudgroupreaders=[];

        $mytimelines=[];
        $mytimelinegroups=[];
        $mytimelinegroupreaders=[];    
        
        $mymindmaps=[];
        $mymindmapgroups=[];
        $mymindmapgroupreaders=[];             
        
        $mypads=[];
        $mypadgroups=[];
        
        $mycalcs=[];
        $mycalcgroups=[];

        if($user) {
            // Mes scrums / whiteboards / wordclouds / timelines / pads / calcs
            $myscrums=$em->getRepository("App:Scrum")->findBy(["user"=>$user]);
            $mywhiteboards=$em->getRepository("App:Whiteboard")->findBy(["user"=>$user]);
            $mywordclouds=$em->getRepository("App:Wordcloud")->findBy(["user"=>$user]);
            $mytimelines=$em->getRepository("App:Timeline")->findBy(["user"=>$user]);
            $mymindmaps=$em->getRepository("App:Mindmap")->findBy(["user"=>$user]);
            $mypads=$em->getRepository("App:Etherpad")->findBy(["user"=>$user]);
            $mycalcs=$em->getRepository("App:Ethercalc")->findBy(["user"=>$user]);   

            // Cacul des scrum / whiteboard / wordcloud / timeline / mindmap / pad / calc partagées aux groupes
            $myscrumgroups=$em->getRepository("App:Scrum")->getScrumgroups($user);
            $myscrumgroupwriters=$em->getRepository("App:Scrum")->getScrumgroupwriters($user,$myscrumgroups);
            $myscrumgroupreaders=$em->getRepository("App:Scrum")->getScrumgroupreaders($user,$myscrumgroups,$myscrumgroupwriters);

            $mywhiteboardgroups=$em->getRepository("App:Whiteboard")->getWhiteboardgroups($user);
            $mywhiteboardgroupwriters=$em->getRepository("App:Whiteboard")->getWhiteboardgroupwriters($user,$mywhiteboardgroups);
            $mywhiteboardgroupreaders=$em->getRepository("App:Whiteboard")->getWhiteboardgroupreaders($user,$mywhiteboardgroups,$mywhiteboardgroupwriters);

            $mywordcloudgroups=$em->getRepository("App:Wordcloud")->getWordcloudgroups($user);
            $mywordcloudgroupwriters=$em->getRepository("App:Wordcloud")->getWordcloudgroupwriters($user,$mywordcloudgroups);
            $mywordcloudgroupreaders=$em->getRepository("App:Wordcloud")->getWordcloudgroupreaders($user,$mywordcloudgroups,$mywordcloudgroupwriters);

            $mytimelinegroups=$em->getRepository("App:Timeline")->getTimelinegroups($user);
            $mytimelinegroupreaders=$em->getRepository("App:Timeline")->getTimelinegroupreaders($user,$mytimelinegroups);

            $mymindmapgroups=$em->getRepository("App:Mindmap")->getMindmapgroups($user);
            $mymindmapgroupreaders=$em->getRepository("App:Mindmap")->getMindmapgroupreaders($user,$mymindmapgroups);

            $mypadgroups=$em->getRepository("App:Etherpad")->getPadgroups($user);

            $mycalcgroups=$em->getRepository("App:Ethercalc")->getCalcgroups($user);
        }

        return $this->render('Home/home.html.twig',[
            "useheader"                 => true,
            "usesidebar"                => false,
            'myscrums'                  => $myscrums,
            'myscrumgroups'             => $myscrumgroups,
            'myscrumgroupwriters'       => $myscrumgroupwriters,
            'myscrumgroupreaders'       => $myscrumgroupreaders,
            'mywhiteboards'             => $mywhiteboards,
            'mywhiteboardgroups'        => $mywhiteboardgroups,
            'mywhiteboardgroupwriters'  => $mywhiteboardgroupwriters,
            'mywhiteboardgroupreaders'  => $mywhiteboardgroupreaders,        
            'mywordclouds'              => $mywordclouds,
            'mywordcloudgroups'         => $mywordcloudgroups,
            'mywordcloudgroupwriters'   => $mywordcloudgroupwriters,
            'mywordcloudgroupreaders'   => $mywordcloudgroupreaders,                  
            'mytimelines'               => $mytimelines,
            'mytimelinegroups'          => $mytimelinegroups,
            'mytimelinegroupreaders'    => $mytimelinegroupreaders,            
            'mymindmaps'                => $mymindmaps,
            'mymindmapgroups'           => $mymindmapgroups,
            'mymindmapgroupreaders'     => $mymindmapgroupreaders,            
            'mypads'                    => $mypads,
            'mypadgroups'               => $mypadgroups,
            'mycalcs'                   => $mycalcs,
            'mycalcgroups'              => $mycalcgroups,            
        ]);
    }

    public function admin()
    {
        return $this->render('Home/admin.html.twig',[
            "useheader"     => true,
            "usesidebar"    => true,
        ]);
    }

    public function noperm(Request $request,$displayname,$email) 
    {
        $url=$request->query->get('url');

        return $this->render('Home/noperm.html.twig',[
            "useheader"     => true,
            "usesidebar"    => false,
            "displayname"   => $displayname,
            "email"         => $email,
            "url"           => $url,
        ]);
    }

    public function ckeditor(Request $request,$access=null) {
        // Fichier temporaire uploadé
        $tmpfile    = $request->files->get('upload');
        $extention  = $tmpfile->getClientOriginalExtension();

        // Répertoire de Destination
        $fs         = new Filesystem();
        $rootdir    = $this->getParameter('kernel.project_dir') . '/public'; 
        $fs->mkdir($rootdir."/uploads/ckeditor");
        
        // Fichier cible
        $targetName = uniqid().".".$extention;
        $targetFile = $rootdir."/uploads/ckeditor/".$targetName;
        $targetUrl  = "/".$this->getParameter('appAlias')."/uploads/ckeditor/".$targetName;
        $message    = "";

        move_uploaded_file($tmpfile,$targetFile);
        
        $output["uploaded"]=1;
        $output["fileName"]=$targetName;
        $output["url"]=$targetUrl;

        return new Response(json_encode($output));
    }

    public function background($type)
    {
        return $this->render('Home/background.html.twig',["type"=>$type]);
    }
}
