<?php
/**
 * @copyright Copyright (c) 2016, ownCloud, Inc.
 *
 * @author Arthur Schiwon <blizzz@arthur-schiwon.de>
 * @author Joas Schilling <coding@schilljs.com>
 * @author Morris Jobke <hey@morrisjobke.de>
 * @author Roeland Jago Douma <roeland@famdouma.nl>
 * @author Roger Szabo <roger.szabo@web.de>
 * @author Vinicius Cubas Brand <vinicius@eita.org.br>
 *
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */

use OCA\User_LDAP\Helper;
use OCA\User_LDAP\LDAP;

use OCA\User_LDAP\User_Proxy;
use OCA\User_LDAP\Mapping\UserMapping;
use OCA\User_LDAP\User\DeletedUsersIndex;

use OCA\User_LDAP\Group_Proxy;
use OCA\User_LDAP\Mapping\GroupMapping;

$dbConnection = \OC::$server->getDatabaseConnection();
$userMapping = new UserMapping($dbConnection);
$helper = new Helper(\OC::$server->getConfig());
$ocConfig = \OC::$server->getConfig();
$ldap=new LDAP();

$userManager=\OC::$server->getUserManager();
$uBackend = new User_Proxy($helper->getServerConfigurationPrefixes(true),$ldap,$ocConfig,\OC::$server->getNotificationManager(),\OC::$server->getUserSession(),\OC::$server->query('LDAPUserPluginManager'));
$deletedUsersIndex = new DeletedUsersIndex($ocConfig, $dbConnection, $userMapping);
$application->add(new OCA\OCCTools\Command\SyncUsers($uBackend, $helper, $deletedUsersIndex, $userManager));

$gMapping = new GroupMapping($dbConnection);
$gProxy = new Group_Proxy($helper->getServerConfigurationPrefixes(true),$ldap,\OC::$server->query('LDAPGroupPluginManager'));
$application->add(new OCA\OCCTools\Command\SyncGroups($gProxy, $gMapping, $dbConnection));

$application->add(new OCA\OCCTools\Command\ClearUserPreference($dbConnection));