/**
 * Retrieves messages from the server.
 *
 * @module     core_message/message_repository
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_repository",["jquery","core/ajax","core/notification","core_message/message_drawer_view_conversation_constants"],(function($,Ajax,Notification,Constants){var CONVERSATION_TYPES=Constants.CONVERSATION_TYPES,sendMessagesToUser=function(toUserId,messages){var request={methodname:"core_message_send_instant_messages",args:{messages:messages.map((function(message){return{touserid:toUserId,text:message}}))}};return Ajax.call([request])[0].then((function(results){var errors=results.reduce((function(carry,result){return result.errormessage&&carry.push(result.errormessage),carry}),[]);if(errors.length)throw new Error(errors.join("\n"));return results})).then((function(results){return results.map((function(result){return{id:result.msgid,text:result.text,timecreated:result.timecreated,useridfrom:result.useridfrom,conversationid:result.conversationid,candeletemessagesforallusers:result.candeletemessagesforallusers}}))}))},sendMessagesToConversation=function(conversationId,messages){var request={methodname:"core_message_send_messages_to_conversation",args:{conversationid:conversationId,messages:messages.map((function(message){return{text:message}}))}};return Ajax.call([request])[0]};return{countUnreadConversations:function(args){var request={methodname:"core_message_get_unread_conversations_count",args:args},promise=Ajax.call([request])[0];return promise.fail(Notification.exception),promise},getContacts:function(userId,limit,offset){var args={userid:userId};void 0!==limit&&(args.limitnum=limit),void 0!==offset&&(args.limitfrom=offset);var request={methodname:"core_message_get_user_contacts",args:args};return Ajax.call([request])[0]},blockUser:function(userId,blockedUserId){var requests=[{methodname:"core_message_block_user",args:{userid:userId,blockeduserid:blockedUserId}},{methodname:"core_message_get_member_info",args:{referenceuserid:userId,userids:[blockedUserId],includecontactrequests:!0,includeprivacyinfo:!0}}];return $.when.apply(null,Ajax.call(requests)).then((function(reponse1,profiles){return profiles.length?profiles[0]:{}}))},unblockUser:function(userId,unblockedUserId){var requests=[{methodname:"core_message_unblock_user",args:{userid:userId,unblockeduserid:unblockedUserId}},{methodname:"core_message_get_member_info",args:{referenceuserid:userId,userids:[unblockedUserId],includecontactrequests:!0,includeprivacyinfo:!0}}];return $.when.apply(null,Ajax.call(requests)).then((function(reponse1,profiles){return profiles.length?profiles[0]:{}}))},createContactRequest:function(userId,requestUserIds){var request={methodname:"core_message_create_contact_request",args:{userid:userId,requesteduserid:requestUserIds}};return Ajax.call([request])[0]},deleteContacts:function(userId,contactUserIds){var requests=[{methodname:"core_message_delete_contacts",args:{userid:userId,userids:contactUserIds}},{methodname:"core_message_get_member_info",args:{referenceuserid:userId,userids:contactUserIds,includecontactrequests:!0,includeprivacyinfo:!0}}];return $.when.apply(null,Ajax.call(requests)).then((function(response1,profiles){return profiles}))},getMessages:function(currentUserId,conversationId,limit,offset,newestFirst,timeFrom){var args={currentuserid:currentUserId,convid:conversationId,newest:!!newestFirst};void 0!==limit&&(args.limitnum=limit),void 0!==offset&&(args.limitfrom=offset),void 0!==timeFrom&&(args.timefrom=timeFrom);var request={methodname:"core_message_get_conversation_messages",args:args};return Ajax.call([request])[0]},searchUsers:function(userId,searchString,limit,offset){var args={userid:userId,search:searchString};void 0!==limit&&(args.limitnum=limit),void 0!==offset&&(args.limitfrom=offset);var request={methodname:"core_message_message_search_users",args:args};return Ajax.call([request])[0]},searchMessages:function(userId,searchString,limit,offset){var args={userid:userId,search:searchString};void 0!==limit&&(args.limitnum=limit),void 0!==offset&&(args.limitfrom=offset);var request={methodname:"core_message_data_for_messagearea_search_messages",args:args};return Ajax.call([request])[0]},sendMessagesToUser:sendMessagesToUser,sendMessageToUser:function(toUserId,text){return sendMessagesToUser(toUserId,[text]).then((function(results){return results[0]}))},sendMessagesToConversation:sendMessagesToConversation,sendMessageToConversation:function(conversationId,text){return sendMessagesToConversation(conversationId,[text]).then((function(result){return result[0]}))},savePreferences:function(userId,preferences){var request={methodname:"core_user_update_user_preferences",args:{userid:userId,preferences:preferences}};return Ajax.call([request])[0]},getPreferences:function(userId){var request={methodname:"core_user_get_user_preferences",args:{userid:userId}};return Ajax.call([request])[0]},deleteMessages:function(userId,messageIds){return $.when.apply(null,Ajax.call(messageIds.map((function(messageId){return{methodname:"core_message_delete_message",args:{messageid:messageId,userid:userId}}}))))},deleteMessagesForAllUsers:function(userId,messageIds){return $.when.apply(null,Ajax.call(messageIds.map((function(messageId){return{methodname:"core_message_delete_message_for_all_users",args:{messageid:messageId,userid:userId}}}))))},deleteConversation:function(userId,conversationId){var request={methodname:"core_message_delete_conversations_by_id",args:{userid:userId,conversationids:[conversationId]}};return Ajax.call([request])[0]},getContactRequests:function(userId){var request={methodname:"core_message_get_contact_requests",args:{userid:userId}};return Ajax.call([request])[0]},acceptContactRequest:function(sendingUserId,recipientUserId){var requests=[{methodname:"core_message_confirm_contact_request",args:{userid:sendingUserId,requesteduserid:recipientUserId}},{methodname:"core_message_get_member_info",args:{referenceuserid:recipientUserId,userids:[sendingUserId],includecontactrequests:!0,includeprivacyinfo:!0}}];return $.when.apply(null,Ajax.call(requests)).then((function(reponse1,profiles){return profiles.length?profiles[0]:{}}))},declineContactRequest:function(sendingUserId,recipientUserId){var requests=[{methodname:"core_message_decline_contact_request",args:{userid:sendingUserId,requesteduserid:recipientUserId}},{methodname:"core_message_get_member_info",args:{referenceuserid:recipientUserId,userids:[sendingUserId],includecontactrequests:!0,includeprivacyinfo:!0}}];return $.when.apply(null,Ajax.call(requests)).then((function(reponse1,profiles){return profiles.length?profiles[0]:{}}))},getConversation:function(loggedInUserId,conversationId,includeContactRequests,includePrivacyInfo,memberLimit,memberOffset,messageLimit,messageOffset,newestMessagesFirst){var args={userid:loggedInUserId,conversationid:conversationId};null!=includeContactRequests&&(args.includecontactrequests=includeContactRequests),null!=includePrivacyInfo&&(args.includeprivacyinfo=includePrivacyInfo),null!=memberLimit&&(args.memberlimit=memberLimit),null!=memberOffset&&(args.memberoffset=memberOffset),null!=messageLimit&&(args.messagelimit=messageLimit),null!=messageOffset&&(args.messageoffset=messageOffset),null!=newestMessagesFirst&&(args.newestmessagesfirst=newestMessagesFirst);var request={methodname:"core_message_get_conversation",args:args};return Ajax.call([request])[0]},getConversationBetweenUsers:function(loggedInUserId,otherUserId,includeContactRequests,includePrivacyInfo,memberLimit,memberOffset,messageLimit,messageOffset,newestMessagesFirst){var args={userid:loggedInUserId,otheruserid:otherUserId};null!=includeContactRequests&&(args.includecontactrequests=includeContactRequests),null!=includePrivacyInfo&&(args.includeprivacyinfo=includePrivacyInfo),null!=memberLimit&&(args.memberlimit=memberLimit),null!=memberOffset&&(args.memberoffset=memberOffset),null!=messageLimit&&(args.messagelimit=messageLimit),null!=messageOffset&&(args.messageoffset=messageOffset),null!=newestMessagesFirst&&(args.newestmessagesfirst=newestMessagesFirst);var request={methodname:"core_message_get_conversation_between_users",args:args};return Ajax.call([request])[0]},getSelfConversation:function(loggedInUserId,messageLimit,messageOffset,newestMessagesFirst){var args={userid:loggedInUserId};null!=messageLimit&&(args.messagelimit=messageLimit),null!=messageOffset&&(args.messageoffset=messageOffset),null!=newestMessagesFirst&&(args.newestmessagesfirst=newestMessagesFirst);var request={methodname:"core_message_get_self_conversation",args:args};return Ajax.call([request])[0]},getConversations:function(userId,type,limit,offset,favourites,mergeself){var args={userid:userId,type:type};null!=limit&&(args.limitnum=limit),null!=offset&&(args.limitfrom=offset),null!=favourites&&(args.favourites=favourites),null!=mergeself&&(args.mergeself=mergeself);var request={methodname:"core_message_get_conversations",args:args};return Ajax.call([request])[0].then((function(result){return result.conversations.length&&(result.conversations=result.conversations.map((function(conversation){if(conversation.type==CONVERSATION_TYPES.PRIVATE||conversation.type==CONVERSATION_TYPES.SELF){var otherUser=conversation.members.length?conversation.members[0]:null;otherUser&&(conversation.name=conversation.name?conversation.name:otherUser.fullname,conversation.imageurl=conversation.imageurl?conversation.imageurl:otherUser.profileimageurl)}return conversation}))),result}))},getConversationMembers:function(conversationId,loggedInUserId,limit,offset,includeContactRequests){var args={userid:loggedInUserId,conversationid:conversationId};null!=limit&&(args.limitnum=limit),null!=offset&&(args.limitfrom=offset),null!=includeContactRequests&&(args.includecontactrequests=includeContactRequests);var request={methodname:"core_message_get_conversation_members",args:args};return Ajax.call([request])[0]},setFavouriteConversations:function(userId,conversationIds){var request={methodname:"core_message_set_favourite_conversations",args:{userid:userId,conversations:conversationIds}};return Ajax.call([request])[0]},setMutedConversations:function(userId,conversationIds){var request={methodname:"core_message_mute_conversations",args:{userid:userId,conversationids:conversationIds}};return Ajax.call([request])[0]},unsetFavouriteConversations:function(userId,conversationIds){var request={methodname:"core_message_unset_favourite_conversations",args:{userid:userId,conversations:conversationIds}};return Ajax.call([request])[0]},unsetMutedConversations:function(userId,conversationIds){var request={methodname:"core_message_unmute_conversations",args:{userid:userId,conversationids:conversationIds}};return Ajax.call([request])[0]},getMemberInfo:function(referenceUserId,userIds,includeContactRequests,includePrivacyInfo){var args={referenceuserid:referenceUserId,userids:userIds};void 0!==includeContactRequests&&(args.includecontactrequests=includeContactRequests),void 0!==includePrivacyInfo&&(args.includeprivacyinfo=includePrivacyInfo);var request={methodname:"core_message_get_member_info",args:args};return Ajax.call([request])[0]},markAllConversationMessagesAsRead:function(userId,conversationId){var request={methodname:"core_message_mark_all_conversation_messages_as_read",args:{userid:userId,conversationid:conversationId}};return Ajax.call([request])[0]},getUserMessagePreferences:function(userId){var request={methodname:"core_message_get_user_message_preferences",args:{userid:userId}};return Ajax.call([request])[0]},getTotalConversationCounts:function(userId){var request={methodname:"core_message_get_conversation_counts",args:{userid:userId}};return Ajax.call([request])[0]},getUnreadConversationCounts:function(userId){var request={methodname:"core_message_get_unread_conversation_counts",args:{userid:userId}};return Ajax.call([request])[0]},getAllConversationCounts:function(userId){var requests=[{methodname:"core_message_get_conversation_counts",args:{userid:userId}},{methodname:"core_message_get_unread_conversation_counts",args:{userid:userId}}];return $.when.apply(null,Ajax.call(requests)).then((function(total,unread){return{total:total,unread:unread}}))}}}));

//# sourceMappingURL=message_repository.min.js.map