<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'fr', branch 'MOODLE_31_STABLE'
 *
 * @package   bigbluebuttonbn
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bbbduetimeoverstartingtime'] = 'La date de fin doit être supérieure à la date de début.';
$string['bbbdurationwarning'] = 'La durée maximale de cette session est de %duration% minutes.';
$string['bbbrecordwarning'] = 'Cette session peut être enregistrée.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Ajouter une nouvelle conférence';
$string['bigbluebuttonbn:join'] = 'Joindre une conférence';
$string['bigbluebuttonbn:managerecordings'] = 'Gérer les enregistrements';
$string['bigbluebuttonbn:moderate'] = 'Modérer une conférence';
$string['config_extended_capabilities'] = 'Paramétrages pour capacités étendues';
$string['config_extended_capabilities_description'] = 'Configuration pour des capacités étendues lorsque le serveur BigBlueButton le permet.';
$string['config_extended_feature_recordingready_enabled'] = 'Notifications lorsque la possibilité d\'enregistrement est activée';
$string['config_extended_feature_recordingready_enabled_description'] = 'Notifications lorsque la fonctionnalité de possibilité d\'enregistrement est activée.';
$string['config_extended_feature_uidelegation_enabled'] = 'La délégation d\'interface utilisateur est activée';
$string['config_extended_feature_uidelegation_enabled_description'] = 'Ces paramètres activent ou désactivent la délégation de l\'interface utilisateur au serveur BigBlueButton.';
$string['config_feature_preuploadpresentation'] = 'Configuration pour la fonctionnalité « Pré-dépôt de présentation »';
$string['config_feature_preuploadpresentation_description'] = 'Ces paramètres activent ou désactivent les options de l\'interface utilisateur et définissent également les valeurs par défaut de ces options. Cette fonctionnalité nécessite obligatoirement que BigBlueButton ait accès au serveur Moodle';
$string['config_feature_preuploadpresentation_enabled'] = 'Pré-dépôt de présentation activé';
$string['config_feature_preuploadpresentation_enabled_description'] = 'La fonction de pré-dépôt de présentation est activée dans l\'interface utilisateur lorsque la salle ou la conférence est ajoutée ou mise à jour.';
$string['config_feature_recording'] = 'Configuration pour la fonction « Enregistrement »';
$string['config_feature_recording_default'] = 'Fonction d\'enregistrement activé par défaut';
$string['config_feature_recording_default_description'] = 'Si l\'option est activée, les sessions créées dans BigBlueButton seront enregistrables.';
$string['config_feature_recording_description'] = 'Ces paramètres sont des options spécifiques';
$string['config_feature_recording_editable'] = 'La fonction d\'enregistrement peut être modifiée';
$string['config_feature_recording_editable_description'] = 'Si l\'option est cochée, l\'interface comprend une option pour activer et désactiver la fonction d\'enregistrement.';
$string['config_feature_recording_icons_enabled'] = 'Icône pour la gestion des enregistrements';
$string['config_feature_recording_icons_enabled_description'] = 'Lorsque c\'est permis, le panneau de gestion d\'enregistrements affiche des icônes pour les actions publier / dépublier et supprimer.';
$string['config_feature_recordingtagging'] = 'Configuration pour la fonction « mot-clé des enregistrements »';
$string['config_feature_recordingtagging_default'] = 'Mot-clé d\'enregistrement activé par défaut';
$string['config_feature_recordingtagging_default_description'] = 'La fonction « mot-clé d\'enregistrement » est activée par défaut quand une nouvelle salle ou conférence est ajoutée. <br> Lorsque cette fonction est activée, une page intermédiaire qui permet de saisir une description et des mots-clés pour la session BigBlueButton est montrée au premier modérateur connecté. La description et les mots-clés sont ensuite utilisés pour identifier l\'enregistrement dans la liste.';
$string['config_feature_recordingtagging_description'] = 'Ces paramètres sont spécifiques à certaines fonctionnalités';
$string['config_feature_recordingtagging_editable'] = 'La fonction mot-clé d\'enregistrement peut être modifiée';
$string['config_feature_recordingtagging_editable_description'] = 'Le choix mot-clé d\'enregistrement par défaut peut être modifié lorsque la salle ou la conférence est ajoutée ou mise à jour.';
$string['config_feature_sendnotifications'] = 'Configuration pour la fonction « Envoyer des notifications »';
$string['config_feature_sendnotifications_description'] = 'Ces paramètres activent ou désactivent les options de l\'interface utilisateur et définissent également les valeurs par défaut pour ces options.';
$string['config_feature_sendnotifications_enabled'] = 'L\'envoi de notifications est activé';
$string['config_feature_sendnotifications_enabled_description'] = 'La fonction d\'envoi de notifications est activée dans l\'interface utilisateur lorsque la salle ou la conférence est ajoutée ou mise à jour.';
$string['config_feature_userlimit'] = 'Options pour paramétrages « Limite d\'utilisateur »';
$string['config_feature_userlimit_default'] = 'Limite d\'utilisateur activée par défaut';
$string['config_feature_userlimit_default_description'] = 'Le nombre d\'utilisateurs autorisés dans une session par défaut, quand une nouvelle salle ou conférence est ajoutée. Si le nombre est fixé à 0, aucune limite n\'est établie';
$string['config_feature_userlimit_description'] = 'Ces paramètres activent ou désactivent les options de l\'interface utilisateur et définissent également les valeurs par défaut pour ces options.';
$string['config_feature_userlimit_editable'] = 'Les options de limite d\'utilisateur peuvent être modifiées';
$string['config_feature_userlimit_editable_description'] = 'La valeur limite d\'utilisateurs par défaut peut être modifiée lorsque la salle ou la conférence est ajoutée ou mise à jour.';
$string['config_feature_voicebridge'] = 'Configuration pour la fonction « pont vocal »';
$string['config_feature_voicebridge_description'] = 'Ces paramètres activent ou désactivent les options de l\'interface utilisateur et définissent également les valeurs par défaut pour ces options.';
$string['config_feature_voicebridge_editable'] = 'Les options du pont vocal peuvent être modifiées';
$string['config_feature_voicebridge_editable_description'] = 'Le numéro du pont vocal de la conférence peut être affecté en permanence à une salle. Quand il est attribué, le numéro ne peut pas être utilisé par une autre salle ou conférence.';
$string['config_feature_waitformoderator'] = 'Configuration pour la fonction « Attendre le modérateur »';
$string['config_feature_waitformoderator_cache_ttl'] = 'Attente du modérateur en cache TTL (secondes)';
$string['config_feature_waitformoderator_cache_ttl_description'] = 'Pour supporter une lourde charge de clients, ce plugin permet l\'utilisation d\'un cache. Ce paramètre définit le temps que le cache sera conservé avant la prochaine demande envoyée au serveur BigBlueButton.';
$string['config_feature_waitformoderator_default'] = 'Attente du modérateur activée par défaut';
$string['config_feature_waitformoderator_default_description'] = 'La fonction d\'attente du modérateur est activée par défaut quand une nouvelle salle ou conférence est ajoutée.';
$string['config_feature_waitformoderator_description'] = 'Ces paramètres sont spécifiques à certaines fonctionnalités';
$string['config_feature_waitformoderator_editable'] = 'L\'option d\'attente du modérateur peut être modifiée';
$string['config_feature_waitformoderator_editable_description'] = 'La valeur de l\'attente du modérateur par défaut peut être modifiée lorsque la salle ou la conférence est ajoutée ou mise à jour.';
$string['config_feature_waitformoderator_ping_interval'] = 'Attente du modérateur (secondes)';
$string['config_feature_waitformoderator_ping_interval_description'] = 'Lorsque la fonction d\'attente du modérateur est activée, le client teste la connexion toutes les [nombre] secondes. Ce paramètre définit l\'intervalle pour les demandes faites au serveur Moodle';
$string['config_general'] = 'Configuration générale';
$string['config_general_description'] = 'Ces paramètres sont <b> toujours </b> utilisés';
$string['config_permission'] = 'Configuration de permission';
$string['config_permission_description'] = 'Ces paramètres définissent les permissions par défaut pour les salles ou conférences créées.';
$string['config_permission_moderator_default'] = 'Modérateur par défaut';
$string['config_permission_moderator_default_description'] = 'Cette règle est utilisée par défaut lorsqu\'une nouvelle salle ou conférence est ajoutée.';
$string['config_scheduled'] = 'Configuration de « sessions planifiées »';
$string['config_scheduled_description'] = 'Ces paramètres définissent certains comportements par défaut pour les sessions planifiées.';
$string['config_scheduled_duration_compensation'] = 'Temps complémentaire (minutes)';
$string['config_scheduled_duration_compensation_description'] = 'Minutes ajoutées à la clôture prévue lors du calcul de la durée.';
$string['config_scheduled_duration_enabled'] = 'Calcul de la durée activé';
$string['config_scheduled_duration_enabled_description'] = 'La durée d\'une séance planifiée est calculée sur la base des horaires d\'ouverture et de fermeture.';
$string['config_scheduled_pre_opening'] = 'Accessible avant l\'heure d\'ouverture (minutes)';
$string['config_scheduled_pre_opening_description'] = 'Le temps en minutes pour accéder à la session avant les horaires d\'ouverture de temps.';
$string['config_server_url'] = 'URL du serveur BigBlueButton';
$string['config_server_url_description'] = 'L\'URL de votre serveur BigBlueButton doit se terminer par /bigbluebutton/. (Cette URL par défaut est celle pour un serveur BigBlueButton fourni par Blindside Networks à utiliser pour les tests.)';
$string['config_shared_secret'] = 'Secret partagé BigBlueButton';
$string['config_shared_secret_description'] = 'Le sel de sécurité de votre serveur BigBlueButton. (Ce sel par défaut est pour un serveur BigBlueButton fourni par Blindside Networks que vous pouvez utiliser pour les tests.)';
$string['config_warning_curl_not_installed'] = 'Cette fonctionnalité nécessite que l\'extension CURL pour PHP soit installée et activée. Le paramétrage ne sera accessible que si cette condition est remplie';
$string['email_body_notification_meeting_by'] = 'par';
$string['email_body_notification_meeting_description'] = 'Description';
$string['email_body_notification_meeting_details'] = 'Détails';
$string['email_body_notification_meeting_end_date'] = 'Date de fin';
$string['email_body_notification_meeting_has_been'] = 'a été';
$string['email_body_notification_meeting_start_date'] = 'Date de début';
$string['email_body_notification_meeting_title'] = 'Titre';
$string['email_body_recording_ready_for'] = 'Enregistrement pour';
$string['email_body_recording_ready_is_ready'] = 'est prêt';
$string['email_footer_sent_by'] = 'Ce message de notification automatique a été envoyé par';
$string['email_footer_sent_from'] = 'du cours';
$string['email_title_notification_has_been'] = 'a été';
$string['event_activity_created'] = 'Activité BigBlueButton créée';
$string['event_activity_deleted'] = 'Activité BigBlueButton supprimée';
$string['event_activity_modified'] = 'Activité BigBlueButton modifiée';
$string['event_activity_viewed'] = 'Activité BigBlueButton consultée';
$string['event_activity_viewed_all'] = 'Gestion d\'activité BigBlueButton consultée';
$string['event_meeting_created'] = 'Conférence BigBlueButton créée';
$string['event_meeting_ended'] = 'Conférence BigBlueButton fermée (de force)';
$string['event_meeting_joined'] = 'Conférence BigBlueButton rejointe';
$string['event_meeting_left'] = 'Conférence BigBlueButton quittée';
$string['event_recording_deleted'] = 'Enregistrement supprimé';
$string['event_recording_published'] = 'Enregistrement publié';
$string['event_recording_unpublished'] = 'Enregistrement non publié';
$string['general_error_unable_connect'] = 'Impossible de se connecter. Vérifiez l\'URL du serveur BigBlueButton ET vérifiez que le serveur est actif.';
$string['index_confirm_end'] = 'Souhaitez-vous terminer la conférence ?';
$string['index_disabled'] = 'désactivé';
$string['index_enabled'] = 'activé';
$string['index_ending'] = 'Fermeture de la conférence... merci de patienter';
$string['index_error_checksum'] = 'Une erreur de vérification est apparue. Vérifiez votre sel de sécurité.';
$string['index_error_forciblyended'] = 'Impossible de joindre cette conférence, car elle a été manuellement fermée.';
$string['index_error_unable_display'] = 'Impossible d\'afficher les conférences. Vérifiez l\'URL du serveur BigBlueButton ET vérifiez que le serveur est actif.';
$string['index_heading'] = 'Salons BigBlueButton';
$string['index_heading_actions'] = 'Actions';
$string['index_heading_group'] = 'Groupe';
$string['index_heading_moderator'] = 'Modérateurs';
$string['index_heading_name'] = 'Salon';
$string['index_heading_recording'] = 'Enregistrement';
$string['index_heading_users'] = 'Utilisateurs';
$string['index_heading_viewer'] = 'Participants';
$string['mod_form_block_general'] = 'Paramètres généraux';
$string['mod_form_block_participants'] = 'Participants';
$string['mod_form_block_presentation'] = 'Contenu de présentation';
$string['mod_form_block_record'] = 'Paramètres d\'enregistrement';
$string['mod_form_block_schedule'] = 'Planification de session';
$string['mod_form_field_closingtime'] = 'Accès clos';
$string['mod_form_field_conference_name'] = 'Nom de la conférence';
$string['mod_form_field_duration'] = 'Durée';
$string['mod_form_field_duration_help'] = 'Définir la durée d\'une conférence établira la durée maximale d\'une conférence, avant que l\'enregistrement ne se termine.';
$string['mod_form_field_intro'] = 'Description';
$string['mod_form_field_intro_help'] = 'Une courte description pour la classe ou conférence.';
$string['mod_form_field_name'] = 'Nom de la conférence';
$string['mod_form_field_newwindow'] = 'Ouvrir dans une nouvelle fenêtre';
$string['mod_form_field_notification'] = 'Envoi de notification';
$string['mod_form_field_notification_created_help'] = 'Envoi de notification aux utilisateurs inscrits les informant que l\'activité a été créée';
$string['mod_form_field_notification_help'] = 'Envoi de notification aux utilisateurs inscrits les informant que l\'activité a été créée ou modifiée';
$string['mod_form_field_notification_modified_help'] = 'Envoi de notification aux utilisateurs inscrits les informant que l\'activité a été modifiée';
$string['mod_form_field_notification_msg_at'] = 'à';
$string['mod_form_field_notification_msg_created'] = 'créé';
$string['mod_form_field_notification_msg_modified'] = 'modifié';
$string['mod_form_field_openingtime'] = 'Accès ouvert';
$string['mod_form_field_participant_add'] = 'Ajouter participant';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Modérateur';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Participant';
$string['mod_form_field_participant_list'] = 'Liste des participants';
$string['mod_form_field_participant_list_action_add'] = 'Ajouter';
$string['mod_form_field_participant_list_action_remove'] = 'Supprimer';
$string['mod_form_field_participant_list_text_as'] = 'comme';
$string['mod_form_field_participant_list_type_all'] = 'Tous les utilisateurs inscrits';
$string['mod_form_field_participant_list_type_owner'] = 'Propriétaire';
$string['mod_form_field_participant_list_type_role'] = 'Rôle';
$string['mod_form_field_participant_list_type_user'] = 'Utilisateur';
$string['mod_form_field_predefinedprofile'] = 'Profil prédéfini';
$string['mod_form_field_predefinedprofile_help'] = 'Profil prédéfini';
$string['mod_form_field_record'] = 'La session peut être enregistrée';
$string['mod_form_field_recordingtagging'] = 'Activer l\'interface pour les mots-clés';
$string['mod_form_field_room_name'] = 'Nom de la conférence';
$string['mod_form_field_userlimit'] = 'Limite utilisateurs';
$string['mod_form_field_userlimit_help'] = 'Limite maximum d\'utilisateurs dans une conférence. Si la limite indiquée est 0, le nombre d\'utilisateurs sera illimité.';
$string['mod_form_field_voicebridge'] = 'Connexion orale [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Erreur de format. Vous devez saisir un nombre entre 1 et 9999.';
$string['mod_form_field_voicebridge_help'] = 'Numéro de conférence vocale que les participants entrent pour rejoindre la conférence vocale. Un nombre entre 1 et 9999 doit être saisi. Si la valeur est 0, un nombre aléatoire sera généré par BigBlueButton. Un nombre 7 sera placé avant les 4 chiffres saisis.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Valeur non unique. Ce numéro est utilisé par une autre salle ou une conférence.';
$string['mod_form_field_wait'] = 'Les étudiants doivent attendre qu\'un modérateur soit présent';
$string['mod_form_field_wait_help'] = 'Les participants doivent attendre qu\'un modérateur entre dans la session avant de pouvoir le faire';
$string['mod_form_field_welcome'] = 'Message d\'accueil';
$string['mod_form_field_welcome_default'] = '<br>Bienvenue sur <b>%%CONFNAME%%</b>!<br><br>Pour comprendre comment fonctionne BigBlueButton, veuillez voir nos <a href="event:http://www.bigbluebutton.org/content/videos"><u>tutoriels vidéos</u></a>.<br><br>Pour joindre la communication audio, cliquez sur l\'icône du casque (en haut à gauche). <b>Merci d\'utiliser un casque, pour éviter l\'écho.</b>';
$string['mod_form_field_welcome_help'] = 'Remplace le message de bienvenue par défaut défini pour le serveur BigBlueButton. Le message peut inclure des mots clés (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) qui seront substitués automatiquement, ainsi que des balises HTML comme <b>...</b> ou <i></i>';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = 'BigBlueButtonBN vous permet de créer des liens au sein de Moodle vers des salles de classe virtuelle en ligne en utilisant BigBlueButton, système open source de conférence web pour l\'enseignement à distance.

En utilisant BigBlueButtonBN, vous pouvez indiquer le titre, la description, l\'agenda (ce qui donne une plage de dates pour rejoindre la session), des groupes et des détails sur l\'enregistrement de la session en ligne.

Pour visionner les enregistrements plus tard, ajouter une ressource de type RecordingsBN à ce cours.';
$string['modulenameplural'] = 'BigBlueButtonBN';
$string['pluginadministration'] = 'Administration BigBlueButton';
$string['pluginname'] = 'BigBlueButtonBN';
$string['predefined_profile_classroom'] = 'Salle de classe';
$string['predefined_profile_collaborationroom'] = 'Salle de collaboration';
$string['predefined_profile_conferenceroom'] = 'Salle de conférence';
$string['predefined_profile_default'] = 'Défaut';
$string['predefined_profile_scheduledsession'] = 'Session programmée';
$string['serverhost'] = 'Nom du serveur';
$string['view_conference_action_end'] = 'Terminer la session';
$string['view_conference_action_join'] = 'Entrer dans la session';
$string['view_conference_action_lineup'] = 'Se mettre en liste d\'attente pour joindre la session';
$string['view_error_create'] = 'Le serveur BigBlueButton a renvoyé un message d\'erreur, la conférence n\'a pas pu être créée.';
$string['view_error_max_concurrent'] = 'Le nombre de sessions simultanées autorisé a été atteint.';
$string['view_error_no_group'] = 'Il n\'y a pas de groupe configuré actuellement. Veuillez créer des groupes avant d\'essayer de vous connecter à la conférence.';
$string['view_error_no_group_student'] = 'Vous n\'avez pas été inscrit dans un groupe. Veuillez contacter votre enseignant, ou l\'administrateur.';
$string['view_error_no_group_teacher'] = 'Il n\'y a pas de groupe configuré actuellement. Veuillez créer des groupes, ou contacter l\'administrateur.';
$string['view_error_unable_join'] = 'Impossible de rejoindre la conférence. Vérifiez l\'URL du serveur BigBlueButton ET vérifiez que le serveur est actif.';
$string['view_error_unable_join_student'] = 'Impossible de se connecter au serveur BigBlueButton. Veuillez contacter votre enseignant ou l\'administrateur.';
$string['view_error_unable_join_teacher'] = 'Impossible de se connecter au serveur BigBlueButton. Veuillez contacter l\'administrateur.';
$string['view_error_userlimit_reached'] = 'Le nombre d\'utilisateurs autorisés dans une conférence a été atteint.';
$string['view_groups_selection'] = 'Sélectionnez le groupe que vous souhaitez joindre, et confirmez l\'action';
$string['view_groups_selection_join'] = 'Joindre';
$string['view_groups_selection_warning'] = 'Il y a une salle de conférence pour chaque groupe. Si vous avez accès à plus d\'une, assurez-vous de choisir la bonne.';
$string['view_login_moderator'] = 'Connexion comme modérateur...';
$string['view_login_viewer'] = 'Connexion comme participant...';
$string['view_message_conference_has_ended'] = 'Cette conférence est terminée.';
$string['view_message_conference_in_progress'] = 'Cette conférence est en cours.';
$string['view_message_conference_not_started'] = 'Cette conférence n\'a pas encore démarré.';
$string['view_message_conference_room_ready'] = 'Cette salle de conférence est prête. Vous pouvez rejoindre la session maintenant.';
$string['view_message_conference_wait_for_moderator'] = 'En attente d\'un modérateur pour joindre.';
$string['view_message_finished'] = 'Cette activité est terminée.';
$string['view_message_has_joined'] = 'a rejoint';
$string['view_message_have_joined'] = 'ont rejoint';
$string['view_message_hour'] = 'heure';
$string['view_message_hours'] = 'heures';
$string['view_message_minute'] = 'minute';
$string['view_message_minutes'] = 'minutes';
$string['view_message_moderator'] = 'modérateur';
$string['view_message_moderators'] = 'modérateurs';
$string['view_message_norecordings'] = 'Il n\'y a pas d\'enregistrement pour cette conférence.';
$string['view_message_notavailableyet'] = 'Cette session n\'est pas encore disponible.';
$string['view_message_room_closed'] = 'Cette salle est fermée.';
$string['view_message_room_open'] = 'Cette salle est ouverte.';
$string['view_message_room_ready'] = 'Cette salle est prête.';
$string['view_message_session_has_user'] = 'Il y a';
$string['view_message_session_has_users'] = 'Il y a';
$string['view_message_session_no_users'] = 'Il n\'y a pas d\'utilisateur dans cette session';
$string['view_message_session_running_for'] = 'Cette session a duré';
$string['view_message_session_started_at'] = 'Cette session a démarré à';
$string['view_message_tab_close'] = 'Cet onglet (ou fenêtre) doit être fermé(e) manuellement';
$string['view_message_user'] = 'utilisateur';
$string['view_message_users'] = 'utilisateurs';
$string['view_message_viewer'] = 'spectateur';
$string['view_message_viewers'] = 'spectateurs';
$string['view_noguests'] = 'BigBlueButtonBN n\'est pas ouvert aux visiteurs anonymes';
$string['view_nojoin'] = 'Votre rôle ne vous permet pas de joindre cette session.';
$string['view_recording_actionbar'] = 'Barre d\'outils';
$string['view_recording_activity'] = 'Activité';
$string['view_recording_course'] = 'Cours';
$string['view_recording_date'] = 'Date';
$string['view_recording_delete_confirmation'] = 'Voulez vous vraiment supprimer cet enregistrement ?';
$string['view_recording_description'] = 'Description';
$string['view_recording_duration'] = 'Durée';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_presentation'] = 'présentation';
$string['view_recording_format_video'] = 'vidéo';
$string['view_recording_length'] = 'Durée';
$string['view_recording_list_actionbar'] = 'Outils';
$string['view_recording_list_actionbar_delete'] = 'Supprimer';
$string['view_recording_list_actionbar_deleting'] = 'Suppression';
$string['view_recording_list_actionbar_hide'] = 'Cacher';
$string['view_recording_list_actionbar_processing'] = 'Traitement';
$string['view_recording_list_actionbar_publish'] = 'Publier';
$string['view_recording_list_actionbar_publishing'] = 'Publication';
$string['view_recording_list_actionbar_show'] = 'Montrer';
$string['view_recording_list_actionbar_unpublish'] = 'Annuler la publication';
$string['view_recording_list_actionbar_unpublishing'] = 'Annulation de la publication';
$string['view_recording_list_activity'] = 'Activité';
$string['view_recording_list_course'] = 'Cours';
$string['view_recording_list_date'] = 'Date';
$string['view_recording_list_description'] = 'Description';
$string['view_recording_list_duration'] = 'Durée';
$string['view_recording_list_recording'] = 'Enregistrement';
$string['view_recording_modal_button'] = 'Appliquer';
$string['view_recording_modal_title'] = 'Définir les valeurs pour l\'enregistrement';
$string['view_recording_name'] = 'Nom';
$string['view_recording_recording'] = 'Enregistrement';
$string['view_recording_tags'] = 'Tags';
$string['view_section_title_presentation'] = 'Fichier de présentation';
$string['view_section_title_recordings'] = 'Enregistrements';
