define("tiny_accessibilitychecker/colorbase",["exports"],(function(_exports){function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}
/*
   * @package    tiny_accessibilitychecker
   * @copyright  2022, Stevani Andolo  <stevani@hotmail.com.au>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;return _exports.default=class{constructor(){_defineProperty(this,"REGEX_HEX",/^#?([\da-fA-F]{2})([\da-fA-F]{2})([\da-fA-F]{2})(\ufffe)?/),_defineProperty(this,"REGEX_HEX3",/^#?([\da-fA-F]{1})([\da-fA-F]{1})([\da-fA-F]{1})(\ufffe)?/),_defineProperty(this,"REGEX_RGB",/rgba?\(([\d]{1,3}), ?([\d]{1,3}), ?([\d]{1,3}),? ?([.\d]*)?\)/),_defineProperty(this,"TYPES",{HEX:"hex",RGB:"rgb",RGBA:"rgba"}),_defineProperty(this,"KEYWORDS",{black:"000",silver:"c0c0c0",gray:"808080",white:"fff",maroon:"800000",red:"f00",purple:"800080",fuchsia:"f0f",green:"008000",lime:"0f0",olive:"808000",yellow:"ff0",navy:"000080",blue:"00f",teal:"008080",aqua:"0ff"}),_defineProperty(this,"STR_HEX","#{*}{*}{*}"),_defineProperty(this,"STR_RGB","rgb({*}, {*}, {*})"),_defineProperty(this,"STR_RGBA","rgba({*}, {*}, {*}, {*})"),_defineProperty(this,"toHex",(str=>{var clr=this._convertTo(str,"hex"),isTransparent="transparent"===clr.toLowerCase();return"#"===clr.charAt(0)||isTransparent||(clr="#"+clr),isTransparent?clr.toLowerCase():clr.toUpperCase()})),_defineProperty(this,"toRGB",(str=>this._convertTo(str,"rgb").toLowerCase())),_defineProperty(this,"toRGBA",(str=>this._convertTo(str,"rgba").toLowerCase())),_defineProperty(this,"toArray",(str=>{var regex,arr,length,type=this.findType(str).toUpperCase();return"HEX"===type&&str.length<5&&(type="HEX3"),"A"===type.charAt(type.length-1)&&(type=type.slice(0,-1)),(regex=this._getRightValue("REGEX_"+type))&&(length=(arr=regex.exec(str)||[]).length)&&(arr.shift(),length--,"HEX3"===type&&(arr[0]+=arr[0],arr[1]+=arr[1],arr[2]+=arr[2]),arr[length-1]||(arr[length-1]=1)),arr})),_defineProperty(this,"fromArray",((arr,template)=>{if(arr=arr.concat(),void 0===template)return arr.join(", ");for(template=this._getRightValue("STR_"+template.toUpperCase()),3===arr.length&&4===template.match(/\{\*\}/g).length&&arr.push(1);template.indexOf("{*}")>=0&&arr.length>0;)template=template.replace("{*}",arr.shift());return template})),_defineProperty(this,"findType",(str=>{if(this.KEYWORDS[str])return"keyword";var key,index=str.indexOf("(");return index>0&&(key=str.substr(0,index)),key&&this.TYPES[key.toUpperCase()]?this.TYPES[key.toUpperCase()]:"hex"})),_defineProperty(this,"_getAlpha",(clr=>{var alpha,arr=this.toArray(clr);return arr.length>3&&(alpha=arr.pop()),+alpha||1})),_defineProperty(this,"_keywordToHex",(clr=>{var keyword=this.KEYWORDS[clr];return keyword||keyword})),_defineProperty(this,"_convertTo",((clr,to)=>{if("transparent"===clr)return clr;var needsAlpha,alpha,method,ucTo,from=this.findType(clr),originalTo=to;return"keyword"===from&&(clr=this._keywordToHex(clr),from="hex"),"hex"===from&&clr.length<5&&("#"===clr.charAt(0)&&(clr=clr.substr(1)),clr="#"+clr.charAt(0)+clr.charAt(0)+clr.charAt(1)+clr.charAt(1)+clr.charAt(2)+clr.charAt(2)),from===to||("a"===from.charAt(from.length-1)&&(from=from.slice(0,-1)),(needsAlpha="a"===to.charAt(to.length-1))&&(to=to.slice(0,-1),alpha=this._getAlpha(clr)),ucTo=to.charAt(0).toUpperCase()+to.substr(1).toLowerCase(),(method=window["_"+from+"To"+ucTo])||"rgb"!==from&&"rgb"!==to&&(clr=window["_"+from+"ToRgb"](clr),from="rgb",method=window["_"+from+"To"+ucTo]),method&&(clr=method(clr,needsAlpha)),needsAlpha&&(Array.isArray(clr)||(clr=this.toArray(clr)),clr.push(alpha),clr=this.fromArray(clr,originalTo.toUpperCase()))),clr})),_defineProperty(this,"_hexToRgb",((str,array)=>{var r,g,b;return"#"===str.charAt(0)&&(str=str.substr(1)),r=(str=parseInt(str,16))>>16,g=str>>8&255,b=255&str,array?[r,g,b]:"rgb("+r+", "+g+", "+b+")"})),_defineProperty(this,"_rgbToHex",(str=>{var rgb=this.toArray(str),hex=rgb[2]|rgb[1]<<8|rgb[0]<<16;for(hex=(+hex).toString(16);hex.length<6;)hex="0"+hex;return"#"+hex})),_defineProperty(this,"_getRightValue",(string=>{let regex=null;return"REGEX_RGB"===string?regex=this.REGEX_RGB:"REGEX_HEX"===string?regex=this.REGEX_HEX:"REGEX_HEX3"===string?regex=this.REGEX_HEX3:"STR_HEX"===string?regex=this.STR_HEX:"STR_RGB"===string?regex=this.STR_RGB:"STR_RGBA"===string&&(regex=this.STR_RGBA),regex}))}},_exports.default}));

//# sourceMappingURL=colorbase.min.js.map