/*
 * Decompiled with CFR 0.152.
 */
package gong.xml;

import gong.xml.InvalidTagException;
import gong.xml.TagNotFoundException;
import gong.xml.XmlConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class DomObject
implements Cloneable {
    private static DocumentBuilderFactory builderFactory = null;
    private static TransformerFactory transformerFactory = null;
    protected Element anchor;

    public DomObject() throws ParserConfigurationException {
        Document document = this.createDocument();
        this.anchor = document.createElement(this.getTag().toString());
        document.appendChild(this.anchor);
    }

    public DomObject(Element element) throws InvalidTagException {
        this.anchor = element;
        this.validateElement();
    }

    public DomObject(String string) throws ParserConfigurationException, InvalidTagException, SAXException, IOException {
        this.parse(string);
    }

    public DomObject(File file) throws ParserConfigurationException, InvalidTagException, SAXException, IOException {
        this.parse(file);
    }

    public Document getDocument() {
        return this.anchor.getOwnerDocument();
    }

    public Element getElement() {
        return this.anchor;
    }

    public boolean isDocumentRoot() {
        return this.anchor.getParentNode().getNodeType() == 9;
    }

    public Element getDocumentRoot() {
        return this.getDocument().getDocumentElement();
    }

    protected void validateElement() throws InvalidTagException {
        XmlConstants.Tag tag = this.getTag();
        if (tag == null) {
            throw new InvalidTagException("Tag is not specified.");
        }
        if (this.anchor == null) {
            throw new InvalidTagException("Cannot find element: " + tag + ".");
        }
        if (!tag.equals(this.anchor.getLocalName())) {
            throw new InvalidTagException("Cannot find element: " + tag + ".");
        }
    }

    protected abstract XmlConstants.Tag getTag();

    protected abstract DomObject createObject(Element var1) throws InvalidTagException;

    public void parse(String string) throws ParserConfigurationException, SAXException, IOException, InvalidTagException {
        StringReader stringReader = new StringReader(string);
        this.parse(new InputSource(stringReader));
    }

    public void parse(File file) throws ParserConfigurationException, SAXException, IOException, FileNotFoundException, InvalidTagException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        this.parse(new InputSource(bufferedInputStream));
    }

    private static void setSystemProperty(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Class<?> clazz = Class.forName(stringArray[i]);
                System.setProperty(string, stringArray[i]);
                return;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DomObject.setSystemProperty("javax.xml.parsers.DocumentBuilderFactory", new String[]{"org.apache.crimson.jaxp.DocumentBuilderFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl"});
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory;
    }

    public static TransformerFactory createTransformerFactory() {
        DomObject.setSystemProperty("javax.xml.transform.TransformerFactory", new String[]{"org.apache.xalan.processor.TransformerFactoryImpl", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl"});
        DomObject.setSystemProperty("org.apache.xml.dtm.DTMManager", new String[]{"org.apache.xml.dtm.ref.DTMManagerDefault"});
        DomObject.setSystemProperty("com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager", new String[]{"com.sun.org.apache.xml.internal.dtm.ref.DTMManagerDefault"});
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        return transformerFactory;
    }

    private void parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException, InvalidTagException {
        if (builderFactory == null) {
            builderFactory = DomObject.createDocumentBuilderFactory();
        }
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        DomObject.normalize(document);
        this.anchor = document.getDocumentElement();
        this.validateElement();
        if (this.anchor.hasAttribute("xmlns")) {
            this.anchor.removeAttribute("xmlns");
        }
    }

    public String serialize() throws TransformerConfigurationException, TransformerException, IOException {
        return this.serialize(this.anchor, true, "utf-8");
    }

    public String serialize(Node node) throws TransformerConfigurationException, TransformerException, IOException {
        return this.serialize(node, true, "utf-8");
    }

    public String serialize(Node node, boolean bl, String string) throws TransformerConfigurationException, TransformerException, IOException {
        StringWriter stringWriter = new StringWriter();
        if (transformerFactory == null) {
            transformerFactory = DomObject.createTransformerFactory();
        }
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(stringWriter);
        if (bl) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        transformer.setOutputProperty("encoding", string);
        transformer.transform(dOMSource, streamResult);
        stringWriter.close();
        return stringWriter.toString();
    }

    public void setId(Long l) {
        String string = l == null ? null : String.valueOf(l);
        DomObject.setTextAttribute(this.anchor, XmlConstants.Attribute.ID, string);
    }

    public Long getId() {
        String string = DomObject.getTextAttribute(this.anchor, XmlConstants.Attribute.ID);
        if (string == null) {
            return null;
        }
        try {
            return Long.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static void normalize(Node node) {
        Object object;
        Node node2;
        int n;
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength() - 1; ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() != 3) continue;
            ++n;
            while (n < nodeList.getLength() && (object = nodeList.item(n)).getNodeType() == 3) {
                String string = node2.getNodeValue() + object.getNodeValue();
                node2.setNodeValue(string);
                node.removeChild((Node)object);
                ++n;
            }
        }
        nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (node2.getNodeType() == 3) {
                object = node2.getNodeValue();
                if (((String)object).trim().length() != 0) continue;
                node.removeChild(node2);
                --n;
                continue;
            }
            DomObject.normalize(node2);
        }
    }

    protected Document createDocument() throws ParserConfigurationException {
        if (builderFactory == null) {
            builderFactory = DomObject.createDocumentBuilderFactory();
        }
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    public static Element getElementById(Node node, String string) {
        Node node2;
        Object object;
        if (node.getNodeType() == 1 && ((String)(object = (node2 = (Element)node).getAttribute(XmlConstants.Attribute.ID.toString()))).equals(string)) {
            return node2;
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || (object = DomObject.getElementById(node2, string)) == null) continue;
            return object;
        }
        return null;
    }

    public static NodeList getElementsByTagName(Element element, String string, boolean bl) {
        if (bl) {
            return element.getElementsByTagName(string);
        }
        NodeListImpl nodeListImpl = new NodeListImpl();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string.equals(node.getLocalName())) continue;
            nodeListImpl.add(node);
        }
        return nodeListImpl;
    }

    public static NodeList getElementsByTagNameNS(Element element, String string, String string2, boolean bl) {
        if (bl) {
            return element.getElementsByTagNameNS(string, string2);
        }
        NodeListImpl nodeListImpl = new NodeListImpl();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string.equals(node.getNamespaceURI()) || !string2.equals(node.getLocalName())) continue;
            nodeListImpl.add(node);
        }
        return nodeListImpl;
    }

    public static Node getNodeByNS(Node node, String string) {
        if (string.equals(node.getNamespaceURI())) {
            return node;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = DomObject.getNodeByNS(node2, string);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    public static void setText(Element element, String string, short s) {
        if (s != 4 && s != 3) {
            throw new IllegalArgumentException("Only cdata section or text node is allowed.");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != s) continue;
            if (string != null) {
                node.setNodeValue(string);
                return;
            }
            element.removeChild(node);
            --i;
        }
        if (string != null) {
            if (s == 3) {
                element.appendChild(element.getOwnerDocument().createTextNode(string));
            } else {
                element.appendChild(element.getOwnerDocument().createCDATASection(string));
            }
        }
    }

    public static String getText(Element element, short s) {
        if (s != 4 && s != 3) {
            throw new IllegalArgumentException("Only cdata section or text node is allowed.");
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != s) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public static void setTextToElement(Element element, XmlConstants.Tag tag, String string, short s) {
        Element element2;
        if (s != 4 && s != 3) {
            throw new IllegalArgumentException("Only cdata section or text node is allowed.");
        }
        NodeList nodeList = DomObject.getElementsByTagName(element, tag.toString(), false);
        if (nodeList.getLength() == 0) {
            element2 = element.getOwnerDocument().createElement(tag.toString());
            element.appendChild(element2);
        } else {
            element2 = (Element)nodeList.item(0);
        }
        DomObject.setText(element2, string, s);
    }

    public static String getTextFromElement(Element element, XmlConstants.Tag tag, short s) throws TagNotFoundException {
        NodeList nodeList = DomObject.getElementsByTagName(element, tag.toString(), false);
        if (nodeList.getLength() == 0) {
            throw new TagNotFoundException("Cannot find the tag: " + tag + ".");
        }
        return DomObject.getText((Element)nodeList.item(0), s);
    }

    public static void setTextAttribute(Element element, XmlConstants.Attribute attribute, String string) {
        if (string == null) {
            element.removeAttribute(attribute.toString());
        } else {
            element.setAttribute(attribute.toString(), string);
        }
    }

    public static String getTextAttribute(Element element, XmlConstants.Attribute attribute) {
        if (!element.hasAttribute(attribute.toString())) {
            return null;
        }
        return element.getAttribute(attribute.toString());
    }

    public void addStyleSheet(String string) {
        Document document = this.getDocument();
        Element element = document.getDocumentElement();
        ProcessingInstruction processingInstruction = document.createProcessingInstruction("xml-stylesheet", "href=\"" + string + "\" type=\"text/xsl\"");
        element.getParentNode().insertBefore(processingInstruction, element);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Document document = this.createDocument();
            document.appendChild(document.importNode(this.anchor, true));
            return this.createObject(document.getDocumentElement());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CloneNotSupportedException("ParserConfigurationException: " + parserConfigurationException.getMessage());
        }
        catch (InvalidTagException invalidTagException) {
            throw new CloneNotSupportedException("InvalidTagException: " + invalidTagException.getMessage());
        }
    }

    protected static class NodeListImpl
    extends Vector
    implements NodeList {
        protected NodeListImpl() {
        }

        public Node item(int n) {
            return (Node)this.get(n);
        }

        public int getLength() {
            return this.size();
        }
    }
}

