/*
 * Decompiled with CFR 0.152.
 */
package gong.ui.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class NanoButtonUI
extends BasicButtonUI {
    public static final String PLAY = "play";
    public static final String RECORD = "record";
    public static final String PAUSE = "pause";
    public static final String STOP = "stop";
    public static final String SAVE = "save";
    protected String iconType;

    public NanoButtonUI(String string) {
        this.iconType = string;
    }

    public void setIconType(String string) {
        this.iconType = string;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(null);
        jComponent.setOpaque(false);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle rectangle = jComponent.getBounds();
        if (buttonModel.isEnabled()) {
            if (buttonModel.isPressed()) {
                graphics2D.setColor(Color.BLACK);
                graphics2D.fillOval(0, 0, rectangle.width, rectangle.height);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillOval(2, 2, rectangle.width - 2, rectangle.height - 2);
                graphics2D.setColor(abstractButton.getBackground().darker());
                graphics2D.fillOval(1, 1, rectangle.width - 3, rectangle.height - 3);
                graphics2D.setPaint(new GradientPaint(1.0f, 1.0f, abstractButton.getBackground(), rectangle.width - 3, rectangle.height - 3, Color.WHITE));
                graphics2D.fillOval(2, 2, rectangle.width - 3, rectangle.height - 3);
            } else {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillOval(0, 0, rectangle.width, rectangle.height);
                graphics2D.setColor(Color.BLACK);
                graphics2D.fillOval(2, 2, rectangle.width - 2, rectangle.height - 2);
                graphics2D.setColor(abstractButton.getBackground().darker());
                graphics2D.fillOval(2, 2, rectangle.width - 3, rectangle.height - 3);
                graphics2D.setPaint(new GradientPaint(1.0f, 1.0f, Color.WHITE, rectangle.width - 3, rectangle.height - 3, abstractButton.getBackground()));
                graphics2D.fillOval(1, 1, rectangle.width - 3, rectangle.height - 3);
            }
        } else {
            graphics2D.setColor(abstractButton.getBackground().darker());
            graphics2D.fillOval(0, 0, rectangle.width, rectangle.height);
            graphics2D.setColor(abstractButton.getBackground());
            graphics2D.fillOval(1, 1, rectangle.width - 2, rectangle.height - 2);
        }
        if (buttonModel.isPressed()) {
            graphics2D.translate(1, 1);
        }
        this.paintIcon(graphics2D, jComponent, buttonModel);
        if (buttonModel.isPressed()) {
            graphics2D.translate(-1, -1);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void paintIcon(Graphics2D graphics2D, JComponent jComponent, ButtonModel buttonModel) {
        Rectangle rectangle = jComponent.getBounds();
        if (buttonModel.isEnabled()) {
            if (this.iconType.equals(RECORD)) {
                graphics2D.setColor(new Color(192, 0, 0));
            } else {
                graphics2D.setColor(new Color(64, 64, 64));
            }
        } else {
            graphics2D.setColor(new Color(128, 128, 128));
        }
        if (this.iconType.equals(PLAY)) {
            int n = rectangle.width / 2 + 1;
            int n2 = rectangle.height / 2 + 1;
            Polygon polygon = new Polygon();
            polygon.addPoint(n + 6, n2);
            polygon.addPoint(n - 5, n2 - 6);
            polygon.addPoint(n - 5, n2 + 5);
            graphics2D.fillPolygon(polygon);
        } else if (this.iconType.equals(RECORD)) {
            graphics2D.fillOval((rectangle.width - 11) / 2, (rectangle.height - 11) / 2, 11, 11);
        } else if (this.iconType.equals(PAUSE)) {
            graphics2D.fillRoundRect((rectangle.width - 11) / 2, (rectangle.height - 11) / 2, 5, 11, 5, 5);
            graphics2D.fillRoundRect((rectangle.width - 11) / 2 + 6, (rectangle.height - 11) / 2, 5, 11, 5, 5);
        } else if (this.iconType.equals(STOP)) {
            graphics2D.fillRoundRect((rectangle.width - 11) / 2, (rectangle.height - 11) / 2, 11, 11, 5, 5);
        } else if (this.iconType.equals(SAVE)) {
            graphics2D.fillRoundRect((rectangle.width - 11) / 2, (rectangle.height - 11) / 2, 11, 11, 5, 5);
            graphics2D.setColor(jComponent.getBackground());
            graphics2D.fillRect((rectangle.width - 11) / 2 + 3, (rectangle.height - 11) / 2 + 7, 5, 4);
        }
    }
}

