/*
 * Decompiled with CFR 0.152.
 */
package gong.audio.data;

import gong.audio.AudioDataException;
import gong.audio.data.BitOutputStream;
import gong.audio.data.BlockAudioData;
import gong.audio.data.FlvMetaDataWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;

public class FlvPCMData
extends BlockAudioData {
    public static final String FILE_EXTENSION = ".flv";
    protected static final int DEFAULT_SAMPLES_PER_BLOCK = 4096;

    public FlvPCMData() {
        this.samplesPerBlock = 4096;
    }

    public FlvPCMData(AudioFormat audioFormat) {
        super(audioFormat);
        this.samplesPerBlock = 4096;
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    protected BlockAudioData.Block createBlock() {
        return new FlvPCMBlock(this.samplesPerBlock);
    }

    public long getMemoryUsage() {
        return (long)this.blockData.size() * (long)this.samplesPerBlock * 2L;
    }

    protected void sendHeaderToStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(new String("FLV").getBytes());
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(4);
        dataOutputStream.writeInt(9);
        dataOutputStream.writeInt(0);
        FlvMetaDataWriter flvMetaDataWriter = new FlvMetaDataWriter();
        flvMetaDataWriter.put("duration", new Double((double)this.getDuration() / 1000.0));
        flvMetaDataWriter.put("audiodatarate", new Double(this.format.getFrameRate() * (float)this.format.getFrameSize()));
        flvMetaDataWriter.put("metadatacreator", "The Gong Project");
        flvMetaDataWriter.put("audiocodecid", new Integer(0));
        flvMetaDataWriter.put("filesize", new Double(13 + flvMetaDataWriter.size() + this.blockData.size() * (this.samplesPerBlock * 2 + 16)));
        flvMetaDataWriter.sendToStream(dataOutputStream);
        dataOutputStream.writeInt(flvMetaDataWriter.size());
    }

    protected void sendDataToStream(OutputStream outputStream) throws IOException, AudioDataException {
        BitOutputStream bitOutputStream = new BitOutputStream(outputStream);
        for (int i = 0; i < this.blockData.size(); ++i) {
            FlvPCMBlock flvPCMBlock = (FlvPCMBlock)this.blockData.get(i);
            bitOutputStream.write(8);
            int n = this.samplesPerBlock * 2 + 1;
            bitOutputStream.write(n, 24);
            int n2 = (int)((double)(i * this.samplesPerBlock) * 1000.0 / (double)this.format.getSampleRate());
            bitOutputStream.write(n2, 24);
            bitOutputStream.write(0, 8);
            bitOutputStream.write(0, 24);
            bitOutputStream.write(0, 4);
            switch ((int)this.format.getSampleRate()) {
                case 5512: {
                    bitOutputStream.write(0, 2);
                    break;
                }
                case 11025: {
                    bitOutputStream.write(1, 2);
                    break;
                }
                case 22050: {
                    bitOutputStream.write(2, 2);
                    break;
                }
                case 44100: {
                    bitOutputStream.write(3, 2);
                }
            }
            bitOutputStream.write(1, 1);
            bitOutputStream.write(0, 1);
            bitOutputStream.flush();
            flvPCMBlock.sendToStream(outputStream);
            if (i < this.blockData.size() - 1) {
                bitOutputStream.write(n + 11, 32);
            }
            if (this.listener == null) continue;
            this.listener.sent(this, this.getBlockTime(i));
        }
        bitOutputStream.flush();
    }

    public void sendToStream(OutputStream outputStream) throws IOException, AudioDataException {
        if (this.format.getSampleRate() != 5512.0f && this.format.getSampleRate() != 11025.0f && this.format.getSampleRate() != 22050.0f && this.format.getSampleRate() != 44100.0f) {
            throw new AudioDataException("Sampling rate is not supported by the FLV format.");
        }
        this.sendHeaderToStream(outputStream);
        this.sendDataToStream(outputStream);
    }

    public void receiveFromStream(InputStream inputStream, boolean bl) throws IOException, AudioDataException {
        throw new AudioDataException("The Flv PCM format is write only.");
    }

    public boolean isSupported(String string) {
        if (string.equals("sent-progress")) {
            return true;
        }
        if (string.equals("received-progress")) {
            return false;
        }
        return false;
    }

    protected class FlvPCMBlock
    extends BlockAudioData.Block {
        public FlvPCMBlock(int n) {
            super(n);
        }

        public synchronized int read() throws AudioDataException {
            throw new AudioDataException("The Flv PCM format is write only.");
        }

        public synchronized void write(int n) throws AudioDataException {
            if (this.eob()) {
                throw new AudioDataException("Invalid write request.");
            }
            if (this.data == null) {
                this.data = new byte[this.size * 2];
                Arrays.fill(this.data, (byte)0);
            }
            int n2 = this.position << 1;
            this.data[n2] = (byte)(n & 0xFF);
            this.data[n2 + 1] = (byte)(n >> 8 & 0xFF);
            ++this.position;
        }

        public synchronized void sendToStream(OutputStream outputStream) throws IOException, AudioDataException {
            if (this.data == null) {
                throw new AudioDataException("Invalid send request.");
            }
            outputStream.write(this.data);
        }
    }
}

