/*
 * Decompiled with CFR 0.152.
 */
package gong.audio.data;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    private OutputStream stream;
    private byte buffer;
    private int bptr;

    public BitOutputStream(OutputStream outputStream) {
        this.stream = outputStream;
        this.buffer = 0;
        this.bptr = 0;
    }

    public void write(int n, int n2) throws IOException {
        for (int i = n2 - 1; i >= 0; --i) {
            int n3 = 1 << 7 - this.bptr;
            this.buffer = (byte)(this.buffer | n3);
            if ((n & 1 << i) == 0) {
                this.buffer = (byte)(this.buffer ^ n3);
            }
            ++this.bptr;
            if (this.bptr != 8) continue;
            this.stream.write(this.buffer);
            this.buffer = 0;
            this.bptr = 0;
        }
    }

    public void write(int n) throws IOException {
        this.write(n, 8);
    }

    public void flush() throws IOException {
        if (this.bptr > 0) {
            this.stream.write(this.buffer);
            this.buffer = 0;
            this.bptr = 0;
        }
    }

    public void close() throws IOException {
        this.flush();
    }
}

