/*
 * Decompiled with CFR 0.152.
 */
package gong.audio;

import javax.sound.sampled.AudioFormat;

public class OlaBuffer {
    protected static final float CORRELATION_ACCEPTANCE = 0.9f;
    protected AudioFormat format;
    protected float rate;
    protected int bufferSize;
    protected int overlapSize;
    protected int[] buffer;
    protected int bufferPos;
    protected int[] outputBuffer;
    protected int outputPos;
    protected float[] window;
    protected int sampleShift;
    protected int searchStart;
    protected int searchEnd;

    public OlaBuffer(AudioFormat audioFormat, float f) {
        this.format = audioFormat;
        this.rate = f;
        this.init();
    }

    public void setRate(float f) {
        this.rate = f;
        this.drain();
        this.init();
    }

    public void init() {
        this.bufferSize = (int)(this.format.getSampleRate() / 20.0f);
        this.buffer = new int[this.bufferSize];
        this.bufferPos = 0;
        if ((double)this.rate == 1.0) {
            this.sampleShift = 0;
        } else {
            this.overlapSize = this.bufferSize / 2;
            this.window = new float[this.overlapSize];
            for (int i = 0; i < this.overlapSize; ++i) {
                this.window[i] = (float)i / (float)(this.overlapSize - 1);
            }
            if ((double)this.rate > 1.0) {
                this.sampleShift = (int)((double)(-this.bufferSize) * ((double)this.rate - 1.0));
                if (this.sampleShift < -(this.bufferSize - this.overlapSize)) {
                    this.sampleShift = -(this.bufferSize - this.overlapSize);
                }
                this.searchStart = this.sampleShift - this.overlapSize / 4;
                this.searchEnd = this.sampleShift + this.overlapSize / 4;
                if (this.searchStart < -this.overlapSize) {
                    this.searchStart = -this.overlapSize;
                }
                if (this.searchEnd > 0) {
                    this.searchEnd = this.sampleShift;
                }
            } else if ((double)this.rate < 1.0) {
                this.sampleShift = (int)((double)this.bufferSize * (1.0 - (double)this.rate));
                if (this.sampleShift > this.bufferSize - this.overlapSize) {
                    this.sampleShift = this.bufferSize - this.overlapSize;
                }
                this.searchStart = this.sampleShift - this.overlapSize / 4;
                this.searchEnd = this.sampleShift + this.overlapSize / 4;
                if (this.searchStart < 0) {
                    this.searchStart = this.sampleShift;
                }
                if (this.searchEnd > this.overlapSize) {
                    this.searchEnd = this.overlapSize;
                }
            }
        }
    }

    protected double findCorrelation(int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.buffer[n + i];
            int n5 = this.buffer[n2 + i];
            d += (double)(n4 * n5);
            d2 += (double)(n4 * n4);
            d3 += (double)(n5 * n5);
        }
        if (d < 0.0) {
            return 0.0;
        }
        double d4 = d2 * d3;
        if (d4 == 0.0) {
            return 0.0;
        }
        return d * d / d4;
    }

    protected int findStretchPosition() {
        int n = 0;
        double d = this.findCorrelation(0, this.sampleShift, this.overlapSize);
        if (d >= (double)0.9f) {
            return this.sampleShift;
        }
        for (int i = 1; i < this.overlapSize / 4; ++i) {
            double d2;
            if (this.sampleShift - i >= this.searchStart && (d2 = this.findCorrelation(0, this.sampleShift - i, this.overlapSize)) > d) {
                d = d2;
                n = -i;
                if (d >= (double)0.9f) break;
            }
            if (this.sampleShift + i > this.searchEnd || !((d2 = this.findCorrelation(0, this.sampleShift + i, this.overlapSize)) > d)) continue;
            d = d2;
            n = i;
            if (d >= (double)0.9f) break;
        }
        return this.sampleShift + n;
    }

    protected int findShrinkPosition() {
        int n = 0;
        int n2 = this.bufferSize - this.overlapSize;
        double d = this.findCorrelation(n2, n2 + this.sampleShift, this.overlapSize);
        if (d >= (double)0.9f) {
            return this.sampleShift;
        }
        for (int i = 1; i < this.overlapSize / 4; ++i) {
            double d2;
            if (this.sampleShift - i >= this.searchStart && (d2 = this.findCorrelation(n2, n2 + this.sampleShift - i, this.overlapSize)) > d) {
                d = d2;
                n = -i;
                if (d >= (double)0.9f) break;
            }
            if (this.sampleShift + i > this.searchEnd || !((d2 = this.findCorrelation(n2, n2 + this.sampleShift + i, this.overlapSize)) > d)) continue;
            d = d2;
            n = i;
            if (d >= (double)0.9f) break;
        }
        return this.sampleShift + n;
    }

    public int read() {
        if (!this.isAvailable()) {
            return 0;
        }
        return this.outputBuffer[this.outputPos++];
    }

    public void write(int n) {
        this.buffer[this.bufferPos++] = n;
        if (this.bufferPos == this.bufferSize) {
            if (this.sampleShift == 0) {
                this.outputBuffer = new int[this.bufferSize];
                System.arraycopy(this.buffer, 0, this.outputBuffer, 0, this.bufferSize);
            } else if (this.sampleShift > 0) {
                int n2 = this.findStretchPosition();
                this.outputBuffer = new int[this.bufferSize + n2];
                System.arraycopy(this.buffer, 0, this.outputBuffer, 0, n2);
                for (int i = 0; i < this.overlapSize; ++i) {
                    this.outputBuffer[n2 + i] = n = (int)((float)this.buffer[i + n2] * (1.0f - this.window[i]) + (float)this.buffer[i] * this.window[i]);
                }
                System.arraycopy(this.buffer, this.overlapSize, this.outputBuffer, n2 + this.overlapSize, this.bufferSize - this.overlapSize);
            } else if (this.sampleShift < 0) {
                int n3 = this.findShrinkPosition();
                this.outputBuffer = new int[this.bufferSize + n3];
                System.arraycopy(this.buffer, 0, this.outputBuffer, 0, this.bufferSize - this.overlapSize + n3);
                int n4 = this.bufferSize - this.overlapSize + n3;
                int n5 = this.bufferSize - this.overlapSize;
                int n6 = 0;
                while (n6 < this.overlapSize) {
                    this.outputBuffer[n4] = n = (int)((float)this.buffer[n4] * (1.0f - this.window[n6]) + (float)this.buffer[n5] * this.window[n6]);
                    ++n6;
                    ++n4;
                    ++n5;
                }
            }
            this.outputPos = 0;
            this.bufferPos = 0;
        }
    }

    public boolean isAvailable() {
        return this.outputBuffer != null && this.outputPos < this.outputBuffer.length;
    }

    public void drain() {
        if (this.bufferPos > 0) {
            this.outputBuffer = new int[this.bufferPos];
            System.arraycopy(this.buffer, 0, this.outputBuffer, 0, this.bufferPos);
            this.outputPos = 0;
            this.bufferPos = 0;
        }
    }
}

