Linux Flatpak package of vimix
================================

## Prerequirement: install flatpak

Instructions are at https://flatpak.org/setup/

e.g. for Ubuntu:

    sudo apt install flatpak
    flatpak remote-add --if-not-exists flathub https://flathub.org/repo/flathub.flatpakrepo


## Install vimix releases from Flathub

If you followed all instructions of the [flatpak setup](https://flatpak.org/setup/), vimix should be in the list of packages.

    flatpak install vimix

Get info on the Flathub release [here](https://flathub.org/en/apps/io.github.brunoherbelin.Vimix).

## Build local beta flatpack package of vimix

If you want to have the latest developper version of vimix (before releases), you can build a vimix flatpak yourself. This way, the application vimix is still sandboxed (i.e. not installing libs in your system), removable (entirely free space after remove) and updatable (just re-compile to update).

#### 1. Install flatpak build environments

If not already installed, install the builder and the flathub repository:

    sudo apt install flatpak-builder    

Install the runtime environments:
    
    flatpak install org.freedesktop.Sdk/x86_64/25.08
    flatpak install org.freedesktop.Platform/x86_64/25.08

These settings of git are needed to enable clone of local repos during build (done only once):

    git config --global --add protocol.file.allow always    

#### 2. Build vimix flatpak

Launch the build of the flatpak:

    flatpak-builder --user --install --from-git=https://github.com/brunoherbelin/vimix.git --from-git-branch=beta --delete-build-dirs --force-clean build flatpak/io.github.brunoherbelin.Vimix.json

The build will be quite long as some dependencies are also re-build from source. However, the build of dependencies is kept in cache; rebuilding vimix will subsequently be much faster.

If all goes well, the build should end with 

    ...
    Installing app/io.github.brunoherbelin.Vimix/x86_64/master
    Pruning cache


#### Troubleshooting build

For a clean rebuild, remove the `.flatpak-builder` folder from where you run the flatpak-builder command;

    rm -fr .flatpak-builder/  

Make sure your version of flatpak-builder is >= 1.4.4. If not, you might upgrade it with;

    sudo add-apt-repository ppa:flatpak/stable -y
    sudo apt install flatpak-builder   


## Run vimix flatpak

If all goes well, the package will have been installed and be able to run. The vimix app icon should be available. 

To run from command line:

    flatpak run io.github.brunoherbelin.Vimix


## Uninstall vimix flatpak

    flatpak uninstall vimix

## Troubleshooting 

Outdated flatpack drivers can cause vimix to fail. Keep your flatpak up to date; 

    flatpak update
