/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TokenStreamProvider extends AbstractStreamProvider {

    private String token;
    private final SSLSocketFactory factory;


    TokenStreamProvider(String token, String caCertFile) throws Exception {
        this.token = token;
        TrustManager[] trustManagers = configureCaCert(caCertFile);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustManagers, null);
        this.factory = context.getSocketFactory();
    }


    @Override
    protected SSLSocketFactory getSocketFactory() {
        return factory;
    }


    protected void setToken(String token) {
        this.token = token;
    }


    @Override
    public InputStream openStream(String url, Map<String,String> headers, int connectTimeout, int readTimeout)
            throws IOException {
        // Set token header
        if (token != null) {
            headers.put("Authorization", "Bearer " + token);
        }
        try {
            return super.openStream(url, headers, connectTimeout, readTimeout);
        } catch (IOException ioe) {
            // Add debug information
            throw new IOException(sm.getString("tokenStream.failedConnection", url, token), ioe);
        }
    }
}