use pipeline::Pipeline;

pub fn make_pipeline() -> Pipeline {
    Pipeline {
        queue: vec![
            ("trimmer-ro".into(), trimmer),
            ("stopWordFilter-ro".into(), stop_word_filter),
            ("stemmer-ro".into(), stemmer),
        ],
    }
}

make_trimmer!(
    "A-Za-z\\xAA\\xBA\\xC0-\\xD6\\xD8-\\xF6\\xF8-\\u02B8\\u02E0-\\u02E4\\u1D00-\\u1D25\
     \\u1D2C-\\u1D5C\\u1D62-\\u1D65\\u1D6B-\\u1D77\\u1D79-\\u1DBE\\u1E00-\\u1EFF\\u2071\\u207F\
     \\u2090-\\u209C\\u212A\\u212B\\u2132\\u214E\\u2160-\\u2188\\u2C60-\\u2C7F\\uA722-\\uA787\
     \\uA78B-\\uA7AD\\uA7B0-\\uA7B7\\uA7F7-\\uA7FF\\uAB30-\\uAB5A\\uAB5C-\\uAB64\\uFB00-\\uFB06\
     \\uFF21-\\uFF3A\\uFF41-\\uFF5A"
);

make_stop_word_filter!([
    "",
    "acea",
    "aceasta",
    "această",
    "aceea",
    "acei",
    "aceia",
    "acel",
    "acela",
    "acele",
    "acelea",
    "acest",
    "acesta",
    "aceste",
    "acestea",
    "aceşti",
    "aceştia",
    "acolo",
    "acord",
    "acum",
    "ai",
    "aia",
    "aibă",
    "aici",
    "al",
    "ale",
    "alea",
    "altceva",
    "altcineva",
    "am",
    "ar",
    "are",
    "asemenea",
    "asta",
    "astea",
    "astăzi",
    "asupra",
    "au",
    "avea",
    "avem",
    "aveţi",
    "azi",
    "aş",
    "aşadar",
    "aţi",
    "bine",
    "bucur",
    "bună",
    "ca",
    "care",
    "caut",
    "ce",
    "cel",
    "ceva",
    "chiar",
    "cinci",
    "cine",
    "cineva",
    "contra",
    "cu",
    "cum",
    "cumva",
    "curând",
    "curînd",
    "când",
    "cât",
    "câte",
    "câtva",
    "câţi",
    "cînd",
    "cît",
    "cîte",
    "cîtva",
    "cîţi",
    "că",
    "căci",
    "cărei",
    "căror",
    "cărui",
    "către",
    "da",
    "dacă",
    "dar",
    "datorită",
    "dată",
    "dau",
    "de",
    "deci",
    "deja",
    "deoarece",
    "departe",
    "deşi",
    "din",
    "dinaintea",
    "dintr-",
    "dintre",
    "doi",
    "doilea",
    "două",
    "drept",
    "după",
    "dă",
    "ea",
    "ei",
    "el",
    "ele",
    "eram",
    "este",
    "eu",
    "eşti",
    "face",
    "fata",
    "fi",
    "fie",
    "fiecare",
    "fii",
    "fim",
    "fiu",
    "fiţi",
    "frumos",
    "fără",
    "graţie",
    "halbă",
    "iar",
    "ieri",
    "la",
    "le",
    "li",
    "lor",
    "lui",
    "lângă",
    "lîngă",
    "mai",
    "mea",
    "mei",
    "mele",
    "mereu",
    "meu",
    "mi",
    "mie",
    "mine",
    "mult",
    "multă",
    "mulţi",
    "mulţumesc",
    "mâine",
    "mîine",
    "mă",
    "ne",
    "nevoie",
    "nici",
    "nicăieri",
    "nimeni",
    "nimeri",
    "nimic",
    "nişte",
    "noastre",
    "noastră",
    "noi",
    "noroc",
    "nostru",
    "nouă",
    "noştri",
    "nu",
    "opt",
    "ori",
    "oricare",
    "orice",
    "oricine",
    "oricum",
    "oricând",
    "oricât",
    "oricînd",
    "oricît",
    "oriunde",
    "patra",
    "patru",
    "patrulea",
    "pe",
    "pentru",
    "peste",
    "pic",
    "poate",
    "pot",
    "prea",
    "prima",
    "primul",
    "prin",
    "puţin",
    "puţina",
    "puţină",
    "până",
    "pînă",
    "rog",
    "sa",
    "sale",
    "sau",
    "se",
    "spate",
    "spre",
    "sub",
    "sunt",
    "suntem",
    "sunteţi",
    "sută",
    "sînt",
    "sîntem",
    "sînteţi",
    "să",
    "săi",
    "său",
    "ta",
    "tale",
    "te",
    "timp",
    "tine",
    "toate",
    "toată",
    "tot",
    "totuşi",
    "toţi",
    "trei",
    "treia",
    "treilea",
    "tu",
    "tăi",
    "tău",
    "un",
    "una",
    "unde",
    "undeva",
    "unei",
    "uneia",
    "unele",
    "uneori",
    "unii",
    "unor",
    "unora",
    "unu",
    "unui",
    "unuia",
    "unul",
    "vi",
    "voastre",
    "voastră",
    "voi",
    "vostru",
    "vouă",
    "voştri",
    "vreme",
    "vreo",
    "vreun",
    "vă",
    "zece",
    "zero",
    "zi",
    "zice",
    "îi",
    "îl",
    "îmi",
    "împotriva",
    "în",
    "înainte",
    "înaintea",
    "încotro",
    "încât",
    "încît",
    "între",
    "întrucât",
    "întrucît",
    "îţi",
    "ăla",
    "ălea",
    "ăsta",
    "ăstea",
    "ăştia",
    "şapte",
    "şase",
    "şi",
    "ştiu",
    "ţi",
    "ţie",
]);

make_stemmer!(Algorithm::Romanian);
