use crate::spec::{
    Abi, Arch, Cc, LinkerFlavor, Lld, PanicStrategy, RelocModel, Target, TargetMetadata,
    TargetOptions,
};

pub(crate) fn target() -> Target {
    Target {
        llvm_target: "loongarch32-unknown-none".into(),
        metadata: TargetMetadata {
            description: Some("Freestanding/bare-metal LoongArch32 softfloat".into()),
            tier: Some(3),
            host_tools: Some(false),
            std: Some(false),
        },
        pointer_width: 32,
        data_layout: "e-m:e-p:32:32-i64:64-n32-S128".into(),
        arch: Arch::LoongArch32,
        options: TargetOptions {
            cpu: "generic".into(),
            features: "-f,-d".into(),
            abi: Abi::SoftFloat,
            linker_flavor: LinkerFlavor::Gnu(Cc::No, Lld::Yes),
            linker: Some("rust-lld".into()),
            llvm_abiname: "ilp32s".into(),
            max_atomic_width: Some(32),
            relocation_model: RelocModel::Static,
            panic_strategy: PanicStrategy::Abort,
            ..Default::default()
        },
    }
}
