% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baggedModel.R
\name{forecast.baggedModel}
\alias{forecast.baggedModel}
\title{Forecasting using a bagged model}
\usage{
\method{forecast}{baggedModel}(
  object,
  h = if (frequency(object$y) > 1) 2 * frequency(object$y) else 10,
  ...
)
}
\arguments{
\item{object}{An object of class \code{baggedModel} resulting from a call to
\code{\link[=baggedModel]{baggedModel()}}.}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{...}{Other arguments, passed on to the \code{\link[=forecast]{forecast()}} function of the original method}
}
\value{
An object of class \code{forecast}.
}
\description{
Returns forecasts and other information for bagged models.
}
\details{
Intervals are calculated as min and max values over the point forecasts from
the models in the ensemble. I.e., the intervals are not prediction
intervals, but give an indication of how different the forecasts within the
ensemble are.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
fit <- baggedModel(WWWusage)
fcast <- forecast(fit)
plot(fcast)

\dontrun{
fit2 <- baggedModel(WWWusage, fn = "auto.arima")
fcast2 <- forecast(fit2)
plot(fcast2)
accuracy(fcast2)
}

}
\references{
Bergmeir, C., R. J. Hyndman, and J. M. Benitez (2016). Bagging
Exponential Smoothing Methods using STL Decomposition and Box-Cox
Transformation. International Journal of Forecasting 32, 303-312.
}
\seealso{
\code{\link[=baggedModel]{baggedModel()}}.
}
\author{
Christoph Bergmeir, Fotios Petropoulos
}
\keyword{ts}
