% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{set_formatter}
\alias{set_formatter}
\title{Set column formatter functions}
\usage{
set_formatter(x, ..., values = NULL, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{...}{Name-value pairs of functions, names should be existing col_key values}

\item{values}{format functions, If values is supplied argument \code{...} is ignored.
\itemize{
\item It can be a list of name-value pairs of functions, names
should be existing col_key values.
\item If \code{values} is a single function, it will be applied to each column.
}}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}
}
\description{
Apply formatter functions to column keys.

Functions should have a single argument (the vector) and should
return the formatted values as a character vector.
}
\examples{
ft <- flextable(head(iris))
ft <- set_formatter(
  x = ft,
  Sepal.Length = function(x) sprintf("\%.02f", x),
  Sepal.Width = function(x) sprintf("\%.04f", x)
)
ft <- theme_vanilla(ft)
ft
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_date}()},
\code{\link{colformat_datetime}()},
\code{\link{colformat_double}()},
\code{\link{colformat_image}()},
\code{\link{colformat_int}()},
\code{\link{colformat_lgl}()},
\code{\link{colformat_num}()}
}
\concept{cells formatters}
