# generated by datamodel-codegen:
#   filename:  github-api.graphql
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from datetime import date, datetime
from enum import Enum
from typing import List, Literal, Optional, TypeAlias, Union

from pydantic import BaseModel, Field

Base64String: TypeAlias = str
"""
A (potentially binary) string encoded using base64.
"""


BigInt: TypeAlias = int
"""
Represents non-fractional signed whole numeric values. Since the value may
exceed the size of a 32-bit integer, it's encoded as a string.
"""


Boolean: TypeAlias = bool
"""
The `Boolean` scalar type represents `true` or `false`.
"""


Date: TypeAlias = date
"""
An ISO-8601 encoded date string.
"""


DateTime: TypeAlias = datetime
"""
An ISO-8601 encoded UTC date string.
"""


Float: TypeAlias = float
"""
The `Float` scalar type represents signed double-precision fractional values as specified by [IEEE 754](https://en.wikipedia.org/wiki/IEEE_floating_point).
"""


GitObjectID: TypeAlias = str
"""
A Git object ID.
"""


GitRefname: TypeAlias = str
"""
A fully qualified reference name (e.g. `refs/heads/master`).
"""


GitSSHRemote: TypeAlias = str
"""
Git SSH string
"""


GitTimestamp: TypeAlias = str
"""
An ISO-8601 encoded date string. Unlike the DateTime type, GitTimestamp is not converted in UTC.
"""


HTML: TypeAlias = str
"""
A string containing HTML code.
"""


ID: TypeAlias = str
"""
The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
"""


Int: TypeAlias = int
"""
The `Int` scalar type represents non-fractional signed whole numeric values. Int can represent values between -(2^31) and 2^31 - 1.
"""


PreciseDateTime: TypeAlias = datetime
"""
An ISO-8601 encoded UTC date string with millisecond precision.
"""


String: TypeAlias = str
"""
The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
"""


URI: TypeAlias = str
"""
An RFC 3986, RFC 3987, and RFC 6570 (level 4) compliant URI string.
"""


X509Certificate: TypeAlias = str
"""
A valid x509 certificate string
"""


class ActorType(Enum):
    """
    The actor's type.
    """

    TEAM = 'TEAM'
    USER = 'USER'


class AuditLogOrderField(Enum):
    """
    Properties by which Audit Log connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class CheckAnnotationLevel(Enum):
    """
    Represents an annotation's information level.
    """

    FAILURE = 'FAILURE'
    NOTICE = 'NOTICE'
    WARNING = 'WARNING'


class CheckConclusionState(Enum):
    """
    The possible states for a check suite or run conclusion.
    """

    ACTION_REQUIRED = 'ACTION_REQUIRED'
    CANCELLED = 'CANCELLED'
    FAILURE = 'FAILURE'
    NEUTRAL = 'NEUTRAL'
    SKIPPED = 'SKIPPED'
    STALE = 'STALE'
    STARTUP_FAILURE = 'STARTUP_FAILURE'
    SUCCESS = 'SUCCESS'
    TIMED_OUT = 'TIMED_OUT'


class CheckRunState(Enum):
    """
    The possible states of a check run in a status rollup.
    """

    ACTION_REQUIRED = 'ACTION_REQUIRED'
    CANCELLED = 'CANCELLED'
    COMPLETED = 'COMPLETED'
    FAILURE = 'FAILURE'
    IN_PROGRESS = 'IN_PROGRESS'
    NEUTRAL = 'NEUTRAL'
    PENDING = 'PENDING'
    QUEUED = 'QUEUED'
    SKIPPED = 'SKIPPED'
    STALE = 'STALE'
    STARTUP_FAILURE = 'STARTUP_FAILURE'
    SUCCESS = 'SUCCESS'
    TIMED_OUT = 'TIMED_OUT'
    WAITING = 'WAITING'


class CheckRunType(Enum):
    """
    The possible types of check runs.
    """

    ALL = 'ALL'
    LATEST = 'LATEST'


class CheckStatusState(Enum):
    """
    The possible states for a check suite or run status.
    """

    COMPLETED = 'COMPLETED'
    IN_PROGRESS = 'IN_PROGRESS'
    PENDING = 'PENDING'
    QUEUED = 'QUEUED'
    REQUESTED = 'REQUESTED'
    WAITING = 'WAITING'


class CollaboratorAffiliation(Enum):
    """
    Collaborators affiliation level with a subject.
    """

    ALL = 'ALL'
    DIRECT = 'DIRECT'
    OUTSIDE = 'OUTSIDE'


class CommentAuthorAssociation(Enum):
    """
    A comment author association with repository.
    """

    COLLABORATOR = 'COLLABORATOR'
    CONTRIBUTOR = 'CONTRIBUTOR'
    FIRST_TIMER = 'FIRST_TIMER'
    FIRST_TIME_CONTRIBUTOR = 'FIRST_TIME_CONTRIBUTOR'
    MANNEQUIN = 'MANNEQUIN'
    MEMBER = 'MEMBER'
    NONE = 'NONE'
    OWNER = 'OWNER'


class CommentCannotUpdateReason(Enum):
    """
    The possible errors that will prevent a user from updating a comment.
    """

    ARCHIVED = 'ARCHIVED'
    DENIED = 'DENIED'
    INSUFFICIENT_ACCESS = 'INSUFFICIENT_ACCESS'
    LOCKED = 'LOCKED'
    LOGIN_REQUIRED = 'LOGIN_REQUIRED'
    MAINTENANCE = 'MAINTENANCE'
    VERIFIED_EMAIL_REQUIRED = 'VERIFIED_EMAIL_REQUIRED'


class CommitContributionOrderField(Enum):
    """
    Properties by which commit contribution connections can be ordered.
    """

    COMMIT_COUNT = 'COMMIT_COUNT'
    OCCURRED_AT = 'OCCURRED_AT'


class ComparisonStatus(Enum):
    """
    The status of a git comparison between two refs.
    """

    AHEAD = 'AHEAD'
    BEHIND = 'BEHIND'
    DIVERGED = 'DIVERGED'
    IDENTICAL = 'IDENTICAL'


class ContributionLevel(Enum):
    """
    Varying levels of contributions from none to many.
    """

    FIRST_QUARTILE = 'FIRST_QUARTILE'
    FOURTH_QUARTILE = 'FOURTH_QUARTILE'
    NONE = 'NONE'
    SECOND_QUARTILE = 'SECOND_QUARTILE'
    THIRD_QUARTILE = 'THIRD_QUARTILE'


class DefaultRepositoryPermissionField(Enum):
    """
    The possible base permissions for repositories.
    """

    ADMIN = 'ADMIN'
    NONE = 'NONE'
    READ = 'READ'
    WRITE = 'WRITE'


class DependencyGraphEcosystem(Enum):
    """
    The possible ecosystems of a dependency graph package.
    """

    ACTIONS = 'ACTIONS'
    COMPOSER = 'COMPOSER'
    GO = 'GO'
    MAVEN = 'MAVEN'
    NPM = 'NPM'
    NUGET = 'NUGET'
    PIP = 'PIP'
    PUB = 'PUB'
    RUBYGEMS = 'RUBYGEMS'
    RUST = 'RUST'
    SWIFT = 'SWIFT'


class DeploymentOrderField(Enum):
    """
    Properties by which deployment connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class DeploymentProtectionRuleType(Enum):
    """
    The possible protection rule types.
    """

    REQUIRED_REVIEWERS = 'REQUIRED_REVIEWERS'
    WAIT_TIMER = 'WAIT_TIMER'


class DeploymentReviewState(Enum):
    """
    The possible states for a deployment review.
    """

    APPROVED = 'APPROVED'
    REJECTED = 'REJECTED'


class DeploymentState(Enum):
    """
    The possible states in which a deployment can be.
    """

    ABANDONED = 'ABANDONED'
    ACTIVE = 'ACTIVE'
    DESTROYED = 'DESTROYED'
    ERROR = 'ERROR'
    FAILURE = 'FAILURE'
    INACTIVE = 'INACTIVE'
    IN_PROGRESS = 'IN_PROGRESS'
    PENDING = 'PENDING'
    QUEUED = 'QUEUED'
    SUCCESS = 'SUCCESS'
    WAITING = 'WAITING'


class DeploymentStatusState(Enum):
    """
    The possible states for a deployment status.
    """

    ERROR = 'ERROR'
    FAILURE = 'FAILURE'
    INACTIVE = 'INACTIVE'
    IN_PROGRESS = 'IN_PROGRESS'
    PENDING = 'PENDING'
    QUEUED = 'QUEUED'
    SUCCESS = 'SUCCESS'
    WAITING = 'WAITING'


class DiffSide(Enum):
    """
    The possible sides of a diff.
    """

    LEFT = 'LEFT'
    RIGHT = 'RIGHT'


class DiscussionCloseReason(Enum):
    """
    The possible reasons for closing a discussion.
    """

    DUPLICATE = 'DUPLICATE'
    OUTDATED = 'OUTDATED'
    RESOLVED = 'RESOLVED'


class DiscussionOrderField(Enum):
    """
    Properties by which discussion connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    UPDATED_AT = 'UPDATED_AT'


class DiscussionPollOptionOrderField(Enum):
    """
    Properties by which discussion poll option connections can be ordered.
    """

    AUTHORED_ORDER = 'AUTHORED_ORDER'
    VOTE_COUNT = 'VOTE_COUNT'


class DiscussionState(Enum):
    """
    The possible states of a discussion.
    """

    CLOSED = 'CLOSED'
    OPEN = 'OPEN'


class DiscussionStateReason(Enum):
    """
    The possible state reasons of a discussion.
    """

    DUPLICATE = 'DUPLICATE'
    OUTDATED = 'OUTDATED'
    REOPENED = 'REOPENED'
    RESOLVED = 'RESOLVED'


class DismissReason(Enum):
    """
    The possible reasons that a Dependabot alert was dismissed.
    """

    FIX_STARTED = 'FIX_STARTED'
    INACCURATE = 'INACCURATE'
    NOT_USED = 'NOT_USED'
    NO_BANDWIDTH = 'NO_BANDWIDTH'
    TOLERABLE_RISK = 'TOLERABLE_RISK'


class EnterpriseAdministratorInvitationOrderField(Enum):
    """
    Properties by which enterprise administrator invitation connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class EnterpriseAdministratorRole(Enum):
    """
    The possible administrator roles in an enterprise account.
    """

    BILLING_MANAGER = 'BILLING_MANAGER'
    OWNER = 'OWNER'


class EnterpriseAllowPrivateRepositoryForkingPolicyValue(Enum):
    """
    The possible values for the enterprise allow private repository forking policy value.
    """

    ENTERPRISE_ORGANIZATIONS = 'ENTERPRISE_ORGANIZATIONS'
    ENTERPRISE_ORGANIZATIONS_USER_ACCOUNTS = 'ENTERPRISE_ORGANIZATIONS_USER_ACCOUNTS'
    EVERYWHERE = 'EVERYWHERE'
    SAME_ORGANIZATION = 'SAME_ORGANIZATION'
    SAME_ORGANIZATION_USER_ACCOUNTS = 'SAME_ORGANIZATION_USER_ACCOUNTS'
    USER_ACCOUNTS = 'USER_ACCOUNTS'


class EnterpriseDefaultRepositoryPermissionSettingValue(Enum):
    """
    The possible values for the enterprise base repository permission setting.
    """

    ADMIN = 'ADMIN'
    NONE = 'NONE'
    NO_POLICY = 'NO_POLICY'
    READ = 'READ'
    WRITE = 'WRITE'


class EnterpriseEnabledDisabledSettingValue(Enum):
    """
    The possible values for an enabled/disabled enterprise setting.
    """

    DISABLED = 'DISABLED'
    ENABLED = 'ENABLED'
    NO_POLICY = 'NO_POLICY'


class EnterpriseEnabledSettingValue(Enum):
    """
    The possible values for an enabled/no policy enterprise setting.
    """

    ENABLED = 'ENABLED'
    NO_POLICY = 'NO_POLICY'


class EnterpriseMemberOrderField(Enum):
    """
    Properties by which enterprise member connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    LOGIN = 'LOGIN'


class EnterpriseMembersCanCreateRepositoriesSettingValue(Enum):
    """
    The possible values for the enterprise members can create repositories setting.
    """

    ALL = 'ALL'
    DISABLED = 'DISABLED'
    NO_POLICY = 'NO_POLICY'
    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class EnterpriseMembersCanMakePurchasesSettingValue(Enum):
    """
    The possible values for the members can make purchases setting.
    """

    DISABLED = 'DISABLED'
    ENABLED = 'ENABLED'


class EnterpriseMembershipType(Enum):
    """
    The possible values we have for filtering Platform::Objects::User#enterprises.
    """

    ADMIN = 'ADMIN'
    ALL = 'ALL'
    BILLING_MANAGER = 'BILLING_MANAGER'
    ORG_MEMBERSHIP = 'ORG_MEMBERSHIP'


class EnterpriseOrderField(Enum):
    """
    Properties by which enterprise connections can be ordered.
    """

    NAME = 'NAME'


class EnterpriseServerInstallationOrderField(Enum):
    """
    Properties by which Enterprise Server installation connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    CUSTOMER_NAME = 'CUSTOMER_NAME'
    HOST_NAME = 'HOST_NAME'


class EnterpriseServerUserAccountEmailOrderField(Enum):
    """
    Properties by which Enterprise Server user account email connections can be ordered.
    """

    EMAIL = 'EMAIL'


class EnterpriseServerUserAccountOrderField(Enum):
    """
    Properties by which Enterprise Server user account connections can be ordered.
    """

    LOGIN = 'LOGIN'
    REMOTE_CREATED_AT = 'REMOTE_CREATED_AT'


class EnterpriseServerUserAccountsUploadOrderField(Enum):
    """
    Properties by which Enterprise Server user accounts upload connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class EnterpriseServerUserAccountsUploadSyncState(Enum):
    """
    Synchronization state of the Enterprise Server user accounts upload
    """

    FAILURE = 'FAILURE'
    PENDING = 'PENDING'
    SUCCESS = 'SUCCESS'


class EnterpriseUserAccountMembershipRole(Enum):
    """
    The possible roles for enterprise membership.
    """

    MEMBER = 'MEMBER'
    OWNER = 'OWNER'
    UNAFFILIATED = 'UNAFFILIATED'


class EnterpriseUserDeployment(Enum):
    """
    The possible GitHub Enterprise deployments where this user can exist.
    """

    CLOUD = 'CLOUD'
    SERVER = 'SERVER'


class EnvironmentOrderField(Enum):
    """
    Properties by which environments connections can be ordered
    """

    NAME = 'NAME'


class FileViewedState(Enum):
    """
    The possible viewed states of a file .
    """

    DISMISSED = 'DISMISSED'
    UNVIEWED = 'UNVIEWED'
    VIEWED = 'VIEWED'


class FundingPlatform(Enum):
    """
    The possible funding platforms for repository funding links.
    """

    COMMUNITY_BRIDGE = 'COMMUNITY_BRIDGE'
    CUSTOM = 'CUSTOM'
    GITHUB = 'GITHUB'
    ISSUEHUNT = 'ISSUEHUNT'
    KO_FI = 'KO_FI'
    LFX_CROWDFUNDING = 'LFX_CROWDFUNDING'
    LIBERAPAY = 'LIBERAPAY'
    OPEN_COLLECTIVE = 'OPEN_COLLECTIVE'
    OTECHIE = 'OTECHIE'
    PATREON = 'PATREON'
    TIDELIFT = 'TIDELIFT'


class GistOrderField(Enum):
    """
    Properties by which gist connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    PUSHED_AT = 'PUSHED_AT'
    UPDATED_AT = 'UPDATED_AT'


class GistPrivacy(Enum):
    """
    The privacy of a Gist
    """

    ALL = 'ALL'
    PUBLIC = 'PUBLIC'
    SECRET = 'SECRET'


class GitSignatureState(Enum):
    """
    The state of a Git signature.
    """

    BAD_CERT = 'BAD_CERT'
    BAD_EMAIL = 'BAD_EMAIL'
    EXPIRED_KEY = 'EXPIRED_KEY'
    GPGVERIFY_ERROR = 'GPGVERIFY_ERROR'
    GPGVERIFY_UNAVAILABLE = 'GPGVERIFY_UNAVAILABLE'
    INVALID = 'INVALID'
    MALFORMED_SIG = 'MALFORMED_SIG'
    NOT_SIGNING_KEY = 'NOT_SIGNING_KEY'
    NO_USER = 'NO_USER'
    OCSP_ERROR = 'OCSP_ERROR'
    OCSP_PENDING = 'OCSP_PENDING'
    OCSP_REVOKED = 'OCSP_REVOKED'
    UNKNOWN_KEY = 'UNKNOWN_KEY'
    UNKNOWN_SIG_TYPE = 'UNKNOWN_SIG_TYPE'
    UNSIGNED = 'UNSIGNED'
    UNVERIFIED_EMAIL = 'UNVERIFIED_EMAIL'
    VALID = 'VALID'


class IdentityProviderConfigurationState(Enum):
    """
    The possible states in which authentication can be configured with an identity provider.
    """

    CONFIGURED = 'CONFIGURED'
    ENFORCED = 'ENFORCED'
    UNCONFIGURED = 'UNCONFIGURED'


class IpAllowListEnabledSettingValue(Enum):
    """
    The possible values for the IP allow list enabled setting.
    """

    DISABLED = 'DISABLED'
    ENABLED = 'ENABLED'


class IpAllowListEntryOrderField(Enum):
    """
    Properties by which IP allow list entry connections can be ordered.
    """

    ALLOW_LIST_VALUE = 'ALLOW_LIST_VALUE'
    CREATED_AT = 'CREATED_AT'


class IpAllowListForInstalledAppsEnabledSettingValue(Enum):
    """
    The possible values for the IP allow list configuration for installed GitHub Apps setting.
    """

    DISABLED = 'DISABLED'
    ENABLED = 'ENABLED'


class IssueClosedStateReason(Enum):
    """
    The possible state reasons of a closed issue.
    """

    COMPLETED = 'COMPLETED'
    NOT_PLANNED = 'NOT_PLANNED'


class IssueCommentOrderField(Enum):
    """
    Properties by which issue comment connections can be ordered.
    """

    UPDATED_AT = 'UPDATED_AT'


class IssueOrderField(Enum):
    """
    Properties by which issue connections can be ordered.
    """

    COMMENTS = 'COMMENTS'
    CREATED_AT = 'CREATED_AT'
    UPDATED_AT = 'UPDATED_AT'


class IssueState(Enum):
    """
    The possible states of an issue.
    """

    CLOSED = 'CLOSED'
    OPEN = 'OPEN'


class IssueStateReason(Enum):
    """
    The possible state reasons of an issue.
    """

    COMPLETED = 'COMPLETED'
    NOT_PLANNED = 'NOT_PLANNED'
    REOPENED = 'REOPENED'


class IssueTimelineItemsItemType(Enum):
    """
    The possible item types found in a timeline.
    """

    ADDED_TO_PROJECT_EVENT = 'ADDED_TO_PROJECT_EVENT'
    ASSIGNED_EVENT = 'ASSIGNED_EVENT'
    CLOSED_EVENT = 'CLOSED_EVENT'
    COMMENT_DELETED_EVENT = 'COMMENT_DELETED_EVENT'
    CONNECTED_EVENT = 'CONNECTED_EVENT'
    CONVERTED_NOTE_TO_ISSUE_EVENT = 'CONVERTED_NOTE_TO_ISSUE_EVENT'
    CONVERTED_TO_DISCUSSION_EVENT = 'CONVERTED_TO_DISCUSSION_EVENT'
    CROSS_REFERENCED_EVENT = 'CROSS_REFERENCED_EVENT'
    DEMILESTONED_EVENT = 'DEMILESTONED_EVENT'
    DISCONNECTED_EVENT = 'DISCONNECTED_EVENT'
    ISSUE_COMMENT = 'ISSUE_COMMENT'
    LABELED_EVENT = 'LABELED_EVENT'
    LOCKED_EVENT = 'LOCKED_EVENT'
    MARKED_AS_DUPLICATE_EVENT = 'MARKED_AS_DUPLICATE_EVENT'
    MENTIONED_EVENT = 'MENTIONED_EVENT'
    MILESTONED_EVENT = 'MILESTONED_EVENT'
    MOVED_COLUMNS_IN_PROJECT_EVENT = 'MOVED_COLUMNS_IN_PROJECT_EVENT'
    PINNED_EVENT = 'PINNED_EVENT'
    REFERENCED_EVENT = 'REFERENCED_EVENT'
    REMOVED_FROM_PROJECT_EVENT = 'REMOVED_FROM_PROJECT_EVENT'
    RENAMED_TITLE_EVENT = 'RENAMED_TITLE_EVENT'
    REOPENED_EVENT = 'REOPENED_EVENT'
    SUBSCRIBED_EVENT = 'SUBSCRIBED_EVENT'
    TRANSFERRED_EVENT = 'TRANSFERRED_EVENT'
    UNASSIGNED_EVENT = 'UNASSIGNED_EVENT'
    UNLABELED_EVENT = 'UNLABELED_EVENT'
    UNLOCKED_EVENT = 'UNLOCKED_EVENT'
    UNMARKED_AS_DUPLICATE_EVENT = 'UNMARKED_AS_DUPLICATE_EVENT'
    UNPINNED_EVENT = 'UNPINNED_EVENT'
    UNSUBSCRIBED_EVENT = 'UNSUBSCRIBED_EVENT'
    USER_BLOCKED_EVENT = 'USER_BLOCKED_EVENT'


class LabelOrderField(Enum):
    """
    Properties by which label connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NAME = 'NAME'


class LanguageOrderField(Enum):
    """
    Properties by which language connections can be ordered.
    """

    SIZE = 'SIZE'


class LockReason(Enum):
    """
    The possible reasons that an issue or pull request was locked.
    """

    OFF_TOPIC = 'OFF_TOPIC'
    RESOLVED = 'RESOLVED'
    SPAM = 'SPAM'
    TOO_HEATED = 'TOO_HEATED'


class MannequinOrderField(Enum):
    """
    Properties by which mannequins can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    LOGIN = 'LOGIN'


class MergeCommitMessage(Enum):
    """
    The possible default commit messages for merges.
    """

    BLANK = 'BLANK'
    PR_BODY = 'PR_BODY'
    PR_TITLE = 'PR_TITLE'


class MergeCommitTitle(Enum):
    """
    The possible default commit titles for merges.
    """

    MERGE_MESSAGE = 'MERGE_MESSAGE'
    PR_TITLE = 'PR_TITLE'


class MergeQueueEntryState(Enum):
    """
    The possible states for a merge queue entry.
    """

    AWAITING_CHECKS = 'AWAITING_CHECKS'
    LOCKED = 'LOCKED'
    MERGEABLE = 'MERGEABLE'
    QUEUED = 'QUEUED'
    UNMERGEABLE = 'UNMERGEABLE'


class MergeQueueMergingStrategy(Enum):
    """
    The possible merging strategies for a merge queue.
    """

    ALLGREEN = 'ALLGREEN'
    HEADGREEN = 'HEADGREEN'


class MergeStateStatus(Enum):
    """
    Detailed status information about a pull request merge.
    """

    BEHIND = 'BEHIND'
    BLOCKED = 'BLOCKED'
    CLEAN = 'CLEAN'
    DIRTY = 'DIRTY'
    DRAFT = 'DRAFT'
    HAS_HOOKS = 'HAS_HOOKS'
    UNKNOWN = 'UNKNOWN'
    UNSTABLE = 'UNSTABLE'


class MergeableState(Enum):
    """
    Whether or not a PullRequest can be merged.
    """

    CONFLICTING = 'CONFLICTING'
    MERGEABLE = 'MERGEABLE'
    UNKNOWN = 'UNKNOWN'


class MigrationSourceType(Enum):
    """
    Represents the different GitHub Enterprise Importer (GEI) migration sources.
    """

    AZURE_DEVOPS = 'AZURE_DEVOPS'
    BITBUCKET_SERVER = 'BITBUCKET_SERVER'
    GITHUB_ARCHIVE = 'GITHUB_ARCHIVE'


class MigrationState(Enum):
    """
    The GitHub Enterprise Importer (GEI) migration state.
    """

    FAILED = 'FAILED'
    FAILED_VALIDATION = 'FAILED_VALIDATION'
    IN_PROGRESS = 'IN_PROGRESS'
    NOT_STARTED = 'NOT_STARTED'
    PENDING_VALIDATION = 'PENDING_VALIDATION'
    QUEUED = 'QUEUED'
    SUCCEEDED = 'SUCCEEDED'


class MilestoneOrderField(Enum):
    """
    Properties by which milestone connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    DUE_DATE = 'DUE_DATE'
    NUMBER = 'NUMBER'
    UPDATED_AT = 'UPDATED_AT'


class MilestoneState(Enum):
    """
    The possible states of a milestone.
    """

    CLOSED = 'CLOSED'
    OPEN = 'OPEN'


class NotificationRestrictionSettingValue(Enum):
    """
    The possible values for the notification restriction setting.
    """

    DISABLED = 'DISABLED'
    ENABLED = 'ENABLED'


class OIDCProviderType(Enum):
    """
    The OIDC identity provider type
    """

    AAD = 'AAD'


class OauthApplicationCreateAuditEntryState(Enum):
    """
    The state of an OAuth application when it was created.
    """

    ACTIVE = 'ACTIVE'
    PENDING_DELETION = 'PENDING_DELETION'
    SUSPENDED = 'SUSPENDED'


class OperationType(Enum):
    """
    The corresponding operation type for the action
    """

    ACCESS = 'ACCESS'
    AUTHENTICATION = 'AUTHENTICATION'
    CREATE = 'CREATE'
    MODIFY = 'MODIFY'
    REMOVE = 'REMOVE'
    RESTORE = 'RESTORE'
    TRANSFER = 'TRANSFER'


class OrderDirection(Enum):
    """
    Possible directions in which to order a list of items when provided an `orderBy` argument.
    """

    ASC = 'ASC'
    DESC = 'DESC'


class OrgAddMemberAuditEntryPermission(Enum):
    """
    The permissions available to members on an Organization.
    """

    ADMIN = 'ADMIN'
    READ = 'READ'


class OrgCreateAuditEntryBillingPlan(Enum):
    """
    The billing plans available for organizations.
    """

    BUSINESS = 'BUSINESS'
    BUSINESS_PLUS = 'BUSINESS_PLUS'
    FREE = 'FREE'
    TIERED_PER_SEAT = 'TIERED_PER_SEAT'
    UNLIMITED = 'UNLIMITED'


class OrgEnterpriseOwnerOrderField(Enum):
    """
    Properties by which enterprise owners can be ordered.
    """

    LOGIN = 'LOGIN'


class OrgRemoveBillingManagerAuditEntryReason(Enum):
    """
    The reason a billing manager was removed from an Organization.
    """

    SAML_EXTERNAL_IDENTITY_MISSING = 'SAML_EXTERNAL_IDENTITY_MISSING'
    SAML_SSO_ENFORCEMENT_REQUIRES_EXTERNAL_IDENTITY = (
        'SAML_SSO_ENFORCEMENT_REQUIRES_EXTERNAL_IDENTITY'
    )
    TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE = 'TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE'


class OrgRemoveMemberAuditEntryMembershipType(Enum):
    """
    The type of membership a user has with an Organization.
    """

    ADMIN = 'ADMIN'
    BILLING_MANAGER = 'BILLING_MANAGER'
    DIRECT_MEMBER = 'DIRECT_MEMBER'
    OUTSIDE_COLLABORATOR = 'OUTSIDE_COLLABORATOR'
    SUSPENDED = 'SUSPENDED'
    UNAFFILIATED = 'UNAFFILIATED'


class OrgRemoveMemberAuditEntryReason(Enum):
    """
    The reason a member was removed from an Organization.
    """

    SAML_EXTERNAL_IDENTITY_MISSING = 'SAML_EXTERNAL_IDENTITY_MISSING'
    SAML_SSO_ENFORCEMENT_REQUIRES_EXTERNAL_IDENTITY = (
        'SAML_SSO_ENFORCEMENT_REQUIRES_EXTERNAL_IDENTITY'
    )
    TWO_FACTOR_ACCOUNT_RECOVERY = 'TWO_FACTOR_ACCOUNT_RECOVERY'
    TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE = 'TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE'
    USER_ACCOUNT_DELETED = 'USER_ACCOUNT_DELETED'


class OrgRemoveOutsideCollaboratorAuditEntryMembershipType(Enum):
    """
    The type of membership a user has with an Organization.
    """

    BILLING_MANAGER = 'BILLING_MANAGER'
    OUTSIDE_COLLABORATOR = 'OUTSIDE_COLLABORATOR'
    UNAFFILIATED = 'UNAFFILIATED'


class OrgRemoveOutsideCollaboratorAuditEntryReason(Enum):
    """
    The reason an outside collaborator was removed from an Organization.
    """

    SAML_EXTERNAL_IDENTITY_MISSING = 'SAML_EXTERNAL_IDENTITY_MISSING'
    TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE = 'TWO_FACTOR_REQUIREMENT_NON_COMPLIANCE'


class OrgUpdateDefaultRepositoryPermissionAuditEntryPermission(Enum):
    """
    The default permission a repository can have in an Organization.
    """

    ADMIN = 'ADMIN'
    NONE = 'NONE'
    READ = 'READ'
    WRITE = 'WRITE'


class OrgUpdateMemberAuditEntryPermission(Enum):
    """
    The permissions available to members on an Organization.
    """

    ADMIN = 'ADMIN'
    READ = 'READ'


class OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility(Enum):
    """
    The permissions available for repository creation on an Organization.
    """

    ALL = 'ALL'
    INTERNAL = 'INTERNAL'
    NONE = 'NONE'
    PRIVATE = 'PRIVATE'
    PRIVATE_INTERNAL = 'PRIVATE_INTERNAL'
    PUBLIC = 'PUBLIC'
    PUBLIC_INTERNAL = 'PUBLIC_INTERNAL'
    PUBLIC_PRIVATE = 'PUBLIC_PRIVATE'


class OrganizationInvitationRole(Enum):
    """
    The possible organization invitation roles.
    """

    ADMIN = 'ADMIN'
    BILLING_MANAGER = 'BILLING_MANAGER'
    DIRECT_MEMBER = 'DIRECT_MEMBER'
    REINSTATE = 'REINSTATE'


class OrganizationInvitationSource(Enum):
    """
    The possible organization invitation sources.
    """

    MEMBER = 'MEMBER'
    SCIM = 'SCIM'
    UNKNOWN = 'UNKNOWN'


class OrganizationInvitationType(Enum):
    """
    The possible organization invitation types.
    """

    EMAIL = 'EMAIL'
    USER = 'USER'


class OrganizationMemberRole(Enum):
    """
    The possible roles within an organization for its members.
    """

    ADMIN = 'ADMIN'
    MEMBER = 'MEMBER'


class OrganizationMembersCanCreateRepositoriesSettingValue(Enum):
    """
    The possible values for the members can create repositories setting on an organization.
    """

    ALL = 'ALL'
    DISABLED = 'DISABLED'
    INTERNAL = 'INTERNAL'
    PRIVATE = 'PRIVATE'


class OrganizationMigrationState(Enum):
    """
    The Octoshift Organization migration state.
    """

    FAILED = 'FAILED'
    FAILED_VALIDATION = 'FAILED_VALIDATION'
    IN_PROGRESS = 'IN_PROGRESS'
    NOT_STARTED = 'NOT_STARTED'
    PENDING_VALIDATION = 'PENDING_VALIDATION'
    POST_REPO_MIGRATION = 'POST_REPO_MIGRATION'
    PRE_REPO_MIGRATION = 'PRE_REPO_MIGRATION'
    QUEUED = 'QUEUED'
    REPO_MIGRATION = 'REPO_MIGRATION'
    SUCCEEDED = 'SUCCEEDED'


class OrganizationOrderField(Enum):
    """
    Properties by which organization connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    LOGIN = 'LOGIN'


class PackageFileOrderField(Enum):
    """
    Properties by which package file connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class PackageOrderField(Enum):
    """
    Properties by which package connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class PackageType(Enum):
    """
    The possible types of a package.
    """

    DEBIAN = 'DEBIAN'
    DOCKER = 'DOCKER'
    MAVEN = 'MAVEN'
    NPM = 'NPM'
    NUGET = 'NUGET'
    PYPI = 'PYPI'
    RUBYGEMS = 'RUBYGEMS'


class PackageVersionOrderField(Enum):
    """
    Properties by which package version connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class PatchStatus(Enum):
    """
    The possible types of patch statuses.
    """

    ADDED = 'ADDED'
    CHANGED = 'CHANGED'
    COPIED = 'COPIED'
    DELETED = 'DELETED'
    MODIFIED = 'MODIFIED'
    RENAMED = 'RENAMED'


class PinnableItemType(Enum):
    """
    Represents items that can be pinned to a profile page or dashboard.
    """

    GIST = 'GIST'
    ISSUE = 'ISSUE'
    ORGANIZATION = 'ORGANIZATION'
    PROJECT = 'PROJECT'
    PULL_REQUEST = 'PULL_REQUEST'
    REPOSITORY = 'REPOSITORY'
    TEAM = 'TEAM'
    USER = 'USER'


class PinnedDiscussionGradient(Enum):
    """
    Preconfigured gradients that may be used to style discussions pinned within a repository.
    """

    BLUE_MINT = 'BLUE_MINT'
    BLUE_PURPLE = 'BLUE_PURPLE'
    PINK_BLUE = 'PINK_BLUE'
    PURPLE_CORAL = 'PURPLE_CORAL'
    RED_ORANGE = 'RED_ORANGE'


class PinnedDiscussionPattern(Enum):
    """
    Preconfigured background patterns that may be used to style discussions pinned within a repository.
    """

    CHEVRON_UP = 'CHEVRON_UP'
    DOT = 'DOT'
    DOT_FILL = 'DOT_FILL'
    HEART_FILL = 'HEART_FILL'
    PLUS = 'PLUS'
    ZAP = 'ZAP'


class ProjectCardArchivedState(Enum):
    """
    The possible archived states of a project card.
    """

    ARCHIVED = 'ARCHIVED'
    NOT_ARCHIVED = 'NOT_ARCHIVED'


class ProjectCardState(Enum):
    """
    Various content states of a ProjectCard
    """

    CONTENT_ONLY = 'CONTENT_ONLY'
    NOTE_ONLY = 'NOTE_ONLY'
    REDACTED = 'REDACTED'


class ProjectColumnPurpose(Enum):
    """
    The semantic purpose of the column - todo, in progress, or done.
    """

    DONE = 'DONE'
    IN_PROGRESS = 'IN_PROGRESS'
    TODO = 'TODO'


class ProjectOrderField(Enum):
    """
    Properties by which project connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NAME = 'NAME'
    UPDATED_AT = 'UPDATED_AT'


class ProjectState(Enum):
    """
    State of the project; either 'open' or 'closed'
    """

    CLOSED = 'CLOSED'
    OPEN = 'OPEN'


class ProjectTemplate(Enum):
    """
    GitHub-provided templates for Projects
    """

    AUTOMATED_KANBAN_V2 = 'AUTOMATED_KANBAN_V2'
    AUTOMATED_REVIEWS_KANBAN = 'AUTOMATED_REVIEWS_KANBAN'
    BASIC_KANBAN = 'BASIC_KANBAN'
    BUG_TRIAGE = 'BUG_TRIAGE'


class ProjectV2CustomFieldType(Enum):
    """
    The type of a project field.
    """

    DATE = 'DATE'
    NUMBER = 'NUMBER'
    SINGLE_SELECT = 'SINGLE_SELECT'
    TEXT = 'TEXT'


class ProjectV2FieldOrderField(Enum):
    """
    Properties by which project v2 field connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NAME = 'NAME'
    POSITION = 'POSITION'


class ProjectV2FieldType(Enum):
    """
    The type of a project field.
    """

    ASSIGNEES = 'ASSIGNEES'
    DATE = 'DATE'
    ITERATION = 'ITERATION'
    LABELS = 'LABELS'
    LINKED_PULL_REQUESTS = 'LINKED_PULL_REQUESTS'
    MILESTONE = 'MILESTONE'
    NUMBER = 'NUMBER'
    REPOSITORY = 'REPOSITORY'
    REVIEWERS = 'REVIEWERS'
    SINGLE_SELECT = 'SINGLE_SELECT'
    TEXT = 'TEXT'
    TITLE = 'TITLE'
    TRACKED_BY = 'TRACKED_BY'
    TRACKS = 'TRACKS'


class ProjectV2ItemFieldValueOrderField(Enum):
    """
    Properties by which project v2 item field value connections can be ordered.
    """

    POSITION = 'POSITION'


class ProjectV2ItemOrderField(Enum):
    """
    Properties by which project v2 item connections can be ordered.
    """

    POSITION = 'POSITION'


class ProjectV2ItemType(Enum):
    """
    The type of a project item.
    """

    DRAFT_ISSUE = 'DRAFT_ISSUE'
    ISSUE = 'ISSUE'
    PULL_REQUEST = 'PULL_REQUEST'
    REDACTED = 'REDACTED'


class ProjectV2OrderField(Enum):
    """
    Properties by which projects can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NUMBER = 'NUMBER'
    TITLE = 'TITLE'
    UPDATED_AT = 'UPDATED_AT'


class ProjectV2Roles(Enum):
    """
    The possible roles of a collaborator on a project.
    """

    ADMIN = 'ADMIN'
    NONE = 'NONE'
    READER = 'READER'
    WRITER = 'WRITER'


class ProjectV2SingleSelectFieldOptionColor(Enum):
    """
    The display color of a single-select field option.
    """

    BLUE = 'BLUE'
    GRAY = 'GRAY'
    GREEN = 'GREEN'
    ORANGE = 'ORANGE'
    PINK = 'PINK'
    PURPLE = 'PURPLE'
    RED = 'RED'
    YELLOW = 'YELLOW'


class ProjectV2State(Enum):
    """
    The possible states of a project v2.
    """

    CLOSED = 'CLOSED'
    OPEN = 'OPEN'


class ProjectV2ViewLayout(Enum):
    """
    The layout of a project v2 view.
    """

    BOARD_LAYOUT = 'BOARD_LAYOUT'
    ROADMAP_LAYOUT = 'ROADMAP_LAYOUT'
    TABLE_LAYOUT = 'TABLE_LAYOUT'


class ProjectV2ViewOrderField(Enum):
    """
    Properties by which project v2 view connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NAME = 'NAME'
    POSITION = 'POSITION'


class ProjectV2WorkflowsOrderField(Enum):
    """
    Properties by which project workflows can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NAME = 'NAME'
    NUMBER = 'NUMBER'
    UPDATED_AT = 'UPDATED_AT'


class PullRequestBranchUpdateMethod(Enum):
    """
    The possible methods for updating a pull request's head branch with the base branch.
    """

    MERGE = 'MERGE'
    REBASE = 'REBASE'


class PullRequestMergeMethod(Enum):
    """
    Represents available types of methods to use when merging a pull request.
    """

    MERGE = 'MERGE'
    REBASE = 'REBASE'
    SQUASH = 'SQUASH'


class PullRequestOrderField(Enum):
    """
    Properties by which pull_requests connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    UPDATED_AT = 'UPDATED_AT'


class PullRequestReviewCommentState(Enum):
    """
    The possible states of a pull request review comment.
    """

    PENDING = 'PENDING'
    SUBMITTED = 'SUBMITTED'


class PullRequestReviewDecision(Enum):
    """
    The review status of a pull request.
    """

    APPROVED = 'APPROVED'
    CHANGES_REQUESTED = 'CHANGES_REQUESTED'
    REVIEW_REQUIRED = 'REVIEW_REQUIRED'


class PullRequestReviewEvent(Enum):
    """
    The possible events to perform on a pull request review.
    """

    APPROVE = 'APPROVE'
    COMMENT = 'COMMENT'
    DISMISS = 'DISMISS'
    REQUEST_CHANGES = 'REQUEST_CHANGES'


class PullRequestReviewState(Enum):
    """
    The possible states of a pull request review.
    """

    APPROVED = 'APPROVED'
    CHANGES_REQUESTED = 'CHANGES_REQUESTED'
    COMMENTED = 'COMMENTED'
    DISMISSED = 'DISMISSED'
    PENDING = 'PENDING'


class PullRequestReviewThreadSubjectType(Enum):
    """
    The possible subject types of a pull request review comment.
    """

    FILE = 'FILE'
    LINE = 'LINE'


class PullRequestState(Enum):
    """
    The possible states of a pull request.
    """

    CLOSED = 'CLOSED'
    MERGED = 'MERGED'
    OPEN = 'OPEN'


class PullRequestTimelineItemsItemType(Enum):
    """
    The possible item types found in a timeline.
    """

    ADDED_TO_MERGE_QUEUE_EVENT = 'ADDED_TO_MERGE_QUEUE_EVENT'
    ADDED_TO_PROJECT_EVENT = 'ADDED_TO_PROJECT_EVENT'
    ASSIGNED_EVENT = 'ASSIGNED_EVENT'
    AUTOMATIC_BASE_CHANGE_FAILED_EVENT = 'AUTOMATIC_BASE_CHANGE_FAILED_EVENT'
    AUTOMATIC_BASE_CHANGE_SUCCEEDED_EVENT = 'AUTOMATIC_BASE_CHANGE_SUCCEEDED_EVENT'
    AUTO_MERGE_DISABLED_EVENT = 'AUTO_MERGE_DISABLED_EVENT'
    AUTO_MERGE_ENABLED_EVENT = 'AUTO_MERGE_ENABLED_EVENT'
    AUTO_REBASE_ENABLED_EVENT = 'AUTO_REBASE_ENABLED_EVENT'
    AUTO_SQUASH_ENABLED_EVENT = 'AUTO_SQUASH_ENABLED_EVENT'
    BASE_REF_CHANGED_EVENT = 'BASE_REF_CHANGED_EVENT'
    BASE_REF_DELETED_EVENT = 'BASE_REF_DELETED_EVENT'
    BASE_REF_FORCE_PUSHED_EVENT = 'BASE_REF_FORCE_PUSHED_EVENT'
    CLOSED_EVENT = 'CLOSED_EVENT'
    COMMENT_DELETED_EVENT = 'COMMENT_DELETED_EVENT'
    CONNECTED_EVENT = 'CONNECTED_EVENT'
    CONVERTED_NOTE_TO_ISSUE_EVENT = 'CONVERTED_NOTE_TO_ISSUE_EVENT'
    CONVERTED_TO_DISCUSSION_EVENT = 'CONVERTED_TO_DISCUSSION_EVENT'
    CONVERT_TO_DRAFT_EVENT = 'CONVERT_TO_DRAFT_EVENT'
    CROSS_REFERENCED_EVENT = 'CROSS_REFERENCED_EVENT'
    DEMILESTONED_EVENT = 'DEMILESTONED_EVENT'
    DEPLOYED_EVENT = 'DEPLOYED_EVENT'
    DEPLOYMENT_ENVIRONMENT_CHANGED_EVENT = 'DEPLOYMENT_ENVIRONMENT_CHANGED_EVENT'
    DISCONNECTED_EVENT = 'DISCONNECTED_EVENT'
    HEAD_REF_DELETED_EVENT = 'HEAD_REF_DELETED_EVENT'
    HEAD_REF_FORCE_PUSHED_EVENT = 'HEAD_REF_FORCE_PUSHED_EVENT'
    HEAD_REF_RESTORED_EVENT = 'HEAD_REF_RESTORED_EVENT'
    ISSUE_COMMENT = 'ISSUE_COMMENT'
    LABELED_EVENT = 'LABELED_EVENT'
    LOCKED_EVENT = 'LOCKED_EVENT'
    MARKED_AS_DUPLICATE_EVENT = 'MARKED_AS_DUPLICATE_EVENT'
    MENTIONED_EVENT = 'MENTIONED_EVENT'
    MERGED_EVENT = 'MERGED_EVENT'
    MILESTONED_EVENT = 'MILESTONED_EVENT'
    MOVED_COLUMNS_IN_PROJECT_EVENT = 'MOVED_COLUMNS_IN_PROJECT_EVENT'
    PINNED_EVENT = 'PINNED_EVENT'
    PULL_REQUEST_COMMIT = 'PULL_REQUEST_COMMIT'
    PULL_REQUEST_COMMIT_COMMENT_THREAD = 'PULL_REQUEST_COMMIT_COMMENT_THREAD'
    PULL_REQUEST_REVIEW = 'PULL_REQUEST_REVIEW'
    PULL_REQUEST_REVIEW_THREAD = 'PULL_REQUEST_REVIEW_THREAD'
    PULL_REQUEST_REVISION_MARKER = 'PULL_REQUEST_REVISION_MARKER'
    READY_FOR_REVIEW_EVENT = 'READY_FOR_REVIEW_EVENT'
    REFERENCED_EVENT = 'REFERENCED_EVENT'
    REMOVED_FROM_MERGE_QUEUE_EVENT = 'REMOVED_FROM_MERGE_QUEUE_EVENT'
    REMOVED_FROM_PROJECT_EVENT = 'REMOVED_FROM_PROJECT_EVENT'
    RENAMED_TITLE_EVENT = 'RENAMED_TITLE_EVENT'
    REOPENED_EVENT = 'REOPENED_EVENT'
    REVIEW_DISMISSED_EVENT = 'REVIEW_DISMISSED_EVENT'
    REVIEW_REQUESTED_EVENT = 'REVIEW_REQUESTED_EVENT'
    REVIEW_REQUEST_REMOVED_EVENT = 'REVIEW_REQUEST_REMOVED_EVENT'
    SUBSCRIBED_EVENT = 'SUBSCRIBED_EVENT'
    TRANSFERRED_EVENT = 'TRANSFERRED_EVENT'
    UNASSIGNED_EVENT = 'UNASSIGNED_EVENT'
    UNLABELED_EVENT = 'UNLABELED_EVENT'
    UNLOCKED_EVENT = 'UNLOCKED_EVENT'
    UNMARKED_AS_DUPLICATE_EVENT = 'UNMARKED_AS_DUPLICATE_EVENT'
    UNPINNED_EVENT = 'UNPINNED_EVENT'
    UNSUBSCRIBED_EVENT = 'UNSUBSCRIBED_EVENT'
    USER_BLOCKED_EVENT = 'USER_BLOCKED_EVENT'


class PullRequestUpdateState(Enum):
    """
    The possible target states when updating a pull request.
    """

    CLOSED = 'CLOSED'
    OPEN = 'OPEN'


class ReactionContent(Enum):
    """
    Emojis that can be attached to Issues, Pull Requests and Comments.
    """

    CONFUSED = 'CONFUSED'
    EYES = 'EYES'
    HEART = 'HEART'
    HOORAY = 'HOORAY'
    LAUGH = 'LAUGH'
    ROCKET = 'ROCKET'
    THUMBS_DOWN = 'THUMBS_DOWN'
    THUMBS_UP = 'THUMBS_UP'


class ReactionOrderField(Enum):
    """
    A list of fields that reactions can be ordered by.
    """

    CREATED_AT = 'CREATED_AT'


class RefOrderField(Enum):
    """
    Properties by which ref connections can be ordered.
    """

    ALPHABETICAL = 'ALPHABETICAL'
    TAG_COMMIT_DATE = 'TAG_COMMIT_DATE'


class ReleaseOrderField(Enum):
    """
    Properties by which release connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NAME = 'NAME'


class RepoAccessAuditEntryVisibility(Enum):
    """
    The privacy of a repository
    """

    INTERNAL = 'INTERNAL'
    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class RepoAddMemberAuditEntryVisibility(Enum):
    """
    The privacy of a repository
    """

    INTERNAL = 'INTERNAL'
    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class RepoArchivedAuditEntryVisibility(Enum):
    """
    The privacy of a repository
    """

    INTERNAL = 'INTERNAL'
    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class RepoChangeMergeSettingAuditEntryMergeType(Enum):
    """
    The merge options available for pull requests to this repository.
    """

    MERGE = 'MERGE'
    REBASE = 'REBASE'
    SQUASH = 'SQUASH'


class RepoCreateAuditEntryVisibility(Enum):
    """
    The privacy of a repository
    """

    INTERNAL = 'INTERNAL'
    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class RepoDestroyAuditEntryVisibility(Enum):
    """
    The privacy of a repository
    """

    INTERNAL = 'INTERNAL'
    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class RepoRemoveMemberAuditEntryVisibility(Enum):
    """
    The privacy of a repository
    """

    INTERNAL = 'INTERNAL'
    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class ReportedContentClassifiers(Enum):
    """
    The reasons a piece of content can be reported or minimized.
    """

    ABUSE = 'ABUSE'
    DUPLICATE = 'DUPLICATE'
    OFF_TOPIC = 'OFF_TOPIC'
    OUTDATED = 'OUTDATED'
    RESOLVED = 'RESOLVED'
    SPAM = 'SPAM'


class RepositoryAffiliation(Enum):
    """
    The affiliation of a user to a repository
    """

    COLLABORATOR = 'COLLABORATOR'
    ORGANIZATION_MEMBER = 'ORGANIZATION_MEMBER'
    OWNER = 'OWNER'


class RepositoryContributionType(Enum):
    """
    The reason a repository is listed as 'contributed'.
    """

    COMMIT = 'COMMIT'
    ISSUE = 'ISSUE'
    PULL_REQUEST = 'PULL_REQUEST'
    PULL_REQUEST_REVIEW = 'PULL_REQUEST_REVIEW'
    REPOSITORY = 'REPOSITORY'


class RepositoryInteractionLimit(Enum):
    """
    A repository interaction limit.
    """

    COLLABORATORS_ONLY = 'COLLABORATORS_ONLY'
    CONTRIBUTORS_ONLY = 'CONTRIBUTORS_ONLY'
    EXISTING_USERS = 'EXISTING_USERS'
    NO_LIMIT = 'NO_LIMIT'


class RepositoryInteractionLimitExpiry(Enum):
    """
    The length for a repository interaction limit to be enabled for.
    """

    ONE_DAY = 'ONE_DAY'
    ONE_MONTH = 'ONE_MONTH'
    ONE_WEEK = 'ONE_WEEK'
    SIX_MONTHS = 'SIX_MONTHS'
    THREE_DAYS = 'THREE_DAYS'


class RepositoryInteractionLimitOrigin(Enum):
    """
    Indicates where an interaction limit is configured.
    """

    ORGANIZATION = 'ORGANIZATION'
    REPOSITORY = 'REPOSITORY'
    USER = 'USER'


class RepositoryInvitationOrderField(Enum):
    """
    Properties by which repository invitation connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class RepositoryLockReason(Enum):
    """
    The possible reasons a given repository could be in a locked state.
    """

    BILLING = 'BILLING'
    MIGRATING = 'MIGRATING'
    MOVING = 'MOVING'
    RENAME = 'RENAME'
    TRADE_RESTRICTION = 'TRADE_RESTRICTION'
    TRANSFERRING_OWNERSHIP = 'TRANSFERRING_OWNERSHIP'


class RepositoryMigrationOrderDirection(Enum):
    """
    Possible directions in which to order a list of repository migrations when provided an `orderBy` argument.
    """

    ASC = 'ASC'
    DESC = 'DESC'


class RepositoryMigrationOrderField(Enum):
    """
    Properties by which repository migrations can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class RepositoryOrderField(Enum):
    """
    Properties by which repository connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NAME = 'NAME'
    PUSHED_AT = 'PUSHED_AT'
    STARGAZERS = 'STARGAZERS'
    UPDATED_AT = 'UPDATED_AT'


class RepositoryPermission(Enum):
    """
    The access level to a repository
    """

    ADMIN = 'ADMIN'
    MAINTAIN = 'MAINTAIN'
    READ = 'READ'
    TRIAGE = 'TRIAGE'
    WRITE = 'WRITE'


class RepositoryPrivacy(Enum):
    """
    The privacy of a repository
    """

    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class RepositoryRuleType(Enum):
    """
    The rule types supported in rulesets
    """

    AUTHORIZATION = 'AUTHORIZATION'
    BRANCH_NAME_PATTERN = 'BRANCH_NAME_PATTERN'
    COMMITTER_EMAIL_PATTERN = 'COMMITTER_EMAIL_PATTERN'
    COMMIT_AUTHOR_EMAIL_PATTERN = 'COMMIT_AUTHOR_EMAIL_PATTERN'
    COMMIT_MESSAGE_PATTERN = 'COMMIT_MESSAGE_PATTERN'
    CREATION = 'CREATION'
    DELETION = 'DELETION'
    LOCK_BRANCH = 'LOCK_BRANCH'
    MAX_REF_UPDATES = 'MAX_REF_UPDATES'
    MERGE_QUEUE = 'MERGE_QUEUE'
    MERGE_QUEUE_LOCKED_REF = 'MERGE_QUEUE_LOCKED_REF'
    NON_FAST_FORWARD = 'NON_FAST_FORWARD'
    PULL_REQUEST = 'PULL_REQUEST'
    REQUIRED_DEPLOYMENTS = 'REQUIRED_DEPLOYMENTS'
    REQUIRED_LINEAR_HISTORY = 'REQUIRED_LINEAR_HISTORY'
    REQUIRED_REVIEW_THREAD_RESOLUTION = 'REQUIRED_REVIEW_THREAD_RESOLUTION'
    REQUIRED_SIGNATURES = 'REQUIRED_SIGNATURES'
    REQUIRED_STATUS_CHECKS = 'REQUIRED_STATUS_CHECKS'
    REQUIRED_WORKFLOW_STATUS_CHECKS = 'REQUIRED_WORKFLOW_STATUS_CHECKS'
    RULESET_REQUIRED_SIGNATURES = 'RULESET_REQUIRED_SIGNATURES'
    SECRET_SCANNING = 'SECRET_SCANNING'
    TAG = 'TAG'
    TAG_NAME_PATTERN = 'TAG_NAME_PATTERN'
    UPDATE = 'UPDATE'
    WORKFLOWS = 'WORKFLOWS'
    WORKFLOW_UPDATES = 'WORKFLOW_UPDATES'


class RepositoryRulesetBypassActorBypassMode(Enum):
    """
    The bypass mode for a specific actor on a ruleset.
    """

    ALWAYS = 'ALWAYS'
    PULL_REQUEST = 'PULL_REQUEST'


class RepositoryRulesetTarget(Enum):
    """
    The targets supported for rulesets
    """

    BRANCH = 'BRANCH'
    TAG = 'TAG'


class RepositoryVisibility(Enum):
    """
    The repository's visibility level.
    """

    INTERNAL = 'INTERNAL'
    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class RepositoryVulnerabilityAlertDependencyScope(Enum):
    """
    The possible scopes of an alert's dependency.
    """

    DEVELOPMENT = 'DEVELOPMENT'
    RUNTIME = 'RUNTIME'


class RepositoryVulnerabilityAlertState(Enum):
    """
    The possible states of an alert
    """

    AUTO_DISMISSED = 'AUTO_DISMISSED'
    DISMISSED = 'DISMISSED'
    FIXED = 'FIXED'
    OPEN = 'OPEN'


class RequestableCheckStatusState(Enum):
    """
    The possible states that can be requested when creating a check run.
    """

    COMPLETED = 'COMPLETED'
    IN_PROGRESS = 'IN_PROGRESS'
    PENDING = 'PENDING'
    QUEUED = 'QUEUED'
    WAITING = 'WAITING'


class RoleInOrganization(Enum):
    """
    Possible roles a user may have in relation to an organization.
    """

    DIRECT_MEMBER = 'DIRECT_MEMBER'
    OWNER = 'OWNER'
    UNAFFILIATED = 'UNAFFILIATED'


class RuleEnforcement(Enum):
    """
    The level of enforcement for a rule or ruleset.
    """

    ACTIVE = 'ACTIVE'
    DISABLED = 'DISABLED'
    EVALUATE = 'EVALUATE'


class SamlDigestAlgorithm(Enum):
    """
    The possible digest algorithms used to sign SAML requests for an identity provider.
    """

    SHA1 = 'SHA1'
    SHA256 = 'SHA256'
    SHA384 = 'SHA384'
    SHA512 = 'SHA512'


class SamlSignatureAlgorithm(Enum):
    """
    The possible signature algorithms used to sign SAML requests for a Identity Provider.
    """

    RSA_SHA1 = 'RSA_SHA1'
    RSA_SHA256 = 'RSA_SHA256'
    RSA_SHA384 = 'RSA_SHA384'
    RSA_SHA512 = 'RSA_SHA512'


class SavedReplyOrderField(Enum):
    """
    Properties by which saved reply connections can be ordered.
    """

    UPDATED_AT = 'UPDATED_AT'


class SearchType(Enum):
    """
    Represents the individual results of a search.
    """

    DISCUSSION = 'DISCUSSION'
    ISSUE = 'ISSUE'
    REPOSITORY = 'REPOSITORY'
    USER = 'USER'


class SecurityAdvisoryClassification(Enum):
    """
    Classification of the advisory.
    """

    GENERAL = 'GENERAL'
    MALWARE = 'MALWARE'


class SecurityAdvisoryEcosystem(Enum):
    """
    The possible ecosystems of a security vulnerability's package.
    """

    ACTIONS = 'ACTIONS'
    COMPOSER = 'COMPOSER'
    ERLANG = 'ERLANG'
    GO = 'GO'
    MAVEN = 'MAVEN'
    NPM = 'NPM'
    NUGET = 'NUGET'
    PIP = 'PIP'
    PUB = 'PUB'
    RUBYGEMS = 'RUBYGEMS'
    RUST = 'RUST'
    SWIFT = 'SWIFT'


class SecurityAdvisoryIdentifierType(Enum):
    """
    Identifier formats available for advisories.
    """

    CVE = 'CVE'
    GHSA = 'GHSA'


class SecurityAdvisoryOrderField(Enum):
    """
    Properties by which security advisory connections can be ordered.
    """

    PUBLISHED_AT = 'PUBLISHED_AT'
    UPDATED_AT = 'UPDATED_AT'


class SecurityAdvisorySeverity(Enum):
    """
    Severity of the vulnerability.
    """

    CRITICAL = 'CRITICAL'
    HIGH = 'HIGH'
    LOW = 'LOW'
    MODERATE = 'MODERATE'


class SecurityVulnerabilityOrderField(Enum):
    """
    Properties by which security vulnerability connections can be ordered.
    """

    UPDATED_AT = 'UPDATED_AT'


class SocialAccountProvider(Enum):
    """
    Software or company that hosts social media accounts.
    """

    FACEBOOK = 'FACEBOOK'
    GENERIC = 'GENERIC'
    HOMETOWN = 'HOMETOWN'
    INSTAGRAM = 'INSTAGRAM'
    LINKEDIN = 'LINKEDIN'
    MASTODON = 'MASTODON'
    NPM = 'NPM'
    REDDIT = 'REDDIT'
    TWITCH = 'TWITCH'
    TWITTER = 'TWITTER'
    YOUTUBE = 'YOUTUBE'


class SponsorOrderField(Enum):
    """
    Properties by which sponsor connections can be ordered.
    """

    LOGIN = 'LOGIN'
    RELEVANCE = 'RELEVANCE'


class SponsorableOrderField(Enum):
    """
    Properties by which sponsorable connections can be ordered.
    """

    LOGIN = 'LOGIN'


class SponsorsActivityAction(Enum):
    """
    The possible actions that GitHub Sponsors activities can represent.
    """

    CANCELLED_SPONSORSHIP = 'CANCELLED_SPONSORSHIP'
    NEW_SPONSORSHIP = 'NEW_SPONSORSHIP'
    PENDING_CHANGE = 'PENDING_CHANGE'
    REFUND = 'REFUND'
    SPONSOR_MATCH_DISABLED = 'SPONSOR_MATCH_DISABLED'
    TIER_CHANGE = 'TIER_CHANGE'


class SponsorsActivityOrderField(Enum):
    """
    Properties by which GitHub Sponsors activity connections can be ordered.
    """

    TIMESTAMP = 'TIMESTAMP'


class SponsorsActivityPeriod(Enum):
    """
    The possible time periods for which Sponsors activities can be requested.
    """

    ALL = 'ALL'
    DAY = 'DAY'
    MONTH = 'MONTH'
    WEEK = 'WEEK'


class SponsorsCountryOrRegionCode(Enum):
    """
    Represents countries or regions for billing and residence for a GitHub Sponsors profile.
    """

    AD = 'AD'
    AE = 'AE'
    AF = 'AF'
    AG = 'AG'
    AI = 'AI'
    AL = 'AL'
    AM = 'AM'
    AO = 'AO'
    AQ = 'AQ'
    AR = 'AR'
    AS = 'AS'
    AT = 'AT'
    AU = 'AU'
    AW = 'AW'
    AX = 'AX'
    AZ = 'AZ'
    BA = 'BA'
    BB = 'BB'
    BD = 'BD'
    BE = 'BE'
    BF = 'BF'
    BG = 'BG'
    BH = 'BH'
    BI = 'BI'
    BJ = 'BJ'
    BL = 'BL'
    BM = 'BM'
    BN = 'BN'
    BO = 'BO'
    BQ = 'BQ'
    BR = 'BR'
    BS = 'BS'
    BT = 'BT'
    BV = 'BV'
    BW = 'BW'
    BY = 'BY'
    BZ = 'BZ'
    CA = 'CA'
    CC = 'CC'
    CD = 'CD'
    CF = 'CF'
    CG = 'CG'
    CH = 'CH'
    CI = 'CI'
    CK = 'CK'
    CL = 'CL'
    CM = 'CM'
    CN = 'CN'
    CO = 'CO'
    CR = 'CR'
    CV = 'CV'
    CW = 'CW'
    CX = 'CX'
    CY = 'CY'
    CZ = 'CZ'
    DE = 'DE'
    DJ = 'DJ'
    DK = 'DK'
    DM = 'DM'
    DO = 'DO'
    DZ = 'DZ'
    EC = 'EC'
    EE = 'EE'
    EG = 'EG'
    EH = 'EH'
    ER = 'ER'
    ES = 'ES'
    ET = 'ET'
    FI = 'FI'
    FJ = 'FJ'
    FK = 'FK'
    FM = 'FM'
    FO = 'FO'
    FR = 'FR'
    GA = 'GA'
    GB = 'GB'
    GD = 'GD'
    GE = 'GE'
    GF = 'GF'
    GG = 'GG'
    GH = 'GH'
    GI = 'GI'
    GL = 'GL'
    GM = 'GM'
    GN = 'GN'
    GP = 'GP'
    GQ = 'GQ'
    GR = 'GR'
    GS = 'GS'
    GT = 'GT'
    GU = 'GU'
    GW = 'GW'
    GY = 'GY'
    HK = 'HK'
    HM = 'HM'
    HN = 'HN'
    HR = 'HR'
    HT = 'HT'
    HU = 'HU'
    ID = 'ID'
    IE = 'IE'
    IL = 'IL'
    IM = 'IM'
    IN = 'IN'
    IO = 'IO'
    IQ = 'IQ'
    IR = 'IR'
    IS = 'IS'
    IT = 'IT'
    JE = 'JE'
    JM = 'JM'
    JO = 'JO'
    JP = 'JP'
    KE = 'KE'
    KG = 'KG'
    KH = 'KH'
    KI = 'KI'
    KM = 'KM'
    KN = 'KN'
    KR = 'KR'
    KW = 'KW'
    KY = 'KY'
    KZ = 'KZ'
    LA = 'LA'
    LB = 'LB'
    LC = 'LC'
    LI = 'LI'
    LK = 'LK'
    LR = 'LR'
    LS = 'LS'
    LT = 'LT'
    LU = 'LU'
    LV = 'LV'
    LY = 'LY'
    MA = 'MA'
    MC = 'MC'
    MD = 'MD'
    ME = 'ME'
    MF = 'MF'
    MG = 'MG'
    MH = 'MH'
    MK = 'MK'
    ML = 'ML'
    MM = 'MM'
    MN = 'MN'
    MO = 'MO'
    MP = 'MP'
    MQ = 'MQ'
    MR = 'MR'
    MS = 'MS'
    MT = 'MT'
    MU = 'MU'
    MV = 'MV'
    MW = 'MW'
    MX = 'MX'
    MY = 'MY'
    MZ = 'MZ'
    NA = 'NA'
    NC = 'NC'
    NE = 'NE'
    NF = 'NF'
    NG = 'NG'
    NI = 'NI'
    NL = 'NL'
    NO = 'NO'
    NP = 'NP'
    NR = 'NR'
    NU = 'NU'
    NZ = 'NZ'
    OM = 'OM'
    PA = 'PA'
    PE = 'PE'
    PF = 'PF'
    PG = 'PG'
    PH = 'PH'
    PK = 'PK'
    PL = 'PL'
    PM = 'PM'
    PN = 'PN'
    PR = 'PR'
    PS = 'PS'
    PT = 'PT'
    PW = 'PW'
    PY = 'PY'
    QA = 'QA'
    RE = 'RE'
    RO = 'RO'
    RS = 'RS'
    RU = 'RU'
    RW = 'RW'
    SA = 'SA'
    SB = 'SB'
    SC = 'SC'
    SD = 'SD'
    SE = 'SE'
    SG = 'SG'
    SH = 'SH'
    SI = 'SI'
    SJ = 'SJ'
    SK = 'SK'
    SL = 'SL'
    SM = 'SM'
    SN = 'SN'
    SO = 'SO'
    SR = 'SR'
    SS = 'SS'
    ST = 'ST'
    SV = 'SV'
    SX = 'SX'
    SZ = 'SZ'
    TC = 'TC'
    TD = 'TD'
    TF = 'TF'
    TG = 'TG'
    TH = 'TH'
    TJ = 'TJ'
    TK = 'TK'
    TL = 'TL'
    TM = 'TM'
    TN = 'TN'
    TO = 'TO'
    TR = 'TR'
    TT = 'TT'
    TV = 'TV'
    TW = 'TW'
    TZ = 'TZ'
    UA = 'UA'
    UG = 'UG'
    UM = 'UM'
    US = 'US'
    UY = 'UY'
    UZ = 'UZ'
    VA = 'VA'
    VC = 'VC'
    VE = 'VE'
    VG = 'VG'
    VI = 'VI'
    VN = 'VN'
    VU = 'VU'
    WF = 'WF'
    WS = 'WS'
    YE = 'YE'
    YT = 'YT'
    ZA = 'ZA'
    ZM = 'ZM'
    ZW = 'ZW'


class SponsorsGoalKind(Enum):
    """
    The different kinds of goals a GitHub Sponsors member can have.
    """

    MONTHLY_SPONSORSHIP_AMOUNT = 'MONTHLY_SPONSORSHIP_AMOUNT'
    TOTAL_SPONSORS_COUNT = 'TOTAL_SPONSORS_COUNT'


class SponsorsListingFeaturedItemFeatureableType(Enum):
    """
    The different kinds of records that can be featured on a GitHub Sponsors profile page.
    """

    REPOSITORY = 'REPOSITORY'
    USER = 'USER'


class SponsorsTierOrderField(Enum):
    """
    Properties by which Sponsors tiers connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    MONTHLY_PRICE_IN_CENTS = 'MONTHLY_PRICE_IN_CENTS'


class SponsorshipNewsletterOrderField(Enum):
    """
    Properties by which sponsorship update connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class SponsorshipOrderField(Enum):
    """
    Properties by which sponsorship connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class SponsorshipPaymentSource(Enum):
    """
    How payment was made for funding a GitHub Sponsors sponsorship.
    """

    GITHUB = 'GITHUB'
    PATREON = 'PATREON'


class SponsorshipPrivacy(Enum):
    """
    The privacy of a sponsorship
    """

    PRIVATE = 'PRIVATE'
    PUBLIC = 'PUBLIC'


class SquashMergeCommitMessage(Enum):
    """
    The possible default commit messages for squash merges.
    """

    BLANK = 'BLANK'
    COMMIT_MESSAGES = 'COMMIT_MESSAGES'
    PR_BODY = 'PR_BODY'


class SquashMergeCommitTitle(Enum):
    """
    The possible default commit titles for squash merges.
    """

    COMMIT_OR_PR_TITLE = 'COMMIT_OR_PR_TITLE'
    PR_TITLE = 'PR_TITLE'


class StarOrderField(Enum):
    """
    Properties by which star connections can be ordered.
    """

    STARRED_AT = 'STARRED_AT'


class StatusState(Enum):
    """
    The possible commit status states.
    """

    ERROR = 'ERROR'
    EXPECTED = 'EXPECTED'
    FAILURE = 'FAILURE'
    PENDING = 'PENDING'
    SUCCESS = 'SUCCESS'


class SubscriptionState(Enum):
    """
    The possible states of a subscription.
    """

    IGNORED = 'IGNORED'
    SUBSCRIBED = 'SUBSCRIBED'
    UNSUBSCRIBED = 'UNSUBSCRIBED'


class TeamDiscussionCommentOrderField(Enum):
    """
    Properties by which team discussion comment connections can be ordered.
    """

    NUMBER = 'NUMBER'


class TeamDiscussionOrderField(Enum):
    """
    Properties by which team discussion connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class TeamMemberOrderField(Enum):
    """
    Properties by which team member connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    LOGIN = 'LOGIN'


class TeamMemberRole(Enum):
    """
    The possible team member roles; either 'maintainer' or 'member'.
    """

    MAINTAINER = 'MAINTAINER'
    MEMBER = 'MEMBER'


class TeamMembershipType(Enum):
    """
    Defines which types of team members are included in the returned list. Can be one of IMMEDIATE, CHILD_TEAM or ALL.
    """

    ALL = 'ALL'
    CHILD_TEAM = 'CHILD_TEAM'
    IMMEDIATE = 'IMMEDIATE'


class TeamNotificationSetting(Enum):
    """
    The possible team notification values.
    """

    NOTIFICATIONS_DISABLED = 'NOTIFICATIONS_DISABLED'
    NOTIFICATIONS_ENABLED = 'NOTIFICATIONS_ENABLED'


class TeamOrderField(Enum):
    """
    Properties by which team connections can be ordered.
    """

    NAME = 'NAME'


class TeamPrivacy(Enum):
    """
    The possible team privacy values.
    """

    SECRET = 'SECRET'
    VISIBLE = 'VISIBLE'


class TeamRepositoryOrderField(Enum):
    """
    Properties by which team repository connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    NAME = 'NAME'
    PERMISSION = 'PERMISSION'
    PUSHED_AT = 'PUSHED_AT'
    STARGAZERS = 'STARGAZERS'
    UPDATED_AT = 'UPDATED_AT'


class TeamReviewAssignmentAlgorithm(Enum):
    """
    The possible team review assignment algorithms
    """

    LOAD_BALANCE = 'LOAD_BALANCE'
    ROUND_ROBIN = 'ROUND_ROBIN'


class TeamRole(Enum):
    """
    The role of a user on a team.
    """

    ADMIN = 'ADMIN'
    MEMBER = 'MEMBER'


class ThreadSubscriptionFormAction(Enum):
    """
    The possible states of a thread subscription form action
    """

    NONE = 'NONE'
    SUBSCRIBE = 'SUBSCRIBE'
    UNSUBSCRIBE = 'UNSUBSCRIBE'


class ThreadSubscriptionState(Enum):
    """
    The possible states of a subscription.
    """

    DISABLED = 'DISABLED'
    IGNORING_LIST = 'IGNORING_LIST'
    IGNORING_THREAD = 'IGNORING_THREAD'
    NONE = 'NONE'
    SUBSCRIBED_TO_LIST = 'SUBSCRIBED_TO_LIST'
    SUBSCRIBED_TO_THREAD = 'SUBSCRIBED_TO_THREAD'
    SUBSCRIBED_TO_THREAD_EVENTS = 'SUBSCRIBED_TO_THREAD_EVENTS'
    SUBSCRIBED_TO_THREAD_TYPE = 'SUBSCRIBED_TO_THREAD_TYPE'
    UNAVAILABLE = 'UNAVAILABLE'


class TopicSuggestionDeclineReason(Enum):
    """
    Reason that the suggested topic is declined.
    """

    NOT_RELEVANT = 'NOT_RELEVANT'
    PERSONAL_PREFERENCE = 'PERSONAL_PREFERENCE'
    TOO_GENERAL = 'TOO_GENERAL'
    TOO_SPECIFIC = 'TOO_SPECIFIC'


class TrackedIssueStates(Enum):
    """
    The possible states of a tracked issue.
    """

    CLOSED = 'CLOSED'
    OPEN = 'OPEN'


class UserBlockDuration(Enum):
    """
    The possible durations that a user can be blocked for.
    """

    ONE_DAY = 'ONE_DAY'
    ONE_MONTH = 'ONE_MONTH'
    ONE_WEEK = 'ONE_WEEK'
    PERMANENT = 'PERMANENT'
    THREE_DAYS = 'THREE_DAYS'


class UserStatusOrderField(Enum):
    """
    Properties by which user status connections can be ordered.
    """

    UPDATED_AT = 'UPDATED_AT'


class VerifiableDomainOrderField(Enum):
    """
    Properties by which verifiable domain connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'
    DOMAIN = 'DOMAIN'


class WorkflowRunOrderField(Enum):
    """
    Properties by which workflow run connections can be ordered.
    """

    CREATED_AT = 'CREATED_AT'


class WorkflowState(Enum):
    """
    The possible states for a workflow.
    """

    ACTIVE = 'ACTIVE'
    DELETED = 'DELETED'
    DISABLED_FORK = 'DISABLED_FORK'
    DISABLED_INACTIVITY = 'DISABLED_INACTIVITY'
    DISABLED_MANUALLY = 'DISABLED_MANUALLY'


class Actor(BaseModel):
    """
    Represents an object which can take actions on GitHub. Typically a User or Bot.
    """

    avatarUrl: URI
    login: String
    resourcePath: URI
    url: URI
    typename__: Optional[Literal['Actor']] = Field('Actor', alias='__typename')


class AnnouncementBanner(BaseModel):
    """
    Represents an announcement banner.
    """

    announcement: Optional[String] = None
    announcementExpiresAt: Optional[DateTime] = None
    announcementUserDismissible: Optional[Boolean] = None
    typename__: Optional[Literal['AnnouncementBanner']] = Field(
        'AnnouncementBanner', alias='__typename'
    )


class Assignable(BaseModel):
    """
    An object that can have users assigned to it.
    """

    assignees: UserConnection
    typename__: Optional[Literal['Assignable']] = Field(
        'Assignable', alias='__typename'
    )


class AuditEntry(BaseModel):
    """
    An entry in the audit log.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    operationType: Optional[OperationType] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['AuditEntry']] = Field(
        'AuditEntry', alias='__typename'
    )


class Closable(BaseModel):
    """
    An object that can be closed
    """

    closed: Boolean
    closedAt: Optional[DateTime] = None
    viewerCanClose: Boolean
    viewerCanReopen: Boolean
    typename__: Optional[Literal['Closable']] = Field('Closable', alias='__typename')


class Comment(BaseModel):
    """
    Represents a comment.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    createdAt: DateTime
    createdViaEmail: Boolean
    editor: Optional[Actor] = None
    id: ID
    includesCreatedEdit: Boolean
    lastEditedAt: Optional[DateTime] = None
    publishedAt: Optional[DateTime] = None
    updatedAt: DateTime
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerDidAuthor: Boolean
    typename__: Optional[Literal['Comment']] = Field('Comment', alias='__typename')


class Contribution(BaseModel):
    """
    Represents a contribution a user made on GitHub, such as opening an issue.
    """

    isRestricted: Boolean
    occurredAt: DateTime
    resourcePath: URI
    url: URI
    user: User
    typename__: Optional[Literal['Contribution']] = Field(
        'Contribution', alias='__typename'
    )


class Deletable(BaseModel):
    """
    Entities that can be deleted.
    """

    viewerCanDelete: Boolean
    typename__: Optional[Literal['Deletable']] = Field('Deletable', alias='__typename')


class EnterpriseAuditEntryData(BaseModel):
    """
    Metadata for an audit entry containing enterprise account information.
    """

    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    typename__: Optional[Literal['EnterpriseAuditEntryData']] = Field(
        'EnterpriseAuditEntryData', alias='__typename'
    )


class GitObject(BaseModel):
    """
    Represents a Git object.
    """

    abbreviatedOid: String
    commitResourcePath: URI
    commitUrl: URI
    id: ID
    oid: GitObjectID
    repository: Repository
    typename__: Optional[Literal['GitObject']] = Field('GitObject', alias='__typename')


class GitSignature(BaseModel):
    """
    Information about a signature (GPG or S/MIME) on a Commit or Tag.
    """

    email: String
    isValid: Boolean
    payload: String
    signature: String
    signer: Optional[User] = None
    state: GitSignatureState
    wasSignedByGitHub: Boolean
    typename__: Optional[Literal['GitSignature']] = Field(
        'GitSignature', alias='__typename'
    )


class HovercardContext(BaseModel):
    """
    An individual line of a hovercard
    """

    message: String
    octicon: String
    typename__: Optional[Literal['HovercardContext']] = Field(
        'HovercardContext', alias='__typename'
    )


class Labelable(BaseModel):
    """
    An object that can have labels assigned to it.
    """

    labels: Optional[LabelConnection] = None
    typename__: Optional[Literal['Labelable']] = Field('Labelable', alias='__typename')


class Lockable(BaseModel):
    """
    An object that can be locked.
    """

    activeLockReason: Optional[LockReason] = None
    locked: Boolean
    typename__: Optional[Literal['Lockable']] = Field('Lockable', alias='__typename')


class MemberStatusable(BaseModel):
    """
    Entities that have members who can set status messages.
    """

    memberStatuses: UserStatusConnection
    typename__: Optional[Literal['MemberStatusable']] = Field(
        'MemberStatusable', alias='__typename'
    )


class Migration(BaseModel):
    """
    Represents a GitHub Enterprise Importer (GEI) migration.
    """

    continueOnError: Boolean
    createdAt: DateTime
    databaseId: Optional[String] = None
    failureReason: Optional[String] = None
    id: ID
    migrationLogUrl: Optional[URI] = None
    migrationSource: MigrationSource
    repositoryName: String
    sourceUrl: URI
    state: MigrationState
    warningsCount: Int
    typename__: Optional[Literal['Migration']] = Field('Migration', alias='__typename')


class Minimizable(BaseModel):
    """
    Entities that can be minimized.
    """

    isMinimized: Boolean
    minimizedReason: Optional[String] = None
    viewerCanMinimize: Boolean
    typename__: Optional[Literal['Minimizable']] = Field(
        'Minimizable', alias='__typename'
    )


class Node(BaseModel):
    """
    An object with an ID.
    """

    id: ID
    typename__: Optional[Literal['Node']] = Field('Node', alias='__typename')


class OauthApplicationAuditEntryData(BaseModel):
    """
    Metadata for an audit entry with action oauth_application.*
    """

    oauthApplicationName: Optional[String] = None
    oauthApplicationResourcePath: Optional[URI] = None
    oauthApplicationUrl: Optional[URI] = None
    typename__: Optional[Literal['OauthApplicationAuditEntryData']] = Field(
        'OauthApplicationAuditEntryData', alias='__typename'
    )


class OrganizationAuditEntryData(BaseModel):
    """
    Metadata for an audit entry with action org.*
    """

    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    typename__: Optional[Literal['OrganizationAuditEntryData']] = Field(
        'OrganizationAuditEntryData', alias='__typename'
    )


class PackageOwner(BaseModel):
    """
    Represents an owner of a package.
    """

    id: ID
    packages: PackageConnection
    typename__: Optional[Literal['PackageOwner']] = Field(
        'PackageOwner', alias='__typename'
    )


class ProfileOwner(BaseModel):
    """
    Represents any entity on GitHub that has a profile page.
    """

    anyPinnableItems: Boolean
    email: Optional[String] = None
    id: ID
    itemShowcase: ProfileItemShowcase
    location: Optional[String] = None
    login: String
    name: Optional[String] = None
    pinnableItems: PinnableItemConnection
    pinnedItems: PinnableItemConnection
    pinnedItemsRemaining: Int
    viewerCanChangePinnedItems: Boolean
    websiteUrl: Optional[URI] = None
    typename__: Optional[Literal['ProfileOwner']] = Field(
        'ProfileOwner', alias='__typename'
    )


class ProjectOwner(BaseModel):
    """
    Represents an owner of a Project.
    """

    id: ID
    project: Optional[Project] = None
    projects: ProjectConnection
    projectsResourcePath: URI
    projectsUrl: URI
    viewerCanCreateProjects: Boolean
    typename__: Optional[Literal['ProjectOwner']] = Field(
        'ProjectOwner', alias='__typename'
    )


class ProjectV2FieldCommon(BaseModel):
    """
    Common fields across different project field types
    """

    createdAt: DateTime
    dataType: ProjectV2FieldType
    databaseId: Optional[Int] = None
    id: ID
    name: String
    project: ProjectV2
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2FieldCommon']] = Field(
        'ProjectV2FieldCommon', alias='__typename'
    )


class ProjectV2ItemFieldValueCommon(BaseModel):
    """
    Common fields across different project field value types
    """

    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    field: ProjectV2FieldConfiguration
    id: ID
    item: ProjectV2Item
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2ItemFieldValueCommon']] = Field(
        'ProjectV2ItemFieldValueCommon', alias='__typename'
    )


class ProjectV2Owner(BaseModel):
    """
    Represents an owner of a project (beta).
    """

    id: ID
    projectV2: Optional[ProjectV2] = None
    projectsV2: ProjectV2Connection
    typename__: Optional[Literal['ProjectV2Owner']] = Field(
        'ProjectV2Owner', alias='__typename'
    )


class ProjectV2Recent(BaseModel):
    """
    Recent projects for the owner.
    """

    recentProjects: ProjectV2Connection
    typename__: Optional[Literal['ProjectV2Recent']] = Field(
        'ProjectV2Recent', alias='__typename'
    )


class Reactable(BaseModel):
    """
    Represents a subject that can be reacted on.
    """

    databaseId: Optional[Int] = None
    id: ID
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    viewerCanReact: Boolean
    typename__: Optional[Literal['Reactable']] = Field('Reactable', alias='__typename')


class RepositoryAuditEntryData(BaseModel):
    """
    Metadata for an audit entry with action repo.*
    """

    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    typename__: Optional[Literal['RepositoryAuditEntryData']] = Field(
        'RepositoryAuditEntryData', alias='__typename'
    )


class RepositoryDiscussionAuthor(BaseModel):
    """
    Represents an author of discussions in repositories.
    """

    repositoryDiscussions: DiscussionConnection
    typename__: Optional[Literal['RepositoryDiscussionAuthor']] = Field(
        'RepositoryDiscussionAuthor', alias='__typename'
    )


class RepositoryDiscussionCommentAuthor(BaseModel):
    """
    Represents an author of discussion comments in repositories.
    """

    repositoryDiscussionComments: DiscussionCommentConnection
    typename__: Optional[Literal['RepositoryDiscussionCommentAuthor']] = Field(
        'RepositoryDiscussionCommentAuthor', alias='__typename'
    )


class RepositoryInfo(BaseModel):
    """
    A subset of repository info.
    """

    archivedAt: Optional[DateTime] = None
    createdAt: DateTime
    description: Optional[String] = None
    descriptionHTML: HTML
    forkCount: Int
    hasDiscussionsEnabled: Boolean
    hasIssuesEnabled: Boolean
    hasProjectsEnabled: Boolean
    hasWikiEnabled: Boolean
    homepageUrl: Optional[URI] = None
    isArchived: Boolean
    isFork: Boolean
    isInOrganization: Boolean
    isLocked: Boolean
    isMirror: Boolean
    isPrivate: Boolean
    isTemplate: Boolean
    licenseInfo: Optional[License] = None
    lockReason: Optional[RepositoryLockReason] = None
    mirrorUrl: Optional[URI] = None
    name: String
    nameWithOwner: String
    openGraphImageUrl: URI
    owner: RepositoryOwner
    pushedAt: Optional[DateTime] = None
    resourcePath: URI
    shortDescriptionHTML: HTML
    updatedAt: DateTime
    url: URI
    usesCustomOpenGraphImage: Boolean
    visibility: RepositoryVisibility
    typename__: Optional[Literal['RepositoryInfo']] = Field(
        'RepositoryInfo', alias='__typename'
    )


class RepositoryNode(BaseModel):
    """
    Represents a object that belongs to a repository.
    """

    repository: Repository
    typename__: Optional[Literal['RepositoryNode']] = Field(
        'RepositoryNode', alias='__typename'
    )


class RepositoryOwner(BaseModel):
    """
    Represents an owner of a Repository.
    """

    avatarUrl: URI
    id: ID
    login: String
    repositories: RepositoryConnection
    repository: Optional[Repository] = None
    resourcePath: URI
    url: URI
    typename__: Optional[Literal['RepositoryOwner']] = Field(
        'RepositoryOwner', alias='__typename'
    )


class RequirableByPullRequest(BaseModel):
    """
    Represents a type that can be required by a pull request for merging.
    """

    isRequired: Boolean
    typename__: Optional[Literal['RequirableByPullRequest']] = Field(
        'RequirableByPullRequest', alias='__typename'
    )


class Sponsorable(BaseModel):
    """
    Entities that can sponsor or be sponsored through GitHub Sponsors.
    """

    estimatedNextSponsorsPayoutInCents: Int
    hasSponsorsListing: Boolean
    isSponsoredBy: Boolean
    isSponsoringViewer: Boolean
    monthlyEstimatedSponsorsIncomeInCents: Int
    sponsoring: SponsorConnection
    sponsors: SponsorConnection
    sponsorsActivities: SponsorsActivityConnection
    sponsorsListing: Optional[SponsorsListing] = None
    sponsorshipForViewerAsSponsor: Optional[Sponsorship] = None
    sponsorshipForViewerAsSponsorable: Optional[Sponsorship] = None
    sponsorshipNewsletters: SponsorshipNewsletterConnection
    sponsorshipsAsMaintainer: SponsorshipConnection
    sponsorshipsAsSponsor: SponsorshipConnection
    totalSponsorshipAmountAsSponsorInCents: Optional[Int] = None
    viewerCanSponsor: Boolean
    viewerIsSponsoring: Boolean
    typename__: Optional[Literal['Sponsorable']] = Field(
        'Sponsorable', alias='__typename'
    )


class Starrable(BaseModel):
    """
    Things that can be starred.
    """

    id: ID
    stargazerCount: Int
    stargazers: StargazerConnection
    viewerHasStarred: Boolean
    typename__: Optional[Literal['Starrable']] = Field('Starrable', alias='__typename')


class Subscribable(BaseModel):
    """
    Entities that can be subscribed to for web and email notifications.
    """

    id: ID
    viewerCanSubscribe: Boolean
    viewerSubscription: Optional[SubscriptionState] = None
    typename__: Optional[Literal['Subscribable']] = Field(
        'Subscribable', alias='__typename'
    )


class SubscribableThread(BaseModel):
    """
    Entities that can be subscribed to for web and email notifications.
    """

    id: ID
    viewerThreadSubscriptionFormAction: Optional[ThreadSubscriptionFormAction] = None
    viewerThreadSubscriptionStatus: Optional[ThreadSubscriptionState] = None
    typename__: Optional[Literal['SubscribableThread']] = Field(
        'SubscribableThread', alias='__typename'
    )


class TeamAuditEntryData(BaseModel):
    """
    Metadata for an audit entry with action team.*
    """

    team: Optional[Team] = None
    teamName: Optional[String] = None
    teamResourcePath: Optional[URI] = None
    teamUrl: Optional[URI] = None
    typename__: Optional[Literal['TeamAuditEntryData']] = Field(
        'TeamAuditEntryData', alias='__typename'
    )


class TopicAuditEntryData(BaseModel):
    """
    Metadata for an audit entry with a topic.
    """

    topic: Optional[Topic] = None
    topicName: Optional[String] = None
    typename__: Optional[Literal['TopicAuditEntryData']] = Field(
        'TopicAuditEntryData', alias='__typename'
    )


class UniformResourceLocatable(BaseModel):
    """
    Represents a type that can be retrieved by a URL.
    """

    resourcePath: URI
    url: URI
    typename__: Optional[Literal['UniformResourceLocatable']] = Field(
        'UniformResourceLocatable', alias='__typename'
    )


class Updatable(BaseModel):
    """
    Entities that can be updated.
    """

    viewerCanUpdate: Boolean
    typename__: Optional[Literal['Updatable']] = Field('Updatable', alias='__typename')


class UpdatableComment(BaseModel):
    """
    Comments that can be updated.
    """

    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    typename__: Optional[Literal['UpdatableComment']] = Field(
        'UpdatableComment', alias='__typename'
    )


class Votable(BaseModel):
    """
    A subject that may be upvoted.
    """

    upvoteCount: Int
    viewerCanUpvote: Boolean
    viewerHasUpvoted: Boolean
    typename__: Optional[Literal['Votable']] = Field('Votable', alias='__typename')


class AbortQueuedMigrationsPayload(BaseModel):
    """
    Autogenerated return type of AbortQueuedMigrations
    """

    clientMutationId: Optional[String] = None
    success: Optional[Boolean] = None
    typename__: Optional[Literal['AbortQueuedMigrationsPayload']] = Field(
        'AbortQueuedMigrationsPayload', alias='__typename'
    )


class AbortRepositoryMigrationPayload(BaseModel):
    """
    Autogenerated return type of AbortRepositoryMigration
    """

    clientMutationId: Optional[String] = None
    success: Optional[Boolean] = None
    typename__: Optional[Literal['AbortRepositoryMigrationPayload']] = Field(
        'AbortRepositoryMigrationPayload', alias='__typename'
    )


class AcceptEnterpriseAdministratorInvitationPayload(BaseModel):
    """
    Autogenerated return type of AcceptEnterpriseAdministratorInvitation
    """

    clientMutationId: Optional[String] = None
    invitation: Optional[EnterpriseAdministratorInvitation] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['AcceptEnterpriseAdministratorInvitationPayload']
    ] = Field('AcceptEnterpriseAdministratorInvitationPayload', alias='__typename')


class AcceptTopicSuggestionPayload(BaseModel):
    """
    Autogenerated return type of AcceptTopicSuggestion
    """

    clientMutationId: Optional[String] = None
    topic: Optional[Topic] = None
    typename__: Optional[Literal['AcceptTopicSuggestionPayload']] = Field(
        'AcceptTopicSuggestionPayload', alias='__typename'
    )


class ActorLocation(BaseModel):
    """
    Location information for an actor
    """

    city: Optional[String] = None
    country: Optional[String] = None
    countryCode: Optional[String] = None
    region: Optional[String] = None
    regionCode: Optional[String] = None
    typename__: Optional[Literal['ActorLocation']] = Field(
        'ActorLocation', alias='__typename'
    )


class AddAssigneesToAssignablePayload(BaseModel):
    """
    Autogenerated return type of AddAssigneesToAssignable
    """

    assignable: Optional[Assignable] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['AddAssigneesToAssignablePayload']] = Field(
        'AddAssigneesToAssignablePayload', alias='__typename'
    )


class AddCommentPayload(BaseModel):
    """
    Autogenerated return type of AddComment
    """

    clientMutationId: Optional[String] = None
    commentEdge: Optional[IssueCommentEdge] = None
    subject: Optional[Node] = None
    timelineEdge: Optional[IssueTimelineItemEdge] = None
    typename__: Optional[Literal['AddCommentPayload']] = Field(
        'AddCommentPayload', alias='__typename'
    )


class AddDiscussionCommentPayload(BaseModel):
    """
    Autogenerated return type of AddDiscussionComment
    """

    clientMutationId: Optional[String] = None
    comment: Optional[DiscussionComment] = None
    typename__: Optional[Literal['AddDiscussionCommentPayload']] = Field(
        'AddDiscussionCommentPayload', alias='__typename'
    )


class AddDiscussionPollVotePayload(BaseModel):
    """
    Autogenerated return type of AddDiscussionPollVote
    """

    clientMutationId: Optional[String] = None
    pollOption: Optional[DiscussionPollOption] = None
    typename__: Optional[Literal['AddDiscussionPollVotePayload']] = Field(
        'AddDiscussionPollVotePayload', alias='__typename'
    )


class AddEnterpriseOrganizationMemberPayload(BaseModel):
    """
    Autogenerated return type of AddEnterpriseOrganizationMember
    """

    clientMutationId: Optional[String] = None
    users: Optional[List[User]] = Field(default_factory=list)
    typename__: Optional[Literal['AddEnterpriseOrganizationMemberPayload']] = Field(
        'AddEnterpriseOrganizationMemberPayload', alias='__typename'
    )


class AddEnterpriseSupportEntitlementPayload(BaseModel):
    """
    Autogenerated return type of AddEnterpriseSupportEntitlement
    """

    clientMutationId: Optional[String] = None
    message: Optional[String] = None
    typename__: Optional[Literal['AddEnterpriseSupportEntitlementPayload']] = Field(
        'AddEnterpriseSupportEntitlementPayload', alias='__typename'
    )


class AddLabelsToLabelablePayload(BaseModel):
    """
    Autogenerated return type of AddLabelsToLabelable
    """

    clientMutationId: Optional[String] = None
    labelable: Optional[Labelable] = None
    typename__: Optional[Literal['AddLabelsToLabelablePayload']] = Field(
        'AddLabelsToLabelablePayload', alias='__typename'
    )


class AddProjectCardPayload(BaseModel):
    """
    Autogenerated return type of AddProjectCard
    """

    cardEdge: Optional[ProjectCardEdge] = None
    clientMutationId: Optional[String] = None
    projectColumn: Optional[ProjectColumn] = None
    typename__: Optional[Literal['AddProjectCardPayload']] = Field(
        'AddProjectCardPayload', alias='__typename'
    )


class AddProjectColumnPayload(BaseModel):
    """
    Autogenerated return type of AddProjectColumn
    """

    clientMutationId: Optional[String] = None
    columnEdge: Optional[ProjectColumnEdge] = None
    project: Optional[Project] = None
    typename__: Optional[Literal['AddProjectColumnPayload']] = Field(
        'AddProjectColumnPayload', alias='__typename'
    )


class AddProjectV2DraftIssuePayload(BaseModel):
    """
    Autogenerated return type of AddProjectV2DraftIssue
    """

    clientMutationId: Optional[String] = None
    projectItem: Optional[ProjectV2Item] = None
    typename__: Optional[Literal['AddProjectV2DraftIssuePayload']] = Field(
        'AddProjectV2DraftIssuePayload', alias='__typename'
    )


class AddProjectV2ItemByIdPayload(BaseModel):
    """
    Autogenerated return type of AddProjectV2ItemById
    """

    clientMutationId: Optional[String] = None
    item: Optional[ProjectV2Item] = None
    typename__: Optional[Literal['AddProjectV2ItemByIdPayload']] = Field(
        'AddProjectV2ItemByIdPayload', alias='__typename'
    )


class AddPullRequestReviewCommentPayload(BaseModel):
    """
    Autogenerated return type of AddPullRequestReviewComment
    """

    clientMutationId: Optional[String] = None
    comment: Optional[PullRequestReviewComment] = None
    commentEdge: Optional[PullRequestReviewCommentEdge] = None
    typename__: Optional[Literal['AddPullRequestReviewCommentPayload']] = Field(
        'AddPullRequestReviewCommentPayload', alias='__typename'
    )


class AddPullRequestReviewPayload(BaseModel):
    """
    Autogenerated return type of AddPullRequestReview
    """

    clientMutationId: Optional[String] = None
    pullRequestReview: Optional[PullRequestReview] = None
    reviewEdge: Optional[PullRequestReviewEdge] = None
    typename__: Optional[Literal['AddPullRequestReviewPayload']] = Field(
        'AddPullRequestReviewPayload', alias='__typename'
    )


class AddPullRequestReviewThreadPayload(BaseModel):
    """
    Autogenerated return type of AddPullRequestReviewThread
    """

    clientMutationId: Optional[String] = None
    thread: Optional[PullRequestReviewThread] = None
    typename__: Optional[Literal['AddPullRequestReviewThreadPayload']] = Field(
        'AddPullRequestReviewThreadPayload', alias='__typename'
    )


class AddPullRequestReviewThreadReplyPayload(BaseModel):
    """
    Autogenerated return type of AddPullRequestReviewThreadReply
    """

    clientMutationId: Optional[String] = None
    comment: Optional[PullRequestReviewComment] = None
    typename__: Optional[Literal['AddPullRequestReviewThreadReplyPayload']] = Field(
        'AddPullRequestReviewThreadReplyPayload', alias='__typename'
    )


class AddReactionPayload(BaseModel):
    """
    Autogenerated return type of AddReaction
    """

    clientMutationId: Optional[String] = None
    reaction: Optional[Reaction] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    subject: Optional[Reactable] = None
    typename__: Optional[Literal['AddReactionPayload']] = Field(
        'AddReactionPayload', alias='__typename'
    )


class AddStarPayload(BaseModel):
    """
    Autogenerated return type of AddStar
    """

    clientMutationId: Optional[String] = None
    starrable: Optional[Starrable] = None
    typename__: Optional[Literal['AddStarPayload']] = Field(
        'AddStarPayload', alias='__typename'
    )


class AddUpvotePayload(BaseModel):
    """
    Autogenerated return type of AddUpvote
    """

    clientMutationId: Optional[String] = None
    subject: Optional[Votable] = None
    typename__: Optional[Literal['AddUpvotePayload']] = Field(
        'AddUpvotePayload', alias='__typename'
    )


class AddVerifiableDomainPayload(BaseModel):
    """
    Autogenerated return type of AddVerifiableDomain
    """

    clientMutationId: Optional[String] = None
    domain: Optional[VerifiableDomain] = None
    typename__: Optional[Literal['AddVerifiableDomainPayload']] = Field(
        'AddVerifiableDomainPayload', alias='__typename'
    )


class AddedToMergeQueueEvent(Node):
    """
    Represents an 'added_to_merge_queue' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    enqueuer: Optional[User] = None
    id: ID
    mergeQueue: Optional[MergeQueue] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['AddedToMergeQueueEvent']] = Field(
        'AddedToMergeQueueEvent', alias='__typename'
    )


class AddedToProjectEvent(Node):
    """
    Represents a 'added_to_project' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    project: Optional[Project] = None
    projectCard: Optional[ProjectCard] = None
    projectColumnName: String
    typename__: Optional[Literal['AddedToProjectEvent']] = Field(
        'AddedToProjectEvent', alias='__typename'
    )


class App(Node):
    """
    A GitHub App.
    """

    createdAt: DateTime
    databaseId: Optional[Int] = None
    description: Optional[String] = None
    id: ID
    ipAllowListEntries: IpAllowListEntryConnection
    logoBackgroundColor: String
    logoUrl: URI
    name: String
    slug: String
    updatedAt: DateTime
    url: URI
    typename__: Optional[Literal['App']] = Field('App', alias='__typename')


class ApproveDeploymentsPayload(BaseModel):
    """
    Autogenerated return type of ApproveDeployments
    """

    clientMutationId: Optional[String] = None
    deployments: Optional[List[Deployment]] = Field(default_factory=list)
    typename__: Optional[Literal['ApproveDeploymentsPayload']] = Field(
        'ApproveDeploymentsPayload', alias='__typename'
    )


class ApproveVerifiableDomainPayload(BaseModel):
    """
    Autogenerated return type of ApproveVerifiableDomain
    """

    clientMutationId: Optional[String] = None
    domain: Optional[VerifiableDomain] = None
    typename__: Optional[Literal['ApproveVerifiableDomainPayload']] = Field(
        'ApproveVerifiableDomainPayload', alias='__typename'
    )


class ArchiveProjectV2ItemPayload(BaseModel):
    """
    Autogenerated return type of ArchiveProjectV2Item
    """

    clientMutationId: Optional[String] = None
    item: Optional[ProjectV2Item] = None
    typename__: Optional[Literal['ArchiveProjectV2ItemPayload']] = Field(
        'ArchiveProjectV2ItemPayload', alias='__typename'
    )


class ArchiveRepositoryPayload(BaseModel):
    """
    Autogenerated return type of ArchiveRepository
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['ArchiveRepositoryPayload']] = Field(
        'ArchiveRepositoryPayload', alias='__typename'
    )


class AssignedEvent(Node):
    """
    Represents an 'assigned' event on any assignable object.
    """

    actor: Optional[Actor] = None
    assignable: Assignable
    assignee: Optional[Assignee] = None
    createdAt: DateTime
    id: ID
    user: Optional[User] = None
    typename__: Optional[Literal['AssignedEvent']] = Field(
        'AssignedEvent', alias='__typename'
    )


class AutoMergeDisabledEvent(Node):
    """
    Represents a 'auto_merge_disabled' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    disabler: Optional[User] = None
    id: ID
    pullRequest: Optional[PullRequest] = None
    reason: Optional[String] = None
    reasonCode: Optional[String] = None
    typename__: Optional[Literal['AutoMergeDisabledEvent']] = Field(
        'AutoMergeDisabledEvent', alias='__typename'
    )


class AutoMergeEnabledEvent(Node):
    """
    Represents a 'auto_merge_enabled' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    enabler: Optional[User] = None
    id: ID
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['AutoMergeEnabledEvent']] = Field(
        'AutoMergeEnabledEvent', alias='__typename'
    )


class AutoMergeRequest(BaseModel):
    """
    Represents an auto-merge request for a pull request
    """

    authorEmail: Optional[String] = None
    commitBody: Optional[String] = None
    commitHeadline: Optional[String] = None
    enabledAt: Optional[DateTime] = None
    enabledBy: Optional[Actor] = None
    mergeMethod: PullRequestMergeMethod
    pullRequest: PullRequest
    typename__: Optional[Literal['AutoMergeRequest']] = Field(
        'AutoMergeRequest', alias='__typename'
    )


class AutoRebaseEnabledEvent(Node):
    """
    Represents a 'auto_rebase_enabled' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    enabler: Optional[User] = None
    id: ID
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['AutoRebaseEnabledEvent']] = Field(
        'AutoRebaseEnabledEvent', alias='__typename'
    )


class AutoSquashEnabledEvent(Node):
    """
    Represents a 'auto_squash_enabled' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    enabler: Optional[User] = None
    id: ID
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['AutoSquashEnabledEvent']] = Field(
        'AutoSquashEnabledEvent', alias='__typename'
    )


class AutomaticBaseChangeFailedEvent(Node):
    """
    Represents a 'automatic_base_change_failed' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    newBase: String
    oldBase: String
    pullRequest: PullRequest
    typename__: Optional[Literal['AutomaticBaseChangeFailedEvent']] = Field(
        'AutomaticBaseChangeFailedEvent', alias='__typename'
    )


class AutomaticBaseChangeSucceededEvent(Node):
    """
    Represents a 'automatic_base_change_succeeded' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    newBase: String
    oldBase: String
    pullRequest: PullRequest
    typename__: Optional[Literal['AutomaticBaseChangeSucceededEvent']] = Field(
        'AutomaticBaseChangeSucceededEvent', alias='__typename'
    )


class BaseRefChangedEvent(Node):
    """
    Represents a 'base_ref_changed' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    currentRefName: String
    databaseId: Optional[Int] = None
    id: ID
    previousRefName: String
    pullRequest: PullRequest
    typename__: Optional[Literal['BaseRefChangedEvent']] = Field(
        'BaseRefChangedEvent', alias='__typename'
    )


class BaseRefDeletedEvent(Node):
    """
    Represents a 'base_ref_deleted' event on a given pull request.
    """

    actor: Optional[Actor] = None
    baseRefName: Optional[String] = None
    createdAt: DateTime
    id: ID
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['BaseRefDeletedEvent']] = Field(
        'BaseRefDeletedEvent', alias='__typename'
    )


class BaseRefForcePushedEvent(Node):
    """
    Represents a 'base_ref_force_pushed' event on a given pull request.
    """

    actor: Optional[Actor] = None
    afterCommit: Optional[Commit] = None
    beforeCommit: Optional[Commit] = None
    createdAt: DateTime
    id: ID
    pullRequest: PullRequest
    ref: Optional[Ref] = None
    typename__: Optional[Literal['BaseRefForcePushedEvent']] = Field(
        'BaseRefForcePushedEvent', alias='__typename'
    )


class Blame(BaseModel):
    """
    Represents a Git blame.
    """

    ranges: List[BlameRange]
    typename__: Optional[Literal['Blame']] = Field('Blame', alias='__typename')


class BlameRange(BaseModel):
    """
    Represents a range of information from a Git blame.
    """

    age: Int
    commit: Commit
    endingLine: Int
    startingLine: Int
    typename__: Optional[Literal['BlameRange']] = Field(
        'BlameRange', alias='__typename'
    )


class Blob(GitObject, Node):
    """
    Represents a Git blob.
    """

    abbreviatedOid: String
    byteSize: Int
    commitResourcePath: URI
    commitUrl: URI
    id: ID
    isBinary: Optional[Boolean] = None
    isTruncated: Boolean
    oid: GitObjectID
    repository: Repository
    text: Optional[String] = None
    typename__: Optional[Literal['Blob']] = Field('Blob', alias='__typename')


class Bot(Actor, Node, UniformResourceLocatable):
    """
    A special type of user which takes actions on behalf of GitHub Apps.
    """

    avatarUrl: URI
    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    login: String
    resourcePath: URI
    updatedAt: DateTime
    url: URI
    typename__: Optional[Literal['Bot']] = Field('Bot', alias='__typename')


class BranchNamePatternParameters(BaseModel):
    """
    Parameters to be used for the branch_name_pattern rule
    """

    name: Optional[String] = None
    negate: Boolean
    operator: String
    pattern: String
    typename__: Optional[Literal['BranchNamePatternParameters']] = Field(
        'BranchNamePatternParameters', alias='__typename'
    )


class BranchProtectionRule(Node):
    """
    A branch protection rule.
    """

    allowsDeletions: Boolean
    allowsForcePushes: Boolean
    blocksCreations: Boolean
    branchProtectionRuleConflicts: BranchProtectionRuleConflictConnection
    bypassForcePushAllowances: BypassForcePushAllowanceConnection
    bypassPullRequestAllowances: BypassPullRequestAllowanceConnection
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    dismissesStaleReviews: Boolean
    id: ID
    isAdminEnforced: Boolean
    lockAllowsFetchAndMerge: Boolean
    lockBranch: Boolean
    matchingRefs: RefConnection
    pattern: String
    pushAllowances: PushAllowanceConnection
    repository: Optional[Repository] = None
    requireLastPushApproval: Boolean
    requiredApprovingReviewCount: Optional[Int] = None
    requiredDeploymentEnvironments: Optional[List[Optional[String]]] = Field(
        default_factory=list
    )
    requiredStatusCheckContexts: Optional[List[Optional[String]]] = Field(
        default_factory=list
    )
    requiredStatusChecks: Optional[List[RequiredStatusCheckDescription]] = Field(
        default_factory=list
    )
    requiresApprovingReviews: Boolean
    requiresCodeOwnerReviews: Boolean
    requiresCommitSignatures: Boolean
    requiresConversationResolution: Boolean
    requiresDeployments: Boolean
    requiresLinearHistory: Boolean
    requiresStatusChecks: Boolean
    requiresStrictStatusChecks: Boolean
    restrictsPushes: Boolean
    restrictsReviewDismissals: Boolean
    reviewDismissalAllowances: ReviewDismissalAllowanceConnection
    typename__: Optional[Literal['BranchProtectionRule']] = Field(
        'BranchProtectionRule', alias='__typename'
    )


class BranchProtectionRuleConflict(BaseModel):
    """
    A conflict between two branch protection rules.
    """

    branchProtectionRule: Optional[BranchProtectionRule] = None
    conflictingBranchProtectionRule: Optional[BranchProtectionRule] = None
    ref: Optional[Ref] = None
    typename__: Optional[Literal['BranchProtectionRuleConflict']] = Field(
        'BranchProtectionRuleConflict', alias='__typename'
    )


class BranchProtectionRuleConflictConnection(BaseModel):
    """
    The connection type for BranchProtectionRuleConflict.
    """

    edges: Optional[List[Optional[BranchProtectionRuleConflictEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[BranchProtectionRuleConflict]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['BranchProtectionRuleConflictConnection']] = Field(
        'BranchProtectionRuleConflictConnection', alias='__typename'
    )


class BranchProtectionRuleConflictEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[BranchProtectionRuleConflict] = None
    typename__: Optional[Literal['BranchProtectionRuleConflictEdge']] = Field(
        'BranchProtectionRuleConflictEdge', alias='__typename'
    )


class BranchProtectionRuleConnection(BaseModel):
    """
    The connection type for BranchProtectionRule.
    """

    edges: Optional[List[Optional[BranchProtectionRuleEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[BranchProtectionRule]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['BranchProtectionRuleConnection']] = Field(
        'BranchProtectionRuleConnection', alias='__typename'
    )


class BranchProtectionRuleEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[BranchProtectionRule] = None
    typename__: Optional[Literal['BranchProtectionRuleEdge']] = Field(
        'BranchProtectionRuleEdge', alias='__typename'
    )


class BypassForcePushAllowance(Node):
    """
    A user, team, or app who has the ability to bypass a force push requirement on a protected branch.
    """

    actor: Optional[BranchActorAllowanceActor] = None
    branchProtectionRule: Optional[BranchProtectionRule] = None
    id: ID
    typename__: Optional[Literal['BypassForcePushAllowance']] = Field(
        'BypassForcePushAllowance', alias='__typename'
    )


class BypassForcePushAllowanceConnection(BaseModel):
    """
    The connection type for BypassForcePushAllowance.
    """

    edges: Optional[List[Optional[BypassForcePushAllowanceEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[BypassForcePushAllowance]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['BypassForcePushAllowanceConnection']] = Field(
        'BypassForcePushAllowanceConnection', alias='__typename'
    )


class BypassForcePushAllowanceEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[BypassForcePushAllowance] = None
    typename__: Optional[Literal['BypassForcePushAllowanceEdge']] = Field(
        'BypassForcePushAllowanceEdge', alias='__typename'
    )


class BypassPullRequestAllowance(Node):
    """
    A user, team, or app who has the ability to bypass a pull request requirement on a protected branch.
    """

    actor: Optional[BranchActorAllowanceActor] = None
    branchProtectionRule: Optional[BranchProtectionRule] = None
    id: ID
    typename__: Optional[Literal['BypassPullRequestAllowance']] = Field(
        'BypassPullRequestAllowance', alias='__typename'
    )


class BypassPullRequestAllowanceConnection(BaseModel):
    """
    The connection type for BypassPullRequestAllowance.
    """

    edges: Optional[List[Optional[BypassPullRequestAllowanceEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[BypassPullRequestAllowance]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['BypassPullRequestAllowanceConnection']] = Field(
        'BypassPullRequestAllowanceConnection', alias='__typename'
    )


class BypassPullRequestAllowanceEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[BypassPullRequestAllowance] = None
    typename__: Optional[Literal['BypassPullRequestAllowanceEdge']] = Field(
        'BypassPullRequestAllowanceEdge', alias='__typename'
    )


class CVSS(BaseModel):
    """
    The Common Vulnerability Scoring System
    """

    score: Float
    vectorString: Optional[String] = None
    typename__: Optional[Literal['CVSS']] = Field('CVSS', alias='__typename')


class CWE(Node):
    """
    A common weakness enumeration
    """

    cweId: String
    description: String
    id: ID
    name: String
    typename__: Optional[Literal['CWE']] = Field('CWE', alias='__typename')


class CWEConnection(BaseModel):
    """
    The connection type for CWE.
    """

    edges: Optional[List[Optional[CWEEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[CWE]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CWEConnection']] = Field(
        'CWEConnection', alias='__typename'
    )


class CWEEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CWE] = None
    typename__: Optional[Literal['CWEEdge']] = Field('CWEEdge', alias='__typename')


class CancelEnterpriseAdminInvitationPayload(BaseModel):
    """
    Autogenerated return type of CancelEnterpriseAdminInvitation
    """

    clientMutationId: Optional[String] = None
    invitation: Optional[EnterpriseAdministratorInvitation] = None
    message: Optional[String] = None
    typename__: Optional[Literal['CancelEnterpriseAdminInvitationPayload']] = Field(
        'CancelEnterpriseAdminInvitationPayload', alias='__typename'
    )


class CancelSponsorshipPayload(BaseModel):
    """
    Autogenerated return type of CancelSponsorship
    """

    clientMutationId: Optional[String] = None
    sponsorsTier: Optional[SponsorsTier] = None
    typename__: Optional[Literal['CancelSponsorshipPayload']] = Field(
        'CancelSponsorshipPayload', alias='__typename'
    )


class ChangeUserStatusPayload(BaseModel):
    """
    Autogenerated return type of ChangeUserStatus
    """

    clientMutationId: Optional[String] = None
    status: Optional[UserStatus] = None
    typename__: Optional[Literal['ChangeUserStatusPayload']] = Field(
        'ChangeUserStatusPayload', alias='__typename'
    )


class CheckAnnotation(BaseModel):
    """
    A single check annotation.
    """

    annotationLevel: Optional[CheckAnnotationLevel] = None
    blobUrl: URI
    databaseId: Optional[Int] = None
    location: CheckAnnotationSpan
    message: String
    path: String
    rawDetails: Optional[String] = None
    title: Optional[String] = None
    typename__: Optional[Literal['CheckAnnotation']] = Field(
        'CheckAnnotation', alias='__typename'
    )


class CheckAnnotationConnection(BaseModel):
    """
    The connection type for CheckAnnotation.
    """

    edges: Optional[List[Optional[CheckAnnotationEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[CheckAnnotation]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CheckAnnotationConnection']] = Field(
        'CheckAnnotationConnection', alias='__typename'
    )


class CheckAnnotationEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CheckAnnotation] = None
    typename__: Optional[Literal['CheckAnnotationEdge']] = Field(
        'CheckAnnotationEdge', alias='__typename'
    )


class CheckAnnotationPosition(BaseModel):
    """
    A character position in a check annotation.
    """

    column: Optional[Int] = None
    line: Int
    typename__: Optional[Literal['CheckAnnotationPosition']] = Field(
        'CheckAnnotationPosition', alias='__typename'
    )


class CheckAnnotationSpan(BaseModel):
    """
    An inclusive pair of positions for a check annotation.
    """

    end: CheckAnnotationPosition
    start: CheckAnnotationPosition
    typename__: Optional[Literal['CheckAnnotationSpan']] = Field(
        'CheckAnnotationSpan', alias='__typename'
    )


class CheckRun(Node, RequirableByPullRequest, UniformResourceLocatable):
    """
    A check run.
    """

    annotations: Optional[CheckAnnotationConnection] = None
    checkSuite: CheckSuite
    completedAt: Optional[DateTime] = None
    conclusion: Optional[CheckConclusionState] = None
    databaseId: Optional[Int] = None
    deployment: Optional[Deployment] = None
    detailsUrl: Optional[URI] = None
    externalId: Optional[String] = None
    id: ID
    isRequired: Boolean
    name: String
    pendingDeploymentRequest: Optional[DeploymentRequest] = None
    permalink: URI
    repository: Repository
    resourcePath: URI
    startedAt: Optional[DateTime] = None
    status: CheckStatusState
    steps: Optional[CheckStepConnection] = None
    summary: Optional[String] = None
    text: Optional[String] = None
    title: Optional[String] = None
    url: URI
    typename__: Optional[Literal['CheckRun']] = Field('CheckRun', alias='__typename')


class CheckRunConnection(BaseModel):
    """
    The connection type for CheckRun.
    """

    edges: Optional[List[Optional[CheckRunEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[CheckRun]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CheckRunConnection']] = Field(
        'CheckRunConnection', alias='__typename'
    )


class CheckRunEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CheckRun] = None
    typename__: Optional[Literal['CheckRunEdge']] = Field(
        'CheckRunEdge', alias='__typename'
    )


class CheckRunStateCount(BaseModel):
    """
    Represents a count of the state of a check run.
    """

    count: Int
    state: CheckRunState
    typename__: Optional[Literal['CheckRunStateCount']] = Field(
        'CheckRunStateCount', alias='__typename'
    )


class CheckStep(BaseModel):
    """
    A single check step.
    """

    completedAt: Optional[DateTime] = None
    conclusion: Optional[CheckConclusionState] = None
    externalId: Optional[String] = None
    name: String
    number: Int
    secondsToCompletion: Optional[Int] = None
    startedAt: Optional[DateTime] = None
    status: CheckStatusState
    typename__: Optional[Literal['CheckStep']] = Field('CheckStep', alias='__typename')


class CheckStepConnection(BaseModel):
    """
    The connection type for CheckStep.
    """

    edges: Optional[List[Optional[CheckStepEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[CheckStep]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CheckStepConnection']] = Field(
        'CheckStepConnection', alias='__typename'
    )


class CheckStepEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CheckStep] = None
    typename__: Optional[Literal['CheckStepEdge']] = Field(
        'CheckStepEdge', alias='__typename'
    )


class CheckSuite(Node):
    """
    A check suite.
    """

    app: Optional[App] = None
    branch: Optional[Ref] = None
    checkRuns: Optional[CheckRunConnection] = None
    commit: Commit
    conclusion: Optional[CheckConclusionState] = None
    createdAt: DateTime
    creator: Optional[User] = None
    databaseId: Optional[Int] = None
    id: ID
    matchingPullRequests: Optional[PullRequestConnection] = None
    push: Optional[Push] = None
    repository: Repository
    resourcePath: URI
    status: CheckStatusState
    updatedAt: DateTime
    url: URI
    workflowRun: Optional[WorkflowRun] = None
    typename__: Optional[Literal['CheckSuite']] = Field(
        'CheckSuite', alias='__typename'
    )


class CheckSuiteConnection(BaseModel):
    """
    The connection type for CheckSuite.
    """

    edges: Optional[List[Optional[CheckSuiteEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[CheckSuite]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CheckSuiteConnection']] = Field(
        'CheckSuiteConnection', alias='__typename'
    )


class CheckSuiteEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CheckSuite] = None
    typename__: Optional[Literal['CheckSuiteEdge']] = Field(
        'CheckSuiteEdge', alias='__typename'
    )


class ClearLabelsFromLabelablePayload(BaseModel):
    """
    Autogenerated return type of ClearLabelsFromLabelable
    """

    clientMutationId: Optional[String] = None
    labelable: Optional[Labelable] = None
    typename__: Optional[Literal['ClearLabelsFromLabelablePayload']] = Field(
        'ClearLabelsFromLabelablePayload', alias='__typename'
    )


class ClearProjectV2ItemFieldValuePayload(BaseModel):
    """
    Autogenerated return type of ClearProjectV2ItemFieldValue
    """

    clientMutationId: Optional[String] = None
    projectV2Item: Optional[ProjectV2Item] = None
    typename__: Optional[Literal['ClearProjectV2ItemFieldValuePayload']] = Field(
        'ClearProjectV2ItemFieldValuePayload', alias='__typename'
    )


class CloneProjectPayload(BaseModel):
    """
    Autogenerated return type of CloneProject
    """

    clientMutationId: Optional[String] = None
    jobStatusId: Optional[String] = None
    project: Optional[Project] = None
    typename__: Optional[Literal['CloneProjectPayload']] = Field(
        'CloneProjectPayload', alias='__typename'
    )


class CloneTemplateRepositoryPayload(BaseModel):
    """
    Autogenerated return type of CloneTemplateRepository
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['CloneTemplateRepositoryPayload']] = Field(
        'CloneTemplateRepositoryPayload', alias='__typename'
    )


class CloseDiscussionPayload(BaseModel):
    """
    Autogenerated return type of CloseDiscussion
    """

    clientMutationId: Optional[String] = None
    discussion: Optional[Discussion] = None
    typename__: Optional[Literal['CloseDiscussionPayload']] = Field(
        'CloseDiscussionPayload', alias='__typename'
    )


class CloseIssuePayload(BaseModel):
    """
    Autogenerated return type of CloseIssue
    """

    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    typename__: Optional[Literal['CloseIssuePayload']] = Field(
        'CloseIssuePayload', alias='__typename'
    )


class ClosePullRequestPayload(BaseModel):
    """
    Autogenerated return type of ClosePullRequest
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['ClosePullRequestPayload']] = Field(
        'ClosePullRequestPayload', alias='__typename'
    )


class ClosedEvent(Node, UniformResourceLocatable):
    """
    Represents a 'closed' event on any `Closable`.
    """

    actor: Optional[Actor] = None
    closable: Closable
    closer: Optional[Closer] = None
    createdAt: DateTime
    id: ID
    resourcePath: URI
    stateReason: Optional[IssueStateReason] = None
    url: URI
    typename__: Optional[Literal['ClosedEvent']] = Field(
        'ClosedEvent', alias='__typename'
    )


class CodeOfConduct(Node):
    """
    The Code of Conduct for a repository
    """

    body: Optional[String] = None
    id: ID
    key: String
    name: String
    resourcePath: Optional[URI] = None
    url: Optional[URI] = None
    typename__: Optional[Literal['CodeOfConduct']] = Field(
        'CodeOfConduct', alias='__typename'
    )


class CommentDeletedEvent(Node):
    """
    Represents a 'comment_deleted' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    deletedCommentAuthor: Optional[Actor] = None
    id: ID
    typename__: Optional[Literal['CommentDeletedEvent']] = Field(
        'CommentDeletedEvent', alias='__typename'
    )


class Commit(GitObject, Node, Subscribable, UniformResourceLocatable):
    """
    Represents a Git commit.
    """

    abbreviatedOid: String
    additions: Int
    associatedPullRequests: Optional[PullRequestConnection] = None
    author: Optional[GitActor] = None
    authoredByCommitter: Boolean
    authoredDate: DateTime
    authors: GitActorConnection
    blame: Blame
    changedFiles: Int
    changedFilesIfAvailable: Optional[Int] = None
    checkSuites: Optional[CheckSuiteConnection] = None
    comments: CommitCommentConnection
    commitResourcePath: URI
    commitUrl: URI
    committedDate: DateTime
    committedViaWeb: Boolean
    committer: Optional[GitActor] = None
    deletions: Int
    deployments: Optional[DeploymentConnection] = None
    file: Optional[TreeEntry] = None
    history: CommitHistoryConnection
    id: ID
    message: String
    messageBody: String
    messageBodyHTML: HTML
    messageHeadline: String
    messageHeadlineHTML: HTML
    oid: GitObjectID
    onBehalfOf: Optional[Organization] = None
    parents: CommitConnection
    pushedDate: Optional[DateTime] = None
    repository: Repository
    resourcePath: URI
    signature: Optional[GitSignature] = None
    status: Optional[Status] = None
    statusCheckRollup: Optional[StatusCheckRollup] = None
    submodules: SubmoduleConnection
    tarballUrl: URI
    tree: Tree
    treeResourcePath: URI
    treeUrl: URI
    url: URI
    viewerCanSubscribe: Boolean
    viewerSubscription: Optional[SubscriptionState] = None
    zipballUrl: URI
    typename__: Optional[Literal['Commit']] = Field('Commit', alias='__typename')


class CommitAuthorEmailPatternParameters(BaseModel):
    """
    Parameters to be used for the commit_author_email_pattern rule
    """

    name: Optional[String] = None
    negate: Boolean
    operator: String
    pattern: String
    typename__: Optional[Literal['CommitAuthorEmailPatternParameters']] = Field(
        'CommitAuthorEmailPatternParameters', alias='__typename'
    )


class CommitComment(
    Comment,
    Deletable,
    Minimizable,
    Node,
    Reactable,
    RepositoryNode,
    Updatable,
    UpdatableComment,
):
    """
    Represents a comment on a given Commit.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    commit: Optional[Commit] = None
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    editor: Optional[Actor] = None
    id: ID
    includesCreatedEdit: Boolean
    isMinimized: Boolean
    lastEditedAt: Optional[DateTime] = None
    minimizedReason: Optional[String] = None
    path: Optional[String] = None
    position: Optional[Int] = None
    publishedAt: Optional[DateTime] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    repository: Repository
    resourcePath: URI
    updatedAt: DateTime
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanDelete: Boolean
    viewerCanMinimize: Boolean
    viewerCanReact: Boolean
    viewerCanUpdate: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    typename__: Optional[Literal['CommitComment']] = Field(
        'CommitComment', alias='__typename'
    )


class CommitCommentConnection(BaseModel):
    """
    The connection type for CommitComment.
    """

    edges: Optional[List[Optional[CommitCommentEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[CommitComment]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CommitCommentConnection']] = Field(
        'CommitCommentConnection', alias='__typename'
    )


class CommitCommentEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CommitComment] = None
    typename__: Optional[Literal['CommitCommentEdge']] = Field(
        'CommitCommentEdge', alias='__typename'
    )


class CommitCommentThread(Node, RepositoryNode):
    """
    A thread of comments on a commit.
    """

    comments: CommitCommentConnection
    commit: Optional[Commit] = None
    id: ID
    path: Optional[String] = None
    position: Optional[Int] = None
    repository: Repository
    typename__: Optional[Literal['CommitCommentThread']] = Field(
        'CommitCommentThread', alias='__typename'
    )


class CommitConnection(BaseModel):
    """
    The connection type for Commit.
    """

    edges: Optional[List[Optional[CommitEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Commit]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CommitConnection']] = Field(
        'CommitConnection', alias='__typename'
    )


class CommitContributionsByRepository(BaseModel):
    """
    This aggregates commits made by a user within one repository.
    """

    contributions: CreatedCommitContributionConnection
    repository: Repository
    resourcePath: URI
    url: URI
    typename__: Optional[Literal['CommitContributionsByRepository']] = Field(
        'CommitContributionsByRepository', alias='__typename'
    )


class CommitEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Commit] = None
    typename__: Optional[Literal['CommitEdge']] = Field(
        'CommitEdge', alias='__typename'
    )


class CommitHistoryConnection(BaseModel):
    """
    The connection type for Commit.
    """

    edges: Optional[List[Optional[CommitEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Commit]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CommitHistoryConnection']] = Field(
        'CommitHistoryConnection', alias='__typename'
    )


class CommitMessagePatternParameters(BaseModel):
    """
    Parameters to be used for the commit_message_pattern rule
    """

    name: Optional[String] = None
    negate: Boolean
    operator: String
    pattern: String
    typename__: Optional[Literal['CommitMessagePatternParameters']] = Field(
        'CommitMessagePatternParameters', alias='__typename'
    )


class CommitterEmailPatternParameters(BaseModel):
    """
    Parameters to be used for the committer_email_pattern rule
    """

    name: Optional[String] = None
    negate: Boolean
    operator: String
    pattern: String
    typename__: Optional[Literal['CommitterEmailPatternParameters']] = Field(
        'CommitterEmailPatternParameters', alias='__typename'
    )


class Comparison(Node):
    """
    Represents a comparison between two commit revisions.
    """

    aheadBy: Int
    baseTarget: GitObject
    behindBy: Int
    commits: ComparisonCommitConnection
    headTarget: GitObject
    id: ID
    status: ComparisonStatus
    typename__: Optional[Literal['Comparison']] = Field(
        'Comparison', alias='__typename'
    )


class ComparisonCommitConnection(BaseModel):
    """
    The connection type for Commit.
    """

    authorCount: Int
    edges: Optional[List[Optional[CommitEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Commit]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ComparisonCommitConnection']] = Field(
        'ComparisonCommitConnection', alias='__typename'
    )


class ConnectedEvent(Node):
    """
    Represents a 'connected' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    isCrossRepository: Boolean
    source: ReferencedSubject
    subject: ReferencedSubject
    typename__: Optional[Literal['ConnectedEvent']] = Field(
        'ConnectedEvent', alias='__typename'
    )


class ContributingGuidelines(BaseModel):
    """
    The Contributing Guidelines for a repository.
    """

    body: Optional[String] = None
    resourcePath: Optional[URI] = None
    url: Optional[URI] = None
    typename__: Optional[Literal['ContributingGuidelines']] = Field(
        'ContributingGuidelines', alias='__typename'
    )


class ContributionCalendar(BaseModel):
    """
    A calendar of contributions made on GitHub by a user.
    """

    colors: List[String]
    isHalloween: Boolean
    months: List[ContributionCalendarMonth]
    totalContributions: Int
    weeks: List[ContributionCalendarWeek]
    typename__: Optional[Literal['ContributionCalendar']] = Field(
        'ContributionCalendar', alias='__typename'
    )


class ContributionCalendarDay(BaseModel):
    """
    Represents a single day of contributions on GitHub by a user.
    """

    color: String
    contributionCount: Int
    contributionLevel: ContributionLevel
    date: Date
    weekday: Int
    typename__: Optional[Literal['ContributionCalendarDay']] = Field(
        'ContributionCalendarDay', alias='__typename'
    )


class ContributionCalendarMonth(BaseModel):
    """
    A month of contributions in a user's contribution graph.
    """

    firstDay: Date
    name: String
    totalWeeks: Int
    year: Int
    typename__: Optional[Literal['ContributionCalendarMonth']] = Field(
        'ContributionCalendarMonth', alias='__typename'
    )


class ContributionCalendarWeek(BaseModel):
    """
    A week of contributions in a user's contribution graph.
    """

    contributionDays: List[ContributionCalendarDay]
    firstDay: Date
    typename__: Optional[Literal['ContributionCalendarWeek']] = Field(
        'ContributionCalendarWeek', alias='__typename'
    )


class ContributionsCollection(BaseModel):
    """
    A contributions collection aggregates contributions such as opened issues and commits created by a user.
    """

    commitContributionsByRepository: List[CommitContributionsByRepository]
    contributionCalendar: ContributionCalendar
    contributionYears: List[Int]
    doesEndInCurrentMonth: Boolean
    earliestRestrictedContributionDate: Optional[Date] = None
    endedAt: DateTime
    firstIssueContribution: Optional[CreatedIssueOrRestrictedContribution] = None
    firstPullRequestContribution: Optional[
        CreatedPullRequestOrRestrictedContribution
    ] = None
    firstRepositoryContribution: Optional[
        CreatedRepositoryOrRestrictedContribution
    ] = None
    hasActivityInThePast: Boolean
    hasAnyContributions: Boolean
    hasAnyRestrictedContributions: Boolean
    isSingleDay: Boolean
    issueContributions: CreatedIssueContributionConnection
    issueContributionsByRepository: List[IssueContributionsByRepository]
    joinedGitHubContribution: Optional[JoinedGitHubContribution] = None
    latestRestrictedContributionDate: Optional[Date] = None
    mostRecentCollectionWithActivity: Optional[ContributionsCollection] = None
    mostRecentCollectionWithoutActivity: Optional[ContributionsCollection] = None
    popularIssueContribution: Optional[CreatedIssueContribution] = None
    popularPullRequestContribution: Optional[CreatedPullRequestContribution] = None
    pullRequestContributions: CreatedPullRequestContributionConnection
    pullRequestContributionsByRepository: List[PullRequestContributionsByRepository]
    pullRequestReviewContributions: CreatedPullRequestReviewContributionConnection
    pullRequestReviewContributionsByRepository: List[
        PullRequestReviewContributionsByRepository
    ]
    repositoryContributions: CreatedRepositoryContributionConnection
    restrictedContributionsCount: Int
    startedAt: DateTime
    totalCommitContributions: Int
    totalIssueContributions: Int
    totalPullRequestContributions: Int
    totalPullRequestReviewContributions: Int
    totalRepositoriesWithContributedCommits: Int
    totalRepositoriesWithContributedIssues: Int
    totalRepositoriesWithContributedPullRequestReviews: Int
    totalRepositoriesWithContributedPullRequests: Int
    totalRepositoryContributions: Int
    user: User
    typename__: Optional[Literal['ContributionsCollection']] = Field(
        'ContributionsCollection', alias='__typename'
    )


class ConvertProjectCardNoteToIssuePayload(BaseModel):
    """
    Autogenerated return type of ConvertProjectCardNoteToIssue
    """

    clientMutationId: Optional[String] = None
    projectCard: Optional[ProjectCard] = None
    typename__: Optional[Literal['ConvertProjectCardNoteToIssuePayload']] = Field(
        'ConvertProjectCardNoteToIssuePayload', alias='__typename'
    )


class ConvertPullRequestToDraftPayload(BaseModel):
    """
    Autogenerated return type of ConvertPullRequestToDraft
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['ConvertPullRequestToDraftPayload']] = Field(
        'ConvertPullRequestToDraftPayload', alias='__typename'
    )


class ConvertToDraftEvent(Node, UniformResourceLocatable):
    """
    Represents a 'convert_to_draft' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    pullRequest: PullRequest
    resourcePath: URI
    url: URI
    typename__: Optional[Literal['ConvertToDraftEvent']] = Field(
        'ConvertToDraftEvent', alias='__typename'
    )


class ConvertedNoteToIssueEvent(Node):
    """
    Represents a 'converted_note_to_issue' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    project: Optional[Project] = None
    projectCard: Optional[ProjectCard] = None
    projectColumnName: String
    typename__: Optional[Literal['ConvertedNoteToIssueEvent']] = Field(
        'ConvertedNoteToIssueEvent', alias='__typename'
    )


class ConvertedToDiscussionEvent(Node):
    """
    Represents a 'converted_to_discussion' event on a given issue.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    discussion: Optional[Discussion] = None
    id: ID
    typename__: Optional[Literal['ConvertedToDiscussionEvent']] = Field(
        'ConvertedToDiscussionEvent', alias='__typename'
    )


class CopyProjectV2Payload(BaseModel):
    """
    Autogenerated return type of CopyProjectV2
    """

    clientMutationId: Optional[String] = None
    projectV2: Optional[ProjectV2] = None
    typename__: Optional[Literal['CopyProjectV2Payload']] = Field(
        'CopyProjectV2Payload', alias='__typename'
    )


class CreateAttributionInvitationPayload(BaseModel):
    """
    Autogenerated return type of CreateAttributionInvitation
    """

    clientMutationId: Optional[String] = None
    owner: Optional[Organization] = None
    source: Optional[Claimable] = None
    target: Optional[Claimable] = None
    typename__: Optional[Literal['CreateAttributionInvitationPayload']] = Field(
        'CreateAttributionInvitationPayload', alias='__typename'
    )


class CreateBranchProtectionRulePayload(BaseModel):
    """
    Autogenerated return type of CreateBranchProtectionRule
    """

    branchProtectionRule: Optional[BranchProtectionRule] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['CreateBranchProtectionRulePayload']] = Field(
        'CreateBranchProtectionRulePayload', alias='__typename'
    )


class CreateCheckRunPayload(BaseModel):
    """
    Autogenerated return type of CreateCheckRun
    """

    checkRun: Optional[CheckRun] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['CreateCheckRunPayload']] = Field(
        'CreateCheckRunPayload', alias='__typename'
    )


class CreateCheckSuitePayload(BaseModel):
    """
    Autogenerated return type of CreateCheckSuite
    """

    checkSuite: Optional[CheckSuite] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['CreateCheckSuitePayload']] = Field(
        'CreateCheckSuitePayload', alias='__typename'
    )


class CreateCommitOnBranchPayload(BaseModel):
    """
    Autogenerated return type of CreateCommitOnBranch
    """

    clientMutationId: Optional[String] = None
    commit: Optional[Commit] = None
    ref: Optional[Ref] = None
    typename__: Optional[Literal['CreateCommitOnBranchPayload']] = Field(
        'CreateCommitOnBranchPayload', alias='__typename'
    )


class CreateDeploymentPayload(BaseModel):
    """
    Autogenerated return type of CreateDeployment
    """

    autoMerged: Optional[Boolean] = None
    clientMutationId: Optional[String] = None
    deployment: Optional[Deployment] = None
    typename__: Optional[Literal['CreateDeploymentPayload']] = Field(
        'CreateDeploymentPayload', alias='__typename'
    )


class CreateDeploymentStatusPayload(BaseModel):
    """
    Autogenerated return type of CreateDeploymentStatus
    """

    clientMutationId: Optional[String] = None
    deploymentStatus: Optional[DeploymentStatus] = None
    typename__: Optional[Literal['CreateDeploymentStatusPayload']] = Field(
        'CreateDeploymentStatusPayload', alias='__typename'
    )


class CreateDiscussionPayload(BaseModel):
    """
    Autogenerated return type of CreateDiscussion
    """

    clientMutationId: Optional[String] = None
    discussion: Optional[Discussion] = None
    typename__: Optional[Literal['CreateDiscussionPayload']] = Field(
        'CreateDiscussionPayload', alias='__typename'
    )


class CreateEnterpriseOrganizationPayload(BaseModel):
    """
    Autogenerated return type of CreateEnterpriseOrganization
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    organization: Optional[Organization] = None
    typename__: Optional[Literal['CreateEnterpriseOrganizationPayload']] = Field(
        'CreateEnterpriseOrganizationPayload', alias='__typename'
    )


class CreateEnvironmentPayload(BaseModel):
    """
    Autogenerated return type of CreateEnvironment
    """

    clientMutationId: Optional[String] = None
    environment: Optional[Environment] = None
    typename__: Optional[Literal['CreateEnvironmentPayload']] = Field(
        'CreateEnvironmentPayload', alias='__typename'
    )


class CreateIpAllowListEntryPayload(BaseModel):
    """
    Autogenerated return type of CreateIpAllowListEntry
    """

    clientMutationId: Optional[String] = None
    ipAllowListEntry: Optional[IpAllowListEntry] = None
    typename__: Optional[Literal['CreateIpAllowListEntryPayload']] = Field(
        'CreateIpAllowListEntryPayload', alias='__typename'
    )


class CreateIssuePayload(BaseModel):
    """
    Autogenerated return type of CreateIssue
    """

    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    typename__: Optional[Literal['CreateIssuePayload']] = Field(
        'CreateIssuePayload', alias='__typename'
    )


class CreateLabelPayload(BaseModel):
    """
    Autogenerated return type of CreateLabel
    """

    clientMutationId: Optional[String] = None
    label: Optional[Label] = None
    typename__: Optional[Literal['CreateLabelPayload']] = Field(
        'CreateLabelPayload', alias='__typename'
    )


class CreateLinkedBranchPayload(BaseModel):
    """
    Autogenerated return type of CreateLinkedBranch
    """

    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    linkedBranch: Optional[LinkedBranch] = None
    typename__: Optional[Literal['CreateLinkedBranchPayload']] = Field(
        'CreateLinkedBranchPayload', alias='__typename'
    )


class CreateMigrationSourcePayload(BaseModel):
    """
    Autogenerated return type of CreateMigrationSource
    """

    clientMutationId: Optional[String] = None
    migrationSource: Optional[MigrationSource] = None
    typename__: Optional[Literal['CreateMigrationSourcePayload']] = Field(
        'CreateMigrationSourcePayload', alias='__typename'
    )


class CreateProjectPayload(BaseModel):
    """
    Autogenerated return type of CreateProject
    """

    clientMutationId: Optional[String] = None
    project: Optional[Project] = None
    typename__: Optional[Literal['CreateProjectPayload']] = Field(
        'CreateProjectPayload', alias='__typename'
    )


class CreateProjectV2FieldPayload(BaseModel):
    """
    Autogenerated return type of CreateProjectV2Field
    """

    clientMutationId: Optional[String] = None
    projectV2Field: Optional[ProjectV2FieldConfiguration] = None
    typename__: Optional[Literal['CreateProjectV2FieldPayload']] = Field(
        'CreateProjectV2FieldPayload', alias='__typename'
    )


class CreateProjectV2Payload(BaseModel):
    """
    Autogenerated return type of CreateProjectV2
    """

    clientMutationId: Optional[String] = None
    projectV2: Optional[ProjectV2] = None
    typename__: Optional[Literal['CreateProjectV2Payload']] = Field(
        'CreateProjectV2Payload', alias='__typename'
    )


class CreatePullRequestPayload(BaseModel):
    """
    Autogenerated return type of CreatePullRequest
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['CreatePullRequestPayload']] = Field(
        'CreatePullRequestPayload', alias='__typename'
    )


class CreateRefPayload(BaseModel):
    """
    Autogenerated return type of CreateRef
    """

    clientMutationId: Optional[String] = None
    ref: Optional[Ref] = None
    typename__: Optional[Literal['CreateRefPayload']] = Field(
        'CreateRefPayload', alias='__typename'
    )


class CreateRepositoryPayload(BaseModel):
    """
    Autogenerated return type of CreateRepository
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['CreateRepositoryPayload']] = Field(
        'CreateRepositoryPayload', alias='__typename'
    )


class CreateRepositoryRulesetPayload(BaseModel):
    """
    Autogenerated return type of CreateRepositoryRuleset
    """

    clientMutationId: Optional[String] = None
    ruleset: Optional[RepositoryRuleset] = None
    typename__: Optional[Literal['CreateRepositoryRulesetPayload']] = Field(
        'CreateRepositoryRulesetPayload', alias='__typename'
    )


class CreateSponsorsListingPayload(BaseModel):
    """
    Autogenerated return type of CreateSponsorsListing
    """

    clientMutationId: Optional[String] = None
    sponsorsListing: Optional[SponsorsListing] = None
    typename__: Optional[Literal['CreateSponsorsListingPayload']] = Field(
        'CreateSponsorsListingPayload', alias='__typename'
    )


class CreateSponsorsTierPayload(BaseModel):
    """
    Autogenerated return type of CreateSponsorsTier
    """

    clientMutationId: Optional[String] = None
    sponsorsTier: Optional[SponsorsTier] = None
    typename__: Optional[Literal['CreateSponsorsTierPayload']] = Field(
        'CreateSponsorsTierPayload', alias='__typename'
    )


class CreateSponsorshipPayload(BaseModel):
    """
    Autogenerated return type of CreateSponsorship
    """

    clientMutationId: Optional[String] = None
    sponsorship: Optional[Sponsorship] = None
    typename__: Optional[Literal['CreateSponsorshipPayload']] = Field(
        'CreateSponsorshipPayload', alias='__typename'
    )


class CreateSponsorshipsPayload(BaseModel):
    """
    Autogenerated return type of CreateSponsorships
    """

    clientMutationId: Optional[String] = None
    sponsorables: Optional[List[Sponsorable]] = Field(default_factory=list)
    typename__: Optional[Literal['CreateSponsorshipsPayload']] = Field(
        'CreateSponsorshipsPayload', alias='__typename'
    )


class CreateTeamDiscussionCommentPayload(BaseModel):
    """
    Autogenerated return type of CreateTeamDiscussionComment
    """

    clientMutationId: Optional[String] = None
    teamDiscussionComment: Optional[TeamDiscussionComment] = None
    typename__: Optional[Literal['CreateTeamDiscussionCommentPayload']] = Field(
        'CreateTeamDiscussionCommentPayload', alias='__typename'
    )


class CreateTeamDiscussionPayload(BaseModel):
    """
    Autogenerated return type of CreateTeamDiscussion
    """

    clientMutationId: Optional[String] = None
    teamDiscussion: Optional[TeamDiscussion] = None
    typename__: Optional[Literal['CreateTeamDiscussionPayload']] = Field(
        'CreateTeamDiscussionPayload', alias='__typename'
    )


class CreatedCommitContribution(Contribution):
    """
    Represents the contribution a user made by committing to a repository.
    """

    commitCount: Int
    isRestricted: Boolean
    occurredAt: DateTime
    repository: Repository
    resourcePath: URI
    url: URI
    user: User
    typename__: Optional[Literal['CreatedCommitContribution']] = Field(
        'CreatedCommitContribution', alias='__typename'
    )


class CreatedCommitContributionConnection(BaseModel):
    """
    The connection type for CreatedCommitContribution.
    """

    edges: Optional[List[Optional[CreatedCommitContributionEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[CreatedCommitContribution]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CreatedCommitContributionConnection']] = Field(
        'CreatedCommitContributionConnection', alias='__typename'
    )


class CreatedCommitContributionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CreatedCommitContribution] = None
    typename__: Optional[Literal['CreatedCommitContributionEdge']] = Field(
        'CreatedCommitContributionEdge', alias='__typename'
    )


class CreatedIssueContribution(Contribution):
    """
    Represents the contribution a user made on GitHub by opening an issue.
    """

    isRestricted: Boolean
    issue: Issue
    occurredAt: DateTime
    resourcePath: URI
    url: URI
    user: User
    typename__: Optional[Literal['CreatedIssueContribution']] = Field(
        'CreatedIssueContribution', alias='__typename'
    )


class CreatedIssueContributionConnection(BaseModel):
    """
    The connection type for CreatedIssueContribution.
    """

    edges: Optional[List[Optional[CreatedIssueContributionEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[CreatedIssueContribution]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CreatedIssueContributionConnection']] = Field(
        'CreatedIssueContributionConnection', alias='__typename'
    )


class CreatedIssueContributionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CreatedIssueContribution] = None
    typename__: Optional[Literal['CreatedIssueContributionEdge']] = Field(
        'CreatedIssueContributionEdge', alias='__typename'
    )


class CreatedPullRequestContribution(Contribution):
    """
    Represents the contribution a user made on GitHub by opening a pull request.
    """

    isRestricted: Boolean
    occurredAt: DateTime
    pullRequest: PullRequest
    resourcePath: URI
    url: URI
    user: User
    typename__: Optional[Literal['CreatedPullRequestContribution']] = Field(
        'CreatedPullRequestContribution', alias='__typename'
    )


class CreatedPullRequestContributionConnection(BaseModel):
    """
    The connection type for CreatedPullRequestContribution.
    """

    edges: Optional[List[Optional[CreatedPullRequestContributionEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[CreatedPullRequestContribution]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CreatedPullRequestContributionConnection']] = Field(
        'CreatedPullRequestContributionConnection', alias='__typename'
    )


class CreatedPullRequestContributionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CreatedPullRequestContribution] = None
    typename__: Optional[Literal['CreatedPullRequestContributionEdge']] = Field(
        'CreatedPullRequestContributionEdge', alias='__typename'
    )


class CreatedPullRequestReviewContribution(Contribution):
    """
    Represents the contribution a user made by leaving a review on a pull request.
    """

    isRestricted: Boolean
    occurredAt: DateTime
    pullRequest: PullRequest
    pullRequestReview: PullRequestReview
    repository: Repository
    resourcePath: URI
    url: URI
    user: User
    typename__: Optional[Literal['CreatedPullRequestReviewContribution']] = Field(
        'CreatedPullRequestReviewContribution', alias='__typename'
    )


class CreatedPullRequestReviewContributionConnection(BaseModel):
    """
    The connection type for CreatedPullRequestReviewContribution.
    """

    edges: Optional[List[Optional[CreatedPullRequestReviewContributionEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[CreatedPullRequestReviewContribution]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[
        Literal['CreatedPullRequestReviewContributionConnection']
    ] = Field('CreatedPullRequestReviewContributionConnection', alias='__typename')


class CreatedPullRequestReviewContributionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CreatedPullRequestReviewContribution] = None
    typename__: Optional[Literal['CreatedPullRequestReviewContributionEdge']] = Field(
        'CreatedPullRequestReviewContributionEdge', alias='__typename'
    )


class CreatedRepositoryContribution(Contribution):
    """
    Represents the contribution a user made on GitHub by creating a repository.
    """

    isRestricted: Boolean
    occurredAt: DateTime
    repository: Repository
    resourcePath: URI
    url: URI
    user: User
    typename__: Optional[Literal['CreatedRepositoryContribution']] = Field(
        'CreatedRepositoryContribution', alias='__typename'
    )


class CreatedRepositoryContributionConnection(BaseModel):
    """
    The connection type for CreatedRepositoryContribution.
    """

    edges: Optional[List[Optional[CreatedRepositoryContributionEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[CreatedRepositoryContribution]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['CreatedRepositoryContributionConnection']] = Field(
        'CreatedRepositoryContributionConnection', alias='__typename'
    )


class CreatedRepositoryContributionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[CreatedRepositoryContribution] = None
    typename__: Optional[Literal['CreatedRepositoryContributionEdge']] = Field(
        'CreatedRepositoryContributionEdge', alias='__typename'
    )


class CrossReferencedEvent(Node, UniformResourceLocatable):
    """
    Represents a mention made by one issue or pull request to another.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    isCrossRepository: Boolean
    referencedAt: DateTime
    resourcePath: URI
    source: ReferencedSubject
    target: ReferencedSubject
    url: URI
    willCloseTarget: Boolean
    typename__: Optional[Literal['CrossReferencedEvent']] = Field(
        'CrossReferencedEvent', alias='__typename'
    )


class DeclineTopicSuggestionPayload(BaseModel):
    """
    Autogenerated return type of DeclineTopicSuggestion
    """

    clientMutationId: Optional[String] = None
    topic: Optional[Topic] = None
    typename__: Optional[Literal['DeclineTopicSuggestionPayload']] = Field(
        'DeclineTopicSuggestionPayload', alias='__typename'
    )


class DeleteBranchProtectionRulePayload(BaseModel):
    """
    Autogenerated return type of DeleteBranchProtectionRule
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteBranchProtectionRulePayload']] = Field(
        'DeleteBranchProtectionRulePayload', alias='__typename'
    )


class DeleteDeploymentPayload(BaseModel):
    """
    Autogenerated return type of DeleteDeployment
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteDeploymentPayload']] = Field(
        'DeleteDeploymentPayload', alias='__typename'
    )


class DeleteDiscussionCommentPayload(BaseModel):
    """
    Autogenerated return type of DeleteDiscussionComment
    """

    clientMutationId: Optional[String] = None
    comment: Optional[DiscussionComment] = None
    typename__: Optional[Literal['DeleteDiscussionCommentPayload']] = Field(
        'DeleteDiscussionCommentPayload', alias='__typename'
    )


class DeleteDiscussionPayload(BaseModel):
    """
    Autogenerated return type of DeleteDiscussion
    """

    clientMutationId: Optional[String] = None
    discussion: Optional[Discussion] = None
    typename__: Optional[Literal['DeleteDiscussionPayload']] = Field(
        'DeleteDiscussionPayload', alias='__typename'
    )


class DeleteEnvironmentPayload(BaseModel):
    """
    Autogenerated return type of DeleteEnvironment
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteEnvironmentPayload']] = Field(
        'DeleteEnvironmentPayload', alias='__typename'
    )


class DeleteIpAllowListEntryPayload(BaseModel):
    """
    Autogenerated return type of DeleteIpAllowListEntry
    """

    clientMutationId: Optional[String] = None
    ipAllowListEntry: Optional[IpAllowListEntry] = None
    typename__: Optional[Literal['DeleteIpAllowListEntryPayload']] = Field(
        'DeleteIpAllowListEntryPayload', alias='__typename'
    )


class DeleteIssueCommentPayload(BaseModel):
    """
    Autogenerated return type of DeleteIssueComment
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteIssueCommentPayload']] = Field(
        'DeleteIssueCommentPayload', alias='__typename'
    )


class DeleteIssuePayload(BaseModel):
    """
    Autogenerated return type of DeleteIssue
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['DeleteIssuePayload']] = Field(
        'DeleteIssuePayload', alias='__typename'
    )


class DeleteLabelPayload(BaseModel):
    """
    Autogenerated return type of DeleteLabel
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteLabelPayload']] = Field(
        'DeleteLabelPayload', alias='__typename'
    )


class DeleteLinkedBranchPayload(BaseModel):
    """
    Autogenerated return type of DeleteLinkedBranch
    """

    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    typename__: Optional[Literal['DeleteLinkedBranchPayload']] = Field(
        'DeleteLinkedBranchPayload', alias='__typename'
    )


class DeletePackageVersionPayload(BaseModel):
    """
    Autogenerated return type of DeletePackageVersion
    """

    clientMutationId: Optional[String] = None
    success: Optional[Boolean] = None
    typename__: Optional[Literal['DeletePackageVersionPayload']] = Field(
        'DeletePackageVersionPayload', alias='__typename'
    )


class DeleteProjectCardPayload(BaseModel):
    """
    Autogenerated return type of DeleteProjectCard
    """

    clientMutationId: Optional[String] = None
    column: Optional[ProjectColumn] = None
    deletedCardId: Optional[ID] = None
    typename__: Optional[Literal['DeleteProjectCardPayload']] = Field(
        'DeleteProjectCardPayload', alias='__typename'
    )


class DeleteProjectColumnPayload(BaseModel):
    """
    Autogenerated return type of DeleteProjectColumn
    """

    clientMutationId: Optional[String] = None
    deletedColumnId: Optional[ID] = None
    project: Optional[Project] = None
    typename__: Optional[Literal['DeleteProjectColumnPayload']] = Field(
        'DeleteProjectColumnPayload', alias='__typename'
    )


class DeleteProjectPayload(BaseModel):
    """
    Autogenerated return type of DeleteProject
    """

    clientMutationId: Optional[String] = None
    owner: Optional[ProjectOwner] = None
    typename__: Optional[Literal['DeleteProjectPayload']] = Field(
        'DeleteProjectPayload', alias='__typename'
    )


class DeleteProjectV2FieldPayload(BaseModel):
    """
    Autogenerated return type of DeleteProjectV2Field
    """

    clientMutationId: Optional[String] = None
    projectV2Field: Optional[ProjectV2FieldConfiguration] = None
    typename__: Optional[Literal['DeleteProjectV2FieldPayload']] = Field(
        'DeleteProjectV2FieldPayload', alias='__typename'
    )


class DeleteProjectV2ItemPayload(BaseModel):
    """
    Autogenerated return type of DeleteProjectV2Item
    """

    clientMutationId: Optional[String] = None
    deletedItemId: Optional[ID] = None
    typename__: Optional[Literal['DeleteProjectV2ItemPayload']] = Field(
        'DeleteProjectV2ItemPayload', alias='__typename'
    )


class DeleteProjectV2Payload(BaseModel):
    """
    Autogenerated return type of DeleteProjectV2
    """

    clientMutationId: Optional[String] = None
    projectV2: Optional[ProjectV2] = None
    typename__: Optional[Literal['DeleteProjectV2Payload']] = Field(
        'DeleteProjectV2Payload', alias='__typename'
    )


class DeleteProjectV2WorkflowPayload(BaseModel):
    """
    Autogenerated return type of DeleteProjectV2Workflow
    """

    clientMutationId: Optional[String] = None
    deletedWorkflowId: Optional[ID] = None
    projectV2: Optional[ProjectV2] = None
    typename__: Optional[Literal['DeleteProjectV2WorkflowPayload']] = Field(
        'DeleteProjectV2WorkflowPayload', alias='__typename'
    )


class DeletePullRequestReviewCommentPayload(BaseModel):
    """
    Autogenerated return type of DeletePullRequestReviewComment
    """

    clientMutationId: Optional[String] = None
    pullRequestReview: Optional[PullRequestReview] = None
    pullRequestReviewComment: Optional[PullRequestReviewComment] = None
    typename__: Optional[Literal['DeletePullRequestReviewCommentPayload']] = Field(
        'DeletePullRequestReviewCommentPayload', alias='__typename'
    )


class DeletePullRequestReviewPayload(BaseModel):
    """
    Autogenerated return type of DeletePullRequestReview
    """

    clientMutationId: Optional[String] = None
    pullRequestReview: Optional[PullRequestReview] = None
    typename__: Optional[Literal['DeletePullRequestReviewPayload']] = Field(
        'DeletePullRequestReviewPayload', alias='__typename'
    )


class DeleteRefPayload(BaseModel):
    """
    Autogenerated return type of DeleteRef
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteRefPayload']] = Field(
        'DeleteRefPayload', alias='__typename'
    )


class DeleteRepositoryRulesetPayload(BaseModel):
    """
    Autogenerated return type of DeleteRepositoryRuleset
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteRepositoryRulesetPayload']] = Field(
        'DeleteRepositoryRulesetPayload', alias='__typename'
    )


class DeleteTeamDiscussionCommentPayload(BaseModel):
    """
    Autogenerated return type of DeleteTeamDiscussionComment
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteTeamDiscussionCommentPayload']] = Field(
        'DeleteTeamDiscussionCommentPayload', alias='__typename'
    )


class DeleteTeamDiscussionPayload(BaseModel):
    """
    Autogenerated return type of DeleteTeamDiscussion
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteTeamDiscussionPayload']] = Field(
        'DeleteTeamDiscussionPayload', alias='__typename'
    )


class DeleteVerifiableDomainPayload(BaseModel):
    """
    Autogenerated return type of DeleteVerifiableDomain
    """

    clientMutationId: Optional[String] = None
    owner: Optional[VerifiableDomainOwner] = None
    typename__: Optional[Literal['DeleteVerifiableDomainPayload']] = Field(
        'DeleteVerifiableDomainPayload', alias='__typename'
    )


class DemilestonedEvent(Node):
    """
    Represents a 'demilestoned' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    milestoneTitle: String
    subject: MilestoneItem
    typename__: Optional[Literal['DemilestonedEvent']] = Field(
        'DemilestonedEvent', alias='__typename'
    )


class DependabotUpdate(RepositoryNode):
    """
    A Dependabot Update for a dependency in a repository
    """

    error: Optional[DependabotUpdateError] = None
    pullRequest: Optional[PullRequest] = None
    repository: Repository
    typename__: Optional[Literal['DependabotUpdate']] = Field(
        'DependabotUpdate', alias='__typename'
    )


class DependabotUpdateError(BaseModel):
    """
    An error produced from a Dependabot Update
    """

    body: String
    errorType: String
    title: String
    typename__: Optional[Literal['DependabotUpdateError']] = Field(
        'DependabotUpdateError', alias='__typename'
    )


class DependencyGraphDependency(BaseModel):
    """
    A dependency manifest entry
    """

    hasDependencies: Boolean
    packageLabel: String
    packageManager: Optional[String] = None
    packageName: String
    repository: Optional[Repository] = None
    requirements: String
    typename__: Optional[Literal['DependencyGraphDependency']] = Field(
        'DependencyGraphDependency', alias='__typename'
    )


class DependencyGraphDependencyConnection(BaseModel):
    """
    The connection type for DependencyGraphDependency.
    """

    edges: Optional[List[Optional[DependencyGraphDependencyEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[DependencyGraphDependency]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DependencyGraphDependencyConnection']] = Field(
        'DependencyGraphDependencyConnection', alias='__typename'
    )


class DependencyGraphDependencyEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DependencyGraphDependency] = None
    typename__: Optional[Literal['DependencyGraphDependencyEdge']] = Field(
        'DependencyGraphDependencyEdge', alias='__typename'
    )


class DependencyGraphManifest(Node):
    """
    Dependency manifest for a repository
    """

    blobPath: String
    dependencies: Optional[DependencyGraphDependencyConnection] = None
    dependenciesCount: Optional[Int] = None
    exceedsMaxSize: Boolean
    filename: String
    id: ID
    parseable: Boolean
    repository: Repository
    typename__: Optional[Literal['DependencyGraphManifest']] = Field(
        'DependencyGraphManifest', alias='__typename'
    )


class DependencyGraphManifestConnection(BaseModel):
    """
    The connection type for DependencyGraphManifest.
    """

    edges: Optional[List[Optional[DependencyGraphManifestEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[DependencyGraphManifest]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DependencyGraphManifestConnection']] = Field(
        'DependencyGraphManifestConnection', alias='__typename'
    )


class DependencyGraphManifestEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DependencyGraphManifest] = None
    typename__: Optional[Literal['DependencyGraphManifestEdge']] = Field(
        'DependencyGraphManifestEdge', alias='__typename'
    )


class DeployKey(Node):
    """
    A repository deploy key.
    """

    createdAt: DateTime
    id: ID
    key: String
    readOnly: Boolean
    title: String
    verified: Boolean
    typename__: Optional[Literal['DeployKey']] = Field('DeployKey', alias='__typename')


class DeployKeyConnection(BaseModel):
    """
    The connection type for DeployKey.
    """

    edges: Optional[List[Optional[DeployKeyEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[DeployKey]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DeployKeyConnection']] = Field(
        'DeployKeyConnection', alias='__typename'
    )


class DeployKeyEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DeployKey] = None
    typename__: Optional[Literal['DeployKeyEdge']] = Field(
        'DeployKeyEdge', alias='__typename'
    )


class DeployedEvent(Node):
    """
    Represents a 'deployed' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    deployment: Deployment
    id: ID
    pullRequest: PullRequest
    ref: Optional[Ref] = None
    typename__: Optional[Literal['DeployedEvent']] = Field(
        'DeployedEvent', alias='__typename'
    )


class Deployment(Node):
    """
    Represents triggered deployment instance.
    """

    commit: Optional[Commit] = None
    commitOid: String
    createdAt: DateTime
    creator: Actor
    databaseId: Optional[Int] = None
    description: Optional[String] = None
    environment: Optional[String] = None
    id: ID
    latestEnvironment: Optional[String] = None
    latestStatus: Optional[DeploymentStatus] = None
    originalEnvironment: Optional[String] = None
    payload: Optional[String] = None
    ref: Optional[Ref] = None
    repository: Repository
    state: Optional[DeploymentState] = None
    statuses: Optional[DeploymentStatusConnection] = None
    task: Optional[String] = None
    updatedAt: DateTime
    typename__: Optional[Literal['Deployment']] = Field(
        'Deployment', alias='__typename'
    )


class DeploymentConnection(BaseModel):
    """
    The connection type for Deployment.
    """

    edges: Optional[List[Optional[DeploymentEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Deployment]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DeploymentConnection']] = Field(
        'DeploymentConnection', alias='__typename'
    )


class DeploymentEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Deployment] = None
    typename__: Optional[Literal['DeploymentEdge']] = Field(
        'DeploymentEdge', alias='__typename'
    )


class DeploymentEnvironmentChangedEvent(Node):
    """
    Represents a 'deployment_environment_changed' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    deploymentStatus: DeploymentStatus
    id: ID
    pullRequest: PullRequest
    typename__: Optional[Literal['DeploymentEnvironmentChangedEvent']] = Field(
        'DeploymentEnvironmentChangedEvent', alias='__typename'
    )


class DeploymentProtectionRule(BaseModel):
    """
    A protection rule.
    """

    databaseId: Optional[Int] = None
    preventSelfReview: Optional[Boolean] = None
    reviewers: DeploymentReviewerConnection
    timeout: Int
    type: DeploymentProtectionRuleType
    typename__: Optional[Literal['DeploymentProtectionRule']] = Field(
        'DeploymentProtectionRule', alias='__typename'
    )


class DeploymentProtectionRuleConnection(BaseModel):
    """
    The connection type for DeploymentProtectionRule.
    """

    edges: Optional[List[Optional[DeploymentProtectionRuleEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[DeploymentProtectionRule]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DeploymentProtectionRuleConnection']] = Field(
        'DeploymentProtectionRuleConnection', alias='__typename'
    )


class DeploymentProtectionRuleEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DeploymentProtectionRule] = None
    typename__: Optional[Literal['DeploymentProtectionRuleEdge']] = Field(
        'DeploymentProtectionRuleEdge', alias='__typename'
    )


class DeploymentRequest(BaseModel):
    """
    A request to deploy a workflow run to an environment.
    """

    currentUserCanApprove: Boolean
    environment: Environment
    reviewers: DeploymentReviewerConnection
    waitTimer: Int
    waitTimerStartedAt: Optional[DateTime] = None
    typename__: Optional[Literal['DeploymentRequest']] = Field(
        'DeploymentRequest', alias='__typename'
    )


class DeploymentRequestConnection(BaseModel):
    """
    The connection type for DeploymentRequest.
    """

    edges: Optional[List[Optional[DeploymentRequestEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[DeploymentRequest]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DeploymentRequestConnection']] = Field(
        'DeploymentRequestConnection', alias='__typename'
    )


class DeploymentRequestEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DeploymentRequest] = None
    typename__: Optional[Literal['DeploymentRequestEdge']] = Field(
        'DeploymentRequestEdge', alias='__typename'
    )


class DeploymentReview(Node):
    """
    A deployment review.
    """

    comment: String
    databaseId: Optional[Int] = None
    environments: EnvironmentConnection
    id: ID
    state: DeploymentReviewState
    user: User
    typename__: Optional[Literal['DeploymentReview']] = Field(
        'DeploymentReview', alias='__typename'
    )


class DeploymentReviewConnection(BaseModel):
    """
    The connection type for DeploymentReview.
    """

    edges: Optional[List[Optional[DeploymentReviewEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[DeploymentReview]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DeploymentReviewConnection']] = Field(
        'DeploymentReviewConnection', alias='__typename'
    )


class DeploymentReviewEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DeploymentReview] = None
    typename__: Optional[Literal['DeploymentReviewEdge']] = Field(
        'DeploymentReviewEdge', alias='__typename'
    )


class DeploymentReviewerConnection(BaseModel):
    """
    The connection type for DeploymentReviewer.
    """

    edges: Optional[List[Optional[DeploymentReviewerEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[DeploymentReviewer]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DeploymentReviewerConnection']] = Field(
        'DeploymentReviewerConnection', alias='__typename'
    )


class DeploymentReviewerEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DeploymentReviewer] = None
    typename__: Optional[Literal['DeploymentReviewerEdge']] = Field(
        'DeploymentReviewerEdge', alias='__typename'
    )


class DeploymentStatus(Node):
    """
    Describes the status of a given deployment attempt.
    """

    createdAt: DateTime
    creator: Actor
    deployment: Deployment
    description: Optional[String] = None
    environment: Optional[String] = None
    environmentUrl: Optional[URI] = None
    id: ID
    logUrl: Optional[URI] = None
    state: DeploymentStatusState
    updatedAt: DateTime
    typename__: Optional[Literal['DeploymentStatus']] = Field(
        'DeploymentStatus', alias='__typename'
    )


class DeploymentStatusConnection(BaseModel):
    """
    The connection type for DeploymentStatus.
    """

    edges: Optional[List[Optional[DeploymentStatusEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[DeploymentStatus]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DeploymentStatusConnection']] = Field(
        'DeploymentStatusConnection', alias='__typename'
    )


class DeploymentStatusEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DeploymentStatus] = None
    typename__: Optional[Literal['DeploymentStatusEdge']] = Field(
        'DeploymentStatusEdge', alias='__typename'
    )


class DequeuePullRequestPayload(BaseModel):
    """
    Autogenerated return type of DequeuePullRequest
    """

    clientMutationId: Optional[String] = None
    mergeQueueEntry: Optional[MergeQueueEntry] = None
    typename__: Optional[Literal['DequeuePullRequestPayload']] = Field(
        'DequeuePullRequestPayload', alias='__typename'
    )


class DisablePullRequestAutoMergePayload(BaseModel):
    """
    Autogenerated return type of DisablePullRequestAutoMerge
    """

    actor: Optional[Actor] = None
    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['DisablePullRequestAutoMergePayload']] = Field(
        'DisablePullRequestAutoMergePayload', alias='__typename'
    )


class DisconnectedEvent(Node):
    """
    Represents a 'disconnected' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    isCrossRepository: Boolean
    source: ReferencedSubject
    subject: ReferencedSubject
    typename__: Optional[Literal['DisconnectedEvent']] = Field(
        'DisconnectedEvent', alias='__typename'
    )


class Discussion(
    Closable,
    Comment,
    Deletable,
    Labelable,
    Lockable,
    Node,
    Reactable,
    RepositoryNode,
    Subscribable,
    Updatable,
    Votable,
):
    """
    A discussion in a repository.
    """

    activeLockReason: Optional[LockReason] = None
    answer: Optional[DiscussionComment] = None
    answerChosenAt: Optional[DateTime] = None
    answerChosenBy: Optional[Actor] = None
    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    category: DiscussionCategory
    closed: Boolean
    closedAt: Optional[DateTime] = None
    comments: DiscussionCommentConnection
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    editor: Optional[Actor] = None
    id: ID
    includesCreatedEdit: Boolean
    isAnswered: Optional[Boolean] = None
    labels: Optional[LabelConnection] = None
    lastEditedAt: Optional[DateTime] = None
    locked: Boolean
    number: Int
    poll: Optional[DiscussionPoll] = None
    publishedAt: Optional[DateTime] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    repository: Repository
    resourcePath: URI
    stateReason: Optional[DiscussionStateReason] = None
    title: String
    updatedAt: DateTime
    upvoteCount: Int
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanClose: Boolean
    viewerCanDelete: Boolean
    viewerCanReact: Boolean
    viewerCanReopen: Boolean
    viewerCanSubscribe: Boolean
    viewerCanUpdate: Boolean
    viewerCanUpvote: Boolean
    viewerDidAuthor: Boolean
    viewerHasUpvoted: Boolean
    viewerSubscription: Optional[SubscriptionState] = None
    typename__: Optional[Literal['Discussion']] = Field(
        'Discussion', alias='__typename'
    )


class DiscussionCategory(Node, RepositoryNode):
    """
    A category for discussions in a repository.
    """

    createdAt: DateTime
    description: Optional[String] = None
    emoji: String
    emojiHTML: HTML
    id: ID
    isAnswerable: Boolean
    name: String
    repository: Repository
    slug: String
    updatedAt: DateTime
    typename__: Optional[Literal['DiscussionCategory']] = Field(
        'DiscussionCategory', alias='__typename'
    )


class DiscussionCategoryConnection(BaseModel):
    """
    The connection type for DiscussionCategory.
    """

    edges: Optional[List[Optional[DiscussionCategoryEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[DiscussionCategory]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DiscussionCategoryConnection']] = Field(
        'DiscussionCategoryConnection', alias='__typename'
    )


class DiscussionCategoryEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DiscussionCategory] = None
    typename__: Optional[Literal['DiscussionCategoryEdge']] = Field(
        'DiscussionCategoryEdge', alias='__typename'
    )


class DiscussionComment(
    Comment,
    Deletable,
    Minimizable,
    Node,
    Reactable,
    Updatable,
    UpdatableComment,
    Votable,
):
    """
    A comment on a discussion.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    deletedAt: Optional[DateTime] = None
    discussion: Optional[Discussion] = None
    editor: Optional[Actor] = None
    id: ID
    includesCreatedEdit: Boolean
    isAnswer: Boolean
    isMinimized: Boolean
    lastEditedAt: Optional[DateTime] = None
    minimizedReason: Optional[String] = None
    publishedAt: Optional[DateTime] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    replies: DiscussionCommentConnection
    replyTo: Optional[DiscussionComment] = None
    resourcePath: URI
    updatedAt: DateTime
    upvoteCount: Int
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanDelete: Boolean
    viewerCanMarkAsAnswer: Boolean
    viewerCanMinimize: Boolean
    viewerCanReact: Boolean
    viewerCanUnmarkAsAnswer: Boolean
    viewerCanUpdate: Boolean
    viewerCanUpvote: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    viewerHasUpvoted: Boolean
    typename__: Optional[Literal['DiscussionComment']] = Field(
        'DiscussionComment', alias='__typename'
    )


class DiscussionCommentConnection(BaseModel):
    """
    The connection type for DiscussionComment.
    """

    edges: Optional[List[Optional[DiscussionCommentEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[DiscussionComment]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DiscussionCommentConnection']] = Field(
        'DiscussionCommentConnection', alias='__typename'
    )


class DiscussionCommentEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DiscussionComment] = None
    typename__: Optional[Literal['DiscussionCommentEdge']] = Field(
        'DiscussionCommentEdge', alias='__typename'
    )


class DiscussionConnection(BaseModel):
    """
    The connection type for Discussion.
    """

    edges: Optional[List[Optional[DiscussionEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Discussion]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DiscussionConnection']] = Field(
        'DiscussionConnection', alias='__typename'
    )


class DiscussionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Discussion] = None
    typename__: Optional[Literal['DiscussionEdge']] = Field(
        'DiscussionEdge', alias='__typename'
    )


class DiscussionPoll(Node):
    """
    A poll for a discussion.
    """

    discussion: Optional[Discussion] = None
    id: ID
    options: Optional[DiscussionPollOptionConnection] = None
    question: String
    totalVoteCount: Int
    viewerCanVote: Boolean
    viewerHasVoted: Boolean
    typename__: Optional[Literal['DiscussionPoll']] = Field(
        'DiscussionPoll', alias='__typename'
    )


class DiscussionPollOption(Node):
    """
    An option for a discussion poll.
    """

    id: ID
    option: String
    poll: Optional[DiscussionPoll] = None
    totalVoteCount: Int
    viewerHasVoted: Boolean
    typename__: Optional[Literal['DiscussionPollOption']] = Field(
        'DiscussionPollOption', alias='__typename'
    )


class DiscussionPollOptionConnection(BaseModel):
    """
    The connection type for DiscussionPollOption.
    """

    edges: Optional[List[Optional[DiscussionPollOptionEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[DiscussionPollOption]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['DiscussionPollOptionConnection']] = Field(
        'DiscussionPollOptionConnection', alias='__typename'
    )


class DiscussionPollOptionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[DiscussionPollOption] = None
    typename__: Optional[Literal['DiscussionPollOptionEdge']] = Field(
        'DiscussionPollOptionEdge', alias='__typename'
    )


class DismissPullRequestReviewPayload(BaseModel):
    """
    Autogenerated return type of DismissPullRequestReview
    """

    clientMutationId: Optional[String] = None
    pullRequestReview: Optional[PullRequestReview] = None
    typename__: Optional[Literal['DismissPullRequestReviewPayload']] = Field(
        'DismissPullRequestReviewPayload', alias='__typename'
    )


class DismissRepositoryVulnerabilityAlertPayload(BaseModel):
    """
    Autogenerated return type of DismissRepositoryVulnerabilityAlert
    """

    clientMutationId: Optional[String] = None
    repositoryVulnerabilityAlert: Optional[RepositoryVulnerabilityAlert] = None
    typename__: Optional[Literal['DismissRepositoryVulnerabilityAlertPayload']] = Field(
        'DismissRepositoryVulnerabilityAlertPayload', alias='__typename'
    )


class DraftIssue(Node):
    """
    A draft issue within a project.
    """

    assignees: UserConnection
    body: String
    bodyHTML: HTML
    bodyText: String
    createdAt: DateTime
    creator: Optional[Actor] = None
    id: ID
    projectV2Items: ProjectV2ItemConnection
    projectsV2: ProjectV2Connection
    title: String
    updatedAt: DateTime
    typename__: Optional[Literal['DraftIssue']] = Field(
        'DraftIssue', alias='__typename'
    )


class EnablePullRequestAutoMergePayload(BaseModel):
    """
    Autogenerated return type of EnablePullRequestAutoMerge
    """

    actor: Optional[Actor] = None
    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['EnablePullRequestAutoMergePayload']] = Field(
        'EnablePullRequestAutoMergePayload', alias='__typename'
    )


class EnqueuePullRequestPayload(BaseModel):
    """
    Autogenerated return type of EnqueuePullRequest
    """

    clientMutationId: Optional[String] = None
    mergeQueueEntry: Optional[MergeQueueEntry] = None
    typename__: Optional[Literal['EnqueuePullRequestPayload']] = Field(
        'EnqueuePullRequestPayload', alias='__typename'
    )


class Enterprise(AnnouncementBanner, Node):
    """
    An account to manage multiple organizations with consolidated policy and billing.
    """

    announcement: Optional[String] = None
    announcementExpiresAt: Optional[DateTime] = None
    announcementUserDismissible: Optional[Boolean] = None
    avatarUrl: URI
    billingInfo: Optional[EnterpriseBillingInfo] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    description: Optional[String] = None
    descriptionHTML: HTML
    id: ID
    location: Optional[String] = None
    members: EnterpriseMemberConnection
    name: String
    organizations: OrganizationConnection
    ownerInfo: Optional[EnterpriseOwnerInfo] = None
    resourcePath: URI
    slug: String
    url: URI
    viewerIsAdmin: Boolean
    websiteUrl: Optional[URI] = None
    typename__: Optional[Literal['Enterprise']] = Field(
        'Enterprise', alias='__typename'
    )


class EnterpriseAdministratorConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[EnterpriseAdministratorEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseAdministratorConnection']] = Field(
        'EnterpriseAdministratorConnection', alias='__typename'
    )


class EnterpriseAdministratorEdge(BaseModel):
    """
    A User who is an administrator of an enterprise.
    """

    cursor: String
    node: Optional[User] = None
    role: EnterpriseAdministratorRole
    typename__: Optional[Literal['EnterpriseAdministratorEdge']] = Field(
        'EnterpriseAdministratorEdge', alias='__typename'
    )


class EnterpriseAdministratorInvitation(Node):
    """
    An invitation for a user to become an owner or billing manager of an enterprise.
    """

    createdAt: DateTime
    email: Optional[String] = None
    enterprise: Enterprise
    id: ID
    invitee: Optional[User] = None
    inviter: Optional[User] = None
    role: EnterpriseAdministratorRole
    typename__: Optional[Literal['EnterpriseAdministratorInvitation']] = Field(
        'EnterpriseAdministratorInvitation', alias='__typename'
    )


class EnterpriseAdministratorInvitationConnection(BaseModel):
    """
    The connection type for EnterpriseAdministratorInvitation.
    """

    edges: Optional[List[Optional[EnterpriseAdministratorInvitationEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[EnterpriseAdministratorInvitation]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[
        Literal['EnterpriseAdministratorInvitationConnection']
    ] = Field('EnterpriseAdministratorInvitationConnection', alias='__typename')


class EnterpriseAdministratorInvitationEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[EnterpriseAdministratorInvitation] = None
    typename__: Optional[Literal['EnterpriseAdministratorInvitationEdge']] = Field(
        'EnterpriseAdministratorInvitationEdge', alias='__typename'
    )


class EnterpriseBillingInfo(BaseModel):
    """
    Enterprise billing information visible to enterprise billing managers and owners.
    """

    allLicensableUsersCount: Int
    assetPacks: Int
    bandwidthQuota: Float
    bandwidthUsage: Float
    bandwidthUsagePercentage: Int
    storageQuota: Float
    storageUsage: Float
    storageUsagePercentage: Int
    totalAvailableLicenses: Int
    totalLicenses: Int
    typename__: Optional[Literal['EnterpriseBillingInfo']] = Field(
        'EnterpriseBillingInfo', alias='__typename'
    )


class EnterpriseConnection(BaseModel):
    """
    The connection type for Enterprise.
    """

    edges: Optional[List[Optional[EnterpriseEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Enterprise]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseConnection']] = Field(
        'EnterpriseConnection', alias='__typename'
    )


class EnterpriseEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Enterprise] = None
    typename__: Optional[Literal['EnterpriseEdge']] = Field(
        'EnterpriseEdge', alias='__typename'
    )


class EnterpriseFailedInvitationConnection(BaseModel):
    """
    The connection type for OrganizationInvitation.
    """

    edges: Optional[List[Optional[EnterpriseFailedInvitationEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[OrganizationInvitation]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    totalUniqueUserCount: Int
    typename__: Optional[Literal['EnterpriseFailedInvitationConnection']] = Field(
        'EnterpriseFailedInvitationConnection', alias='__typename'
    )


class EnterpriseFailedInvitationEdge(BaseModel):
    """
    A failed invitation to be a member in an enterprise organization.
    """

    cursor: String
    node: Optional[OrganizationInvitation] = None
    typename__: Optional[Literal['EnterpriseFailedInvitationEdge']] = Field(
        'EnterpriseFailedInvitationEdge', alias='__typename'
    )


class EnterpriseIdentityProvider(Node):
    """
    An identity provider configured to provision identities for an enterprise.
    Visible to enterprise owners or enterprise owners' personal access tokens
    (classic) with read:enterprise or admin:enterprise scope.
    """

    digestMethod: Optional[SamlDigestAlgorithm] = None
    enterprise: Optional[Enterprise] = None
    externalIdentities: ExternalIdentityConnection
    id: ID
    idpCertificate: Optional[X509Certificate] = None
    issuer: Optional[String] = None
    recoveryCodes: Optional[List[String]] = Field(default_factory=list)
    signatureMethod: Optional[SamlSignatureAlgorithm] = None
    ssoUrl: Optional[URI] = None
    typename__: Optional[Literal['EnterpriseIdentityProvider']] = Field(
        'EnterpriseIdentityProvider', alias='__typename'
    )


class EnterpriseMemberConnection(BaseModel):
    """
    The connection type for EnterpriseMember.
    """

    edges: Optional[List[Optional[EnterpriseMemberEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[EnterpriseMember]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseMemberConnection']] = Field(
        'EnterpriseMemberConnection', alias='__typename'
    )


class EnterpriseMemberEdge(BaseModel):
    """
    A User who is a member of an enterprise through one or more organizations.
    """

    cursor: String
    node: Optional[EnterpriseMember] = None
    typename__: Optional[Literal['EnterpriseMemberEdge']] = Field(
        'EnterpriseMemberEdge', alias='__typename'
    )


class EnterpriseOrganizationMembershipConnection(BaseModel):
    """
    The connection type for Organization.
    """

    edges: Optional[List[Optional[EnterpriseOrganizationMembershipEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[Organization]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseOrganizationMembershipConnection']] = Field(
        'EnterpriseOrganizationMembershipConnection', alias='__typename'
    )


class EnterpriseOrganizationMembershipEdge(BaseModel):
    """
    An enterprise organization that a user is a member of.
    """

    cursor: String
    node: Optional[Organization] = None
    role: EnterpriseUserAccountMembershipRole
    typename__: Optional[Literal['EnterpriseOrganizationMembershipEdge']] = Field(
        'EnterpriseOrganizationMembershipEdge', alias='__typename'
    )


class EnterpriseOutsideCollaboratorConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[EnterpriseOutsideCollaboratorEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseOutsideCollaboratorConnection']] = Field(
        'EnterpriseOutsideCollaboratorConnection', alias='__typename'
    )


class EnterpriseOutsideCollaboratorEdge(BaseModel):
    """
    A User who is an outside collaborator of an enterprise through one or more organizations.
    """

    cursor: String
    node: Optional[User] = None
    repositories: EnterpriseRepositoryInfoConnection
    typename__: Optional[Literal['EnterpriseOutsideCollaboratorEdge']] = Field(
        'EnterpriseOutsideCollaboratorEdge', alias='__typename'
    )


class EnterpriseOwnerInfo(BaseModel):
    """
    Enterprise information visible to enterprise owners or enterprise owners'
    personal access tokens (classic) with read:enterprise or admin:enterprise scope.
    """

    admins: EnterpriseAdministratorConnection
    affiliatedUsersWithTwoFactorDisabled: UserConnection
    affiliatedUsersWithTwoFactorDisabledExist: Boolean
    allowPrivateRepositoryForkingSetting: EnterpriseEnabledDisabledSettingValue
    allowPrivateRepositoryForkingSettingOrganizations: OrganizationConnection
    allowPrivateRepositoryForkingSettingPolicyValue: Optional[
        EnterpriseAllowPrivateRepositoryForkingPolicyValue
    ] = None
    defaultRepositoryPermissionSetting: EnterpriseDefaultRepositoryPermissionSettingValue
    defaultRepositoryPermissionSettingOrganizations: OrganizationConnection
    domains: VerifiableDomainConnection
    enterpriseServerInstallations: EnterpriseServerInstallationConnection
    failedInvitations: EnterpriseFailedInvitationConnection
    ipAllowListEnabledSetting: IpAllowListEnabledSettingValue
    ipAllowListEntries: IpAllowListEntryConnection
    ipAllowListForInstalledAppsEnabledSetting: IpAllowListForInstalledAppsEnabledSettingValue
    isUpdatingDefaultRepositoryPermission: Boolean
    isUpdatingTwoFactorRequirement: Boolean
    membersCanChangeRepositoryVisibilitySetting: EnterpriseEnabledDisabledSettingValue
    membersCanChangeRepositoryVisibilitySettingOrganizations: OrganizationConnection
    membersCanCreateInternalRepositoriesSetting: Optional[Boolean] = None
    membersCanCreatePrivateRepositoriesSetting: Optional[Boolean] = None
    membersCanCreatePublicRepositoriesSetting: Optional[Boolean] = None
    membersCanCreateRepositoriesSetting: Optional[
        EnterpriseMembersCanCreateRepositoriesSettingValue
    ] = None
    membersCanCreateRepositoriesSettingOrganizations: OrganizationConnection
    membersCanDeleteIssuesSetting: EnterpriseEnabledDisabledSettingValue
    membersCanDeleteIssuesSettingOrganizations: OrganizationConnection
    membersCanDeleteRepositoriesSetting: EnterpriseEnabledDisabledSettingValue
    membersCanDeleteRepositoriesSettingOrganizations: OrganizationConnection
    membersCanInviteCollaboratorsSetting: EnterpriseEnabledDisabledSettingValue
    membersCanInviteCollaboratorsSettingOrganizations: OrganizationConnection
    membersCanMakePurchasesSetting: EnterpriseMembersCanMakePurchasesSettingValue
    membersCanUpdateProtectedBranchesSetting: EnterpriseEnabledDisabledSettingValue
    membersCanUpdateProtectedBranchesSettingOrganizations: OrganizationConnection
    membersCanViewDependencyInsightsSetting: EnterpriseEnabledDisabledSettingValue
    membersCanViewDependencyInsightsSettingOrganizations: OrganizationConnection
    notificationDeliveryRestrictionEnabledSetting: NotificationRestrictionSettingValue
    oidcProvider: Optional[OIDCProvider] = None
    organizationProjectsSetting: EnterpriseEnabledDisabledSettingValue
    organizationProjectsSettingOrganizations: OrganizationConnection
    outsideCollaborators: EnterpriseOutsideCollaboratorConnection
    pendingAdminInvitations: EnterpriseAdministratorInvitationConnection
    pendingCollaboratorInvitations: RepositoryInvitationConnection
    pendingMemberInvitations: EnterprisePendingMemberInvitationConnection
    repositoryProjectsSetting: EnterpriseEnabledDisabledSettingValue
    repositoryProjectsSettingOrganizations: OrganizationConnection
    samlIdentityProvider: Optional[EnterpriseIdentityProvider] = None
    samlIdentityProviderSettingOrganizations: OrganizationConnection
    supportEntitlements: EnterpriseMemberConnection
    teamDiscussionsSetting: EnterpriseEnabledDisabledSettingValue
    teamDiscussionsSettingOrganizations: OrganizationConnection
    twoFactorRequiredSetting: EnterpriseEnabledSettingValue
    twoFactorRequiredSettingOrganizations: OrganizationConnection
    typename__: Optional[Literal['EnterpriseOwnerInfo']] = Field(
        'EnterpriseOwnerInfo', alias='__typename'
    )


class EnterprisePendingMemberInvitationConnection(BaseModel):
    """
    The connection type for OrganizationInvitation.
    """

    edges: Optional[List[Optional[EnterprisePendingMemberInvitationEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[OrganizationInvitation]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    totalUniqueUserCount: Int
    typename__: Optional[
        Literal['EnterprisePendingMemberInvitationConnection']
    ] = Field('EnterprisePendingMemberInvitationConnection', alias='__typename')


class EnterprisePendingMemberInvitationEdge(BaseModel):
    """
    An invitation to be a member in an enterprise organization.
    """

    cursor: String
    node: Optional[OrganizationInvitation] = None
    typename__: Optional[Literal['EnterprisePendingMemberInvitationEdge']] = Field(
        'EnterprisePendingMemberInvitationEdge', alias='__typename'
    )


class EnterpriseRepositoryInfo(Node):
    """
    A subset of repository information queryable from an enterprise.
    """

    id: ID
    isPrivate: Boolean
    name: String
    nameWithOwner: String
    typename__: Optional[Literal['EnterpriseRepositoryInfo']] = Field(
        'EnterpriseRepositoryInfo', alias='__typename'
    )


class EnterpriseRepositoryInfoConnection(BaseModel):
    """
    The connection type for EnterpriseRepositoryInfo.
    """

    edges: Optional[List[Optional[EnterpriseRepositoryInfoEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[EnterpriseRepositoryInfo]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseRepositoryInfoConnection']] = Field(
        'EnterpriseRepositoryInfoConnection', alias='__typename'
    )


class EnterpriseRepositoryInfoEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[EnterpriseRepositoryInfo] = None
    typename__: Optional[Literal['EnterpriseRepositoryInfoEdge']] = Field(
        'EnterpriseRepositoryInfoEdge', alias='__typename'
    )


class EnterpriseServerInstallation(Node):
    """
    An Enterprise Server installation.
    """

    createdAt: DateTime
    customerName: String
    hostName: String
    id: ID
    isConnected: Boolean
    updatedAt: DateTime
    userAccounts: EnterpriseServerUserAccountConnection
    userAccountsUploads: EnterpriseServerUserAccountsUploadConnection
    typename__: Optional[Literal['EnterpriseServerInstallation']] = Field(
        'EnterpriseServerInstallation', alias='__typename'
    )


class EnterpriseServerInstallationConnection(BaseModel):
    """
    The connection type for EnterpriseServerInstallation.
    """

    edges: Optional[List[Optional[EnterpriseServerInstallationEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[EnterpriseServerInstallation]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseServerInstallationConnection']] = Field(
        'EnterpriseServerInstallationConnection', alias='__typename'
    )


class EnterpriseServerInstallationEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[EnterpriseServerInstallation] = None
    typename__: Optional[Literal['EnterpriseServerInstallationEdge']] = Field(
        'EnterpriseServerInstallationEdge', alias='__typename'
    )


class EnterpriseServerInstallationMembershipConnection(BaseModel):
    """
    The connection type for EnterpriseServerInstallation.
    """

    edges: Optional[List[Optional[EnterpriseServerInstallationMembershipEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[EnterpriseServerInstallation]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[
        Literal['EnterpriseServerInstallationMembershipConnection']
    ] = Field('EnterpriseServerInstallationMembershipConnection', alias='__typename')


class EnterpriseServerInstallationMembershipEdge(BaseModel):
    """
    An Enterprise Server installation that a user is a member of.
    """

    cursor: String
    node: Optional[EnterpriseServerInstallation] = None
    role: EnterpriseUserAccountMembershipRole
    typename__: Optional[Literal['EnterpriseServerInstallationMembershipEdge']] = Field(
        'EnterpriseServerInstallationMembershipEdge', alias='__typename'
    )


class EnterpriseServerUserAccount(Node):
    """
    A user account on an Enterprise Server installation.
    """

    createdAt: DateTime
    emails: EnterpriseServerUserAccountEmailConnection
    enterpriseServerInstallation: EnterpriseServerInstallation
    id: ID
    isSiteAdmin: Boolean
    login: String
    profileName: Optional[String] = None
    remoteCreatedAt: DateTime
    remoteUserId: Int
    updatedAt: DateTime
    typename__: Optional[Literal['EnterpriseServerUserAccount']] = Field(
        'EnterpriseServerUserAccount', alias='__typename'
    )


class EnterpriseServerUserAccountConnection(BaseModel):
    """
    The connection type for EnterpriseServerUserAccount.
    """

    edges: Optional[List[Optional[EnterpriseServerUserAccountEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[EnterpriseServerUserAccount]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseServerUserAccountConnection']] = Field(
        'EnterpriseServerUserAccountConnection', alias='__typename'
    )


class EnterpriseServerUserAccountEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[EnterpriseServerUserAccount] = None
    typename__: Optional[Literal['EnterpriseServerUserAccountEdge']] = Field(
        'EnterpriseServerUserAccountEdge', alias='__typename'
    )


class EnterpriseServerUserAccountEmail(Node):
    """
    An email belonging to a user account on an Enterprise Server installation.
    """

    createdAt: DateTime
    email: String
    id: ID
    isPrimary: Boolean
    updatedAt: DateTime
    userAccount: EnterpriseServerUserAccount
    typename__: Optional[Literal['EnterpriseServerUserAccountEmail']] = Field(
        'EnterpriseServerUserAccountEmail', alias='__typename'
    )


class EnterpriseServerUserAccountEmailConnection(BaseModel):
    """
    The connection type for EnterpriseServerUserAccountEmail.
    """

    edges: Optional[List[Optional[EnterpriseServerUserAccountEmailEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[EnterpriseServerUserAccountEmail]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnterpriseServerUserAccountEmailConnection']] = Field(
        'EnterpriseServerUserAccountEmailConnection', alias='__typename'
    )


class EnterpriseServerUserAccountEmailEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[EnterpriseServerUserAccountEmail] = None
    typename__: Optional[Literal['EnterpriseServerUserAccountEmailEdge']] = Field(
        'EnterpriseServerUserAccountEmailEdge', alias='__typename'
    )


class EnterpriseServerUserAccountsUpload(Node):
    """
    A user accounts upload from an Enterprise Server installation.
    """

    createdAt: DateTime
    enterprise: Enterprise
    enterpriseServerInstallation: EnterpriseServerInstallation
    id: ID
    name: String
    syncState: EnterpriseServerUserAccountsUploadSyncState
    updatedAt: DateTime
    typename__: Optional[Literal['EnterpriseServerUserAccountsUpload']] = Field(
        'EnterpriseServerUserAccountsUpload', alias='__typename'
    )


class EnterpriseServerUserAccountsUploadConnection(BaseModel):
    """
    The connection type for EnterpriseServerUserAccountsUpload.
    """

    edges: Optional[List[Optional[EnterpriseServerUserAccountsUploadEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[EnterpriseServerUserAccountsUpload]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[
        Literal['EnterpriseServerUserAccountsUploadConnection']
    ] = Field('EnterpriseServerUserAccountsUploadConnection', alias='__typename')


class EnterpriseServerUserAccountsUploadEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[EnterpriseServerUserAccountsUpload] = None
    typename__: Optional[Literal['EnterpriseServerUserAccountsUploadEdge']] = Field(
        'EnterpriseServerUserAccountsUploadEdge', alias='__typename'
    )


class EnterpriseUserAccount(Actor, Node):
    """
    An account for a user who is an admin of an enterprise or a member of an enterprise through one or more organizations.
    """

    avatarUrl: URI
    createdAt: DateTime
    enterprise: Enterprise
    enterpriseInstallations: EnterpriseServerInstallationMembershipConnection
    id: ID
    login: String
    name: Optional[String] = None
    organizations: EnterpriseOrganizationMembershipConnection
    resourcePath: URI
    updatedAt: DateTime
    url: URI
    user: Optional[User] = None
    typename__: Optional[Literal['EnterpriseUserAccount']] = Field(
        'EnterpriseUserAccount', alias='__typename'
    )


class Environment(Node):
    """
    An environment.
    """

    databaseId: Optional[Int] = None
    id: ID
    name: String
    protectionRules: DeploymentProtectionRuleConnection
    typename__: Optional[Literal['Environment']] = Field(
        'Environment', alias='__typename'
    )


class EnvironmentConnection(BaseModel):
    """
    The connection type for Environment.
    """

    edges: Optional[List[Optional[EnvironmentEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Environment]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['EnvironmentConnection']] = Field(
        'EnvironmentConnection', alias='__typename'
    )


class EnvironmentEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Environment] = None
    typename__: Optional[Literal['EnvironmentEdge']] = Field(
        'EnvironmentEdge', alias='__typename'
    )


class ExternalIdentity(Node):
    """
    An external identity provisioned by SAML SSO or SCIM. If SAML is configured on
    the organization, the external identity is visible to (1) organization owners,
    (2) organization owners' personal access tokens (classic) with read:org or
    admin:org scope, (3) GitHub App with an installation token with read or write
    access to members. If SAML is configured on the enterprise, the external
    identity is visible to (1) enterprise owners, (2) enterprise owners' personal
    access tokens (classic) with read:enterprise or admin:enterprise scope.
    """

    guid: String
    id: ID
    organizationInvitation: Optional[OrganizationInvitation] = None
    samlIdentity: Optional[ExternalIdentitySamlAttributes] = None
    scimIdentity: Optional[ExternalIdentityScimAttributes] = None
    user: Optional[User] = None
    typename__: Optional[Literal['ExternalIdentity']] = Field(
        'ExternalIdentity', alias='__typename'
    )


class ExternalIdentityAttribute(BaseModel):
    """
    An attribute for the External Identity attributes collection
    """

    metadata: Optional[String] = None
    name: String
    value: String
    typename__: Optional[Literal['ExternalIdentityAttribute']] = Field(
        'ExternalIdentityAttribute', alias='__typename'
    )


class ExternalIdentityConnection(BaseModel):
    """
    The connection type for ExternalIdentity.
    """

    edges: Optional[List[Optional[ExternalIdentityEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ExternalIdentity]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ExternalIdentityConnection']] = Field(
        'ExternalIdentityConnection', alias='__typename'
    )


class ExternalIdentityEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ExternalIdentity] = None
    typename__: Optional[Literal['ExternalIdentityEdge']] = Field(
        'ExternalIdentityEdge', alias='__typename'
    )


class ExternalIdentitySamlAttributes(BaseModel):
    """
    SAML attributes for the External Identity
    """

    attributes: List[ExternalIdentityAttribute]
    emails: Optional[List[UserEmailMetadata]] = Field(default_factory=list)
    familyName: Optional[String] = None
    givenName: Optional[String] = None
    groups: Optional[List[String]] = Field(default_factory=list)
    nameId: Optional[String] = None
    username: Optional[String] = None
    typename__: Optional[Literal['ExternalIdentitySamlAttributes']] = Field(
        'ExternalIdentitySamlAttributes', alias='__typename'
    )


class ExternalIdentityScimAttributes(BaseModel):
    """
    SCIM attributes for the External Identity
    """

    emails: Optional[List[UserEmailMetadata]] = Field(default_factory=list)
    familyName: Optional[String] = None
    givenName: Optional[String] = None
    groups: Optional[List[String]] = Field(default_factory=list)
    username: Optional[String] = None
    typename__: Optional[Literal['ExternalIdentityScimAttributes']] = Field(
        'ExternalIdentityScimAttributes', alias='__typename'
    )


class FollowOrganizationPayload(BaseModel):
    """
    Autogenerated return type of FollowOrganization
    """

    clientMutationId: Optional[String] = None
    organization: Optional[Organization] = None
    typename__: Optional[Literal['FollowOrganizationPayload']] = Field(
        'FollowOrganizationPayload', alias='__typename'
    )


class FollowUserPayload(BaseModel):
    """
    Autogenerated return type of FollowUser
    """

    clientMutationId: Optional[String] = None
    user: Optional[User] = None
    typename__: Optional[Literal['FollowUserPayload']] = Field(
        'FollowUserPayload', alias='__typename'
    )


class FollowerConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[UserEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['FollowerConnection']] = Field(
        'FollowerConnection', alias='__typename'
    )


class FollowingConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[UserEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['FollowingConnection']] = Field(
        'FollowingConnection', alias='__typename'
    )


class FundingLink(BaseModel):
    """
    A funding platform link for a repository.
    """

    platform: FundingPlatform
    url: URI
    typename__: Optional[Literal['FundingLink']] = Field(
        'FundingLink', alias='__typename'
    )


class GenericHovercardContext(HovercardContext):
    """
    A generic hovercard context with a message and icon
    """

    message: String
    octicon: String
    typename__: Optional[Literal['GenericHovercardContext']] = Field(
        'GenericHovercardContext', alias='__typename'
    )


class Gist(Node, Starrable, UniformResourceLocatable):
    """
    A Gist.
    """

    comments: GistCommentConnection
    createdAt: DateTime
    description: Optional[String] = None
    files: Optional[List[Optional[GistFile]]] = Field(default_factory=list)
    forks: GistConnection
    id: ID
    isFork: Boolean
    isPublic: Boolean
    name: String
    owner: Optional[RepositoryOwner] = None
    pushedAt: Optional[DateTime] = None
    resourcePath: URI
    stargazerCount: Int
    stargazers: StargazerConnection
    updatedAt: DateTime
    url: URI
    viewerHasStarred: Boolean
    typename__: Optional[Literal['Gist']] = Field('Gist', alias='__typename')


class GistComment(Comment, Deletable, Minimizable, Node, Updatable, UpdatableComment):
    """
    Represents a comment on an Gist.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    editor: Optional[Actor] = None
    gist: Gist
    id: ID
    includesCreatedEdit: Boolean
    isMinimized: Boolean
    lastEditedAt: Optional[DateTime] = None
    minimizedReason: Optional[String] = None
    publishedAt: Optional[DateTime] = None
    updatedAt: DateTime
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanDelete: Boolean
    viewerCanMinimize: Boolean
    viewerCanUpdate: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    typename__: Optional[Literal['GistComment']] = Field(
        'GistComment', alias='__typename'
    )


class GistCommentConnection(BaseModel):
    """
    The connection type for GistComment.
    """

    edges: Optional[List[Optional[GistCommentEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[GistComment]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['GistCommentConnection']] = Field(
        'GistCommentConnection', alias='__typename'
    )


class GistCommentEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[GistComment] = None
    typename__: Optional[Literal['GistCommentEdge']] = Field(
        'GistCommentEdge', alias='__typename'
    )


class GistConnection(BaseModel):
    """
    The connection type for Gist.
    """

    edges: Optional[List[Optional[GistEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Gist]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['GistConnection']] = Field(
        'GistConnection', alias='__typename'
    )


class GistEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Gist] = None
    typename__: Optional[Literal['GistEdge']] = Field('GistEdge', alias='__typename')


class GistFile(BaseModel):
    """
    A file in a gist.
    """

    encodedName: Optional[String] = None
    encoding: Optional[String] = None
    extension: Optional[String] = None
    isImage: Boolean
    isTruncated: Boolean
    language: Optional[Language] = None
    name: Optional[String] = None
    size: Optional[Int] = None
    text: Optional[String] = None
    typename__: Optional[Literal['GistFile']] = Field('GistFile', alias='__typename')


class GitActor(BaseModel):
    """
    Represents an actor in a Git commit (ie. an author or committer).
    """

    avatarUrl: URI
    date: Optional[GitTimestamp] = None
    email: Optional[String] = None
    name: Optional[String] = None
    user: Optional[User] = None
    typename__: Optional[Literal['GitActor']] = Field('GitActor', alias='__typename')


class GitActorConnection(BaseModel):
    """
    The connection type for GitActor.
    """

    edges: Optional[List[Optional[GitActorEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[GitActor]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['GitActorConnection']] = Field(
        'GitActorConnection', alias='__typename'
    )


class GitActorEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[GitActor] = None
    typename__: Optional[Literal['GitActorEdge']] = Field(
        'GitActorEdge', alias='__typename'
    )


class GitHubMetadata(BaseModel):
    """
    Represents information about the GitHub instance.
    """

    gitHubServicesSha: GitObjectID
    gitIpAddresses: Optional[List[String]] = Field(default_factory=list)
    githubEnterpriseImporterIpAddresses: Optional[List[String]] = Field(
        default_factory=list
    )
    hookIpAddresses: Optional[List[String]] = Field(default_factory=list)
    importerIpAddresses: Optional[List[String]] = Field(default_factory=list)
    isPasswordAuthenticationVerifiable: Boolean
    pagesIpAddresses: Optional[List[String]] = Field(default_factory=list)
    typename__: Optional[Literal['GitHubMetadata']] = Field(
        'GitHubMetadata', alias='__typename'
    )


class GpgSignature(GitSignature):
    """
    Represents a GPG signature on a Commit or Tag.
    """

    email: String
    isValid: Boolean
    keyId: Optional[String] = None
    payload: String
    signature: String
    signer: Optional[User] = None
    state: GitSignatureState
    wasSignedByGitHub: Boolean
    typename__: Optional[Literal['GpgSignature']] = Field(
        'GpgSignature', alias='__typename'
    )


class GrantEnterpriseOrganizationsMigratorRolePayload(BaseModel):
    """
    Autogenerated return type of GrantEnterpriseOrganizationsMigratorRole
    """

    clientMutationId: Optional[String] = None
    organizations: Optional[OrganizationConnection] = None
    typename__: Optional[
        Literal['GrantEnterpriseOrganizationsMigratorRolePayload']
    ] = Field('GrantEnterpriseOrganizationsMigratorRolePayload', alias='__typename')


class GrantMigratorRolePayload(BaseModel):
    """
    Autogenerated return type of GrantMigratorRole
    """

    clientMutationId: Optional[String] = None
    success: Optional[Boolean] = None
    typename__: Optional[Literal['GrantMigratorRolePayload']] = Field(
        'GrantMigratorRolePayload', alias='__typename'
    )


class HeadRefDeletedEvent(Node):
    """
    Represents a 'head_ref_deleted' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    headRef: Optional[Ref] = None
    headRefName: String
    id: ID
    pullRequest: PullRequest
    typename__: Optional[Literal['HeadRefDeletedEvent']] = Field(
        'HeadRefDeletedEvent', alias='__typename'
    )


class HeadRefForcePushedEvent(Node):
    """
    Represents a 'head_ref_force_pushed' event on a given pull request.
    """

    actor: Optional[Actor] = None
    afterCommit: Optional[Commit] = None
    beforeCommit: Optional[Commit] = None
    createdAt: DateTime
    id: ID
    pullRequest: PullRequest
    ref: Optional[Ref] = None
    typename__: Optional[Literal['HeadRefForcePushedEvent']] = Field(
        'HeadRefForcePushedEvent', alias='__typename'
    )


class HeadRefRestoredEvent(Node):
    """
    Represents a 'head_ref_restored' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    pullRequest: PullRequest
    typename__: Optional[Literal['HeadRefRestoredEvent']] = Field(
        'HeadRefRestoredEvent', alias='__typename'
    )


class Hovercard(BaseModel):
    """
    Detail needed to display a hovercard for a user
    """

    contexts: List[HovercardContext]
    typename__: Optional[Literal['Hovercard']] = Field('Hovercard', alias='__typename')


class ImportProjectPayload(BaseModel):
    """
    Autogenerated return type of ImportProject
    """

    clientMutationId: Optional[String] = None
    project: Optional[Project] = None
    typename__: Optional[Literal['ImportProjectPayload']] = Field(
        'ImportProjectPayload', alias='__typename'
    )


class InviteEnterpriseAdminPayload(BaseModel):
    """
    Autogenerated return type of InviteEnterpriseAdmin
    """

    clientMutationId: Optional[String] = None
    invitation: Optional[EnterpriseAdministratorInvitation] = None
    typename__: Optional[Literal['InviteEnterpriseAdminPayload']] = Field(
        'InviteEnterpriseAdminPayload', alias='__typename'
    )


class IpAllowListEntry(Node):
    """
    An IP address or range of addresses that is allowed to access an owner's resources.
    """

    allowListValue: String
    createdAt: DateTime
    id: ID
    isActive: Boolean
    name: Optional[String] = None
    owner: IpAllowListOwner
    updatedAt: DateTime
    typename__: Optional[Literal['IpAllowListEntry']] = Field(
        'IpAllowListEntry', alias='__typename'
    )


class IpAllowListEntryConnection(BaseModel):
    """
    The connection type for IpAllowListEntry.
    """

    edges: Optional[List[Optional[IpAllowListEntryEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[IpAllowListEntry]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['IpAllowListEntryConnection']] = Field(
        'IpAllowListEntryConnection', alias='__typename'
    )


class IpAllowListEntryEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[IpAllowListEntry] = None
    typename__: Optional[Literal['IpAllowListEntryEdge']] = Field(
        'IpAllowListEntryEdge', alias='__typename'
    )


class Issue(
    Assignable,
    Closable,
    Comment,
    Deletable,
    Labelable,
    Lockable,
    Node,
    ProjectV2Owner,
    Reactable,
    RepositoryNode,
    Subscribable,
    SubscribableThread,
    UniformResourceLocatable,
    Updatable,
    UpdatableComment,
):
    """
    An Issue is a place to discuss ideas, enhancements, tasks, and bugs for a project.
    """

    activeLockReason: Optional[LockReason] = None
    assignees: UserConnection
    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyResourcePath: URI
    bodyText: String
    bodyUrl: URI
    closed: Boolean
    closedAt: Optional[DateTime] = None
    comments: IssueCommentConnection
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    editor: Optional[Actor] = None
    fullDatabaseId: Optional[BigInt] = None
    hovercard: Hovercard
    id: ID
    includesCreatedEdit: Boolean
    isPinned: Optional[Boolean] = None
    isReadByViewer: Optional[Boolean] = None
    labels: Optional[LabelConnection] = None
    lastEditedAt: Optional[DateTime] = None
    linkedBranches: LinkedBranchConnection
    locked: Boolean
    milestone: Optional[Milestone] = None
    number: Int
    participants: UserConnection
    projectCards: ProjectCardConnection
    projectItems: ProjectV2ItemConnection
    projectV2: Optional[ProjectV2] = None
    projectsV2: ProjectV2Connection
    publishedAt: Optional[DateTime] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    repository: Repository
    resourcePath: URI
    state: IssueState
    stateReason: Optional[IssueStateReason] = None
    timeline: IssueTimelineConnection
    timelineItems: IssueTimelineItemsConnection
    title: String
    titleHTML: String
    trackedInIssues: IssueConnection
    trackedIssues: IssueConnection
    trackedIssuesCount: Int
    updatedAt: DateTime
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanClose: Boolean
    viewerCanDelete: Boolean
    viewerCanReact: Boolean
    viewerCanReopen: Boolean
    viewerCanSubscribe: Boolean
    viewerCanUpdate: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    viewerSubscription: Optional[SubscriptionState] = None
    viewerThreadSubscriptionFormAction: Optional[ThreadSubscriptionFormAction] = None
    viewerThreadSubscriptionStatus: Optional[ThreadSubscriptionState] = None
    typename__: Optional[Literal['Issue']] = Field('Issue', alias='__typename')


class IssueComment(
    Comment,
    Deletable,
    Minimizable,
    Node,
    Reactable,
    RepositoryNode,
    Updatable,
    UpdatableComment,
):
    """
    Represents a comment on an Issue.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    editor: Optional[Actor] = None
    fullDatabaseId: Optional[BigInt] = None
    id: ID
    includesCreatedEdit: Boolean
    isMinimized: Boolean
    issue: Issue
    lastEditedAt: Optional[DateTime] = None
    minimizedReason: Optional[String] = None
    publishedAt: Optional[DateTime] = None
    pullRequest: Optional[PullRequest] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    repository: Repository
    resourcePath: URI
    updatedAt: DateTime
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanDelete: Boolean
    viewerCanMinimize: Boolean
    viewerCanReact: Boolean
    viewerCanUpdate: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    typename__: Optional[Literal['IssueComment']] = Field(
        'IssueComment', alias='__typename'
    )


class IssueCommentConnection(BaseModel):
    """
    The connection type for IssueComment.
    """

    edges: Optional[List[Optional[IssueCommentEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[IssueComment]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['IssueCommentConnection']] = Field(
        'IssueCommentConnection', alias='__typename'
    )


class IssueCommentEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[IssueComment] = None
    typename__: Optional[Literal['IssueCommentEdge']] = Field(
        'IssueCommentEdge', alias='__typename'
    )


class IssueConnection(BaseModel):
    """
    The connection type for Issue.
    """

    edges: Optional[List[Optional[IssueEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Issue]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['IssueConnection']] = Field(
        'IssueConnection', alias='__typename'
    )


class IssueContributionsByRepository(BaseModel):
    """
    This aggregates issues opened by a user within one repository.
    """

    contributions: CreatedIssueContributionConnection
    repository: Repository
    typename__: Optional[Literal['IssueContributionsByRepository']] = Field(
        'IssueContributionsByRepository', alias='__typename'
    )


class IssueEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Issue] = None
    typename__: Optional[Literal['IssueEdge']] = Field('IssueEdge', alias='__typename')


class IssueTemplate(BaseModel):
    """
    A repository issue template.
    """

    about: Optional[String] = None
    assignees: UserConnection
    body: Optional[String] = None
    filename: String
    labels: Optional[LabelConnection] = None
    name: String
    title: Optional[String] = None
    typename__: Optional[Literal['IssueTemplate']] = Field(
        'IssueTemplate', alias='__typename'
    )


class IssueTimelineConnection(BaseModel):
    """
    The connection type for IssueTimelineItem.
    """

    edges: Optional[List[Optional[IssueTimelineItemEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[IssueTimelineItem]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['IssueTimelineConnection']] = Field(
        'IssueTimelineConnection', alias='__typename'
    )


class IssueTimelineItemEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[IssueTimelineItem] = None
    typename__: Optional[Literal['IssueTimelineItemEdge']] = Field(
        'IssueTimelineItemEdge', alias='__typename'
    )


class IssueTimelineItemsConnection(BaseModel):
    """
    The connection type for IssueTimelineItems.
    """

    edges: Optional[List[Optional[IssueTimelineItemsEdge]]] = Field(
        default_factory=list
    )
    filteredCount: Int
    nodes: Optional[List[Optional[IssueTimelineItems]]] = Field(default_factory=list)
    pageCount: Int
    pageInfo: PageInfo
    totalCount: Int
    updatedAt: DateTime
    typename__: Optional[Literal['IssueTimelineItemsConnection']] = Field(
        'IssueTimelineItemsConnection', alias='__typename'
    )


class IssueTimelineItemsEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[IssueTimelineItems] = None
    typename__: Optional[Literal['IssueTimelineItemsEdge']] = Field(
        'IssueTimelineItemsEdge', alias='__typename'
    )


class JoinedGitHubContribution(Contribution):
    """
    Represents a user signing up for a GitHub account.
    """

    isRestricted: Boolean
    occurredAt: DateTime
    resourcePath: URI
    url: URI
    user: User
    typename__: Optional[Literal['JoinedGitHubContribution']] = Field(
        'JoinedGitHubContribution', alias='__typename'
    )


class Label(Node):
    """
    A label for categorizing Issues, Pull Requests, Milestones, or Discussions with a given Repository.
    """

    color: String
    createdAt: Optional[DateTime] = None
    description: Optional[String] = None
    id: ID
    isDefault: Boolean
    issues: IssueConnection
    name: String
    pullRequests: PullRequestConnection
    repository: Repository
    resourcePath: URI
    updatedAt: Optional[DateTime] = None
    url: URI
    typename__: Optional[Literal['Label']] = Field('Label', alias='__typename')


class LabelConnection(BaseModel):
    """
    The connection type for Label.
    """

    edges: Optional[List[Optional[LabelEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Label]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['LabelConnection']] = Field(
        'LabelConnection', alias='__typename'
    )


class LabelEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Label] = None
    typename__: Optional[Literal['LabelEdge']] = Field('LabelEdge', alias='__typename')


class LabeledEvent(Node):
    """
    Represents a 'labeled' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    label: Label
    labelable: Labelable
    typename__: Optional[Literal['LabeledEvent']] = Field(
        'LabeledEvent', alias='__typename'
    )


class Language(Node):
    """
    Represents a given language found in repositories.
    """

    color: Optional[String] = None
    id: ID
    name: String
    typename__: Optional[Literal['Language']] = Field('Language', alias='__typename')


class LanguageConnection(BaseModel):
    """
    A list of languages associated with the parent.
    """

    edges: Optional[List[Optional[LanguageEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Language]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    totalSize: Int
    typename__: Optional[Literal['LanguageConnection']] = Field(
        'LanguageConnection', alias='__typename'
    )


class LanguageEdge(BaseModel):
    """
    Represents the language of a repository.
    """

    cursor: String
    node: Language
    size: Int
    typename__: Optional[Literal['LanguageEdge']] = Field(
        'LanguageEdge', alias='__typename'
    )


class License(Node):
    """
    A repository's open source license
    """

    body: String
    conditions: List[Optional[LicenseRule]]
    description: Optional[String] = None
    featured: Boolean
    hidden: Boolean
    id: ID
    implementation: Optional[String] = None
    key: String
    limitations: List[Optional[LicenseRule]]
    name: String
    nickname: Optional[String] = None
    permissions: List[Optional[LicenseRule]]
    pseudoLicense: Boolean
    spdxId: Optional[String] = None
    url: Optional[URI] = None
    typename__: Optional[Literal['License']] = Field('License', alias='__typename')


class LicenseRule(BaseModel):
    """
    Describes a License's conditions, permissions, and limitations
    """

    description: String
    key: String
    label: String
    typename__: Optional[Literal['LicenseRule']] = Field(
        'LicenseRule', alias='__typename'
    )


class LinkProjectV2ToRepositoryPayload(BaseModel):
    """
    Autogenerated return type of LinkProjectV2ToRepository
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['LinkProjectV2ToRepositoryPayload']] = Field(
        'LinkProjectV2ToRepositoryPayload', alias='__typename'
    )


class LinkProjectV2ToTeamPayload(BaseModel):
    """
    Autogenerated return type of LinkProjectV2ToTeam
    """

    clientMutationId: Optional[String] = None
    team: Optional[Team] = None
    typename__: Optional[Literal['LinkProjectV2ToTeamPayload']] = Field(
        'LinkProjectV2ToTeamPayload', alias='__typename'
    )


class LinkRepositoryToProjectPayload(BaseModel):
    """
    Autogenerated return type of LinkRepositoryToProject
    """

    clientMutationId: Optional[String] = None
    project: Optional[Project] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['LinkRepositoryToProjectPayload']] = Field(
        'LinkRepositoryToProjectPayload', alias='__typename'
    )


class LinkedBranch(Node):
    """
    A branch linked to an issue.
    """

    id: ID
    ref: Optional[Ref] = None
    typename__: Optional[Literal['LinkedBranch']] = Field(
        'LinkedBranch', alias='__typename'
    )


class LinkedBranchConnection(BaseModel):
    """
    The connection type for LinkedBranch.
    """

    edges: Optional[List[Optional[LinkedBranchEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[LinkedBranch]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['LinkedBranchConnection']] = Field(
        'LinkedBranchConnection', alias='__typename'
    )


class LinkedBranchEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[LinkedBranch] = None
    typename__: Optional[Literal['LinkedBranchEdge']] = Field(
        'LinkedBranchEdge', alias='__typename'
    )


class LockLockablePayload(BaseModel):
    """
    Autogenerated return type of LockLockable
    """

    actor: Optional[Actor] = None
    clientMutationId: Optional[String] = None
    lockedRecord: Optional[Lockable] = None
    typename__: Optional[Literal['LockLockablePayload']] = Field(
        'LockLockablePayload', alias='__typename'
    )


class LockedEvent(Node):
    """
    Represents a 'locked' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    lockReason: Optional[LockReason] = None
    lockable: Lockable
    typename__: Optional[Literal['LockedEvent']] = Field(
        'LockedEvent', alias='__typename'
    )


class Mannequin(Actor, Node, UniformResourceLocatable):
    """
    A placeholder user for attribution of imported data on GitHub.
    """

    avatarUrl: URI
    claimant: Optional[User] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    email: Optional[String] = None
    id: ID
    login: String
    resourcePath: URI
    updatedAt: DateTime
    url: URI
    typename__: Optional[Literal['Mannequin']] = Field('Mannequin', alias='__typename')


class MannequinConnection(BaseModel):
    """
    The connection type for Mannequin.
    """

    edges: Optional[List[Optional[MannequinEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Mannequin]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['MannequinConnection']] = Field(
        'MannequinConnection', alias='__typename'
    )


class MannequinEdge(BaseModel):
    """
    Represents a mannequin.
    """

    cursor: String
    node: Optional[Mannequin] = None
    typename__: Optional[Literal['MannequinEdge']] = Field(
        'MannequinEdge', alias='__typename'
    )


class MarkDiscussionCommentAsAnswerPayload(BaseModel):
    """
    Autogenerated return type of MarkDiscussionCommentAsAnswer
    """

    clientMutationId: Optional[String] = None
    discussion: Optional[Discussion] = None
    typename__: Optional[Literal['MarkDiscussionCommentAsAnswerPayload']] = Field(
        'MarkDiscussionCommentAsAnswerPayload', alias='__typename'
    )


class MarkFileAsViewedPayload(BaseModel):
    """
    Autogenerated return type of MarkFileAsViewed
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['MarkFileAsViewedPayload']] = Field(
        'MarkFileAsViewedPayload', alias='__typename'
    )


class MarkProjectV2AsTemplatePayload(BaseModel):
    """
    Autogenerated return type of MarkProjectV2AsTemplate
    """

    clientMutationId: Optional[String] = None
    projectV2: Optional[ProjectV2] = None
    typename__: Optional[Literal['MarkProjectV2AsTemplatePayload']] = Field(
        'MarkProjectV2AsTemplatePayload', alias='__typename'
    )


class MarkPullRequestReadyForReviewPayload(BaseModel):
    """
    Autogenerated return type of MarkPullRequestReadyForReview
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['MarkPullRequestReadyForReviewPayload']] = Field(
        'MarkPullRequestReadyForReviewPayload', alias='__typename'
    )


class MarkedAsDuplicateEvent(Node):
    """
    Represents a 'marked_as_duplicate' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    canonical: Optional[IssueOrPullRequest] = None
    createdAt: DateTime
    duplicate: Optional[IssueOrPullRequest] = None
    id: ID
    isCrossRepository: Boolean
    typename__: Optional[Literal['MarkedAsDuplicateEvent']] = Field(
        'MarkedAsDuplicateEvent', alias='__typename'
    )


class MarketplaceCategory(Node):
    """
    A public description of a Marketplace category.
    """

    description: Optional[String] = None
    howItWorks: Optional[String] = None
    id: ID
    name: String
    primaryListingCount: Int
    resourcePath: URI
    secondaryListingCount: Int
    slug: String
    url: URI
    typename__: Optional[Literal['MarketplaceCategory']] = Field(
        'MarketplaceCategory', alias='__typename'
    )


class MarketplaceListing(Node):
    """
    A listing in the GitHub integration marketplace.
    """

    app: Optional[App] = None
    companyUrl: Optional[URI] = None
    configurationResourcePath: URI
    configurationUrl: URI
    documentationUrl: Optional[URI] = None
    extendedDescription: Optional[String] = None
    extendedDescriptionHTML: HTML
    fullDescription: String
    fullDescriptionHTML: HTML
    hasPublishedFreeTrialPlans: Boolean
    hasTermsOfService: Boolean
    hasVerifiedOwner: Boolean
    howItWorks: Optional[String] = None
    howItWorksHTML: HTML
    id: ID
    installationUrl: Optional[URI] = None
    installedForViewer: Boolean
    isArchived: Boolean
    isDraft: Boolean
    isPaid: Boolean
    isPublic: Boolean
    isRejected: Boolean
    isUnverified: Boolean
    isUnverifiedPending: Boolean
    isVerificationPendingFromDraft: Boolean
    isVerificationPendingFromUnverified: Boolean
    isVerified: Boolean
    logoBackgroundColor: String
    logoUrl: Optional[URI] = None
    name: String
    normalizedShortDescription: String
    pricingUrl: Optional[URI] = None
    primaryCategory: MarketplaceCategory
    privacyPolicyUrl: URI
    resourcePath: URI
    screenshotUrls: List[Optional[String]]
    secondaryCategory: Optional[MarketplaceCategory] = None
    shortDescription: String
    slug: String
    statusUrl: Optional[URI] = None
    supportEmail: Optional[String] = None
    supportUrl: URI
    termsOfServiceUrl: Optional[URI] = None
    url: URI
    viewerCanAddPlans: Boolean
    viewerCanApprove: Boolean
    viewerCanDelist: Boolean
    viewerCanEdit: Boolean
    viewerCanEditCategories: Boolean
    viewerCanEditPlans: Boolean
    viewerCanRedraft: Boolean
    viewerCanReject: Boolean
    viewerCanRequestApproval: Boolean
    viewerHasPurchased: Boolean
    viewerHasPurchasedForAllOrganizations: Boolean
    viewerIsListingAdmin: Boolean
    typename__: Optional[Literal['MarketplaceListing']] = Field(
        'MarketplaceListing', alias='__typename'
    )


class MarketplaceListingConnection(BaseModel):
    """
    Look up Marketplace Listings
    """

    edges: Optional[List[Optional[MarketplaceListingEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[MarketplaceListing]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['MarketplaceListingConnection']] = Field(
        'MarketplaceListingConnection', alias='__typename'
    )


class MarketplaceListingEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[MarketplaceListing] = None
    typename__: Optional[Literal['MarketplaceListingEdge']] = Field(
        'MarketplaceListingEdge', alias='__typename'
    )


class MemberFeatureRequestNotification(Node):
    """
    Represents a member feature request notification
    """

    body: String
    id: ID
    title: String
    updatedAt: DateTime
    typename__: Optional[Literal['MemberFeatureRequestNotification']] = Field(
        'MemberFeatureRequestNotification', alias='__typename'
    )


class MembersCanDeleteReposClearAuditEntry(
    AuditEntry, EnterpriseAuditEntryData, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a members_can_delete_repos.clear event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['MembersCanDeleteReposClearAuditEntry']] = Field(
        'MembersCanDeleteReposClearAuditEntry', alias='__typename'
    )


class MembersCanDeleteReposDisableAuditEntry(
    AuditEntry, EnterpriseAuditEntryData, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a members_can_delete_repos.disable event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['MembersCanDeleteReposDisableAuditEntry']] = Field(
        'MembersCanDeleteReposDisableAuditEntry', alias='__typename'
    )


class MembersCanDeleteReposEnableAuditEntry(
    AuditEntry, EnterpriseAuditEntryData, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a members_can_delete_repos.enable event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['MembersCanDeleteReposEnableAuditEntry']] = Field(
        'MembersCanDeleteReposEnableAuditEntry', alias='__typename'
    )


class MentionedEvent(Node):
    """
    Represents a 'mentioned' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    typename__: Optional[Literal['MentionedEvent']] = Field(
        'MentionedEvent', alias='__typename'
    )


class MergeBranchPayload(BaseModel):
    """
    Autogenerated return type of MergeBranch
    """

    clientMutationId: Optional[String] = None
    mergeCommit: Optional[Commit] = None
    typename__: Optional[Literal['MergeBranchPayload']] = Field(
        'MergeBranchPayload', alias='__typename'
    )


class MergePullRequestPayload(BaseModel):
    """
    Autogenerated return type of MergePullRequest
    """

    actor: Optional[Actor] = None
    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['MergePullRequestPayload']] = Field(
        'MergePullRequestPayload', alias='__typename'
    )


class MergeQueue(Node):
    """
    The queue of pull request entries to be merged into a protected branch in a repository.
    """

    configuration: Optional[MergeQueueConfiguration] = None
    entries: Optional[MergeQueueEntryConnection] = None
    id: ID
    nextEntryEstimatedTimeToMerge: Optional[Int] = None
    repository: Optional[Repository] = None
    resourcePath: URI
    url: URI
    typename__: Optional[Literal['MergeQueue']] = Field(
        'MergeQueue', alias='__typename'
    )


class MergeQueueConfiguration(BaseModel):
    """
    Configuration for a MergeQueue
    """

    checkResponseTimeout: Optional[Int] = None
    maximumEntriesToBuild: Optional[Int] = None
    maximumEntriesToMerge: Optional[Int] = None
    mergeMethod: Optional[PullRequestMergeMethod] = None
    mergingStrategy: Optional[MergeQueueMergingStrategy] = None
    minimumEntriesToMerge: Optional[Int] = None
    minimumEntriesToMergeWaitTime: Optional[Int] = None
    typename__: Optional[Literal['MergeQueueConfiguration']] = Field(
        'MergeQueueConfiguration', alias='__typename'
    )


class MergeQueueEntry(Node):
    """
    Entries in a MergeQueue
    """

    baseCommit: Optional[Commit] = None
    enqueuedAt: DateTime
    enqueuer: Actor
    estimatedTimeToMerge: Optional[Int] = None
    headCommit: Optional[Commit] = None
    id: ID
    jump: Boolean
    mergeQueue: Optional[MergeQueue] = None
    position: Int
    pullRequest: Optional[PullRequest] = None
    solo: Boolean
    state: MergeQueueEntryState
    typename__: Optional[Literal['MergeQueueEntry']] = Field(
        'MergeQueueEntry', alias='__typename'
    )


class MergeQueueEntryConnection(BaseModel):
    """
    The connection type for MergeQueueEntry.
    """

    edges: Optional[List[Optional[MergeQueueEntryEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[MergeQueueEntry]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['MergeQueueEntryConnection']] = Field(
        'MergeQueueEntryConnection', alias='__typename'
    )


class MergeQueueEntryEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[MergeQueueEntry] = None
    typename__: Optional[Literal['MergeQueueEntryEdge']] = Field(
        'MergeQueueEntryEdge', alias='__typename'
    )


class MergedEvent(Node, UniformResourceLocatable):
    """
    Represents a 'merged' event on a given pull request.
    """

    actor: Optional[Actor] = None
    commit: Optional[Commit] = None
    createdAt: DateTime
    id: ID
    mergeRef: Optional[Ref] = None
    mergeRefName: String
    pullRequest: PullRequest
    resourcePath: URI
    url: URI
    typename__: Optional[Literal['MergedEvent']] = Field(
        'MergedEvent', alias='__typename'
    )


class MigrationSource(Node):
    """
    A GitHub Enterprise Importer (GEI) migration source.
    """

    id: ID
    name: String
    type: MigrationSourceType
    url: URI
    typename__: Optional[Literal['MigrationSource']] = Field(
        'MigrationSource', alias='__typename'
    )


class Milestone(Closable, Node, UniformResourceLocatable):
    """
    Represents a Milestone object on a given repository.
    """

    closed: Boolean
    closedAt: Optional[DateTime] = None
    createdAt: DateTime
    creator: Optional[Actor] = None
    description: Optional[String] = None
    dueOn: Optional[DateTime] = None
    id: ID
    issues: IssueConnection
    number: Int
    progressPercentage: Float
    pullRequests: PullRequestConnection
    repository: Repository
    resourcePath: URI
    state: MilestoneState
    title: String
    updatedAt: DateTime
    url: URI
    viewerCanClose: Boolean
    viewerCanReopen: Boolean
    typename__: Optional[Literal['Milestone']] = Field('Milestone', alias='__typename')


class MilestoneConnection(BaseModel):
    """
    The connection type for Milestone.
    """

    edges: Optional[List[Optional[MilestoneEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Milestone]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['MilestoneConnection']] = Field(
        'MilestoneConnection', alias='__typename'
    )


class MilestoneEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Milestone] = None
    typename__: Optional[Literal['MilestoneEdge']] = Field(
        'MilestoneEdge', alias='__typename'
    )


class MilestonedEvent(Node):
    """
    Represents a 'milestoned' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    milestoneTitle: String
    subject: MilestoneItem
    typename__: Optional[Literal['MilestonedEvent']] = Field(
        'MilestonedEvent', alias='__typename'
    )


class MinimizeCommentPayload(BaseModel):
    """
    Autogenerated return type of MinimizeComment
    """

    clientMutationId: Optional[String] = None
    minimizedComment: Optional[Minimizable] = None
    typename__: Optional[Literal['MinimizeCommentPayload']] = Field(
        'MinimizeCommentPayload', alias='__typename'
    )


class MoveProjectCardPayload(BaseModel):
    """
    Autogenerated return type of MoveProjectCard
    """

    cardEdge: Optional[ProjectCardEdge] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['MoveProjectCardPayload']] = Field(
        'MoveProjectCardPayload', alias='__typename'
    )


class MoveProjectColumnPayload(BaseModel):
    """
    Autogenerated return type of MoveProjectColumn
    """

    clientMutationId: Optional[String] = None
    columnEdge: Optional[ProjectColumnEdge] = None
    typename__: Optional[Literal['MoveProjectColumnPayload']] = Field(
        'MoveProjectColumnPayload', alias='__typename'
    )


class MovedColumnsInProjectEvent(Node):
    """
    Represents a 'moved_columns_in_project' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    previousProjectColumnName: String
    project: Optional[Project] = None
    projectCard: Optional[ProjectCard] = None
    projectColumnName: String
    typename__: Optional[Literal['MovedColumnsInProjectEvent']] = Field(
        'MovedColumnsInProjectEvent', alias='__typename'
    )


class OIDCProvider(Node):
    """
    An OIDC identity provider configured to provision identities for an enterprise.
    Visible to enterprise owners or enterprise owners' personal access tokens
    (classic) with read:enterprise or admin:enterprise scope.
    """

    enterprise: Optional[Enterprise] = None
    externalIdentities: ExternalIdentityConnection
    id: ID
    providerType: OIDCProviderType
    tenantId: String
    typename__: Optional[Literal['OIDCProvider']] = Field(
        'OIDCProvider', alias='__typename'
    )


class OauthApplicationCreateAuditEntry(
    AuditEntry, Node, OauthApplicationAuditEntryData, OrganizationAuditEntryData
):
    """
    Audit log entry for a oauth_application.create event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    applicationUrl: Optional[URI] = None
    callbackUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    oauthApplicationName: Optional[String] = None
    oauthApplicationResourcePath: Optional[URI] = None
    oauthApplicationUrl: Optional[URI] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    rateLimit: Optional[Int] = None
    state: Optional[OauthApplicationCreateAuditEntryState] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OauthApplicationCreateAuditEntry']] = Field(
        'OauthApplicationCreateAuditEntry', alias='__typename'
    )


class OrgAddBillingManagerAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.add_billing_manager
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    invitationEmail: Optional[String] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgAddBillingManagerAuditEntry']] = Field(
        'OrgAddBillingManagerAuditEntry', alias='__typename'
    )


class OrgAddMemberAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.add_member
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    permission: Optional[OrgAddMemberAuditEntryPermission] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgAddMemberAuditEntry']] = Field(
        'OrgAddMemberAuditEntry', alias='__typename'
    )


class OrgBlockUserAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.block_user
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    blockedUser: Optional[User] = None
    blockedUserName: Optional[String] = None
    blockedUserResourcePath: Optional[URI] = None
    blockedUserUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgBlockUserAuditEntry']] = Field(
        'OrgBlockUserAuditEntry', alias='__typename'
    )


class OrgConfigDisableCollaboratorsOnlyAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.config.disable_collaborators_only event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['OrgConfigDisableCollaboratorsOnlyAuditEntry']
    ] = Field('OrgConfigDisableCollaboratorsOnlyAuditEntry', alias='__typename')


class OrgConfigEnableCollaboratorsOnlyAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.config.enable_collaborators_only event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgConfigEnableCollaboratorsOnlyAuditEntry']] = Field(
        'OrgConfigEnableCollaboratorsOnlyAuditEntry', alias='__typename'
    )


class OrgCreateAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.create event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    billingPlan: Optional[OrgCreateAuditEntryBillingPlan] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgCreateAuditEntry']] = Field(
        'OrgCreateAuditEntry', alias='__typename'
    )


class OrgDisableOauthAppRestrictionsAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.disable_oauth_app_restrictions event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgDisableOauthAppRestrictionsAuditEntry']] = Field(
        'OrgDisableOauthAppRestrictionsAuditEntry', alias='__typename'
    )


class OrgDisableSamlAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.disable_saml event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    digestMethodUrl: Optional[URI] = None
    id: ID
    issuerUrl: Optional[URI] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    signatureMethodUrl: Optional[URI] = None
    singleSignOnUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgDisableSamlAuditEntry']] = Field(
        'OrgDisableSamlAuditEntry', alias='__typename'
    )


class OrgDisableTwoFactorRequirementAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.disable_two_factor_requirement event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgDisableTwoFactorRequirementAuditEntry']] = Field(
        'OrgDisableTwoFactorRequirementAuditEntry', alias='__typename'
    )


class OrgEnableOauthAppRestrictionsAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.enable_oauth_app_restrictions event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgEnableOauthAppRestrictionsAuditEntry']] = Field(
        'OrgEnableOauthAppRestrictionsAuditEntry', alias='__typename'
    )


class OrgEnableSamlAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.enable_saml event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    digestMethodUrl: Optional[URI] = None
    id: ID
    issuerUrl: Optional[URI] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    signatureMethodUrl: Optional[URI] = None
    singleSignOnUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgEnableSamlAuditEntry']] = Field(
        'OrgEnableSamlAuditEntry', alias='__typename'
    )


class OrgEnableTwoFactorRequirementAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.enable_two_factor_requirement event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgEnableTwoFactorRequirementAuditEntry']] = Field(
        'OrgEnableTwoFactorRequirementAuditEntry', alias='__typename'
    )


class OrgInviteMemberAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.invite_member event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    email: Optional[String] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationInvitation: Optional[OrganizationInvitation] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgInviteMemberAuditEntry']] = Field(
        'OrgInviteMemberAuditEntry', alias='__typename'
    )


class OrgInviteToBusinessAuditEntry(
    AuditEntry, EnterpriseAuditEntryData, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.invite_to_business event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgInviteToBusinessAuditEntry']] = Field(
        'OrgInviteToBusinessAuditEntry', alias='__typename'
    )


class OrgOauthAppAccessApprovedAuditEntry(
    AuditEntry, Node, OauthApplicationAuditEntryData, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.oauth_app_access_approved event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    oauthApplicationName: Optional[String] = None
    oauthApplicationResourcePath: Optional[URI] = None
    oauthApplicationUrl: Optional[URI] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgOauthAppAccessApprovedAuditEntry']] = Field(
        'OrgOauthAppAccessApprovedAuditEntry', alias='__typename'
    )


class OrgOauthAppAccessBlockedAuditEntry(
    AuditEntry, Node, OauthApplicationAuditEntryData, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.oauth_app_access_blocked event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    oauthApplicationName: Optional[String] = None
    oauthApplicationResourcePath: Optional[URI] = None
    oauthApplicationUrl: Optional[URI] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgOauthAppAccessBlockedAuditEntry']] = Field(
        'OrgOauthAppAccessBlockedAuditEntry', alias='__typename'
    )


class OrgOauthAppAccessDeniedAuditEntry(
    AuditEntry, Node, OauthApplicationAuditEntryData, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.oauth_app_access_denied event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    oauthApplicationName: Optional[String] = None
    oauthApplicationResourcePath: Optional[URI] = None
    oauthApplicationUrl: Optional[URI] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgOauthAppAccessDeniedAuditEntry']] = Field(
        'OrgOauthAppAccessDeniedAuditEntry', alias='__typename'
    )


class OrgOauthAppAccessRequestedAuditEntry(
    AuditEntry, Node, OauthApplicationAuditEntryData, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.oauth_app_access_requested event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    oauthApplicationName: Optional[String] = None
    oauthApplicationResourcePath: Optional[URI] = None
    oauthApplicationUrl: Optional[URI] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgOauthAppAccessRequestedAuditEntry']] = Field(
        'OrgOauthAppAccessRequestedAuditEntry', alias='__typename'
    )


class OrgOauthAppAccessUnblockedAuditEntry(
    AuditEntry, Node, OauthApplicationAuditEntryData, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.oauth_app_access_unblocked event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    oauthApplicationName: Optional[String] = None
    oauthApplicationResourcePath: Optional[URI] = None
    oauthApplicationUrl: Optional[URI] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgOauthAppAccessUnblockedAuditEntry']] = Field(
        'OrgOauthAppAccessUnblockedAuditEntry', alias='__typename'
    )


class OrgRemoveBillingManagerAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.remove_billing_manager event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    reason: Optional[OrgRemoveBillingManagerAuditEntryReason] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgRemoveBillingManagerAuditEntry']] = Field(
        'OrgRemoveBillingManagerAuditEntry', alias='__typename'
    )


class OrgRemoveMemberAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.remove_member event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    membershipTypes: Optional[List[OrgRemoveMemberAuditEntryMembershipType]] = Field(
        default_factory=list
    )
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    reason: Optional[OrgRemoveMemberAuditEntryReason] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgRemoveMemberAuditEntry']] = Field(
        'OrgRemoveMemberAuditEntry', alias='__typename'
    )


class OrgRemoveOutsideCollaboratorAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.remove_outside_collaborator event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    membershipTypes: Optional[
        List[OrgRemoveOutsideCollaboratorAuditEntryMembershipType]
    ] = Field(default_factory=list)
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    reason: Optional[OrgRemoveOutsideCollaboratorAuditEntryReason] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgRemoveOutsideCollaboratorAuditEntry']] = Field(
        'OrgRemoveOutsideCollaboratorAuditEntry', alias='__typename'
    )


class OrgRestoreMemberAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.restore_member event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    restoredCustomEmailRoutingsCount: Optional[Int] = None
    restoredIssueAssignmentsCount: Optional[Int] = None
    restoredMemberships: Optional[List[OrgRestoreMemberAuditEntryMembership]] = Field(
        default_factory=list
    )
    restoredMembershipsCount: Optional[Int] = None
    restoredRepositoriesCount: Optional[Int] = None
    restoredRepositoryStarsCount: Optional[Int] = None
    restoredRepositoryWatchesCount: Optional[Int] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgRestoreMemberAuditEntry']] = Field(
        'OrgRestoreMemberAuditEntry', alias='__typename'
    )


class OrgRestoreMemberMembershipOrganizationAuditEntryData(OrganizationAuditEntryData):
    """
    Metadata for an organization membership for org.restore_member actions
    """

    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    typename__: Optional[
        Literal['OrgRestoreMemberMembershipOrganizationAuditEntryData']
    ] = Field(
        'OrgRestoreMemberMembershipOrganizationAuditEntryData', alias='__typename'
    )


class OrgRestoreMemberMembershipRepositoryAuditEntryData(RepositoryAuditEntryData):
    """
    Metadata for a repository membership for org.restore_member actions
    """

    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    typename__: Optional[
        Literal['OrgRestoreMemberMembershipRepositoryAuditEntryData']
    ] = Field('OrgRestoreMemberMembershipRepositoryAuditEntryData', alias='__typename')


class OrgRestoreMemberMembershipTeamAuditEntryData(TeamAuditEntryData):
    """
    Metadata for a team membership for org.restore_member actions
    """

    team: Optional[Team] = None
    teamName: Optional[String] = None
    teamResourcePath: Optional[URI] = None
    teamUrl: Optional[URI] = None
    typename__: Optional[
        Literal['OrgRestoreMemberMembershipTeamAuditEntryData']
    ] = Field('OrgRestoreMemberMembershipTeamAuditEntryData', alias='__typename')


class OrgUnblockUserAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.unblock_user
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    blockedUser: Optional[User] = None
    blockedUserName: Optional[String] = None
    blockedUserResourcePath: Optional[URI] = None
    blockedUserUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgUnblockUserAuditEntry']] = Field(
        'OrgUnblockUserAuditEntry', alias='__typename'
    )


class OrgUpdateDefaultRepositoryPermissionAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.update_default_repository_permission
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    permission: Optional[
        OrgUpdateDefaultRepositoryPermissionAuditEntryPermission
    ] = None
    permissionWas: Optional[
        OrgUpdateDefaultRepositoryPermissionAuditEntryPermission
    ] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['OrgUpdateDefaultRepositoryPermissionAuditEntry']
    ] = Field('OrgUpdateDefaultRepositoryPermissionAuditEntry', alias='__typename')


class OrgUpdateMemberAuditEntry(AuditEntry, Node, OrganizationAuditEntryData):
    """
    Audit log entry for a org.update_member event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    permission: Optional[OrgUpdateMemberAuditEntryPermission] = None
    permissionWas: Optional[OrgUpdateMemberAuditEntryPermission] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['OrgUpdateMemberAuditEntry']] = Field(
        'OrgUpdateMemberAuditEntry', alias='__typename'
    )


class OrgUpdateMemberRepositoryCreationPermissionAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.update_member_repository_creation_permission event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    canCreateRepositories: Optional[Boolean] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    visibility: Optional[
        OrgUpdateMemberRepositoryCreationPermissionAuditEntryVisibility
    ] = None
    typename__: Optional[
        Literal['OrgUpdateMemberRepositoryCreationPermissionAuditEntry']
    ] = Field(
        'OrgUpdateMemberRepositoryCreationPermissionAuditEntry', alias='__typename'
    )


class OrgUpdateMemberRepositoryInvitationPermissionAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a org.update_member_repository_invitation_permission event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    canInviteOutsideCollaboratorsToRepositories: Optional[Boolean] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['OrgUpdateMemberRepositoryInvitationPermissionAuditEntry']
    ] = Field(
        'OrgUpdateMemberRepositoryInvitationPermissionAuditEntry', alias='__typename'
    )


class Organization(
    Actor,
    AnnouncementBanner,
    MemberStatusable,
    Node,
    PackageOwner,
    ProfileOwner,
    ProjectOwner,
    ProjectV2Owner,
    ProjectV2Recent,
    RepositoryDiscussionAuthor,
    RepositoryDiscussionCommentAuthor,
    RepositoryOwner,
    Sponsorable,
    UniformResourceLocatable,
):
    """
    An account on GitHub, with one or more owners, that has repositories, members and teams.
    """

    announcement: Optional[String] = None
    announcementExpiresAt: Optional[DateTime] = None
    announcementUserDismissible: Optional[Boolean] = None
    anyPinnableItems: Boolean
    archivedAt: Optional[DateTime] = None
    auditLog: OrganizationAuditEntryConnection
    avatarUrl: URI
    createdAt: DateTime
    databaseId: Optional[Int] = None
    description: Optional[String] = None
    descriptionHTML: Optional[String] = None
    domains: Optional[VerifiableDomainConnection] = None
    email: Optional[String] = None
    enterpriseOwners: OrganizationEnterpriseOwnerConnection
    estimatedNextSponsorsPayoutInCents: Int
    hasSponsorsListing: Boolean
    id: ID
    interactionAbility: Optional[RepositoryInteractionAbility] = None
    ipAllowListEnabledSetting: IpAllowListEnabledSettingValue
    ipAllowListEntries: IpAllowListEntryConnection
    ipAllowListForInstalledAppsEnabledSetting: IpAllowListForInstalledAppsEnabledSettingValue
    isSponsoredBy: Boolean
    isSponsoringViewer: Boolean
    isVerified: Boolean
    itemShowcase: ProfileItemShowcase
    location: Optional[String] = None
    login: String
    mannequins: MannequinConnection
    memberStatuses: UserStatusConnection
    membersCanForkPrivateRepositories: Boolean
    membersWithRole: OrganizationMemberConnection
    monthlyEstimatedSponsorsIncomeInCents: Int
    name: Optional[String] = None
    newTeamResourcePath: URI
    newTeamUrl: URI
    notificationDeliveryRestrictionEnabledSetting: NotificationRestrictionSettingValue
    organizationBillingEmail: Optional[String] = None
    packages: PackageConnection
    pendingMembers: UserConnection
    pinnableItems: PinnableItemConnection
    pinnedItems: PinnableItemConnection
    pinnedItemsRemaining: Int
    project: Optional[Project] = None
    projectV2: Optional[ProjectV2] = None
    projects: ProjectConnection
    projectsResourcePath: URI
    projectsUrl: URI
    projectsV2: ProjectV2Connection
    recentProjects: ProjectV2Connection
    repositories: RepositoryConnection
    repository: Optional[Repository] = None
    repositoryDiscussionComments: DiscussionCommentConnection
    repositoryDiscussions: DiscussionConnection
    repositoryMigrations: RepositoryMigrationConnection
    requiresTwoFactorAuthentication: Optional[Boolean] = None
    resourcePath: URI
    ruleset: Optional[RepositoryRuleset] = None
    rulesets: Optional[RepositoryRulesetConnection] = None
    samlIdentityProvider: Optional[OrganizationIdentityProvider] = None
    sponsoring: SponsorConnection
    sponsors: SponsorConnection
    sponsorsActivities: SponsorsActivityConnection
    sponsorsListing: Optional[SponsorsListing] = None
    sponsorshipForViewerAsSponsor: Optional[Sponsorship] = None
    sponsorshipForViewerAsSponsorable: Optional[Sponsorship] = None
    sponsorshipNewsletters: SponsorshipNewsletterConnection
    sponsorshipsAsMaintainer: SponsorshipConnection
    sponsorshipsAsSponsor: SponsorshipConnection
    team: Optional[Team] = None
    teams: TeamConnection
    teamsResourcePath: URI
    teamsUrl: URI
    totalSponsorshipAmountAsSponsorInCents: Optional[Int] = None
    twitterUsername: Optional[String] = None
    updatedAt: DateTime
    url: URI
    viewerCanAdminister: Boolean
    viewerCanChangePinnedItems: Boolean
    viewerCanCreateProjects: Boolean
    viewerCanCreateRepositories: Boolean
    viewerCanCreateTeams: Boolean
    viewerCanSponsor: Boolean
    viewerIsAMember: Boolean
    viewerIsFollowing: Boolean
    viewerIsSponsoring: Boolean
    webCommitSignoffRequired: Boolean
    websiteUrl: Optional[URI] = None
    typename__: Optional[Literal['Organization']] = Field(
        'Organization', alias='__typename'
    )


class OrganizationAuditEntryConnection(BaseModel):
    """
    The connection type for OrganizationAuditEntry.
    """

    edges: Optional[List[Optional[OrganizationAuditEntryEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[OrganizationAuditEntry]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['OrganizationAuditEntryConnection']] = Field(
        'OrganizationAuditEntryConnection', alias='__typename'
    )


class OrganizationAuditEntryEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[OrganizationAuditEntry] = None
    typename__: Optional[Literal['OrganizationAuditEntryEdge']] = Field(
        'OrganizationAuditEntryEdge', alias='__typename'
    )


class OrganizationConnection(BaseModel):
    """
    A list of organizations managed by an enterprise.
    """

    edges: Optional[List[Optional[OrganizationEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Organization]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['OrganizationConnection']] = Field(
        'OrganizationConnection', alias='__typename'
    )


class OrganizationEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Organization] = None
    typename__: Optional[Literal['OrganizationEdge']] = Field(
        'OrganizationEdge', alias='__typename'
    )


class OrganizationEnterpriseOwnerConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[OrganizationEnterpriseOwnerEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['OrganizationEnterpriseOwnerConnection']] = Field(
        'OrganizationEnterpriseOwnerConnection', alias='__typename'
    )


class OrganizationEnterpriseOwnerEdge(BaseModel):
    """
    An enterprise owner in the context of an organization that is part of the enterprise.
    """

    cursor: String
    node: Optional[User] = None
    organizationRole: RoleInOrganization
    typename__: Optional[Literal['OrganizationEnterpriseOwnerEdge']] = Field(
        'OrganizationEnterpriseOwnerEdge', alias='__typename'
    )


class OrganizationIdentityProvider(Node):
    """
    An Identity Provider configured to provision SAML and SCIM identities for
    Organizations. Visible to (1) organization owners, (2) organization owners'
    personal access tokens (classic) with read:org or admin:org scope, (3) GitHub
    App with an installation token with read or write access to members.
    """

    digestMethod: Optional[URI] = None
    externalIdentities: ExternalIdentityConnection
    id: ID
    idpCertificate: Optional[X509Certificate] = None
    issuer: Optional[String] = None
    organization: Optional[Organization] = None
    signatureMethod: Optional[URI] = None
    ssoUrl: Optional[URI] = None
    typename__: Optional[Literal['OrganizationIdentityProvider']] = Field(
        'OrganizationIdentityProvider', alias='__typename'
    )


class OrganizationInvitation(Node):
    """
    An Invitation for a user to an organization.
    """

    createdAt: DateTime
    email: Optional[String] = None
    id: ID
    invitationSource: OrganizationInvitationSource
    invitationType: OrganizationInvitationType
    invitee: Optional[User] = None
    inviter: User
    organization: Organization
    role: OrganizationInvitationRole
    typename__: Optional[Literal['OrganizationInvitation']] = Field(
        'OrganizationInvitation', alias='__typename'
    )


class OrganizationInvitationConnection(BaseModel):
    """
    The connection type for OrganizationInvitation.
    """

    edges: Optional[List[Optional[OrganizationInvitationEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[OrganizationInvitation]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['OrganizationInvitationConnection']] = Field(
        'OrganizationInvitationConnection', alias='__typename'
    )


class OrganizationInvitationEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[OrganizationInvitation] = None
    typename__: Optional[Literal['OrganizationInvitationEdge']] = Field(
        'OrganizationInvitationEdge', alias='__typename'
    )


class OrganizationMemberConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[OrganizationMemberEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['OrganizationMemberConnection']] = Field(
        'OrganizationMemberConnection', alias='__typename'
    )


class OrganizationMemberEdge(BaseModel):
    """
    Represents a user within an organization.
    """

    cursor: String
    hasTwoFactorEnabled: Optional[Boolean] = None
    node: Optional[User] = None
    role: Optional[OrganizationMemberRole] = None
    typename__: Optional[Literal['OrganizationMemberEdge']] = Field(
        'OrganizationMemberEdge', alias='__typename'
    )


class OrganizationMigration(Node):
    """
    A GitHub Enterprise Importer (GEI) organization migration.
    """

    createdAt: DateTime
    databaseId: Optional[String] = None
    failureReason: Optional[String] = None
    id: ID
    remainingRepositoriesCount: Optional[Int] = None
    sourceOrgName: String
    sourceOrgUrl: URI
    state: OrganizationMigrationState
    targetOrgName: String
    totalRepositoriesCount: Optional[Int] = None
    typename__: Optional[Literal['OrganizationMigration']] = Field(
        'OrganizationMigration', alias='__typename'
    )


class OrganizationTeamsHovercardContext(HovercardContext):
    """
    An organization teams hovercard context
    """

    message: String
    octicon: String
    relevantTeams: TeamConnection
    teamsResourcePath: URI
    teamsUrl: URI
    totalTeamCount: Int
    typename__: Optional[Literal['OrganizationTeamsHovercardContext']] = Field(
        'OrganizationTeamsHovercardContext', alias='__typename'
    )


class OrganizationsHovercardContext(HovercardContext):
    """
    An organization list hovercard context
    """

    message: String
    octicon: String
    relevantOrganizations: OrganizationConnection
    totalOrganizationCount: Int
    typename__: Optional[Literal['OrganizationsHovercardContext']] = Field(
        'OrganizationsHovercardContext', alias='__typename'
    )


class Package(Node):
    """
    Information for an uploaded package.
    """

    id: ID
    latestVersion: Optional[PackageVersion] = None
    name: String
    packageType: PackageType
    repository: Optional[Repository] = None
    statistics: Optional[PackageStatistics] = None
    version: Optional[PackageVersion] = None
    versions: PackageVersionConnection
    typename__: Optional[Literal['Package']] = Field('Package', alias='__typename')


class PackageConnection(BaseModel):
    """
    The connection type for Package.
    """

    edges: Optional[List[Optional[PackageEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Package]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PackageConnection']] = Field(
        'PackageConnection', alias='__typename'
    )


class PackageEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Package] = None
    typename__: Optional[Literal['PackageEdge']] = Field(
        'PackageEdge', alias='__typename'
    )


class PackageFile(Node):
    """
    A file in a package version.
    """

    id: ID
    md5: Optional[String] = None
    name: String
    packageVersion: Optional[PackageVersion] = None
    sha1: Optional[String] = None
    sha256: Optional[String] = None
    size: Optional[Int] = None
    updatedAt: DateTime
    url: Optional[URI] = None
    typename__: Optional[Literal['PackageFile']] = Field(
        'PackageFile', alias='__typename'
    )


class PackageFileConnection(BaseModel):
    """
    The connection type for PackageFile.
    """

    edges: Optional[List[Optional[PackageFileEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PackageFile]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PackageFileConnection']] = Field(
        'PackageFileConnection', alias='__typename'
    )


class PackageFileEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PackageFile] = None
    typename__: Optional[Literal['PackageFileEdge']] = Field(
        'PackageFileEdge', alias='__typename'
    )


class PackageStatistics(BaseModel):
    """
    Represents a object that contains package activity statistics such as downloads.
    """

    downloadsTotalCount: Int
    typename__: Optional[Literal['PackageStatistics']] = Field(
        'PackageStatistics', alias='__typename'
    )


class PackageTag(Node):
    """
    A version tag contains the mapping between a tag name and a version.
    """

    id: ID
    name: String
    version: Optional[PackageVersion] = None
    typename__: Optional[Literal['PackageTag']] = Field(
        'PackageTag', alias='__typename'
    )


class PackageVersion(Node):
    """
    Information about a specific package version.
    """

    files: PackageFileConnection
    id: ID
    package: Optional[Package] = None
    platform: Optional[String] = None
    preRelease: Boolean
    readme: Optional[String] = None
    release: Optional[Release] = None
    statistics: Optional[PackageVersionStatistics] = None
    summary: Optional[String] = None
    version: String
    typename__: Optional[Literal['PackageVersion']] = Field(
        'PackageVersion', alias='__typename'
    )


class PackageVersionConnection(BaseModel):
    """
    The connection type for PackageVersion.
    """

    edges: Optional[List[Optional[PackageVersionEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PackageVersion]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PackageVersionConnection']] = Field(
        'PackageVersionConnection', alias='__typename'
    )


class PackageVersionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PackageVersion] = None
    typename__: Optional[Literal['PackageVersionEdge']] = Field(
        'PackageVersionEdge', alias='__typename'
    )


class PackageVersionStatistics(BaseModel):
    """
    Represents a object that contains package version activity statistics such as downloads.
    """

    downloadsTotalCount: Int
    typename__: Optional[Literal['PackageVersionStatistics']] = Field(
        'PackageVersionStatistics', alias='__typename'
    )


class PageInfo(BaseModel):
    """
    Information about pagination in a connection.
    """

    endCursor: Optional[String] = None
    hasNextPage: Boolean
    hasPreviousPage: Boolean
    startCursor: Optional[String] = None
    typename__: Optional[Literal['PageInfo']] = Field('PageInfo', alias='__typename')


class PermissionSource(BaseModel):
    """
    A level of permission and source for a user's access to a repository.
    """

    organization: Organization
    permission: DefaultRepositoryPermissionField
    roleName: Optional[String] = None
    source: PermissionGranter
    typename__: Optional[Literal['PermissionSource']] = Field(
        'PermissionSource', alias='__typename'
    )


class PinIssuePayload(BaseModel):
    """
    Autogenerated return type of PinIssue
    """

    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    typename__: Optional[Literal['PinIssuePayload']] = Field(
        'PinIssuePayload', alias='__typename'
    )


class PinnableItemConnection(BaseModel):
    """
    The connection type for PinnableItem.
    """

    edges: Optional[List[Optional[PinnableItemEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PinnableItem]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PinnableItemConnection']] = Field(
        'PinnableItemConnection', alias='__typename'
    )


class PinnableItemEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PinnableItem] = None
    typename__: Optional[Literal['PinnableItemEdge']] = Field(
        'PinnableItemEdge', alias='__typename'
    )


class PinnedDiscussion(Node, RepositoryNode):
    """
    A Pinned Discussion is a discussion pinned to a repository's index page.
    """

    createdAt: DateTime
    databaseId: Optional[Int] = None
    discussion: Discussion
    gradientStopColors: List[String]
    id: ID
    pattern: PinnedDiscussionPattern
    pinnedBy: Actor
    preconfiguredGradient: Optional[PinnedDiscussionGradient] = None
    repository: Repository
    updatedAt: DateTime
    typename__: Optional[Literal['PinnedDiscussion']] = Field(
        'PinnedDiscussion', alias='__typename'
    )


class PinnedDiscussionConnection(BaseModel):
    """
    The connection type for PinnedDiscussion.
    """

    edges: Optional[List[Optional[PinnedDiscussionEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PinnedDiscussion]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PinnedDiscussionConnection']] = Field(
        'PinnedDiscussionConnection', alias='__typename'
    )


class PinnedDiscussionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PinnedDiscussion] = None
    typename__: Optional[Literal['PinnedDiscussionEdge']] = Field(
        'PinnedDiscussionEdge', alias='__typename'
    )


class PinnedEvent(Node):
    """
    Represents a 'pinned' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    issue: Issue
    typename__: Optional[Literal['PinnedEvent']] = Field(
        'PinnedEvent', alias='__typename'
    )


class PinnedIssue(Node):
    """
    A Pinned Issue is a issue pinned to a repository's index page.
    """

    databaseId: Optional[Int] = None
    fullDatabaseId: Optional[BigInt] = None
    id: ID
    issue: Issue
    pinnedBy: Actor
    repository: Repository
    typename__: Optional[Literal['PinnedIssue']] = Field(
        'PinnedIssue', alias='__typename'
    )


class PinnedIssueConnection(BaseModel):
    """
    The connection type for PinnedIssue.
    """

    edges: Optional[List[Optional[PinnedIssueEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PinnedIssue]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PinnedIssueConnection']] = Field(
        'PinnedIssueConnection', alias='__typename'
    )


class PinnedIssueEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PinnedIssue] = None
    typename__: Optional[Literal['PinnedIssueEdge']] = Field(
        'PinnedIssueEdge', alias='__typename'
    )


class PrivateRepositoryForkingDisableAuditEntry(
    AuditEntry,
    EnterpriseAuditEntryData,
    Node,
    OrganizationAuditEntryData,
    RepositoryAuditEntryData,
):
    """
    Audit log entry for a private_repository_forking.disable event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['PrivateRepositoryForkingDisableAuditEntry']] = Field(
        'PrivateRepositoryForkingDisableAuditEntry', alias='__typename'
    )


class PrivateRepositoryForkingEnableAuditEntry(
    AuditEntry,
    EnterpriseAuditEntryData,
    Node,
    OrganizationAuditEntryData,
    RepositoryAuditEntryData,
):
    """
    Audit log entry for a private_repository_forking.enable event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['PrivateRepositoryForkingEnableAuditEntry']] = Field(
        'PrivateRepositoryForkingEnableAuditEntry', alias='__typename'
    )


class ProfileItemShowcase(BaseModel):
    """
    A curatable list of repositories relating to a repository owner, which defaults
    to showing the most popular repositories they own.
    """

    hasPinnedItems: Boolean
    items: PinnableItemConnection
    typename__: Optional[Literal['ProfileItemShowcase']] = Field(
        'ProfileItemShowcase', alias='__typename'
    )


class Project(Closable, Node, Updatable):
    """
    Projects manage issues, pull requests and notes within a project owner.
    """

    body: Optional[String] = None
    bodyHTML: HTML
    closed: Boolean
    closedAt: Optional[DateTime] = None
    columns: ProjectColumnConnection
    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    id: ID
    name: String
    number: Int
    owner: ProjectOwner
    pendingCards: ProjectCardConnection
    progress: ProjectProgress
    resourcePath: URI
    state: ProjectState
    updatedAt: DateTime
    url: URI
    viewerCanClose: Boolean
    viewerCanReopen: Boolean
    viewerCanUpdate: Boolean
    typename__: Optional[Literal['Project']] = Field('Project', alias='__typename')


class ProjectCard(Node):
    """
    A card in a project.
    """

    column: Optional[ProjectColumn] = None
    content: Optional[ProjectCardItem] = None
    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    id: ID
    isArchived: Boolean
    note: Optional[String] = None
    project: Project
    resourcePath: URI
    state: Optional[ProjectCardState] = None
    updatedAt: DateTime
    url: URI
    typename__: Optional[Literal['ProjectCard']] = Field(
        'ProjectCard', alias='__typename'
    )


class ProjectCardConnection(BaseModel):
    """
    The connection type for ProjectCard.
    """

    edges: Optional[List[Optional[ProjectCardEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectCard]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectCardConnection']] = Field(
        'ProjectCardConnection', alias='__typename'
    )


class ProjectCardEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectCard] = None
    typename__: Optional[Literal['ProjectCardEdge']] = Field(
        'ProjectCardEdge', alias='__typename'
    )


class ProjectColumn(Node):
    """
    A column inside a project.
    """

    cards: ProjectCardConnection
    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    name: String
    project: Project
    purpose: Optional[ProjectColumnPurpose] = None
    resourcePath: URI
    updatedAt: DateTime
    url: URI
    typename__: Optional[Literal['ProjectColumn']] = Field(
        'ProjectColumn', alias='__typename'
    )


class ProjectColumnConnection(BaseModel):
    """
    The connection type for ProjectColumn.
    """

    edges: Optional[List[Optional[ProjectColumnEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectColumn]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectColumnConnection']] = Field(
        'ProjectColumnConnection', alias='__typename'
    )


class ProjectColumnEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectColumn] = None
    typename__: Optional[Literal['ProjectColumnEdge']] = Field(
        'ProjectColumnEdge', alias='__typename'
    )


class ProjectConnection(BaseModel):
    """
    A list of projects associated with the owner.
    """

    edges: Optional[List[Optional[ProjectEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Project]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectConnection']] = Field(
        'ProjectConnection', alias='__typename'
    )


class ProjectEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Project] = None
    typename__: Optional[Literal['ProjectEdge']] = Field(
        'ProjectEdge', alias='__typename'
    )


class ProjectProgress(BaseModel):
    """
    Project progress stats.
    """

    doneCount: Int
    donePercentage: Float
    enabled: Boolean
    inProgressCount: Int
    inProgressPercentage: Float
    todoCount: Int
    todoPercentage: Float
    typename__: Optional[Literal['ProjectProgress']] = Field(
        'ProjectProgress', alias='__typename'
    )


class ProjectV2(Closable, Node, Updatable):
    """
    New projects that manage issues, pull requests and drafts using tables and boards.
    """

    closed: Boolean
    closedAt: Optional[DateTime] = None
    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    field: Optional[ProjectV2FieldConfiguration] = None
    fields_: ProjectV2FieldConfigurationConnection = Field(..., alias='fields')
    id: ID
    items: ProjectV2ItemConnection
    number: Int
    owner: ProjectV2Owner
    public: Boolean
    readme: Optional[String] = None
    repositories: RepositoryConnection
    resourcePath: URI
    shortDescription: Optional[String] = None
    teams: TeamConnection
    template: Boolean
    title: String
    updatedAt: DateTime
    url: URI
    view: Optional[ProjectV2View] = None
    viewerCanClose: Boolean
    viewerCanReopen: Boolean
    viewerCanUpdate: Boolean
    views: ProjectV2ViewConnection
    workflow: Optional[ProjectV2Workflow] = None
    workflows: ProjectV2WorkflowConnection
    typename__: Optional[Literal['ProjectV2']] = Field('ProjectV2', alias='__typename')


class ProjectV2ActorConnection(BaseModel):
    """
    The connection type for ProjectV2Actor.
    """

    edges: Optional[List[Optional[ProjectV2ActorEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectV2Actor]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2ActorConnection']] = Field(
        'ProjectV2ActorConnection', alias='__typename'
    )


class ProjectV2ActorEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2Actor] = None
    typename__: Optional[Literal['ProjectV2ActorEdge']] = Field(
        'ProjectV2ActorEdge', alias='__typename'
    )


class ProjectV2Connection(BaseModel):
    """
    The connection type for ProjectV2.
    """

    edges: Optional[List[Optional[ProjectV2Edge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectV2]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2Connection']] = Field(
        'ProjectV2Connection', alias='__typename'
    )


class ProjectV2Edge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2] = None
    typename__: Optional[Literal['ProjectV2Edge']] = Field(
        'ProjectV2Edge', alias='__typename'
    )


class ProjectV2Field(Node, ProjectV2FieldCommon):
    """
    A field inside a project.
    """

    createdAt: DateTime
    dataType: ProjectV2FieldType
    databaseId: Optional[Int] = None
    id: ID
    name: String
    project: ProjectV2
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2Field']] = Field(
        'ProjectV2Field', alias='__typename'
    )


class ProjectV2FieldConfigurationConnection(BaseModel):
    """
    The connection type for ProjectV2FieldConfiguration.
    """

    edges: Optional[List[Optional[ProjectV2FieldConfigurationEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[ProjectV2FieldConfiguration]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2FieldConfigurationConnection']] = Field(
        'ProjectV2FieldConfigurationConnection', alias='__typename'
    )


class ProjectV2FieldConfigurationEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2FieldConfiguration] = None
    typename__: Optional[Literal['ProjectV2FieldConfigurationEdge']] = Field(
        'ProjectV2FieldConfigurationEdge', alias='__typename'
    )


class ProjectV2FieldConnection(BaseModel):
    """
    The connection type for ProjectV2Field.
    """

    edges: Optional[List[Optional[ProjectV2FieldEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectV2Field]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2FieldConnection']] = Field(
        'ProjectV2FieldConnection', alias='__typename'
    )


class ProjectV2FieldEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2Field] = None
    typename__: Optional[Literal['ProjectV2FieldEdge']] = Field(
        'ProjectV2FieldEdge', alias='__typename'
    )


class ProjectV2Item(Node):
    """
    An item within a Project.
    """

    content: Optional[ProjectV2ItemContent] = None
    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    fieldValueByName: Optional[ProjectV2ItemFieldValue] = None
    fieldValues: ProjectV2ItemFieldValueConnection
    id: ID
    isArchived: Boolean
    project: ProjectV2
    type: ProjectV2ItemType
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2Item']] = Field(
        'ProjectV2Item', alias='__typename'
    )


class ProjectV2ItemConnection(BaseModel):
    """
    The connection type for ProjectV2Item.
    """

    edges: Optional[List[Optional[ProjectV2ItemEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectV2Item]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2ItemConnection']] = Field(
        'ProjectV2ItemConnection', alias='__typename'
    )


class ProjectV2ItemEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2Item] = None
    typename__: Optional[Literal['ProjectV2ItemEdge']] = Field(
        'ProjectV2ItemEdge', alias='__typename'
    )


class ProjectV2ItemFieldDateValue(Node, ProjectV2ItemFieldValueCommon):
    """
    The value of a date field in a Project item.
    """

    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    date: Optional[Date] = None
    field: ProjectV2FieldConfiguration
    id: ID
    item: ProjectV2Item
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2ItemFieldDateValue']] = Field(
        'ProjectV2ItemFieldDateValue', alias='__typename'
    )


class ProjectV2ItemFieldIterationValue(Node, ProjectV2ItemFieldValueCommon):
    """
    The value of an iteration field in a Project item.
    """

    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    duration: Int
    field: ProjectV2FieldConfiguration
    id: ID
    item: ProjectV2Item
    iterationId: String
    startDate: Date
    title: String
    titleHTML: String
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2ItemFieldIterationValue']] = Field(
        'ProjectV2ItemFieldIterationValue', alias='__typename'
    )


class ProjectV2ItemFieldLabelValue(BaseModel):
    """
    The value of the labels field in a Project item.
    """

    field: ProjectV2FieldConfiguration
    labels: Optional[LabelConnection] = None
    typename__: Optional[Literal['ProjectV2ItemFieldLabelValue']] = Field(
        'ProjectV2ItemFieldLabelValue', alias='__typename'
    )


class ProjectV2ItemFieldMilestoneValue(BaseModel):
    """
    The value of a milestone field in a Project item.
    """

    field: ProjectV2FieldConfiguration
    milestone: Optional[Milestone] = None
    typename__: Optional[Literal['ProjectV2ItemFieldMilestoneValue']] = Field(
        'ProjectV2ItemFieldMilestoneValue', alias='__typename'
    )


class ProjectV2ItemFieldNumberValue(Node, ProjectV2ItemFieldValueCommon):
    """
    The value of a number field in a Project item.
    """

    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    field: ProjectV2FieldConfiguration
    id: ID
    item: ProjectV2Item
    number: Optional[Float] = None
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2ItemFieldNumberValue']] = Field(
        'ProjectV2ItemFieldNumberValue', alias='__typename'
    )


class ProjectV2ItemFieldPullRequestValue(BaseModel):
    """
    The value of a pull request field in a Project item.
    """

    field: ProjectV2FieldConfiguration
    pullRequests: Optional[PullRequestConnection] = None
    typename__: Optional[Literal['ProjectV2ItemFieldPullRequestValue']] = Field(
        'ProjectV2ItemFieldPullRequestValue', alias='__typename'
    )


class ProjectV2ItemFieldRepositoryValue(BaseModel):
    """
    The value of a repository field in a Project item.
    """

    field: ProjectV2FieldConfiguration
    repository: Optional[Repository] = None
    typename__: Optional[Literal['ProjectV2ItemFieldRepositoryValue']] = Field(
        'ProjectV2ItemFieldRepositoryValue', alias='__typename'
    )


class ProjectV2ItemFieldReviewerValue(BaseModel):
    """
    The value of a reviewers field in a Project item.
    """

    field: ProjectV2FieldConfiguration
    reviewers: Optional[RequestedReviewerConnection] = None
    typename__: Optional[Literal['ProjectV2ItemFieldReviewerValue']] = Field(
        'ProjectV2ItemFieldReviewerValue', alias='__typename'
    )


class ProjectV2ItemFieldSingleSelectValue(Node, ProjectV2ItemFieldValueCommon):
    """
    The value of a single select field in a Project item.
    """

    color: ProjectV2SingleSelectFieldOptionColor
    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    description: Optional[String] = None
    descriptionHTML: Optional[String] = None
    field: ProjectV2FieldConfiguration
    id: ID
    item: ProjectV2Item
    name: Optional[String] = None
    nameHTML: Optional[String] = None
    optionId: Optional[String] = None
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2ItemFieldSingleSelectValue']] = Field(
        'ProjectV2ItemFieldSingleSelectValue', alias='__typename'
    )


class ProjectV2ItemFieldTextValue(Node, ProjectV2ItemFieldValueCommon):
    """
    The value of a text field in a Project item.
    """

    createdAt: DateTime
    creator: Optional[Actor] = None
    databaseId: Optional[Int] = None
    field: ProjectV2FieldConfiguration
    id: ID
    item: ProjectV2Item
    text: Optional[String] = None
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2ItemFieldTextValue']] = Field(
        'ProjectV2ItemFieldTextValue', alias='__typename'
    )


class ProjectV2ItemFieldUserValue(BaseModel):
    """
    The value of a user field in a Project item.
    """

    field: ProjectV2FieldConfiguration
    users: Optional[UserConnection] = None
    typename__: Optional[Literal['ProjectV2ItemFieldUserValue']] = Field(
        'ProjectV2ItemFieldUserValue', alias='__typename'
    )


class ProjectV2ItemFieldValueConnection(BaseModel):
    """
    The connection type for ProjectV2ItemFieldValue.
    """

    edges: Optional[List[Optional[ProjectV2ItemFieldValueEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[ProjectV2ItemFieldValue]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2ItemFieldValueConnection']] = Field(
        'ProjectV2ItemFieldValueConnection', alias='__typename'
    )


class ProjectV2ItemFieldValueEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2ItemFieldValue] = None
    typename__: Optional[Literal['ProjectV2ItemFieldValueEdge']] = Field(
        'ProjectV2ItemFieldValueEdge', alias='__typename'
    )


class ProjectV2IterationField(Node, ProjectV2FieldCommon):
    """
    An iteration field inside a project.
    """

    configuration: ProjectV2IterationFieldConfiguration
    createdAt: DateTime
    dataType: ProjectV2FieldType
    databaseId: Optional[Int] = None
    id: ID
    name: String
    project: ProjectV2
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2IterationField']] = Field(
        'ProjectV2IterationField', alias='__typename'
    )


class ProjectV2IterationFieldConfiguration(BaseModel):
    """
    Iteration field configuration for a project.
    """

    completedIterations: List[ProjectV2IterationFieldIteration]
    duration: Int
    iterations: List[ProjectV2IterationFieldIteration]
    startDay: Int
    typename__: Optional[Literal['ProjectV2IterationFieldConfiguration']] = Field(
        'ProjectV2IterationFieldConfiguration', alias='__typename'
    )


class ProjectV2IterationFieldIteration(BaseModel):
    """
    Iteration field iteration settings for a project.
    """

    duration: Int
    id: String
    startDate: Date
    title: String
    titleHTML: String
    typename__: Optional[Literal['ProjectV2IterationFieldIteration']] = Field(
        'ProjectV2IterationFieldIteration', alias='__typename'
    )


class ProjectV2SingleSelectField(Node, ProjectV2FieldCommon):
    """
    A single select field inside a project.
    """

    createdAt: DateTime
    dataType: ProjectV2FieldType
    databaseId: Optional[Int] = None
    id: ID
    name: String
    options: List[ProjectV2SingleSelectFieldOption]
    project: ProjectV2
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2SingleSelectField']] = Field(
        'ProjectV2SingleSelectField', alias='__typename'
    )


class ProjectV2SingleSelectFieldOption(BaseModel):
    """
    Single select field option for a configuration for a project.
    """

    color: ProjectV2SingleSelectFieldOptionColor
    description: String
    descriptionHTML: String
    id: String
    name: String
    nameHTML: String
    typename__: Optional[Literal['ProjectV2SingleSelectFieldOption']] = Field(
        'ProjectV2SingleSelectFieldOption', alias='__typename'
    )


class ProjectV2SortBy(BaseModel):
    """
    Represents a sort by field and direction.
    """

    direction: OrderDirection
    field: ProjectV2Field
    typename__: Optional[Literal['ProjectV2SortBy']] = Field(
        'ProjectV2SortBy', alias='__typename'
    )


class ProjectV2SortByConnection(BaseModel):
    """
    The connection type for ProjectV2SortBy.
    """

    edges: Optional[List[Optional[ProjectV2SortByEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectV2SortBy]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2SortByConnection']] = Field(
        'ProjectV2SortByConnection', alias='__typename'
    )


class ProjectV2SortByEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2SortBy] = None
    typename__: Optional[Literal['ProjectV2SortByEdge']] = Field(
        'ProjectV2SortByEdge', alias='__typename'
    )


class ProjectV2SortByField(BaseModel):
    """
    Represents a sort by field and direction.
    """

    direction: OrderDirection
    field: ProjectV2FieldConfiguration
    typename__: Optional[Literal['ProjectV2SortByField']] = Field(
        'ProjectV2SortByField', alias='__typename'
    )


class ProjectV2SortByFieldConnection(BaseModel):
    """
    The connection type for ProjectV2SortByField.
    """

    edges: Optional[List[Optional[ProjectV2SortByFieldEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[ProjectV2SortByField]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2SortByFieldConnection']] = Field(
        'ProjectV2SortByFieldConnection', alias='__typename'
    )


class ProjectV2SortByFieldEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2SortByField] = None
    typename__: Optional[Literal['ProjectV2SortByFieldEdge']] = Field(
        'ProjectV2SortByFieldEdge', alias='__typename'
    )


class ProjectV2View(Node):
    """
    A view within a ProjectV2.
    """

    createdAt: DateTime
    databaseId: Optional[Int] = None
    fields_: Optional[ProjectV2FieldConfigurationConnection] = Field(
        None, alias='fields'
    )
    filter: Optional[String] = None
    groupBy: Optional[ProjectV2FieldConnection] = None
    groupByFields: Optional[ProjectV2FieldConfigurationConnection] = None
    id: ID
    layout: ProjectV2ViewLayout
    name: String
    number: Int
    project: ProjectV2
    sortBy: Optional[ProjectV2SortByConnection] = None
    sortByFields: Optional[ProjectV2SortByFieldConnection] = None
    updatedAt: DateTime
    verticalGroupBy: Optional[ProjectV2FieldConnection] = None
    verticalGroupByFields: Optional[ProjectV2FieldConfigurationConnection] = None
    visibleFields: Optional[ProjectV2FieldConnection] = None
    typename__: Optional[Literal['ProjectV2View']] = Field(
        'ProjectV2View', alias='__typename'
    )


class ProjectV2ViewConnection(BaseModel):
    """
    The connection type for ProjectV2View.
    """

    edges: Optional[List[Optional[ProjectV2ViewEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectV2View]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2ViewConnection']] = Field(
        'ProjectV2ViewConnection', alias='__typename'
    )


class ProjectV2ViewEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2View] = None
    typename__: Optional[Literal['ProjectV2ViewEdge']] = Field(
        'ProjectV2ViewEdge', alias='__typename'
    )


class ProjectV2Workflow(Node):
    """
    A workflow inside a project.
    """

    createdAt: DateTime
    databaseId: Optional[Int] = None
    enabled: Boolean
    id: ID
    name: String
    number: Int
    project: ProjectV2
    updatedAt: DateTime
    typename__: Optional[Literal['ProjectV2Workflow']] = Field(
        'ProjectV2Workflow', alias='__typename'
    )


class ProjectV2WorkflowConnection(BaseModel):
    """
    The connection type for ProjectV2Workflow.
    """

    edges: Optional[List[Optional[ProjectV2WorkflowEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ProjectV2Workflow]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ProjectV2WorkflowConnection']] = Field(
        'ProjectV2WorkflowConnection', alias='__typename'
    )


class ProjectV2WorkflowEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ProjectV2Workflow] = None
    typename__: Optional[Literal['ProjectV2WorkflowEdge']] = Field(
        'ProjectV2WorkflowEdge', alias='__typename'
    )


class PublicKey(Node):
    """
    A user's public key.
    """

    accessedAt: Optional[DateTime] = None
    createdAt: Optional[DateTime] = None
    fingerprint: String
    id: ID
    isReadOnly: Optional[Boolean] = None
    key: String
    updatedAt: Optional[DateTime] = None
    typename__: Optional[Literal['PublicKey']] = Field('PublicKey', alias='__typename')


class PublicKeyConnection(BaseModel):
    """
    The connection type for PublicKey.
    """

    edges: Optional[List[Optional[PublicKeyEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PublicKey]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PublicKeyConnection']] = Field(
        'PublicKeyConnection', alias='__typename'
    )


class PublicKeyEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PublicKey] = None
    typename__: Optional[Literal['PublicKeyEdge']] = Field(
        'PublicKeyEdge', alias='__typename'
    )


class PublishSponsorsTierPayload(BaseModel):
    """
    Autogenerated return type of PublishSponsorsTier
    """

    clientMutationId: Optional[String] = None
    sponsorsTier: Optional[SponsorsTier] = None
    typename__: Optional[Literal['PublishSponsorsTierPayload']] = Field(
        'PublishSponsorsTierPayload', alias='__typename'
    )


class PullRequest(
    Assignable,
    Closable,
    Comment,
    Labelable,
    Lockable,
    Node,
    ProjectV2Owner,
    Reactable,
    RepositoryNode,
    Subscribable,
    UniformResourceLocatable,
    Updatable,
    UpdatableComment,
):
    """
    A repository pull request.
    """

    activeLockReason: Optional[LockReason] = None
    additions: Int
    assignees: UserConnection
    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    autoMergeRequest: Optional[AutoMergeRequest] = None
    baseRef: Optional[Ref] = None
    baseRefName: String
    baseRefOid: GitObjectID
    baseRepository: Optional[Repository] = None
    body: String
    bodyHTML: HTML
    bodyText: String
    canBeRebased: Boolean
    changedFiles: Int
    checksResourcePath: URI
    checksUrl: URI
    closed: Boolean
    closedAt: Optional[DateTime] = None
    closingIssuesReferences: Optional[IssueConnection] = None
    comments: IssueCommentConnection
    commits: PullRequestCommitConnection
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    deletions: Int
    editor: Optional[Actor] = None
    files: Optional[PullRequestChangedFileConnection] = None
    headRef: Optional[Ref] = None
    headRefName: String
    headRefOid: GitObjectID
    headRepository: Optional[Repository] = None
    headRepositoryOwner: Optional[RepositoryOwner] = None
    hovercard: Hovercard
    id: ID
    includesCreatedEdit: Boolean
    isCrossRepository: Boolean
    isDraft: Boolean
    isReadByViewer: Optional[Boolean] = None
    labels: Optional[LabelConnection] = None
    lastEditedAt: Optional[DateTime] = None
    latestOpinionatedReviews: Optional[PullRequestReviewConnection] = None
    latestReviews: Optional[PullRequestReviewConnection] = None
    locked: Boolean
    maintainerCanModify: Boolean
    mergeCommit: Optional[Commit] = None
    mergeQueueEntry: Optional[MergeQueueEntry] = None
    mergeStateStatus: MergeStateStatus
    mergeable: MergeableState
    merged: Boolean
    mergedAt: Optional[DateTime] = None
    mergedBy: Optional[Actor] = None
    milestone: Optional[Milestone] = None
    number: Int
    participants: UserConnection
    permalink: URI
    potentialMergeCommit: Optional[Commit] = None
    projectCards: ProjectCardConnection
    projectItems: ProjectV2ItemConnection
    projectV2: Optional[ProjectV2] = None
    projectsV2: ProjectV2Connection
    publishedAt: Optional[DateTime] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    repository: Repository
    resourcePath: URI
    revertResourcePath: URI
    revertUrl: URI
    reviewDecision: Optional[PullRequestReviewDecision] = None
    reviewRequests: Optional[ReviewRequestConnection] = None
    reviewThreads: PullRequestReviewThreadConnection
    reviews: Optional[PullRequestReviewConnection] = None
    state: PullRequestState
    suggestedReviewers: List[Optional[SuggestedReviewer]]
    timeline: PullRequestTimelineConnection
    timelineItems: PullRequestTimelineItemsConnection
    title: String
    titleHTML: HTML
    totalCommentsCount: Optional[Int] = None
    updatedAt: DateTime
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanApplySuggestion: Boolean
    viewerCanClose: Boolean
    viewerCanDeleteHeadRef: Boolean
    viewerCanDisableAutoMerge: Boolean
    viewerCanEditFiles: Boolean
    viewerCanEnableAutoMerge: Boolean
    viewerCanMergeAsAdmin: Boolean
    viewerCanReact: Boolean
    viewerCanReopen: Boolean
    viewerCanSubscribe: Boolean
    viewerCanUpdate: Boolean
    viewerCanUpdateBranch: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    viewerLatestReview: Optional[PullRequestReview] = None
    viewerLatestReviewRequest: Optional[ReviewRequest] = None
    viewerMergeBodyText: String
    viewerMergeHeadlineText: String
    viewerSubscription: Optional[SubscriptionState] = None
    typename__: Optional[Literal['PullRequest']] = Field(
        'PullRequest', alias='__typename'
    )


class PullRequestChangedFile(BaseModel):
    """
    A file changed in a pull request.
    """

    additions: Int
    changeType: PatchStatus
    deletions: Int
    path: String
    viewerViewedState: FileViewedState
    typename__: Optional[Literal['PullRequestChangedFile']] = Field(
        'PullRequestChangedFile', alias='__typename'
    )


class PullRequestChangedFileConnection(BaseModel):
    """
    The connection type for PullRequestChangedFile.
    """

    edges: Optional[List[Optional[PullRequestChangedFileEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[PullRequestChangedFile]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PullRequestChangedFileConnection']] = Field(
        'PullRequestChangedFileConnection', alias='__typename'
    )


class PullRequestChangedFileEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PullRequestChangedFile] = None
    typename__: Optional[Literal['PullRequestChangedFileEdge']] = Field(
        'PullRequestChangedFileEdge', alias='__typename'
    )


class PullRequestCommit(Node, UniformResourceLocatable):
    """
    Represents a Git commit part of a pull request.
    """

    commit: Commit
    id: ID
    pullRequest: PullRequest
    resourcePath: URI
    url: URI
    typename__: Optional[Literal['PullRequestCommit']] = Field(
        'PullRequestCommit', alias='__typename'
    )


class PullRequestCommitCommentThread(Node, RepositoryNode):
    """
    Represents a commit comment thread part of a pull request.
    """

    comments: CommitCommentConnection
    commit: Commit
    id: ID
    path: Optional[String] = None
    position: Optional[Int] = None
    pullRequest: PullRequest
    repository: Repository
    typename__: Optional[Literal['PullRequestCommitCommentThread']] = Field(
        'PullRequestCommitCommentThread', alias='__typename'
    )


class PullRequestCommitConnection(BaseModel):
    """
    The connection type for PullRequestCommit.
    """

    edges: Optional[List[Optional[PullRequestCommitEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PullRequestCommit]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PullRequestCommitConnection']] = Field(
        'PullRequestCommitConnection', alias='__typename'
    )


class PullRequestCommitEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PullRequestCommit] = None
    typename__: Optional[Literal['PullRequestCommitEdge']] = Field(
        'PullRequestCommitEdge', alias='__typename'
    )


class PullRequestConnection(BaseModel):
    """
    The connection type for PullRequest.
    """

    edges: Optional[List[Optional[PullRequestEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PullRequest]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PullRequestConnection']] = Field(
        'PullRequestConnection', alias='__typename'
    )


class PullRequestContributionsByRepository(BaseModel):
    """
    This aggregates pull requests opened by a user within one repository.
    """

    contributions: CreatedPullRequestContributionConnection
    repository: Repository
    typename__: Optional[Literal['PullRequestContributionsByRepository']] = Field(
        'PullRequestContributionsByRepository', alias='__typename'
    )


class PullRequestEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PullRequest] = None
    typename__: Optional[Literal['PullRequestEdge']] = Field(
        'PullRequestEdge', alias='__typename'
    )


class PullRequestParameters(BaseModel):
    """
    Require all commits be made to a non-target branch and submitted via a pull request before they can be merged.
    """

    dismissStaleReviewsOnPush: Boolean
    requireCodeOwnerReview: Boolean
    requireLastPushApproval: Boolean
    requiredApprovingReviewCount: Int
    requiredReviewThreadResolution: Boolean
    typename__: Optional[Literal['PullRequestParameters']] = Field(
        'PullRequestParameters', alias='__typename'
    )


class PullRequestReview(
    Comment,
    Deletable,
    Minimizable,
    Node,
    Reactable,
    RepositoryNode,
    Updatable,
    UpdatableComment,
):
    """
    A review object for a given pull request.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    authorCanPushToRepository: Boolean
    body: String
    bodyHTML: HTML
    bodyText: String
    comments: PullRequestReviewCommentConnection
    commit: Optional[Commit] = None
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    editor: Optional[Actor] = None
    id: ID
    includesCreatedEdit: Boolean
    isMinimized: Boolean
    lastEditedAt: Optional[DateTime] = None
    minimizedReason: Optional[String] = None
    onBehalfOf: TeamConnection
    publishedAt: Optional[DateTime] = None
    pullRequest: PullRequest
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    repository: Repository
    resourcePath: URI
    state: PullRequestReviewState
    submittedAt: Optional[DateTime] = None
    updatedAt: DateTime
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanDelete: Boolean
    viewerCanMinimize: Boolean
    viewerCanReact: Boolean
    viewerCanUpdate: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    typename__: Optional[Literal['PullRequestReview']] = Field(
        'PullRequestReview', alias='__typename'
    )


class PullRequestReviewComment(
    Comment,
    Deletable,
    Minimizable,
    Node,
    Reactable,
    RepositoryNode,
    Updatable,
    UpdatableComment,
):
    """
    A review comment associated with a given repository pull request.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    commit: Optional[Commit] = None
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    diffHunk: String
    draftedAt: DateTime
    editor: Optional[Actor] = None
    id: ID
    includesCreatedEdit: Boolean
    isMinimized: Boolean
    lastEditedAt: Optional[DateTime] = None
    line: Optional[Int] = None
    minimizedReason: Optional[String] = None
    originalCommit: Optional[Commit] = None
    originalLine: Optional[Int] = None
    originalPosition: Int
    originalStartLine: Optional[Int] = None
    outdated: Boolean
    path: String
    position: Optional[Int] = None
    publishedAt: Optional[DateTime] = None
    pullRequest: PullRequest
    pullRequestReview: Optional[PullRequestReview] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    replyTo: Optional[PullRequestReviewComment] = None
    repository: Repository
    resourcePath: URI
    startLine: Optional[Int] = None
    state: PullRequestReviewCommentState
    subjectType: PullRequestReviewThreadSubjectType
    updatedAt: DateTime
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanDelete: Boolean
    viewerCanMinimize: Boolean
    viewerCanReact: Boolean
    viewerCanUpdate: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    typename__: Optional[Literal['PullRequestReviewComment']] = Field(
        'PullRequestReviewComment', alias='__typename'
    )


class PullRequestReviewCommentConnection(BaseModel):
    """
    The connection type for PullRequestReviewComment.
    """

    edges: Optional[List[Optional[PullRequestReviewCommentEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[PullRequestReviewComment]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PullRequestReviewCommentConnection']] = Field(
        'PullRequestReviewCommentConnection', alias='__typename'
    )


class PullRequestReviewCommentEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PullRequestReviewComment] = None
    typename__: Optional[Literal['PullRequestReviewCommentEdge']] = Field(
        'PullRequestReviewCommentEdge', alias='__typename'
    )


class PullRequestReviewConnection(BaseModel):
    """
    The connection type for PullRequestReview.
    """

    edges: Optional[List[Optional[PullRequestReviewEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PullRequestReview]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PullRequestReviewConnection']] = Field(
        'PullRequestReviewConnection', alias='__typename'
    )


class PullRequestReviewContributionsByRepository(BaseModel):
    """
    This aggregates pull request reviews made by a user within one repository.
    """

    contributions: CreatedPullRequestReviewContributionConnection
    repository: Repository
    typename__: Optional[Literal['PullRequestReviewContributionsByRepository']] = Field(
        'PullRequestReviewContributionsByRepository', alias='__typename'
    )


class PullRequestReviewEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PullRequestReview] = None
    typename__: Optional[Literal['PullRequestReviewEdge']] = Field(
        'PullRequestReviewEdge', alias='__typename'
    )


class PullRequestReviewThread(Node):
    """
    A threaded list of comments for a given pull request.
    """

    comments: PullRequestReviewCommentConnection
    diffSide: DiffSide
    id: ID
    isCollapsed: Boolean
    isOutdated: Boolean
    isResolved: Boolean
    line: Optional[Int] = None
    originalLine: Optional[Int] = None
    originalStartLine: Optional[Int] = None
    path: String
    pullRequest: PullRequest
    repository: Repository
    resolvedBy: Optional[User] = None
    startDiffSide: Optional[DiffSide] = None
    startLine: Optional[Int] = None
    subjectType: PullRequestReviewThreadSubjectType
    viewerCanReply: Boolean
    viewerCanResolve: Boolean
    viewerCanUnresolve: Boolean
    typename__: Optional[Literal['PullRequestReviewThread']] = Field(
        'PullRequestReviewThread', alias='__typename'
    )


class PullRequestReviewThreadConnection(BaseModel):
    """
    Review comment threads for a pull request review.
    """

    edges: Optional[List[Optional[PullRequestReviewThreadEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[PullRequestReviewThread]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PullRequestReviewThreadConnection']] = Field(
        'PullRequestReviewThreadConnection', alias='__typename'
    )


class PullRequestReviewThreadEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PullRequestReviewThread] = None
    typename__: Optional[Literal['PullRequestReviewThreadEdge']] = Field(
        'PullRequestReviewThreadEdge', alias='__typename'
    )


class PullRequestRevisionMarker(BaseModel):
    """
    Represents the latest point in the pull request timeline for which the viewer has seen the pull request's commits.
    """

    createdAt: DateTime
    lastSeenCommit: Commit
    pullRequest: PullRequest
    typename__: Optional[Literal['PullRequestRevisionMarker']] = Field(
        'PullRequestRevisionMarker', alias='__typename'
    )


class PullRequestTemplate(BaseModel):
    """
    A repository pull request template.
    """

    body: Optional[String] = None
    filename: Optional[String] = None
    repository: Repository
    typename__: Optional[Literal['PullRequestTemplate']] = Field(
        'PullRequestTemplate', alias='__typename'
    )


class PullRequestThread(Node):
    """
    A threaded list of comments for a given pull request.
    """

    comments: PullRequestReviewCommentConnection
    diffSide: DiffSide
    id: ID
    isCollapsed: Boolean
    isOutdated: Boolean
    isResolved: Boolean
    line: Optional[Int] = None
    path: String
    pullRequest: PullRequest
    repository: Repository
    resolvedBy: Optional[User] = None
    startDiffSide: Optional[DiffSide] = None
    startLine: Optional[Int] = None
    subjectType: PullRequestReviewThreadSubjectType
    viewerCanReply: Boolean
    viewerCanResolve: Boolean
    viewerCanUnresolve: Boolean
    typename__: Optional[Literal['PullRequestThread']] = Field(
        'PullRequestThread', alias='__typename'
    )


class PullRequestTimelineConnection(BaseModel):
    """
    The connection type for PullRequestTimelineItem.
    """

    edges: Optional[List[Optional[PullRequestTimelineItemEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[PullRequestTimelineItem]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PullRequestTimelineConnection']] = Field(
        'PullRequestTimelineConnection', alias='__typename'
    )


class PullRequestTimelineItemEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PullRequestTimelineItem] = None
    typename__: Optional[Literal['PullRequestTimelineItemEdge']] = Field(
        'PullRequestTimelineItemEdge', alias='__typename'
    )


class PullRequestTimelineItemsConnection(BaseModel):
    """
    The connection type for PullRequestTimelineItems.
    """

    edges: Optional[List[Optional[PullRequestTimelineItemsEdge]]] = Field(
        default_factory=list
    )
    filteredCount: Int
    nodes: Optional[List[Optional[PullRequestTimelineItems]]] = Field(
        default_factory=list
    )
    pageCount: Int
    pageInfo: PageInfo
    totalCount: Int
    updatedAt: DateTime
    typename__: Optional[Literal['PullRequestTimelineItemsConnection']] = Field(
        'PullRequestTimelineItemsConnection', alias='__typename'
    )


class PullRequestTimelineItemsEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PullRequestTimelineItems] = None
    typename__: Optional[Literal['PullRequestTimelineItemsEdge']] = Field(
        'PullRequestTimelineItemsEdge', alias='__typename'
    )


class Push(Node):
    """
    A Git push.
    """

    id: ID
    nextSha: Optional[GitObjectID] = None
    permalink: URI
    previousSha: Optional[GitObjectID] = None
    pusher: Actor
    repository: Repository
    typename__: Optional[Literal['Push']] = Field('Push', alias='__typename')


class PushAllowance(Node):
    """
    A team, user, or app who has the ability to push to a protected branch.
    """

    actor: Optional[PushAllowanceActor] = None
    branchProtectionRule: Optional[BranchProtectionRule] = None
    id: ID
    typename__: Optional[Literal['PushAllowance']] = Field(
        'PushAllowance', alias='__typename'
    )


class PushAllowanceConnection(BaseModel):
    """
    The connection type for PushAllowance.
    """

    edges: Optional[List[Optional[PushAllowanceEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[PushAllowance]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['PushAllowanceConnection']] = Field(
        'PushAllowanceConnection', alias='__typename'
    )


class PushAllowanceEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[PushAllowance] = None
    typename__: Optional[Literal['PushAllowanceEdge']] = Field(
        'PushAllowanceEdge', alias='__typename'
    )


class RateLimit(BaseModel):
    """
    Represents the client's rate limit.
    """

    cost: Int
    limit: Int
    nodeCount: Int
    remaining: Int
    resetAt: DateTime
    used: Int
    typename__: Optional[Literal['RateLimit']] = Field('RateLimit', alias='__typename')


class ReactingUserConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[ReactingUserEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ReactingUserConnection']] = Field(
        'ReactingUserConnection', alias='__typename'
    )


class ReactingUserEdge(BaseModel):
    """
    Represents a user that's made a reaction.
    """

    cursor: String
    node: User
    reactedAt: DateTime
    typename__: Optional[Literal['ReactingUserEdge']] = Field(
        'ReactingUserEdge', alias='__typename'
    )


class Reaction(Node):
    """
    An emoji reaction to a particular piece of content.
    """

    content: ReactionContent
    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    reactable: Reactable
    user: Optional[User] = None
    typename__: Optional[Literal['Reaction']] = Field('Reaction', alias='__typename')


class ReactionConnection(BaseModel):
    """
    A list of reactions that have been left on the subject.
    """

    edges: Optional[List[Optional[ReactionEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Reaction]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    viewerHasReacted: Boolean
    typename__: Optional[Literal['ReactionConnection']] = Field(
        'ReactionConnection', alias='__typename'
    )


class ReactionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Reaction] = None
    typename__: Optional[Literal['ReactionEdge']] = Field(
        'ReactionEdge', alias='__typename'
    )


class ReactionGroup(BaseModel):
    """
    A group of emoji reactions to a particular piece of content.
    """

    content: ReactionContent
    createdAt: Optional[DateTime] = None
    reactors: ReactorConnection
    subject: Reactable
    users: ReactingUserConnection
    viewerHasReacted: Boolean
    typename__: Optional[Literal['ReactionGroup']] = Field(
        'ReactionGroup', alias='__typename'
    )


class ReactorConnection(BaseModel):
    """
    The connection type for Reactor.
    """

    edges: Optional[List[Optional[ReactorEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Reactor]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ReactorConnection']] = Field(
        'ReactorConnection', alias='__typename'
    )


class ReactorEdge(BaseModel):
    """
    Represents an author of a reaction.
    """

    cursor: String
    node: Reactor
    reactedAt: DateTime
    typename__: Optional[Literal['ReactorEdge']] = Field(
        'ReactorEdge', alias='__typename'
    )


class ReadyForReviewEvent(Node, UniformResourceLocatable):
    """
    Represents a 'ready_for_review' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    pullRequest: PullRequest
    resourcePath: URI
    url: URI
    typename__: Optional[Literal['ReadyForReviewEvent']] = Field(
        'ReadyForReviewEvent', alias='__typename'
    )


class Ref(Node):
    """
    Represents a Git reference.
    """

    associatedPullRequests: PullRequestConnection
    branchProtectionRule: Optional[BranchProtectionRule] = None
    compare: Optional[Comparison] = None
    id: ID
    name: String
    prefix: String
    refUpdateRule: Optional[RefUpdateRule] = None
    repository: Repository
    target: Optional[GitObject] = None
    typename__: Optional[Literal['Ref']] = Field('Ref', alias='__typename')


class RefConnection(BaseModel):
    """
    The connection type for Ref.
    """

    edges: Optional[List[Optional[RefEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Ref]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RefConnection']] = Field(
        'RefConnection', alias='__typename'
    )


class RefEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Ref] = None
    typename__: Optional[Literal['RefEdge']] = Field('RefEdge', alias='__typename')


class RefNameConditionTarget(BaseModel):
    """
    Parameters to be used for the ref_name condition
    """

    exclude: List[String]
    include: List[String]
    typename__: Optional[Literal['RefNameConditionTarget']] = Field(
        'RefNameConditionTarget', alias='__typename'
    )


class RefUpdateRule(BaseModel):
    """
    A ref update rules for a viewer.
    """

    allowsDeletions: Boolean
    allowsForcePushes: Boolean
    blocksCreations: Boolean
    pattern: String
    requiredApprovingReviewCount: Optional[Int] = None
    requiredStatusCheckContexts: Optional[List[Optional[String]]] = Field(
        default_factory=list
    )
    requiresCodeOwnerReviews: Boolean
    requiresConversationResolution: Boolean
    requiresLinearHistory: Boolean
    requiresSignatures: Boolean
    viewerAllowedToDismissReviews: Boolean
    viewerCanPush: Boolean
    typename__: Optional[Literal['RefUpdateRule']] = Field(
        'RefUpdateRule', alias='__typename'
    )


class ReferencedEvent(Node):
    """
    Represents a 'referenced' event on a given `ReferencedSubject`.
    """

    actor: Optional[Actor] = None
    commit: Optional[Commit] = None
    commitRepository: Repository
    createdAt: DateTime
    id: ID
    isCrossRepository: Boolean
    isDirectReference: Boolean
    subject: ReferencedSubject
    typename__: Optional[Literal['ReferencedEvent']] = Field(
        'ReferencedEvent', alias='__typename'
    )


class RegenerateEnterpriseIdentityProviderRecoveryCodesPayload(BaseModel):
    """
    Autogenerated return type of RegenerateEnterpriseIdentityProviderRecoveryCodes
    """

    clientMutationId: Optional[String] = None
    identityProvider: Optional[EnterpriseIdentityProvider] = None
    typename__: Optional[
        Literal['RegenerateEnterpriseIdentityProviderRecoveryCodesPayload']
    ] = Field(
        'RegenerateEnterpriseIdentityProviderRecoveryCodesPayload', alias='__typename'
    )


class RegenerateVerifiableDomainTokenPayload(BaseModel):
    """
    Autogenerated return type of RegenerateVerifiableDomainToken
    """

    clientMutationId: Optional[String] = None
    verificationToken: Optional[String] = None
    typename__: Optional[Literal['RegenerateVerifiableDomainTokenPayload']] = Field(
        'RegenerateVerifiableDomainTokenPayload', alias='__typename'
    )


class RejectDeploymentsPayload(BaseModel):
    """
    Autogenerated return type of RejectDeployments
    """

    clientMutationId: Optional[String] = None
    deployments: Optional[List[Deployment]] = Field(default_factory=list)
    typename__: Optional[Literal['RejectDeploymentsPayload']] = Field(
        'RejectDeploymentsPayload', alias='__typename'
    )


class Release(Node, Reactable, UniformResourceLocatable):
    """
    A release contains the content for a release.
    """

    author: Optional[User] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    description: Optional[String] = None
    descriptionHTML: Optional[HTML] = None
    id: ID
    isDraft: Boolean
    isLatest: Boolean
    isPrerelease: Boolean
    mentions: Optional[UserConnection] = None
    name: Optional[String] = None
    publishedAt: Optional[DateTime] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    releaseAssets: ReleaseAssetConnection
    repository: Repository
    resourcePath: URI
    shortDescriptionHTML: Optional[HTML] = None
    tag: Optional[Ref] = None
    tagCommit: Optional[Commit] = None
    tagName: String
    updatedAt: DateTime
    url: URI
    viewerCanReact: Boolean
    typename__: Optional[Literal['Release']] = Field('Release', alias='__typename')


class ReleaseAsset(Node):
    """
    A release asset contains the content for a release asset.
    """

    contentType: String
    createdAt: DateTime
    downloadCount: Int
    downloadUrl: URI
    id: ID
    name: String
    release: Optional[Release] = None
    size: Int
    updatedAt: DateTime
    uploadedBy: User
    url: URI
    typename__: Optional[Literal['ReleaseAsset']] = Field(
        'ReleaseAsset', alias='__typename'
    )


class ReleaseAssetConnection(BaseModel):
    """
    The connection type for ReleaseAsset.
    """

    edges: Optional[List[Optional[ReleaseAssetEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ReleaseAsset]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ReleaseAssetConnection']] = Field(
        'ReleaseAssetConnection', alias='__typename'
    )


class ReleaseAssetEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ReleaseAsset] = None
    typename__: Optional[Literal['ReleaseAssetEdge']] = Field(
        'ReleaseAssetEdge', alias='__typename'
    )


class ReleaseConnection(BaseModel):
    """
    The connection type for Release.
    """

    edges: Optional[List[Optional[ReleaseEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Release]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ReleaseConnection']] = Field(
        'ReleaseConnection', alias='__typename'
    )


class ReleaseEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Release] = None
    typename__: Optional[Literal['ReleaseEdge']] = Field(
        'ReleaseEdge', alias='__typename'
    )


class RemoveAssigneesFromAssignablePayload(BaseModel):
    """
    Autogenerated return type of RemoveAssigneesFromAssignable
    """

    assignable: Optional[Assignable] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['RemoveAssigneesFromAssignablePayload']] = Field(
        'RemoveAssigneesFromAssignablePayload', alias='__typename'
    )


class RemoveEnterpriseAdminPayload(BaseModel):
    """
    Autogenerated return type of RemoveEnterpriseAdmin
    """

    admin: Optional[User] = None
    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    viewer: Optional[User] = None
    typename__: Optional[Literal['RemoveEnterpriseAdminPayload']] = Field(
        'RemoveEnterpriseAdminPayload', alias='__typename'
    )


class RemoveEnterpriseIdentityProviderPayload(BaseModel):
    """
    Autogenerated return type of RemoveEnterpriseIdentityProvider
    """

    clientMutationId: Optional[String] = None
    identityProvider: Optional[EnterpriseIdentityProvider] = None
    typename__: Optional[Literal['RemoveEnterpriseIdentityProviderPayload']] = Field(
        'RemoveEnterpriseIdentityProviderPayload', alias='__typename'
    )


class RemoveEnterpriseMemberPayload(BaseModel):
    """
    Autogenerated return type of RemoveEnterpriseMember
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    user: Optional[User] = None
    viewer: Optional[User] = None
    typename__: Optional[Literal['RemoveEnterpriseMemberPayload']] = Field(
        'RemoveEnterpriseMemberPayload', alias='__typename'
    )


class RemoveEnterpriseOrganizationPayload(BaseModel):
    """
    Autogenerated return type of RemoveEnterpriseOrganization
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    organization: Optional[Organization] = None
    viewer: Optional[User] = None
    typename__: Optional[Literal['RemoveEnterpriseOrganizationPayload']] = Field(
        'RemoveEnterpriseOrganizationPayload', alias='__typename'
    )


class RemoveEnterpriseSupportEntitlementPayload(BaseModel):
    """
    Autogenerated return type of RemoveEnterpriseSupportEntitlement
    """

    clientMutationId: Optional[String] = None
    message: Optional[String] = None
    typename__: Optional[Literal['RemoveEnterpriseSupportEntitlementPayload']] = Field(
        'RemoveEnterpriseSupportEntitlementPayload', alias='__typename'
    )


class RemoveLabelsFromLabelablePayload(BaseModel):
    """
    Autogenerated return type of RemoveLabelsFromLabelable
    """

    clientMutationId: Optional[String] = None
    labelable: Optional[Labelable] = None
    typename__: Optional[Literal['RemoveLabelsFromLabelablePayload']] = Field(
        'RemoveLabelsFromLabelablePayload', alias='__typename'
    )


class RemoveOutsideCollaboratorPayload(BaseModel):
    """
    Autogenerated return type of RemoveOutsideCollaborator
    """

    clientMutationId: Optional[String] = None
    removedUser: Optional[User] = None
    typename__: Optional[Literal['RemoveOutsideCollaboratorPayload']] = Field(
        'RemoveOutsideCollaboratorPayload', alias='__typename'
    )


class RemoveReactionPayload(BaseModel):
    """
    Autogenerated return type of RemoveReaction
    """

    clientMutationId: Optional[String] = None
    reaction: Optional[Reaction] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    subject: Optional[Reactable] = None
    typename__: Optional[Literal['RemoveReactionPayload']] = Field(
        'RemoveReactionPayload', alias='__typename'
    )


class RemoveStarPayload(BaseModel):
    """
    Autogenerated return type of RemoveStar
    """

    clientMutationId: Optional[String] = None
    starrable: Optional[Starrable] = None
    typename__: Optional[Literal['RemoveStarPayload']] = Field(
        'RemoveStarPayload', alias='__typename'
    )


class RemoveUpvotePayload(BaseModel):
    """
    Autogenerated return type of RemoveUpvote
    """

    clientMutationId: Optional[String] = None
    subject: Optional[Votable] = None
    typename__: Optional[Literal['RemoveUpvotePayload']] = Field(
        'RemoveUpvotePayload', alias='__typename'
    )


class RemovedFromMergeQueueEvent(Node):
    """
    Represents a 'removed_from_merge_queue' event on a given pull request.
    """

    actor: Optional[Actor] = None
    beforeCommit: Optional[Commit] = None
    createdAt: DateTime
    enqueuer: Optional[User] = None
    id: ID
    mergeQueue: Optional[MergeQueue] = None
    pullRequest: Optional[PullRequest] = None
    reason: Optional[String] = None
    typename__: Optional[Literal['RemovedFromMergeQueueEvent']] = Field(
        'RemovedFromMergeQueueEvent', alias='__typename'
    )


class RemovedFromProjectEvent(Node):
    """
    Represents a 'removed_from_project' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    project: Optional[Project] = None
    projectColumnName: String
    typename__: Optional[Literal['RemovedFromProjectEvent']] = Field(
        'RemovedFromProjectEvent', alias='__typename'
    )


class RenamedTitleEvent(Node):
    """
    Represents a 'renamed' event on a given issue or pull request
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    currentTitle: String
    id: ID
    previousTitle: String
    subject: RenamedTitleSubject
    typename__: Optional[Literal['RenamedTitleEvent']] = Field(
        'RenamedTitleEvent', alias='__typename'
    )


class ReopenDiscussionPayload(BaseModel):
    """
    Autogenerated return type of ReopenDiscussion
    """

    clientMutationId: Optional[String] = None
    discussion: Optional[Discussion] = None
    typename__: Optional[Literal['ReopenDiscussionPayload']] = Field(
        'ReopenDiscussionPayload', alias='__typename'
    )


class ReopenIssuePayload(BaseModel):
    """
    Autogenerated return type of ReopenIssue
    """

    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    typename__: Optional[Literal['ReopenIssuePayload']] = Field(
        'ReopenIssuePayload', alias='__typename'
    )


class ReopenPullRequestPayload(BaseModel):
    """
    Autogenerated return type of ReopenPullRequest
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['ReopenPullRequestPayload']] = Field(
        'ReopenPullRequestPayload', alias='__typename'
    )


class ReopenedEvent(Node):
    """
    Represents a 'reopened' event on any `Closable`.
    """

    actor: Optional[Actor] = None
    closable: Closable
    createdAt: DateTime
    id: ID
    stateReason: Optional[IssueStateReason] = None
    typename__: Optional[Literal['ReopenedEvent']] = Field(
        'ReopenedEvent', alias='__typename'
    )


class RepoAccessAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.access event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    visibility: Optional[RepoAccessAuditEntryVisibility] = None
    typename__: Optional[Literal['RepoAccessAuditEntry']] = Field(
        'RepoAccessAuditEntry', alias='__typename'
    )


class RepoAddMemberAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.add_member event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    visibility: Optional[RepoAddMemberAuditEntryVisibility] = None
    typename__: Optional[Literal['RepoAddMemberAuditEntry']] = Field(
        'RepoAddMemberAuditEntry', alias='__typename'
    )


class RepoAddTopicAuditEntry(
    AuditEntry,
    Node,
    OrganizationAuditEntryData,
    RepositoryAuditEntryData,
    TopicAuditEntryData,
):
    """
    Audit log entry for a repo.add_topic event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    topic: Optional[Topic] = None
    topicName: Optional[String] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['RepoAddTopicAuditEntry']] = Field(
        'RepoAddTopicAuditEntry', alias='__typename'
    )


class RepoArchivedAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.archived event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    visibility: Optional[RepoArchivedAuditEntryVisibility] = None
    typename__: Optional[Literal['RepoArchivedAuditEntry']] = Field(
        'RepoArchivedAuditEntry', alias='__typename'
    )


class RepoChangeMergeSettingAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.change_merge_setting event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    isEnabled: Optional[Boolean] = None
    mergeType: Optional[RepoChangeMergeSettingAuditEntryMergeType] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['RepoChangeMergeSettingAuditEntry']] = Field(
        'RepoChangeMergeSettingAuditEntry', alias='__typename'
    )


class RepoConfigDisableAnonymousGitAccessAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.disable_anonymous_git_access event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepoConfigDisableAnonymousGitAccessAuditEntry']
    ] = Field('RepoConfigDisableAnonymousGitAccessAuditEntry', alias='__typename')


class RepoConfigDisableCollaboratorsOnlyAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.disable_collaborators_only event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepoConfigDisableCollaboratorsOnlyAuditEntry']
    ] = Field('RepoConfigDisableCollaboratorsOnlyAuditEntry', alias='__typename')


class RepoConfigDisableContributorsOnlyAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.disable_contributors_only event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepoConfigDisableContributorsOnlyAuditEntry']
    ] = Field('RepoConfigDisableContributorsOnlyAuditEntry', alias='__typename')


class RepoConfigDisableSockpuppetDisallowedAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.disable_sockpuppet_disallowed event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepoConfigDisableSockpuppetDisallowedAuditEntry']
    ] = Field('RepoConfigDisableSockpuppetDisallowedAuditEntry', alias='__typename')


class RepoConfigEnableAnonymousGitAccessAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.enable_anonymous_git_access event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepoConfigEnableAnonymousGitAccessAuditEntry']
    ] = Field('RepoConfigEnableAnonymousGitAccessAuditEntry', alias='__typename')


class RepoConfigEnableCollaboratorsOnlyAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.enable_collaborators_only event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepoConfigEnableCollaboratorsOnlyAuditEntry']
    ] = Field('RepoConfigEnableCollaboratorsOnlyAuditEntry', alias='__typename')


class RepoConfigEnableContributorsOnlyAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.enable_contributors_only event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['RepoConfigEnableContributorsOnlyAuditEntry']] = Field(
        'RepoConfigEnableContributorsOnlyAuditEntry', alias='__typename'
    )


class RepoConfigEnableSockpuppetDisallowedAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.enable_sockpuppet_disallowed event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepoConfigEnableSockpuppetDisallowedAuditEntry']
    ] = Field('RepoConfigEnableSockpuppetDisallowedAuditEntry', alias='__typename')


class RepoConfigLockAnonymousGitAccessAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.lock_anonymous_git_access event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['RepoConfigLockAnonymousGitAccessAuditEntry']] = Field(
        'RepoConfigLockAnonymousGitAccessAuditEntry', alias='__typename'
    )


class RepoConfigUnlockAnonymousGitAccessAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.config.unlock_anonymous_git_access event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepoConfigUnlockAnonymousGitAccessAuditEntry']
    ] = Field('RepoConfigUnlockAnonymousGitAccessAuditEntry', alias='__typename')


class RepoCreateAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.create event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    forkParentName: Optional[String] = None
    forkSourceName: Optional[String] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    visibility: Optional[RepoCreateAuditEntryVisibility] = None
    typename__: Optional[Literal['RepoCreateAuditEntry']] = Field(
        'RepoCreateAuditEntry', alias='__typename'
    )


class RepoDestroyAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.destroy event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    visibility: Optional[RepoDestroyAuditEntryVisibility] = None
    typename__: Optional[Literal['RepoDestroyAuditEntry']] = Field(
        'RepoDestroyAuditEntry', alias='__typename'
    )


class RepoRemoveMemberAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, RepositoryAuditEntryData
):
    """
    Audit log entry for a repo.remove_member event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    visibility: Optional[RepoRemoveMemberAuditEntryVisibility] = None
    typename__: Optional[Literal['RepoRemoveMemberAuditEntry']] = Field(
        'RepoRemoveMemberAuditEntry', alias='__typename'
    )


class RepoRemoveTopicAuditEntry(
    AuditEntry,
    Node,
    OrganizationAuditEntryData,
    RepositoryAuditEntryData,
    TopicAuditEntryData,
):
    """
    Audit log entry for a repo.remove_topic event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    topic: Optional[Topic] = None
    topicName: Optional[String] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['RepoRemoveTopicAuditEntry']] = Field(
        'RepoRemoveTopicAuditEntry', alias='__typename'
    )


class Repository(
    Node,
    PackageOwner,
    ProjectOwner,
    ProjectV2Recent,
    RepositoryInfo,
    Starrable,
    Subscribable,
    UniformResourceLocatable,
):
    """
    A repository contains the content for a project.
    """

    allowUpdateBranch: Boolean
    archivedAt: Optional[DateTime] = None
    assignableUsers: UserConnection
    autoMergeAllowed: Boolean
    branchProtectionRules: BranchProtectionRuleConnection
    codeOfConduct: Optional[CodeOfConduct] = None
    codeowners: Optional[RepositoryCodeowners] = None
    collaborators: Optional[RepositoryCollaboratorConnection] = None
    commitComments: CommitCommentConnection
    contactLinks: Optional[List[RepositoryContactLink]] = Field(default_factory=list)
    contributingGuidelines: Optional[ContributingGuidelines] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    defaultBranchRef: Optional[Ref] = None
    deleteBranchOnMerge: Boolean
    dependencyGraphManifests: Optional[DependencyGraphManifestConnection] = None
    deployKeys: DeployKeyConnection
    deployments: DeploymentConnection
    description: Optional[String] = None
    descriptionHTML: HTML
    discussion: Optional[Discussion] = None
    discussionCategories: DiscussionCategoryConnection
    discussionCategory: Optional[DiscussionCategory] = None
    discussions: DiscussionConnection
    diskUsage: Optional[Int] = None
    environment: Optional[Environment] = None
    environments: EnvironmentConnection
    forkCount: Int
    forkingAllowed: Boolean
    forks: RepositoryConnection
    fundingLinks: List[FundingLink]
    hasDiscussionsEnabled: Boolean
    hasIssuesEnabled: Boolean
    hasProjectsEnabled: Boolean
    hasVulnerabilityAlertsEnabled: Boolean
    hasWikiEnabled: Boolean
    homepageUrl: Optional[URI] = None
    id: ID
    interactionAbility: Optional[RepositoryInteractionAbility] = None
    isArchived: Boolean
    isBlankIssuesEnabled: Boolean
    isDisabled: Boolean
    isEmpty: Boolean
    isFork: Boolean
    isInOrganization: Boolean
    isLocked: Boolean
    isMirror: Boolean
    isPrivate: Boolean
    isSecurityPolicyEnabled: Optional[Boolean] = None
    isTemplate: Boolean
    isUserConfigurationRepository: Boolean
    issue: Optional[Issue] = None
    issueOrPullRequest: Optional[IssueOrPullRequest] = None
    issueTemplates: Optional[List[IssueTemplate]] = Field(default_factory=list)
    issues: IssueConnection
    label: Optional[Label] = None
    labels: Optional[LabelConnection] = None
    languages: Optional[LanguageConnection] = None
    latestRelease: Optional[Release] = None
    licenseInfo: Optional[License] = None
    lockReason: Optional[RepositoryLockReason] = None
    mentionableUsers: UserConnection
    mergeCommitAllowed: Boolean
    mergeCommitMessage: MergeCommitMessage
    mergeCommitTitle: MergeCommitTitle
    mergeQueue: Optional[MergeQueue] = None
    milestone: Optional[Milestone] = None
    milestones: Optional[MilestoneConnection] = None
    mirrorUrl: Optional[URI] = None
    name: String
    nameWithOwner: String
    object: Optional[GitObject] = None
    openGraphImageUrl: URI
    owner: RepositoryOwner
    packages: PackageConnection
    parent: Optional[Repository] = None
    pinnedDiscussions: PinnedDiscussionConnection
    pinnedIssues: Optional[PinnedIssueConnection] = None
    primaryLanguage: Optional[Language] = None
    project: Optional[Project] = None
    projectV2: Optional[ProjectV2] = None
    projects: ProjectConnection
    projectsResourcePath: URI
    projectsUrl: URI
    projectsV2: ProjectV2Connection
    pullRequest: Optional[PullRequest] = None
    pullRequestTemplates: Optional[List[PullRequestTemplate]] = Field(
        default_factory=list
    )
    pullRequests: PullRequestConnection
    pushedAt: Optional[DateTime] = None
    rebaseMergeAllowed: Boolean
    recentProjects: ProjectV2Connection
    ref: Optional[Ref] = None
    refs: Optional[RefConnection] = None
    release: Optional[Release] = None
    releases: ReleaseConnection
    repositoryTopics: RepositoryTopicConnection
    resourcePath: URI
    ruleset: Optional[RepositoryRuleset] = None
    rulesets: Optional[RepositoryRulesetConnection] = None
    securityPolicyUrl: Optional[URI] = None
    shortDescriptionHTML: HTML
    squashMergeAllowed: Boolean
    squashMergeCommitMessage: SquashMergeCommitMessage
    squashMergeCommitTitle: SquashMergeCommitTitle
    squashPrTitleUsedAsDefault: Boolean
    sshUrl: GitSSHRemote
    stargazerCount: Int
    stargazers: StargazerConnection
    submodules: SubmoduleConnection
    tempCloneToken: Optional[String] = None
    templateRepository: Optional[Repository] = None
    updatedAt: DateTime
    url: URI
    usesCustomOpenGraphImage: Boolean
    viewerCanAdminister: Boolean
    viewerCanCreateProjects: Boolean
    viewerCanSubscribe: Boolean
    viewerCanUpdateTopics: Boolean
    viewerDefaultCommitEmail: Optional[String] = None
    viewerDefaultMergeMethod: PullRequestMergeMethod
    viewerHasStarred: Boolean
    viewerPermission: Optional[RepositoryPermission] = None
    viewerPossibleCommitEmails: Optional[List[String]] = Field(default_factory=list)
    viewerSubscription: Optional[SubscriptionState] = None
    visibility: RepositoryVisibility
    vulnerabilityAlert: Optional[RepositoryVulnerabilityAlert] = None
    vulnerabilityAlerts: Optional[RepositoryVulnerabilityAlertConnection] = None
    watchers: UserConnection
    webCommitSignoffRequired: Boolean
    typename__: Optional[Literal['Repository']] = Field(
        'Repository', alias='__typename'
    )


class RepositoryCodeowners(BaseModel):
    """
    Information extracted from a repository's `CODEOWNERS` file.
    """

    errors: List[RepositoryCodeownersError]
    typename__: Optional[Literal['RepositoryCodeowners']] = Field(
        'RepositoryCodeowners', alias='__typename'
    )


class RepositoryCodeownersError(BaseModel):
    """
    An error in a `CODEOWNERS` file.
    """

    column: Int
    kind: String
    line: Int
    message: String
    path: String
    source: String
    suggestion: Optional[String] = None
    typename__: Optional[Literal['RepositoryCodeownersError']] = Field(
        'RepositoryCodeownersError', alias='__typename'
    )


class RepositoryCollaboratorConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[RepositoryCollaboratorEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RepositoryCollaboratorConnection']] = Field(
        'RepositoryCollaboratorConnection', alias='__typename'
    )


class RepositoryCollaboratorEdge(BaseModel):
    """
    Represents a user who is a collaborator of a repository.
    """

    cursor: String
    node: User
    permission: RepositoryPermission
    permissionSources: Optional[List[PermissionSource]] = Field(default_factory=list)
    typename__: Optional[Literal['RepositoryCollaboratorEdge']] = Field(
        'RepositoryCollaboratorEdge', alias='__typename'
    )


class RepositoryConnection(BaseModel):
    """
    A list of repositories owned by the subject.
    """

    edges: Optional[List[Optional[RepositoryEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Repository]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    totalDiskUsage: Int
    typename__: Optional[Literal['RepositoryConnection']] = Field(
        'RepositoryConnection', alias='__typename'
    )


class RepositoryContactLink(BaseModel):
    """
    A repository contact link.
    """

    about: String
    name: String
    url: URI
    typename__: Optional[Literal['RepositoryContactLink']] = Field(
        'RepositoryContactLink', alias='__typename'
    )


class RepositoryEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Repository] = None
    typename__: Optional[Literal['RepositoryEdge']] = Field(
        'RepositoryEdge', alias='__typename'
    )


class RepositoryIdConditionTarget(BaseModel):
    """
    Parameters to be used for the repository_id condition
    """

    repositoryIds: List[ID]
    typename__: Optional[Literal['RepositoryIdConditionTarget']] = Field(
        'RepositoryIdConditionTarget', alias='__typename'
    )


class RepositoryInteractionAbility(BaseModel):
    """
    Repository interaction limit that applies to this object.
    """

    expiresAt: Optional[DateTime] = None
    limit: RepositoryInteractionLimit
    origin: RepositoryInteractionLimitOrigin
    typename__: Optional[Literal['RepositoryInteractionAbility']] = Field(
        'RepositoryInteractionAbility', alias='__typename'
    )


class RepositoryInvitation(Node):
    """
    An invitation for a user to be added to a repository.
    """

    email: Optional[String] = None
    id: ID
    invitee: Optional[User] = None
    inviter: User
    permalink: URI
    permission: RepositoryPermission
    repository: Optional[RepositoryInfo] = None
    typename__: Optional[Literal['RepositoryInvitation']] = Field(
        'RepositoryInvitation', alias='__typename'
    )


class RepositoryInvitationConnection(BaseModel):
    """
    A list of repository invitations.
    """

    edges: Optional[List[Optional[RepositoryInvitationEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[RepositoryInvitation]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RepositoryInvitationConnection']] = Field(
        'RepositoryInvitationConnection', alias='__typename'
    )


class RepositoryInvitationEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[RepositoryInvitation] = None
    typename__: Optional[Literal['RepositoryInvitationEdge']] = Field(
        'RepositoryInvitationEdge', alias='__typename'
    )


class RepositoryMigration(Migration, Node):
    """
    A GitHub Enterprise Importer (GEI) repository migration.
    """

    continueOnError: Boolean
    createdAt: DateTime
    databaseId: Optional[String] = None
    failureReason: Optional[String] = None
    id: ID
    migrationLogUrl: Optional[URI] = None
    migrationSource: MigrationSource
    repositoryName: String
    sourceUrl: URI
    state: MigrationState
    warningsCount: Int
    typename__: Optional[Literal['RepositoryMigration']] = Field(
        'RepositoryMigration', alias='__typename'
    )


class RepositoryMigrationConnection(BaseModel):
    """
    The connection type for RepositoryMigration.
    """

    edges: Optional[List[Optional[RepositoryMigrationEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[RepositoryMigration]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RepositoryMigrationConnection']] = Field(
        'RepositoryMigrationConnection', alias='__typename'
    )


class RepositoryMigrationEdge(BaseModel):
    """
    Represents a repository migration.
    """

    cursor: String
    node: Optional[RepositoryMigration] = None
    typename__: Optional[Literal['RepositoryMigrationEdge']] = Field(
        'RepositoryMigrationEdge', alias='__typename'
    )


class RepositoryNameConditionTarget(BaseModel):
    """
    Parameters to be used for the repository_name condition
    """

    exclude: List[String]
    include: List[String]
    protected: Boolean
    typename__: Optional[Literal['RepositoryNameConditionTarget']] = Field(
        'RepositoryNameConditionTarget', alias='__typename'
    )


class RepositoryRule(Node):
    """
    A repository rule.
    """

    id: ID
    parameters: Optional[RuleParameters] = None
    repositoryRuleset: Optional[RepositoryRuleset] = None
    type: RepositoryRuleType
    typename__: Optional[Literal['RepositoryRule']] = Field(
        'RepositoryRule', alias='__typename'
    )


class RepositoryRuleConditions(BaseModel):
    """
    Set of conditions that determine if a ruleset will evaluate
    """

    refName: Optional[RefNameConditionTarget] = None
    repositoryId: Optional[RepositoryIdConditionTarget] = None
    repositoryName: Optional[RepositoryNameConditionTarget] = None
    typename__: Optional[Literal['RepositoryRuleConditions']] = Field(
        'RepositoryRuleConditions', alias='__typename'
    )


class RepositoryRuleConnection(BaseModel):
    """
    The connection type for RepositoryRule.
    """

    edges: Optional[List[Optional[RepositoryRuleEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[RepositoryRule]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RepositoryRuleConnection']] = Field(
        'RepositoryRuleConnection', alias='__typename'
    )


class RepositoryRuleEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[RepositoryRule] = None
    typename__: Optional[Literal['RepositoryRuleEdge']] = Field(
        'RepositoryRuleEdge', alias='__typename'
    )


class RepositoryRuleset(Node):
    """
    A repository ruleset.
    """

    bypassActors: Optional[RepositoryRulesetBypassActorConnection] = None
    conditions: RepositoryRuleConditions
    createdAt: DateTime
    databaseId: Optional[Int] = None
    enforcement: RuleEnforcement
    id: ID
    name: String
    rules: Optional[RepositoryRuleConnection] = None
    source: RuleSource
    target: Optional[RepositoryRulesetTarget] = None
    updatedAt: DateTime
    typename__: Optional[Literal['RepositoryRuleset']] = Field(
        'RepositoryRuleset', alias='__typename'
    )


class RepositoryRulesetBypassActor(Node):
    """
    A team or app that has the ability to bypass a rules defined on a ruleset
    """

    actor: Optional[BypassActor] = None
    bypassMode: Optional[RepositoryRulesetBypassActorBypassMode] = None
    id: ID
    organizationAdmin: Boolean
    repositoryRoleDatabaseId: Optional[Int] = None
    repositoryRoleName: Optional[String] = None
    repositoryRuleset: Optional[RepositoryRuleset] = None
    typename__: Optional[Literal['RepositoryRulesetBypassActor']] = Field(
        'RepositoryRulesetBypassActor', alias='__typename'
    )


class RepositoryRulesetBypassActorConnection(BaseModel):
    """
    The connection type for RepositoryRulesetBypassActor.
    """

    edges: Optional[List[Optional[RepositoryRulesetBypassActorEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[RepositoryRulesetBypassActor]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RepositoryRulesetBypassActorConnection']] = Field(
        'RepositoryRulesetBypassActorConnection', alias='__typename'
    )


class RepositoryRulesetBypassActorEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[RepositoryRulesetBypassActor] = None
    typename__: Optional[Literal['RepositoryRulesetBypassActorEdge']] = Field(
        'RepositoryRulesetBypassActorEdge', alias='__typename'
    )


class RepositoryRulesetConnection(BaseModel):
    """
    The connection type for RepositoryRuleset.
    """

    edges: Optional[List[Optional[RepositoryRulesetEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[RepositoryRuleset]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RepositoryRulesetConnection']] = Field(
        'RepositoryRulesetConnection', alias='__typename'
    )


class RepositoryRulesetEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[RepositoryRuleset] = None
    typename__: Optional[Literal['RepositoryRulesetEdge']] = Field(
        'RepositoryRulesetEdge', alias='__typename'
    )


class RepositoryTopic(Node, UniformResourceLocatable):
    """
    A repository-topic connects a repository to a topic.
    """

    id: ID
    resourcePath: URI
    topic: Topic
    url: URI
    typename__: Optional[Literal['RepositoryTopic']] = Field(
        'RepositoryTopic', alias='__typename'
    )


class RepositoryTopicConnection(BaseModel):
    """
    The connection type for RepositoryTopic.
    """

    edges: Optional[List[Optional[RepositoryTopicEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[RepositoryTopic]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RepositoryTopicConnection']] = Field(
        'RepositoryTopicConnection', alias='__typename'
    )


class RepositoryTopicEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[RepositoryTopic] = None
    typename__: Optional[Literal['RepositoryTopicEdge']] = Field(
        'RepositoryTopicEdge', alias='__typename'
    )


class RepositoryVisibilityChangeDisableAuditEntry(
    AuditEntry, EnterpriseAuditEntryData, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a repository_visibility_change.disable event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[
        Literal['RepositoryVisibilityChangeDisableAuditEntry']
    ] = Field('RepositoryVisibilityChangeDisableAuditEntry', alias='__typename')


class RepositoryVisibilityChangeEnableAuditEntry(
    AuditEntry, EnterpriseAuditEntryData, Node, OrganizationAuditEntryData
):
    """
    Audit log entry for a repository_visibility_change.enable event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    enterpriseResourcePath: Optional[URI] = None
    enterpriseSlug: Optional[String] = None
    enterpriseUrl: Optional[URI] = None
    id: ID
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['RepositoryVisibilityChangeEnableAuditEntry']] = Field(
        'RepositoryVisibilityChangeEnableAuditEntry', alias='__typename'
    )


class RepositoryVulnerabilityAlert(Node, RepositoryNode):
    """
    A Dependabot alert for a repository with a dependency affected by a security vulnerability.
    """

    autoDismissedAt: Optional[DateTime] = None
    createdAt: DateTime
    dependabotUpdate: Optional[DependabotUpdate] = None
    dependencyScope: Optional[RepositoryVulnerabilityAlertDependencyScope] = None
    dismissComment: Optional[String] = None
    dismissReason: Optional[String] = None
    dismissedAt: Optional[DateTime] = None
    dismisser: Optional[User] = None
    fixedAt: Optional[DateTime] = None
    id: ID
    number: Int
    repository: Repository
    securityAdvisory: Optional[SecurityAdvisory] = None
    securityVulnerability: Optional[SecurityVulnerability] = None
    state: RepositoryVulnerabilityAlertState
    vulnerableManifestFilename: String
    vulnerableManifestPath: String
    vulnerableRequirements: Optional[String] = None
    typename__: Optional[Literal['RepositoryVulnerabilityAlert']] = Field(
        'RepositoryVulnerabilityAlert', alias='__typename'
    )


class RepositoryVulnerabilityAlertConnection(BaseModel):
    """
    The connection type for RepositoryVulnerabilityAlert.
    """

    edges: Optional[List[Optional[RepositoryVulnerabilityAlertEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[RepositoryVulnerabilityAlert]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RepositoryVulnerabilityAlertConnection']] = Field(
        'RepositoryVulnerabilityAlertConnection', alias='__typename'
    )


class RepositoryVulnerabilityAlertEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[RepositoryVulnerabilityAlert] = None
    typename__: Optional[Literal['RepositoryVulnerabilityAlertEdge']] = Field(
        'RepositoryVulnerabilityAlertEdge', alias='__typename'
    )


class RequestReviewsPayload(BaseModel):
    """
    Autogenerated return type of RequestReviews
    """

    actor: Optional[Actor] = None
    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    requestedReviewersEdge: Optional[UserEdge] = None
    typename__: Optional[Literal['RequestReviewsPayload']] = Field(
        'RequestReviewsPayload', alias='__typename'
    )


class RequestedReviewerConnection(BaseModel):
    """
    The connection type for RequestedReviewer.
    """

    edges: Optional[List[Optional[RequestedReviewerEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[RequestedReviewer]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['RequestedReviewerConnection']] = Field(
        'RequestedReviewerConnection', alias='__typename'
    )


class RequestedReviewerEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[RequestedReviewer] = None
    typename__: Optional[Literal['RequestedReviewerEdge']] = Field(
        'RequestedReviewerEdge', alias='__typename'
    )


class RequiredDeploymentsParameters(BaseModel):
    """
    Choose which environments must be successfully deployed to before refs can be pushed into a ref that matches this rule.
    """

    requiredDeploymentEnvironments: List[String]
    typename__: Optional[Literal['RequiredDeploymentsParameters']] = Field(
        'RequiredDeploymentsParameters', alias='__typename'
    )


class RequiredStatusCheckDescription(BaseModel):
    """
    Represents a required status check for a protected branch, but not any specific run of that check.
    """

    app: Optional[App] = None
    context: String
    typename__: Optional[Literal['RequiredStatusCheckDescription']] = Field(
        'RequiredStatusCheckDescription', alias='__typename'
    )


class RequiredStatusChecksParameters(BaseModel):
    """
    Choose which status checks must pass before the ref is updated. When enabled,
    commits must first be pushed to another ref where the checks pass.
    """

    requiredStatusChecks: List[StatusCheckConfiguration]
    strictRequiredStatusChecksPolicy: Boolean
    typename__: Optional[Literal['RequiredStatusChecksParameters']] = Field(
        'RequiredStatusChecksParameters', alias='__typename'
    )


class RerequestCheckSuitePayload(BaseModel):
    """
    Autogenerated return type of RerequestCheckSuite
    """

    checkSuite: Optional[CheckSuite] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['RerequestCheckSuitePayload']] = Field(
        'RerequestCheckSuitePayload', alias='__typename'
    )


class ResolveReviewThreadPayload(BaseModel):
    """
    Autogenerated return type of ResolveReviewThread
    """

    clientMutationId: Optional[String] = None
    thread: Optional[PullRequestReviewThread] = None
    typename__: Optional[Literal['ResolveReviewThreadPayload']] = Field(
        'ResolveReviewThreadPayload', alias='__typename'
    )


class RestrictedContribution(Contribution):
    """
    Represents a private contribution a user made on GitHub.
    """

    isRestricted: Boolean
    occurredAt: DateTime
    resourcePath: URI
    url: URI
    user: User
    typename__: Optional[Literal['RestrictedContribution']] = Field(
        'RestrictedContribution', alias='__typename'
    )


class RetireSponsorsTierPayload(BaseModel):
    """
    Autogenerated return type of RetireSponsorsTier
    """

    clientMutationId: Optional[String] = None
    sponsorsTier: Optional[SponsorsTier] = None
    typename__: Optional[Literal['RetireSponsorsTierPayload']] = Field(
        'RetireSponsorsTierPayload', alias='__typename'
    )


class RevertPullRequestPayload(BaseModel):
    """
    Autogenerated return type of RevertPullRequest
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    revertPullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['RevertPullRequestPayload']] = Field(
        'RevertPullRequestPayload', alias='__typename'
    )


class ReviewDismissalAllowance(Node):
    """
    A user, team, or app who has the ability to dismiss a review on a protected branch.
    """

    actor: Optional[ReviewDismissalAllowanceActor] = None
    branchProtectionRule: Optional[BranchProtectionRule] = None
    id: ID
    typename__: Optional[Literal['ReviewDismissalAllowance']] = Field(
        'ReviewDismissalAllowance', alias='__typename'
    )


class ReviewDismissalAllowanceConnection(BaseModel):
    """
    The connection type for ReviewDismissalAllowance.
    """

    edges: Optional[List[Optional[ReviewDismissalAllowanceEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[ReviewDismissalAllowance]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ReviewDismissalAllowanceConnection']] = Field(
        'ReviewDismissalAllowanceConnection', alias='__typename'
    )


class ReviewDismissalAllowanceEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ReviewDismissalAllowance] = None
    typename__: Optional[Literal['ReviewDismissalAllowanceEdge']] = Field(
        'ReviewDismissalAllowanceEdge', alias='__typename'
    )


class ReviewDismissedEvent(Node, UniformResourceLocatable):
    """
    Represents a 'review_dismissed' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    databaseId: Optional[Int] = None
    dismissalMessage: Optional[String] = None
    dismissalMessageHTML: Optional[String] = None
    id: ID
    previousReviewState: PullRequestReviewState
    pullRequest: PullRequest
    pullRequestCommit: Optional[PullRequestCommit] = None
    resourcePath: URI
    review: Optional[PullRequestReview] = None
    url: URI
    typename__: Optional[Literal['ReviewDismissedEvent']] = Field(
        'ReviewDismissedEvent', alias='__typename'
    )


class ReviewRequest(Node):
    """
    A request for a user to review a pull request.
    """

    asCodeOwner: Boolean
    databaseId: Optional[Int] = None
    id: ID
    pullRequest: PullRequest
    requestedReviewer: Optional[RequestedReviewer] = None
    typename__: Optional[Literal['ReviewRequest']] = Field(
        'ReviewRequest', alias='__typename'
    )


class ReviewRequestConnection(BaseModel):
    """
    The connection type for ReviewRequest.
    """

    edges: Optional[List[Optional[ReviewRequestEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[ReviewRequest]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['ReviewRequestConnection']] = Field(
        'ReviewRequestConnection', alias='__typename'
    )


class ReviewRequestEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[ReviewRequest] = None
    typename__: Optional[Literal['ReviewRequestEdge']] = Field(
        'ReviewRequestEdge', alias='__typename'
    )


class ReviewRequestRemovedEvent(Node):
    """
    Represents an 'review_request_removed' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    pullRequest: PullRequest
    requestedReviewer: Optional[RequestedReviewer] = None
    typename__: Optional[Literal['ReviewRequestRemovedEvent']] = Field(
        'ReviewRequestRemovedEvent', alias='__typename'
    )


class ReviewRequestedEvent(Node):
    """
    Represents an 'review_requested' event on a given pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    pullRequest: PullRequest
    requestedReviewer: Optional[RequestedReviewer] = None
    typename__: Optional[Literal['ReviewRequestedEvent']] = Field(
        'ReviewRequestedEvent', alias='__typename'
    )


class ReviewStatusHovercardContext(HovercardContext):
    """
    A hovercard context with a message describing the current code review state of the pull
    request.
    """

    message: String
    octicon: String
    reviewDecision: Optional[PullRequestReviewDecision] = None
    typename__: Optional[Literal['ReviewStatusHovercardContext']] = Field(
        'ReviewStatusHovercardContext', alias='__typename'
    )


class RevokeEnterpriseOrganizationsMigratorRolePayload(BaseModel):
    """
    Autogenerated return type of RevokeEnterpriseOrganizationsMigratorRole
    """

    clientMutationId: Optional[String] = None
    organizations: Optional[OrganizationConnection] = None
    typename__: Optional[
        Literal['RevokeEnterpriseOrganizationsMigratorRolePayload']
    ] = Field('RevokeEnterpriseOrganizationsMigratorRolePayload', alias='__typename')


class RevokeMigratorRolePayload(BaseModel):
    """
    Autogenerated return type of RevokeMigratorRole
    """

    clientMutationId: Optional[String] = None
    success: Optional[Boolean] = None
    typename__: Optional[Literal['RevokeMigratorRolePayload']] = Field(
        'RevokeMigratorRolePayload', alias='__typename'
    )


class SavedReply(Node):
    """
    A Saved Reply is text a user can use to reply quickly.
    """

    body: String
    bodyHTML: HTML
    databaseId: Optional[Int] = None
    id: ID
    title: String
    user: Optional[Actor] = None
    typename__: Optional[Literal['SavedReply']] = Field(
        'SavedReply', alias='__typename'
    )


class SavedReplyConnection(BaseModel):
    """
    The connection type for SavedReply.
    """

    edges: Optional[List[Optional[SavedReplyEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[SavedReply]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SavedReplyConnection']] = Field(
        'SavedReplyConnection', alias='__typename'
    )


class SavedReplyEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SavedReply] = None
    typename__: Optional[Literal['SavedReplyEdge']] = Field(
        'SavedReplyEdge', alias='__typename'
    )


class SearchResultItemConnection(BaseModel):
    """
    A list of results that matched against a search query. Regardless of the number
    of matches, a maximum of 1,000 results will be available across all types,
    potentially split across many pages.
    """

    codeCount: Int
    discussionCount: Int
    edges: Optional[List[Optional[SearchResultItemEdge]]] = Field(default_factory=list)
    issueCount: Int
    nodes: Optional[List[Optional[SearchResultItem]]] = Field(default_factory=list)
    pageInfo: PageInfo
    repositoryCount: Int
    userCount: Int
    wikiCount: Int
    typename__: Optional[Literal['SearchResultItemConnection']] = Field(
        'SearchResultItemConnection', alias='__typename'
    )


class SearchResultItemEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SearchResultItem] = None
    textMatches: Optional[List[Optional[TextMatch]]] = Field(default_factory=list)
    typename__: Optional[Literal['SearchResultItemEdge']] = Field(
        'SearchResultItemEdge', alias='__typename'
    )


class SecurityAdvisory(Node):
    """
    A GitHub Security Advisory
    """

    classification: SecurityAdvisoryClassification
    cvss: CVSS
    cwes: CWEConnection
    databaseId: Optional[Int] = None
    description: String
    ghsaId: String
    id: ID
    identifiers: List[SecurityAdvisoryIdentifier]
    notificationsPermalink: Optional[URI] = None
    origin: String
    permalink: Optional[URI] = None
    publishedAt: DateTime
    references: List[SecurityAdvisoryReference]
    severity: SecurityAdvisorySeverity
    summary: String
    updatedAt: DateTime
    vulnerabilities: SecurityVulnerabilityConnection
    withdrawnAt: Optional[DateTime] = None
    typename__: Optional[Literal['SecurityAdvisory']] = Field(
        'SecurityAdvisory', alias='__typename'
    )


class SecurityAdvisoryConnection(BaseModel):
    """
    The connection type for SecurityAdvisory.
    """

    edges: Optional[List[Optional[SecurityAdvisoryEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[SecurityAdvisory]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SecurityAdvisoryConnection']] = Field(
        'SecurityAdvisoryConnection', alias='__typename'
    )


class SecurityAdvisoryEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SecurityAdvisory] = None
    typename__: Optional[Literal['SecurityAdvisoryEdge']] = Field(
        'SecurityAdvisoryEdge', alias='__typename'
    )


class SecurityAdvisoryIdentifier(BaseModel):
    """
    A GitHub Security Advisory Identifier
    """

    type: String
    value: String
    typename__: Optional[Literal['SecurityAdvisoryIdentifier']] = Field(
        'SecurityAdvisoryIdentifier', alias='__typename'
    )


class SecurityAdvisoryPackage(BaseModel):
    """
    An individual package
    """

    ecosystem: SecurityAdvisoryEcosystem
    name: String
    typename__: Optional[Literal['SecurityAdvisoryPackage']] = Field(
        'SecurityAdvisoryPackage', alias='__typename'
    )


class SecurityAdvisoryPackageVersion(BaseModel):
    """
    An individual package version
    """

    identifier: String
    typename__: Optional[Literal['SecurityAdvisoryPackageVersion']] = Field(
        'SecurityAdvisoryPackageVersion', alias='__typename'
    )


class SecurityAdvisoryReference(BaseModel):
    """
    A GitHub Security Advisory Reference
    """

    url: URI
    typename__: Optional[Literal['SecurityAdvisoryReference']] = Field(
        'SecurityAdvisoryReference', alias='__typename'
    )


class SecurityVulnerability(BaseModel):
    """
    An individual vulnerability within an Advisory
    """

    advisory: SecurityAdvisory
    firstPatchedVersion: Optional[SecurityAdvisoryPackageVersion] = None
    package: SecurityAdvisoryPackage
    severity: SecurityAdvisorySeverity
    updatedAt: DateTime
    vulnerableVersionRange: String
    typename__: Optional[Literal['SecurityVulnerability']] = Field(
        'SecurityVulnerability', alias='__typename'
    )


class SecurityVulnerabilityConnection(BaseModel):
    """
    The connection type for SecurityVulnerability.
    """

    edges: Optional[List[Optional[SecurityVulnerabilityEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[SecurityVulnerability]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SecurityVulnerabilityConnection']] = Field(
        'SecurityVulnerabilityConnection', alias='__typename'
    )


class SecurityVulnerabilityEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SecurityVulnerability] = None
    typename__: Optional[Literal['SecurityVulnerabilityEdge']] = Field(
        'SecurityVulnerabilityEdge', alias='__typename'
    )


class SetEnterpriseIdentityProviderPayload(BaseModel):
    """
    Autogenerated return type of SetEnterpriseIdentityProvider
    """

    clientMutationId: Optional[String] = None
    identityProvider: Optional[EnterpriseIdentityProvider] = None
    typename__: Optional[Literal['SetEnterpriseIdentityProviderPayload']] = Field(
        'SetEnterpriseIdentityProviderPayload', alias='__typename'
    )


class SetOrganizationInteractionLimitPayload(BaseModel):
    """
    Autogenerated return type of SetOrganizationInteractionLimit
    """

    clientMutationId: Optional[String] = None
    organization: Optional[Organization] = None
    typename__: Optional[Literal['SetOrganizationInteractionLimitPayload']] = Field(
        'SetOrganizationInteractionLimitPayload', alias='__typename'
    )


class SetRepositoryInteractionLimitPayload(BaseModel):
    """
    Autogenerated return type of SetRepositoryInteractionLimit
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['SetRepositoryInteractionLimitPayload']] = Field(
        'SetRepositoryInteractionLimitPayload', alias='__typename'
    )


class SetUserInteractionLimitPayload(BaseModel):
    """
    Autogenerated return type of SetUserInteractionLimit
    """

    clientMutationId: Optional[String] = None
    user: Optional[User] = None
    typename__: Optional[Literal['SetUserInteractionLimitPayload']] = Field(
        'SetUserInteractionLimitPayload', alias='__typename'
    )


class SmimeSignature(GitSignature):
    """
    Represents an S/MIME signature on a Commit or Tag.
    """

    email: String
    isValid: Boolean
    payload: String
    signature: String
    signer: Optional[User] = None
    state: GitSignatureState
    wasSignedByGitHub: Boolean
    typename__: Optional[Literal['SmimeSignature']] = Field(
        'SmimeSignature', alias='__typename'
    )


class SocialAccount(BaseModel):
    """
    Social media profile associated with a user.
    """

    displayName: String
    provider: SocialAccountProvider
    url: URI
    typename__: Optional[Literal['SocialAccount']] = Field(
        'SocialAccount', alias='__typename'
    )


class SocialAccountConnection(BaseModel):
    """
    The connection type for SocialAccount.
    """

    edges: Optional[List[Optional[SocialAccountEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[SocialAccount]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SocialAccountConnection']] = Field(
        'SocialAccountConnection', alias='__typename'
    )


class SocialAccountEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SocialAccount] = None
    typename__: Optional[Literal['SocialAccountEdge']] = Field(
        'SocialAccountEdge', alias='__typename'
    )


class SponsorConnection(BaseModel):
    """
    The connection type for Sponsor.
    """

    edges: Optional[List[Optional[SponsorEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Sponsor]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SponsorConnection']] = Field(
        'SponsorConnection', alias='__typename'
    )


class SponsorEdge(BaseModel):
    """
    Represents a user or organization who is sponsoring someone in GitHub Sponsors.
    """

    cursor: String
    node: Optional[Sponsor] = None
    typename__: Optional[Literal['SponsorEdge']] = Field(
        'SponsorEdge', alias='__typename'
    )


class SponsorableItemConnection(BaseModel):
    """
    The connection type for SponsorableItem.
    """

    edges: Optional[List[Optional[SponsorableItemEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[SponsorableItem]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SponsorableItemConnection']] = Field(
        'SponsorableItemConnection', alias='__typename'
    )


class SponsorableItemEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SponsorableItem] = None
    typename__: Optional[Literal['SponsorableItemEdge']] = Field(
        'SponsorableItemEdge', alias='__typename'
    )


class SponsorsActivity(Node):
    """
    An event related to sponsorship activity.
    """

    action: SponsorsActivityAction
    currentPrivacyLevel: Optional[SponsorshipPrivacy] = None
    id: ID
    paymentSource: Optional[SponsorshipPaymentSource] = None
    previousSponsorsTier: Optional[SponsorsTier] = None
    sponsor: Optional[Sponsor] = None
    sponsorable: Sponsorable
    sponsorsTier: Optional[SponsorsTier] = None
    timestamp: Optional[DateTime] = None
    viaBulkSponsorship: Boolean
    typename__: Optional[Literal['SponsorsActivity']] = Field(
        'SponsorsActivity', alias='__typename'
    )


class SponsorsActivityConnection(BaseModel):
    """
    The connection type for SponsorsActivity.
    """

    edges: Optional[List[Optional[SponsorsActivityEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[SponsorsActivity]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SponsorsActivityConnection']] = Field(
        'SponsorsActivityConnection', alias='__typename'
    )


class SponsorsActivityEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SponsorsActivity] = None
    typename__: Optional[Literal['SponsorsActivityEdge']] = Field(
        'SponsorsActivityEdge', alias='__typename'
    )


class SponsorsGoal(BaseModel):
    """
    A goal associated with a GitHub Sponsors listing, representing a target the sponsored maintainer would like to attain.
    """

    description: Optional[String] = None
    kind: SponsorsGoalKind
    percentComplete: Int
    targetValue: Int
    title: String
    typename__: Optional[Literal['SponsorsGoal']] = Field(
        'SponsorsGoal', alias='__typename'
    )


class SponsorsListing(Node):
    """
    A GitHub Sponsors listing.
    """

    activeGoal: Optional[SponsorsGoal] = None
    activeStripeConnectAccount: Optional[StripeConnectAccount] = None
    billingCountryOrRegion: Optional[String] = None
    contactEmailAddress: Optional[String] = None
    createdAt: DateTime
    dashboardResourcePath: URI
    dashboardUrl: URI
    featuredItems: List[SponsorsListingFeaturedItem]
    fiscalHost: Optional[Organization] = None
    fullDescription: String
    fullDescriptionHTML: HTML
    id: ID
    isPublic: Boolean
    name: String
    nextPayoutDate: Optional[Date] = None
    residenceCountryOrRegion: Optional[String] = None
    resourcePath: URI
    shortDescription: String
    slug: String
    sponsorable: Sponsorable
    tiers: Optional[SponsorsTierConnection] = None
    url: URI
    typename__: Optional[Literal['SponsorsListing']] = Field(
        'SponsorsListing', alias='__typename'
    )


class SponsorsListingFeaturedItem(Node):
    """
    A record that is promoted on a GitHub Sponsors profile.
    """

    createdAt: DateTime
    description: Optional[String] = None
    featureable: SponsorsListingFeatureableItem
    id: ID
    position: Int
    sponsorsListing: SponsorsListing
    updatedAt: DateTime
    typename__: Optional[Literal['SponsorsListingFeaturedItem']] = Field(
        'SponsorsListingFeaturedItem', alias='__typename'
    )


class SponsorsTier(Node):
    """
    A GitHub Sponsors tier associated with a GitHub Sponsors listing.
    """

    adminInfo: Optional[SponsorsTierAdminInfo] = None
    closestLesserValueTier: Optional[SponsorsTier] = None
    createdAt: DateTime
    description: String
    descriptionHTML: HTML
    id: ID
    isCustomAmount: Boolean
    isOneTime: Boolean
    monthlyPriceInCents: Int
    monthlyPriceInDollars: Int
    name: String
    sponsorsListing: SponsorsListing
    updatedAt: DateTime
    typename__: Optional[Literal['SponsorsTier']] = Field(
        'SponsorsTier', alias='__typename'
    )


class SponsorsTierAdminInfo(BaseModel):
    """
    SponsorsTier information only visible to users that can administer the associated Sponsors listing.
    """

    isDraft: Boolean
    isPublished: Boolean
    isRetired: Boolean
    sponsorships: SponsorshipConnection
    typename__: Optional[Literal['SponsorsTierAdminInfo']] = Field(
        'SponsorsTierAdminInfo', alias='__typename'
    )


class SponsorsTierConnection(BaseModel):
    """
    The connection type for SponsorsTier.
    """

    edges: Optional[List[Optional[SponsorsTierEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[SponsorsTier]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SponsorsTierConnection']] = Field(
        'SponsorsTierConnection', alias='__typename'
    )


class SponsorsTierEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SponsorsTier] = None
    typename__: Optional[Literal['SponsorsTierEdge']] = Field(
        'SponsorsTierEdge', alias='__typename'
    )


class Sponsorship(Node):
    """
    A sponsorship relationship between a sponsor and a maintainer
    """

    createdAt: DateTime
    id: ID
    isActive: Boolean
    isOneTimePayment: Boolean
    isSponsorOptedIntoEmail: Optional[Boolean] = None
    maintainer: User
    paymentSource: Optional[SponsorshipPaymentSource] = None
    privacyLevel: SponsorshipPrivacy
    sponsor: Optional[User] = None
    sponsorEntity: Optional[Sponsor] = None
    sponsorable: Sponsorable
    tier: Optional[SponsorsTier] = None
    tierSelectedAt: Optional[DateTime] = None
    typename__: Optional[Literal['Sponsorship']] = Field(
        'Sponsorship', alias='__typename'
    )


class SponsorshipConnection(BaseModel):
    """
    The connection type for Sponsorship.
    """

    edges: Optional[List[Optional[SponsorshipEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Sponsorship]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    totalRecurringMonthlyPriceInCents: Int
    totalRecurringMonthlyPriceInDollars: Int
    typename__: Optional[Literal['SponsorshipConnection']] = Field(
        'SponsorshipConnection', alias='__typename'
    )


class SponsorshipEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Sponsorship] = None
    typename__: Optional[Literal['SponsorshipEdge']] = Field(
        'SponsorshipEdge', alias='__typename'
    )


class SponsorshipNewsletter(Node):
    """
    An update sent to sponsors of a user or organization on GitHub Sponsors.
    """

    author: Optional[User] = None
    body: String
    createdAt: DateTime
    id: ID
    isPublished: Boolean
    sponsorable: Sponsorable
    subject: String
    updatedAt: DateTime
    typename__: Optional[Literal['SponsorshipNewsletter']] = Field(
        'SponsorshipNewsletter', alias='__typename'
    )


class SponsorshipNewsletterConnection(BaseModel):
    """
    The connection type for SponsorshipNewsletter.
    """

    edges: Optional[List[Optional[SponsorshipNewsletterEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[SponsorshipNewsletter]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SponsorshipNewsletterConnection']] = Field(
        'SponsorshipNewsletterConnection', alias='__typename'
    )


class SponsorshipNewsletterEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[SponsorshipNewsletter] = None
    typename__: Optional[Literal['SponsorshipNewsletterEdge']] = Field(
        'SponsorshipNewsletterEdge', alias='__typename'
    )


class SshSignature(GitSignature):
    """
    Represents an SSH signature on a Commit or Tag.
    """

    email: String
    isValid: Boolean
    keyFingerprint: Optional[String] = None
    payload: String
    signature: String
    signer: Optional[User] = None
    state: GitSignatureState
    wasSignedByGitHub: Boolean
    typename__: Optional[Literal['SshSignature']] = Field(
        'SshSignature', alias='__typename'
    )


class StargazerConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[StargazerEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['StargazerConnection']] = Field(
        'StargazerConnection', alias='__typename'
    )


class StargazerEdge(BaseModel):
    """
    Represents a user that's starred a repository.
    """

    cursor: String
    node: User
    starredAt: DateTime
    typename__: Optional[Literal['StargazerEdge']] = Field(
        'StargazerEdge', alias='__typename'
    )


class StarredRepositoryConnection(BaseModel):
    """
    The connection type for Repository.
    """

    edges: Optional[List[Optional[StarredRepositoryEdge]]] = Field(default_factory=list)
    isOverLimit: Boolean
    nodes: Optional[List[Optional[Repository]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['StarredRepositoryConnection']] = Field(
        'StarredRepositoryConnection', alias='__typename'
    )


class StarredRepositoryEdge(BaseModel):
    """
    Represents a starred repository.
    """

    cursor: String
    node: Repository
    starredAt: DateTime
    typename__: Optional[Literal['StarredRepositoryEdge']] = Field(
        'StarredRepositoryEdge', alias='__typename'
    )


class StartOrganizationMigrationPayload(BaseModel):
    """
    Autogenerated return type of StartOrganizationMigration
    """

    clientMutationId: Optional[String] = None
    orgMigration: Optional[OrganizationMigration] = None
    typename__: Optional[Literal['StartOrganizationMigrationPayload']] = Field(
        'StartOrganizationMigrationPayload', alias='__typename'
    )


class StartRepositoryMigrationPayload(BaseModel):
    """
    Autogenerated return type of StartRepositoryMigration
    """

    clientMutationId: Optional[String] = None
    repositoryMigration: Optional[RepositoryMigration] = None
    typename__: Optional[Literal['StartRepositoryMigrationPayload']] = Field(
        'StartRepositoryMigrationPayload', alias='__typename'
    )


class Status(Node):
    """
    Represents a commit status.
    """

    combinedContexts: StatusCheckRollupContextConnection
    commit: Optional[Commit] = None
    context: Optional[StatusContext] = None
    contexts: List[StatusContext]
    id: ID
    state: StatusState
    typename__: Optional[Literal['Status']] = Field('Status', alias='__typename')


class StatusCheckConfiguration(BaseModel):
    """
    Required status check
    """

    context: String
    integrationId: Optional[Int] = None
    typename__: Optional[Literal['StatusCheckConfiguration']] = Field(
        'StatusCheckConfiguration', alias='__typename'
    )


class StatusCheckRollup(Node):
    """
    Represents the rollup for both the check runs and status for a commit.
    """

    commit: Optional[Commit] = None
    contexts: StatusCheckRollupContextConnection
    id: ID
    state: StatusState
    typename__: Optional[Literal['StatusCheckRollup']] = Field(
        'StatusCheckRollup', alias='__typename'
    )


class StatusCheckRollupContextConnection(BaseModel):
    """
    The connection type for StatusCheckRollupContext.
    """

    checkRunCount: Int
    checkRunCountsByState: Optional[List[CheckRunStateCount]] = Field(
        default_factory=list
    )
    edges: Optional[List[Optional[StatusCheckRollupContextEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[StatusCheckRollupContext]]] = Field(
        default_factory=list
    )
    pageInfo: PageInfo
    statusContextCount: Int
    statusContextCountsByState: Optional[List[StatusContextStateCount]] = Field(
        default_factory=list
    )
    totalCount: Int
    typename__: Optional[Literal['StatusCheckRollupContextConnection']] = Field(
        'StatusCheckRollupContextConnection', alias='__typename'
    )


class StatusCheckRollupContextEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[StatusCheckRollupContext] = None
    typename__: Optional[Literal['StatusCheckRollupContextEdge']] = Field(
        'StatusCheckRollupContextEdge', alias='__typename'
    )


class StatusContext(Node, RequirableByPullRequest):
    """
    Represents an individual commit status context
    """

    avatarUrl: Optional[URI] = None
    commit: Optional[Commit] = None
    context: String
    createdAt: DateTime
    creator: Optional[Actor] = None
    description: Optional[String] = None
    id: ID
    isRequired: Boolean
    state: StatusState
    targetUrl: Optional[URI] = None
    typename__: Optional[Literal['StatusContext']] = Field(
        'StatusContext', alias='__typename'
    )


class StatusContextStateCount(BaseModel):
    """
    Represents a count of the state of a status context.
    """

    count: Int
    state: StatusState
    typename__: Optional[Literal['StatusContextStateCount']] = Field(
        'StatusContextStateCount', alias='__typename'
    )


class StripeConnectAccount(BaseModel):
    """
    A Stripe Connect account for receiving sponsorship funds from GitHub Sponsors.
    """

    accountId: String
    billingCountryOrRegion: Optional[String] = None
    countryOrRegion: Optional[String] = None
    isActive: Boolean
    sponsorsListing: SponsorsListing
    stripeDashboardUrl: URI
    typename__: Optional[Literal['StripeConnectAccount']] = Field(
        'StripeConnectAccount', alias='__typename'
    )


class SubmitPullRequestReviewPayload(BaseModel):
    """
    Autogenerated return type of SubmitPullRequestReview
    """

    clientMutationId: Optional[String] = None
    pullRequestReview: Optional[PullRequestReview] = None
    typename__: Optional[Literal['SubmitPullRequestReviewPayload']] = Field(
        'SubmitPullRequestReviewPayload', alias='__typename'
    )


class Submodule(BaseModel):
    """
    A pointer to a repository at a specific revision embedded inside another repository.
    """

    branch: Optional[String] = None
    gitUrl: URI
    name: String
    nameRaw: Base64String
    path: String
    pathRaw: Base64String
    subprojectCommitOid: Optional[GitObjectID] = None
    typename__: Optional[Literal['Submodule']] = Field('Submodule', alias='__typename')


class SubmoduleConnection(BaseModel):
    """
    The connection type for Submodule.
    """

    edges: Optional[List[Optional[SubmoduleEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Submodule]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['SubmoduleConnection']] = Field(
        'SubmoduleConnection', alias='__typename'
    )


class SubmoduleEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Submodule] = None
    typename__: Optional[Literal['SubmoduleEdge']] = Field(
        'SubmoduleEdge', alias='__typename'
    )


class SubscribedEvent(Node):
    """
    Represents a 'subscribed' event on a given `Subscribable`.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    subscribable: Subscribable
    typename__: Optional[Literal['SubscribedEvent']] = Field(
        'SubscribedEvent', alias='__typename'
    )


class SuggestedReviewer(BaseModel):
    """
    A suggestion to review a pull request based on a user's commit history and review comments.
    """

    isAuthor: Boolean
    isCommenter: Boolean
    reviewer: User
    typename__: Optional[Literal['SuggestedReviewer']] = Field(
        'SuggestedReviewer', alias='__typename'
    )


class Tag(GitObject, Node):
    """
    Represents a Git tag.
    """

    abbreviatedOid: String
    commitResourcePath: URI
    commitUrl: URI
    id: ID
    message: Optional[String] = None
    name: String
    oid: GitObjectID
    repository: Repository
    tagger: Optional[GitActor] = None
    target: GitObject
    typename__: Optional[Literal['Tag']] = Field('Tag', alias='__typename')


class TagNamePatternParameters(BaseModel):
    """
    Parameters to be used for the tag_name_pattern rule
    """

    name: Optional[String] = None
    negate: Boolean
    operator: String
    pattern: String
    typename__: Optional[Literal['TagNamePatternParameters']] = Field(
        'TagNamePatternParameters', alias='__typename'
    )


class Team(MemberStatusable, Node, Subscribable):
    """
    A team of users in an organization.
    """

    ancestors: TeamConnection
    avatarUrl: Optional[URI] = None
    childTeams: TeamConnection
    combinedSlug: String
    createdAt: DateTime
    databaseId: Optional[Int] = None
    description: Optional[String] = None
    discussion: Optional[TeamDiscussion] = None
    discussions: TeamDiscussionConnection
    discussionsResourcePath: URI
    discussionsUrl: URI
    editTeamResourcePath: URI
    editTeamUrl: URI
    id: ID
    invitations: Optional[OrganizationInvitationConnection] = None
    memberStatuses: UserStatusConnection
    members: TeamMemberConnection
    membersResourcePath: URI
    membersUrl: URI
    name: String
    newTeamResourcePath: URI
    newTeamUrl: URI
    notificationSetting: TeamNotificationSetting
    organization: Organization
    parentTeam: Optional[Team] = None
    privacy: TeamPrivacy
    projectV2: Optional[ProjectV2] = None
    projectsV2: ProjectV2Connection
    repositories: TeamRepositoryConnection
    repositoriesResourcePath: URI
    repositoriesUrl: URI
    resourcePath: URI
    reviewRequestDelegationAlgorithm: Optional[TeamReviewAssignmentAlgorithm] = None
    reviewRequestDelegationEnabled: Boolean
    reviewRequestDelegationMemberCount: Optional[Int] = None
    reviewRequestDelegationNotifyTeam: Boolean
    slug: String
    teamsResourcePath: URI
    teamsUrl: URI
    updatedAt: DateTime
    url: URI
    viewerCanAdminister: Boolean
    viewerCanSubscribe: Boolean
    viewerSubscription: Optional[SubscriptionState] = None
    typename__: Optional[Literal['Team']] = Field('Team', alias='__typename')


class TeamAddMemberAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, TeamAuditEntryData
):
    """
    Audit log entry for a team.add_member event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    isLdapMapped: Optional[Boolean] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    team: Optional[Team] = None
    teamName: Optional[String] = None
    teamResourcePath: Optional[URI] = None
    teamUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['TeamAddMemberAuditEntry']] = Field(
        'TeamAddMemberAuditEntry', alias='__typename'
    )


class TeamAddRepositoryAuditEntry(
    AuditEntry,
    Node,
    OrganizationAuditEntryData,
    RepositoryAuditEntryData,
    TeamAuditEntryData,
):
    """
    Audit log entry for a team.add_repository event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    isLdapMapped: Optional[Boolean] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    team: Optional[Team] = None
    teamName: Optional[String] = None
    teamResourcePath: Optional[URI] = None
    teamUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['TeamAddRepositoryAuditEntry']] = Field(
        'TeamAddRepositoryAuditEntry', alias='__typename'
    )


class TeamChangeParentTeamAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, TeamAuditEntryData
):
    """
    Audit log entry for a team.change_parent_team event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    isLdapMapped: Optional[Boolean] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    parentTeam: Optional[Team] = None
    parentTeamName: Optional[String] = None
    parentTeamNameWas: Optional[String] = None
    parentTeamResourcePath: Optional[URI] = None
    parentTeamUrl: Optional[URI] = None
    parentTeamWas: Optional[Team] = None
    parentTeamWasResourcePath: Optional[URI] = None
    parentTeamWasUrl: Optional[URI] = None
    team: Optional[Team] = None
    teamName: Optional[String] = None
    teamResourcePath: Optional[URI] = None
    teamUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['TeamChangeParentTeamAuditEntry']] = Field(
        'TeamChangeParentTeamAuditEntry', alias='__typename'
    )


class TeamConnection(BaseModel):
    """
    The connection type for Team.
    """

    edges: Optional[List[Optional[TeamEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Team]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['TeamConnection']] = Field(
        'TeamConnection', alias='__typename'
    )


class TeamDiscussion(
    Comment,
    Deletable,
    Node,
    Reactable,
    Subscribable,
    UniformResourceLocatable,
    Updatable,
    UpdatableComment,
):
    """
    A team discussion.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    bodyVersion: String
    comments: TeamDiscussionCommentConnection
    commentsResourcePath: URI
    commentsUrl: URI
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    editor: Optional[Actor] = None
    id: ID
    includesCreatedEdit: Boolean
    isPinned: Boolean
    isPrivate: Boolean
    lastEditedAt: Optional[DateTime] = None
    number: Int
    publishedAt: Optional[DateTime] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    resourcePath: URI
    team: Team
    title: String
    updatedAt: DateTime
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanDelete: Boolean
    viewerCanPin: Boolean
    viewerCanReact: Boolean
    viewerCanSubscribe: Boolean
    viewerCanUpdate: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    viewerSubscription: Optional[SubscriptionState] = None
    typename__: Optional[Literal['TeamDiscussion']] = Field(
        'TeamDiscussion', alias='__typename'
    )


class TeamDiscussionComment(
    Comment,
    Deletable,
    Node,
    Reactable,
    UniformResourceLocatable,
    Updatable,
    UpdatableComment,
):
    """
    A comment on a team discussion.
    """

    author: Optional[Actor] = None
    authorAssociation: CommentAuthorAssociation
    body: String
    bodyHTML: HTML
    bodyText: String
    bodyVersion: String
    createdAt: DateTime
    createdViaEmail: Boolean
    databaseId: Optional[Int] = None
    discussion: TeamDiscussion
    editor: Optional[Actor] = None
    id: ID
    includesCreatedEdit: Boolean
    lastEditedAt: Optional[DateTime] = None
    number: Int
    publishedAt: Optional[DateTime] = None
    reactionGroups: Optional[List[ReactionGroup]] = Field(default_factory=list)
    reactions: ReactionConnection
    resourcePath: URI
    updatedAt: DateTime
    url: URI
    userContentEdits: Optional[UserContentEditConnection] = None
    viewerCanDelete: Boolean
    viewerCanReact: Boolean
    viewerCanUpdate: Boolean
    viewerCannotUpdateReasons: List[CommentCannotUpdateReason]
    viewerDidAuthor: Boolean
    typename__: Optional[Literal['TeamDiscussionComment']] = Field(
        'TeamDiscussionComment', alias='__typename'
    )


class TeamDiscussionCommentConnection(BaseModel):
    """
    The connection type for TeamDiscussionComment.
    """

    edges: Optional[List[Optional[TeamDiscussionCommentEdge]]] = Field(
        default_factory=list
    )
    nodes: Optional[List[Optional[TeamDiscussionComment]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['TeamDiscussionCommentConnection']] = Field(
        'TeamDiscussionCommentConnection', alias='__typename'
    )


class TeamDiscussionCommentEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[TeamDiscussionComment] = None
    typename__: Optional[Literal['TeamDiscussionCommentEdge']] = Field(
        'TeamDiscussionCommentEdge', alias='__typename'
    )


class TeamDiscussionConnection(BaseModel):
    """
    The connection type for TeamDiscussion.
    """

    edges: Optional[List[Optional[TeamDiscussionEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[TeamDiscussion]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['TeamDiscussionConnection']] = Field(
        'TeamDiscussionConnection', alias='__typename'
    )


class TeamDiscussionEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[TeamDiscussion] = None
    typename__: Optional[Literal['TeamDiscussionEdge']] = Field(
        'TeamDiscussionEdge', alias='__typename'
    )


class TeamEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[Team] = None
    typename__: Optional[Literal['TeamEdge']] = Field('TeamEdge', alias='__typename')


class TeamMemberConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[TeamMemberEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['TeamMemberConnection']] = Field(
        'TeamMemberConnection', alias='__typename'
    )


class TeamMemberEdge(BaseModel):
    """
    Represents a user who is a member of a team.
    """

    cursor: String
    memberAccessResourcePath: URI
    memberAccessUrl: URI
    node: User
    role: TeamMemberRole
    typename__: Optional[Literal['TeamMemberEdge']] = Field(
        'TeamMemberEdge', alias='__typename'
    )


class TeamRemoveMemberAuditEntry(
    AuditEntry, Node, OrganizationAuditEntryData, TeamAuditEntryData
):
    """
    Audit log entry for a team.remove_member event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    isLdapMapped: Optional[Boolean] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    team: Optional[Team] = None
    teamName: Optional[String] = None
    teamResourcePath: Optional[URI] = None
    teamUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['TeamRemoveMemberAuditEntry']] = Field(
        'TeamRemoveMemberAuditEntry', alias='__typename'
    )


class TeamRemoveRepositoryAuditEntry(
    AuditEntry,
    Node,
    OrganizationAuditEntryData,
    RepositoryAuditEntryData,
    TeamAuditEntryData,
):
    """
    Audit log entry for a team.remove_repository event.
    """

    action: String
    actor: Optional[AuditEntryActor] = None
    actorIp: Optional[String] = None
    actorLocation: Optional[ActorLocation] = None
    actorLogin: Optional[String] = None
    actorResourcePath: Optional[URI] = None
    actorUrl: Optional[URI] = None
    createdAt: PreciseDateTime
    id: ID
    isLdapMapped: Optional[Boolean] = None
    operationType: Optional[OperationType] = None
    organization: Optional[Organization] = None
    organizationName: Optional[String] = None
    organizationResourcePath: Optional[URI] = None
    organizationUrl: Optional[URI] = None
    repository: Optional[Repository] = None
    repositoryName: Optional[String] = None
    repositoryResourcePath: Optional[URI] = None
    repositoryUrl: Optional[URI] = None
    team: Optional[Team] = None
    teamName: Optional[String] = None
    teamResourcePath: Optional[URI] = None
    teamUrl: Optional[URI] = None
    user: Optional[User] = None
    userLogin: Optional[String] = None
    userResourcePath: Optional[URI] = None
    userUrl: Optional[URI] = None
    typename__: Optional[Literal['TeamRemoveRepositoryAuditEntry']] = Field(
        'TeamRemoveRepositoryAuditEntry', alias='__typename'
    )


class TeamRepositoryConnection(BaseModel):
    """
    The connection type for Repository.
    """

    edges: Optional[List[Optional[TeamRepositoryEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[Repository]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['TeamRepositoryConnection']] = Field(
        'TeamRepositoryConnection', alias='__typename'
    )


class TeamRepositoryEdge(BaseModel):
    """
    Represents a team repository.
    """

    cursor: String
    node: Repository
    permission: RepositoryPermission
    typename__: Optional[Literal['TeamRepositoryEdge']] = Field(
        'TeamRepositoryEdge', alias='__typename'
    )


class TextMatch(BaseModel):
    """
    A text match within a search result.
    """

    fragment: String
    highlights: List[TextMatchHighlight]
    property: String
    typename__: Optional[Literal['TextMatch']] = Field('TextMatch', alias='__typename')


class TextMatchHighlight(BaseModel):
    """
    Represents a single highlight in a search result match.
    """

    beginIndice: Int
    endIndice: Int
    text: String
    typename__: Optional[Literal['TextMatchHighlight']] = Field(
        'TextMatchHighlight', alias='__typename'
    )


class Topic(Node, Starrable):
    """
    A topic aggregates entities that are related to a subject.
    """

    id: ID
    name: String
    relatedTopics: List[Topic]
    repositories: RepositoryConnection
    stargazerCount: Int
    stargazers: StargazerConnection
    viewerHasStarred: Boolean
    typename__: Optional[Literal['Topic']] = Field('Topic', alias='__typename')


class TransferEnterpriseOrganizationPayload(BaseModel):
    """
    Autogenerated return type of TransferEnterpriseOrganization
    """

    clientMutationId: Optional[String] = None
    organization: Optional[Organization] = None
    typename__: Optional[Literal['TransferEnterpriseOrganizationPayload']] = Field(
        'TransferEnterpriseOrganizationPayload', alias='__typename'
    )


class TransferIssuePayload(BaseModel):
    """
    Autogenerated return type of TransferIssue
    """

    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    typename__: Optional[Literal['TransferIssuePayload']] = Field(
        'TransferIssuePayload', alias='__typename'
    )


class TransferredEvent(Node):
    """
    Represents a 'transferred' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    fromRepository: Optional[Repository] = None
    id: ID
    issue: Issue
    typename__: Optional[Literal['TransferredEvent']] = Field(
        'TransferredEvent', alias='__typename'
    )


class Tree(GitObject, Node):
    """
    Represents a Git tree.
    """

    abbreviatedOid: String
    commitResourcePath: URI
    commitUrl: URI
    entries: Optional[List[TreeEntry]] = Field(default_factory=list)
    id: ID
    oid: GitObjectID
    repository: Repository
    typename__: Optional[Literal['Tree']] = Field('Tree', alias='__typename')


class TreeEntry(BaseModel):
    """
    Represents a Git tree entry.
    """

    extension: Optional[String] = None
    isGenerated: Boolean
    language: Optional[Language] = None
    lineCount: Optional[Int] = None
    mode: Int
    name: String
    nameRaw: Base64String
    object: Optional[GitObject] = None
    oid: GitObjectID
    path: Optional[String] = None
    pathRaw: Optional[Base64String] = None
    repository: Repository
    size: Int
    submodule: Optional[Submodule] = None
    type: String
    typename__: Optional[Literal['TreeEntry']] = Field('TreeEntry', alias='__typename')


class UnarchiveProjectV2ItemPayload(BaseModel):
    """
    Autogenerated return type of UnarchiveProjectV2Item
    """

    clientMutationId: Optional[String] = None
    item: Optional[ProjectV2Item] = None
    typename__: Optional[Literal['UnarchiveProjectV2ItemPayload']] = Field(
        'UnarchiveProjectV2ItemPayload', alias='__typename'
    )


class UnarchiveRepositoryPayload(BaseModel):
    """
    Autogenerated return type of UnarchiveRepository
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['UnarchiveRepositoryPayload']] = Field(
        'UnarchiveRepositoryPayload', alias='__typename'
    )


class UnassignedEvent(Node):
    """
    Represents an 'unassigned' event on any assignable object.
    """

    actor: Optional[Actor] = None
    assignable: Assignable
    assignee: Optional[Assignee] = None
    createdAt: DateTime
    id: ID
    user: Optional[User] = None
    typename__: Optional[Literal['UnassignedEvent']] = Field(
        'UnassignedEvent', alias='__typename'
    )


class UnfollowOrganizationPayload(BaseModel):
    """
    Autogenerated return type of UnfollowOrganization
    """

    clientMutationId: Optional[String] = None
    organization: Optional[Organization] = None
    typename__: Optional[Literal['UnfollowOrganizationPayload']] = Field(
        'UnfollowOrganizationPayload', alias='__typename'
    )


class UnfollowUserPayload(BaseModel):
    """
    Autogenerated return type of UnfollowUser
    """

    clientMutationId: Optional[String] = None
    user: Optional[User] = None
    typename__: Optional[Literal['UnfollowUserPayload']] = Field(
        'UnfollowUserPayload', alias='__typename'
    )


class UnknownSignature(GitSignature):
    """
    Represents an unknown signature on a Commit or Tag.
    """

    email: String
    isValid: Boolean
    payload: String
    signature: String
    signer: Optional[User] = None
    state: GitSignatureState
    wasSignedByGitHub: Boolean
    typename__: Optional[Literal['UnknownSignature']] = Field(
        'UnknownSignature', alias='__typename'
    )


class UnlabeledEvent(Node):
    """
    Represents an 'unlabeled' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    label: Label
    labelable: Labelable
    typename__: Optional[Literal['UnlabeledEvent']] = Field(
        'UnlabeledEvent', alias='__typename'
    )


class UnlinkProjectV2FromRepositoryPayload(BaseModel):
    """
    Autogenerated return type of UnlinkProjectV2FromRepository
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['UnlinkProjectV2FromRepositoryPayload']] = Field(
        'UnlinkProjectV2FromRepositoryPayload', alias='__typename'
    )


class UnlinkProjectV2FromTeamPayload(BaseModel):
    """
    Autogenerated return type of UnlinkProjectV2FromTeam
    """

    clientMutationId: Optional[String] = None
    team: Optional[Team] = None
    typename__: Optional[Literal['UnlinkProjectV2FromTeamPayload']] = Field(
        'UnlinkProjectV2FromTeamPayload', alias='__typename'
    )


class UnlinkRepositoryFromProjectPayload(BaseModel):
    """
    Autogenerated return type of UnlinkRepositoryFromProject
    """

    clientMutationId: Optional[String] = None
    project: Optional[Project] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['UnlinkRepositoryFromProjectPayload']] = Field(
        'UnlinkRepositoryFromProjectPayload', alias='__typename'
    )


class UnlockLockablePayload(BaseModel):
    """
    Autogenerated return type of UnlockLockable
    """

    actor: Optional[Actor] = None
    clientMutationId: Optional[String] = None
    unlockedRecord: Optional[Lockable] = None
    typename__: Optional[Literal['UnlockLockablePayload']] = Field(
        'UnlockLockablePayload', alias='__typename'
    )


class UnlockedEvent(Node):
    """
    Represents an 'unlocked' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    lockable: Lockable
    typename__: Optional[Literal['UnlockedEvent']] = Field(
        'UnlockedEvent', alias='__typename'
    )


class UnmarkDiscussionCommentAsAnswerPayload(BaseModel):
    """
    Autogenerated return type of UnmarkDiscussionCommentAsAnswer
    """

    clientMutationId: Optional[String] = None
    discussion: Optional[Discussion] = None
    typename__: Optional[Literal['UnmarkDiscussionCommentAsAnswerPayload']] = Field(
        'UnmarkDiscussionCommentAsAnswerPayload', alias='__typename'
    )


class UnmarkFileAsViewedPayload(BaseModel):
    """
    Autogenerated return type of UnmarkFileAsViewed
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['UnmarkFileAsViewedPayload']] = Field(
        'UnmarkFileAsViewedPayload', alias='__typename'
    )


class UnmarkIssueAsDuplicatePayload(BaseModel):
    """
    Autogenerated return type of UnmarkIssueAsDuplicate
    """

    clientMutationId: Optional[String] = None
    duplicate: Optional[IssueOrPullRequest] = None
    typename__: Optional[Literal['UnmarkIssueAsDuplicatePayload']] = Field(
        'UnmarkIssueAsDuplicatePayload', alias='__typename'
    )


class UnmarkProjectV2AsTemplatePayload(BaseModel):
    """
    Autogenerated return type of UnmarkProjectV2AsTemplate
    """

    clientMutationId: Optional[String] = None
    projectV2: Optional[ProjectV2] = None
    typename__: Optional[Literal['UnmarkProjectV2AsTemplatePayload']] = Field(
        'UnmarkProjectV2AsTemplatePayload', alias='__typename'
    )


class UnmarkedAsDuplicateEvent(Node):
    """
    Represents an 'unmarked_as_duplicate' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    canonical: Optional[IssueOrPullRequest] = None
    createdAt: DateTime
    duplicate: Optional[IssueOrPullRequest] = None
    id: ID
    isCrossRepository: Boolean
    typename__: Optional[Literal['UnmarkedAsDuplicateEvent']] = Field(
        'UnmarkedAsDuplicateEvent', alias='__typename'
    )


class UnminimizeCommentPayload(BaseModel):
    """
    Autogenerated return type of UnminimizeComment
    """

    clientMutationId: Optional[String] = None
    unminimizedComment: Optional[Minimizable] = None
    typename__: Optional[Literal['UnminimizeCommentPayload']] = Field(
        'UnminimizeCommentPayload', alias='__typename'
    )


class UnpinIssuePayload(BaseModel):
    """
    Autogenerated return type of UnpinIssue
    """

    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    typename__: Optional[Literal['UnpinIssuePayload']] = Field(
        'UnpinIssuePayload', alias='__typename'
    )


class UnpinnedEvent(Node):
    """
    Represents an 'unpinned' event on a given issue or pull request.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    issue: Issue
    typename__: Optional[Literal['UnpinnedEvent']] = Field(
        'UnpinnedEvent', alias='__typename'
    )


class UnresolveReviewThreadPayload(BaseModel):
    """
    Autogenerated return type of UnresolveReviewThread
    """

    clientMutationId: Optional[String] = None
    thread: Optional[PullRequestReviewThread] = None
    typename__: Optional[Literal['UnresolveReviewThreadPayload']] = Field(
        'UnresolveReviewThreadPayload', alias='__typename'
    )


class UnsubscribedEvent(Node):
    """
    Represents an 'unsubscribed' event on a given `Subscribable`.
    """

    actor: Optional[Actor] = None
    createdAt: DateTime
    id: ID
    subscribable: Subscribable
    typename__: Optional[Literal['UnsubscribedEvent']] = Field(
        'UnsubscribedEvent', alias='__typename'
    )


class UpdateBranchProtectionRulePayload(BaseModel):
    """
    Autogenerated return type of UpdateBranchProtectionRule
    """

    branchProtectionRule: Optional[BranchProtectionRule] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['UpdateBranchProtectionRulePayload']] = Field(
        'UpdateBranchProtectionRulePayload', alias='__typename'
    )


class UpdateCheckRunPayload(BaseModel):
    """
    Autogenerated return type of UpdateCheckRun
    """

    checkRun: Optional[CheckRun] = None
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['UpdateCheckRunPayload']] = Field(
        'UpdateCheckRunPayload', alias='__typename'
    )


class UpdateCheckSuitePreferencesPayload(BaseModel):
    """
    Autogenerated return type of UpdateCheckSuitePreferences
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['UpdateCheckSuitePreferencesPayload']] = Field(
        'UpdateCheckSuitePreferencesPayload', alias='__typename'
    )


class UpdateDiscussionCommentPayload(BaseModel):
    """
    Autogenerated return type of UpdateDiscussionComment
    """

    clientMutationId: Optional[String] = None
    comment: Optional[DiscussionComment] = None
    typename__: Optional[Literal['UpdateDiscussionCommentPayload']] = Field(
        'UpdateDiscussionCommentPayload', alias='__typename'
    )


class UpdateDiscussionPayload(BaseModel):
    """
    Autogenerated return type of UpdateDiscussion
    """

    clientMutationId: Optional[String] = None
    discussion: Optional[Discussion] = None
    typename__: Optional[Literal['UpdateDiscussionPayload']] = Field(
        'UpdateDiscussionPayload', alias='__typename'
    )


class UpdateEnterpriseAdministratorRolePayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseAdministratorRole
    """

    clientMutationId: Optional[String] = None
    message: Optional[String] = None
    typename__: Optional[Literal['UpdateEnterpriseAdministratorRolePayload']] = Field(
        'UpdateEnterpriseAdministratorRolePayload', alias='__typename'
    )


class UpdateEnterpriseAllowPrivateRepositoryForkingSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseAllowPrivateRepositoryForkingSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseAllowPrivateRepositoryForkingSettingPayload']
    ] = Field(
        'UpdateEnterpriseAllowPrivateRepositoryForkingSettingPayload',
        alias='__typename',
    )


class UpdateEnterpriseDefaultRepositoryPermissionSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseDefaultRepositoryPermissionSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseDefaultRepositoryPermissionSettingPayload']
    ] = Field(
        'UpdateEnterpriseDefaultRepositoryPermissionSettingPayload', alias='__typename'
    )


class UpdateEnterpriseMembersCanChangeRepositoryVisibilitySettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseMembersCanChangeRepositoryVisibilitySetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanChangeRepositoryVisibilitySettingPayload']
    ] = Field(
        'UpdateEnterpriseMembersCanChangeRepositoryVisibilitySettingPayload',
        alias='__typename',
    )


class UpdateEnterpriseMembersCanCreateRepositoriesSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseMembersCanCreateRepositoriesSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanCreateRepositoriesSettingPayload']
    ] = Field(
        'UpdateEnterpriseMembersCanCreateRepositoriesSettingPayload', alias='__typename'
    )


class UpdateEnterpriseMembersCanDeleteIssuesSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseMembersCanDeleteIssuesSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanDeleteIssuesSettingPayload']
    ] = Field(
        'UpdateEnterpriseMembersCanDeleteIssuesSettingPayload', alias='__typename'
    )


class UpdateEnterpriseMembersCanDeleteRepositoriesSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseMembersCanDeleteRepositoriesSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanDeleteRepositoriesSettingPayload']
    ] = Field(
        'UpdateEnterpriseMembersCanDeleteRepositoriesSettingPayload', alias='__typename'
    )


class UpdateEnterpriseMembersCanInviteCollaboratorsSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseMembersCanInviteCollaboratorsSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanInviteCollaboratorsSettingPayload']
    ] = Field(
        'UpdateEnterpriseMembersCanInviteCollaboratorsSettingPayload',
        alias='__typename',
    )


class UpdateEnterpriseMembersCanMakePurchasesSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseMembersCanMakePurchasesSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanMakePurchasesSettingPayload']
    ] = Field(
        'UpdateEnterpriseMembersCanMakePurchasesSettingPayload', alias='__typename'
    )


class UpdateEnterpriseMembersCanUpdateProtectedBranchesSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseMembersCanUpdateProtectedBranchesSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanUpdateProtectedBranchesSettingPayload']
    ] = Field(
        'UpdateEnterpriseMembersCanUpdateProtectedBranchesSettingPayload',
        alias='__typename',
    )


class UpdateEnterpriseMembersCanViewDependencyInsightsSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseMembersCanViewDependencyInsightsSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanViewDependencyInsightsSettingPayload']
    ] = Field(
        'UpdateEnterpriseMembersCanViewDependencyInsightsSettingPayload',
        alias='__typename',
    )


class UpdateEnterpriseOrganizationProjectsSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseOrganizationProjectsSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseOrganizationProjectsSettingPayload']
    ] = Field('UpdateEnterpriseOrganizationProjectsSettingPayload', alias='__typename')


class UpdateEnterpriseOwnerOrganizationRolePayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseOwnerOrganizationRole
    """

    clientMutationId: Optional[String] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseOwnerOrganizationRolePayload']
    ] = Field('UpdateEnterpriseOwnerOrganizationRolePayload', alias='__typename')


class UpdateEnterpriseProfilePayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseProfile
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    typename__: Optional[Literal['UpdateEnterpriseProfilePayload']] = Field(
        'UpdateEnterpriseProfilePayload', alias='__typename'
    )


class UpdateEnterpriseRepositoryProjectsSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseRepositoryProjectsSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseRepositoryProjectsSettingPayload']
    ] = Field('UpdateEnterpriseRepositoryProjectsSettingPayload', alias='__typename')


class UpdateEnterpriseTeamDiscussionsSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseTeamDiscussionsSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseTeamDiscussionsSettingPayload']
    ] = Field('UpdateEnterpriseTeamDiscussionsSettingPayload', alias='__typename')


class UpdateEnterpriseTwoFactorAuthenticationRequiredSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnterpriseTwoFactorAuthenticationRequiredSetting
    """

    clientMutationId: Optional[String] = None
    enterprise: Optional[Enterprise] = None
    message: Optional[String] = None
    typename__: Optional[
        Literal['UpdateEnterpriseTwoFactorAuthenticationRequiredSettingPayload']
    ] = Field(
        'UpdateEnterpriseTwoFactorAuthenticationRequiredSettingPayload',
        alias='__typename',
    )


class UpdateEnvironmentPayload(BaseModel):
    """
    Autogenerated return type of UpdateEnvironment
    """

    clientMutationId: Optional[String] = None
    environment: Optional[Environment] = None
    typename__: Optional[Literal['UpdateEnvironmentPayload']] = Field(
        'UpdateEnvironmentPayload', alias='__typename'
    )


class UpdateIpAllowListEnabledSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateIpAllowListEnabledSetting
    """

    clientMutationId: Optional[String] = None
    owner: Optional[IpAllowListOwner] = None
    typename__: Optional[Literal['UpdateIpAllowListEnabledSettingPayload']] = Field(
        'UpdateIpAllowListEnabledSettingPayload', alias='__typename'
    )


class UpdateIpAllowListEntryPayload(BaseModel):
    """
    Autogenerated return type of UpdateIpAllowListEntry
    """

    clientMutationId: Optional[String] = None
    ipAllowListEntry: Optional[IpAllowListEntry] = None
    typename__: Optional[Literal['UpdateIpAllowListEntryPayload']] = Field(
        'UpdateIpAllowListEntryPayload', alias='__typename'
    )


class UpdateIpAllowListForInstalledAppsEnabledSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateIpAllowListForInstalledAppsEnabledSetting
    """

    clientMutationId: Optional[String] = None
    owner: Optional[IpAllowListOwner] = None
    typename__: Optional[
        Literal['UpdateIpAllowListForInstalledAppsEnabledSettingPayload']
    ] = Field(
        'UpdateIpAllowListForInstalledAppsEnabledSettingPayload', alias='__typename'
    )


class UpdateIssueCommentPayload(BaseModel):
    """
    Autogenerated return type of UpdateIssueComment
    """

    clientMutationId: Optional[String] = None
    issueComment: Optional[IssueComment] = None
    typename__: Optional[Literal['UpdateIssueCommentPayload']] = Field(
        'UpdateIssueCommentPayload', alias='__typename'
    )


class UpdateIssuePayload(BaseModel):
    """
    Autogenerated return type of UpdateIssue
    """

    actor: Optional[Actor] = None
    clientMutationId: Optional[String] = None
    issue: Optional[Issue] = None
    typename__: Optional[Literal['UpdateIssuePayload']] = Field(
        'UpdateIssuePayload', alias='__typename'
    )


class UpdateLabelPayload(BaseModel):
    """
    Autogenerated return type of UpdateLabel
    """

    clientMutationId: Optional[String] = None
    label: Optional[Label] = None
    typename__: Optional[Literal['UpdateLabelPayload']] = Field(
        'UpdateLabelPayload', alias='__typename'
    )


class UpdateNotificationRestrictionSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateNotificationRestrictionSetting
    """

    clientMutationId: Optional[String] = None
    owner: Optional[VerifiableDomainOwner] = None
    typename__: Optional[
        Literal['UpdateNotificationRestrictionSettingPayload']
    ] = Field('UpdateNotificationRestrictionSettingPayload', alias='__typename')


class UpdateOrganizationAllowPrivateRepositoryForkingSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateOrganizationAllowPrivateRepositoryForkingSetting
    """

    clientMutationId: Optional[String] = None
    message: Optional[String] = None
    organization: Optional[Organization] = None
    typename__: Optional[
        Literal['UpdateOrganizationAllowPrivateRepositoryForkingSettingPayload']
    ] = Field(
        'UpdateOrganizationAllowPrivateRepositoryForkingSettingPayload',
        alias='__typename',
    )


class UpdateOrganizationWebCommitSignoffSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateOrganizationWebCommitSignoffSetting
    """

    clientMutationId: Optional[String] = None
    message: Optional[String] = None
    organization: Optional[Organization] = None
    typename__: Optional[
        Literal['UpdateOrganizationWebCommitSignoffSettingPayload']
    ] = Field('UpdateOrganizationWebCommitSignoffSettingPayload', alias='__typename')


class UpdateParameters(BaseModel):
    """
    Only allow users with bypass permission to update matching refs.
    """

    updateAllowsFetchAndMerge: Boolean
    typename__: Optional[Literal['UpdateParameters']] = Field(
        'UpdateParameters', alias='__typename'
    )


class UpdatePatreonSponsorabilityPayload(BaseModel):
    """
    Autogenerated return type of UpdatePatreonSponsorability
    """

    clientMutationId: Optional[String] = None
    sponsorsListing: Optional[SponsorsListing] = None
    typename__: Optional[Literal['UpdatePatreonSponsorabilityPayload']] = Field(
        'UpdatePatreonSponsorabilityPayload', alias='__typename'
    )


class UpdateProjectCardPayload(BaseModel):
    """
    Autogenerated return type of UpdateProjectCard
    """

    clientMutationId: Optional[String] = None
    projectCard: Optional[ProjectCard] = None
    typename__: Optional[Literal['UpdateProjectCardPayload']] = Field(
        'UpdateProjectCardPayload', alias='__typename'
    )


class UpdateProjectColumnPayload(BaseModel):
    """
    Autogenerated return type of UpdateProjectColumn
    """

    clientMutationId: Optional[String] = None
    projectColumn: Optional[ProjectColumn] = None
    typename__: Optional[Literal['UpdateProjectColumnPayload']] = Field(
        'UpdateProjectColumnPayload', alias='__typename'
    )


class UpdateProjectPayload(BaseModel):
    """
    Autogenerated return type of UpdateProject
    """

    clientMutationId: Optional[String] = None
    project: Optional[Project] = None
    typename__: Optional[Literal['UpdateProjectPayload']] = Field(
        'UpdateProjectPayload', alias='__typename'
    )


class UpdateProjectV2CollaboratorsPayload(BaseModel):
    """
    Autogenerated return type of UpdateProjectV2Collaborators
    """

    clientMutationId: Optional[String] = None
    collaborators: Optional[ProjectV2ActorConnection] = None
    typename__: Optional[Literal['UpdateProjectV2CollaboratorsPayload']] = Field(
        'UpdateProjectV2CollaboratorsPayload', alias='__typename'
    )


class UpdateProjectV2DraftIssuePayload(BaseModel):
    """
    Autogenerated return type of UpdateProjectV2DraftIssue
    """

    clientMutationId: Optional[String] = None
    draftIssue: Optional[DraftIssue] = None
    typename__: Optional[Literal['UpdateProjectV2DraftIssuePayload']] = Field(
        'UpdateProjectV2DraftIssuePayload', alias='__typename'
    )


class UpdateProjectV2ItemFieldValuePayload(BaseModel):
    """
    Autogenerated return type of UpdateProjectV2ItemFieldValue
    """

    clientMutationId: Optional[String] = None
    projectV2Item: Optional[ProjectV2Item] = None
    typename__: Optional[Literal['UpdateProjectV2ItemFieldValuePayload']] = Field(
        'UpdateProjectV2ItemFieldValuePayload', alias='__typename'
    )


class UpdateProjectV2ItemPositionPayload(BaseModel):
    """
    Autogenerated return type of UpdateProjectV2ItemPosition
    """

    clientMutationId: Optional[String] = None
    items: Optional[ProjectV2ItemConnection] = None
    typename__: Optional[Literal['UpdateProjectV2ItemPositionPayload']] = Field(
        'UpdateProjectV2ItemPositionPayload', alias='__typename'
    )


class UpdateProjectV2Payload(BaseModel):
    """
    Autogenerated return type of UpdateProjectV2
    """

    clientMutationId: Optional[String] = None
    projectV2: Optional[ProjectV2] = None
    typename__: Optional[Literal['UpdateProjectV2Payload']] = Field(
        'UpdateProjectV2Payload', alias='__typename'
    )


class UpdatePullRequestBranchPayload(BaseModel):
    """
    Autogenerated return type of UpdatePullRequestBranch
    """

    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['UpdatePullRequestBranchPayload']] = Field(
        'UpdatePullRequestBranchPayload', alias='__typename'
    )


class UpdatePullRequestPayload(BaseModel):
    """
    Autogenerated return type of UpdatePullRequest
    """

    actor: Optional[Actor] = None
    clientMutationId: Optional[String] = None
    pullRequest: Optional[PullRequest] = None
    typename__: Optional[Literal['UpdatePullRequestPayload']] = Field(
        'UpdatePullRequestPayload', alias='__typename'
    )


class UpdatePullRequestReviewCommentPayload(BaseModel):
    """
    Autogenerated return type of UpdatePullRequestReviewComment
    """

    clientMutationId: Optional[String] = None
    pullRequestReviewComment: Optional[PullRequestReviewComment] = None
    typename__: Optional[Literal['UpdatePullRequestReviewCommentPayload']] = Field(
        'UpdatePullRequestReviewCommentPayload', alias='__typename'
    )


class UpdatePullRequestReviewPayload(BaseModel):
    """
    Autogenerated return type of UpdatePullRequestReview
    """

    clientMutationId: Optional[String] = None
    pullRequestReview: Optional[PullRequestReview] = None
    typename__: Optional[Literal['UpdatePullRequestReviewPayload']] = Field(
        'UpdatePullRequestReviewPayload', alias='__typename'
    )


class UpdateRefPayload(BaseModel):
    """
    Autogenerated return type of UpdateRef
    """

    clientMutationId: Optional[String] = None
    ref: Optional[Ref] = None
    typename__: Optional[Literal['UpdateRefPayload']] = Field(
        'UpdateRefPayload', alias='__typename'
    )


class UpdateRefsPayload(BaseModel):
    """
    Autogenerated return type of UpdateRefs
    """

    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['UpdateRefsPayload']] = Field(
        'UpdateRefsPayload', alias='__typename'
    )


class UpdateRepositoryPayload(BaseModel):
    """
    Autogenerated return type of UpdateRepository
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[Literal['UpdateRepositoryPayload']] = Field(
        'UpdateRepositoryPayload', alias='__typename'
    )


class UpdateRepositoryRulesetPayload(BaseModel):
    """
    Autogenerated return type of UpdateRepositoryRuleset
    """

    clientMutationId: Optional[String] = None
    ruleset: Optional[RepositoryRuleset] = None
    typename__: Optional[Literal['UpdateRepositoryRulesetPayload']] = Field(
        'UpdateRepositoryRulesetPayload', alias='__typename'
    )


class UpdateRepositoryWebCommitSignoffSettingPayload(BaseModel):
    """
    Autogenerated return type of UpdateRepositoryWebCommitSignoffSetting
    """

    clientMutationId: Optional[String] = None
    message: Optional[String] = None
    repository: Optional[Repository] = None
    typename__: Optional[
        Literal['UpdateRepositoryWebCommitSignoffSettingPayload']
    ] = Field('UpdateRepositoryWebCommitSignoffSettingPayload', alias='__typename')


class UpdateSponsorshipPreferencesPayload(BaseModel):
    """
    Autogenerated return type of UpdateSponsorshipPreferences
    """

    clientMutationId: Optional[String] = None
    sponsorship: Optional[Sponsorship] = None
    typename__: Optional[Literal['UpdateSponsorshipPreferencesPayload']] = Field(
        'UpdateSponsorshipPreferencesPayload', alias='__typename'
    )


class UpdateSubscriptionPayload(BaseModel):
    """
    Autogenerated return type of UpdateSubscription
    """

    clientMutationId: Optional[String] = None
    subscribable: Optional[Subscribable] = None
    typename__: Optional[Literal['UpdateSubscriptionPayload']] = Field(
        'UpdateSubscriptionPayload', alias='__typename'
    )


class UpdateTeamDiscussionCommentPayload(BaseModel):
    """
    Autogenerated return type of UpdateTeamDiscussionComment
    """

    clientMutationId: Optional[String] = None
    teamDiscussionComment: Optional[TeamDiscussionComment] = None
    typename__: Optional[Literal['UpdateTeamDiscussionCommentPayload']] = Field(
        'UpdateTeamDiscussionCommentPayload', alias='__typename'
    )


class UpdateTeamDiscussionPayload(BaseModel):
    """
    Autogenerated return type of UpdateTeamDiscussion
    """

    clientMutationId: Optional[String] = None
    teamDiscussion: Optional[TeamDiscussion] = None
    typename__: Optional[Literal['UpdateTeamDiscussionPayload']] = Field(
        'UpdateTeamDiscussionPayload', alias='__typename'
    )


class UpdateTeamReviewAssignmentPayload(BaseModel):
    """
    Autogenerated return type of UpdateTeamReviewAssignment
    """

    clientMutationId: Optional[String] = None
    team: Optional[Team] = None
    typename__: Optional[Literal['UpdateTeamReviewAssignmentPayload']] = Field(
        'UpdateTeamReviewAssignmentPayload', alias='__typename'
    )


class UpdateTeamsRepositoryPayload(BaseModel):
    """
    Autogenerated return type of UpdateTeamsRepository
    """

    clientMutationId: Optional[String] = None
    repository: Optional[Repository] = None
    teams: Optional[List[Team]] = Field(default_factory=list)
    typename__: Optional[Literal['UpdateTeamsRepositoryPayload']] = Field(
        'UpdateTeamsRepositoryPayload', alias='__typename'
    )


class UpdateTopicsPayload(BaseModel):
    """
    Autogenerated return type of UpdateTopics
    """

    clientMutationId: Optional[String] = None
    invalidTopicNames: Optional[List[String]] = Field(default_factory=list)
    repository: Optional[Repository] = None
    typename__: Optional[Literal['UpdateTopicsPayload']] = Field(
        'UpdateTopicsPayload', alias='__typename'
    )


class User(
    Actor,
    Node,
    PackageOwner,
    ProfileOwner,
    ProjectOwner,
    ProjectV2Owner,
    ProjectV2Recent,
    RepositoryDiscussionAuthor,
    RepositoryDiscussionCommentAuthor,
    RepositoryOwner,
    Sponsorable,
    UniformResourceLocatable,
):
    """
    A user is an individual's account on GitHub that owns repositories and can make new content.
    """

    anyPinnableItems: Boolean
    avatarUrl: URI
    bio: Optional[String] = None
    bioHTML: HTML
    canReceiveOrganizationEmailsWhenNotificationsRestricted: Boolean
    commitComments: CommitCommentConnection
    company: Optional[String] = None
    companyHTML: HTML
    contributionsCollection: ContributionsCollection
    createdAt: DateTime
    databaseId: Optional[Int] = None
    email: String
    enterprises: Optional[EnterpriseConnection] = None
    estimatedNextSponsorsPayoutInCents: Int
    followers: FollowerConnection
    following: FollowingConnection
    gist: Optional[Gist] = None
    gistComments: GistCommentConnection
    gists: GistConnection
    hasSponsorsListing: Boolean
    hovercard: Hovercard
    id: ID
    interactionAbility: Optional[RepositoryInteractionAbility] = None
    isBountyHunter: Boolean
    isCampusExpert: Boolean
    isDeveloperProgramMember: Boolean
    isEmployee: Boolean
    isFollowingViewer: Boolean
    isGitHubStar: Boolean
    isHireable: Boolean
    isSiteAdmin: Boolean
    isSponsoredBy: Boolean
    isSponsoringViewer: Boolean
    isViewer: Boolean
    issueComments: IssueCommentConnection
    issues: IssueConnection
    itemShowcase: ProfileItemShowcase
    location: Optional[String] = None
    login: String
    monthlyEstimatedSponsorsIncomeInCents: Int
    name: Optional[String] = None
    organization: Optional[Organization] = None
    organizationVerifiedDomainEmails: List[String]
    organizations: OrganizationConnection
    packages: PackageConnection
    pinnableItems: PinnableItemConnection
    pinnedItems: PinnableItemConnection
    pinnedItemsRemaining: Int
    project: Optional[Project] = None
    projectV2: Optional[ProjectV2] = None
    projects: ProjectConnection
    projectsResourcePath: URI
    projectsUrl: URI
    projectsV2: ProjectV2Connection
    pronouns: Optional[String] = None
    publicKeys: PublicKeyConnection
    pullRequests: PullRequestConnection
    recentProjects: ProjectV2Connection
    repositories: RepositoryConnection
    repositoriesContributedTo: RepositoryConnection
    repository: Optional[Repository] = None
    repositoryDiscussionComments: DiscussionCommentConnection
    repositoryDiscussions: DiscussionConnection
    resourcePath: URI
    savedReplies: Optional[SavedReplyConnection] = None
    socialAccounts: SocialAccountConnection
    sponsoring: SponsorConnection
    sponsors: SponsorConnection
    sponsorsActivities: SponsorsActivityConnection
    sponsorsListing: Optional[SponsorsListing] = None
    sponsorshipForViewerAsSponsor: Optional[Sponsorship] = None
    sponsorshipForViewerAsSponsorable: Optional[Sponsorship] = None
    sponsorshipNewsletters: SponsorshipNewsletterConnection
    sponsorshipsAsMaintainer: SponsorshipConnection
    sponsorshipsAsSponsor: SponsorshipConnection
    starredRepositories: StarredRepositoryConnection
    status: Optional[UserStatus] = None
    topRepositories: RepositoryConnection
    totalSponsorshipAmountAsSponsorInCents: Optional[Int] = None
    twitterUsername: Optional[String] = None
    updatedAt: DateTime
    url: URI
    viewerCanChangePinnedItems: Boolean
    viewerCanCreateProjects: Boolean
    viewerCanFollow: Boolean
    viewerCanSponsor: Boolean
    viewerIsFollowing: Boolean
    viewerIsSponsoring: Boolean
    watching: RepositoryConnection
    websiteUrl: Optional[URI] = None
    typename__: Optional[Literal['User']] = Field('User', alias='__typename')


class UserBlockedEvent(Node):
    """
    Represents a 'user_blocked' event on a given user.
    """

    actor: Optional[Actor] = None
    blockDuration: UserBlockDuration
    createdAt: DateTime
    id: ID
    subject: Optional[User] = None
    typename__: Optional[Literal['UserBlockedEvent']] = Field(
        'UserBlockedEvent', alias='__typename'
    )


class UserConnection(BaseModel):
    """
    The connection type for User.
    """

    edges: Optional[List[Optional[UserEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[User]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['UserConnection']] = Field(
        'UserConnection', alias='__typename'
    )


class UserContentEdit(Node):
    """
    An edit on user content
    """

    createdAt: DateTime
    deletedAt: Optional[DateTime] = None
    deletedBy: Optional[Actor] = None
    diff: Optional[String] = None
    editedAt: DateTime
    editor: Optional[Actor] = None
    id: ID
    updatedAt: DateTime
    typename__: Optional[Literal['UserContentEdit']] = Field(
        'UserContentEdit', alias='__typename'
    )


class UserContentEditConnection(BaseModel):
    """
    A list of edits to content.
    """

    edges: Optional[List[Optional[UserContentEditEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[UserContentEdit]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['UserContentEditConnection']] = Field(
        'UserContentEditConnection', alias='__typename'
    )


class UserContentEditEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[UserContentEdit] = None
    typename__: Optional[Literal['UserContentEditEdge']] = Field(
        'UserContentEditEdge', alias='__typename'
    )


class UserEdge(BaseModel):
    """
    Represents a user.
    """

    cursor: String
    node: Optional[User] = None
    typename__: Optional[Literal['UserEdge']] = Field('UserEdge', alias='__typename')


class UserEmailMetadata(BaseModel):
    """
    Email attributes from External Identity
    """

    primary: Optional[Boolean] = None
    type: Optional[String] = None
    value: String
    typename__: Optional[Literal['UserEmailMetadata']] = Field(
        'UserEmailMetadata', alias='__typename'
    )


class UserStatus(Node):
    """
    The user's description of what they're currently doing.
    """

    createdAt: DateTime
    emoji: Optional[String] = None
    emojiHTML: Optional[HTML] = None
    expiresAt: Optional[DateTime] = None
    id: ID
    indicatesLimitedAvailability: Boolean
    message: Optional[String] = None
    organization: Optional[Organization] = None
    updatedAt: DateTime
    user: User
    typename__: Optional[Literal['UserStatus']] = Field(
        'UserStatus', alias='__typename'
    )


class UserStatusConnection(BaseModel):
    """
    The connection type for UserStatus.
    """

    edges: Optional[List[Optional[UserStatusEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[UserStatus]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['UserStatusConnection']] = Field(
        'UserStatusConnection', alias='__typename'
    )


class UserStatusEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[UserStatus] = None
    typename__: Optional[Literal['UserStatusEdge']] = Field(
        'UserStatusEdge', alias='__typename'
    )


class VerifiableDomain(Node):
    """
    A domain that can be verified or approved for an organization or an enterprise.
    """

    createdAt: DateTime
    databaseId: Optional[Int] = None
    dnsHostName: Optional[URI] = None
    domain: URI
    hasFoundHostName: Boolean
    hasFoundVerificationToken: Boolean
    id: ID
    isApproved: Boolean
    isRequiredForPolicyEnforcement: Boolean
    isVerified: Boolean
    owner: VerifiableDomainOwner
    punycodeEncodedDomain: URI
    tokenExpirationTime: Optional[DateTime] = None
    updatedAt: DateTime
    verificationToken: Optional[String] = None
    typename__: Optional[Literal['VerifiableDomain']] = Field(
        'VerifiableDomain', alias='__typename'
    )


class VerifiableDomainConnection(BaseModel):
    """
    The connection type for VerifiableDomain.
    """

    edges: Optional[List[Optional[VerifiableDomainEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[VerifiableDomain]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['VerifiableDomainConnection']] = Field(
        'VerifiableDomainConnection', alias='__typename'
    )


class VerifiableDomainEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[VerifiableDomain] = None
    typename__: Optional[Literal['VerifiableDomainEdge']] = Field(
        'VerifiableDomainEdge', alias='__typename'
    )


class VerifyVerifiableDomainPayload(BaseModel):
    """
    Autogenerated return type of VerifyVerifiableDomain
    """

    clientMutationId: Optional[String] = None
    domain: Optional[VerifiableDomain] = None
    typename__: Optional[Literal['VerifyVerifiableDomainPayload']] = Field(
        'VerifyVerifiableDomainPayload', alias='__typename'
    )


class ViewerHovercardContext(HovercardContext):
    """
    A hovercard context with a message describing how the viewer is related.
    """

    message: String
    octicon: String
    viewer: User
    typename__: Optional[Literal['ViewerHovercardContext']] = Field(
        'ViewerHovercardContext', alias='__typename'
    )


class Workflow(Node, UniformResourceLocatable):
    """
    A workflow contains meta information about an Actions workflow file.
    """

    createdAt: DateTime
    databaseId: Optional[Int] = None
    id: ID
    name: String
    resourcePath: URI
    runs: WorkflowRunConnection
    state: WorkflowState
    updatedAt: DateTime
    url: URI
    typename__: Optional[Literal['Workflow']] = Field('Workflow', alias='__typename')


class WorkflowFileReference(BaseModel):
    """
    A workflow that must run for this rule to pass
    """

    path: String
    ref: Optional[String] = None
    repositoryId: Int
    sha: Optional[String] = None
    typename__: Optional[Literal['WorkflowFileReference']] = Field(
        'WorkflowFileReference', alias='__typename'
    )


class WorkflowRun(Node, UniformResourceLocatable):
    """
    A workflow run.
    """

    checkSuite: CheckSuite
    createdAt: DateTime
    databaseId: Optional[Int] = None
    deploymentReviews: DeploymentReviewConnection
    event: String
    file: Optional[WorkflowRunFile] = None
    id: ID
    pendingDeploymentRequests: DeploymentRequestConnection
    resourcePath: URI
    runNumber: Int
    updatedAt: DateTime
    url: URI
    workflow: Workflow
    typename__: Optional[Literal['WorkflowRun']] = Field(
        'WorkflowRun', alias='__typename'
    )


class WorkflowRunConnection(BaseModel):
    """
    The connection type for WorkflowRun.
    """

    edges: Optional[List[Optional[WorkflowRunEdge]]] = Field(default_factory=list)
    nodes: Optional[List[Optional[WorkflowRun]]] = Field(default_factory=list)
    pageInfo: PageInfo
    totalCount: Int
    typename__: Optional[Literal['WorkflowRunConnection']] = Field(
        'WorkflowRunConnection', alias='__typename'
    )


class WorkflowRunEdge(BaseModel):
    """
    An edge in a connection.
    """

    cursor: String
    node: Optional[WorkflowRun] = None
    typename__: Optional[Literal['WorkflowRunEdge']] = Field(
        'WorkflowRunEdge', alias='__typename'
    )


class WorkflowRunFile(Node, UniformResourceLocatable):
    """
    An executed workflow file for a workflow run.
    """

    id: ID
    path: String
    repositoryFileUrl: URI
    repositoryName: URI
    resourcePath: URI
    run: WorkflowRun
    url: URI
    viewerCanPushRepository: Boolean
    viewerCanReadRepository: Boolean
    typename__: Optional[Literal['WorkflowRunFile']] = Field(
        'WorkflowRunFile', alias='__typename'
    )


class WorkflowsParameters(BaseModel):
    """
    Require all changes made to a targeted branch to pass the specified workflows before they can be merged.
    """

    workflows: List[WorkflowFileReference]
    typename__: Optional[Literal['WorkflowsParameters']] = Field(
        'WorkflowsParameters', alias='__typename'
    )


class AbortQueuedMigrationsInput(BaseModel):
    """
    Autogenerated input type of AbortQueuedMigrations
    """

    clientMutationId: Optional[String] = None
    ownerId: ID
    typename__: Optional[Literal['AbortQueuedMigrationsInput']] = Field(
        'AbortQueuedMigrationsInput', alias='__typename'
    )


class AbortRepositoryMigrationInput(BaseModel):
    """
    Autogenerated input type of AbortRepositoryMigration
    """

    clientMutationId: Optional[String] = None
    migrationId: ID
    typename__: Optional[Literal['AbortRepositoryMigrationInput']] = Field(
        'AbortRepositoryMigrationInput', alias='__typename'
    )


class AcceptEnterpriseAdministratorInvitationInput(BaseModel):
    """
    Autogenerated input type of AcceptEnterpriseAdministratorInvitation
    """

    clientMutationId: Optional[String] = None
    invitationId: ID
    typename__: Optional[
        Literal['AcceptEnterpriseAdministratorInvitationInput']
    ] = Field('AcceptEnterpriseAdministratorInvitationInput', alias='__typename')


class AcceptTopicSuggestionInput(BaseModel):
    """
    Autogenerated input type of AcceptTopicSuggestion
    """

    clientMutationId: Optional[String] = None
    name: String
    repositoryId: ID
    typename__: Optional[Literal['AcceptTopicSuggestionInput']] = Field(
        'AcceptTopicSuggestionInput', alias='__typename'
    )


class AddAssigneesToAssignableInput(BaseModel):
    """
    Autogenerated input type of AddAssigneesToAssignable
    """

    assignableId: ID
    assigneeIds: List[ID]
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['AddAssigneesToAssignableInput']] = Field(
        'AddAssigneesToAssignableInput', alias='__typename'
    )


class AddCommentInput(BaseModel):
    """
    Autogenerated input type of AddComment
    """

    body: String
    clientMutationId: Optional[String] = None
    subjectId: ID
    typename__: Optional[Literal['AddCommentInput']] = Field(
        'AddCommentInput', alias='__typename'
    )


class AddDiscussionCommentInput(BaseModel):
    """
    Autogenerated input type of AddDiscussionComment
    """

    body: String
    clientMutationId: Optional[String] = None
    discussionId: ID
    replyToId: Optional[ID] = None
    typename__: Optional[Literal['AddDiscussionCommentInput']] = Field(
        'AddDiscussionCommentInput', alias='__typename'
    )


class AddDiscussionPollVoteInput(BaseModel):
    """
    Autogenerated input type of AddDiscussionPollVote
    """

    clientMutationId: Optional[String] = None
    pollOptionId: ID
    typename__: Optional[Literal['AddDiscussionPollVoteInput']] = Field(
        'AddDiscussionPollVoteInput', alias='__typename'
    )


class AddEnterpriseOrganizationMemberInput(BaseModel):
    """
    Autogenerated input type of AddEnterpriseOrganizationMember
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    organizationId: ID
    role: Optional[OrganizationMemberRole] = None
    userIds: List[ID]
    typename__: Optional[Literal['AddEnterpriseOrganizationMemberInput']] = Field(
        'AddEnterpriseOrganizationMemberInput', alias='__typename'
    )


class AddEnterpriseSupportEntitlementInput(BaseModel):
    """
    Autogenerated input type of AddEnterpriseSupportEntitlement
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    login: String
    typename__: Optional[Literal['AddEnterpriseSupportEntitlementInput']] = Field(
        'AddEnterpriseSupportEntitlementInput', alias='__typename'
    )


class AddLabelsToLabelableInput(BaseModel):
    """
    Autogenerated input type of AddLabelsToLabelable
    """

    clientMutationId: Optional[String] = None
    labelIds: List[ID]
    labelableId: ID
    typename__: Optional[Literal['AddLabelsToLabelableInput']] = Field(
        'AddLabelsToLabelableInput', alias='__typename'
    )


class AddProjectCardInput(BaseModel):
    """
    Autogenerated input type of AddProjectCard
    """

    clientMutationId: Optional[String] = None
    contentId: Optional[ID] = None
    note: Optional[String] = None
    projectColumnId: ID
    typename__: Optional[Literal['AddProjectCardInput']] = Field(
        'AddProjectCardInput', alias='__typename'
    )


class AddProjectColumnInput(BaseModel):
    """
    Autogenerated input type of AddProjectColumn
    """

    clientMutationId: Optional[String] = None
    name: String
    projectId: ID
    typename__: Optional[Literal['AddProjectColumnInput']] = Field(
        'AddProjectColumnInput', alias='__typename'
    )


class AddProjectV2DraftIssueInput(BaseModel):
    """
    Autogenerated input type of AddProjectV2DraftIssue
    """

    assigneeIds: Optional[List[ID]] = None
    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    projectId: ID
    title: String
    typename__: Optional[Literal['AddProjectV2DraftIssueInput']] = Field(
        'AddProjectV2DraftIssueInput', alias='__typename'
    )


class AddProjectV2ItemByIdInput(BaseModel):
    """
    Autogenerated input type of AddProjectV2ItemById
    """

    clientMutationId: Optional[String] = None
    contentId: ID
    projectId: ID
    typename__: Optional[Literal['AddProjectV2ItemByIdInput']] = Field(
        'AddProjectV2ItemByIdInput', alias='__typename'
    )


class AddPullRequestReviewCommentInput(BaseModel):
    """
    Autogenerated input type of AddPullRequestReviewComment
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    commitOID: Optional[GitObjectID] = None
    inReplyTo: Optional[ID] = None
    path: Optional[String] = None
    position: Optional[Int] = None
    pullRequestId: Optional[ID] = None
    pullRequestReviewId: Optional[ID] = None
    typename__: Optional[Literal['AddPullRequestReviewCommentInput']] = Field(
        'AddPullRequestReviewCommentInput', alias='__typename'
    )


class AddPullRequestReviewInput(BaseModel):
    """
    Autogenerated input type of AddPullRequestReview
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    comments: Optional[List[Optional[DraftPullRequestReviewComment]]] = None
    commitOID: Optional[GitObjectID] = None
    event: Optional[PullRequestReviewEvent] = None
    pullRequestId: ID
    threads: Optional[List[Optional[DraftPullRequestReviewThread]]] = None
    typename__: Optional[Literal['AddPullRequestReviewInput']] = Field(
        'AddPullRequestReviewInput', alias='__typename'
    )


class AddPullRequestReviewThreadInput(BaseModel):
    """
    Autogenerated input type of AddPullRequestReviewThread
    """

    body: String
    clientMutationId: Optional[String] = None
    line: Optional[Int] = None
    path: String
    pullRequestId: Optional[ID] = None
    pullRequestReviewId: Optional[ID] = None
    side: Optional[DiffSide] = 'RIGHT'
    startLine: Optional[Int] = None
    startSide: Optional[DiffSide] = 'RIGHT'
    subjectType: Optional[PullRequestReviewThreadSubjectType] = 'LINE'
    typename__: Optional[Literal['AddPullRequestReviewThreadInput']] = Field(
        'AddPullRequestReviewThreadInput', alias='__typename'
    )


class AddPullRequestReviewThreadReplyInput(BaseModel):
    """
    Autogenerated input type of AddPullRequestReviewThreadReply
    """

    body: String
    clientMutationId: Optional[String] = None
    pullRequestReviewId: Optional[ID] = None
    pullRequestReviewThreadId: ID
    typename__: Optional[Literal['AddPullRequestReviewThreadReplyInput']] = Field(
        'AddPullRequestReviewThreadReplyInput', alias='__typename'
    )


class AddReactionInput(BaseModel):
    """
    Autogenerated input type of AddReaction
    """

    clientMutationId: Optional[String] = None
    content: ReactionContent
    subjectId: ID
    typename__: Optional[Literal['AddReactionInput']] = Field(
        'AddReactionInput', alias='__typename'
    )


class AddStarInput(BaseModel):
    """
    Autogenerated input type of AddStar
    """

    clientMutationId: Optional[String] = None
    starrableId: ID
    typename__: Optional[Literal['AddStarInput']] = Field(
        'AddStarInput', alias='__typename'
    )


class AddUpvoteInput(BaseModel):
    """
    Autogenerated input type of AddUpvote
    """

    clientMutationId: Optional[String] = None
    subjectId: ID
    typename__: Optional[Literal['AddUpvoteInput']] = Field(
        'AddUpvoteInput', alias='__typename'
    )


class AddVerifiableDomainInput(BaseModel):
    """
    Autogenerated input type of AddVerifiableDomain
    """

    clientMutationId: Optional[String] = None
    domain: URI
    ownerId: ID
    typename__: Optional[Literal['AddVerifiableDomainInput']] = Field(
        'AddVerifiableDomainInput', alias='__typename'
    )


class ApproveDeploymentsInput(BaseModel):
    """
    Autogenerated input type of ApproveDeployments
    """

    clientMutationId: Optional[String] = None
    comment: Optional[String] = ''
    environmentIds: List[ID]
    workflowRunId: ID
    typename__: Optional[Literal['ApproveDeploymentsInput']] = Field(
        'ApproveDeploymentsInput', alias='__typename'
    )


class ApproveVerifiableDomainInput(BaseModel):
    """
    Autogenerated input type of ApproveVerifiableDomain
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['ApproveVerifiableDomainInput']] = Field(
        'ApproveVerifiableDomainInput', alias='__typename'
    )


class ArchiveProjectV2ItemInput(BaseModel):
    """
    Autogenerated input type of ArchiveProjectV2Item
    """

    clientMutationId: Optional[String] = None
    itemId: ID
    projectId: ID
    typename__: Optional[Literal['ArchiveProjectV2ItemInput']] = Field(
        'ArchiveProjectV2ItemInput', alias='__typename'
    )


class ArchiveRepositoryInput(BaseModel):
    """
    Autogenerated input type of ArchiveRepository
    """

    clientMutationId: Optional[String] = None
    repositoryId: ID
    typename__: Optional[Literal['ArchiveRepositoryInput']] = Field(
        'ArchiveRepositoryInput', alias='__typename'
    )


class AuditLogOrder(BaseModel):
    """
    Ordering options for Audit Log connections.
    """

    direction: Optional[OrderDirection] = None
    field: Optional[AuditLogOrderField] = None
    typename__: Optional[Literal['AuditLogOrder']] = Field(
        'AuditLogOrder', alias='__typename'
    )


class BranchNamePatternParametersInput(BaseModel):
    """
    Parameters to be used for the branch_name_pattern rule
    """

    name: Optional[String] = None
    negate: Optional[Boolean] = None
    operator: String
    pattern: String
    typename__: Optional[Literal['BranchNamePatternParametersInput']] = Field(
        'BranchNamePatternParametersInput', alias='__typename'
    )


class BulkSponsorship(BaseModel):
    """
    Information about a sponsorship to make for a user or organization with a GitHub
    Sponsors profile, as part of sponsoring many users or organizations at once.
    """

    amount: Int
    sponsorableId: Optional[ID] = None
    sponsorableLogin: Optional[String] = None
    typename__: Optional[Literal['BulkSponsorship']] = Field(
        'BulkSponsorship', alias='__typename'
    )


class CancelEnterpriseAdminInvitationInput(BaseModel):
    """
    Autogenerated input type of CancelEnterpriseAdminInvitation
    """

    clientMutationId: Optional[String] = None
    invitationId: ID
    typename__: Optional[Literal['CancelEnterpriseAdminInvitationInput']] = Field(
        'CancelEnterpriseAdminInvitationInput', alias='__typename'
    )


class CancelSponsorshipInput(BaseModel):
    """
    Autogenerated input type of CancelSponsorship
    """

    clientMutationId: Optional[String] = None
    sponsorId: Optional[ID] = None
    sponsorLogin: Optional[String] = None
    sponsorableId: Optional[ID] = None
    sponsorableLogin: Optional[String] = None
    typename__: Optional[Literal['CancelSponsorshipInput']] = Field(
        'CancelSponsorshipInput', alias='__typename'
    )


class ChangeUserStatusInput(BaseModel):
    """
    Autogenerated input type of ChangeUserStatus
    """

    clientMutationId: Optional[String] = None
    emoji: Optional[String] = None
    expiresAt: Optional[DateTime] = None
    limitedAvailability: Optional[Boolean] = False
    message: Optional[String] = None
    organizationId: Optional[ID] = None
    typename__: Optional[Literal['ChangeUserStatusInput']] = Field(
        'ChangeUserStatusInput', alias='__typename'
    )


class CheckAnnotationData(BaseModel):
    """
    Information from a check run analysis to specific lines of code.
    """

    annotationLevel: CheckAnnotationLevel
    location: CheckAnnotationRange
    message: String
    path: String
    rawDetails: Optional[String] = None
    title: Optional[String] = None
    typename__: Optional[Literal['CheckAnnotationData']] = Field(
        'CheckAnnotationData', alias='__typename'
    )


class CheckAnnotationRange(BaseModel):
    """
    Information from a check run analysis to specific lines of code.
    """

    endColumn: Optional[Int] = None
    endLine: Int
    startColumn: Optional[Int] = None
    startLine: Int
    typename__: Optional[Literal['CheckAnnotationRange']] = Field(
        'CheckAnnotationRange', alias='__typename'
    )


class CheckRunAction(BaseModel):
    """
    Possible further actions the integrator can perform.
    """

    description: String
    identifier: String
    label: String
    typename__: Optional[Literal['CheckRunAction']] = Field(
        'CheckRunAction', alias='__typename'
    )


class CheckRunFilter(BaseModel):
    """
    The filters that are available when fetching check runs.
    """

    appId: Optional[Int] = None
    checkName: Optional[String] = None
    checkType: Optional[CheckRunType] = None
    conclusions: Optional[List[CheckConclusionState]] = None
    status: Optional[CheckStatusState] = None
    statuses: Optional[List[CheckStatusState]] = None
    typename__: Optional[Literal['CheckRunFilter']] = Field(
        'CheckRunFilter', alias='__typename'
    )


class CheckRunOutput(BaseModel):
    """
    Descriptive details about the check run.
    """

    annotations: Optional[List[CheckAnnotationData]] = None
    images: Optional[List[CheckRunOutputImage]] = None
    summary: String
    text: Optional[String] = None
    title: String
    typename__: Optional[Literal['CheckRunOutput']] = Field(
        'CheckRunOutput', alias='__typename'
    )


class CheckRunOutputImage(BaseModel):
    """
    Images attached to the check run output displayed in the GitHub pull request UI.
    """

    alt: String
    caption: Optional[String] = None
    imageUrl: URI
    typename__: Optional[Literal['CheckRunOutputImage']] = Field(
        'CheckRunOutputImage', alias='__typename'
    )


class CheckSuiteAutoTriggerPreference(BaseModel):
    """
    The auto-trigger preferences that are available for check suites.
    """

    appId: ID
    setting: Boolean
    typename__: Optional[Literal['CheckSuiteAutoTriggerPreference']] = Field(
        'CheckSuiteAutoTriggerPreference', alias='__typename'
    )


class CheckSuiteFilter(BaseModel):
    """
    The filters that are available when fetching check suites.
    """

    appId: Optional[Int] = None
    checkName: Optional[String] = None
    typename__: Optional[Literal['CheckSuiteFilter']] = Field(
        'CheckSuiteFilter', alias='__typename'
    )


class ClearLabelsFromLabelableInput(BaseModel):
    """
    Autogenerated input type of ClearLabelsFromLabelable
    """

    clientMutationId: Optional[String] = None
    labelableId: ID
    typename__: Optional[Literal['ClearLabelsFromLabelableInput']] = Field(
        'ClearLabelsFromLabelableInput', alias='__typename'
    )


class ClearProjectV2ItemFieldValueInput(BaseModel):
    """
    Autogenerated input type of ClearProjectV2ItemFieldValue
    """

    clientMutationId: Optional[String] = None
    fieldId: ID
    itemId: ID
    projectId: ID
    typename__: Optional[Literal['ClearProjectV2ItemFieldValueInput']] = Field(
        'ClearProjectV2ItemFieldValueInput', alias='__typename'
    )


class CloneProjectInput(BaseModel):
    """
    Autogenerated input type of CloneProject
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    includeWorkflows: Boolean
    name: String
    public: Optional[Boolean] = None
    sourceId: ID
    targetOwnerId: ID
    typename__: Optional[Literal['CloneProjectInput']] = Field(
        'CloneProjectInput', alias='__typename'
    )


class CloneTemplateRepositoryInput(BaseModel):
    """
    Autogenerated input type of CloneTemplateRepository
    """

    clientMutationId: Optional[String] = None
    description: Optional[String] = None
    includeAllBranches: Optional[Boolean] = False
    name: String
    ownerId: ID
    repositoryId: ID
    visibility: RepositoryVisibility
    typename__: Optional[Literal['CloneTemplateRepositoryInput']] = Field(
        'CloneTemplateRepositoryInput', alias='__typename'
    )


class CloseDiscussionInput(BaseModel):
    """
    Autogenerated input type of CloseDiscussion
    """

    clientMutationId: Optional[String] = None
    discussionId: ID
    reason: Optional[DiscussionCloseReason] = 'RESOLVED'
    typename__: Optional[Literal['CloseDiscussionInput']] = Field(
        'CloseDiscussionInput', alias='__typename'
    )


class CloseIssueInput(BaseModel):
    """
    Autogenerated input type of CloseIssue
    """

    clientMutationId: Optional[String] = None
    issueId: ID
    stateReason: Optional[IssueClosedStateReason] = None
    typename__: Optional[Literal['CloseIssueInput']] = Field(
        'CloseIssueInput', alias='__typename'
    )


class ClosePullRequestInput(BaseModel):
    """
    Autogenerated input type of ClosePullRequest
    """

    clientMutationId: Optional[String] = None
    pullRequestId: ID
    typename__: Optional[Literal['ClosePullRequestInput']] = Field(
        'ClosePullRequestInput', alias='__typename'
    )


class CommitAuthor(BaseModel):
    """
    Specifies an author for filtering Git commits.
    """

    emails: Optional[List[String]] = None
    id: Optional[ID] = None
    typename__: Optional[Literal['CommitAuthor']] = Field(
        'CommitAuthor', alias='__typename'
    )


class CommitAuthorEmailPatternParametersInput(BaseModel):
    """
    Parameters to be used for the commit_author_email_pattern rule
    """

    name: Optional[String] = None
    negate: Optional[Boolean] = None
    operator: String
    pattern: String
    typename__: Optional[Literal['CommitAuthorEmailPatternParametersInput']] = Field(
        'CommitAuthorEmailPatternParametersInput', alias='__typename'
    )


class CommitContributionOrder(BaseModel):
    """
    Ordering options for commit contribution connections.
    """

    direction: OrderDirection
    field: CommitContributionOrderField
    typename__: Optional[Literal['CommitContributionOrder']] = Field(
        'CommitContributionOrder', alias='__typename'
    )


class CommitMessage(BaseModel):
    """
    A message to include with a new commit
    """

    body: Optional[String] = None
    headline: String
    typename__: Optional[Literal['CommitMessage']] = Field(
        'CommitMessage', alias='__typename'
    )


class CommitMessagePatternParametersInput(BaseModel):
    """
    Parameters to be used for the commit_message_pattern rule
    """

    name: Optional[String] = None
    negate: Optional[Boolean] = None
    operator: String
    pattern: String
    typename__: Optional[Literal['CommitMessagePatternParametersInput']] = Field(
        'CommitMessagePatternParametersInput', alias='__typename'
    )


class CommittableBranch(BaseModel):
    """
    A git ref for a commit to be appended to.

    The ref must be a branch, i.e. its fully qualified name must start
    with `refs/heads/` (although the input is not required to be fully
    qualified).

    The Ref may be specified by its global node ID or by the
    `repositoryNameWithOwner` and `branchName`.

    ### Examples

    Specify a branch using a global node ID:

        { "id": "MDM6UmVmMTpyZWZzL2hlYWRzL21haW4=" }

    Specify a branch using `repositoryNameWithOwner` and `branchName`:

        {
          "repositoryNameWithOwner": "github/graphql-client",
          "branchName": "main"
        }
    """

    branchName: Optional[String] = None
    id: Optional[ID] = None
    repositoryNameWithOwner: Optional[String] = None
    typename__: Optional[Literal['CommittableBranch']] = Field(
        'CommittableBranch', alias='__typename'
    )


class CommitterEmailPatternParametersInput(BaseModel):
    """
    Parameters to be used for the committer_email_pattern rule
    """

    name: Optional[String] = None
    negate: Optional[Boolean] = None
    operator: String
    pattern: String
    typename__: Optional[Literal['CommitterEmailPatternParametersInput']] = Field(
        'CommitterEmailPatternParametersInput', alias='__typename'
    )


class ContributionOrder(BaseModel):
    """
    Ordering options for contribution connections.
    """

    direction: OrderDirection
    typename__: Optional[Literal['ContributionOrder']] = Field(
        'ContributionOrder', alias='__typename'
    )


class ConvertProjectCardNoteToIssueInput(BaseModel):
    """
    Autogenerated input type of ConvertProjectCardNoteToIssue
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    projectCardId: ID
    repositoryId: ID
    title: Optional[String] = None
    typename__: Optional[Literal['ConvertProjectCardNoteToIssueInput']] = Field(
        'ConvertProjectCardNoteToIssueInput', alias='__typename'
    )


class ConvertPullRequestToDraftInput(BaseModel):
    """
    Autogenerated input type of ConvertPullRequestToDraft
    """

    clientMutationId: Optional[String] = None
    pullRequestId: ID
    typename__: Optional[Literal['ConvertPullRequestToDraftInput']] = Field(
        'ConvertPullRequestToDraftInput', alias='__typename'
    )


class CopyProjectV2Input(BaseModel):
    """
    Autogenerated input type of CopyProjectV2
    """

    clientMutationId: Optional[String] = None
    includeDraftIssues: Optional[Boolean] = False
    ownerId: ID
    projectId: ID
    title: String
    typename__: Optional[Literal['CopyProjectV2Input']] = Field(
        'CopyProjectV2Input', alias='__typename'
    )


class CreateAttributionInvitationInput(BaseModel):
    """
    Autogenerated input type of CreateAttributionInvitation
    """

    clientMutationId: Optional[String] = None
    ownerId: ID
    sourceId: ID
    targetId: ID
    typename__: Optional[Literal['CreateAttributionInvitationInput']] = Field(
        'CreateAttributionInvitationInput', alias='__typename'
    )


class CreateBranchProtectionRuleInput(BaseModel):
    """
    Autogenerated input type of CreateBranchProtectionRule
    """

    allowsDeletions: Optional[Boolean] = None
    allowsForcePushes: Optional[Boolean] = None
    blocksCreations: Optional[Boolean] = None
    bypassForcePushActorIds: Optional[List[ID]] = None
    bypassPullRequestActorIds: Optional[List[ID]] = None
    clientMutationId: Optional[String] = None
    dismissesStaleReviews: Optional[Boolean] = None
    isAdminEnforced: Optional[Boolean] = None
    lockAllowsFetchAndMerge: Optional[Boolean] = None
    lockBranch: Optional[Boolean] = None
    pattern: String
    pushActorIds: Optional[List[ID]] = None
    repositoryId: ID
    requireLastPushApproval: Optional[Boolean] = None
    requiredApprovingReviewCount: Optional[Int] = None
    requiredDeploymentEnvironments: Optional[List[String]] = None
    requiredStatusCheckContexts: Optional[List[String]] = None
    requiredStatusChecks: Optional[List[RequiredStatusCheckInput]] = None
    requiresApprovingReviews: Optional[Boolean] = None
    requiresCodeOwnerReviews: Optional[Boolean] = None
    requiresCommitSignatures: Optional[Boolean] = None
    requiresConversationResolution: Optional[Boolean] = None
    requiresDeployments: Optional[Boolean] = None
    requiresLinearHistory: Optional[Boolean] = None
    requiresStatusChecks: Optional[Boolean] = None
    requiresStrictStatusChecks: Optional[Boolean] = None
    restrictsPushes: Optional[Boolean] = None
    restrictsReviewDismissals: Optional[Boolean] = None
    reviewDismissalActorIds: Optional[List[ID]] = None
    typename__: Optional[Literal['CreateBranchProtectionRuleInput']] = Field(
        'CreateBranchProtectionRuleInput', alias='__typename'
    )


class CreateCheckRunInput(BaseModel):
    """
    Autogenerated input type of CreateCheckRun
    """

    actions: Optional[List[CheckRunAction]] = None
    clientMutationId: Optional[String] = None
    completedAt: Optional[DateTime] = None
    conclusion: Optional[CheckConclusionState] = None
    detailsUrl: Optional[URI] = None
    externalId: Optional[String] = None
    headSha: GitObjectID
    name: String
    output: Optional[CheckRunOutput] = None
    repositoryId: ID
    startedAt: Optional[DateTime] = None
    status: Optional[RequestableCheckStatusState] = None
    typename__: Optional[Literal['CreateCheckRunInput']] = Field(
        'CreateCheckRunInput', alias='__typename'
    )


class CreateCheckSuiteInput(BaseModel):
    """
    Autogenerated input type of CreateCheckSuite
    """

    clientMutationId: Optional[String] = None
    headSha: GitObjectID
    repositoryId: ID
    typename__: Optional[Literal['CreateCheckSuiteInput']] = Field(
        'CreateCheckSuiteInput', alias='__typename'
    )


class CreateCommitOnBranchInput(BaseModel):
    """
    Autogenerated input type of CreateCommitOnBranch
    """

    branch: CommittableBranch
    clientMutationId: Optional[String] = None
    expectedHeadOid: GitObjectID
    fileChanges: Optional[FileChanges] = None
    message: CommitMessage
    typename__: Optional[Literal['CreateCommitOnBranchInput']] = Field(
        'CreateCommitOnBranchInput', alias='__typename'
    )


class CreateDeploymentInput(BaseModel):
    """
    Autogenerated input type of CreateDeployment
    """

    autoMerge: Optional[Boolean] = True
    clientMutationId: Optional[String] = None
    description: Optional[String] = ''
    environment: Optional[String] = 'production'
    payload: Optional[String] = '{}'
    refId: ID
    repositoryId: ID
    requiredContexts: Optional[List[String]] = None
    task: Optional[String] = 'deploy'
    typename__: Optional[Literal['CreateDeploymentInput']] = Field(
        'CreateDeploymentInput', alias='__typename'
    )


class CreateDeploymentStatusInput(BaseModel):
    """
    Autogenerated input type of CreateDeploymentStatus
    """

    autoInactive: Optional[Boolean] = True
    clientMutationId: Optional[String] = None
    deploymentId: ID
    description: Optional[String] = ''
    environment: Optional[String] = None
    environmentUrl: Optional[String] = ''
    logUrl: Optional[String] = ''
    state: DeploymentStatusState
    typename__: Optional[Literal['CreateDeploymentStatusInput']] = Field(
        'CreateDeploymentStatusInput', alias='__typename'
    )


class CreateDiscussionInput(BaseModel):
    """
    Autogenerated input type of CreateDiscussion
    """

    body: String
    categoryId: ID
    clientMutationId: Optional[String] = None
    repositoryId: ID
    title: String
    typename__: Optional[Literal['CreateDiscussionInput']] = Field(
        'CreateDiscussionInput', alias='__typename'
    )


class CreateEnterpriseOrganizationInput(BaseModel):
    """
    Autogenerated input type of CreateEnterpriseOrganization
    """

    adminLogins: List[String]
    billingEmail: String
    clientMutationId: Optional[String] = None
    enterpriseId: ID
    login: String
    profileName: String
    typename__: Optional[Literal['CreateEnterpriseOrganizationInput']] = Field(
        'CreateEnterpriseOrganizationInput', alias='__typename'
    )


class CreateEnvironmentInput(BaseModel):
    """
    Autogenerated input type of CreateEnvironment
    """

    clientMutationId: Optional[String] = None
    name: String
    repositoryId: ID
    typename__: Optional[Literal['CreateEnvironmentInput']] = Field(
        'CreateEnvironmentInput', alias='__typename'
    )


class CreateIpAllowListEntryInput(BaseModel):
    """
    Autogenerated input type of CreateIpAllowListEntry
    """

    allowListValue: String
    clientMutationId: Optional[String] = None
    isActive: Boolean
    name: Optional[String] = None
    ownerId: ID
    typename__: Optional[Literal['CreateIpAllowListEntryInput']] = Field(
        'CreateIpAllowListEntryInput', alias='__typename'
    )


class CreateIssueInput(BaseModel):
    """
    Autogenerated input type of CreateIssue
    """

    assigneeIds: Optional[List[ID]] = None
    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    issueTemplate: Optional[String] = None
    labelIds: Optional[List[ID]] = None
    milestoneId: Optional[ID] = None
    projectIds: Optional[List[ID]] = None
    repositoryId: ID
    title: String
    typename__: Optional[Literal['CreateIssueInput']] = Field(
        'CreateIssueInput', alias='__typename'
    )


class CreateLabelInput(BaseModel):
    """
    Autogenerated input type of CreateLabel
    """

    clientMutationId: Optional[String] = None
    color: String
    description: Optional[String] = None
    name: String
    repositoryId: ID
    typename__: Optional[Literal['CreateLabelInput']] = Field(
        'CreateLabelInput', alias='__typename'
    )


class CreateLinkedBranchInput(BaseModel):
    """
    Autogenerated input type of CreateLinkedBranch
    """

    clientMutationId: Optional[String] = None
    issueId: ID
    name: Optional[String] = None
    oid: GitObjectID
    repositoryId: Optional[ID] = None
    typename__: Optional[Literal['CreateLinkedBranchInput']] = Field(
        'CreateLinkedBranchInput', alias='__typename'
    )


class CreateMigrationSourceInput(BaseModel):
    """
    Autogenerated input type of CreateMigrationSource
    """

    accessToken: Optional[String] = None
    clientMutationId: Optional[String] = None
    githubPat: Optional[String] = None
    name: String
    ownerId: ID
    type: MigrationSourceType
    url: Optional[String] = None
    typename__: Optional[Literal['CreateMigrationSourceInput']] = Field(
        'CreateMigrationSourceInput', alias='__typename'
    )


class CreateProjectInput(BaseModel):
    """
    Autogenerated input type of CreateProject
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    name: String
    ownerId: ID
    repositoryIds: Optional[List[ID]] = None
    template: Optional[ProjectTemplate] = None
    typename__: Optional[Literal['CreateProjectInput']] = Field(
        'CreateProjectInput', alias='__typename'
    )


class CreateProjectV2FieldInput(BaseModel):
    """
    Autogenerated input type of CreateProjectV2Field
    """

    clientMutationId: Optional[String] = None
    dataType: ProjectV2CustomFieldType
    name: String
    projectId: ID
    singleSelectOptions: Optional[List[ProjectV2SingleSelectFieldOptionInput]] = None
    typename__: Optional[Literal['CreateProjectV2FieldInput']] = Field(
        'CreateProjectV2FieldInput', alias='__typename'
    )


class CreateProjectV2Input(BaseModel):
    """
    Autogenerated input type of CreateProjectV2
    """

    clientMutationId: Optional[String] = None
    ownerId: ID
    repositoryId: Optional[ID] = None
    teamId: Optional[ID] = None
    title: String
    typename__: Optional[Literal['CreateProjectV2Input']] = Field(
        'CreateProjectV2Input', alias='__typename'
    )


class CreatePullRequestInput(BaseModel):
    """
    Autogenerated input type of CreatePullRequest
    """

    baseRefName: String
    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    draft: Optional[Boolean] = False
    headRefName: String
    headRepositoryId: Optional[ID] = None
    maintainerCanModify: Optional[Boolean] = True
    repositoryId: ID
    title: String
    typename__: Optional[Literal['CreatePullRequestInput']] = Field(
        'CreatePullRequestInput', alias='__typename'
    )


class CreateRefInput(BaseModel):
    """
    Autogenerated input type of CreateRef
    """

    clientMutationId: Optional[String] = None
    name: String
    oid: GitObjectID
    repositoryId: ID
    typename__: Optional[Literal['CreateRefInput']] = Field(
        'CreateRefInput', alias='__typename'
    )


class CreateRepositoryInput(BaseModel):
    """
    Autogenerated input type of CreateRepository
    """

    clientMutationId: Optional[String] = None
    description: Optional[String] = None
    hasIssuesEnabled: Optional[Boolean] = True
    hasWikiEnabled: Optional[Boolean] = False
    homepageUrl: Optional[URI] = None
    name: String
    ownerId: Optional[ID] = None
    teamId: Optional[ID] = None
    template: Optional[Boolean] = False
    visibility: RepositoryVisibility
    typename__: Optional[Literal['CreateRepositoryInput']] = Field(
        'CreateRepositoryInput', alias='__typename'
    )


class CreateRepositoryRulesetInput(BaseModel):
    """
    Autogenerated input type of CreateRepositoryRuleset
    """

    bypassActors: Optional[List[RepositoryRulesetBypassActorInput]] = None
    clientMutationId: Optional[String] = None
    conditions: RepositoryRuleConditionsInput
    enforcement: RuleEnforcement
    name: String
    rules: Optional[List[RepositoryRuleInput]] = None
    sourceId: ID
    target: Optional[RepositoryRulesetTarget] = None
    typename__: Optional[Literal['CreateRepositoryRulesetInput']] = Field(
        'CreateRepositoryRulesetInput', alias='__typename'
    )


class CreateSponsorsListingInput(BaseModel):
    """
    Autogenerated input type of CreateSponsorsListing
    """

    billingCountryOrRegionCode: Optional[SponsorsCountryOrRegionCode] = None
    clientMutationId: Optional[String] = None
    contactEmail: Optional[String] = None
    fiscalHostLogin: Optional[String] = None
    fiscallyHostedProjectProfileUrl: Optional[String] = None
    fullDescription: Optional[String] = None
    residenceCountryOrRegionCode: Optional[SponsorsCountryOrRegionCode] = None
    sponsorableLogin: Optional[String] = None
    typename__: Optional[Literal['CreateSponsorsListingInput']] = Field(
        'CreateSponsorsListingInput', alias='__typename'
    )


class CreateSponsorsTierInput(BaseModel):
    """
    Autogenerated input type of CreateSponsorsTier
    """

    amount: Int
    clientMutationId: Optional[String] = None
    description: String
    isRecurring: Optional[Boolean] = True
    publish: Optional[Boolean] = False
    repositoryId: Optional[ID] = None
    repositoryName: Optional[String] = None
    repositoryOwnerLogin: Optional[String] = None
    sponsorableId: Optional[ID] = None
    sponsorableLogin: Optional[String] = None
    welcomeMessage: Optional[String] = None
    typename__: Optional[Literal['CreateSponsorsTierInput']] = Field(
        'CreateSponsorsTierInput', alias='__typename'
    )


class CreateSponsorshipInput(BaseModel):
    """
    Autogenerated input type of CreateSponsorship
    """

    amount: Optional[Int] = None
    clientMutationId: Optional[String] = None
    isRecurring: Optional[Boolean] = None
    privacyLevel: Optional[SponsorshipPrivacy] = 'PUBLIC'
    receiveEmails: Optional[Boolean] = True
    sponsorId: Optional[ID] = None
    sponsorLogin: Optional[String] = None
    sponsorableId: Optional[ID] = None
    sponsorableLogin: Optional[String] = None
    tierId: Optional[ID] = None
    typename__: Optional[Literal['CreateSponsorshipInput']] = Field(
        'CreateSponsorshipInput', alias='__typename'
    )


class CreateSponsorshipsInput(BaseModel):
    """
    Autogenerated input type of CreateSponsorships
    """

    clientMutationId: Optional[String] = None
    privacyLevel: Optional[SponsorshipPrivacy] = 'PUBLIC'
    receiveEmails: Optional[Boolean] = False
    sponsorLogin: String
    sponsorships: List[BulkSponsorship]
    typename__: Optional[Literal['CreateSponsorshipsInput']] = Field(
        'CreateSponsorshipsInput', alias='__typename'
    )


class CreateTeamDiscussionCommentInput(BaseModel):
    """
    Autogenerated input type of CreateTeamDiscussionComment
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    discussionId: Optional[ID] = None
    typename__: Optional[Literal['CreateTeamDiscussionCommentInput']] = Field(
        'CreateTeamDiscussionCommentInput', alias='__typename'
    )


class CreateTeamDiscussionInput(BaseModel):
    """
    Autogenerated input type of CreateTeamDiscussion
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    private: Optional[Boolean] = None
    teamId: Optional[ID] = None
    title: Optional[String] = None
    typename__: Optional[Literal['CreateTeamDiscussionInput']] = Field(
        'CreateTeamDiscussionInput', alias='__typename'
    )


class DeclineTopicSuggestionInput(BaseModel):
    """
    Autogenerated input type of DeclineTopicSuggestion
    """

    clientMutationId: Optional[String] = None
    name: String
    reason: TopicSuggestionDeclineReason
    repositoryId: ID
    typename__: Optional[Literal['DeclineTopicSuggestionInput']] = Field(
        'DeclineTopicSuggestionInput', alias='__typename'
    )


class DeleteBranchProtectionRuleInput(BaseModel):
    """
    Autogenerated input type of DeleteBranchProtectionRule
    """

    branchProtectionRuleId: ID
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteBranchProtectionRuleInput']] = Field(
        'DeleteBranchProtectionRuleInput', alias='__typename'
    )


class DeleteDeploymentInput(BaseModel):
    """
    Autogenerated input type of DeleteDeployment
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteDeploymentInput']] = Field(
        'DeleteDeploymentInput', alias='__typename'
    )


class DeleteDiscussionCommentInput(BaseModel):
    """
    Autogenerated input type of DeleteDiscussionComment
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteDiscussionCommentInput']] = Field(
        'DeleteDiscussionCommentInput', alias='__typename'
    )


class DeleteDiscussionInput(BaseModel):
    """
    Autogenerated input type of DeleteDiscussion
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteDiscussionInput']] = Field(
        'DeleteDiscussionInput', alias='__typename'
    )


class DeleteEnvironmentInput(BaseModel):
    """
    Autogenerated input type of DeleteEnvironment
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteEnvironmentInput']] = Field(
        'DeleteEnvironmentInput', alias='__typename'
    )


class DeleteIpAllowListEntryInput(BaseModel):
    """
    Autogenerated input type of DeleteIpAllowListEntry
    """

    clientMutationId: Optional[String] = None
    ipAllowListEntryId: ID
    typename__: Optional[Literal['DeleteIpAllowListEntryInput']] = Field(
        'DeleteIpAllowListEntryInput', alias='__typename'
    )


class DeleteIssueCommentInput(BaseModel):
    """
    Autogenerated input type of DeleteIssueComment
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteIssueCommentInput']] = Field(
        'DeleteIssueCommentInput', alias='__typename'
    )


class DeleteIssueInput(BaseModel):
    """
    Autogenerated input type of DeleteIssue
    """

    clientMutationId: Optional[String] = None
    issueId: ID
    typename__: Optional[Literal['DeleteIssueInput']] = Field(
        'DeleteIssueInput', alias='__typename'
    )


class DeleteLabelInput(BaseModel):
    """
    Autogenerated input type of DeleteLabel
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteLabelInput']] = Field(
        'DeleteLabelInput', alias='__typename'
    )


class DeleteLinkedBranchInput(BaseModel):
    """
    Autogenerated input type of DeleteLinkedBranch
    """

    clientMutationId: Optional[String] = None
    linkedBranchId: ID
    typename__: Optional[Literal['DeleteLinkedBranchInput']] = Field(
        'DeleteLinkedBranchInput', alias='__typename'
    )


class DeletePackageVersionInput(BaseModel):
    """
    Autogenerated input type of DeletePackageVersion
    """

    clientMutationId: Optional[String] = None
    packageVersionId: ID
    typename__: Optional[Literal['DeletePackageVersionInput']] = Field(
        'DeletePackageVersionInput', alias='__typename'
    )


class DeleteProjectCardInput(BaseModel):
    """
    Autogenerated input type of DeleteProjectCard
    """

    cardId: ID
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['DeleteProjectCardInput']] = Field(
        'DeleteProjectCardInput', alias='__typename'
    )


class DeleteProjectColumnInput(BaseModel):
    """
    Autogenerated input type of DeleteProjectColumn
    """

    clientMutationId: Optional[String] = None
    columnId: ID
    typename__: Optional[Literal['DeleteProjectColumnInput']] = Field(
        'DeleteProjectColumnInput', alias='__typename'
    )


class DeleteProjectInput(BaseModel):
    """
    Autogenerated input type of DeleteProject
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    typename__: Optional[Literal['DeleteProjectInput']] = Field(
        'DeleteProjectInput', alias='__typename'
    )


class DeleteProjectV2FieldInput(BaseModel):
    """
    Autogenerated input type of DeleteProjectV2Field
    """

    clientMutationId: Optional[String] = None
    fieldId: ID
    typename__: Optional[Literal['DeleteProjectV2FieldInput']] = Field(
        'DeleteProjectV2FieldInput', alias='__typename'
    )


class DeleteProjectV2Input(BaseModel):
    """
    Autogenerated input type of DeleteProjectV2
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    typename__: Optional[Literal['DeleteProjectV2Input']] = Field(
        'DeleteProjectV2Input', alias='__typename'
    )


class DeleteProjectV2ItemInput(BaseModel):
    """
    Autogenerated input type of DeleteProjectV2Item
    """

    clientMutationId: Optional[String] = None
    itemId: ID
    projectId: ID
    typename__: Optional[Literal['DeleteProjectV2ItemInput']] = Field(
        'DeleteProjectV2ItemInput', alias='__typename'
    )


class DeleteProjectV2WorkflowInput(BaseModel):
    """
    Autogenerated input type of DeleteProjectV2Workflow
    """

    clientMutationId: Optional[String] = None
    workflowId: ID
    typename__: Optional[Literal['DeleteProjectV2WorkflowInput']] = Field(
        'DeleteProjectV2WorkflowInput', alias='__typename'
    )


class DeletePullRequestReviewCommentInput(BaseModel):
    """
    Autogenerated input type of DeletePullRequestReviewComment
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeletePullRequestReviewCommentInput']] = Field(
        'DeletePullRequestReviewCommentInput', alias='__typename'
    )


class DeletePullRequestReviewInput(BaseModel):
    """
    Autogenerated input type of DeletePullRequestReview
    """

    clientMutationId: Optional[String] = None
    pullRequestReviewId: ID
    typename__: Optional[Literal['DeletePullRequestReviewInput']] = Field(
        'DeletePullRequestReviewInput', alias='__typename'
    )


class DeleteRefInput(BaseModel):
    """
    Autogenerated input type of DeleteRef
    """

    clientMutationId: Optional[String] = None
    refId: ID
    typename__: Optional[Literal['DeleteRefInput']] = Field(
        'DeleteRefInput', alias='__typename'
    )


class DeleteRepositoryRulesetInput(BaseModel):
    """
    Autogenerated input type of DeleteRepositoryRuleset
    """

    clientMutationId: Optional[String] = None
    repositoryRulesetId: ID
    typename__: Optional[Literal['DeleteRepositoryRulesetInput']] = Field(
        'DeleteRepositoryRulesetInput', alias='__typename'
    )


class DeleteTeamDiscussionCommentInput(BaseModel):
    """
    Autogenerated input type of DeleteTeamDiscussionComment
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteTeamDiscussionCommentInput']] = Field(
        'DeleteTeamDiscussionCommentInput', alias='__typename'
    )


class DeleteTeamDiscussionInput(BaseModel):
    """
    Autogenerated input type of DeleteTeamDiscussion
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteTeamDiscussionInput']] = Field(
        'DeleteTeamDiscussionInput', alias='__typename'
    )


class DeleteVerifiableDomainInput(BaseModel):
    """
    Autogenerated input type of DeleteVerifiableDomain
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DeleteVerifiableDomainInput']] = Field(
        'DeleteVerifiableDomainInput', alias='__typename'
    )


class DeploymentOrder(BaseModel):
    """
    Ordering options for deployment connections
    """

    direction: OrderDirection
    field: DeploymentOrderField
    typename__: Optional[Literal['DeploymentOrder']] = Field(
        'DeploymentOrder', alias='__typename'
    )


class DequeuePullRequestInput(BaseModel):
    """
    Autogenerated input type of DequeuePullRequest
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['DequeuePullRequestInput']] = Field(
        'DequeuePullRequestInput', alias='__typename'
    )


class DisablePullRequestAutoMergeInput(BaseModel):
    """
    Autogenerated input type of DisablePullRequestAutoMerge
    """

    clientMutationId: Optional[String] = None
    pullRequestId: ID
    typename__: Optional[Literal['DisablePullRequestAutoMergeInput']] = Field(
        'DisablePullRequestAutoMergeInput', alias='__typename'
    )


class DiscussionOrder(BaseModel):
    """
    Ways in which lists of discussions can be ordered upon return.
    """

    direction: OrderDirection
    field: DiscussionOrderField
    typename__: Optional[Literal['DiscussionOrder']] = Field(
        'DiscussionOrder', alias='__typename'
    )


class DiscussionPollOptionOrder(BaseModel):
    """
    Ordering options for discussion poll option connections.
    """

    direction: OrderDirection
    field: DiscussionPollOptionOrderField
    typename__: Optional[Literal['DiscussionPollOptionOrder']] = Field(
        'DiscussionPollOptionOrder', alias='__typename'
    )


class DismissPullRequestReviewInput(BaseModel):
    """
    Autogenerated input type of DismissPullRequestReview
    """

    clientMutationId: Optional[String] = None
    message: String
    pullRequestReviewId: ID
    typename__: Optional[Literal['DismissPullRequestReviewInput']] = Field(
        'DismissPullRequestReviewInput', alias='__typename'
    )


class DismissRepositoryVulnerabilityAlertInput(BaseModel):
    """
    Autogenerated input type of DismissRepositoryVulnerabilityAlert
    """

    clientMutationId: Optional[String] = None
    dismissReason: DismissReason
    repositoryVulnerabilityAlertId: ID
    typename__: Optional[Literal['DismissRepositoryVulnerabilityAlertInput']] = Field(
        'DismissRepositoryVulnerabilityAlertInput', alias='__typename'
    )


class DraftPullRequestReviewComment(BaseModel):
    """
    Specifies a review comment to be left with a Pull Request Review.
    """

    body: String
    path: String
    position: Int
    typename__: Optional[Literal['DraftPullRequestReviewComment']] = Field(
        'DraftPullRequestReviewComment', alias='__typename'
    )


class DraftPullRequestReviewThread(BaseModel):
    """
    Specifies a review comment thread to be left with a Pull Request Review.
    """

    body: String
    line: Int
    path: String
    side: Optional[DiffSide] = 'RIGHT'
    startLine: Optional[Int] = None
    startSide: Optional[DiffSide] = 'RIGHT'
    typename__: Optional[Literal['DraftPullRequestReviewThread']] = Field(
        'DraftPullRequestReviewThread', alias='__typename'
    )


class EnablePullRequestAutoMergeInput(BaseModel):
    """
    Autogenerated input type of EnablePullRequestAutoMerge
    """

    authorEmail: Optional[String] = None
    clientMutationId: Optional[String] = None
    commitBody: Optional[String] = None
    commitHeadline: Optional[String] = None
    expectedHeadOid: Optional[GitObjectID] = None
    mergeMethod: Optional[PullRequestMergeMethod] = 'MERGE'
    pullRequestId: ID
    typename__: Optional[Literal['EnablePullRequestAutoMergeInput']] = Field(
        'EnablePullRequestAutoMergeInput', alias='__typename'
    )


class EnqueuePullRequestInput(BaseModel):
    """
    Autogenerated input type of EnqueuePullRequest
    """

    clientMutationId: Optional[String] = None
    expectedHeadOid: Optional[GitObjectID] = None
    jump: Optional[Boolean] = None
    pullRequestId: ID
    typename__: Optional[Literal['EnqueuePullRequestInput']] = Field(
        'EnqueuePullRequestInput', alias='__typename'
    )


class EnterpriseAdministratorInvitationOrder(BaseModel):
    """
    Ordering options for enterprise administrator invitation connections
    """

    direction: OrderDirection
    field: EnterpriseAdministratorInvitationOrderField
    typename__: Optional[Literal['EnterpriseAdministratorInvitationOrder']] = Field(
        'EnterpriseAdministratorInvitationOrder', alias='__typename'
    )


class EnterpriseMemberOrder(BaseModel):
    """
    Ordering options for enterprise member connections.
    """

    direction: OrderDirection
    field: EnterpriseMemberOrderField
    typename__: Optional[Literal['EnterpriseMemberOrder']] = Field(
        'EnterpriseMemberOrder', alias='__typename'
    )


class EnterpriseOrder(BaseModel):
    """
    Ordering options for enterprises.
    """

    direction: OrderDirection
    field: EnterpriseOrderField
    typename__: Optional[Literal['EnterpriseOrder']] = Field(
        'EnterpriseOrder', alias='__typename'
    )


class EnterpriseServerInstallationOrder(BaseModel):
    """
    Ordering options for Enterprise Server installation connections.
    """

    direction: OrderDirection
    field: EnterpriseServerInstallationOrderField
    typename__: Optional[Literal['EnterpriseServerInstallationOrder']] = Field(
        'EnterpriseServerInstallationOrder', alias='__typename'
    )


class EnterpriseServerUserAccountEmailOrder(BaseModel):
    """
    Ordering options for Enterprise Server user account email connections.
    """

    direction: OrderDirection
    field: EnterpriseServerUserAccountEmailOrderField
    typename__: Optional[Literal['EnterpriseServerUserAccountEmailOrder']] = Field(
        'EnterpriseServerUserAccountEmailOrder', alias='__typename'
    )


class EnterpriseServerUserAccountOrder(BaseModel):
    """
    Ordering options for Enterprise Server user account connections.
    """

    direction: OrderDirection
    field: EnterpriseServerUserAccountOrderField
    typename__: Optional[Literal['EnterpriseServerUserAccountOrder']] = Field(
        'EnterpriseServerUserAccountOrder', alias='__typename'
    )


class EnterpriseServerUserAccountsUploadOrder(BaseModel):
    """
    Ordering options for Enterprise Server user accounts upload connections.
    """

    direction: OrderDirection
    field: EnterpriseServerUserAccountsUploadOrderField
    typename__: Optional[Literal['EnterpriseServerUserAccountsUploadOrder']] = Field(
        'EnterpriseServerUserAccountsUploadOrder', alias='__typename'
    )


class Environments(BaseModel):
    """
    Ordering options for environments
    """

    direction: OrderDirection
    field: EnvironmentOrderField
    typename__: Optional[Literal['Environments']] = Field(
        'Environments', alias='__typename'
    )


class FileAddition(BaseModel):
    """
    A command to add a file at the given path with the given contents as part of a
    commit.  Any existing file at that that path will be replaced.
    """

    contents: Base64String
    path: String
    typename__: Optional[Literal['FileAddition']] = Field(
        'FileAddition', alias='__typename'
    )


class FileChanges(BaseModel):
    """
    A description of a set of changes to a file tree to be made as part of
    a git commit, modeled as zero or more file `additions` and zero or more
    file `deletions`.

    Both fields are optional; omitting both will produce a commit with no
    file changes.

    `deletions` and `additions` describe changes to files identified
    by their path in the git tree using unix-style path separators, i.e.
    `/`.  The root of a git tree is an empty string, so paths are not
    slash-prefixed.

    `path` values must be unique across all `additions` and `deletions`
    provided.  Any duplication will result in a validation error.

    ### Encoding

    File contents must be provided in full for each `FileAddition`.

    The `contents` of a `FileAddition` must be encoded using RFC 4648
    compliant base64, i.e. correct padding is required and no characters
    outside the standard alphabet may be used.  Invalid base64
    encoding will be rejected with a validation error.

    The encoded contents may be binary.

    For text files, no assumptions are made about the character encoding of
    the file contents (after base64 decoding).  No charset transcoding or
    line-ending normalization will be performed; it is the client's
    responsibility to manage the character encoding of files they provide.
    However, for maximum compatibility we recommend using UTF-8 encoding
    and ensuring that all files in a repository use a consistent
    line-ending convention (`\n` or `\r\n`), and that all files end
    with a newline.

    ### Modeling file changes

    Each of the the five types of conceptual changes that can be made in a
    git commit can be described using the `FileChanges` type as follows:

    1. New file addition: create file `hello world\n` at path `docs/README.txt`:

           {
             "additions" [
               {
                 "path": "docs/README.txt",
                 "contents": base64encode("hello world\n")
               }
             ]
           }

    2. Existing file modification: change existing `docs/README.txt` to have new
       content `new content here\n`:

           {
             "additions" [
               {
                 "path": "docs/README.txt",
                 "contents": base64encode("new content here\n")
               }
             ]
           }

    3. Existing file deletion: remove existing file `docs/README.txt`.
       Note that the path is required to exist -- specifying a
       path that does not exist on the given branch will abort the
       commit and return an error.

           {
             "deletions" [
               {
                 "path": "docs/README.txt"
               }
             ]
           }


    4. File rename with no changes: rename `docs/README.txt` with
       previous content `hello world\n` to the same content at
       `newdocs/README.txt`:

           {
             "deletions" [
               {
                 "path": "docs/README.txt",
               }
             ],
             "additions" [
               {
                 "path": "newdocs/README.txt",
                 "contents": base64encode("hello world\n")
               }
             ]
           }


    5. File rename with changes: rename `docs/README.txt` with
       previous content `hello world\n` to a file at path
       `newdocs/README.txt` with content `new contents\n`:

           {
             "deletions" [
               {
                 "path": "docs/README.txt",
               }
             ],
             "additions" [
               {
                 "path": "newdocs/README.txt",
                 "contents": base64encode("new contents\n")
               }
             ]
           }
    """

    additions: Optional[List[FileAddition]] = []
    deletions: Optional[List[FileDeletion]] = []
    typename__: Optional[Literal['FileChanges']] = Field(
        'FileChanges', alias='__typename'
    )


class FileDeletion(BaseModel):
    """
    A command to delete the file at the given path as part of a commit.
    """

    path: String
    typename__: Optional[Literal['FileDeletion']] = Field(
        'FileDeletion', alias='__typename'
    )


class FollowOrganizationInput(BaseModel):
    """
    Autogenerated input type of FollowOrganization
    """

    clientMutationId: Optional[String] = None
    organizationId: ID
    typename__: Optional[Literal['FollowOrganizationInput']] = Field(
        'FollowOrganizationInput', alias='__typename'
    )


class FollowUserInput(BaseModel):
    """
    Autogenerated input type of FollowUser
    """

    clientMutationId: Optional[String] = None
    userId: ID
    typename__: Optional[Literal['FollowUserInput']] = Field(
        'FollowUserInput', alias='__typename'
    )


class GistOrder(BaseModel):
    """
    Ordering options for gist connections
    """

    direction: OrderDirection
    field: GistOrderField
    typename__: Optional[Literal['GistOrder']] = Field('GistOrder', alias='__typename')


class GrantEnterpriseOrganizationsMigratorRoleInput(BaseModel):
    """
    Autogenerated input type of GrantEnterpriseOrganizationsMigratorRole
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    login: String
    typename__: Optional[
        Literal['GrantEnterpriseOrganizationsMigratorRoleInput']
    ] = Field('GrantEnterpriseOrganizationsMigratorRoleInput', alias='__typename')


class GrantMigratorRoleInput(BaseModel):
    """
    Autogenerated input type of GrantMigratorRole
    """

    actor: String
    actorType: ActorType
    clientMutationId: Optional[String] = None
    organizationId: ID
    typename__: Optional[Literal['GrantMigratorRoleInput']] = Field(
        'GrantMigratorRoleInput', alias='__typename'
    )


class ImportProjectInput(BaseModel):
    """
    Autogenerated input type of ImportProject
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    columnImports: List[ProjectColumnImport]
    name: String
    ownerName: String
    public: Optional[Boolean] = False
    typename__: Optional[Literal['ImportProjectInput']] = Field(
        'ImportProjectInput', alias='__typename'
    )


class InviteEnterpriseAdminInput(BaseModel):
    """
    Autogenerated input type of InviteEnterpriseAdmin
    """

    clientMutationId: Optional[String] = None
    email: Optional[String] = None
    enterpriseId: ID
    invitee: Optional[String] = None
    role: Optional[EnterpriseAdministratorRole] = None
    typename__: Optional[Literal['InviteEnterpriseAdminInput']] = Field(
        'InviteEnterpriseAdminInput', alias='__typename'
    )


class IpAllowListEntryOrder(BaseModel):
    """
    Ordering options for IP allow list entry connections.
    """

    direction: OrderDirection
    field: IpAllowListEntryOrderField
    typename__: Optional[Literal['IpAllowListEntryOrder']] = Field(
        'IpAllowListEntryOrder', alias='__typename'
    )


class IssueCommentOrder(BaseModel):
    """
    Ways in which lists of issue comments can be ordered upon return.
    """

    direction: OrderDirection
    field: IssueCommentOrderField
    typename__: Optional[Literal['IssueCommentOrder']] = Field(
        'IssueCommentOrder', alias='__typename'
    )


class IssueFilters(BaseModel):
    """
    Ways in which to filter lists of issues.
    """

    assignee: Optional[String] = None
    createdBy: Optional[String] = None
    labels: Optional[List[String]] = None
    mentioned: Optional[String] = None
    milestone: Optional[String] = None
    milestoneNumber: Optional[String] = None
    since: Optional[DateTime] = None
    states: Optional[List[IssueState]] = None
    viewerSubscribed: Optional[Boolean] = False
    typename__: Optional[Literal['IssueFilters']] = Field(
        'IssueFilters', alias='__typename'
    )


class IssueOrder(BaseModel):
    """
    Ways in which lists of issues can be ordered upon return.
    """

    direction: OrderDirection
    field: IssueOrderField
    typename__: Optional[Literal['IssueOrder']] = Field(
        'IssueOrder', alias='__typename'
    )


class LabelOrder(BaseModel):
    """
    Ways in which lists of labels can be ordered upon return.
    """

    direction: OrderDirection
    field: LabelOrderField
    typename__: Optional[Literal['LabelOrder']] = Field(
        'LabelOrder', alias='__typename'
    )


class LanguageOrder(BaseModel):
    """
    Ordering options for language connections.
    """

    direction: OrderDirection
    field: LanguageOrderField
    typename__: Optional[Literal['LanguageOrder']] = Field(
        'LanguageOrder', alias='__typename'
    )


class LinkProjectV2ToRepositoryInput(BaseModel):
    """
    Autogenerated input type of LinkProjectV2ToRepository
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    repositoryId: ID
    typename__: Optional[Literal['LinkProjectV2ToRepositoryInput']] = Field(
        'LinkProjectV2ToRepositoryInput', alias='__typename'
    )


class LinkProjectV2ToTeamInput(BaseModel):
    """
    Autogenerated input type of LinkProjectV2ToTeam
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    teamId: ID
    typename__: Optional[Literal['LinkProjectV2ToTeamInput']] = Field(
        'LinkProjectV2ToTeamInput', alias='__typename'
    )


class LinkRepositoryToProjectInput(BaseModel):
    """
    Autogenerated input type of LinkRepositoryToProject
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    repositoryId: ID
    typename__: Optional[Literal['LinkRepositoryToProjectInput']] = Field(
        'LinkRepositoryToProjectInput', alias='__typename'
    )


class LockLockableInput(BaseModel):
    """
    Autogenerated input type of LockLockable
    """

    clientMutationId: Optional[String] = None
    lockReason: Optional[LockReason] = None
    lockableId: ID
    typename__: Optional[Literal['LockLockableInput']] = Field(
        'LockLockableInput', alias='__typename'
    )


class MannequinOrder(BaseModel):
    """
    Ordering options for mannequins.
    """

    direction: OrderDirection
    field: MannequinOrderField
    typename__: Optional[Literal['MannequinOrder']] = Field(
        'MannequinOrder', alias='__typename'
    )


class MarkDiscussionCommentAsAnswerInput(BaseModel):
    """
    Autogenerated input type of MarkDiscussionCommentAsAnswer
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['MarkDiscussionCommentAsAnswerInput']] = Field(
        'MarkDiscussionCommentAsAnswerInput', alias='__typename'
    )


class MarkFileAsViewedInput(BaseModel):
    """
    Autogenerated input type of MarkFileAsViewed
    """

    clientMutationId: Optional[String] = None
    path: String
    pullRequestId: ID
    typename__: Optional[Literal['MarkFileAsViewedInput']] = Field(
        'MarkFileAsViewedInput', alias='__typename'
    )


class MarkProjectV2AsTemplateInput(BaseModel):
    """
    Autogenerated input type of MarkProjectV2AsTemplate
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    typename__: Optional[Literal['MarkProjectV2AsTemplateInput']] = Field(
        'MarkProjectV2AsTemplateInput', alias='__typename'
    )


class MarkPullRequestReadyForReviewInput(BaseModel):
    """
    Autogenerated input type of MarkPullRequestReadyForReview
    """

    clientMutationId: Optional[String] = None
    pullRequestId: ID
    typename__: Optional[Literal['MarkPullRequestReadyForReviewInput']] = Field(
        'MarkPullRequestReadyForReviewInput', alias='__typename'
    )


class MergeBranchInput(BaseModel):
    """
    Autogenerated input type of MergeBranch
    """

    authorEmail: Optional[String] = None
    base: String
    clientMutationId: Optional[String] = None
    commitMessage: Optional[String] = None
    head: String
    repositoryId: ID
    typename__: Optional[Literal['MergeBranchInput']] = Field(
        'MergeBranchInput', alias='__typename'
    )


class MergePullRequestInput(BaseModel):
    """
    Autogenerated input type of MergePullRequest
    """

    authorEmail: Optional[String] = None
    clientMutationId: Optional[String] = None
    commitBody: Optional[String] = None
    commitHeadline: Optional[String] = None
    expectedHeadOid: Optional[GitObjectID] = None
    mergeMethod: Optional[PullRequestMergeMethod] = 'MERGE'
    pullRequestId: ID
    typename__: Optional[Literal['MergePullRequestInput']] = Field(
        'MergePullRequestInput', alias='__typename'
    )


class MilestoneOrder(BaseModel):
    """
    Ordering options for milestone connections.
    """

    direction: OrderDirection
    field: MilestoneOrderField
    typename__: Optional[Literal['MilestoneOrder']] = Field(
        'MilestoneOrder', alias='__typename'
    )


class MinimizeCommentInput(BaseModel):
    """
    Autogenerated input type of MinimizeComment
    """

    classifier: ReportedContentClassifiers
    clientMutationId: Optional[String] = None
    subjectId: ID
    typename__: Optional[Literal['MinimizeCommentInput']] = Field(
        'MinimizeCommentInput', alias='__typename'
    )


class MoveProjectCardInput(BaseModel):
    """
    Autogenerated input type of MoveProjectCard
    """

    afterCardId: Optional[ID] = None
    cardId: ID
    clientMutationId: Optional[String] = None
    columnId: ID
    typename__: Optional[Literal['MoveProjectCardInput']] = Field(
        'MoveProjectCardInput', alias='__typename'
    )


class MoveProjectColumnInput(BaseModel):
    """
    Autogenerated input type of MoveProjectColumn
    """

    afterColumnId: Optional[ID] = None
    clientMutationId: Optional[String] = None
    columnId: ID
    typename__: Optional[Literal['MoveProjectColumnInput']] = Field(
        'MoveProjectColumnInput', alias='__typename'
    )


class OrgEnterpriseOwnerOrder(BaseModel):
    """
    Ordering options for an organization's enterprise owner connections.
    """

    direction: OrderDirection
    field: OrgEnterpriseOwnerOrderField
    typename__: Optional[Literal['OrgEnterpriseOwnerOrder']] = Field(
        'OrgEnterpriseOwnerOrder', alias='__typename'
    )


class OrganizationOrder(BaseModel):
    """
    Ordering options for organization connections.
    """

    direction: OrderDirection
    field: OrganizationOrderField
    typename__: Optional[Literal['OrganizationOrder']] = Field(
        'OrganizationOrder', alias='__typename'
    )


class PackageFileOrder(BaseModel):
    """
    Ways in which lists of package files can be ordered upon return.
    """

    direction: Optional[OrderDirection] = None
    field: Optional[PackageFileOrderField] = None
    typename__: Optional[Literal['PackageFileOrder']] = Field(
        'PackageFileOrder', alias='__typename'
    )


class PackageOrder(BaseModel):
    """
    Ways in which lists of packages can be ordered upon return.
    """

    direction: Optional[OrderDirection] = None
    field: Optional[PackageOrderField] = None
    typename__: Optional[Literal['PackageOrder']] = Field(
        'PackageOrder', alias='__typename'
    )


class PackageVersionOrder(BaseModel):
    """
    Ways in which lists of package versions can be ordered upon return.
    """

    direction: Optional[OrderDirection] = None
    field: Optional[PackageVersionOrderField] = None
    typename__: Optional[Literal['PackageVersionOrder']] = Field(
        'PackageVersionOrder', alias='__typename'
    )


class PinIssueInput(BaseModel):
    """
    Autogenerated input type of PinIssue
    """

    clientMutationId: Optional[String] = None
    issueId: ID
    typename__: Optional[Literal['PinIssueInput']] = Field(
        'PinIssueInput', alias='__typename'
    )


class ProjectCardImport(BaseModel):
    """
    An issue or PR and its owning repository to be used in a project card.
    """

    number: Int
    repository: String
    typename__: Optional[Literal['ProjectCardImport']] = Field(
        'ProjectCardImport', alias='__typename'
    )


class ProjectColumnImport(BaseModel):
    """
    A project column and a list of its issues and PRs.
    """

    columnName: String
    issues: Optional[List[ProjectCardImport]] = None
    position: Int
    typename__: Optional[Literal['ProjectColumnImport']] = Field(
        'ProjectColumnImport', alias='__typename'
    )


class ProjectOrder(BaseModel):
    """
    Ways in which lists of projects can be ordered upon return.
    """

    direction: OrderDirection
    field: ProjectOrderField
    typename__: Optional[Literal['ProjectOrder']] = Field(
        'ProjectOrder', alias='__typename'
    )


class ProjectV2Collaborator(BaseModel):
    """
    A collaborator to update on a project. Only one of the userId or teamId should be provided.
    """

    role: ProjectV2Roles
    teamId: Optional[ID] = None
    userId: Optional[ID] = None
    typename__: Optional[Literal['ProjectV2Collaborator']] = Field(
        'ProjectV2Collaborator', alias='__typename'
    )


class ProjectV2FieldOrder(BaseModel):
    """
    Ordering options for project v2 field connections
    """

    direction: OrderDirection
    field: ProjectV2FieldOrderField
    typename__: Optional[Literal['ProjectV2FieldOrder']] = Field(
        'ProjectV2FieldOrder', alias='__typename'
    )


class ProjectV2FieldValue(BaseModel):
    """
    The values that can be used to update a field of an item inside a Project. Only 1 value can be updated at a time.
    """

    date: Optional[Date] = None
    iterationId: Optional[String] = None
    number: Optional[Float] = None
    singleSelectOptionId: Optional[String] = None
    text: Optional[String] = None
    typename__: Optional[Literal['ProjectV2FieldValue']] = Field(
        'ProjectV2FieldValue', alias='__typename'
    )


class ProjectV2Filters(BaseModel):
    """
    Ways in which to filter lists of projects.
    """

    state: Optional[ProjectV2State] = None
    typename__: Optional[Literal['ProjectV2Filters']] = Field(
        'ProjectV2Filters', alias='__typename'
    )


class ProjectV2ItemFieldValueOrder(BaseModel):
    """
    Ordering options for project v2 item field value connections
    """

    direction: OrderDirection
    field: ProjectV2ItemFieldValueOrderField
    typename__: Optional[Literal['ProjectV2ItemFieldValueOrder']] = Field(
        'ProjectV2ItemFieldValueOrder', alias='__typename'
    )


class ProjectV2ItemOrder(BaseModel):
    """
    Ordering options for project v2 item connections
    """

    direction: OrderDirection
    field: ProjectV2ItemOrderField
    typename__: Optional[Literal['ProjectV2ItemOrder']] = Field(
        'ProjectV2ItemOrder', alias='__typename'
    )


class ProjectV2Order(BaseModel):
    """
    Ways in which lists of projects can be ordered upon return.
    """

    direction: OrderDirection
    field: ProjectV2OrderField
    typename__: Optional[Literal['ProjectV2Order']] = Field(
        'ProjectV2Order', alias='__typename'
    )


class ProjectV2SingleSelectFieldOptionInput(BaseModel):
    """
    Represents a single select field option
    """

    color: ProjectV2SingleSelectFieldOptionColor
    description: String
    name: String
    typename__: Optional[Literal['ProjectV2SingleSelectFieldOptionInput']] = Field(
        'ProjectV2SingleSelectFieldOptionInput', alias='__typename'
    )


class ProjectV2ViewOrder(BaseModel):
    """
    Ordering options for project v2 view connections
    """

    direction: OrderDirection
    field: ProjectV2ViewOrderField
    typename__: Optional[Literal['ProjectV2ViewOrder']] = Field(
        'ProjectV2ViewOrder', alias='__typename'
    )


class ProjectV2WorkflowOrder(BaseModel):
    """
    Ordering options for project v2 workflows connections
    """

    direction: OrderDirection
    field: ProjectV2WorkflowsOrderField
    typename__: Optional[Literal['ProjectV2WorkflowOrder']] = Field(
        'ProjectV2WorkflowOrder', alias='__typename'
    )


class PublishSponsorsTierInput(BaseModel):
    """
    Autogenerated input type of PublishSponsorsTier
    """

    clientMutationId: Optional[String] = None
    tierId: ID
    typename__: Optional[Literal['PublishSponsorsTierInput']] = Field(
        'PublishSponsorsTierInput', alias='__typename'
    )


class PullRequestOrder(BaseModel):
    """
    Ways in which lists of issues can be ordered upon return.
    """

    direction: OrderDirection
    field: PullRequestOrderField
    typename__: Optional[Literal['PullRequestOrder']] = Field(
        'PullRequestOrder', alias='__typename'
    )


class PullRequestParametersInput(BaseModel):
    """
    Require all commits be made to a non-target branch and submitted via a pull request before they can be merged.
    """

    dismissStaleReviewsOnPush: Boolean
    requireCodeOwnerReview: Boolean
    requireLastPushApproval: Boolean
    requiredApprovingReviewCount: Int
    requiredReviewThreadResolution: Boolean
    typename__: Optional[Literal['PullRequestParametersInput']] = Field(
        'PullRequestParametersInput', alias='__typename'
    )


class ReactionOrder(BaseModel):
    """
    Ways in which lists of reactions can be ordered upon return.
    """

    direction: OrderDirection
    field: ReactionOrderField
    typename__: Optional[Literal['ReactionOrder']] = Field(
        'ReactionOrder', alias='__typename'
    )


class RefNameConditionTargetInput(BaseModel):
    """
    Parameters to be used for the ref_name condition
    """

    exclude: List[String]
    include: List[String]
    typename__: Optional[Literal['RefNameConditionTargetInput']] = Field(
        'RefNameConditionTargetInput', alias='__typename'
    )


class RefOrder(BaseModel):
    """
    Ways in which lists of git refs can be ordered upon return.
    """

    direction: OrderDirection
    field: RefOrderField
    typename__: Optional[Literal['RefOrder']] = Field('RefOrder', alias='__typename')


class RefUpdate(BaseModel):
    """
    A ref update
    """

    afterOid: GitObjectID
    beforeOid: Optional[GitObjectID] = None
    force: Optional[Boolean] = False
    name: GitRefname
    typename__: Optional[Literal['RefUpdate']] = Field('RefUpdate', alias='__typename')


class RegenerateEnterpriseIdentityProviderRecoveryCodesInput(BaseModel):
    """
    Autogenerated input type of RegenerateEnterpriseIdentityProviderRecoveryCodes
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    typename__: Optional[
        Literal['RegenerateEnterpriseIdentityProviderRecoveryCodesInput']
    ] = Field(
        'RegenerateEnterpriseIdentityProviderRecoveryCodesInput', alias='__typename'
    )


class RegenerateVerifiableDomainTokenInput(BaseModel):
    """
    Autogenerated input type of RegenerateVerifiableDomainToken
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['RegenerateVerifiableDomainTokenInput']] = Field(
        'RegenerateVerifiableDomainTokenInput', alias='__typename'
    )


class RejectDeploymentsInput(BaseModel):
    """
    Autogenerated input type of RejectDeployments
    """

    clientMutationId: Optional[String] = None
    comment: Optional[String] = ''
    environmentIds: List[ID]
    workflowRunId: ID
    typename__: Optional[Literal['RejectDeploymentsInput']] = Field(
        'RejectDeploymentsInput', alias='__typename'
    )


class ReleaseOrder(BaseModel):
    """
    Ways in which lists of releases can be ordered upon return.
    """

    direction: OrderDirection
    field: ReleaseOrderField
    typename__: Optional[Literal['ReleaseOrder']] = Field(
        'ReleaseOrder', alias='__typename'
    )


class RemoveAssigneesFromAssignableInput(BaseModel):
    """
    Autogenerated input type of RemoveAssigneesFromAssignable
    """

    assignableId: ID
    assigneeIds: List[ID]
    clientMutationId: Optional[String] = None
    typename__: Optional[Literal['RemoveAssigneesFromAssignableInput']] = Field(
        'RemoveAssigneesFromAssignableInput', alias='__typename'
    )


class RemoveEnterpriseAdminInput(BaseModel):
    """
    Autogenerated input type of RemoveEnterpriseAdmin
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    login: String
    typename__: Optional[Literal['RemoveEnterpriseAdminInput']] = Field(
        'RemoveEnterpriseAdminInput', alias='__typename'
    )


class RemoveEnterpriseIdentityProviderInput(BaseModel):
    """
    Autogenerated input type of RemoveEnterpriseIdentityProvider
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    typename__: Optional[Literal['RemoveEnterpriseIdentityProviderInput']] = Field(
        'RemoveEnterpriseIdentityProviderInput', alias='__typename'
    )


class RemoveEnterpriseMemberInput(BaseModel):
    """
    Autogenerated input type of RemoveEnterpriseMember
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    userId: ID
    typename__: Optional[Literal['RemoveEnterpriseMemberInput']] = Field(
        'RemoveEnterpriseMemberInput', alias='__typename'
    )


class RemoveEnterpriseOrganizationInput(BaseModel):
    """
    Autogenerated input type of RemoveEnterpriseOrganization
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    organizationId: ID
    typename__: Optional[Literal['RemoveEnterpriseOrganizationInput']] = Field(
        'RemoveEnterpriseOrganizationInput', alias='__typename'
    )


class RemoveEnterpriseSupportEntitlementInput(BaseModel):
    """
    Autogenerated input type of RemoveEnterpriseSupportEntitlement
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    login: String
    typename__: Optional[Literal['RemoveEnterpriseSupportEntitlementInput']] = Field(
        'RemoveEnterpriseSupportEntitlementInput', alias='__typename'
    )


class RemoveLabelsFromLabelableInput(BaseModel):
    """
    Autogenerated input type of RemoveLabelsFromLabelable
    """

    clientMutationId: Optional[String] = None
    labelIds: List[ID]
    labelableId: ID
    typename__: Optional[Literal['RemoveLabelsFromLabelableInput']] = Field(
        'RemoveLabelsFromLabelableInput', alias='__typename'
    )


class RemoveOutsideCollaboratorInput(BaseModel):
    """
    Autogenerated input type of RemoveOutsideCollaborator
    """

    clientMutationId: Optional[String] = None
    organizationId: ID
    userId: ID
    typename__: Optional[Literal['RemoveOutsideCollaboratorInput']] = Field(
        'RemoveOutsideCollaboratorInput', alias='__typename'
    )


class RemoveReactionInput(BaseModel):
    """
    Autogenerated input type of RemoveReaction
    """

    clientMutationId: Optional[String] = None
    content: ReactionContent
    subjectId: ID
    typename__: Optional[Literal['RemoveReactionInput']] = Field(
        'RemoveReactionInput', alias='__typename'
    )


class RemoveStarInput(BaseModel):
    """
    Autogenerated input type of RemoveStar
    """

    clientMutationId: Optional[String] = None
    starrableId: ID
    typename__: Optional[Literal['RemoveStarInput']] = Field(
        'RemoveStarInput', alias='__typename'
    )


class RemoveUpvoteInput(BaseModel):
    """
    Autogenerated input type of RemoveUpvote
    """

    clientMutationId: Optional[String] = None
    subjectId: ID
    typename__: Optional[Literal['RemoveUpvoteInput']] = Field(
        'RemoveUpvoteInput', alias='__typename'
    )


class ReopenDiscussionInput(BaseModel):
    """
    Autogenerated input type of ReopenDiscussion
    """

    clientMutationId: Optional[String] = None
    discussionId: ID
    typename__: Optional[Literal['ReopenDiscussionInput']] = Field(
        'ReopenDiscussionInput', alias='__typename'
    )


class ReopenIssueInput(BaseModel):
    """
    Autogenerated input type of ReopenIssue
    """

    clientMutationId: Optional[String] = None
    issueId: ID
    typename__: Optional[Literal['ReopenIssueInput']] = Field(
        'ReopenIssueInput', alias='__typename'
    )


class ReopenPullRequestInput(BaseModel):
    """
    Autogenerated input type of ReopenPullRequest
    """

    clientMutationId: Optional[String] = None
    pullRequestId: ID
    typename__: Optional[Literal['ReopenPullRequestInput']] = Field(
        'ReopenPullRequestInput', alias='__typename'
    )


class RepositoryIdConditionTargetInput(BaseModel):
    """
    Parameters to be used for the repository_id condition
    """

    repositoryIds: List[ID]
    typename__: Optional[Literal['RepositoryIdConditionTargetInput']] = Field(
        'RepositoryIdConditionTargetInput', alias='__typename'
    )


class RepositoryInvitationOrder(BaseModel):
    """
    Ordering options for repository invitation connections.
    """

    direction: OrderDirection
    field: RepositoryInvitationOrderField
    typename__: Optional[Literal['RepositoryInvitationOrder']] = Field(
        'RepositoryInvitationOrder', alias='__typename'
    )


class RepositoryMigrationOrder(BaseModel):
    """
    Ordering options for repository migrations.
    """

    direction: RepositoryMigrationOrderDirection
    field: RepositoryMigrationOrderField
    typename__: Optional[Literal['RepositoryMigrationOrder']] = Field(
        'RepositoryMigrationOrder', alias='__typename'
    )


class RepositoryNameConditionTargetInput(BaseModel):
    """
    Parameters to be used for the repository_name condition
    """

    exclude: List[String]
    include: List[String]
    protected: Optional[Boolean] = None
    typename__: Optional[Literal['RepositoryNameConditionTargetInput']] = Field(
        'RepositoryNameConditionTargetInput', alias='__typename'
    )


class RepositoryOrder(BaseModel):
    """
    Ordering options for repository connections
    """

    direction: OrderDirection
    field: RepositoryOrderField
    typename__: Optional[Literal['RepositoryOrder']] = Field(
        'RepositoryOrder', alias='__typename'
    )


class RepositoryRuleConditionsInput(BaseModel):
    """
    Specifies the conditions required for a ruleset to evaluate
    """

    refName: Optional[RefNameConditionTargetInput] = None
    repositoryId: Optional[RepositoryIdConditionTargetInput] = None
    repositoryName: Optional[RepositoryNameConditionTargetInput] = None
    typename__: Optional[Literal['RepositoryRuleConditionsInput']] = Field(
        'RepositoryRuleConditionsInput', alias='__typename'
    )


class RepositoryRuleInput(BaseModel):
    """
    Specifies the attributes for a new or updated rule.
    """

    id: Optional[ID] = None
    parameters: Optional[RuleParametersInput] = None
    type: RepositoryRuleType
    typename__: Optional[Literal['RepositoryRuleInput']] = Field(
        'RepositoryRuleInput', alias='__typename'
    )


class RepositoryRulesetBypassActorInput(BaseModel):
    """
    Specifies the attributes for a new or updated ruleset bypass actor. Only one of
    `actor_id`, `repository_role_database_id`, or `organization_admin` should be specified.
    """

    actorId: Optional[ID] = None
    bypassMode: RepositoryRulesetBypassActorBypassMode
    organizationAdmin: Optional[Boolean] = None
    repositoryRoleDatabaseId: Optional[Int] = None
    typename__: Optional[Literal['RepositoryRulesetBypassActorInput']] = Field(
        'RepositoryRulesetBypassActorInput', alias='__typename'
    )


class RequestReviewsInput(BaseModel):
    """
    Autogenerated input type of RequestReviews
    """

    clientMutationId: Optional[String] = None
    pullRequestId: ID
    teamIds: Optional[List[ID]] = None
    union: Optional[Boolean] = False
    userIds: Optional[List[ID]] = None
    typename__: Optional[Literal['RequestReviewsInput']] = Field(
        'RequestReviewsInput', alias='__typename'
    )


class RequiredDeploymentsParametersInput(BaseModel):
    """
    Choose which environments must be successfully deployed to before refs can be pushed into a ref that matches this rule.
    """

    requiredDeploymentEnvironments: List[String]
    typename__: Optional[Literal['RequiredDeploymentsParametersInput']] = Field(
        'RequiredDeploymentsParametersInput', alias='__typename'
    )


class RequiredStatusCheckInput(BaseModel):
    """
    Specifies the attributes for a new or updated required status check.
    """

    appId: Optional[ID] = None
    context: String
    typename__: Optional[Literal['RequiredStatusCheckInput']] = Field(
        'RequiredStatusCheckInput', alias='__typename'
    )


class RequiredStatusChecksParametersInput(BaseModel):
    """
    Choose which status checks must pass before the ref is updated. When enabled,
    commits must first be pushed to another ref where the checks pass.
    """

    requiredStatusChecks: List[StatusCheckConfigurationInput]
    strictRequiredStatusChecksPolicy: Boolean
    typename__: Optional[Literal['RequiredStatusChecksParametersInput']] = Field(
        'RequiredStatusChecksParametersInput', alias='__typename'
    )


class RerequestCheckSuiteInput(BaseModel):
    """
    Autogenerated input type of RerequestCheckSuite
    """

    checkSuiteId: ID
    clientMutationId: Optional[String] = None
    repositoryId: ID
    typename__: Optional[Literal['RerequestCheckSuiteInput']] = Field(
        'RerequestCheckSuiteInput', alias='__typename'
    )


class ResolveReviewThreadInput(BaseModel):
    """
    Autogenerated input type of ResolveReviewThread
    """

    clientMutationId: Optional[String] = None
    threadId: ID
    typename__: Optional[Literal['ResolveReviewThreadInput']] = Field(
        'ResolveReviewThreadInput', alias='__typename'
    )


class RetireSponsorsTierInput(BaseModel):
    """
    Autogenerated input type of RetireSponsorsTier
    """

    clientMutationId: Optional[String] = None
    tierId: ID
    typename__: Optional[Literal['RetireSponsorsTierInput']] = Field(
        'RetireSponsorsTierInput', alias='__typename'
    )


class RevertPullRequestInput(BaseModel):
    """
    Autogenerated input type of RevertPullRequest
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    draft: Optional[Boolean] = False
    pullRequestId: ID
    title: Optional[String] = None
    typename__: Optional[Literal['RevertPullRequestInput']] = Field(
        'RevertPullRequestInput', alias='__typename'
    )


class RevokeEnterpriseOrganizationsMigratorRoleInput(BaseModel):
    """
    Autogenerated input type of RevokeEnterpriseOrganizationsMigratorRole
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    login: String
    typename__: Optional[
        Literal['RevokeEnterpriseOrganizationsMigratorRoleInput']
    ] = Field('RevokeEnterpriseOrganizationsMigratorRoleInput', alias='__typename')


class RevokeMigratorRoleInput(BaseModel):
    """
    Autogenerated input type of RevokeMigratorRole
    """

    actor: String
    actorType: ActorType
    clientMutationId: Optional[String] = None
    organizationId: ID
    typename__: Optional[Literal['RevokeMigratorRoleInput']] = Field(
        'RevokeMigratorRoleInput', alias='__typename'
    )


class RuleParametersInput(BaseModel):
    """
    Specifies the parameters for a `RepositoryRule` object. Only one of the fields should be specified.
    """

    branchNamePattern: Optional[BranchNamePatternParametersInput] = None
    commitAuthorEmailPattern: Optional[CommitAuthorEmailPatternParametersInput] = None
    commitMessagePattern: Optional[CommitMessagePatternParametersInput] = None
    committerEmailPattern: Optional[CommitterEmailPatternParametersInput] = None
    pullRequest: Optional[PullRequestParametersInput] = None
    requiredDeployments: Optional[RequiredDeploymentsParametersInput] = None
    requiredStatusChecks: Optional[RequiredStatusChecksParametersInput] = None
    tagNamePattern: Optional[TagNamePatternParametersInput] = None
    update: Optional[UpdateParametersInput] = None
    workflows: Optional[WorkflowsParametersInput] = None
    typename__: Optional[Literal['RuleParametersInput']] = Field(
        'RuleParametersInput', alias='__typename'
    )


class SavedReplyOrder(BaseModel):
    """
    Ordering options for saved reply connections.
    """

    direction: OrderDirection
    field: SavedReplyOrderField
    typename__: Optional[Literal['SavedReplyOrder']] = Field(
        'SavedReplyOrder', alias='__typename'
    )


class SecurityAdvisoryIdentifierFilter(BaseModel):
    """
    An advisory identifier to filter results on.
    """

    type: SecurityAdvisoryIdentifierType
    value: String
    typename__: Optional[Literal['SecurityAdvisoryIdentifierFilter']] = Field(
        'SecurityAdvisoryIdentifierFilter', alias='__typename'
    )


class SecurityAdvisoryOrder(BaseModel):
    """
    Ordering options for security advisory connections
    """

    direction: OrderDirection
    field: SecurityAdvisoryOrderField
    typename__: Optional[Literal['SecurityAdvisoryOrder']] = Field(
        'SecurityAdvisoryOrder', alias='__typename'
    )


class SecurityVulnerabilityOrder(BaseModel):
    """
    Ordering options for security vulnerability connections
    """

    direction: OrderDirection
    field: SecurityVulnerabilityOrderField
    typename__: Optional[Literal['SecurityVulnerabilityOrder']] = Field(
        'SecurityVulnerabilityOrder', alias='__typename'
    )


class SetEnterpriseIdentityProviderInput(BaseModel):
    """
    Autogenerated input type of SetEnterpriseIdentityProvider
    """

    clientMutationId: Optional[String] = None
    digestMethod: SamlDigestAlgorithm
    enterpriseId: ID
    idpCertificate: String
    issuer: Optional[String] = None
    signatureMethod: SamlSignatureAlgorithm
    ssoUrl: URI
    typename__: Optional[Literal['SetEnterpriseIdentityProviderInput']] = Field(
        'SetEnterpriseIdentityProviderInput', alias='__typename'
    )


class SetOrganizationInteractionLimitInput(BaseModel):
    """
    Autogenerated input type of SetOrganizationInteractionLimit
    """

    clientMutationId: Optional[String] = None
    expiry: Optional[RepositoryInteractionLimitExpiry] = None
    limit: RepositoryInteractionLimit
    organizationId: ID
    typename__: Optional[Literal['SetOrganizationInteractionLimitInput']] = Field(
        'SetOrganizationInteractionLimitInput', alias='__typename'
    )


class SetRepositoryInteractionLimitInput(BaseModel):
    """
    Autogenerated input type of SetRepositoryInteractionLimit
    """

    clientMutationId: Optional[String] = None
    expiry: Optional[RepositoryInteractionLimitExpiry] = None
    limit: RepositoryInteractionLimit
    repositoryId: ID
    typename__: Optional[Literal['SetRepositoryInteractionLimitInput']] = Field(
        'SetRepositoryInteractionLimitInput', alias='__typename'
    )


class SetUserInteractionLimitInput(BaseModel):
    """
    Autogenerated input type of SetUserInteractionLimit
    """

    clientMutationId: Optional[String] = None
    expiry: Optional[RepositoryInteractionLimitExpiry] = None
    limit: RepositoryInteractionLimit
    userId: ID
    typename__: Optional[Literal['SetUserInteractionLimitInput']] = Field(
        'SetUserInteractionLimitInput', alias='__typename'
    )


class SponsorOrder(BaseModel):
    """
    Ordering options for connections to get sponsor entities for GitHub Sponsors.
    """

    direction: OrderDirection
    field: SponsorOrderField
    typename__: Optional[Literal['SponsorOrder']] = Field(
        'SponsorOrder', alias='__typename'
    )


class SponsorableOrder(BaseModel):
    """
    Ordering options for connections to get sponsorable entities for GitHub Sponsors.
    """

    direction: OrderDirection
    field: SponsorableOrderField
    typename__: Optional[Literal['SponsorableOrder']] = Field(
        'SponsorableOrder', alias='__typename'
    )


class SponsorsActivityOrder(BaseModel):
    """
    Ordering options for GitHub Sponsors activity connections.
    """

    direction: OrderDirection
    field: SponsorsActivityOrderField
    typename__: Optional[Literal['SponsorsActivityOrder']] = Field(
        'SponsorsActivityOrder', alias='__typename'
    )


class SponsorsTierOrder(BaseModel):
    """
    Ordering options for Sponsors tiers connections.
    """

    direction: OrderDirection
    field: SponsorsTierOrderField
    typename__: Optional[Literal['SponsorsTierOrder']] = Field(
        'SponsorsTierOrder', alias='__typename'
    )


class SponsorshipNewsletterOrder(BaseModel):
    """
    Ordering options for sponsorship newsletter connections.
    """

    direction: OrderDirection
    field: SponsorshipNewsletterOrderField
    typename__: Optional[Literal['SponsorshipNewsletterOrder']] = Field(
        'SponsorshipNewsletterOrder', alias='__typename'
    )


class SponsorshipOrder(BaseModel):
    """
    Ordering options for sponsorship connections.
    """

    direction: OrderDirection
    field: SponsorshipOrderField
    typename__: Optional[Literal['SponsorshipOrder']] = Field(
        'SponsorshipOrder', alias='__typename'
    )


class StarOrder(BaseModel):
    """
    Ways in which star connections can be ordered.
    """

    direction: OrderDirection
    field: StarOrderField
    typename__: Optional[Literal['StarOrder']] = Field('StarOrder', alias='__typename')


class StartOrganizationMigrationInput(BaseModel):
    """
    Autogenerated input type of StartOrganizationMigration
    """

    clientMutationId: Optional[String] = None
    sourceAccessToken: String
    sourceOrgUrl: URI
    targetEnterpriseId: ID
    targetOrgName: String
    typename__: Optional[Literal['StartOrganizationMigrationInput']] = Field(
        'StartOrganizationMigrationInput', alias='__typename'
    )


class StartRepositoryMigrationInput(BaseModel):
    """
    Autogenerated input type of StartRepositoryMigration
    """

    accessToken: Optional[String] = None
    clientMutationId: Optional[String] = None
    continueOnError: Optional[Boolean] = None
    gitArchiveUrl: Optional[String] = None
    githubPat: Optional[String] = None
    lockSource: Optional[Boolean] = None
    metadataArchiveUrl: Optional[String] = None
    ownerId: ID
    repositoryName: String
    skipReleases: Optional[Boolean] = None
    sourceId: ID
    sourceRepositoryUrl: Optional[URI] = None
    targetRepoVisibility: Optional[String] = None
    typename__: Optional[Literal['StartRepositoryMigrationInput']] = Field(
        'StartRepositoryMigrationInput', alias='__typename'
    )


class StatusCheckConfigurationInput(BaseModel):
    """
    Required status check
    """

    context: String
    integrationId: Optional[Int] = None
    typename__: Optional[Literal['StatusCheckConfigurationInput']] = Field(
        'StatusCheckConfigurationInput', alias='__typename'
    )


class SubmitPullRequestReviewInput(BaseModel):
    """
    Autogenerated input type of SubmitPullRequestReview
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    event: PullRequestReviewEvent
    pullRequestId: Optional[ID] = None
    pullRequestReviewId: Optional[ID] = None
    typename__: Optional[Literal['SubmitPullRequestReviewInput']] = Field(
        'SubmitPullRequestReviewInput', alias='__typename'
    )


class TagNamePatternParametersInput(BaseModel):
    """
    Parameters to be used for the tag_name_pattern rule
    """

    name: Optional[String] = None
    negate: Optional[Boolean] = None
    operator: String
    pattern: String
    typename__: Optional[Literal['TagNamePatternParametersInput']] = Field(
        'TagNamePatternParametersInput', alias='__typename'
    )


class TeamDiscussionCommentOrder(BaseModel):
    """
    Ways in which team discussion comment connections can be ordered.
    """

    direction: OrderDirection
    field: TeamDiscussionCommentOrderField
    typename__: Optional[Literal['TeamDiscussionCommentOrder']] = Field(
        'TeamDiscussionCommentOrder', alias='__typename'
    )


class TeamDiscussionOrder(BaseModel):
    """
    Ways in which team discussion connections can be ordered.
    """

    direction: OrderDirection
    field: TeamDiscussionOrderField
    typename__: Optional[Literal['TeamDiscussionOrder']] = Field(
        'TeamDiscussionOrder', alias='__typename'
    )


class TeamMemberOrder(BaseModel):
    """
    Ordering options for team member connections
    """

    direction: OrderDirection
    field: TeamMemberOrderField
    typename__: Optional[Literal['TeamMemberOrder']] = Field(
        'TeamMemberOrder', alias='__typename'
    )


class TeamOrder(BaseModel):
    """
    Ways in which team connections can be ordered.
    """

    direction: OrderDirection
    field: TeamOrderField
    typename__: Optional[Literal['TeamOrder']] = Field('TeamOrder', alias='__typename')


class TeamRepositoryOrder(BaseModel):
    """
    Ordering options for team repository connections
    """

    direction: OrderDirection
    field: TeamRepositoryOrderField
    typename__: Optional[Literal['TeamRepositoryOrder']] = Field(
        'TeamRepositoryOrder', alias='__typename'
    )


class TransferEnterpriseOrganizationInput(BaseModel):
    """
    Autogenerated input type of TransferEnterpriseOrganization
    """

    clientMutationId: Optional[String] = None
    destinationEnterpriseId: ID
    organizationId: ID
    typename__: Optional[Literal['TransferEnterpriseOrganizationInput']] = Field(
        'TransferEnterpriseOrganizationInput', alias='__typename'
    )


class TransferIssueInput(BaseModel):
    """
    Autogenerated input type of TransferIssue
    """

    clientMutationId: Optional[String] = None
    createLabelsIfMissing: Optional[Boolean] = False
    issueId: ID
    repositoryId: ID
    typename__: Optional[Literal['TransferIssueInput']] = Field(
        'TransferIssueInput', alias='__typename'
    )


class UnarchiveProjectV2ItemInput(BaseModel):
    """
    Autogenerated input type of UnarchiveProjectV2Item
    """

    clientMutationId: Optional[String] = None
    itemId: ID
    projectId: ID
    typename__: Optional[Literal['UnarchiveProjectV2ItemInput']] = Field(
        'UnarchiveProjectV2ItemInput', alias='__typename'
    )


class UnarchiveRepositoryInput(BaseModel):
    """
    Autogenerated input type of UnarchiveRepository
    """

    clientMutationId: Optional[String] = None
    repositoryId: ID
    typename__: Optional[Literal['UnarchiveRepositoryInput']] = Field(
        'UnarchiveRepositoryInput', alias='__typename'
    )


class UnfollowOrganizationInput(BaseModel):
    """
    Autogenerated input type of UnfollowOrganization
    """

    clientMutationId: Optional[String] = None
    organizationId: ID
    typename__: Optional[Literal['UnfollowOrganizationInput']] = Field(
        'UnfollowOrganizationInput', alias='__typename'
    )


class UnfollowUserInput(BaseModel):
    """
    Autogenerated input type of UnfollowUser
    """

    clientMutationId: Optional[String] = None
    userId: ID
    typename__: Optional[Literal['UnfollowUserInput']] = Field(
        'UnfollowUserInput', alias='__typename'
    )


class UnlinkProjectV2FromRepositoryInput(BaseModel):
    """
    Autogenerated input type of UnlinkProjectV2FromRepository
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    repositoryId: ID
    typename__: Optional[Literal['UnlinkProjectV2FromRepositoryInput']] = Field(
        'UnlinkProjectV2FromRepositoryInput', alias='__typename'
    )


class UnlinkProjectV2FromTeamInput(BaseModel):
    """
    Autogenerated input type of UnlinkProjectV2FromTeam
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    teamId: ID
    typename__: Optional[Literal['UnlinkProjectV2FromTeamInput']] = Field(
        'UnlinkProjectV2FromTeamInput', alias='__typename'
    )


class UnlinkRepositoryFromProjectInput(BaseModel):
    """
    Autogenerated input type of UnlinkRepositoryFromProject
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    repositoryId: ID
    typename__: Optional[Literal['UnlinkRepositoryFromProjectInput']] = Field(
        'UnlinkRepositoryFromProjectInput', alias='__typename'
    )


class UnlockLockableInput(BaseModel):
    """
    Autogenerated input type of UnlockLockable
    """

    clientMutationId: Optional[String] = None
    lockableId: ID
    typename__: Optional[Literal['UnlockLockableInput']] = Field(
        'UnlockLockableInput', alias='__typename'
    )


class UnmarkDiscussionCommentAsAnswerInput(BaseModel):
    """
    Autogenerated input type of UnmarkDiscussionCommentAsAnswer
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['UnmarkDiscussionCommentAsAnswerInput']] = Field(
        'UnmarkDiscussionCommentAsAnswerInput', alias='__typename'
    )


class UnmarkFileAsViewedInput(BaseModel):
    """
    Autogenerated input type of UnmarkFileAsViewed
    """

    clientMutationId: Optional[String] = None
    path: String
    pullRequestId: ID
    typename__: Optional[Literal['UnmarkFileAsViewedInput']] = Field(
        'UnmarkFileAsViewedInput', alias='__typename'
    )


class UnmarkIssueAsDuplicateInput(BaseModel):
    """
    Autogenerated input type of UnmarkIssueAsDuplicate
    """

    canonicalId: ID
    clientMutationId: Optional[String] = None
    duplicateId: ID
    typename__: Optional[Literal['UnmarkIssueAsDuplicateInput']] = Field(
        'UnmarkIssueAsDuplicateInput', alias='__typename'
    )


class UnmarkProjectV2AsTemplateInput(BaseModel):
    """
    Autogenerated input type of UnmarkProjectV2AsTemplate
    """

    clientMutationId: Optional[String] = None
    projectId: ID
    typename__: Optional[Literal['UnmarkProjectV2AsTemplateInput']] = Field(
        'UnmarkProjectV2AsTemplateInput', alias='__typename'
    )


class UnminimizeCommentInput(BaseModel):
    """
    Autogenerated input type of UnminimizeComment
    """

    clientMutationId: Optional[String] = None
    subjectId: ID
    typename__: Optional[Literal['UnminimizeCommentInput']] = Field(
        'UnminimizeCommentInput', alias='__typename'
    )


class UnpinIssueInput(BaseModel):
    """
    Autogenerated input type of UnpinIssue
    """

    clientMutationId: Optional[String] = None
    issueId: ID
    typename__: Optional[Literal['UnpinIssueInput']] = Field(
        'UnpinIssueInput', alias='__typename'
    )


class UnresolveReviewThreadInput(BaseModel):
    """
    Autogenerated input type of UnresolveReviewThread
    """

    clientMutationId: Optional[String] = None
    threadId: ID
    typename__: Optional[Literal['UnresolveReviewThreadInput']] = Field(
        'UnresolveReviewThreadInput', alias='__typename'
    )


class UpdateBranchProtectionRuleInput(BaseModel):
    """
    Autogenerated input type of UpdateBranchProtectionRule
    """

    allowsDeletions: Optional[Boolean] = None
    allowsForcePushes: Optional[Boolean] = None
    blocksCreations: Optional[Boolean] = None
    branchProtectionRuleId: ID
    bypassForcePushActorIds: Optional[List[ID]] = None
    bypassPullRequestActorIds: Optional[List[ID]] = None
    clientMutationId: Optional[String] = None
    dismissesStaleReviews: Optional[Boolean] = None
    isAdminEnforced: Optional[Boolean] = None
    lockAllowsFetchAndMerge: Optional[Boolean] = None
    lockBranch: Optional[Boolean] = None
    pattern: Optional[String] = None
    pushActorIds: Optional[List[ID]] = None
    requireLastPushApproval: Optional[Boolean] = None
    requiredApprovingReviewCount: Optional[Int] = None
    requiredDeploymentEnvironments: Optional[List[String]] = None
    requiredStatusCheckContexts: Optional[List[String]] = None
    requiredStatusChecks: Optional[List[RequiredStatusCheckInput]] = None
    requiresApprovingReviews: Optional[Boolean] = None
    requiresCodeOwnerReviews: Optional[Boolean] = None
    requiresCommitSignatures: Optional[Boolean] = None
    requiresConversationResolution: Optional[Boolean] = None
    requiresDeployments: Optional[Boolean] = None
    requiresLinearHistory: Optional[Boolean] = None
    requiresStatusChecks: Optional[Boolean] = None
    requiresStrictStatusChecks: Optional[Boolean] = None
    restrictsPushes: Optional[Boolean] = None
    restrictsReviewDismissals: Optional[Boolean] = None
    reviewDismissalActorIds: Optional[List[ID]] = None
    typename__: Optional[Literal['UpdateBranchProtectionRuleInput']] = Field(
        'UpdateBranchProtectionRuleInput', alias='__typename'
    )


class UpdateCheckRunInput(BaseModel):
    """
    Autogenerated input type of UpdateCheckRun
    """

    actions: Optional[List[CheckRunAction]] = None
    checkRunId: ID
    clientMutationId: Optional[String] = None
    completedAt: Optional[DateTime] = None
    conclusion: Optional[CheckConclusionState] = None
    detailsUrl: Optional[URI] = None
    externalId: Optional[String] = None
    name: Optional[String] = None
    output: Optional[CheckRunOutput] = None
    repositoryId: ID
    startedAt: Optional[DateTime] = None
    status: Optional[RequestableCheckStatusState] = None
    typename__: Optional[Literal['UpdateCheckRunInput']] = Field(
        'UpdateCheckRunInput', alias='__typename'
    )


class UpdateCheckSuitePreferencesInput(BaseModel):
    """
    Autogenerated input type of UpdateCheckSuitePreferences
    """

    autoTriggerPreferences: List[CheckSuiteAutoTriggerPreference]
    clientMutationId: Optional[String] = None
    repositoryId: ID
    typename__: Optional[Literal['UpdateCheckSuitePreferencesInput']] = Field(
        'UpdateCheckSuitePreferencesInput', alias='__typename'
    )


class UpdateDiscussionCommentInput(BaseModel):
    """
    Autogenerated input type of UpdateDiscussionComment
    """

    body: String
    clientMutationId: Optional[String] = None
    commentId: ID
    typename__: Optional[Literal['UpdateDiscussionCommentInput']] = Field(
        'UpdateDiscussionCommentInput', alias='__typename'
    )


class UpdateDiscussionInput(BaseModel):
    """
    Autogenerated input type of UpdateDiscussion
    """

    body: Optional[String] = None
    categoryId: Optional[ID] = None
    clientMutationId: Optional[String] = None
    discussionId: ID
    title: Optional[String] = None
    typename__: Optional[Literal['UpdateDiscussionInput']] = Field(
        'UpdateDiscussionInput', alias='__typename'
    )


class UpdateEnterpriseAdministratorRoleInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseAdministratorRole
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    login: String
    role: EnterpriseAdministratorRole
    typename__: Optional[Literal['UpdateEnterpriseAdministratorRoleInput']] = Field(
        'UpdateEnterpriseAdministratorRoleInput', alias='__typename'
    )


class UpdateEnterpriseAllowPrivateRepositoryForkingSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseAllowPrivateRepositoryForkingSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    policyValue: Optional[EnterpriseAllowPrivateRepositoryForkingPolicyValue] = None
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseAllowPrivateRepositoryForkingSettingInput']
    ] = Field(
        'UpdateEnterpriseAllowPrivateRepositoryForkingSettingInput', alias='__typename'
    )


class UpdateEnterpriseDefaultRepositoryPermissionSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseDefaultRepositoryPermissionSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseDefaultRepositoryPermissionSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseDefaultRepositoryPermissionSettingInput']
    ] = Field(
        'UpdateEnterpriseDefaultRepositoryPermissionSettingInput', alias='__typename'
    )


class UpdateEnterpriseMembersCanChangeRepositoryVisibilitySettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseMembersCanChangeRepositoryVisibilitySetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanChangeRepositoryVisibilitySettingInput']
    ] = Field(
        'UpdateEnterpriseMembersCanChangeRepositoryVisibilitySettingInput',
        alias='__typename',
    )


class UpdateEnterpriseMembersCanCreateRepositoriesSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseMembersCanCreateRepositoriesSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    membersCanCreateInternalRepositories: Optional[Boolean] = None
    membersCanCreatePrivateRepositories: Optional[Boolean] = None
    membersCanCreatePublicRepositories: Optional[Boolean] = None
    membersCanCreateRepositoriesPolicyEnabled: Optional[Boolean] = None
    settingValue: Optional[EnterpriseMembersCanCreateRepositoriesSettingValue] = None
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanCreateRepositoriesSettingInput']
    ] = Field(
        'UpdateEnterpriseMembersCanCreateRepositoriesSettingInput', alias='__typename'
    )


class UpdateEnterpriseMembersCanDeleteIssuesSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseMembersCanDeleteIssuesSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanDeleteIssuesSettingInput']
    ] = Field('UpdateEnterpriseMembersCanDeleteIssuesSettingInput', alias='__typename')


class UpdateEnterpriseMembersCanDeleteRepositoriesSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseMembersCanDeleteRepositoriesSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanDeleteRepositoriesSettingInput']
    ] = Field(
        'UpdateEnterpriseMembersCanDeleteRepositoriesSettingInput', alias='__typename'
    )


class UpdateEnterpriseMembersCanInviteCollaboratorsSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseMembersCanInviteCollaboratorsSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanInviteCollaboratorsSettingInput']
    ] = Field(
        'UpdateEnterpriseMembersCanInviteCollaboratorsSettingInput', alias='__typename'
    )


class UpdateEnterpriseMembersCanMakePurchasesSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseMembersCanMakePurchasesSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseMembersCanMakePurchasesSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanMakePurchasesSettingInput']
    ] = Field('UpdateEnterpriseMembersCanMakePurchasesSettingInput', alias='__typename')


class UpdateEnterpriseMembersCanUpdateProtectedBranchesSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseMembersCanUpdateProtectedBranchesSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanUpdateProtectedBranchesSettingInput']
    ] = Field(
        'UpdateEnterpriseMembersCanUpdateProtectedBranchesSettingInput',
        alias='__typename',
    )


class UpdateEnterpriseMembersCanViewDependencyInsightsSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseMembersCanViewDependencyInsightsSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseMembersCanViewDependencyInsightsSettingInput']
    ] = Field(
        'UpdateEnterpriseMembersCanViewDependencyInsightsSettingInput',
        alias='__typename',
    )


class UpdateEnterpriseOrganizationProjectsSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseOrganizationProjectsSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseOrganizationProjectsSettingInput']
    ] = Field('UpdateEnterpriseOrganizationProjectsSettingInput', alias='__typename')


class UpdateEnterpriseOwnerOrganizationRoleInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseOwnerOrganizationRole
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    organizationId: ID
    organizationRole: RoleInOrganization
    typename__: Optional[Literal['UpdateEnterpriseOwnerOrganizationRoleInput']] = Field(
        'UpdateEnterpriseOwnerOrganizationRoleInput', alias='__typename'
    )


class UpdateEnterpriseProfileInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseProfile
    """

    clientMutationId: Optional[String] = None
    description: Optional[String] = None
    enterpriseId: ID
    location: Optional[String] = None
    name: Optional[String] = None
    websiteUrl: Optional[String] = None
    typename__: Optional[Literal['UpdateEnterpriseProfileInput']] = Field(
        'UpdateEnterpriseProfileInput', alias='__typename'
    )


class UpdateEnterpriseRepositoryProjectsSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseRepositoryProjectsSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseRepositoryProjectsSettingInput']
    ] = Field('UpdateEnterpriseRepositoryProjectsSettingInput', alias='__typename')


class UpdateEnterpriseTeamDiscussionsSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseTeamDiscussionsSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledDisabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseTeamDiscussionsSettingInput']
    ] = Field('UpdateEnterpriseTeamDiscussionsSettingInput', alias='__typename')


class UpdateEnterpriseTwoFactorAuthenticationRequiredSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateEnterpriseTwoFactorAuthenticationRequiredSetting
    """

    clientMutationId: Optional[String] = None
    enterpriseId: ID
    settingValue: EnterpriseEnabledSettingValue
    typename__: Optional[
        Literal['UpdateEnterpriseTwoFactorAuthenticationRequiredSettingInput']
    ] = Field(
        'UpdateEnterpriseTwoFactorAuthenticationRequiredSettingInput',
        alias='__typename',
    )


class UpdateEnvironmentInput(BaseModel):
    """
    Autogenerated input type of UpdateEnvironment
    """

    clientMutationId: Optional[String] = None
    environmentId: ID
    preventSelfReview: Optional[Boolean] = None
    reviewers: Optional[List[ID]] = None
    waitTimer: Optional[Int] = None
    typename__: Optional[Literal['UpdateEnvironmentInput']] = Field(
        'UpdateEnvironmentInput', alias='__typename'
    )


class UpdateIpAllowListEnabledSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateIpAllowListEnabledSetting
    """

    clientMutationId: Optional[String] = None
    ownerId: ID
    settingValue: IpAllowListEnabledSettingValue
    typename__: Optional[Literal['UpdateIpAllowListEnabledSettingInput']] = Field(
        'UpdateIpAllowListEnabledSettingInput', alias='__typename'
    )


class UpdateIpAllowListEntryInput(BaseModel):
    """
    Autogenerated input type of UpdateIpAllowListEntry
    """

    allowListValue: String
    clientMutationId: Optional[String] = None
    ipAllowListEntryId: ID
    isActive: Boolean
    name: Optional[String] = None
    typename__: Optional[Literal['UpdateIpAllowListEntryInput']] = Field(
        'UpdateIpAllowListEntryInput', alias='__typename'
    )


class UpdateIpAllowListForInstalledAppsEnabledSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateIpAllowListForInstalledAppsEnabledSetting
    """

    clientMutationId: Optional[String] = None
    ownerId: ID
    settingValue: IpAllowListForInstalledAppsEnabledSettingValue
    typename__: Optional[
        Literal['UpdateIpAllowListForInstalledAppsEnabledSettingInput']
    ] = Field(
        'UpdateIpAllowListForInstalledAppsEnabledSettingInput', alias='__typename'
    )


class UpdateIssueCommentInput(BaseModel):
    """
    Autogenerated input type of UpdateIssueComment
    """

    body: String
    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['UpdateIssueCommentInput']] = Field(
        'UpdateIssueCommentInput', alias='__typename'
    )


class UpdateIssueInput(BaseModel):
    """
    Autogenerated input type of UpdateIssue
    """

    assigneeIds: Optional[List[ID]] = None
    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    id: ID
    labelIds: Optional[List[ID]] = None
    milestoneId: Optional[ID] = None
    projectIds: Optional[List[ID]] = None
    state: Optional[IssueState] = None
    title: Optional[String] = None
    typename__: Optional[Literal['UpdateIssueInput']] = Field(
        'UpdateIssueInput', alias='__typename'
    )


class UpdateLabelInput(BaseModel):
    """
    Autogenerated input type of UpdateLabel
    """

    clientMutationId: Optional[String] = None
    color: Optional[String] = None
    description: Optional[String] = None
    id: ID
    name: Optional[String] = None
    typename__: Optional[Literal['UpdateLabelInput']] = Field(
        'UpdateLabelInput', alias='__typename'
    )


class UpdateNotificationRestrictionSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateNotificationRestrictionSetting
    """

    clientMutationId: Optional[String] = None
    ownerId: ID
    settingValue: NotificationRestrictionSettingValue
    typename__: Optional[Literal['UpdateNotificationRestrictionSettingInput']] = Field(
        'UpdateNotificationRestrictionSettingInput', alias='__typename'
    )


class UpdateOrganizationAllowPrivateRepositoryForkingSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateOrganizationAllowPrivateRepositoryForkingSetting
    """

    clientMutationId: Optional[String] = None
    forkingEnabled: Boolean
    organizationId: ID
    typename__: Optional[
        Literal['UpdateOrganizationAllowPrivateRepositoryForkingSettingInput']
    ] = Field(
        'UpdateOrganizationAllowPrivateRepositoryForkingSettingInput',
        alias='__typename',
    )


class UpdateOrganizationWebCommitSignoffSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateOrganizationWebCommitSignoffSetting
    """

    clientMutationId: Optional[String] = None
    organizationId: ID
    webCommitSignoffRequired: Boolean
    typename__: Optional[
        Literal['UpdateOrganizationWebCommitSignoffSettingInput']
    ] = Field('UpdateOrganizationWebCommitSignoffSettingInput', alias='__typename')


class UpdateParametersInput(BaseModel):
    """
    Only allow users with bypass permission to update matching refs.
    """

    updateAllowsFetchAndMerge: Boolean
    typename__: Optional[Literal['UpdateParametersInput']] = Field(
        'UpdateParametersInput', alias='__typename'
    )


class UpdatePatreonSponsorabilityInput(BaseModel):
    """
    Autogenerated input type of UpdatePatreonSponsorability
    """

    clientMutationId: Optional[String] = None
    enablePatreonSponsorships: Boolean
    sponsorableLogin: Optional[String] = None
    typename__: Optional[Literal['UpdatePatreonSponsorabilityInput']] = Field(
        'UpdatePatreonSponsorabilityInput', alias='__typename'
    )


class UpdateProjectCardInput(BaseModel):
    """
    Autogenerated input type of UpdateProjectCard
    """

    clientMutationId: Optional[String] = None
    isArchived: Optional[Boolean] = None
    note: Optional[String] = None
    projectCardId: ID
    typename__: Optional[Literal['UpdateProjectCardInput']] = Field(
        'UpdateProjectCardInput', alias='__typename'
    )


class UpdateProjectColumnInput(BaseModel):
    """
    Autogenerated input type of UpdateProjectColumn
    """

    clientMutationId: Optional[String] = None
    name: String
    projectColumnId: ID
    typename__: Optional[Literal['UpdateProjectColumnInput']] = Field(
        'UpdateProjectColumnInput', alias='__typename'
    )


class UpdateProjectInput(BaseModel):
    """
    Autogenerated input type of UpdateProject
    """

    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    name: Optional[String] = None
    projectId: ID
    public: Optional[Boolean] = None
    state: Optional[ProjectState] = None
    typename__: Optional[Literal['UpdateProjectInput']] = Field(
        'UpdateProjectInput', alias='__typename'
    )


class UpdateProjectV2CollaboratorsInput(BaseModel):
    """
    Autogenerated input type of UpdateProjectV2Collaborators
    """

    clientMutationId: Optional[String] = None
    collaborators: List[ProjectV2Collaborator]
    projectId: ID
    typename__: Optional[Literal['UpdateProjectV2CollaboratorsInput']] = Field(
        'UpdateProjectV2CollaboratorsInput', alias='__typename'
    )


class UpdateProjectV2DraftIssueInput(BaseModel):
    """
    Autogenerated input type of UpdateProjectV2DraftIssue
    """

    assigneeIds: Optional[List[ID]] = None
    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    draftIssueId: ID
    title: Optional[String] = None
    typename__: Optional[Literal['UpdateProjectV2DraftIssueInput']] = Field(
        'UpdateProjectV2DraftIssueInput', alias='__typename'
    )


class UpdateProjectV2Input(BaseModel):
    """
    Autogenerated input type of UpdateProjectV2
    """

    clientMutationId: Optional[String] = None
    closed: Optional[Boolean] = None
    projectId: ID
    public: Optional[Boolean] = None
    readme: Optional[String] = None
    shortDescription: Optional[String] = None
    title: Optional[String] = None
    typename__: Optional[Literal['UpdateProjectV2Input']] = Field(
        'UpdateProjectV2Input', alias='__typename'
    )


class UpdateProjectV2ItemFieldValueInput(BaseModel):
    """
    Autogenerated input type of UpdateProjectV2ItemFieldValue
    """

    clientMutationId: Optional[String] = None
    fieldId: ID
    itemId: ID
    projectId: ID
    value: ProjectV2FieldValue
    typename__: Optional[Literal['UpdateProjectV2ItemFieldValueInput']] = Field(
        'UpdateProjectV2ItemFieldValueInput', alias='__typename'
    )


class UpdateProjectV2ItemPositionInput(BaseModel):
    """
    Autogenerated input type of UpdateProjectV2ItemPosition
    """

    afterId: Optional[ID] = None
    clientMutationId: Optional[String] = None
    itemId: ID
    projectId: ID
    typename__: Optional[Literal['UpdateProjectV2ItemPositionInput']] = Field(
        'UpdateProjectV2ItemPositionInput', alias='__typename'
    )


class UpdatePullRequestBranchInput(BaseModel):
    """
    Autogenerated input type of UpdatePullRequestBranch
    """

    clientMutationId: Optional[String] = None
    expectedHeadOid: Optional[GitObjectID] = None
    pullRequestId: ID
    updateMethod: Optional[PullRequestBranchUpdateMethod] = None
    typename__: Optional[Literal['UpdatePullRequestBranchInput']] = Field(
        'UpdatePullRequestBranchInput', alias='__typename'
    )


class UpdatePullRequestInput(BaseModel):
    """
    Autogenerated input type of UpdatePullRequest
    """

    assigneeIds: Optional[List[ID]] = None
    baseRefName: Optional[String] = None
    body: Optional[String] = None
    clientMutationId: Optional[String] = None
    labelIds: Optional[List[ID]] = None
    maintainerCanModify: Optional[Boolean] = None
    milestoneId: Optional[ID] = None
    projectIds: Optional[List[ID]] = None
    pullRequestId: ID
    state: Optional[PullRequestUpdateState] = None
    title: Optional[String] = None
    typename__: Optional[Literal['UpdatePullRequestInput']] = Field(
        'UpdatePullRequestInput', alias='__typename'
    )


class UpdatePullRequestReviewCommentInput(BaseModel):
    """
    Autogenerated input type of UpdatePullRequestReviewComment
    """

    body: String
    clientMutationId: Optional[String] = None
    pullRequestReviewCommentId: ID
    typename__: Optional[Literal['UpdatePullRequestReviewCommentInput']] = Field(
        'UpdatePullRequestReviewCommentInput', alias='__typename'
    )


class UpdatePullRequestReviewInput(BaseModel):
    """
    Autogenerated input type of UpdatePullRequestReview
    """

    body: String
    clientMutationId: Optional[String] = None
    pullRequestReviewId: ID
    typename__: Optional[Literal['UpdatePullRequestReviewInput']] = Field(
        'UpdatePullRequestReviewInput', alias='__typename'
    )


class UpdateRefInput(BaseModel):
    """
    Autogenerated input type of UpdateRef
    """

    clientMutationId: Optional[String] = None
    force: Optional[Boolean] = False
    oid: GitObjectID
    refId: ID
    typename__: Optional[Literal['UpdateRefInput']] = Field(
        'UpdateRefInput', alias='__typename'
    )


class UpdateRefsInput(BaseModel):
    """
    Autogenerated input type of UpdateRefs
    """

    clientMutationId: Optional[String] = None
    refUpdates: List[RefUpdate]
    repositoryId: ID
    typename__: Optional[Literal['UpdateRefsInput']] = Field(
        'UpdateRefsInput', alias='__typename'
    )


class UpdateRepositoryInput(BaseModel):
    """
    Autogenerated input type of UpdateRepository
    """

    clientMutationId: Optional[String] = None
    description: Optional[String] = None
    hasDiscussionsEnabled: Optional[Boolean] = None
    hasIssuesEnabled: Optional[Boolean] = None
    hasProjectsEnabled: Optional[Boolean] = None
    hasWikiEnabled: Optional[Boolean] = None
    homepageUrl: Optional[URI] = None
    name: Optional[String] = None
    repositoryId: ID
    template: Optional[Boolean] = None
    typename__: Optional[Literal['UpdateRepositoryInput']] = Field(
        'UpdateRepositoryInput', alias='__typename'
    )


class UpdateRepositoryRulesetInput(BaseModel):
    """
    Autogenerated input type of UpdateRepositoryRuleset
    """

    bypassActors: Optional[List[RepositoryRulesetBypassActorInput]] = None
    clientMutationId: Optional[String] = None
    conditions: Optional[RepositoryRuleConditionsInput] = None
    enforcement: Optional[RuleEnforcement] = None
    name: Optional[String] = None
    repositoryRulesetId: ID
    rules: Optional[List[RepositoryRuleInput]] = None
    target: Optional[RepositoryRulesetTarget] = None
    typename__: Optional[Literal['UpdateRepositoryRulesetInput']] = Field(
        'UpdateRepositoryRulesetInput', alias='__typename'
    )


class UpdateRepositoryWebCommitSignoffSettingInput(BaseModel):
    """
    Autogenerated input type of UpdateRepositoryWebCommitSignoffSetting
    """

    clientMutationId: Optional[String] = None
    repositoryId: ID
    webCommitSignoffRequired: Boolean
    typename__: Optional[
        Literal['UpdateRepositoryWebCommitSignoffSettingInput']
    ] = Field('UpdateRepositoryWebCommitSignoffSettingInput', alias='__typename')


class UpdateSponsorshipPreferencesInput(BaseModel):
    """
    Autogenerated input type of UpdateSponsorshipPreferences
    """

    clientMutationId: Optional[String] = None
    privacyLevel: Optional[SponsorshipPrivacy] = 'PUBLIC'
    receiveEmails: Optional[Boolean] = True
    sponsorId: Optional[ID] = None
    sponsorLogin: Optional[String] = None
    sponsorableId: Optional[ID] = None
    sponsorableLogin: Optional[String] = None
    typename__: Optional[Literal['UpdateSponsorshipPreferencesInput']] = Field(
        'UpdateSponsorshipPreferencesInput', alias='__typename'
    )


class UpdateSubscriptionInput(BaseModel):
    """
    Autogenerated input type of UpdateSubscription
    """

    clientMutationId: Optional[String] = None
    state: SubscriptionState
    subscribableId: ID
    typename__: Optional[Literal['UpdateSubscriptionInput']] = Field(
        'UpdateSubscriptionInput', alias='__typename'
    )


class UpdateTeamDiscussionCommentInput(BaseModel):
    """
    Autogenerated input type of UpdateTeamDiscussionComment
    """

    body: String
    bodyVersion: Optional[String] = None
    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['UpdateTeamDiscussionCommentInput']] = Field(
        'UpdateTeamDiscussionCommentInput', alias='__typename'
    )


class UpdateTeamDiscussionInput(BaseModel):
    """
    Autogenerated input type of UpdateTeamDiscussion
    """

    body: Optional[String] = None
    bodyVersion: Optional[String] = None
    clientMutationId: Optional[String] = None
    id: ID
    pinned: Optional[Boolean] = None
    title: Optional[String] = None
    typename__: Optional[Literal['UpdateTeamDiscussionInput']] = Field(
        'UpdateTeamDiscussionInput', alias='__typename'
    )


class UpdateTeamReviewAssignmentInput(BaseModel):
    """
    Autogenerated input type of UpdateTeamReviewAssignment
    """

    algorithm: Optional[TeamReviewAssignmentAlgorithm] = 'ROUND_ROBIN'
    clientMutationId: Optional[String] = None
    enabled: Boolean
    excludedTeamMemberIds: Optional[List[ID]] = None
    id: ID
    notifyTeam: Optional[Boolean] = True
    teamMemberCount: Optional[Int] = 1
    typename__: Optional[Literal['UpdateTeamReviewAssignmentInput']] = Field(
        'UpdateTeamReviewAssignmentInput', alias='__typename'
    )


class UpdateTeamsRepositoryInput(BaseModel):
    """
    Autogenerated input type of UpdateTeamsRepository
    """

    clientMutationId: Optional[String] = None
    permission: RepositoryPermission
    repositoryId: ID
    teamIds: List[ID]
    typename__: Optional[Literal['UpdateTeamsRepositoryInput']] = Field(
        'UpdateTeamsRepositoryInput', alias='__typename'
    )


class UpdateTopicsInput(BaseModel):
    """
    Autogenerated input type of UpdateTopics
    """

    clientMutationId: Optional[String] = None
    repositoryId: ID
    topicNames: List[String]
    typename__: Optional[Literal['UpdateTopicsInput']] = Field(
        'UpdateTopicsInput', alias='__typename'
    )


class UserStatusOrder(BaseModel):
    """
    Ordering options for user status connections.
    """

    direction: OrderDirection
    field: UserStatusOrderField
    typename__: Optional[Literal['UserStatusOrder']] = Field(
        'UserStatusOrder', alias='__typename'
    )


class VerifiableDomainOrder(BaseModel):
    """
    Ordering options for verifiable domain connections.
    """

    direction: OrderDirection
    field: VerifiableDomainOrderField
    typename__: Optional[Literal['VerifiableDomainOrder']] = Field(
        'VerifiableDomainOrder', alias='__typename'
    )


class VerifyVerifiableDomainInput(BaseModel):
    """
    Autogenerated input type of VerifyVerifiableDomain
    """

    clientMutationId: Optional[String] = None
    id: ID
    typename__: Optional[Literal['VerifyVerifiableDomainInput']] = Field(
        'VerifyVerifiableDomainInput', alias='__typename'
    )


class WorkflowFileReferenceInput(BaseModel):
    """
    A workflow that must run for this rule to pass
    """

    path: String
    ref: Optional[String] = None
    repositoryId: Int
    sha: Optional[String] = None
    typename__: Optional[Literal['WorkflowFileReferenceInput']] = Field(
        'WorkflowFileReferenceInput', alias='__typename'
    )


class WorkflowRunOrder(BaseModel):
    """
    Ways in which lists of workflow runs can be ordered upon return.
    """

    direction: OrderDirection
    field: WorkflowRunOrderField
    typename__: Optional[Literal['WorkflowRunOrder']] = Field(
        'WorkflowRunOrder', alias='__typename'
    )


class WorkflowsParametersInput(BaseModel):
    """
    Require all changes made to a targeted branch to pass the specified workflows before they can be merged.
    """

    workflows: List[WorkflowFileReferenceInput]
    typename__: Optional[Literal['WorkflowsParametersInput']] = Field(
        'WorkflowsParametersInput', alias='__typename'
    )


# Types that can be assigned to issues.
Assignee: TypeAlias = Union[
    'Bot',
    'Mannequin',
    'Organization',
    'User',
]


# Types that can initiate an audit log event.
AuditEntryActor: TypeAlias = Union[
    'Bot',
    'Organization',
    'User',
]


# Types which can be actors for `BranchActorAllowance` objects.
BranchActorAllowanceActor: TypeAlias = Union[
    'App',
    'Team',
    'User',
]


# Types that can represent a repository ruleset bypass actor.
BypassActor: TypeAlias = Union[
    'App',
    'Team',
]


# An object which can have its data claimed or claim data from another.
Claimable: TypeAlias = Union[
    'Mannequin',
    'User',
]


# The object which triggered a `ClosedEvent`.
Closer: TypeAlias = Union[
    'Commit',
    'PullRequest',
]


# Represents either a issue the viewer can access or a restricted contribution.
CreatedIssueOrRestrictedContribution: TypeAlias = Union[
    'CreatedIssueContribution',
    'RestrictedContribution',
]


# Represents either a pull request the viewer can access or a restricted contribution.
CreatedPullRequestOrRestrictedContribution: TypeAlias = Union[
    'CreatedPullRequestContribution',
    'RestrictedContribution',
]


# Represents either a repository the viewer can access or a restricted contribution.
CreatedRepositoryOrRestrictedContribution: TypeAlias = Union[
    'CreatedRepositoryContribution',
    'RestrictedContribution',
]


# Users and teams.
DeploymentReviewer: TypeAlias = Union[
    'Team',
    'User',
]


# An object that is a member of an enterprise.
EnterpriseMember: TypeAlias = Union[
    'EnterpriseUserAccount',
    'User',
]


# Types that can own an IP allow list.
IpAllowListOwner: TypeAlias = Union[
    'App',
    'Enterprise',
    'Organization',
]


# Used for return value of Repository.issueOrPullRequest.
IssueOrPullRequest: TypeAlias = Union[
    'Issue',
    'PullRequest',
]


# An item in an issue timeline
IssueTimelineItem: TypeAlias = Union[
    'AssignedEvent',
    'ClosedEvent',
    'Commit',
    'CrossReferencedEvent',
    'DemilestonedEvent',
    'IssueComment',
    'LabeledEvent',
    'LockedEvent',
    'MilestonedEvent',
    'ReferencedEvent',
    'RenamedTitleEvent',
    'ReopenedEvent',
    'SubscribedEvent',
    'TransferredEvent',
    'UnassignedEvent',
    'UnlabeledEvent',
    'UnlockedEvent',
    'UnsubscribedEvent',
    'UserBlockedEvent',
]


# An item in an issue timeline
IssueTimelineItems: TypeAlias = Union[
    'AddedToProjectEvent',
    'AssignedEvent',
    'ClosedEvent',
    'CommentDeletedEvent',
    'ConnectedEvent',
    'ConvertedNoteToIssueEvent',
    'ConvertedToDiscussionEvent',
    'CrossReferencedEvent',
    'DemilestonedEvent',
    'DisconnectedEvent',
    'IssueComment',
    'LabeledEvent',
    'LockedEvent',
    'MarkedAsDuplicateEvent',
    'MentionedEvent',
    'MilestonedEvent',
    'MovedColumnsInProjectEvent',
    'PinnedEvent',
    'ReferencedEvent',
    'RemovedFromProjectEvent',
    'RenamedTitleEvent',
    'ReopenedEvent',
    'SubscribedEvent',
    'TransferredEvent',
    'UnassignedEvent',
    'UnlabeledEvent',
    'UnlockedEvent',
    'UnmarkedAsDuplicateEvent',
    'UnpinnedEvent',
    'UnsubscribedEvent',
    'UserBlockedEvent',
]


# Types that can be inside a Milestone.
MilestoneItem: TypeAlias = Union[
    'Issue',
    'PullRequest',
]


# Types of memberships that can be restored for an Organization member.
OrgRestoreMemberAuditEntryMembership: TypeAlias = Union[
    'OrgRestoreMemberMembershipOrganizationAuditEntryData',
    'OrgRestoreMemberMembershipRepositoryAuditEntryData',
    'OrgRestoreMemberMembershipTeamAuditEntryData',
]


# An audit entry in an organization audit log.
OrganizationAuditEntry: TypeAlias = Union[
    'MembersCanDeleteReposClearAuditEntry',
    'MembersCanDeleteReposDisableAuditEntry',
    'MembersCanDeleteReposEnableAuditEntry',
    'OauthApplicationCreateAuditEntry',
    'OrgAddBillingManagerAuditEntry',
    'OrgAddMemberAuditEntry',
    'OrgBlockUserAuditEntry',
    'OrgConfigDisableCollaboratorsOnlyAuditEntry',
    'OrgConfigEnableCollaboratorsOnlyAuditEntry',
    'OrgCreateAuditEntry',
    'OrgDisableOauthAppRestrictionsAuditEntry',
    'OrgDisableSamlAuditEntry',
    'OrgDisableTwoFactorRequirementAuditEntry',
    'OrgEnableOauthAppRestrictionsAuditEntry',
    'OrgEnableSamlAuditEntry',
    'OrgEnableTwoFactorRequirementAuditEntry',
    'OrgInviteMemberAuditEntry',
    'OrgInviteToBusinessAuditEntry',
    'OrgOauthAppAccessApprovedAuditEntry',
    'OrgOauthAppAccessBlockedAuditEntry',
    'OrgOauthAppAccessDeniedAuditEntry',
    'OrgOauthAppAccessRequestedAuditEntry',
    'OrgOauthAppAccessUnblockedAuditEntry',
    'OrgRemoveBillingManagerAuditEntry',
    'OrgRemoveMemberAuditEntry',
    'OrgRemoveOutsideCollaboratorAuditEntry',
    'OrgRestoreMemberAuditEntry',
    'OrgUnblockUserAuditEntry',
    'OrgUpdateDefaultRepositoryPermissionAuditEntry',
    'OrgUpdateMemberAuditEntry',
    'OrgUpdateMemberRepositoryCreationPermissionAuditEntry',
    'OrgUpdateMemberRepositoryInvitationPermissionAuditEntry',
    'PrivateRepositoryForkingDisableAuditEntry',
    'PrivateRepositoryForkingEnableAuditEntry',
    'RepoAccessAuditEntry',
    'RepoAddMemberAuditEntry',
    'RepoAddTopicAuditEntry',
    'RepoArchivedAuditEntry',
    'RepoChangeMergeSettingAuditEntry',
    'RepoConfigDisableAnonymousGitAccessAuditEntry',
    'RepoConfigDisableCollaboratorsOnlyAuditEntry',
    'RepoConfigDisableContributorsOnlyAuditEntry',
    'RepoConfigDisableSockpuppetDisallowedAuditEntry',
    'RepoConfigEnableAnonymousGitAccessAuditEntry',
    'RepoConfigEnableCollaboratorsOnlyAuditEntry',
    'RepoConfigEnableContributorsOnlyAuditEntry',
    'RepoConfigEnableSockpuppetDisallowedAuditEntry',
    'RepoConfigLockAnonymousGitAccessAuditEntry',
    'RepoConfigUnlockAnonymousGitAccessAuditEntry',
    'RepoCreateAuditEntry',
    'RepoDestroyAuditEntry',
    'RepoRemoveMemberAuditEntry',
    'RepoRemoveTopicAuditEntry',
    'RepositoryVisibilityChangeDisableAuditEntry',
    'RepositoryVisibilityChangeEnableAuditEntry',
    'TeamAddMemberAuditEntry',
    'TeamAddRepositoryAuditEntry',
    'TeamChangeParentTeamAuditEntry',
    'TeamRemoveMemberAuditEntry',
    'TeamRemoveRepositoryAuditEntry',
]


# Used for argument of CreateProjectV2 mutation.
OrganizationOrUser: TypeAlias = Union[
    'Organization',
    'User',
]


# Types that can grant permissions on a repository to a user
PermissionGranter: TypeAlias = Union[
    'Organization',
    'Repository',
    'Team',
]


# Types that can be pinned to a profile page.
PinnableItem: TypeAlias = Union[
    'Gist',
    'Repository',
]


# Types that can be inside Project Cards.
ProjectCardItem: TypeAlias = Union[
    'Issue',
    'PullRequest',
]


# Possible collaborators for a project.
ProjectV2Actor: TypeAlias = Union[
    'Team',
    'User',
]


# Configurations for project fields.
ProjectV2FieldConfiguration: TypeAlias = Union[
    'ProjectV2Field',
    'ProjectV2IterationField',
    'ProjectV2SingleSelectField',
]


# Types that can be inside Project Items.
ProjectV2ItemContent: TypeAlias = Union[
    'DraftIssue',
    'Issue',
    'PullRequest',
]


# Project field values
ProjectV2ItemFieldValue: TypeAlias = Union[
    'ProjectV2ItemFieldDateValue',
    'ProjectV2ItemFieldIterationValue',
    'ProjectV2ItemFieldLabelValue',
    'ProjectV2ItemFieldMilestoneValue',
    'ProjectV2ItemFieldNumberValue',
    'ProjectV2ItemFieldPullRequestValue',
    'ProjectV2ItemFieldRepositoryValue',
    'ProjectV2ItemFieldReviewerValue',
    'ProjectV2ItemFieldSingleSelectValue',
    'ProjectV2ItemFieldTextValue',
    'ProjectV2ItemFieldUserValue',
]


# An item in a pull request timeline
PullRequestTimelineItem: TypeAlias = Union[
    'AssignedEvent',
    'BaseRefDeletedEvent',
    'BaseRefForcePushedEvent',
    'ClosedEvent',
    'Commit',
    'CommitCommentThread',
    'CrossReferencedEvent',
    'DemilestonedEvent',
    'DeployedEvent',
    'DeploymentEnvironmentChangedEvent',
    'HeadRefDeletedEvent',
    'HeadRefForcePushedEvent',
    'HeadRefRestoredEvent',
    'IssueComment',
    'LabeledEvent',
    'LockedEvent',
    'MergedEvent',
    'MilestonedEvent',
    'PullRequestReview',
    'PullRequestReviewComment',
    'PullRequestReviewThread',
    'ReferencedEvent',
    'RenamedTitleEvent',
    'ReopenedEvent',
    'ReviewDismissedEvent',
    'ReviewRequestRemovedEvent',
    'ReviewRequestedEvent',
    'SubscribedEvent',
    'UnassignedEvent',
    'UnlabeledEvent',
    'UnlockedEvent',
    'UnsubscribedEvent',
    'UserBlockedEvent',
]


# An item in a pull request timeline
PullRequestTimelineItems: TypeAlias = Union[
    'AddedToMergeQueueEvent',
    'AddedToProjectEvent',
    'AssignedEvent',
    'AutoMergeDisabledEvent',
    'AutoMergeEnabledEvent',
    'AutoRebaseEnabledEvent',
    'AutoSquashEnabledEvent',
    'AutomaticBaseChangeFailedEvent',
    'AutomaticBaseChangeSucceededEvent',
    'BaseRefChangedEvent',
    'BaseRefDeletedEvent',
    'BaseRefForcePushedEvent',
    'ClosedEvent',
    'CommentDeletedEvent',
    'ConnectedEvent',
    'ConvertToDraftEvent',
    'ConvertedNoteToIssueEvent',
    'ConvertedToDiscussionEvent',
    'CrossReferencedEvent',
    'DemilestonedEvent',
    'DeployedEvent',
    'DeploymentEnvironmentChangedEvent',
    'DisconnectedEvent',
    'HeadRefDeletedEvent',
    'HeadRefForcePushedEvent',
    'HeadRefRestoredEvent',
    'IssueComment',
    'LabeledEvent',
    'LockedEvent',
    'MarkedAsDuplicateEvent',
    'MentionedEvent',
    'MergedEvent',
    'MilestonedEvent',
    'MovedColumnsInProjectEvent',
    'PinnedEvent',
    'PullRequestCommit',
    'PullRequestCommitCommentThread',
    'PullRequestReview',
    'PullRequestReviewThread',
    'PullRequestRevisionMarker',
    'ReadyForReviewEvent',
    'ReferencedEvent',
    'RemovedFromMergeQueueEvent',
    'RemovedFromProjectEvent',
    'RenamedTitleEvent',
    'ReopenedEvent',
    'ReviewDismissedEvent',
    'ReviewRequestRemovedEvent',
    'ReviewRequestedEvent',
    'SubscribedEvent',
    'TransferredEvent',
    'UnassignedEvent',
    'UnlabeledEvent',
    'UnlockedEvent',
    'UnmarkedAsDuplicateEvent',
    'UnpinnedEvent',
    'UnsubscribedEvent',
    'UserBlockedEvent',
]


# Types that can be an actor.
PushAllowanceActor: TypeAlias = Union[
    'App',
    'Team',
    'User',
]


# Types that can be assigned to reactions.
Reactor: TypeAlias = Union[
    'Bot',
    'Mannequin',
    'Organization',
    'User',
]


# Any referenceable object
ReferencedSubject: TypeAlias = Union[
    'Issue',
    'PullRequest',
]


# An object which has a renamable title
RenamedTitleSubject: TypeAlias = Union[
    'Issue',
    'PullRequest',
]


# Types that can be requested reviewers.
RequestedReviewer: TypeAlias = Union[
    'Bot',
    'Mannequin',
    'Team',
    'User',
]


# Types that can be an actor.
ReviewDismissalAllowanceActor: TypeAlias = Union[
    'App',
    'Team',
    'User',
]


# Types which can be parameters for `RepositoryRule` objects.
RuleParameters: TypeAlias = Union[
    'BranchNamePatternParameters',
    'CommitAuthorEmailPatternParameters',
    'CommitMessagePatternParameters',
    'CommitterEmailPatternParameters',
    'PullRequestParameters',
    'RequiredDeploymentsParameters',
    'RequiredStatusChecksParameters',
    'TagNamePatternParameters',
    'UpdateParameters',
    'WorkflowsParameters',
]


# Types which can have `RepositoryRule` objects.
RuleSource: TypeAlias = Union[
    'Organization',
    'Repository',
]


# The results of a search.
SearchResultItem: TypeAlias = Union[
    'App',
    'Discussion',
    'Issue',
    'MarketplaceListing',
    'Organization',
    'PullRequest',
    'Repository',
    'User',
]


# Entities that can sponsor others via GitHub Sponsors
Sponsor: TypeAlias = Union[
    'Organization',
    'User',
]


# Entities that can be sponsored via GitHub Sponsors
SponsorableItem: TypeAlias = Union[
    'Organization',
    'User',
]


# A record that can be featured on a GitHub Sponsors profile.
SponsorsListingFeatureableItem: TypeAlias = Union[
    'Repository',
    'User',
]


# Types that can be inside a StatusCheckRollup context.
StatusCheckRollupContext: TypeAlias = Union[
    'CheckRun',
    'StatusContext',
]


# Types that can own a verifiable domain.
VerifiableDomainOwner: TypeAlias = Union[
    'Enterprise',
    'Organization',
]
