/**
 * \file pappsomspp/widget/httpbutton/httpbutton.h
 * \date 20/04/2021
 * \author Olivier Langella
 * \brief push button to trigger web browser on URL
 */


/*******************************************************************************
 * Copyright (c) 2021 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once


#include <QPushButton>
#include <QUrl>
#include "pappsomspp/export-import-config.h"

namespace pappso
{

class PMSPP_LIB_DECL HttpButton : public QPushButton
{
  Q_OBJECT
  public:
  /**
   * Default constructor
   */
  explicit HttpButton(QWidget *parent = nullptr);

  /**
   * Destructor
   */
  ~HttpButton();

  void setText(const QString &text);

  protected:
  void mousePressEvent(QMouseEvent *e) override;

  const QUrl getOlsUrl(QString psimod_accession);
  const QUrl getPubMedUrl(QString accession);
  const QUrl getRESIDUrl(QString accession);
  const QUrl getChEBIUrl(QString accession);
  const QUrl getUnimodUrl(QString accession);
};
} // namespace pappso
