// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package slhdsa

import (
	"slices"
	"testing"
)

func TestXmssNodeKat(t *testing.T) {
	par := SLH_DSA_SHA2_128s
	skSeed := []byte{0x4f, 0x5d, 0xc5, 0xc9, 0x93, 0xb5, 0x88, 0x88, 0xb, 0xc4, 0x8, 0xf9, 0xfd, 0x8e, 0xd6, 0xe2}
	i := uint32(0x77)
	z := uint32(2)
	pkSeed := []byte{0xb5, 0x1f, 0x3b, 0x4f, 0xdc, 0x81, 0x97, 0xeb, 0x7a, 0xc6, 0x67, 0x82, 0x25, 0xac, 0x11, 0xee}
	adrs := &address{0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0xa5, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x76}
	want := []byte{0xe8, 0xab, 0xf, 0x93, 0xb4, 0x9b, 0xa2, 0x7a, 0x86, 0x2c, 0xc0, 0xf2, 0xd6, 0xe3, 0xb3, 0x1f}
	if got := par.xmssNode(skSeed, i, z, pkSeed, adrs); !slices.Equal(got, want) {
		t.Errorf("par.xmssNode() = %v, want %v", got, want)
	}
}

func TestXmssSignKat(t *testing.T) {
	par := SLH_DSA_SHA2_128s
	msg := []byte{0x55, 0x50, 0x9d, 0x20, 0x54, 0x35, 0x22, 0x1f, 0x8, 0xaa, 0xa6, 0x89, 0xed, 0x2c, 0xb0, 0xd7}
	skSeed := []byte{0x4f, 0x5d, 0xc5, 0xc9, 0x93, 0xb5, 0x88, 0x88, 0xb, 0xc4, 0x8, 0xf9, 0xfd, 0x8e, 0xd6, 0xe2}
	idx := uint32(0xa5)
	pkSeed := []byte{0xb5, 0x1f, 0x3b, 0x4f, 0xdc, 0x81, 0x97, 0xeb, 0x7a, 0xc6, 0x67, 0x82, 0x25, 0xac, 0x11, 0xee}
	adrs := &address{0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x0, 0x0, 0x0, 0x0}
	want := []byte{0xc9, 0xd2, 0x81, 0xfd, 0xe5, 0xd, 0x4b, 0xac, 0x6e, 0xd8, 0xab, 0x98, 0x6a, 0x25, 0xa5, 0x8e, 0xf9, 0xf8, 0xb4, 0xf0, 0x78, 0x2d, 0x7e, 0x93, 0xe6, 0x61, 0x6, 0x93, 0xd6, 0x42, 0x92, 0x70, 0x22, 0x8f, 0xb8, 0x51, 0xed, 0x4e, 0x4, 0x82, 0x98, 0x68, 0x20, 0x76, 0x16, 0x4, 0x39, 0xd8, 0x27, 0x29, 0x38, 0x61, 0x4a, 0x5e, 0xf0, 0x2b, 0x27, 0x4e, 0xc, 0x6a, 0x8c, 0x25, 0x81, 0x4, 0xde, 0x1b, 0x2d, 0x2, 0xdd, 0x4b, 0x42, 0xc9, 0xec, 0xa2, 0x76, 0x2b, 0xa6, 0x8b, 0xc1, 0x6b, 0xc8, 0xc9, 0x3a, 0xa, 0x5a, 0xbb, 0x14, 0x74, 0x52, 0x68, 0x46, 0xe, 0xb4, 0xec, 0x34, 0x15, 0x5, 0x96, 0x9c, 0x10, 0x64, 0x75, 0x31, 0xb2, 0x3f, 0x39, 0x46, 0xb, 0x5, 0xf1, 0x7e, 0x5d, 0x96, 0x2f, 0xd5, 0x73, 0xa3, 0x82, 0x64, 0xb4, 0x6b, 0xb0, 0x15, 0xc0, 0xb0, 0xcb, 0xbf, 0x6, 0xa5, 0xb9, 0x80, 0x6b, 0x76, 0x9d, 0xa8, 0xd7, 0x2e, 0x8a, 0x6e, 0xa2, 0x42, 0x40, 0x76, 0x21, 0xfc, 0x4b, 0x48, 0x32, 0xb5, 0x59, 0xa1, 0x5, 0xbf, 0xfc, 0x85, 0x21, 0x48, 0xe3, 0x41, 0x8b, 0xa6, 0x2f, 0x99, 0x15, 0xc5, 0x5e, 0xe4, 0xc6, 0xce, 0xe5, 0x30, 0x50, 0x95, 0x9e, 0x9f, 0xba, 0x14, 0xb5, 0x83, 0xd2, 0xb4, 0xad, 0xd6, 0x2a, 0x9, 0x94, 0x9f, 0xba, 0xcc, 0x50, 0xf, 0xfc, 0xf, 0xa9, 0xca, 0xf0, 0x49, 0x2, 0x51, 0xd0, 0xae, 0xc9, 0x1c, 0x2b, 0xfd, 0x8c, 0x51, 0x50, 0x73, 0x59, 0x92, 0x30, 0x50, 0x95, 0xbf, 0x39, 0x45, 0x97, 0xff, 0x44, 0x90, 0x0, 0x88, 0x5b, 0xd9, 0xcf, 0x53, 0xf1, 0x77, 0xd4, 0xc5, 0x94, 0x9a, 0xd, 0x74, 0x6a, 0xa5, 0x7a, 0xcd, 0xf4, 0x67, 0x54, 0xf9, 0xd2, 0x50, 0x28, 0xae, 0xc8, 0x44, 0x29, 0xa6, 0x9d, 0x75, 0x57, 0xac, 0x33, 0x82, 0xfd, 0x51, 0x28, 0x34, 0xcd, 0x7, 0x35, 0x4d, 0x1f, 0x90, 0x44, 0xa5, 0xde, 0xae, 0x12, 0xa0, 0x25, 0xdd, 0xe3, 0xfc, 0x65, 0x58, 0x88, 0x1f, 0x2c, 0x8d, 0xb4, 0x2e, 0x28, 0x2c, 0xe6, 0x70, 0x24, 0x93, 0x9d, 0x36, 0xde, 0x53, 0x92, 0xbb, 0xcf, 0xeb, 0x1e, 0xe7, 0xc7, 0x9a, 0x1b, 0xed, 0xd, 0x5a, 0x38, 0x16, 0x97, 0x0, 0x21, 0xdd, 0xf6, 0xe8, 0x7d, 0xd8, 0xc, 0xfb, 0x74, 0xcf, 0x59, 0xde, 0xd5, 0x86, 0xdd, 0xaf, 0xa, 0x6f, 0x6b, 0xd5, 0xc1, 0xf3, 0x2c, 0x4a, 0x73, 0xd5, 0x70, 0x40, 0xfa, 0xa, 0x4d, 0x10, 0x8f, 0xaa, 0x99, 0x85, 0xc9, 0x63, 0x3e, 0x61, 0xd7, 0x28, 0x82, 0x11, 0x7a, 0x79, 0x41, 0x3d, 0x1a, 0xf1, 0xd1, 0xb8, 0x4a, 0xbf, 0xd9, 0x75, 0xa4, 0xd3, 0x84, 0xe8, 0x1e, 0xc8, 0xa9, 0xa0, 0x2c, 0x6f, 0x1b, 0x6, 0xf0, 0xfd, 0xf4, 0x19, 0x7f, 0x4a, 0x26, 0x8c, 0xb5, 0x19, 0x7f, 0xe9, 0x15, 0xd4, 0x42, 0xef, 0x9d, 0x50, 0xc4, 0xcd, 0x54, 0x2b, 0x27, 0xaa, 0x20, 0xf1, 0xa5, 0x44, 0xf3, 0xbe, 0xb5, 0x48, 0x18, 0x1, 0x23, 0x1e, 0xc0, 0x91, 0x16, 0x6, 0x3, 0xe2, 0x3f, 0xc6, 0x94, 0x65, 0xc0, 0x72, 0xfe, 0xa7, 0x9, 0xbc, 0x19, 0x9d, 0xd0, 0xdf, 0x1e, 0x4a, 0x16, 0x65, 0x83, 0x39, 0xbd, 0xcc, 0xb4, 0x24, 0x9c, 0x45, 0x59, 0xbc, 0x60, 0x8b, 0x7, 0xba, 0x22, 0x26, 0xb, 0xff, 0xa8, 0xc, 0x4a, 0x5, 0x49, 0xd3, 0xf3, 0x12, 0xc6, 0x62, 0x2d, 0x72, 0x2f, 0x17, 0xe6, 0x92, 0xb1, 0xf4, 0xdd, 0x5d, 0x2b, 0x10, 0x47, 0x42, 0xe4, 0x72, 0x48, 0x3f, 0x1a, 0x9d, 0x48, 0x84, 0xd9, 0x19, 0x5d, 0x9e, 0x8f, 0xee, 0xd3, 0x41, 0xe9, 0xe7, 0x0, 0x3f, 0xe4, 0x5a, 0x1e, 0x7, 0xdf, 0xb2, 0xce, 0xd5, 0xd3, 0x9a, 0x38, 0x92, 0x24, 0x5e, 0xb2, 0xc9, 0x5a, 0xba, 0xc2, 0xe1, 0x9a, 0x42, 0xa1, 0xc9, 0x1a, 0x44, 0xac, 0xc7, 0xcc, 0x46, 0x2, 0xd3, 0xf5, 0x18, 0x66, 0x2d, 0x16, 0xf5, 0xee, 0xb2, 0x41, 0x7b, 0xfa, 0xb4, 0x9e, 0x6c, 0xb8, 0x9, 0x91, 0x36, 0xe3, 0xc4, 0xf8, 0x35, 0xcb, 0xc0, 0xbc, 0xf9, 0x92, 0x75, 0xb7, 0x10, 0x2d, 0xa4, 0x81, 0xfc, 0xce, 0x8f, 0xcf, 0x46, 0x72, 0xc9, 0xed, 0x32, 0x42, 0xb0, 0x60, 0x5e, 0xb9, 0xe1, 0xee, 0xc4, 0xa, 0xfe, 0x32, 0x84, 0x62, 0x1d, 0x92, 0x76, 0x47, 0xa8, 0x25, 0x1b, 0x20, 0x26, 0x95, 0xba, 0x0, 0xce, 0xd6, 0x30, 0x8, 0x81, 0x61, 0xf0, 0x41, 0x76, 0xb2, 0xee, 0xbd, 0x51, 0x9c, 0xca, 0xac, 0x49, 0xf, 0x9, 0x5d, 0xdd, 0xcf, 0xe5, 0xd7, 0x46, 0x1b, 0xde, 0x6d, 0x6e, 0xea, 0xab, 0xdc, 0x3, 0x69, 0xc6, 0xd8, 0xaa, 0x70, 0x3d, 0x9b, 0xb3, 0xc8, 0xad, 0x38, 0x52, 0xe6, 0xf0, 0x1b, 0xf9, 0xab, 0xd, 0x7d, 0x6c, 0x20, 0x13, 0xb4, 0x3d, 0x3a, 0xbb, 0x7a, 0x46, 0x20, 0x2c, 0x68, 0x51, 0xb3, 0xc8, 0xa5, 0xd6, 0x7f, 0xf3, 0xf4, 0x75, 0x91, 0xd2, 0x5e, 0x55, 0x68, 0xaa, 0xff, 0x30, 0xa4, 0xa, 0x10, 0xfe, 0x55, 0x3b, 0x3, 0x1e, 0x26, 0xde, 0xce, 0x7f, 0x1e, 0x53, 0xc, 0xb9, 0x5e, 0xa2, 0xf9, 0x51, 0xac, 0x7, 0xca}
	if got := par.xmssSign(msg, skSeed, idx, pkSeed, adrs); !slices.Equal(got, want) {
		t.Errorf("par.xmssSign() = %v, want %v", got, want)
	}
}

func TestXmssPkFromSigKat(t *testing.T) {
	par := SLH_DSA_SHA2_128s
	idx := uint32(0xa5)
	sigXmss := []byte{0xc9, 0xd2, 0x81, 0xfd, 0xe5, 0xd, 0x4b, 0xac, 0x6e, 0xd8, 0xab, 0x98, 0x6a, 0x25, 0xa5, 0x8e, 0xf9, 0xf8, 0xb4, 0xf0, 0x78, 0x2d, 0x7e, 0x93, 0xe6, 0x61, 0x6, 0x93, 0xd6, 0x42, 0x92, 0x70, 0x22, 0x8f, 0xb8, 0x51, 0xed, 0x4e, 0x4, 0x82, 0x98, 0x68, 0x20, 0x76, 0x16, 0x4, 0x39, 0xd8, 0x27, 0x29, 0x38, 0x61, 0x4a, 0x5e, 0xf0, 0x2b, 0x27, 0x4e, 0xc, 0x6a, 0x8c, 0x25, 0x81, 0x4, 0xde, 0x1b, 0x2d, 0x2, 0xdd, 0x4b, 0x42, 0xc9, 0xec, 0xa2, 0x76, 0x2b, 0xa6, 0x8b, 0xc1, 0x6b, 0xc8, 0xc9, 0x3a, 0xa, 0x5a, 0xbb, 0x14, 0x74, 0x52, 0x68, 0x46, 0xe, 0xb4, 0xec, 0x34, 0x15, 0x5, 0x96, 0x9c, 0x10, 0x64, 0x75, 0x31, 0xb2, 0x3f, 0x39, 0x46, 0xb, 0x5, 0xf1, 0x7e, 0x5d, 0x96, 0x2f, 0xd5, 0x73, 0xa3, 0x82, 0x64, 0xb4, 0x6b, 0xb0, 0x15, 0xc0, 0xb0, 0xcb, 0xbf, 0x6, 0xa5, 0xb9, 0x80, 0x6b, 0x76, 0x9d, 0xa8, 0xd7, 0x2e, 0x8a, 0x6e, 0xa2, 0x42, 0x40, 0x76, 0x21, 0xfc, 0x4b, 0x48, 0x32, 0xb5, 0x59, 0xa1, 0x5, 0xbf, 0xfc, 0x85, 0x21, 0x48, 0xe3, 0x41, 0x8b, 0xa6, 0x2f, 0x99, 0x15, 0xc5, 0x5e, 0xe4, 0xc6, 0xce, 0xe5, 0x30, 0x50, 0x95, 0x9e, 0x9f, 0xba, 0x14, 0xb5, 0x83, 0xd2, 0xb4, 0xad, 0xd6, 0x2a, 0x9, 0x94, 0x9f, 0xba, 0xcc, 0x50, 0xf, 0xfc, 0xf, 0xa9, 0xca, 0xf0, 0x49, 0x2, 0x51, 0xd0, 0xae, 0xc9, 0x1c, 0x2b, 0xfd, 0x8c, 0x51, 0x50, 0x73, 0x59, 0x92, 0x30, 0x50, 0x95, 0xbf, 0x39, 0x45, 0x97, 0xff, 0x44, 0x90, 0x0, 0x88, 0x5b, 0xd9, 0xcf, 0x53, 0xf1, 0x77, 0xd4, 0xc5, 0x94, 0x9a, 0xd, 0x74, 0x6a, 0xa5, 0x7a, 0xcd, 0xf4, 0x67, 0x54, 0xf9, 0xd2, 0x50, 0x28, 0xae, 0xc8, 0x44, 0x29, 0xa6, 0x9d, 0x75, 0x57, 0xac, 0x33, 0x82, 0xfd, 0x51, 0x28, 0x34, 0xcd, 0x7, 0x35, 0x4d, 0x1f, 0x90, 0x44, 0xa5, 0xde, 0xae, 0x12, 0xa0, 0x25, 0xdd, 0xe3, 0xfc, 0x65, 0x58, 0x88, 0x1f, 0x2c, 0x8d, 0xb4, 0x2e, 0x28, 0x2c, 0xe6, 0x70, 0x24, 0x93, 0x9d, 0x36, 0xde, 0x53, 0x92, 0xbb, 0xcf, 0xeb, 0x1e, 0xe7, 0xc7, 0x9a, 0x1b, 0xed, 0xd, 0x5a, 0x38, 0x16, 0x97, 0x0, 0x21, 0xdd, 0xf6, 0xe8, 0x7d, 0xd8, 0xc, 0xfb, 0x74, 0xcf, 0x59, 0xde, 0xd5, 0x86, 0xdd, 0xaf, 0xa, 0x6f, 0x6b, 0xd5, 0xc1, 0xf3, 0x2c, 0x4a, 0x73, 0xd5, 0x70, 0x40, 0xfa, 0xa, 0x4d, 0x10, 0x8f, 0xaa, 0x99, 0x85, 0xc9, 0x63, 0x3e, 0x61, 0xd7, 0x28, 0x82, 0x11, 0x7a, 0x79, 0x41, 0x3d, 0x1a, 0xf1, 0xd1, 0xb8, 0x4a, 0xbf, 0xd9, 0x75, 0xa4, 0xd3, 0x84, 0xe8, 0x1e, 0xc8, 0xa9, 0xa0, 0x2c, 0x6f, 0x1b, 0x6, 0xf0, 0xfd, 0xf4, 0x19, 0x7f, 0x4a, 0x26, 0x8c, 0xb5, 0x19, 0x7f, 0xe9, 0x15, 0xd4, 0x42, 0xef, 0x9d, 0x50, 0xc4, 0xcd, 0x54, 0x2b, 0x27, 0xaa, 0x20, 0xf1, 0xa5, 0x44, 0xf3, 0xbe, 0xb5, 0x48, 0x18, 0x1, 0x23, 0x1e, 0xc0, 0x91, 0x16, 0x6, 0x3, 0xe2, 0x3f, 0xc6, 0x94, 0x65, 0xc0, 0x72, 0xfe, 0xa7, 0x9, 0xbc, 0x19, 0x9d, 0xd0, 0xdf, 0x1e, 0x4a, 0x16, 0x65, 0x83, 0x39, 0xbd, 0xcc, 0xb4, 0x24, 0x9c, 0x45, 0x59, 0xbc, 0x60, 0x8b, 0x7, 0xba, 0x22, 0x26, 0xb, 0xff, 0xa8, 0xc, 0x4a, 0x5, 0x49, 0xd3, 0xf3, 0x12, 0xc6, 0x62, 0x2d, 0x72, 0x2f, 0x17, 0xe6, 0x92, 0xb1, 0xf4, 0xdd, 0x5d, 0x2b, 0x10, 0x47, 0x42, 0xe4, 0x72, 0x48, 0x3f, 0x1a, 0x9d, 0x48, 0x84, 0xd9, 0x19, 0x5d, 0x9e, 0x8f, 0xee, 0xd3, 0x41, 0xe9, 0xe7, 0x0, 0x3f, 0xe4, 0x5a, 0x1e, 0x7, 0xdf, 0xb2, 0xce, 0xd5, 0xd3, 0x9a, 0x38, 0x92, 0x24, 0x5e, 0xb2, 0xc9, 0x5a, 0xba, 0xc2, 0xe1, 0x9a, 0x42, 0xa1, 0xc9, 0x1a, 0x44, 0xac, 0xc7, 0xcc, 0x46, 0x2, 0xd3, 0xf5, 0x18, 0x66, 0x2d, 0x16, 0xf5, 0xee, 0xb2, 0x41, 0x7b, 0xfa, 0xb4, 0x9e, 0x6c, 0xb8, 0x9, 0x91, 0x36, 0xe3, 0xc4, 0xf8, 0x35, 0xcb, 0xc0, 0xbc, 0xf9, 0x92, 0x75, 0xb7, 0x10, 0x2d, 0xa4, 0x81, 0xfc, 0xce, 0x8f, 0xcf, 0x46, 0x72, 0xc9, 0xed, 0x32, 0x42, 0xb0, 0x60, 0x5e, 0xb9, 0xe1, 0xee, 0xc4, 0xa, 0xfe, 0x32, 0x84, 0x62, 0x1d, 0x92, 0x76, 0x47, 0xa8, 0x25, 0x1b, 0x20, 0x26, 0x95, 0xba, 0x0, 0xce, 0xd6, 0x30, 0x8, 0x81, 0x61, 0xf0, 0x41, 0x76, 0xb2, 0xee, 0xbd, 0x51, 0x9c, 0xca, 0xac, 0x49, 0xf, 0x9, 0x5d, 0xdd, 0xcf, 0xe5, 0xd7, 0x46, 0x1b, 0xde, 0x6d, 0x6e, 0xea, 0xab, 0xdc, 0x3, 0x69, 0xc6, 0xd8, 0xaa, 0x70, 0x3d, 0x9b, 0xb3, 0xc8, 0xad, 0x38, 0x52, 0xe6, 0xf0, 0x1b, 0xf9, 0xab, 0xd, 0x7d, 0x6c, 0x20, 0x13, 0xb4, 0x3d, 0x3a, 0xbb, 0x7a, 0x46, 0x20, 0x2c, 0x68, 0x51, 0xb3, 0xc8, 0xa5, 0xd6, 0x7f, 0xf3, 0xf4, 0x75, 0x91, 0xd2, 0x5e, 0x55, 0x68, 0xaa, 0xff, 0x30, 0xa4, 0xa, 0x10, 0xfe, 0x55, 0x3b, 0x3, 0x1e, 0x26, 0xde, 0xce, 0x7f, 0x1e, 0x53, 0xc, 0xb9, 0x5e, 0xa2, 0xf9, 0x51, 0xac, 0x7, 0xca}
	msg := []byte{0x55, 0x50, 0x9d, 0x20, 0x54, 0x35, 0x22, 0x1f, 0x8, 0xaa, 0xa6, 0x89, 0xed, 0x2c, 0xb0, 0xd7}
	pkSeed := []byte{0xb5, 0x1f, 0x3b, 0x4f, 0xdc, 0x81, 0x97, 0xeb, 0x7a, 0xc6, 0x67, 0x82, 0x25, 0xac, 0x11, 0xee}
	adrs := &address{0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa5, 0x0, 0x0, 0x0, 0x22, 0x0, 0x0, 0x0, 0xe}
	want := []byte{0xd5, 0x8b, 0x7c, 0xf0, 0x16, 0xa0, 0x48, 0x8f, 0x6, 0x5b, 0x5d, 0x5b, 0x9e, 0x7, 0xf1, 0x53}
	if got := par.xmssPkFromSig(idx, sigXmss, msg, pkSeed, adrs); !slices.Equal(got, want) {
		t.Errorf("par.xmssPkFromSig() = %v, want %v", got, want)
	}
}
