import camitk
# This line will run the mixedcomponentextension/__init__.py 
# which register the component extension to the CamiTK application
from mixedcomponentextension import MixedComponentExtension

def check_registration():
    return "pymixed" in camitk.ExtensionManager.getFileExtensions()

def init(self:camitk.Action):
    isRegistered = check_registration()
    self.setParameterValue("Python Mixed Extension Registered", isRegistered)
    self.setApplyButtonText("Check Registration")
    if isRegistered:
        camitk.trace("MixedComponentExtension registered.")
    else:
        camitk.warning("MixedComponentExtension was not registered")
    return isRegistered

def process(self:camitk.Action):
    self.setParameterValue("Python Mixed Extension Registered", check_registration())
    return True # nothing to do as the registration was already done

