#!/bin/sh
set -o nounset

oneTimeSetUp() {
	# Load the ./play.it library
	. lib/libplayit2.sh
}

# Prevent archive type leaks.
test_archive_type_hallucination() {
	local \
		archive_type

	archive_type=$(archive_guess_type_from_name 'some_game_archive.tar.gz')
	assertEquals 'tar.gz' "$archive_type"
	archive_type=$(archive_guess_type_from_name 'some_strange_game_archive.xyz')
	assertNull \
		'archive_guess_type_from_name hallucinated a type for an archive using an unknown extension.' \
		"$archive_type"

	return 0
}

# Ensure that line breaks are not allowed in applications options strings.
test_application_options_line_break() {
	local \
		APP_MAIN_OPTIONS='--some-option
		--some-other-option'

	assertFalse \
		'application_options failed to correctly prevent a multi-lines options string.' \
		'application_options "APP_MAIN"'

	return 0
}
