# random_r.m4
# serial 6
dnl Copyright (C) 2008-2026 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.
dnl This file is offered as-is, without any warranty.

AC_DEFUN([gl_FUNC_RANDOM_R],
[
  AC_REQUIRE([gl_STDLIB_H_DEFAULTS])
  AC_REQUIRE([AC_CANONICAL_HOST])

  AC_CHECK_HEADERS([random.h], [], [], [AC_INCLUDES_DEFAULT])

  AC_CHECK_TYPES([struct random_data],
    [], [HAVE_STRUCT_RANDOM_DATA=0],
    [[#include <stdlib.h>
      #if HAVE_RANDOM_H
      # include <random.h>
      #endif
    ]])

  dnl On AIX, these functions exist, but with different declarations.
  dnl Override them all.
  case "$host_os" in
    aix*)
      REPLACE_RANDOM_R=1
      ;;
    *)
      AC_CHECK_FUNCS([random_r])
      if test $ac_cv_func_random_r = no; then
        HAVE_RANDOM_R=0
      fi
      ;;
  esac
])

# Prerequisites of lib/random_r.c.
AC_DEFUN([gl_PREREQ_RANDOM_R], [
  :
])
