/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.text;

import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextSpan;
import org.odftoolkit.odfdom.incubator.doc.text.OdfWhitespaceProcessor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;

public class OdfTextHeading
extends TextHElement {
    public OdfTextHeading(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfTextHeading(OdfFileDom ownerDoc, String styleName) {
        super(ownerDoc);
        if (styleName != null && !styleName.equals("")) {
            this.setStyleName(styleName);
        }
    }

    public OdfTextHeading(OdfFileDom ownerDoc, String styleName, String content) {
        super(ownerDoc);
        this.addStyledContent(styleName, content);
    }

    public OdfTextHeading addContent(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
        return this;
    }

    public OdfTextHeading addContentWhitespace(String content) {
        if (content != null && !content.equals("")) {
            new OdfWhitespaceProcessor().append(this, content);
        }
        return this;
    }

    public OdfTextHeading addStyledContent(String styleName, String content) {
        if (styleName != null && !styleName.equals("")) {
            this.setStyleName(styleName);
        }
        return this.addContent(content);
    }

    public OdfTextHeading addStyledContentWhitespace(String styleName, String content) {
        if (styleName != null && !styleName.equals("")) {
            this.setStyleName(styleName);
        }
        return this.addContentWhitespace(content);
    }

    public OdfTextHeading addStyledSpan(String styleName, String content) {
        if (styleName != null && !styleName.equals("") && content != null && !content.equals("")) {
            this.appendChild(new OdfTextSpan((OdfFileDom)this.getOwnerDocument(), styleName, content));
        }
        return this;
    }

    public OdfTextHeading addStyledSpanWhitespace(String styleName, String content) {
        if (styleName != null && !styleName.equals("") && content != null && !content.equals("")) {
            OdfTextSpan span = new OdfTextSpan((OdfFileDom)this.getOwnerDocument());
            span.addStyledContentWhitespace(styleName, content);
            this.appendChild(span);
        }
        return this;
    }
}

