/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2017 - 2022: Samsung Electronics Co., Ltd.
 *             https://www.samsung.com
 * Copyright (c) 2017-2022 Tesla, Inc.
 *             https://www.tesla.com
 *
 * The constants defined in this header are being used in dts
 * and fsd platform driver.
 */

#ifndef _DT_BINDINGS_CLOCK_FSD_H
#define _DT_BINDINGS_CLOCK_FSD_H

/* CMU */
#define DOUT_CMU_PLL_SHARED0_DIV4		1
#define DOUT_CMU_PERIC_SHARED1DIV36		2
#define DOUT_CMU_PERIC_SHARED0DIV3_TBUCLK	3
#define DOUT_CMU_PERIC_SHARED0DIV20		4
#define DOUT_CMU_PERIC_SHARED1DIV4_DMACLK	5
#define DOUT_CMU_PLL_SHARED0_DIV6		6
#define DOUT_CMU_FSYS0_SHARED1DIV4		7
#define DOUT_CMU_FSYS0_SHARED0DIV4		8
#define DOUT_CMU_FSYS1_SHARED0DIV8		9
#define DOUT_CMU_FSYS1_SHARED0DIV4		10
#define CMU_CPUCL_SWITCH_GATE			11
#define DOUT_CMU_IMEM_TCUCLK			12
#define DOUT_CMU_IMEM_ACLK			13
#define DOUT_CMU_IMEM_DMACLK			14
#define GAT_CMU_FSYS0_SHARED0DIV4		15

/* PERIC */
#define PERIC_SCLK_UART0			1
#define PERIC_PCLK_UART0			2
#define PERIC_SCLK_UART1			3
#define PERIC_PCLK_UART1			4
#define PERIC_DMA0_IPCLKPORT_ACLK		5
#define PERIC_DMA1_IPCLKPORT_ACLK		6
#define PERIC_PWM0_IPCLKPORT_I_PCLK_S0		7
#define PERIC_PWM1_IPCLKPORT_I_PCLK_S0		8
#define PERIC_PCLK_SPI0                         9
#define PERIC_SCLK_SPI0                         10
#define PERIC_PCLK_SPI1                         11
#define PERIC_SCLK_SPI1                         12
#define PERIC_PCLK_SPI2                         13
#define PERIC_SCLK_SPI2                         14
#define PERIC_PCLK_TDM0                         15
#define PERIC_PCLK_HSI2C0			16
#define PERIC_PCLK_HSI2C1			17
#define PERIC_PCLK_HSI2C2			18
#define PERIC_PCLK_HSI2C3			19
#define PERIC_PCLK_HSI2C4			20
#define PERIC_PCLK_HSI2C5			21
#define PERIC_PCLK_HSI2C6			22
#define PERIC_PCLK_HSI2C7			23
#define PERIC_MCAN0_IPCLKPORT_CCLK		24
#define PERIC_MCAN0_IPCLKPORT_PCLK		25
#define PERIC_MCAN1_IPCLKPORT_CCLK		26
#define PERIC_MCAN1_IPCLKPORT_PCLK		27
#define PERIC_MCAN2_IPCLKPORT_CCLK		28
#define PERIC_MCAN2_IPCLKPORT_PCLK		29
#define PERIC_MCAN3_IPCLKPORT_CCLK		30
#define PERIC_MCAN3_IPCLKPORT_PCLK		31
#define PERIC_PCLK_ADCIF			32
#define PERIC_EQOS_TOP_IPCLKPORT_CLK_PTP_REF_I  33
#define PERIC_EQOS_TOP_IPCLKPORT_ACLK_I		34
#define PERIC_EQOS_TOP_IPCLKPORT_HCLK_I		35
#define PERIC_EQOS_TOP_IPCLKPORT_RGMII_CLK_I	36
#define PERIC_EQOS_TOP_IPCLKPORT_CLK_RX_I	37
#define PERIC_BUS_D_PERIC_IPCLKPORT_EQOSCLK	38
#define PERIC_BUS_P_PERIC_IPCLKPORT_EQOSCLK	39
#define PERIC_HCLK_TDM0				40
#define PERIC_PCLK_TDM1				41
#define PERIC_HCLK_TDM1				42
#define PERIC_EQOS_PHYRXCLK_MUX			43
#define PERIC_EQOS_PHYRXCLK			44
#define PERIC_DOUT_RGMII_CLK			45

/* FSYS0 */
#define UFS0_MPHY_REFCLK_IXTAL24		1
#define UFS0_MPHY_REFCLK_IXTAL26		2
#define UFS1_MPHY_REFCLK_IXTAL24		3
#define UFS1_MPHY_REFCLK_IXTAL26		4
#define UFS0_TOP0_HCLK_BUS			5
#define UFS0_TOP0_ACLK				6
#define UFS0_TOP0_CLK_UNIPRO			7
#define UFS0_TOP0_FMP_CLK			8
#define UFS1_TOP1_HCLK_BUS			9
#define UFS1_TOP1_ACLK				10
#define UFS1_TOP1_CLK_UNIPRO			11
#define UFS1_TOP1_FMP_CLK			12
#define PCIE_SUBCTRL_INST0_DBI_ACLK_SOC		13
#define PCIE_SUBCTRL_INST0_AUX_CLK_SOC		14
#define PCIE_SUBCTRL_INST0_MSTR_ACLK_SOC	15
#define PCIE_SUBCTRL_INST0_SLV_ACLK_SOC		16
#define FSYS0_EQOS_TOP0_IPCLKPORT_CLK_PTP_REF_I 17
#define FSYS0_EQOS_TOP0_IPCLKPORT_ACLK_I	18
#define FSYS0_EQOS_TOP0_IPCLKPORT_HCLK_I	19
#define FSYS0_EQOS_TOP0_IPCLKPORT_RGMII_CLK_I	20
#define FSYS0_EQOS_TOP0_IPCLKPORT_CLK_RX_I	21
#define FSYS0_DOUT_FSYS0_PERIBUS_GRP		22

/* FSYS1 */
#define PCIE_LINK0_IPCLKPORT_DBI_ACLK		1
#define PCIE_LINK0_IPCLKPORT_AUX_ACLK		2
#define PCIE_LINK0_IPCLKPORT_MSTR_ACLK		3
#define PCIE_LINK0_IPCLKPORT_SLV_ACLK		4
#define PCIE_LINK1_IPCLKPORT_DBI_ACLK		5
#define PCIE_LINK1_IPCLKPORT_AUX_ACLK		6
#define PCIE_LINK1_IPCLKPORT_MSTR_ACLK		7
#define PCIE_LINK1_IPCLKPORT_SLV_ACLK		8

/* IMEM */
#define IMEM_DMA0_IPCLKPORT_ACLK		1
#define IMEM_DMA1_IPCLKPORT_ACLK		2
#define IMEM_WDT0_IPCLKPORT_PCLK		3
#define IMEM_WDT1_IPCLKPORT_PCLK		4
#define IMEM_WDT2_IPCLKPORT_PCLK		5
#define IMEM_MCT_PCLK				6
#define IMEM_TMU_CPU0_IPCLKPORT_I_CLK_TS	7
#define IMEM_TMU_CPU2_IPCLKPORT_I_CLK_TS	8
#define IMEM_TMU_TOP_IPCLKPORT_I_CLK_TS		9
#define IMEM_TMU_GPU_IPCLKPORT_I_CLK_TS		10
#define IMEM_TMU_GT_IPCLKPORT_I_CLK_TS		11

/* MFC */
#define MFC_MFC_IPCLKPORT_ACLK			1

/* CAM_CSI */
#define CAM_CSI0_0_IPCLKPORT_I_ACLK		1
#define CAM_CSI0_1_IPCLKPORT_I_ACLK		2
#define CAM_CSI0_2_IPCLKPORT_I_ACLK		3
#define CAM_CSI0_3_IPCLKPORT_I_ACLK		4
#define CAM_CSI1_0_IPCLKPORT_I_ACLK		5
#define CAM_CSI1_1_IPCLKPORT_I_ACLK		6
#define CAM_CSI1_2_IPCLKPORT_I_ACLK		7
#define CAM_CSI1_3_IPCLKPORT_I_ACLK		8
#define CAM_CSI2_0_IPCLKPORT_I_ACLK		9
#define CAM_CSI2_1_IPCLKPORT_I_ACLK		10
#define CAM_CSI2_2_IPCLKPORT_I_ACLK		11
#define CAM_CSI2_3_IPCLKPORT_I_ACLK		12

#endif /*_DT_BINDINGS_CLOCK_FSD_H */
