/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.type;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.tcas.Annotation;

public class RutaBasic
extends Annotation {
    private static final int INITIAL_CAPACITY = 2;
    private static final String ROOT_TYPE1 = "uima.tcas.Annotation";
    private static final String ROOT_TYPE2 = "uima.cas.AnnotationBase";
    private boolean lowMemoryProfile = false;
    private int[] partOf = new int[((TypeSystemImpl)this.getCAS().getTypeSystem()).getLargestTypeCode()];
    private Collection<?>[] beginMap = new ArrayList[((TypeSystemImpl)this.getCAS().getTypeSystem()).getLargestTypeCode()];
    private Collection<?>[] endMap = new ArrayList[((TypeSystemImpl)this.getCAS().getTypeSystem()).getLargestTypeCode()];
    private boolean empty = true;
    public static final String _TypeName = "org.apache.uima.ruta.type.RutaBasic";
    public static final int typeIndexID;
    public static final int type;
    public static final String _FeatName_replacement = "replacement";
    private static final CallSite _FC_replacement;
    private static final MethodHandle _FH_replacement;

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isLowMemoryProfile() {
        return this.lowMemoryProfile;
    }

    public void setLowMemoryProfile(boolean lowMemoryProfile) {
        this.lowMemoryProfile = lowMemoryProfile;
    }

    public void addPartOf(Type type) {
        int code = ((TypeImpl)type).getCode();
        this.addPartOf(code);
    }

    private void addPartOf(int code) {
        int parentCode;
        this.partOf[code] = this.partOf[code] + 1;
        if (!this.lowMemoryProfile && (parentCode = this.getCAS().getTypeSystem().getLowLevelTypeSystem().ll_getParentType(code)) > 0) {
            this.addPartOf(parentCode);
        }
    }

    public void removePartOf(Type type) {
        int code = ((TypeImpl)type).getCode();
        this.removePartOf(code);
    }

    private void removePartOf(int code) {
        if (this.partOf[code] != 0) {
            int parentCode;
            this.partOf[code] = this.partOf[code] - 1;
            if (!this.lowMemoryProfile && (parentCode = this.getCAS().getTypeSystem().getLowLevelTypeSystem().ll_getParentType(code)) > 0) {
                this.removePartOf(parentCode);
            }
        }
    }

    public boolean isPartOf(Type type) {
        int code = ((TypeImpl)type).getCode();
        int count = this.partOf[code];
        if (count > 0) {
            return true;
        }
        if (this.lowMemoryProfile) {
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                int code2 = ((TypeImpl)each).getCode();
                int count2 = this.partOf[code2];
                if (count2 <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void setPartOf(int[] partOf) {
        this.partOf = partOf;
    }

    public int[] getPartOf() {
        return this.partOf;
    }

    public Collection<AnnotationFS> getBeginAnchors(Type type) {
        int code = ((TypeImpl)type).getCode();
        Collection<AnnotationFS> set = this.beginMap[code];
        if (this.lowMemoryProfile) {
            ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
            if (set != null) {
                result.addAll(set);
            }
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                int parentCode = ((TypeImpl)each).getCode();
                Collection<?> c = this.beginMap[parentCode];
                if (c == null) continue;
                result.addAll(c);
            }
            return result;
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Collection<AnnotationFS> getEndAnchors(Type type) {
        int code = ((TypeImpl)type).getCode();
        Collection<AnnotationFS> set = this.endMap[code];
        if (this.lowMemoryProfile) {
            ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
            if (set != null) {
                result.addAll(set);
            }
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                int parentCode = ((TypeImpl)each).getCode();
                Collection<?> c = this.endMap[parentCode];
                if (c == null) continue;
                result.addAll(c);
            }
            return result;
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public boolean beginsWith(Type type) {
        boolean beginsWith;
        int code = ((TypeImpl)type).getCode();
        Collection<?> set = this.beginMap[code];
        boolean bl = beginsWith = set != null && !set.isEmpty();
        if (beginsWith) {
            return true;
        }
        if (this.lowMemoryProfile) {
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                if (!this.beginsWith(each)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean endsWith(Type type) {
        boolean endswith;
        int code = ((TypeImpl)type).getCode();
        Collection<?> set = this.endMap[code];
        boolean bl = endswith = set != null && !set.isEmpty();
        if (endswith) {
            return true;
        }
        if (this.lowMemoryProfile) {
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                if (!this.endsWith(each)) continue;
                return true;
            }
        }
        return false;
    }

    public void addBegin(AnnotationFS annotation, Type type) {
        TypeSystem typeSystem;
        Type parent;
        this.empty = false;
        int code = ((TypeImpl)type).getCode();
        Collection<?> set = this.beginMap[code];
        if (set == null) {
            set = new ArrayList(2);
            this.beginMap[code] = set;
        }
        set.add(annotation);
        if (!(this.lowMemoryProfile || type.getName().equals(ROOT_TYPE1) || type.getName().equals(ROOT_TYPE2) || (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) == null)) {
            this.addBegin(annotation, parent);
        }
    }

    public void addEnd(AnnotationFS annotation, Type type) {
        TypeSystem typeSystem;
        Type parent;
        this.empty = false;
        int code = ((TypeImpl)type).getCode();
        Collection<?> set = this.endMap[code];
        if (set == null) {
            set = new ArrayList(2);
            this.endMap[code] = set;
        }
        set.add(annotation);
        if (!(this.lowMemoryProfile || type.getName().equals(ROOT_TYPE1) || type.getName().equals(ROOT_TYPE2) || (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) == null)) {
            this.addEnd(annotation, parent);
        }
    }

    public void removeBegin(AnnotationFS annotation, Type type) {
        TypeSystem typeSystem;
        Type parent;
        int code = ((TypeImpl)type).getCode();
        Collection<?> set = this.beginMap[code];
        if (set != null) {
            set.remove(annotation);
            if (set.isEmpty()) {
                this.beginMap[code] = null;
            }
        }
        if (!this.lowMemoryProfile && (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) != null) {
            this.removeBegin(annotation, parent);
        }
    }

    public void removeEnd(AnnotationFS annotation, Type type) {
        TypeSystem typeSystem;
        Type parent;
        int code = ((TypeImpl)type).getCode();
        Collection<?> set = this.endMap[code];
        if (set != null) {
            set.remove(annotation);
            if (set.isEmpty()) {
                this.endMap[code] = null;
            }
        }
        if (!this.lowMemoryProfile && (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) != null) {
            this.removeEnd(annotation, parent);
        }
    }

    public Collection<?>[] getBeginMap() {
        return this.beginMap;
    }

    public Collection<?>[] getEndMap() {
        return this.endMap;
    }

    public void setBeginMap(Collection<?>[] beginMap) {
        this.beginMap = beginMap;
        for (Collection<?> each : beginMap) {
            if (each == null || each.isEmpty()) continue;
            this.empty = false;
            break;
        }
    }

    public void setEndMap(Collection<?>[] endMap) {
        this.endMap = endMap;
        for (Collection<?> each : endMap) {
            if (each == null || each.isEmpty()) continue;
            this.empty = false;
            break;
        }
    }

    public void clearBeginMap() {
        this.beginMap = new ArrayList[((TypeSystemImpl)this.getCAS().getTypeSystem()).getLargestTypeCode()];
    }

    public void clearEndMap() {
        this.endMap = new ArrayList[((TypeSystemImpl)this.getCAS().getTypeSystem()).getLargestTypeCode()];
        for (Collection<?> each : this.beginMap) {
            if (each == null || each.isEmpty()) continue;
            return;
        }
        this.empty = true;
    }

    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected RutaBasic() {
    }

    public RutaBasic(TypeImpl type, CASImpl casImpl) {
        super(type, casImpl);
        this.readObject();
    }

    public RutaBasic(JCas jcas) {
        super(jcas);
        this.readObject();
    }

    public RutaBasic(JCas jcas, int begin, int end) {
        super(jcas);
        this.setBegin(begin);
        this.setEnd(end);
        this.readObject();
    }

    private void readObject() {
    }

    public String getReplacement() {
        return this._getStringValueNc(RutaBasic.wrapGetIntCatchException((MethodHandle)_FH_replacement));
    }

    public void setReplacement(String v) {
        this._setStringValueNfc(RutaBasic.wrapGetIntCatchException((MethodHandle)_FH_replacement), v);
    }

    static {
        type = typeIndexID = JCasRegistry.register(RutaBasic.class);
        _FC_replacement = TypeSystemImpl.createCallSite(RutaBasic.class, (String)_FeatName_replacement);
        _FH_replacement = _FC_replacement.dynamicInvoker();
    }
}

