/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.DBTokenStore;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.HiveDelegationTokenManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HiveAuthFactory {
    private static final SparkLogger LOG = SparkLoggerFactory.getLogger(HiveAuthFactory.class);
    private HadoopThriftAuthBridge.Server saslServer;
    private String authTypeStr;
    private final String transportMode;
    private final HiveConf conf;
    private HiveDelegationTokenManager delegationTokenManager = null;
    public static final String HS2_PROXY_USER = "hive.server2.proxy.user";
    public static final String HS2_CLIENT_TOKEN = "hiveserver2ClientToken";
    private static Method getKeytab = null;

    public HiveAuthFactory(HiveConf conf) throws TTransportException, IOException {
        this.conf = conf;
        this.transportMode = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        this.authTypeStr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        if ("http".equalsIgnoreCase(this.transportMode)) {
            if (this.authTypeStr == null) {
                this.authTypeStr = AuthTypes.NOSASL.getAuthName();
            }
        } else {
            if (this.authTypeStr == null) {
                this.authTypeStr = AuthTypes.NONE.getAuthName();
            }
            if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
                String principal = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
                String keytab = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
                this.saslServer = HiveAuthFactory.needUgiLogin(UserGroupInformation.getCurrentUser(), SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), keytab) ? ShimLoader.getHadoopThriftAuthBridge().createServer(keytab, principal) : new HadoopThriftAuthBridge.Server();
                this.delegationTokenManager = new HiveDelegationTokenManager();
                try {
                    Class<Hive> rawStore = null;
                    String tokenStoreClass = conf.getVar(HiveConf.ConfVars.METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_CLS);
                    if (tokenStoreClass.equals(DBTokenStore.class.getName())) {
                        rawStore = Hive.class;
                    }
                    this.delegationTokenManager.startDelegationTokenSecretManager((Configuration)conf, rawStore, HadoopThriftAuthBridge.Server.ServerMode.HIVESERVER2);
                    this.saslServer.setSecretManager(this.delegationTokenManager.getSecretManager());
                }
                catch (IOException e) {
                    throw new TTransportException("Failed to start token manager", (Throwable)e);
                }
            }
        }
    }

    public Map<String, String> getSaslProperties() {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        SaslQOP saslQOP = SaslQOP.fromString(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    public TTransportFactory getAuthTransFactory() throws LoginException {
        TTransportFactory transportFactory;
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            try {
                transportFactory = this.saslServer.createTransportFactory(this.getSaslProperties());
            }
            catch (TTransportException e) {
                throw new LoginException(e.getMessage());
            }
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NONE.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.LDAP.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.PAM.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NOSASL.getAuthName())) {
            transportFactory = new TTransportFactory();
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.CUSTOM.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else {
            throw new LoginException("Unsupported authentication type " + this.authTypeStr);
        }
        return transportFactory;
    }

    public TProcessorFactory getAuthProcFactory(ThriftCLIService service) throws LoginException {
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            return KerberosSaslHelper.getKerberosProcessorFactory(this.saslServer, service);
        }
        return PlainSaslHelper.getPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        return this.saslServer == null ? null : this.saslServer.getRemoteUser();
    }

    public String getIpAddress() {
        if (this.saslServer == null || this.saslServer.getRemoteAddress() == null) {
            return null;
        }
        return this.saslServer.getRemoteAddress().getHostAddress();
    }

    public static void loginFromKeytab(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 Kerberos principal or keytab is not correctly configured");
        }
        UserGroupInformation.loginUserFromKeytab((String)SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), (String)keyTabFile);
    }

    public static UserGroupInformation loginFromSpnegoKeytabAndReturnUGI(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 SPNEGO principal or keytab is not correctly configured");
        }
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), (String)keyTabFile);
    }

    public String getDelegationToken(String owner, String renewer, String remoteAddr) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            String tokenStr = this.delegationTokenManager.getDelegationTokenWithService(owner, renewer, HS2_CLIENT_TOKEN, remoteAddr);
            if (tokenStr == null || tokenStr.isEmpty()) {
                throw new HiveSQLException("Received empty retrieving delegation token for user " + owner, "08S01");
            }
            return tokenStr;
        }
        catch (IOException e) {
            throw new HiveSQLException("Error retrieving delegation token for user " + owner, "08S01", e);
        }
        catch (InterruptedException e) {
            throw new HiveSQLException("delegation token retrieval interrupted", "08S01", e);
        }
    }

    public void cancelDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            this.delegationTokenManager.cancelDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error canceling delegation token " + delegationToken, "08S01", e);
        }
    }

    public void renewDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            this.delegationTokenManager.renewDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error renewing delegation token " + delegationToken, "08S01", e);
        }
    }

    public String verifyDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            return this.delegationTokenManager.verifyDelegationToken(delegationToken);
        }
        catch (IOException e) {
            String msg = "Error verifying delegation token";
            LOG.error(msg + " {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.TOKEN, (Object)delegationToken)});
            throw new HiveSQLException(msg + delegationToken, "08S01", e);
        }
    }

    public String getUserFromToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            return this.delegationTokenManager.getUserFromToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error extracting user from delegation token " + delegationToken, "08S01", e);
        }
    }

    public static void verifyProxyAccess(String realUser, String proxyUser, String ipAddress, HiveConf hiveConf) throws HiveSQLException {
        try {
            UserGroupInformation sessionUgi;
            if (UserGroupInformation.isSecurityEnabled()) {
                HadoopShims.KerberosNameShim kerbName = ShimLoader.getHadoopShims().getKerberosNameShim(realUser);
                sessionUgi = UserGroupInformation.createProxyUser((String)kerbName.getServiceName(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            } else {
                sessionUgi = UserGroupInformation.createRemoteUser((String)realUser);
            }
            if (!proxyUser.equalsIgnoreCase(realUser)) {
                ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)hiveConf);
                ProxyUsers.authorize((UserGroupInformation)UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)sessionUgi), (String)ipAddress, (Configuration)hiveConf);
            }
        }
        catch (IOException e) {
            throw new HiveSQLException("Failed to validate proxy privilege of " + realUser + " for " + proxyUser, "08S01", e);
        }
    }

    public static boolean needUgiLogin(UserGroupInformation ugi, String principal, String keytab) {
        return null == ugi || !ugi.hasKerberosCredentials() || !ugi.getUserName().equals(principal) || !Objects.equals(keytab, HiveAuthFactory.getKeytabFromUgi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getKeytabFromUgi() {
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        synchronized (UserGroupInformation.class) {
            try {
                if (getKeytab != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return (String)getKeytab.invoke((Object)UserGroupInformation.getCurrentUser(), new Object[0]);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            catch (Exception e) {
                LOG.debug("Fail to get keytabFile path via reflection", (Throwable)e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
        }
    }

    static {
        Class<UserGroupInformation> clz = UserGroupInformation.class;
        try {
            getKeytab = clz.getDeclaredMethod("getKeytab", new Class[0]);
            getKeytab.setAccessible(true);
        }
        catch (NoSuchMethodException nme) {
            LOG.debug("Cannot find private method \"getKeytab\" in class:" + UserGroupInformation.class.getCanonicalName(), (Throwable)nme);
            getKeytab = null;
        }
    }

    public static enum AuthTypes {
        NOSASL("NOSASL"),
        NONE("NONE"),
        LDAP("LDAP"),
        KERBEROS("KERBEROS"),
        CUSTOM("CUSTOM"),
        PAM("PAM");

        private final String authType;

        private AuthTypes(String authType) {
            this.authType = authType;
        }

        public String getAuthName() {
            return this.authType;
        }
    }
}

