/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.hbase.HBaseUtils;
import org.apache.hadoop.hive.metastore.hbase.PartitionKeyComparator;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

class HBaseFilterPlanUtil {
    HBaseFilterPlanUtil() {
    }

    static int compare(byte[] ar1, byte[] ar2) {
        for (int i = 0; i < ar1.length; ++i) {
            if (i == ar2.length) {
                return 1;
            }
            if (ar1[i] == ar2[i]) continue;
            if (ar1[i] > ar2[i]) {
                return 1;
            }
            return -1;
        }
        if (ar1.length == ar2.length) {
            return 0;
        }
        return -1;
    }

    public static PlanResult getFilterPlan(ExpressionTree exprTree, List<FieldSchema> parts) throws MetaException {
        if (exprTree == null) {
            return new PlanResult(new ScanPlan(), true);
        }
        PartitionFilterGenerator pGenerator = new PartitionFilterGenerator(parts);
        exprTree.accept(pGenerator);
        return new PlanResult(pGenerator.getPlan(), pGenerator.hasUnsupportedCondition());
    }

    public static class PlanResult {
        public final FilterPlan plan;
        public final boolean hasUnsupportedCondition;

        PlanResult(FilterPlan plan, boolean hasUnsupportedCondition) {
            this.plan = plan;
            this.hasUnsupportedCondition = hasUnsupportedCondition;
        }
    }

    @VisibleForTesting
    static class PartitionFilterGenerator
    extends ExpressionTree.TreeVisitor {
        private FilterPlan curPlan;
        private boolean hasUnsupportedCondition = false;
        Map<ExpressionTree.TreeNode, FilterPlan> leftPlans = new IdentityHashMap<ExpressionTree.TreeNode, FilterPlan>();
        private FilterPlan rPlan;
        private Map<String, String> nameToType = new HashMap<String, String>();

        public PartitionFilterGenerator(List<FieldSchema> parts) {
            for (FieldSchema part : parts) {
                this.nameToType.put(part.getName(), part.getType());
            }
        }

        FilterPlan getPlan() {
            return this.curPlan;
        }

        @Override
        protected void beginTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.rPlan = null;
            this.curPlan = null;
        }

        @Override
        protected void midTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.leftPlans.put(node, this.curPlan);
            this.curPlan = null;
        }

        @Override
        protected void endTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.rPlan = this.curPlan;
            FilterPlan lPlan = this.leftPlans.get(node);
            this.leftPlans.remove(node);
            switch (node.getAndOr()) {
                case AND: {
                    this.curPlan = lPlan.and(this.rPlan);
                    break;
                }
                case OR: {
                    this.curPlan = lPlan.or(this.rPlan);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected logical operation " + (Object)((Object)node.getAndOr())));
                }
            }
        }

        @Override
        public void visit(ExpressionTree.LeafNode node) throws MetaException {
            ScanPlan leafPlan = new ScanPlan();
            this.curPlan = leafPlan;
            boolean INCLUSIVE = true;
            switch (node.operator) {
                case EQUALS: {
                    leafPlan.setStartMarker(node.keyName, this.nameToType.get(node.keyName), node.value.toString(), true);
                    leafPlan.setEndMarker(node.keyName, this.nameToType.get(node.keyName), node.value.toString(), true);
                    break;
                }
                case GREATERTHAN: {
                    leafPlan.setStartMarker(node.keyName, this.nameToType.get(node.keyName), node.value.toString(), false);
                    break;
                }
                case GREATERTHANOREQUALTO: {
                    leafPlan.setStartMarker(node.keyName, this.nameToType.get(node.keyName), node.value.toString(), true);
                    break;
                }
                case LESSTHAN: {
                    leafPlan.setEndMarker(node.keyName, this.nameToType.get(node.keyName), node.value.toString(), false);
                    break;
                }
                case LESSTHANOREQUALTO: {
                    leafPlan.setEndMarker(node.keyName, this.nameToType.get(node.keyName), node.value.toString(), true);
                    break;
                }
                case LIKE: {
                    leafPlan.ops.add(new PartitionKeyComparator.Operator(PartitionKeyComparator.Operator.Type.LIKE, node.keyName, node.value.toString()));
                    break;
                }
                case NOTEQUALS: 
                case NOTEQUALS2: {
                    leafPlan.ops.add(new PartitionKeyComparator.Operator(PartitionKeyComparator.Operator.Type.NOTEQUALS, node.keyName, node.value.toString()));
                }
            }
        }

        private boolean hasUnsupportedCondition() {
            return this.hasUnsupportedCondition;
        }
    }

    public static class ScanPlan
    extends FilterPlan {
        Map<String, ScanMarkerPair> markers = new HashMap<String, ScanMarkerPair>();
        List<PartitionKeyComparator.Operator> ops = new ArrayList<PartitionKeyComparator.Operator>();

        private int getMajorPartsCount(List<FieldSchema> parts) {
            int majorPartsCount;
            for (majorPartsCount = 0; majorPartsCount < parts.size() && this.markers.containsKey(parts.get(majorPartsCount).getName()); ++majorPartsCount) {
                ScanMarkerPair pair = this.markers.get(parts.get(majorPartsCount).getName());
                if (pair.startMarker != null && pair.endMarker != null && pair.startMarker.value.equals(pair.endMarker.value) && pair.startMarker.isInclusive && pair.endMarker.isInclusive) continue;
            }
            return majorPartsCount;
        }

        public Filter getFilter(List<FieldSchema> parts) {
            int majorPartsCount = this.getMajorPartsCount(parts);
            HashSet<String> majorKeys = new HashSet<String>();
            for (int i = 0; i < majorPartsCount; ++i) {
                majorKeys.add(parts.get(i).getName());
            }
            List<String> names = HBaseUtils.getPartitionNames(parts);
            ArrayList<PartitionKeyComparator.Range> ranges = new ArrayList<PartitionKeyComparator.Range>();
            for (Map.Entry<String, ScanMarkerPair> entry : this.markers.entrySet()) {
                if (!names.contains(entry.getKey()) || majorKeys.contains(entry.getKey())) continue;
                PartitionKeyComparator.Mark startMark = null;
                if (entry.getValue().startMarker != null) {
                    startMark = new PartitionKeyComparator.Mark(entry.getValue().startMarker.value, entry.getValue().startMarker.isInclusive);
                }
                PartitionKeyComparator.Mark endMark = null;
                if (entry.getValue().endMarker != null) {
                    startMark = new PartitionKeyComparator.Mark(entry.getValue().endMarker.value, entry.getValue().endMarker.isInclusive);
                }
                PartitionKeyComparator.Range range = new PartitionKeyComparator.Range(entry.getKey(), startMark, endMark);
                ranges.add(range);
            }
            if (ranges.isEmpty() && this.ops.isEmpty()) {
                return null;
            }
            return new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new PartitionKeyComparator(StringUtils.join(names, (String)","), StringUtils.join(HBaseUtils.getPartitionKeyTypes(parts), (String)","), ranges, this.ops));
        }

        public void setStartMarker(String keyName, String keyType, String start, boolean isInclusive) {
            if (this.markers.containsKey(keyName)) {
                this.markers.get((Object)keyName).startMarker = new ScanMarker(start, isInclusive, keyType);
            } else {
                ScanMarkerPair marker = new ScanMarkerPair(new ScanMarker(start, isInclusive, keyType), null);
                this.markers.put(keyName, marker);
            }
        }

        public ScanMarker getStartMarker(String keyName) {
            if (this.markers.containsKey(keyName)) {
                return this.markers.get((Object)keyName).startMarker;
            }
            return null;
        }

        public void setEndMarker(String keyName, String keyType, String end, boolean isInclusive) {
            if (this.markers.containsKey(keyName)) {
                this.markers.get((Object)keyName).endMarker = new ScanMarker(end, isInclusive, keyType);
            } else {
                ScanMarkerPair marker = new ScanMarkerPair(null, new ScanMarker(end, isInclusive, keyType));
                this.markers.put(keyName, marker);
            }
        }

        public ScanMarker getEndMarker(String keyName) {
            if (this.markers.containsKey(keyName)) {
                return this.markers.get((Object)keyName).endMarker;
            }
            return null;
        }

        @Override
        public FilterPlan and(FilterPlan other) {
            ArrayList<ScanPlan> newSPlans = new ArrayList<ScanPlan>();
            for (ScanPlan otherSPlan : other.getPlans()) {
                newSPlans.add(this.and(otherSPlan));
            }
            return new MultiScanPlan(newSPlans);
        }

        private ScanPlan and(ScanPlan other) {
            ScanPlan newPlan = new ScanPlan();
            newPlan.markers.putAll(this.markers);
            for (String keyName : other.markers.keySet()) {
                if (newPlan.markers.containsKey(keyName)) {
                    ScanMarker lesserEndMarker;
                    ScanMarker greaterStartMarker = ScanPlan.getComparedMarker(this.getStartMarker(keyName), other.getStartMarker(keyName), true);
                    if (greaterStartMarker != null) {
                        newPlan.setStartMarker(keyName, greaterStartMarker.type, greaterStartMarker.value, greaterStartMarker.isInclusive);
                    }
                    if ((lesserEndMarker = ScanPlan.getComparedMarker(this.getEndMarker(keyName), other.getEndMarker(keyName), false)) == null) continue;
                    newPlan.setEndMarker(keyName, lesserEndMarker.type, lesserEndMarker.value, lesserEndMarker.isInclusive);
                    continue;
                }
                newPlan.markers.put(keyName, other.markers.get(keyName));
            }
            newPlan.ops.addAll(this.ops);
            newPlan.ops.addAll(other.ops);
            return newPlan;
        }

        @VisibleForTesting
        static ScanMarker getComparedMarker(ScanMarker lStartMarker, ScanMarker rStartMarker, boolean getGreater) {
            Comparable rValue;
            if (lStartMarker == null) {
                return rStartMarker;
            }
            if (rStartMarker == null) {
                return lStartMarker;
            }
            TypeInfo expectedType = TypeInfoUtils.getTypeInfoFromTypeString((String)lStartMarker.type);
            ObjectInspector outputOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)expectedType);
            ObjectInspectorConverters.Converter lConverter = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)outputOI);
            ObjectInspectorConverters.Converter rConverter = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)outputOI);
            Comparable lValue = (Comparable)lConverter.convert((Object)lStartMarker.value);
            int compareRes = lValue.compareTo(rValue = (Comparable)rConverter.convert((Object)rStartMarker.value));
            if (compareRes == 0) {
                if (lStartMarker.isInclusive == rStartMarker.isInclusive) {
                    return lStartMarker;
                }
                boolean isInclusive = true;
                if (getGreater) {
                    isInclusive = false;
                }
                return new ScanMarker(lStartMarker.value, isInclusive, lStartMarker.type);
            }
            if (getGreater) {
                return compareRes == 1 ? lStartMarker : rStartMarker;
            }
            return compareRes == -1 ? lStartMarker : rStartMarker;
        }

        @Override
        public FilterPlan or(FilterPlan other) {
            ArrayList<ScanPlan> plans = new ArrayList<ScanPlan>(this.getPlans());
            plans.addAll(other.getPlans());
            return new MultiScanPlan(plans);
        }

        @Override
        public List<ScanPlan> getPlans() {
            return Arrays.asList(this);
        }

        public byte[] getStartRowSuffix(String dbName, String tableName, List<FieldSchema> parts) {
            int majorPartsCount = this.getMajorPartsCount(parts);
            ArrayList<String> majorPartTypes = new ArrayList<String>();
            ArrayList<String> components = new ArrayList<String>();
            boolean endPrefix = false;
            for (int i = 0; i < majorPartsCount; ++i) {
                majorPartTypes.add(parts.get(i).getType());
                ScanMarker marker = this.markers.get((Object)parts.get((int)i).getName()).startMarker;
                if (marker != null) {
                    components.add(marker.value);
                    if (i != majorPartsCount - 1) continue;
                    endPrefix = !marker.isInclusive;
                    continue;
                }
                components.add(null);
                if (i != majorPartsCount - 1) continue;
                endPrefix = false;
            }
            byte[] bytes = HBaseUtils.buildPartitionKey(dbName, tableName, majorPartTypes, components, endPrefix);
            return bytes;
        }

        public byte[] getEndRowSuffix(String dbName, String tableName, List<FieldSchema> parts) {
            int majorPartsCount = this.getMajorPartsCount(parts);
            ArrayList<String> majorPartTypes = new ArrayList<String>();
            ArrayList<String> components = new ArrayList<String>();
            boolean endPrefix = false;
            for (int i = 0; i < majorPartsCount; ++i) {
                majorPartTypes.add(parts.get(i).getType());
                ScanMarker marker = this.markers.get((Object)parts.get((int)i).getName()).endMarker;
                if (marker != null) {
                    components.add(marker.value);
                    if (i != majorPartsCount - 1) continue;
                    endPrefix = marker.isInclusive;
                    continue;
                }
                components.add(null);
                if (i != majorPartsCount - 1) continue;
                endPrefix = true;
            }
            byte[] bytes = HBaseUtils.buildPartitionKey(dbName, tableName, majorPartTypes, components, endPrefix);
            if (components.isEmpty()) {
                int n = bytes.length - 1;
                bytes[n] = (byte)(bytes[n] + 1);
            }
            return bytes;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ScanPlan:\n");
            for (Map.Entry<String, ScanMarkerPair> entry : this.markers.entrySet()) {
                sb.append("key=" + entry.getKey() + "[startMarker=" + entry.getValue().startMarker + ", endMarker=" + entry.getValue().endMarker + "]");
            }
            return sb.toString();
        }

        public static class ScanMarkerPair {
            ScanMarker startMarker;
            ScanMarker endMarker;

            public ScanMarkerPair(ScanMarker startMarker, ScanMarker endMarker) {
                this.startMarker = startMarker;
                this.endMarker = endMarker;
            }
        }

        public static class ScanMarker {
            final String value;
            final boolean isInclusive;
            final String type;

            ScanMarker(String obj, boolean i, String type) {
                this.value = obj;
                this.isInclusive = i;
                this.type = type;
            }

            public String toString() {
                return "ScanMarker [value=" + this.value.toString() + ", isInclusive=" + this.isInclusive + ", type=" + this.type + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.value.hashCode();
                result = 31 * result + (this.isInclusive ? 1231 : 1237);
                result = 31 * result + this.type.hashCode();
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ScanMarker other = (ScanMarker)obj;
                if (!this.value.equals(other.value)) {
                    return false;
                }
                if (this.isInclusive != other.isInclusive) {
                    return false;
                }
                return this.type == other.type;
            }
        }
    }

    public static class MultiScanPlan
    extends FilterPlan {
        final ImmutableList<ScanPlan> scanPlans;

        public MultiScanPlan(List<ScanPlan> scanPlans) {
            this.scanPlans = ImmutableList.copyOf(scanPlans);
        }

        @Override
        public FilterPlan and(FilterPlan other) {
            ArrayList<FilterPlan> newFPlans = new ArrayList<FilterPlan>();
            for (ScanPlan splan : this.getPlans()) {
                newFPlans.add(splan.and(other));
            }
            ArrayList<ScanPlan> newScanPlans = new ArrayList<ScanPlan>();
            for (FilterPlan fp : newFPlans) {
                newScanPlans.addAll(fp.getPlans());
            }
            return new MultiScanPlan(newScanPlans);
        }

        @Override
        public FilterPlan or(FilterPlan other) {
            ArrayList<ScanPlan> newScanPlans = new ArrayList<ScanPlan>(this.getPlans());
            newScanPlans.addAll(other.getPlans());
            return new MultiScanPlan(newScanPlans);
        }

        @Override
        public List<ScanPlan> getPlans() {
            return this.scanPlans;
        }
    }

    public static abstract class FilterPlan {
        abstract FilterPlan and(FilterPlan var1);

        abstract FilterPlan or(FilterPlan var1);

        abstract List<ScanPlan> getPlans();

        public String toString() {
            return this.getPlans().toString();
        }
    }
}

