/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.mllib.feature.ChiSqSelector$;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001\u0002\u0017.\u0001aBQa\u0013\u0001\u0005\u00021Cq\u0001\u0017\u0001A\u0002\u0013\u0005\u0011\fC\u0004^\u0001\u0001\u0007I\u0011\u00010\t\r\u0011\u0004\u0001\u0015)\u0003[\u0011\u001d)\u0007\u00011A\u0005\u0002\u0019DqA\u001b\u0001A\u0002\u0013\u00051\u000e\u0003\u0004n\u0001\u0001\u0006Ka\u001a\u0005\b]\u0002\u0001\r\u0011\"\u0001g\u0011\u001dy\u0007\u00011A\u0005\u0002ADaA\u001d\u0001!B\u00139\u0007bB:\u0001\u0001\u0004%\tA\u001a\u0005\bi\u0002\u0001\r\u0011\"\u0001v\u0011\u00199\b\u0001)Q\u0005O\"9\u0001\u0010\u0001a\u0001\n\u00031\u0007bB=\u0001\u0001\u0004%\tA\u001f\u0005\u0007y\u0002\u0001\u000b\u0015B4\t\u000fu\u0004\u0001\u0019!C\u0001}\"I\u0011q\u0002\u0001A\u0002\u0013\u0005\u0011\u0011\u0003\u0005\b\u0003+\u0001\u0001\u0015)\u0003\u0000\u0011\u0019Y\u0005\u0001\"\u0001\u0002\u0018!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`\u001dA\u0011qQ\u0017\t\u0002E\nIIB\u0004-[!\u0005\u0011'a#\t\r-kB\u0011AAN\u0011%\ti*\bb\u0001\n\u0003\td\u0010C\u0004\u0002 v\u0001\u000b\u0011B@\t\u0013\u0005\u0005VD1A\u0005\u0002Er\bbBAR;\u0001\u0006Ia \u0005\n\u0003Kk\"\u0019!C\u0001cyDq!a*\u001eA\u0003%q\u0010C\u0005\u0002*v\u0011\r\u0011\"\u00012}\"9\u00111V\u000f!\u0002\u0013y\b\"CAW;\t\u0007I\u0011A\u0019\u007f\u0011\u001d\ty+\bQ\u0001\n}D\u0011\"!-\u001e\u0005\u0004%\t!a-\t\u0011\u0005mV\u0004)A\u0005\u0003kC\u0011\"!0\u001e\u0003\u0003%I!a0\u0003\u001b\rC\u0017nU9TK2,7\r^8s\u0015\tqs&A\u0004gK\u0006$XO]3\u000b\u0005A\n\u0014!B7mY&\u0014'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0005J\u0004\u0002B\r:\u0011!)R\u0007\u0002\u0007*\u0011AiN\u0001\u0007yI|w\u000e\u001e \n\u0003qJ!aR\u001e\u0002\u000fA\f7m[1hK&\u0011\u0011J\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u000fn\na\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"A\u0017)\u0007\u0005\u0001f\u000b\u0005\u0002R)6\t!K\u0003\u0002Tc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005U\u0013&!B*j]\u000e,\u0017%A,\u0002\u000bIr\u0013G\f\u0019\u0002\u001d9,X\u000eV8q\r\u0016\fG/\u001e:fgV\t!\f\u0005\u0002;7&\u0011Al\u000f\u0002\u0004\u0013:$\u0018A\u00058v[R{\u0007OR3biV\u0014Xm]0%KF$\"a\u00182\u0011\u0005i\u0002\u0017BA1<\u0005\u0011)f.\u001b;\t\u000f\r\u001c\u0011\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002\u001f9,X\u000eV8q\r\u0016\fG/\u001e:fg\u0002\n!\u0002]3sG\u0016tG/\u001b7f+\u00059\u0007C\u0001\u001ei\u0013\tI7H\u0001\u0004E_V\u0014G.Z\u0001\u000fa\u0016\u00148-\u001a8uS2,w\fJ3r)\tyF\u000eC\u0004d\r\u0005\u0005\t\u0019A4\u0002\u0017A,'oY3oi&dW\rI\u0001\u0004MB\u0014\u0018a\u00024qe~#S-\u001d\u000b\u0003?FDqaY\u0005\u0002\u0002\u0003\u0007q-\u0001\u0003gaJ\u0004\u0013a\u00014ee\u00069a\r\u001a:`I\u0015\fHCA0w\u0011\u001d\u0019G\"!AA\u0002\u001d\fAA\u001a3sA\u0005\u0019am^3\u0002\u000f\u0019<Xm\u0018\u0013fcR\u0011ql\u001f\u0005\bG>\t\t\u00111\u0001h\u0003\u00111w/\u001a\u0011\u0002\u0019M,G.Z2u_J$\u0016\u0010]3\u0016\u0003}\u0004B!!\u0001\u0002\n9!\u00111AA\u0003!\t\u00115(C\u0002\u0002\bm\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004w\u0005\u00012/\u001a7fGR|'\u000fV=qK~#S-\u001d\u000b\u0004?\u0006M\u0001bB2\u0013\u0003\u0003\u0005\ra`\u0001\u000eg\u0016dWm\u0019;peRK\b/\u001a\u0011\u0015\u00075\u000bI\u0002C\u0003Y)\u0001\u0007!\f\u000b\u0003\u0015!\u0006u\u0011EAA\u0010\u0003\u0015\tdf\r\u00181\u0003E\u0019X\r\u001e(v[R{\u0007OR3biV\u0014Xm\u001d\u000b\u0005\u0003K\t9#D\u0001\u0001\u0011\u0019\tI#\u0006a\u00015\u0006)a/\u00197vK\"\"Q\u0003UA\u0017C\t\ty#A\u00032]Yr\u0003'A\u0007tKR\u0004VM]2f]RLG.\u001a\u000b\u0005\u0003K\t)\u0004\u0003\u0004\u0002*Y\u0001\ra\u001a\u0015\u0004-A3\u0016AB:fi\u001a\u0003(\u000f\u0006\u0003\u0002&\u0005u\u0002BBA\u0015/\u0001\u0007q\rK\u0002\u0018!Z\u000baa]3u\r\u0012\u0014H\u0003BA\u0013\u0003\u000bBa!!\u000b\u0019\u0001\u00049\u0007\u0006\u0002\rQ\u0003\u0013\n#!a\u0013\u0002\u000bIr#G\f\u0019\u0002\rM,GOR<f)\u0011\t)#!\u0015\t\r\u0005%\u0012\u00041\u0001hQ\u0011I\u0002+!\u0013\u0002\u001fM,GoU3mK\u000e$xN\u001d+za\u0016$B!!\n\u0002Z!1\u0011\u0011\u0006\u000eA\u0002}D3A\u0007)W\u0003\r1\u0017\u000e\u001e\u000b\u0005\u0003C\n9\u0007E\u0002O\u0003GJ1!!\u001a.\u0005I\u0019\u0005.[*r'\u0016dWm\u0019;pe6{G-\u001a7\t\u000f\u0005%4\u00041\u0001\u0002l\u0005!A-\u0019;b!\u0019\ti'a\u001d\u0002x5\u0011\u0011q\u000e\u0006\u0004\u0003c\n\u0014a\u0001:eI&!\u0011QOA8\u0005\r\u0011F\t\u0012\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP\u0018\u0002\u0015I,wM]3tg&|g.\u0003\u0003\u0002\u0002\u0006m$\u0001\u0004'bE\u0016dW\r\u001a)pS:$\b\u0006B\u000eQ\u0003;AC\u0001\u0001)\u0002\u001e\u0005i1\t[5TcN+G.Z2u_J\u0004\"AT\u000f\u0014\tuI\u0014Q\u0012\t\u0005\u0003\u001f\u000bI*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003\tIwN\u0003\u0002\u0002\u0018\u0006!!.\u0019<b\u0013\rI\u0015\u0011\u0013\u000b\u0003\u0003\u0013\u000baBT;n)>\u0004h)Z1ukJ,7/A\bOk6$v\u000e\u001d$fCR,(/Z:!\u0003)\u0001VM]2f]RLG.Z\u0001\f!\u0016\u00148-\u001a8uS2,\u0007%A\u0002G!J\u000bAA\u0012)SA\u0005\u0019a\t\u0012*\u0002\t\u0019#%\u000bI\u0001\u0004\r^+\u0015\u0001\u0002$X\u000b\u0002\nac];qa>\u0014H/\u001a3TK2,7\r^8s)f\u0004Xm]\u000b\u0003\u0003k\u0003BAOA\\\u007f&\u0019\u0011\u0011X\u001e\u0003\u000b\u0005\u0013(/Y=\u0002/M,\b\u000f]8si\u0016$7+\u001a7fGR|'\u000fV=qKN\u0004\u0013\u0001D<sSR,'+\u001a9mC\u000e,GCAAa!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'\u0002BAd\u0003+\u000bA\u0001\\1oO&!\u00111ZAc\u0005\u0019y%M[3di\u0002")
public class ChiSqSelector
implements Serializable {
    private int numTopFeatures = 50;
    private double percentile = 0.1;
    private double fpr = 0.05;
    private double fdr = 0.05;
    private double fwe = 0.05;
    private String selectorType = ChiSqSelector$.MODULE$.NumTopFeatures();

    public static String[] supportedSelectorTypes() {
        return ChiSqSelector$.MODULE$.supportedSelectorTypes();
    }

    public int numTopFeatures() {
        return this.numTopFeatures;
    }

    public void numTopFeatures_$eq(int x$1) {
        this.numTopFeatures = x$1;
    }

    public double percentile() {
        return this.percentile;
    }

    public void percentile_$eq(double x$1) {
        this.percentile = x$1;
    }

    public double fpr() {
        return this.fpr;
    }

    public void fpr_$eq(double x$1) {
        this.fpr = x$1;
    }

    public double fdr() {
        return this.fdr;
    }

    public void fdr_$eq(double x$1) {
        this.fdr = x$1;
    }

    public double fwe() {
        return this.fwe;
    }

    public void fwe_$eq(double x$1) {
        this.fwe = x$1;
    }

    public String selectorType() {
        return this.selectorType;
    }

    public void selectorType_$eq(String x$1) {
        this.selectorType = x$1;
    }

    public ChiSqSelector setNumTopFeatures(int value) {
        this.numTopFeatures_$eq(value);
        return this;
    }

    public ChiSqSelector setPercentile(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable)() -> "Percentile must be in [0,1]");
        this.percentile_$eq(value);
        return this;
    }

    public ChiSqSelector setFpr(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable)() -> "FPR must be in [0,1]");
        this.fpr_$eq(value);
        return this;
    }

    public ChiSqSelector setFdr(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable)() -> "FDR must be in [0,1]");
        this.fdr_$eq(value);
        return this;
    }

    public ChiSqSelector setFwe(double value) {
        Predef$.MODULE$.require(0.0 <= value && value <= 1.0, (Function0 & Serializable)() -> "FWE must be in [0,1]");
        this.fwe_$eq(value);
        return this;
    }

    public ChiSqSelector setSelectorType(String value) {
        Predef$.MODULE$.require(ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ChiSqSelector$.MODULE$.supportedSelectorTypes()), (Object)value), (Function0 & Serializable)() -> "ChiSqSelector Type: " + value + " was not supported.");
        this.selectorType_$eq(value);
        return this;
    }

    public ChiSqSelectorModel fit(RDD<LabeledPoint> data) {
        Tuple2[] tuple2Array;
        Tuple2[] chiSqTestResult = ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])Statistics$.MODULE$.chiSqTest(data)));
        String string = this.selectorType();
        String string2 = ChiSqSelector$.MODULE$.NumTopFeatures();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2Array = (Tuple2[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$1(x0$1)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), this.numTopFeatures());
        } else {
            String string4 = ChiSqSelector$.MODULE$.Percentile();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2Array = (Tuple2[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult), (Function1 & Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$2(x0$2)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), (int)((double)chiSqTestResult.length * this.percentile()));
            } else {
                String string6 = ChiSqSelector$.MODULE$.FPR();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    tuple2Array = (Tuple2[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult), (Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$3(this, x0$3)));
                } else {
                    String string8 = ChiSqSelector$.MODULE$.FDR();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        Tuple2[] tempRes = (Tuple2[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult), (Function1 & Serializable)x0$4 -> BoxesRunTime.boxToDouble((double)ChiSqSelector.$anonfun$fit$4(x0$4)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
                        Tuple2[] selected = (Tuple2[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])tempRes))), (Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$5(this, chiSqTestResult, x0$5)));
                        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])selected))) {
                            tuple2Array = (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
                        } else {
                            int maxIndex = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])selected), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._2$mcI$sp()), (ClassTag)ClassTag$.MODULE$.Int())).max((Ordering)Ordering.Int$.MODULE$));
                            tuple2Array = (Tuple2[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])tempRes), maxIndex + 1);
                        }
                    } else {
                        String string10 = ChiSqSelector$.MODULE$.FWE();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            tuple2Array = (Tuple2[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])chiSqTestResult), (Function1 & Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ChiSqSelector.$anonfun$fit$7(this, chiSqTestResult, x0$6)));
                        } else {
                            throw new IllegalArgumentException("Unknown ChiSqSelector Type: " + string);
                        }
                    }
                }
            }
        }
        Tuple2[] features = tuple2Array;
        int[] indices = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])features), (Function1 & Serializable)x0$7 -> BoxesRunTime.boxToInteger((int)ChiSqSelector.$anonfun$fit$8(x0$7)), (ClassTag)ClassTag$.MODULE$.Int());
        return new ChiSqSelectorModel(indices);
    }

    public static final /* synthetic */ double $anonfun$fit$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$fit$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$fit$3(ChiSqSelector $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue() < $this.fpr();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$fit$4(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$fit$5(ChiSqSelector $this, Tuple2[] chiSqTestResult$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                ChiSqTestResult res = (ChiSqTestResult)tuple22._1();
                return res.pValue() <= $this.fdr() * (double)(index + 1) / (double)chiSqTestResult$1.length;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$fit$7(ChiSqSelector $this, Tuple2[] chiSqTestResult$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            ChiSqTestResult res = (ChiSqTestResult)tuple2._1();
            return res.pValue() < $this.fwe() / (double)chiSqTestResult$1.length;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$fit$8(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            int index = tuple2._2$mcI$sp();
            return index;
        }
        throw new MatchError((Object)tuple2);
    }

    public ChiSqSelector() {
    }

    public ChiSqSelector(int numTopFeatures) {
        this();
        this.numTopFeatures_$eq(numTopFeatures);
    }
}

