/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.XmlToStructs$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.xml.XmlToStructsEvaluator;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xmlStr, schema[, options]) - Returns a struct value with the given `xmlStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('<p><a>1</a><b>0.8</b></p>', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('<p><time>26/08/2015</time></p>', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('<p><teacher>Alice</teacher><student><name>Bob</name><rank>1</rank></student><student><name>Charlie</name><rank>2</rank></student></p>', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="xml_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001B\u00193\u0001~B\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tU\u0002\u0011\t\u0012)A\u0005I\"A1\u000e\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005y\u0001\tE\t\u0015!\u0003n\u0011!I\bA!f\u0001\n\u0003Q\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011B>\t\u0013}\u0004!Q3A\u0005\u0002\u0005\u0005\u0001BCA\u0005\u0001\tE\t\u0015!\u0003\u0002\u0004!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u0006\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\tY\u0003\u0001C!\u0003GA\u0001\"!\f\u0001\u0005\u0004%Ia\u0019\u0005\b\u0003_\u0001\u0001\u0015!\u0003e\u0011\u001d\tY\u0001\u0001C\u0001\u0003cAq!a\u0003\u0001\t\u0003\t9\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u0015\u0005=\u0003\u0001#b\u0001\n\u0013\t\t\u0006C\u0005\u0002h\u0001\u0011\r\u0011\"\u0003\u0002j!9\u00111\u000e\u0001!\u0002\u0013)\bBBA7\u0001\u0011\u00053\rC\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x!9\u0011\u0011\u0011\u0001\u0005R\u0005\r\u0005bBAP\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003_\u0003A\u0011IA5\u0011\u001d\t\t\f\u0001C\t\u0003gC\u0011\"!/\u0001\u0003\u0003%\t!a/\t\u0013\u0005\u0015\u0007!%A\u0005\u0002\u0005\u001d\u0007\"CAo\u0001E\u0005I\u0011AAp\u0011%\t\u0019\u000fAI\u0001\n\u0003\t)\u000fC\u0005\u0002j\u0002\t\n\u0011\"\u0001\u0002l\"I\u0011q\u001e\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001f\u0005\n\u0005\u0003\u0001\u0011\u0011!C\u0001\u0005\u0007A\u0011Ba\u0003\u0001\u0003\u0003%\tA!\u0004\t\u0013\tM\u0001!!A\u0005B\tU\u0001\"\u0003B\u0012\u0001\u0005\u0005I\u0011\u0001B\u0013\u0011%\u0011I\u0003AA\u0001\n\u0003\u0012Y\u0003C\u0005\u00030\u0001\t\t\u0011\"\u0011\u00032\u001dI!Q\u000b\u001a\u0002\u0002#\u0005!q\u000b\u0004\tcI\n\t\u0011#\u0001\u0003Z!9\u00111B\u0015\u0005\u0002\tE\u0004\"\u0003B:S\u0005\u0005IQ\tB;\u0011%\u00119(KA\u0001\n\u0003\u0013I\bC\u0005\u0003\u0004&\n\n\u0011\"\u0001\u0002l\"I!QQ\u0015\u0002\u0002\u0013\u0005%q\u0011\u0005\n\u0005+K\u0013\u0013!C\u0001\u0003WD\u0011Ba&*\u0003\u0003%IA!'\u0003\u0019akG\u000eV8TiJ,8\r^:\u000b\u0005M\"\u0014aC3yaJ,7o]5p]NT!!\u000e\u001c\u0002\u0011\r\fG/\u00197zgRT!a\u000e\u001d\u0002\u0007M\fHN\u0003\u0002:u\u0005)1\u000f]1sW*\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001!E\u000f*\u0003f\u000b\u0005\u0002B\u00056\t!'\u0003\u0002De\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002B\u000b&\u0011aI\r\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"!\u0011%\n\u0005%\u0013$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u00111JT\u0007\u0002\u0019*\u0011QJN\u0001\u0007KJ\u0014xN]:\n\u0005=c%aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005E#V\"\u0001*\u000b\u0003M\u000bQa]2bY\u0006L!!\u0016*\u0003\u000fA\u0013x\u000eZ;diB\u0011qk\u0018\b\u00031vs!!\u0017/\u000e\u0003iS!a\u0017 \u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0016B\u00010S\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005y\u0013\u0016AB:dQ\u0016l\u0017-F\u0001e!\t)\u0007.D\u0001g\u0015\t9g'A\u0003usB,7/\u0003\u0002jM\nAA)\u0019;b)f\u0004X-A\u0004tG\",W.\u0019\u0011\u0002\u000f=\u0004H/[8ogV\tQ\u000e\u0005\u0003oeV,hBA8q!\tI&+\u0003\u0002r%\u00061\u0001K]3eK\u001aL!a\u001d;\u0003\u00075\u000b\u0007O\u0003\u0002r%B\u0011aN^\u0005\u0003oR\u0014aa\u0015;sS:<\u0017\u0001C8qi&|gn\u001d\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003m\u0004\"!\u0011?\n\u0005u\u0014$AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n!\u0002^5nKj{g.Z%e+\t\t\u0019\u0001\u0005\u0003R\u0003\u000b)\u0018bAA\u0004%\n1q\n\u001d;j_:\f1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"\"\"a\u0004\u0002\u0012\u0005M\u0011QCA\f!\t\t\u0005\u0001C\u0003c\u0013\u0001\u0007A\rC\u0003l\u0013\u0001\u0007Q\u000eC\u0003z\u0013\u0001\u00071\u0010\u0003\u0005\u0000\u0013A\u0005\t\u0019AA\u0002)!\ty!a\u0007\u0002\u001e\u0005}\u0001\"B=\u000b\u0001\u0004Y\b\"\u00022\u000b\u0001\u0004Y\b\"B6\u000b\u0001\u0004i\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005\u0015\u0002cA)\u0002(%\u0019\u0011\u0011\u0006*\u0003\u000f\t{w\u000e\\3b]\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$\u0018A\u00048vY2\f'\r\\3TG\",W.Y\u0001\u0010]VdG.\u00192mKN\u001b\u0007.Z7bAQ1\u0011qBA\u001a\u0003kAQ!_\bA\u0002mDQAY\bA\u0002m$\u0002\"a\u0004\u0002:\u0005m\u0012Q\b\u0005\u0006sB\u0001\ra\u001f\u0005\u0006EB\u0001\ra\u001f\u0005\u0006WB\u0001\ra_\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013\"\u0014\u0001C1oC2L8/[:\n\t\u00055\u0013q\t\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006IQM^1mk\u0006$xN]\u000b\u0003\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033\u0012\u0014a\u0001=nY&!\u0011QLA,\u0005UAV\u000e\u001c+p'R\u0014Xo\u0019;t\u000bZ\fG.^1u_JD3AEA1!\r\t\u00161M\u0005\u0004\u0003K\u0012&!\u0003;sC:\u001c\u0018.\u001a8u\u0003Mq\u0017-\\3PM\u000e{'O];qiJ+7m\u001c:e+\u0005)\u0018\u0001\u00068b[\u0016|emQ8seV\u0004HOU3d_J$\u0007%\u0001\u0005eCR\fG+\u001f9f\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\r!\u00151\u000f\u0005\u0006\u007fZ\u0001\r!^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u0003s\ny\bE\u0002R\u0003wJ1!! S\u0005\r\te.\u001f\u0005\b\u00033:\u0002\u0019AA=\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0006\u0006E\u00151\u0014\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111\u0012\u001a\u0002\u000f\r|G-Z4f]&!\u0011qRAE\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBAJ1\u0001\u0007\u0011QS\u0001\u0004GRD\b\u0003BAD\u0003/KA!!'\u0002\n\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBAO1\u0001\u0007\u0011QQ\u0001\u0003KZ\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\u0019\u000bE\u0003X\u0003K\u000bI+C\u0002\u0002(\u0006\u00141aU3r!\r)\u00171V\u0005\u0004\u0003[3'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\t\u0005=\u0011Q\u0017\u0005\u0007\u0003o[\u0002\u0019A>\u0002\u00119,wo\u00115jY\u0012\fAaY8qsRQ\u0011qBA_\u0003\u007f\u000b\t-a1\t\u000f\td\u0002\u0013!a\u0001I\"91\u000e\bI\u0001\u0002\u0004i\u0007bB=\u001d!\u0003\u0005\ra\u001f\u0005\t\u007fr\u0001\n\u00111\u0001\u0002\u0004\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAeU\r!\u00171Z\u0016\u0003\u0003\u001b\u0004B!a4\u0002Z6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u001b*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\\\u0006E'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAqU\ri\u00171Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t9OK\u0002|\u0003\u0017\fabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002n*\"\u00111AAf\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001f\t\u0005\u0003k\fy0\u0004\u0002\u0002x*!\u0011\u0011`A~\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0018\u0001\u00026bm\u0006L1a^A|\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011)\u0001E\u0002R\u0005\u000fI1A!\u0003S\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tIHa\u0004\t\u0013\tE1%!AA\u0002\t\u0015\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0018A1!\u0011\u0004B\u0010\u0003sj!Aa\u0007\u000b\u0007\tu!+\u0001\u0006d_2dWm\u0019;j_:LAA!\t\u0003\u001c\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)Ca\n\t\u0013\tEQ%!AA\u0002\u0005e\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a=\u0003.!I!\u0011\u0003\u0014\u0002\u0002\u0003\u0007!QA\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\"1\u0007\u0005\n\u0005#9\u0013\u0011!a\u0001\u0003sB3\u0003\u0001B\u001c\u0005{\u0011yDa\u0011\u0003F\t%#1\nB(\u0005#\u00022!\u0011B\u001d\u0013\r\u0011YD\r\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011\t%\u00011`\rVs5i\u0018\u0015y[2\u001cFO\u001d\u0017!g\u000eDW-\\1\\Y\u0001z\u0007\u000f^5p]Nl\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\u000f\u001e:vGR\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!i\",\u0007eZ5wK:\u0004\u0003\r_7m'R\u0014\b\rI1oI\u0002\u00027o\u00195f[\u0006\u0004g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u00119%\u0001CL\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C\b\u001d =Cz\nDhL1?y\tt\u0004G\f\u001d=_\ttDh\f9?O1\u0002s%\u0019\u0011J\u001dRc\u0003E\u0019\u0011E\u001fV\u0013E*R\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;c1\u0012#M\t\u001e1]aj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014=azbD/[7f}I2t\u0006\r\u001d0eA\nT\u0007P\u0018uS6,g\bP\u0018q}\u001db\u0003e\n;j[\u0016\u0004C+[7fgR\fW\u000e]\u0014-A5\f\u0007\u000fK\u0014uS6,7\u000f^1na\u001a{'/\\1uO1\u0002s\u0005\u001a30\u001b6{\u00130_=zO%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#i&lWM\t\u001e3aE*T\u0006\r\u001d.eY\u0002\u0003\u0007\r\u001e1ai\u0002\u0004' \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oq\u0002h\b\u0010;fC\u000eDWM\u001d BY&\u001cW\rP\u0018uK\u0006\u001c\u0007.\u001a:?yM$X\u000fZ3oizbd.Y7f}\t{'\rP\u0018oC6,g\b\u0010:b].t\u0014\u0007P\u0018sC:\\g\bP\u0018tiV$WM\u001c;?yM$X\u000fZ3oizbd.Y7f}\rC\u0017M\u001d7jKrzc.Y7f}q\u0012\u0018M\\6?eqz#/\u00198l}qz3\u000f^;eK:$h\bP\u0018q}\u001db\u0003eJ*U%V\u001bE\u000b\u0010;fC\u000eDWM\u001d\u001e!'R\u0013\u0016JT$-AM$X\u000fZ3oij\u0002\u0013I\u0015*B3r\u001aFKU+D)rr\u0017-\\3;AM#&+\u0013(HY\u0001\u0012\u0018M\\6;A%sEK\u0010 ?O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uK\u0006\u001c\u0007.\u001a:#u\t\nE.[2fE1\u00123\u000f^;eK:$(EO.|E9\fW.\u001a\u0012;E\t{'M\t\u0017#e\u0006t7N\t\u001e2{2Z(E\\1nK\nR$e\u00115be2LWM\t\u0017#e\u0006t7N\t\u001e3{vk(\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t5\u0013!\u0003=nY~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011\u0019&A\u00035]Ar\u0003'\u0001\u0007Y[2$vn\u0015;sk\u000e$8\u000f\u0005\u0002BSM)\u0011Fa\u0017\u0003hAY!Q\fB2I6\\\u00181AA\b\u001b\t\u0011yFC\u0002\u0003bI\u000bqA];oi&lW-\u0003\u0003\u0003f\t}#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!\u0011\u000eB8\u001b\t\u0011YG\u0003\u0003\u0003n\u0005m\u0018AA5p\u0013\r\u0001'1\u000e\u000b\u0003\u0005/\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003g\fQ!\u00199qYf$\"\"a\u0004\u0003|\tu$q\u0010BA\u0011\u0015\u0011G\u00061\u0001e\u0011\u0015YG\u00061\u0001n\u0011\u0015IH\u00061\u0001|\u0011!yH\u0006%AA\u0002\u0005\r\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0012BI!\u0015\t\u0016Q\u0001BF!!\t&Q\u00123nw\u0006\r\u0011b\u0001BH%\n1A+\u001e9mKRB\u0011Ba%/\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00057\u0003B!!>\u0003\u001e&!!qTA|\u0005\u0019y%M[3di\u0002")
public class XmlToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
ExpectsInputTypes,
QueryErrorsBase,
Serializable {
    private transient XmlToStructsEvaluator evaluator;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return XmlToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(XmlToStructs x$0) {
        return XmlToStructs$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return XmlToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, XmlToStructs> tupled() {
        return XmlToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, XmlToStructs>>>> curried() {
        return XmlToStructs$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        if (dataType instanceof StructType ? true : dataType instanceof VariantType) {
            TypeCheckResult checkResult = ExprUtils$.MODULE$.checkXmlSchema(this.nullableSchema());
            if (checkResult.isFailure()) {
                return checkResult;
            }
            return ExpectsInputTypes.checkInputDataTypes$(this);
        }
        return new TypeCheckResult.DataTypeMismatch("INVALID_XML_SCHEMA", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)this.nullableSchema()))}))));
    }

    private XmlToStructsEvaluator evaluator$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.evaluator = new XmlToStructsEvaluator(this.options(), this.nullableSchema(), this.nameOfCorruptRecord(), this.timeZoneId(), this.child());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.evaluator;
    }

    private XmlToStructsEvaluator evaluator() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.evaluator$lzycompute();
        }
        return this.evaluator;
    }

    private String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object xml) {
        return this.evaluator().evaluate((UTF8String)xml);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String expr = ctx.addReferenceObj("this", this, ctx.addReferenceObj$default$3());
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)input -> "(InternalRow) " + expr + ".nullSafeEval(" + input + ")");
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringTypeWithCollation stringTypeWithCollation = StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)stringTypeWithCollation);
    }

    @Override
    public String prettyName() {
        return "from_xml";
    }

    @Override
    public XmlToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public XmlToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new XmlToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "XmlToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XmlToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "schema";
            }
            case 1: {
                return "options";
            }
            case 2: {
                return "child";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XmlToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        XmlToStructs xmlToStructs = (XmlToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = xmlToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = xmlToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = xmlToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = xmlToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!xmlToStructs.canEqual(this)) return false;
        return true;
    }

    public XmlToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
        Statics.releaseFence();
    }

    public XmlToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public XmlToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public XmlToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

