/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(unix_time[, fmt]) - Returns `unix_time` in the specified `fmt`.", arguments="\n    Arguments:\n      * unix_time - UNIX Timestamp to be converted to the provided format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n              for valid date and time format patterns. The 'yyyy-MM-dd HH:mm:ss' pattern is used if omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss');\n       1969-12-31 16:00:00\n\n      > SELECT _FUNC_(0);\n       1969-12-31 16:00:00\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t%c\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00055\"Aa\f\u0001BK\u0002\u0013\u0005\u0011\f\u0003\u0005`\u0001\tE\t\u0015!\u0003[\u0011!\u0001\u0007A!f\u0001\n\u0003\t\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011\u00022\t\u000b9\u0004A\u0011A8\t\u000bQ\u0004A\u0011I;\t\u000b9\u0004A\u0011A=\t\u000bq\u0004A\u0011I-\t\u000bu\u0004A\u0011I-\t\u000by\u0004A\u0011I@\t\r9\u0004A\u0011AA\u0001\u0011\u0019\t9\u0001\u0001C!k\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\tY\u0004\u0001C!\u0003{Aa!!\u0017\u0001\t#J\u0006BBA.\u0001\u0011ES\u000fC\u0004\u0002^\u0001!\t&a\u0018\t\u0013\u0005%\u0004!!A\u0005\u0002\u0005-\u0004\"CA:\u0001E\u0005I\u0011AA;\u0011%\tY\tAI\u0001\n\u0003\t)\bC\u0005\u0002\u000e\u0002\t\n\u0011\"\u0001\u0002\u0010\"I\u00111\u0013\u0001\u0002\u0002\u0013\u0005\u0013Q\u0013\u0005\n\u0003K\u0003\u0011\u0011!C\u0001\u0003OC\u0011\"a,\u0001\u0003\u0003%\t!!-\t\u0013\u0005]\u0006!!A\u0005B\u0005e\u0006\"CAd\u0001\u0005\u0005I\u0011AAe\u0011%\ti\rAA\u0001\n\u0003\ny\rC\u0005\u0002T\u0002\t\t\u0011\"\u0011\u0002V\u001eI\u0011q`\u0016\u0002\u0002#\u0005!\u0011\u0001\u0004\tU-\n\t\u0011#\u0001\u0003\u0004!1aN\tC\u0001\u00057A\u0011B!\b#\u0003\u0003%)Ea\b\t\u0013\t\u0005\"%!A\u0005\u0002\n\r\u0002\"\u0003B\u0016EE\u0005I\u0011AAH\u0011%\u0011iCIA\u0001\n\u0003\u0013y\u0003C\u0005\u0003>\t\n\n\u0011\"\u0001\u0002\u0010\"I!q\b\u0012\u0002\u0002\u0013%!\u0011\t\u0002\r\rJ|W.\u00168jqRKW.\u001a\u0006\u0003Y5\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011afL\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001'M\u0001\u0004gFd'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M9\u0001!O\u001fA\u0007\u001ac\u0005C\u0001\u001e<\u001b\u0005Y\u0013B\u0001\u001f,\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002;}%\u0011qh\u000b\u0002\u0019)&lWm\u001d;b[B4uN]7biR,'\u000fS3ma\u0016\u0014\bC\u0001\u001eB\u0013\t\u00115F\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tQD)\u0003\u0002FW\t\u0001C)\u001a4bk2$8\u000b\u001e:j]\u001e\u0004&o\u001c3vG&tw-\u0012=qe\u0016\u001c8/[8o!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u001d\u0001&o\u001c3vGR\u0004\"!T+\u000f\u00059\u001bfBA(S\u001b\u0005\u0001&BA)8\u0003\u0019a$o\\8u}%\t\u0011*\u0003\u0002U\u0011\u00069\u0001/Y2lC\u001e,\u0017B\u0001,X\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!\u0006*A\u0002tK\u000e,\u0012A\u0017\t\u0003umK!\u0001X\u0016\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003tK\u000e\u0004\u0013A\u00024pe6\fG/A\u0004g_Jl\u0017\r\u001e\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001c!\r95-Z\u0005\u0003I\"\u0013aa\u00149uS>t\u0007C\u00014k\u001d\t9\u0007\u000e\u0005\u0002P\u0011&\u0011\u0011\u000eS\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002j\u0011\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}Q!\u0001/\u001d:t!\tQ\u0004\u0001C\u0003Y\u000f\u0001\u0007!\fC\u0003_\u000f\u0001\u0007!\fC\u0004a\u000fA\u0005\t\u0019\u00012\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\ta\u000f\u0005\u0002Ho&\u0011\u0001\u0010\u0013\u0002\b\u0005>|G.Z1o)\r\u0001(p\u001f\u0005\u00061&\u0001\rA\u0017\u0005\u0006=&\u0001\rAW\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u001a\u000b\u0004a\u0006\r\u0001BBA\u0003\u001b\u0001\u0007!,\u0001\u0003v]&D\u0018\u0001\u00038vY2\f'\r\\3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002\u000eA)Q*a\u0004\u0002\u0014%\u0019\u0011\u0011C,\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIbL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003;\t9B\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR!\u00111EA\u0015!\rQ\u0014QE\u0005\u0004\u0003OY#a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o\u0011\u0015\u0001\u0007\u00031\u0001f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\ty#!\u000e\u0002:A\u0019q)!\r\n\u0007\u0005M\u0002JA\u0002B]fDq!a\u000e\u0012\u0001\u0004\ty#A\u0004tK\u000e|g\u000eZ:\t\ry\u000b\u0002\u0019AA\u0018\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002@\u0005-\u0013Q\u000b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI\u0016\u0002\u000f\r|G-Z4f]&!\u0011\u0011JA\"\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA'%\u0001\u0007\u0011qJ\u0001\u0004GRD\b\u0003BA!\u0003#JA!a\u0015\u0002D\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA,%\u0001\u0007\u0011qH\u0001\u0003KZ\fABZ8s[\u0006$8\u000b\u001e:j]\u001e\f\u0011\"[:QCJ\u001c\u0018N\\4\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00029\u0002b\u0005\u0015\u0004BBA2+\u0001\u0007!,A\u0004oK^dUM\u001a;\t\r\u0005\u001dT\u00031\u0001[\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$r\u0001]A7\u0003_\n\t\bC\u0004Y-A\u0005\t\u0019\u0001.\t\u000fy3\u0002\u0013!a\u00015\"9\u0001M\u0006I\u0001\u0002\u0004\u0011\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003oR3AWA=W\t\tY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\u0013Ut7\r[3dW\u0016$'bAAC\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0015q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tJK\u0002c\u0003s\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAL!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000bA\u0001\\1oO*\u0011\u0011\u0011U\u0001\u0005U\u00064\u0018-C\u0002l\u00037\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!+\u0011\u0007\u001d\u000bY+C\u0002\u0002.\"\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\f\u00024\"I\u0011Q\u0017\u000f\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0006CBA_\u0003\u0007\fy#\u0004\u0002\u0002@*\u0019\u0011\u0011\u0019%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002F\u0006}&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2A^Af\u0011%\t)LHA\u0001\u0002\u0004\ty#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAL\u0003#D\u0011\"!. \u0003\u0003\u0005\r!!+\u0002\r\u0015\fX/\u00197t)\r1\u0018q\u001b\u0005\n\u0003k\u0003\u0013\u0011!a\u0001\u0003_As\u0003AAn\u0003C\f\u0019/a:\u0002j\u00065\u0018q^Az\u0003k\fI0a?\u0011\u0007i\ni.C\u0002\u0002`.\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002f\u00061uLR+O\u0007~CSO\\5y?RLW.Z.-A\u0019lG/X\u0015![\u0001\u0012V\r^;s]N\u0004\u0003-\u001e8jq~#\u0018.\\3aA%t\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007\u0005\u00194ni\u0002t\u0013!C1sOVlWM\u001c;tC\t\tY/\u0001Bd\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002SO\\5y?RLW.\u001a\u0011.AUs\u0015\n\u0017\u0011US6,7\u000f^1na\u0002\"x\u000e\t2fA\r|gN^3si\u0016$\u0007\u0005^8!i\",\u0007\u0005\u001d:pm&$W\r\u001a\u0011g_Jl\u0017\r\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0019lG\u000fI\u0017!\t\u0006$Xm\f;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt\u0007\u0005^8!M>dGn\\</AM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC-\u0019;fi&lW-\f9biR,'O\u001c\u0018ii6d'E\u0010#bi\u0016$\u0018.\\3!!\u0006$H/\u001a:ogrz\u0013M\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011g_J\u0004c/\u00197jI\u0002\"\u0017\r^3!C:$\u0007\u0005^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u001ch\u0006\t+iK\u0002:\u00130_=z[5kU\u0006\u001a3!\u0011\"ST.\u001c\u001etg\u001e\u0002\u0003/\u0019;uKJt\u0007%[:!kN,G\rI5gA=l\u0017\u000e\u001e;fI:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011_\u0001\u0002()\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003\u0007\f\u0011(sfL\u00180L'N[\u0011$\u0007\u0005\u0013%;[6T4o]\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0014HN\u001d.cIj3'\r\u00112mi\u0002\u0004G\u000f\u00191\u0015)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!ce2\u0014(L\u00193[M\n\u0004%\r\u001c;aAR\u0004\u0007\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011q_\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\ti0A\u00032]Ur\u0003'\u0001\u0007Ge>lWK\\5y)&lW\r\u0005\u0002;EM)!E!\u0002\u0003\u0012AA!q\u0001B\u00075j\u0013\u0007/\u0004\u0002\u0003\n)\u0019!1\u0002%\u0002\u000fI,h\u000e^5nK&!!q\u0002B\u0005\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)!!qCAP\u0003\tIw.C\u0002W\u0005+!\"A!\u0001\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fA\u0014)Ca\n\u0003*!)\u0001,\na\u00015\")a,\na\u00015\"9\u0001-\nI\u0001\u0002\u0004\u0011\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0007B\u001d!\u001195Ma\r\u0011\r\u001d\u0013)D\u0017.c\u0013\r\u00119\u0004\u0013\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tmr%!AA\u0002A\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\t\t\u0005\u00033\u0013)%\u0003\u0003\u0003H\u0005m%AB(cU\u0016\u001cG\u000f")
public class FromUnixTime
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression sec;
    private final Expression format;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return FromUnixTime$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(FromUnixTime x$0) {
        return FromUnixTime$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return FromUnixTime$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, FromUnixTime> tupled() {
        return FromUnixTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, FromUnixTime>>> curried() {
        return FromUnixTime$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean forTimestampNTZ() {
        return TimestampFormatterHelper.forTimestampNTZ$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.formatterOption$lzycompute();
        }
        return this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression sec() {
        return this.sec;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.sec();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "from_unixtime";
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object seconds, Object format) {
        TimestampFormatter fmt = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)fmt.format(BoxesRunTime.unboxToLong((Object)seconds) * 1000000L));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable)f -> {
            String formatterName = ctx.addReferenceObj("formatter", f, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(seconds, x$6) -> "UTF8String.fromString(" + formatterName + ".format(" + seconds + " * 1000000L))");
        }).getOrElse((Function0 & Serializable)() -> {
            String tf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName()), "$");
            String ldf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName()), "$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(seconds, format) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |UTF8String.fromString(\n           |  " + tf + "$.MODULE$.apply(" + format + ".toString(),\n           |  " + zid + ",\n           |  " + ldf + "$.MODULE$.SIMPLE_DATE_FORMAT(),\n           |  false).format(" + seconds + " * 1000000L))\n           |")));
        });
    }

    @Override
    public Expression formatString() {
        return this.format();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    @Override
    public FromUnixTime withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public FromUnixTime copy(Expression sec, Expression format, Option<String> timeZoneId) {
        return new FromUnixTime(sec, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.sec();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "FromUnixTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sec();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUnixTime;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "sec";
            }
            case 1: {
                return "format";
            }
            case 2: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUnixTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUnixTime fromUnixTime = (FromUnixTime)x$1;
        Expression expression = this.sec();
        Expression expression2 = fromUnixTime.sec();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = fromUnixTime.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = fromUnixTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fromUnixTime.canEqual(this)) return false;
        return true;
    }

    public FromUnixTime(Expression sec, Expression format, Option<String> timeZoneId) {
        this.sec = sec;
        this.format = format;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        Statics.releaseFence();
    }

    public FromUnixTime(Expression sec, Expression format) {
        this(sec, format, (Option<String>)None$.MODULE$);
    }

    public FromUnixTime(Expression unix) {
        this(unix, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

