/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.ZStandardCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.io.CompressionCodec$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class HadoopCodecStreams$ {
    public static final HadoopCodecStreams$ MODULE$ = new HadoopCodecStreams$();
    private static final Seq<String> ZSTD_EXTENSIONS = new .colon.colon((Object)".zstd", (List)new .colon.colon((Object)".zst", (List)Nil$.MODULE$));

    private Seq<String> ZSTD_EXTENSIONS() {
        return ZSTD_EXTENSIONS;
    }

    public Option<CompressionCodec> getDecompressionCodec(Configuration config, Path file) {
        CompressionCodecFactory factory = new CompressionCodecFactory(config);
        return Option$.MODULE$.apply((Object)factory.getCodec(file)).orElse((Function0 & Serializable)() -> {
            String string = file.getName().toLowerCase();
            switch (string == null ? 0 : string.hashCode()) {
                default: 
            }
            if (string.endsWith(".zstd")) {
                return Option$.MODULE$.apply((Object)factory.getCodecByName(ZStandardCodec.class.getName()));
            }
            if (string.endsWith(".gzip")) {
                return Option$.MODULE$.apply((Object)factory.getCodecByName(GzipCodec.class.getName()));
            }
            return None$.MODULE$;
        });
    }

    public Option<InputStream> createZstdInputStream(Path file, InputStream inputStream) {
        SparkConf sparkConf = (SparkConf)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable)x$1 -> x$1.conf()).getOrElse((Function0 & Serializable)() -> new SparkConf());
        String fileName = file.getName().toLowerCase(Locale.ROOT);
        None$ isOpt = this.ZSTD_EXTENSIONS().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)fileName.endsWith(x$1))) ? new Some((Object)CompressionCodec$.MODULE$.createCodec(sparkConf, CompressionCodec$.MODULE$.ZSTD()).compressedInputStream(inputStream)) : None$.MODULE$;
        return isOpt;
    }

    public InputStream createInputStream(Configuration config, Path file) {
        FileSystem fs = file.getFileSystem(config);
        FSDataInputStream inputStream = fs.open(file);
        return (InputStream)this.getDecompressionCodec(config, file).map(arg_0 -> HadoopCodecStreams$.$anonfun$createInputStream$1((InputStream)inputStream, file, arg_0)).getOrElse(() -> HadoopCodecStreams$.$anonfun$createInputStream$3((InputStream)inputStream));
    }

    public static final /* synthetic */ InputStream $anonfun$createInputStream$1(InputStream inputStream$1, Path file$2, CompressionCodec codec) {
        Object object;
        try {
            object = codec.createInputStream(inputStream$1);
        }
        catch (RuntimeException e) {
            object = (InputStream)MODULE$.createZstdInputStream(file$2, inputStream$1).getOrElse((Function0 & Serializable)() -> {
                throw e;
            });
        }
        return object;
    }

    public static final /* synthetic */ InputStream $anonfun$createInputStream$3(InputStream inputStream$1) {
        return inputStream$1;
    }

    private HadoopCodecStreams$() {
    }
}

