/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.SizeofMarker;
import java.util.Arrays;

public abstract class INLongRep {
    public abstract long get(int var1);

    public abstract INLongRep set(int var1, long var2, IN var4);

    public abstract INLongRep compact(IN var1, EmptyRep var2);

    public abstract INLongRep clear(IN var1, EmptyRep var2);

    public abstract boolean isEmpty();

    public abstract INLongRep copy(int var1, int var2, int var3, IN var4);

    public abstract INLongRep resize(int var1);

    public abstract long getMemorySize();

    public static class SparseRep
    extends DefaultRep {
        private static final int MAX_ENTRIES = 4;
        private final short[] idxs;

        public SparseRep(int nBytes) {
            super(4, nBytes);
            this.idxs = new short[4];
            Arrays.fill(this.idxs, (short)-1);
        }

        public SparseRep(SizeofMarker marker) {
            super(marker);
            this.idxs = null;
        }

        @Override
        public SparseRep resize(int capacity) {
            return this;
        }

        @Override
        public long get(int idx) {
            for (int i = 0; i < this.idxs.length; ++i) {
                if (this.idxs[i] != idx) continue;
                return super.get(i);
            }
            return 0L;
        }

        @Override
        public INLongRep set(int idx, long val, IN parent) {
            int slot = -1;
            for (int i = 0; i < this.idxs.length; ++i) {
                if (this.idxs[i] == idx) {
                    if (val == 0L) {
                        this.idxs[i] = -1;
                    }
                    return super.set(i, val, parent);
                }
                if (slot >= 0 || this.idxs[i] != -1) continue;
                slot = i;
            }
            if (val == 0L) {
                return this;
            }
            if (slot >= 0) {
                this.idxs[slot] = (short)idx;
                return super.set(slot, val, parent);
            }
            INLongRep newRep = new DefaultRep(parent.getMaxEntries(), this.bytesPerValue);
            parent.updateMemorySize(this.getMemorySize(), ((INLongRep)newRep).getMemorySize());
            for (int i = 0; i < this.idxs.length; ++i) {
                if (this.idxs[i] == -1) continue;
                newRep = ((INLongRep)newRep).set(this.idxs[i], super.get(i), parent);
            }
            return ((INLongRep)newRep).set(idx, val, parent);
        }

        @Override
        public INLongRep compact(IN parent, EmptyRep emptyRep) {
            if (this.isEmpty()) {
                return this.clear(parent, emptyRep);
            }
            return this;
        }

        @Override
        public INLongRep clear(IN parent, EmptyRep emptyRep) {
            parent.updateMemorySize(this.getMemorySize(), emptyRep.getMemorySize());
            return emptyRep;
        }

        @Override
        public boolean isEmpty() {
            for (short idx : this.idxs) {
                if (idx == -1) continue;
                return false;
            }
            return true;
        }

        @Override
        public INLongRep copy(int from, int to, int n, IN parent) {
            INLongRep target;
            block4: {
                target = this;
                if (to == from || n == 0) break block4;
                if (to < from) {
                    for (int i = 0; i < n; ++i) {
                        target = ((INLongRep)target).set(to++, this.get(from++), parent);
                    }
                } else {
                    from += n;
                    to += n;
                    for (int i = 0; i < n; ++i) {
                        target = ((INLongRep)target).set(--to, this.get(--from), parent);
                    }
                }
            }
            return target;
        }

        @Override
        public long getMemorySize() {
            return super.getMemorySize() + (long)MemoryBudget.SPARSE_LONG_REP_OVERHEAD - (long)MemoryBudget.DEFAULT_KEYVALS_OVERHEAD + (long)MemoryBudget.shortArraySize(this.idxs.length);
        }
    }

    public static class DefaultRep
    extends INLongRep {
        private static long[] MAX_VALUE = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, Long.MAX_VALUE};
        private final byte[] byteArray;
        final int bytesPerValue;

        public DefaultRep(int capacity, int nBytes) {
            assert (capacity >= 1);
            assert (nBytes >= 1);
            assert (nBytes <= 8);
            this.bytesPerValue = nBytes;
            this.byteArray = new byte[capacity * this.bytesPerValue];
        }

        public DefaultRep(SizeofMarker marker) {
            this.bytesPerValue = 0;
            this.byteArray = null;
        }

        private DefaultRep(byte[] byteArray, int bytesPerValue) {
            this.byteArray = byteArray;
            this.bytesPerValue = bytesPerValue;
        }

        @Override
        public DefaultRep resize(int capacity) {
            return new DefaultRep(Arrays.copyOfRange(this.byteArray, 0, capacity * this.bytesPerValue), this.bytesPerValue);
        }

        @Override
        public long get(int idx) {
            int i = idx * this.bytesPerValue;
            int end = i + this.bytesPerValue;
            long val = this.byteArray[i] & 0xFF;
            ++i;
            while (i < end) {
                val <<= 8;
                val |= (long)(this.byteArray[i] & 0xFF);
                ++i;
            }
            return val;
        }

        @Override
        public INLongRep set(int idx, long val, IN parent) {
            assert (idx >= 0);
            assert (idx < this.byteArray.length / this.bytesPerValue);
            assert (val >= 0L);
            if (val > MAX_VALUE[this.bytesPerValue]) {
                int capacity = this.byteArray.length / this.bytesPerValue;
                INLongRep newRep = this.getClass() == SparseRep.class ? new SparseRep(this.bytesPerValue + 1) : new DefaultRep(capacity, this.bytesPerValue + 1);
                parent.updateMemorySize(this.getMemorySize(), newRep.getMemorySize());
                newRep = newRep.set(idx, val, parent);
                for (int i = 0; i < capacity; ++i) {
                    if (i == idx) continue;
                    newRep = newRep.set(i, this.get(i), parent);
                }
                return newRep;
            }
            int i = (idx + 1) * this.bytesPerValue - 1;
            int end = i - this.bytesPerValue;
            this.byteArray[i] = (byte)(val & 0xFFL);
            --i;
            while (i > end) {
                this.byteArray[i] = (byte)((val >>= 8) & 0xFFL);
                --i;
            }
            assert ((val & 0xFFFFFFFFFFFFFF00L) == 0L) : val;
            return this;
        }

        @Override
        public INLongRep compact(IN parent, EmptyRep emptyRep) {
            if (this.isEmpty()) {
                return this.clear(parent, emptyRep);
            }
            return this;
        }

        @Override
        public INLongRep clear(IN parent, EmptyRep emptyRep) {
            parent.updateMemorySize(this.getMemorySize(), emptyRep.getMemorySize());
            return emptyRep;
        }

        @Override
        public boolean isEmpty() {
            for (byte b : this.byteArray) {
                if (b == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public INLongRep copy(int from, int to, int n, IN parent) {
            System.arraycopy(this.byteArray, from * this.bytesPerValue, this.byteArray, to * this.bytesPerValue, n * this.bytesPerValue);
            return this;
        }

        @Override
        public long getMemorySize() {
            return MemoryBudget.DEFAULT_LONG_REP_OVERHEAD + MemoryBudget.byteArraySize(this.byteArray.length);
        }
    }

    public static class EmptyRep
    extends INLongRep {
        final int minLength;
        final boolean allowSparseRep;

        public EmptyRep(int minLength, boolean allowSparseRep) {
            this.minLength = minLength;
            this.allowSparseRep = allowSparseRep;
        }

        @Override
        public INLongRep resize(int capacity) {
            return this;
        }

        @Override
        public long get(int idx) {
            return 0L;
        }

        @Override
        public INLongRep set(int idx, long val, IN parent) {
            if (val == 0L) {
                return this;
            }
            DefaultRep newCache = new DefaultRep(parent.getMaxEntries(), this.minLength);
            parent.updateMemorySize(this.getMemorySize(), ((INLongRep)newCache).getMemorySize());
            return ((INLongRep)newCache).set(idx, val, parent);
        }

        @Override
        public INLongRep compact(IN parent, EmptyRep emptyRep) {
            return this;
        }

        @Override
        public INLongRep clear(IN parent, EmptyRep emptyRep) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public INLongRep copy(int from, int to, int n, IN parent) {
            return this;
        }

        @Override
        public long getMemorySize() {
            return 0L;
        }
    }
}

