/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockTimeoutException;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.logging.Logger;

public class FeederReplicaHandshake {
    private final int GROUP_RETRY = 60;
    private final long GROUP_RETRY_SLEEP_MS = 1000L;
    private final RepNode repNode;
    private final NamedChannel namedChannel;
    private final NameIdPair feederNameIdPair;
    private NameIdPair replicaNameIdPair = null;
    private Protocol.ReplicaJEVersions replicaJEVersions;
    private int streamLogVersion;
    private volatile RepNodeImpl replicaNode;
    private final Logger logger;
    private final TestHook<BinaryProtocol.Message> writeMessageHook;
    private static int testCurrentLogVersion = 0;

    public FeederReplicaHandshake(RepNode repNode, Feeder feeder, NamedChannel namedChannel) {
        this.repNode = repNode;
        this.namedChannel = namedChannel;
        this.feederNameIdPair = repNode.getNameIdPair();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.writeMessageHook = feeder.getWriteMessageHook();
    }

    public NameIdPair getReplicaNameIdPair() {
        return this.replicaNameIdPair;
    }

    private int getCurrentLogVersion() {
        return testCurrentLogVersion != 0 ? testCurrentLogVersion : 13;
    }

    public int getStreamLogVersion() {
        if (this.streamLogVersion <= 0) {
            throw new IllegalStateException("execute() method was not invoked");
        }
        return this.streamLogVersion;
    }

    public static void setTestLogVersion(int testLogVersion) {
        testCurrentLogVersion = testLogVersion;
    }

    private JEVersion getCurrentJEVersion() {
        return this.repNode.getRepImpl().getCurrentJEVersion();
    }

    private int getCurrentProtocolVersion() {
        return Protocol.getJEVersionProtocolVersion(this.getCurrentJEVersion());
    }

    private Protocol.JEVersionsReject checkJECompatibility(Protocol protocol, Protocol.JEVersions jeVersions) {
        byte replicaLogVersion = jeVersions.getLogVersion();
        if (replicaLogVersion < 8) {
            Protocol protocol2 = protocol;
            protocol2.getClass();
            return new Protocol.JEVersionsReject(protocol2, "Incompatible log versions. Feeder log version: " + this.getCurrentLogVersion() + ", Feeder JE version: " + this.getCurrentJEVersion() + ", Replica log version: " + replicaLogVersion + ", Replica JE version: " + jeVersions.getVersion());
        }
        JEVersion minJEVersion = this.repNode.getGroup().getMinJEVersion();
        if (minJEVersion.compareTo(jeVersions.getVersion()) > 0) {
            Protocol protocol3 = protocol;
            protocol3.getClass();
            return new Protocol.JEVersionsReject(protocol3, "Unsupported JE version. Feeder JE version: " + this.getCurrentJEVersion() + ", Feeder min JE version: " + minJEVersion + ", Replica JE version: " + jeVersions.getVersion());
        }
        return null;
    }

    public JEVersion getReplicaJEVersion() {
        return this.replicaJEVersions != null ? this.replicaJEVersions.getVersion() : null;
    }

    public RepNodeImpl getReplicaNode() {
        if (this.replicaNode == null) {
            throw new IllegalStateException("Handshake did not complete");
        }
        return this.replicaNode;
    }

    public Protocol execute() throws DatabaseException, IOException, BinaryProtocol.ProtocolException, Feeder.ExitException {
        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder-replica handshake start");
        Protocol protocol = this.negotiateProtocol();
        this.replicaJEVersions = (Protocol.ReplicaJEVersions)protocol.read(this.namedChannel);
        String versionMsg = " Replica " + this.replicaNameIdPair.getName() + " Versions" + " JE: " + this.replicaJEVersions.getVersion().getVersionString() + " Log: " + this.replicaJEVersions.getLogVersion() + " Protocol: " + protocol.getVersion();
        LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), versionMsg);
        Protocol.JEVersionsReject reject = this.checkJECompatibility(protocol, this.replicaJEVersions);
        if (reject != null) {
            String msg = "Version incompatibility: " + reject.getErrorMessage() + " with replica " + this.replicaNameIdPair.getName();
            LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), msg);
            this.writeMessage(protocol, reject);
            throw new Feeder.ExitException(msg);
        }
        this.streamLogVersion = Math.min(this.getCurrentLogVersion(), this.replicaJEVersions.getLogVersion());
        Protocol protocol2 = protocol;
        protocol2.getClass();
        this.writeMessage(protocol, new Protocol.FeederJEVersions(protocol2, this.getCurrentJEVersion(), this.streamLogVersion));
        protocol.setStreamLogVersion(this.streamLogVersion);
        this.verifyMembershipInfo(protocol);
        this.checkClockSkew(protocol);
        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Feeder-replica " + this.replicaNameIdPair.getName() + " handshake completed." + versionMsg + " Stream Log: " + protocol.getStreamLogVersion());
        return protocol;
    }

    private void writeMessage(Protocol protocol, BinaryProtocol.Message message) throws IOException {
        assert (TestHookExecute.doHookIfSet(this.writeMessageHook, message));
        protocol.write(message, this.namedChannel);
    }

    private void checkClockSkew(Protocol protocol) throws IOException, BinaryProtocol.ProtocolException {
        Protocol.SNTPRequest request;
        do {
            request = protocol.read(this.namedChannel.getChannel(), Protocol.SNTPRequest.class);
            Protocol protocol2 = protocol;
            protocol2.getClass();
            this.writeMessage(protocol, new Protocol.SNTPResponse(protocol2, request));
        } while (!request.isLast());
    }

    private void verifyMembershipInfo(Protocol protocol) throws IOException, DatabaseException, Feeder.ExitException {
        Protocol.NodeGroupInfo nodeGroup = (Protocol.NodeGroupInfo)protocol.read(this.namedChannel);
        RepGroupImpl group = this.repNode.getGroup();
        RepNodeImpl node = group.getNode(nodeGroup.getNodeName());
        try {
            block19: {
                if (nodeGroup.getNodeId() != this.replicaNameIdPair.getId()) {
                    throw new Feeder.ExitException("The replica node ID sent during protocol negotiation: " + this.replicaNameIdPair + " differs from the one sent in the MembershipInfo " + "request: " + nodeGroup.getNodeId());
                }
                if (nodeGroup.getNodeType().hasTransientId()) {
                    if (node == null) {
                        node = new RepNodeImpl(nodeGroup);
                        try {
                            this.repNode.addTransientIdNode(node);
                        }
                        catch (RepGroupImpl.NodeConflictException | IllegalStateException e) {
                            throw new Feeder.ExitException(e, true);
                        }
                    }
                } else {
                    if (node == null || !node.isQuorumAck()) {
                        Set<RepNodeImpl> arbMembers;
                        if (nodeGroup.getNodeType().isArbiter() && (arbMembers = group.getArbiterMembers()).size() > 0) {
                            throw new Feeder.ExitException("An Arbiter node already exists in the replication group.");
                        }
                        try {
                            this.repNode.getRepGroupDB().ensureMember(nodeGroup);
                            for (int i = 0; i < 60 && (node = this.repNode.getGroup().getMember(nodeGroup.getNodeName())) == null; ++i) {
                                try {
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (node == null) {
                                throw EnvironmentFailureException.unexpectedState("Node: " + nodeGroup.getNameIdPair() + " not found");
                            }
                            break block19;
                        }
                        catch (LockTimeoutException | InsufficientAcksException | InsufficientReplicasException e) {
                            throw new Feeder.ExitException(e, false);
                        }
                        catch (RepGroupImpl.NodeConflictException e) {
                            throw new Feeder.ExitException(e, true);
                        }
                    }
                    if (node.isRemoved()) {
                        throw new Feeder.ExitException("Node: " + nodeGroup.getNameIdPair() + " is no longer a member of the group." + " It was explicitly removed.");
                    }
                }
            }
            this.doGroupChecks(nodeGroup, group);
            this.doNodeChecks(nodeGroup, node);
            this.maybeUpdateJEVersion(nodeGroup, group, node);
        }
        catch (Feeder.ExitException exception) {
            LoggerUtils.info(this.logger, this.repNode.getRepImpl(), exception.getMessage());
            if (exception.failReplica()) {
                Protocol protocol2 = protocol;
                protocol2.getClass();
                this.writeMessage(protocol, new Protocol.NodeGroupInfoReject(protocol2, exception.getMessage()));
            }
            throw exception;
        }
        this.replicaNameIdPair.update(node.getNameIdPair());
        this.namedChannel.setNameIdPair(this.replicaNameIdPair);
        LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Channel Mapping: " + this.replicaNameIdPair + " is at " + this.namedChannel.getChannel());
        Protocol protocol3 = protocol;
        protocol3.getClass();
        this.writeMessage(protocol, new Protocol.NodeGroupInfoOK(protocol3, group.getUUID(), this.replicaNameIdPair));
    }

    private void doGroupChecks(Protocol.NodeGroupInfo nodeGroup, RepGroupImpl group) throws Feeder.ExitException {
        if (nodeGroup.isDesignatedPrimary() && this.repNode.getRepImpl().isDesignatedPrimary()) {
            throw new Feeder.ExitException("Conflicting Primary designations. Feeder node: " + this.repNode.getNodeName() + " and replica node: " + nodeGroup.getNodeName() + " cannot simultaneously be designated primaries");
        }
        if (!nodeGroup.getGroupName().equals(group.getName())) {
            throw new Feeder.ExitException("The feeder belongs to the group: " + group.getName() + " but replica id" + this.replicaNameIdPair + " belongs to the group: " + nodeGroup.getGroupName());
        }
        if (!RepGroupImpl.isUnknownUUID(nodeGroup.getUUID()) && !nodeGroup.getUUID().equals(group.getUUID())) {
            throw new Feeder.ExitException("The environments have the same name: " + group.getName() + " but represent different environment instances." + " The environment at the master has UUID " + group.getUUID() + ", while the replica " + this.replicaNameIdPair.getName() + " has UUID: " + nodeGroup.getUUID());
        }
    }

    private void doNodeChecks(Protocol.NodeGroupInfo nodeGroup, RepNodeImpl node) throws Feeder.ExitException {
        if (!nodeGroup.getHostName().equals(node.getHostName())) {
            throw new Feeder.ExitException("Conflicting hostnames for replica id: " + this.replicaNameIdPair + " Feeder thinks it is: " + node.getHostName() + " Replica is configured to use: " + nodeGroup.getHostName());
        }
        if (nodeGroup.port() != node.getPort()) {
            throw new Feeder.ExitException("Conflicting ports for replica id: " + this.replicaNameIdPair + " Feeder thinks it uses: " + node.getPort() + " Replica is configured to use: " + nodeGroup.port());
        }
        if (NodeType.ELECTABLE != node.getType() && NodeType.SECONDARY != node.getType() && NodeType.EXTERNAL != node.getType() && NodeType.ARBITER != node.getType() && NodeType.MONITOR != node.getType()) {
            throw new Feeder.ExitException("The replica node: " + this.replicaNameIdPair + " is of type: " + (Object)((Object)node.getType()));
        }
        if (!nodeGroup.getNodeType().equals((Object)node.getType())) {
            throw new Feeder.ExitException("Conflicting node types for: " + this.replicaNameIdPair + " Feeder thinks it uses: " + (Object)((Object)node.getType()) + " Replica is configured as type: " + (Object)((Object)nodeGroup.getNodeType()));
        }
        this.replicaNode = node;
    }

    private void maybeUpdateJEVersion(Protocol.NodeGroupInfo nodeGroup, RepGroupImpl group, RepNodeImpl node) throws Feeder.ExitException {
        if (group.getFormatVersion() >= 3 && nodeGroup.getJEVersion() != null && !nodeGroup.getJEVersion().equals(node.getJEVersion())) {
            try {
                this.repNode.getRepGroupDB().updateMember(new RepNodeImpl(nodeGroup), false);
            }
            catch (LockTimeoutException | InsufficientAcksException | InsufficientReplicasException operationFailureException) {
            }
            catch (RepGroupImpl.NodeConflictException e) {
                throw new Feeder.ExitException(e, true);
            }
        }
    }

    private Protocol negotiateProtocol() throws IOException, Feeder.ExitException {
        Protocol defaultProtocol = Protocol.getProtocol(this.repNode, this.getCurrentProtocolVersion());
        Protocol.ReplicaProtocolVersion message = (Protocol.ReplicaProtocolVersion)defaultProtocol.read(this.namedChannel);
        this.replicaNameIdPair = message.getNameIdPair();
        Feeder dup = this.repNode.feederManager().getFeeder(this.replicaNameIdPair.getName());
        if (dup != null || message.getNameIdPair().getName().equals(this.feederNameIdPair.getName())) {
            Protocol protocol = defaultProtocol;
            protocol.getClass();
            this.writeMessage(defaultProtocol, new Protocol.DuplicateNodeReject(protocol, "This node: " + this.replicaNameIdPair + " is already in active use at the feeder "));
            SocketAddress dupAddress = this.namedChannel.getChannel().getSocketChannel().socket().getRemoteSocketAddress();
            throw new Feeder.ExitException("A replica with the id: " + this.replicaNameIdPair + " is already active with this feeder. " + " The duplicate replica resides at: " + dupAddress);
        }
        int replicaVersion = message.getVersion();
        Protocol protocol = Protocol.get(this.repNode, replicaVersion, this.getCurrentProtocolVersion());
        if (protocol == null) {
            protocol = defaultProtocol;
        }
        Protocol protocol2 = defaultProtocol;
        protocol2.getClass();
        defaultProtocol.write((BinaryProtocol.Message)new Protocol.FeederProtocolVersion(protocol2, protocol.getVersion()), this.namedChannel);
        return protocol;
    }
}

