/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.batch;

import com.google.common.annotations.VisibleForTesting;
import io.oxia.client.batch.Batch;
import io.oxia.client.batch.BatchBase;
import io.oxia.client.batch.Operation;
import io.oxia.client.batch.WriteBatchFactory;
import io.oxia.client.grpc.OxiaStubProvider;
import io.oxia.client.session.SessionManager;
import io.oxia.proto.WriteRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.NonNull;

final class WriteBatch
extends BatchBase
implements Batch {
    private final WriteBatchFactory factory;
    @VisibleForTesting
    final List<Operation.WriteOperation.PutOperation> puts = new ArrayList<Operation.WriteOperation.PutOperation>();
    @VisibleForTesting
    final List<Operation.WriteOperation.DeleteOperation> deletes = new ArrayList<Operation.WriteOperation.DeleteOperation>();
    @VisibleForTesting
    final List<Operation.WriteOperation.DeleteRangeOperation> deleteRanges = new ArrayList<Operation.WriteOperation.DeleteRangeOperation>();
    private final SessionManager sessionManager;
    private final int maxBatchSize;
    private int byteSize;
    private long bytes;
    private long startSendTimeNanos;

    WriteBatch(@NonNull WriteBatchFactory factory, @NonNull OxiaStubProvider stubProvider, @NonNull SessionManager sessionManager, long shardId, int maxBatchSize) {
        super(stubProvider, shardId);
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        this.factory = factory;
        this.sessionManager = sessionManager;
        this.byteSize = 0;
        this.maxBatchSize = maxBatchSize;
    }

    int sizeOf(@NonNull Operation<?> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (operation instanceof Operation.WriteOperation.PutOperation) {
            Operation.WriteOperation.PutOperation p = (Operation.WriteOperation.PutOperation)operation;
            return p.key().getBytes(StandardCharsets.UTF_8).length + p.value().length;
        }
        if (operation instanceof Operation.WriteOperation.DeleteOperation) {
            Operation.WriteOperation.DeleteOperation d = (Operation.WriteOperation.DeleteOperation)operation;
            return d.key().getBytes(StandardCharsets.UTF_8).length;
        }
        if (operation instanceof Operation.WriteOperation.DeleteRangeOperation) {
            Operation.WriteOperation.DeleteRangeOperation r = (Operation.WriteOperation.DeleteRangeOperation)operation;
            return r.startKeyInclusive().getBytes(StandardCharsets.UTF_8).length + r.endKeyExclusive().getBytes(StandardCharsets.UTF_8).length;
        }
        return 0;
    }

    @Override
    public void add(@NonNull Operation<?> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (operation instanceof Operation.WriteOperation.PutOperation) {
            Operation.WriteOperation.PutOperation p = (Operation.WriteOperation.PutOperation)operation;
            this.puts.add(p);
            this.bytes += (long)p.value().length;
        } else if (operation instanceof Operation.WriteOperation.DeleteOperation) {
            Operation.WriteOperation.DeleteOperation d = (Operation.WriteOperation.DeleteOperation)operation;
            this.deletes.add(d);
        } else if (operation instanceof Operation.WriteOperation.DeleteRangeOperation) {
            Operation.WriteOperation.DeleteRangeOperation r = (Operation.WriteOperation.DeleteRangeOperation)operation;
            this.deleteRanges.add(r);
        }
        this.byteSize += this.sizeOf(operation);
    }

    @Override
    public boolean canAdd(@NonNull Operation<?> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        int size = this.sizeOf(operation);
        return this.byteSize + size <= this.maxBatchSize;
    }

    @Override
    public int size() {
        return this.puts.size() + this.deletes.size() + this.deleteRanges.size();
    }

    @Override
    public void send() {
        this.startSendTimeNanos = System.nanoTime();
        try {
            ((CompletableFuture)this.getWriteStream().send(this.toProto()).thenAccept(response -> {
                int i;
                this.factory.writeRequestLatencyHistogram.recordSuccess(System.nanoTime() - this.startSendTimeNanos);
                for (i = 0; i < this.deletes.size(); ++i) {
                    this.deletes.get(i).complete(response.getDeletes(i));
                }
                for (i = 0; i < this.deleteRanges.size(); ++i) {
                    this.deleteRanges.get(i).complete(response.getDeleteRanges(i));
                }
                for (i = 0; i < this.puts.size(); ++i) {
                    this.puts.get(i).complete(response.getPuts(i));
                }
            })).exceptionally(ex -> {
                this.handleError((Throwable)ex);
                return null;
            });
        }
        catch (Throwable t) {
            this.handleError(t);
        }
    }

    public void handleError(Throwable batchError) {
        this.factory.writeRequestLatencyHistogram.recordFailure(System.nanoTime() - this.startSendTimeNanos);
        this.deletes.forEach(d -> d.fail(batchError));
        this.deleteRanges.forEach(f -> f.fail(batchError));
        this.puts.forEach(p -> p.fail(batchError));
    }

    @NonNull
    WriteRequest toProto() {
        return WriteRequest.newBuilder().setShard(this.getShardId()).addAllPuts(this.puts.stream().map(Operation.WriteOperation.PutOperation::toProto).collect(Collectors.toList())).addAllDeletes(this.deletes.stream().map(Operation.WriteOperation.DeleteOperation::toProto).collect(Collectors.toList())).addAllDeleteRanges(this.deleteRanges.stream().map(Operation.WriteOperation.DeleteRangeOperation::toProto).collect(Collectors.toList())).build();
    }
}

