/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed.bucket;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pulsar.broker.delayed.bucket.DelayedIndexQueue;
import org.apache.pulsar.broker.delayed.proto.DelayedIndex;
import org.apache.pulsar.common.util.collections.TripleLongPriorityQueue;

@NotThreadSafe
class TripleLongPriorityDelayedIndexQueue
implements DelayedIndexQueue {
    private final TripleLongPriorityQueue queue;

    private TripleLongPriorityDelayedIndexQueue(TripleLongPriorityQueue queue) {
        this.queue = queue;
    }

    public static TripleLongPriorityDelayedIndexQueue wrap(TripleLongPriorityQueue queue) {
        return new TripleLongPriorityDelayedIndexQueue(queue);
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public DelayedIndex peek() {
        DelayedIndex delayedIndex = new DelayedIndex().setTimestamp(this.queue.peekN1()).setLedgerId(this.queue.peekN2()).setEntryId(this.queue.peekN3());
        return delayedIndex;
    }

    @Override
    public DelayedIndex pop() {
        DelayedIndex peek = this.peek();
        this.queue.pop();
        return peek;
    }

    @Override
    public void popToObject(DelayedIndex delayedIndex) {
        delayedIndex.setTimestamp(this.queue.peekN1()).setLedgerId(this.queue.peekN2()).setEntryId(this.queue.peekN3());
        this.queue.pop();
    }

    @Override
    public long peekTimestamp() {
        return this.queue.peekN1();
    }
}

