/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.concurrent.Future;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.ObjectCache;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.FrameDecoderUtil;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.NettySSLContextAutoRefreshBuilder;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarChannelInitializer.class);
    public static final String TLS_HANDLER = "tls";
    private final Supplier<ClientCnx> clientCnxSupplier;
    private final boolean tlsEnabled;
    private final boolean tlsHostnameVerificationEnabled;
    private final boolean tlsEnabledWithKeyStore;
    private final InetSocketAddress socks5ProxyAddress;
    private final String socks5ProxyUsername;
    private final String socks5ProxyPassword;
    private final Supplier<SslContext> sslContextSupplier;
    private NettySSLContextAutoRefreshBuilder nettySSLContextAutoRefreshBuilder;
    private static final long TLS_CERTIFICATE_CACHE_MILLIS = TimeUnit.MINUTES.toMillis(1L);

    public PulsarChannelInitializer(ClientConfigurationData conf, Supplier<ClientCnx> clientCnxSupplier) throws Exception {
        this.clientCnxSupplier = clientCnxSupplier;
        this.tlsEnabled = conf.isUseTls();
        this.tlsHostnameVerificationEnabled = conf.isTlsHostnameVerificationEnable();
        this.socks5ProxyAddress = conf.getSocks5ProxyAddress();
        this.socks5ProxyUsername = conf.getSocks5ProxyUsername();
        this.socks5ProxyPassword = conf.getSocks5ProxyPassword();
        this.tlsEnabledWithKeyStore = conf.isUseKeyStoreTls();
        if (this.tlsEnabled) {
            if (this.tlsEnabledWithKeyStore) {
                AuthenticationDataProvider authData1 = conf.getAuthentication().getAuthData();
                if (StringUtils.isBlank((CharSequence)conf.getTlsTrustStorePath())) {
                    throw new PulsarClientException("Failed to create TLS context, the tlsTrustStorePath need to be configured if useKeyStoreTls enabled");
                }
                this.nettySSLContextAutoRefreshBuilder = new NettySSLContextAutoRefreshBuilder(conf.getSslProvider(), conf.isTlsAllowInsecureConnection(), conf.getTlsTrustStoreType(), conf.getTlsTrustStorePath(), conf.getTlsTrustStorePassword(), conf.getTlsKeyStoreType(), conf.getTlsKeyStorePath(), conf.getTlsKeyStorePassword(), conf.getTlsCiphers(), conf.getTlsProtocols(), TLS_CERTIFICATE_CACHE_MILLIS, authData1);
            }
            this.sslContextSupplier = new ObjectCache<SslContext>(() -> {
                try {
                    AuthenticationDataProvider authData;
                    SslProvider sslProvider = null;
                    if (conf.getSslProvider() != null) {
                        sslProvider = SslProvider.valueOf((String)conf.getSslProvider());
                    }
                    if ((authData = conf.getAuthentication().getAuthData()).hasDataForTls()) {
                        return authData.getTlsTrustStoreStream() == null ? SecurityUtility.createNettySslContextForClient((SslProvider)sslProvider, (boolean)conf.isTlsAllowInsecureConnection(), (String)conf.getTlsTrustCertsFilePath(), (Certificate[])authData.getTlsCertificates(), (PrivateKey)authData.getTlsPrivateKey(), conf.getTlsCiphers(), conf.getTlsProtocols()) : SecurityUtility.createNettySslContextForClient((SslProvider)sslProvider, (boolean)conf.isTlsAllowInsecureConnection(), (InputStream)authData.getTlsTrustStoreStream(), (Certificate[])authData.getTlsCertificates(), (PrivateKey)authData.getTlsPrivateKey(), conf.getTlsCiphers(), conf.getTlsProtocols());
                    }
                    return SecurityUtility.createNettySslContextForClient((SslProvider)sslProvider, (boolean)conf.isTlsAllowInsecureConnection(), (String)conf.getTlsTrustCertsFilePath(), (String)conf.getTlsCertificateFilePath(), (String)conf.getTlsKeyFilePath(), conf.getTlsCiphers(), conf.getTlsProtocols());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create TLS context", e);
                }
            }, TLS_CERTIFICATE_CACHE_MILLIS, TimeUnit.MILLISECONDS);
        } else {
            this.sslContextSupplier = null;
        }
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("consolidation", (ChannelHandler)new FlushConsolidationHandler(1024, true));
        ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.getEncoder((boolean)this.tlsEnabled));
        FrameDecoderUtil.addFrameDecoder((ChannelPipeline)ch.pipeline(), (int)0x500000);
        ChannelHandler clientCnx = (ChannelHandler)this.clientCnxSupplier.get();
        ch.pipeline().addLast("handler", clientCnx);
    }

    CompletableFuture<Channel> initTls(Channel ch, InetSocketAddress sniHost) {
        Objects.requireNonNull(ch, "A channel is required");
        Objects.requireNonNull(sniHost, "A sniHost is required");
        if (!this.tlsEnabled) {
            throw new IllegalStateException("TLS is not enabled in client configuration");
        }
        CompletableFuture<Channel> initTlsFuture = new CompletableFuture<Channel>();
        ch.eventLoop().execute(() -> {
            try {
                SslHandler handler;
                SslHandler sslHandler = handler = this.tlsEnabledWithKeyStore ? new SslHandler(((KeyStoreSSLContext)this.nettySSLContextAutoRefreshBuilder.get()).createSSLEngine(sniHost.getHostString(), sniHost.getPort())) : this.sslContextSupplier.get().newHandler(ch.alloc(), sniHost.getHostString(), sniHost.getPort());
                if (this.tlsHostnameVerificationEnabled) {
                    SecurityUtility.configureSSLHandler((SslHandler)handler);
                }
                ch.pipeline().addFirst(TLS_HANDLER, (ChannelHandler)handler);
                initTlsFuture.complete(ch);
            }
            catch (Throwable t) {
                initTlsFuture.completeExceptionally(t);
            }
        });
        return initTlsFuture;
    }

    CompletableFuture<Channel> initSocks5IfConfig(Channel ch) {
        CompletableFuture<Channel> initSocks5Future = new CompletableFuture<Channel>();
        if (this.socks5ProxyAddress != null) {
            ch.eventLoop().execute(() -> {
                try {
                    Socks5ProxyHandler socks5ProxyHandler = new Socks5ProxyHandler((SocketAddress)this.socks5ProxyAddress, this.socks5ProxyUsername, this.socks5ProxyPassword);
                    ch.pipeline().addFirst(socks5ProxyHandler.protocol(), (ChannelHandler)socks5ProxyHandler);
                    initSocks5Future.complete(ch);
                }
                catch (Throwable t) {
                    initSocks5Future.completeExceptionally(t);
                }
            });
        } else {
            initSocks5Future.complete(ch);
        }
        return initSocks5Future;
    }

    CompletableFuture<Channel> initializeClientCnx(Channel ch, InetSocketAddress logicalAddress, InetSocketAddress unresolvedPhysicalAddress) {
        return NettyFutureUtil.toCompletableFuture((Future)ch.eventLoop().submit(() -> {
            ClientCnx cnx = (ClientCnx)ch.pipeline().get("handler");
            if (cnx == null) {
                throw new IllegalStateException("Missing ClientCnx. This should not happen.");
            }
            if (!logicalAddress.equals(unresolvedPhysicalAddress)) {
                cnx.setTargetBroker(logicalAddress);
            }
            cnx.setRemoteHostName(unresolvedPhysicalAddress.getHostString());
            return ch;
        }));
    }

    @Generated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }
}

