/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RowCalculator {
    private final int buckets;
    private final int rows;
    private final List<Integer> rowCountList;

    public RowCalculator(int buckets, int rows) {
        this.buckets = buckets;
        this.rows = rows;
        this.rowCountList = Collections.synchronizedList(new ArrayList(buckets));
        this.init();
    }

    public synchronized int size() {
        return this.rowCountList.size();
    }

    public synchronized int getNext() {
        return this.rowCountList.remove(0);
    }

    public int getRowsPerBucket() {
        return this.rows / this.buckets;
    }

    public int getExtraRowCount() {
        return this.rows % this.buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        for (int i = 0; i < this.buckets; ++i) {
            List<Integer> list = this.rowCountList;
            synchronized (list) {
                if (i == 0) {
                    if (this.rows < this.buckets) {
                        this.rowCountList.add(this.getExtraRowCount());
                    } else {
                        this.rowCountList.add(this.getRowsPerBucket() + this.getExtraRowCount());
                    }
                } else {
                    this.rowCountList.add(this.getRowsPerBucket());
                }
                continue;
            }
        }
    }
}

