/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.generators;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.LoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;
import org.apache.phoenix.pherf.workload.mt.handlers.TenantOperationWorkHandler;
import org.apache.phoenix.pherf.workload.mt.operations.TenantOperationFactory;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLoadEventGenerator
implements LoadEventGenerator<TenantOperationInfo> {
    protected static final int DEFAULT_NUM_HANDLER_PER_SCENARIO = 4;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseLoadEventGenerator.class);
    protected Disruptor<TenantOperationEvent> disruptor;
    protected List<PherfWorkHandler> handlers;
    protected final Properties properties;
    protected final TenantOperationFactory operationFactory;
    protected final ExceptionHandler exceptionHandler;

    public BaseLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, List<PherfWorkHandler> workers, Properties properties) {
        this(phoenixUtil, model, scenario, workers, new WorkloadExceptionHandler(), properties);
    }

    public BaseLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, Properties properties) {
        this(phoenixUtil, model, scenario, null, new WorkloadExceptionHandler(), properties);
    }

    public BaseLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, List<PherfWorkHandler> workers, ExceptionHandler exceptionHandler, Properties properties) {
        this.operationFactory = new TenantOperationFactory(phoenixUtil, model, scenario);
        if (scenario.getPhoenixProperties() != null) {
            properties.putAll(scenario.getPhoenixProperties());
        }
        this.properties = properties;
        if (workers == null || workers.isEmpty()) {
            workers = this.getWorkHandlers(properties);
        }
        this.handlers = workers;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public PhoenixUtil getPhoenixUtil() {
        return this.operationFactory.getPhoenixUtil();
    }

    @Override
    public Scenario getScenario() {
        return this.operationFactory.getScenario();
    }

    @Override
    public DataModel getModel() {
        return this.operationFactory.getModel();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public TenantOperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    @Override
    public void start() throws Exception {
        Scenario scenario = this.operationFactory.getScenario();
        String currentThreadName = Thread.currentThread().getName();
        int bufferSize = 8192;
        if (this.properties.containsKey("pherf.mt.buffer_size_per_scenario")) {
            bufferSize = Integer.parseInt((String)this.properties.get("pherf.mt.buffer_size_per_scenario"));
        }
        this.disruptor = new Disruptor<TenantOperationEvent>(TenantOperationEvent.EVENT_FACTORY, bufferSize, new ThreadFactoryBuilder().setNameFormat(currentThreadName + "." + scenario.getName()).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.setDefaultExceptionHandler(this.exceptionHandler);
        this.disruptor.handleEventsWithWorkerPool(this.handlers.toArray(new WorkHandler[0]));
        RingBuffer<TenantOperationEvent> ringBuffer = this.disruptor.start();
        long numOperations = scenario.getLoadProfile().getNumOperations();
        while (numOperations > 0L) {
            TenantOperationInfo sample = this.next();
            this.operationFactory.initializeTenant(sample);
            long sequence = ringBuffer.next();
            TenantOperationEvent event = ringBuffer.get(sequence);
            event.setTenantOperationInfo(sample);
            ringBuffer.publish(sequence);
            LOGGER.info(String.format("published : %s:%s:%d, %d, %d", scenario.getName(), scenario.getTableName(), --numOperations, ringBuffer.getCursor(), sequence));
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
        }
    }

    @Override
    public List<PherfWorkHandler> getWorkHandlers(Properties properties) {
        String handlerName = "";
        try {
            handlerName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        int handlerCount = 4;
        if (properties.containsKey("pherf.mt.handlers_per_scenario")) {
            handlerCount = Integer.parseInt((String)properties.get("pherf.mt.handlers_per_scenario"));
        }
        ArrayList<PherfWorkHandler> workers = Lists.newArrayListWithCapacity(handlerCount);
        for (int i = 0; i < handlerCount; ++i) {
            String handlerId = String.format("%s.%d", handlerName, i + 1);
            workers.add(new TenantOperationWorkHandler(this.operationFactory, handlerId));
        }
        return workers;
    }

    @Override
    public abstract TenantOperationInfo next();

    public static class TenantOperationEvent {
        TenantOperationInfo tenantOperationInfo;
        public static final EventFactory<TenantOperationEvent> EVENT_FACTORY = new EventFactory<TenantOperationEvent>(){

            @Override
            public TenantOperationEvent newInstance() {
                return new TenantOperationEvent();
            }
        };

        public TenantOperationInfo getTenantOperationInfo() {
            return this.tenantOperationInfo;
        }

        public void setTenantOperationInfo(TenantOperationInfo tenantOperationInfo) {
            this.tenantOperationInfo = tenantOperationInfo;
        }
    }

    private static class WorkloadExceptionHandler
    implements ExceptionHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(WorkloadExceptionHandler.class);

        private WorkloadExceptionHandler() {
        }

        public void handleEventException(Throwable ex, long sequence, Object event) {
            LOGGER.error("Sequence=" + sequence + ", event=" + event, ex);
            throw new RuntimeException(ex);
        }

        @Override
        public void handleOnStartException(Throwable ex) {
            LOGGER.error("On Start", ex);
            throw new RuntimeException(ex);
        }

        @Override
        public void handleOnShutdownException(Throwable ex) {
            LOGGER.error("On Shutdown", ex);
            throw new RuntimeException(ex);
        }
    }
}

