/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.RunTime;

public class ThreadTime {
    private List<RunTime> runTimesInMs = Collections.synchronizedList(new ArrayList());
    private String threadName;

    public synchronized List<RunTime> getRunTimesInMs() {
        return this.runTimesInMs;
    }

    public synchronized void setRunTimesInMs(List<RunTime> runTimesInMs) {
        this.runTimesInMs = runTimesInMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getStartTime() {
        if (this.getRunTimesInMs().isEmpty()) {
            return new Date(0L);
        }
        Date startTime = null;
        List<RunTime> list = this.getRunTimesInMs();
        synchronized (list) {
            for (RunTime runTime : this.getRunTimesInMs()) {
                if (null != runTime.getStartTime()) {
                    Date currStartTime = new Date(runTime.getStartTime().getTime());
                    if (null == startTime) {
                        startTime = currStartTime;
                        continue;
                    }
                    if (currStartTime.compareTo(startTime) >= 0) continue;
                    startTime = currStartTime;
                    continue;
                }
                startTime = new Date(0L);
            }
        }
        return startTime;
    }

    public RunTime getMinTimeInMs() {
        if (this.getRunTimesInMs().isEmpty()) {
            return null;
        }
        return Collections.min(this.getRunTimesInMs());
    }

    public Integer getAvgTimeInMs() {
        if (this.getRunTimesInMs().isEmpty()) {
            return null;
        }
        Long totalTimeInMs = new Long(0L);
        for (RunTime runTime : this.getRunTimesInMs()) {
            if (null == runTime.getElapsedDurationInMs()) continue;
            totalTimeInMs = totalTimeInMs + runTime.getElapsedDurationInMs();
        }
        return (int)(totalTimeInMs / (long)this.getRunTimesInMs().size());
    }

    public RunTime getMaxTimeInMs() {
        if (this.getRunTimesInMs().isEmpty()) {
            return null;
        }
        return Collections.max(this.getRunTimesInMs());
    }

    @XmlAttribute
    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    private String parseThreadName(boolean getConcurrency) {
        if (this.getThreadName() == null || !this.getThreadName().contains(",")) {
            return null;
        }
        String[] threadNameSet = this.getThreadName().split(",");
        if (getConcurrency) {
            return threadNameSet[1];
        }
        return threadNameSet[0];
    }

    public List<List<ResultValue>> getCsvPerformanceRepresentation(ResultUtil util) {
        ArrayList<List<ResultValue>> rows = new ArrayList<List<ResultValue>>();
        for (int i = 0; i < this.getRunTimesInMs().size(); ++i) {
            ArrayList<ResultValue<Object>> rowValues = new ArrayList<ResultValue<Object>>(this.getRunTimesInMs().size());
            rowValues.add(new ResultValue<String>(util.convertNull(this.parseThreadName(false))));
            rowValues.add(new ResultValue<String>(util.convertNull(this.parseThreadName(true))));
            rowValues.add(new ResultValue<String>(String.valueOf(this.getRunTimesInMs().get(i).getResultRowCount())));
            if (this.getRunTimesInMs().get(i).getMessage() == null) {
                rowValues.add(new ResultValue<String>(util.convertNull(String.valueOf(this.getRunTimesInMs().get(i).getElapsedDurationInMs()))));
            } else {
                rowValues.add(new ResultValue<String>(util.convertNull(this.getRunTimesInMs().get(i).getMessage())));
            }
            rowValues.add(new ResultValue<Boolean>(this.getRunTimesInMs().get(i).getTimedOut()));
            rows.add(rowValues);
        }
        return rows;
    }

    public List<List<ResultValue>> getCsvFunctionalRepresentation(ResultUtil util) {
        ArrayList<List<ResultValue>> rows = new ArrayList<List<ResultValue>>();
        for (int i = 0; i < this.getRunTimesInMs().size(); ++i) {
            ArrayList<ResultValue<String>> rowValues = new ArrayList<ResultValue<String>>(this.getRunTimesInMs().size());
            rowValues.add(new ResultValue<String>(util.convertNull(this.parseThreadName(false))));
            rowValues.add(new ResultValue<String>(util.convertNull(this.parseThreadName(true))));
            rowValues.add(new ResultValue<String>(util.convertNull(this.getRunTimesInMs().get(i).getMessage())));
            rowValues.add(new ResultValue<String>(util.convertNull(this.getRunTimesInMs().get(i).getExplainPlan())));
            rows.add(rowValues);
        }
        return rows;
    }

    public int getRunCount() {
        if (this.getRunTimesInMs().isEmpty()) {
            return 0;
        }
        return this.getRunTimesInMs().size();
    }
}

