/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.configuration;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.rules.RulesApplier;

@XmlType
public class Query {
    private String id;
    private String queryGroup;
    private String tenantId;
    private String statement;
    private Long expectedAggregateRowCount;
    private String ddl;
    private boolean useGlobalConnection;
    private Pattern pattern;
    private long timeoutDuration = Long.MAX_VALUE;

    public Query() {
        this.pattern = Pattern.compile("\\[.*?\\]");
    }

    @XmlAttribute
    public String getStatement() {
        return this.statement;
    }

    public String getDynamicStatement(RulesApplier ruleApplier, Scenario scenario) throws Exception {
        String ret = this.statement;
        String needQuotes = "";
        Matcher m = this.pattern.matcher(ret);
        while (m.find()) {
            String dynamicField = m.group(0).replace("[", "").replace("]", "");
            Column dynamicColumn = ruleApplier.getRule(dynamicField, scenario);
            if (dynamicColumn == null || dynamicColumn.getType() == null) continue;
            needQuotes = dynamicColumn.getType() == DataTypeMapping.CHAR || dynamicColumn.getType() == DataTypeMapping.VARCHAR ? "'" : "";
            ret = ret.replace("[" + dynamicField + "]", needQuotes + ruleApplier.getDataValue(dynamicColumn).getValue() + needQuotes);
        }
        return ret;
    }

    public void setStatement(String statement) {
        this.statement = statement.replaceAll("\\s+", " ");
    }

    @XmlAttribute
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @XmlAttribute
    public Long getExpectedAggregateRowCount() {
        return this.expectedAggregateRowCount;
    }

    public void setExpectedAggregateRowCount(Long expectedAggregateRowCount) {
        this.expectedAggregateRowCount = expectedAggregateRowCount;
    }

    @XmlAttribute
    public String getDdl() {
        return this.ddl;
    }

    public void setDdl(String ddl) {
        this.ddl = ddl;
    }

    @XmlAttribute
    public String getQueryGroup() {
        return this.queryGroup;
    }

    public void setQueryGroup(String queryGroup) {
        this.queryGroup = queryGroup;
    }

    public void setHint(String queryHint) {
        if (null != queryHint) {
            this.statement = this.statement.toUpperCase().replace("SELECT ", "SELECT /*+ " + queryHint + "*/ ");
        }
    }

    @XmlAttribute
    public String getId() {
        if (null == this.id) {
            this.id = UUID.randomUUID().toString();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute
    public boolean isUseGlobalConnection() {
        return this.useGlobalConnection;
    }

    public void setUseGlobalConnection(boolean useGlobalConnection) {
        this.useGlobalConnection = useGlobalConnection;
    }

    @XmlAttribute
    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public void setTimeoutDuration(long timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
    }
}

