/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.ranger;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class RangerServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "RANGER";
    public static final String SERVICE_TYPE = "RANGER";
    public static final String ROLE_TYPE = "RANGER_ADMIN";
    static final String SSL_ENABLED = "ssl_enabled";
    static final String HTTP_PORT = "ranger_service_http_port";
    static final String HTTPS_PORT = "ranger_service_https_port";

    @Override
    public String getService() {
        return "RANGER";
    }

    @Override
    public String getServiceType() {
        return "RANGER";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        String sslEnabled = this.getRoleConfigValue(roleConfig, SSL_ENABLED);
        if (Boolean.parseBoolean(sslEnabled)) {
            scheme = "https";
            port = this.getServiceConfigValue(serviceConfig, HTTPS_PORT);
        } else {
            scheme = "http";
            port = this.getServiceConfigValue(serviceConfig, HTTP_PORT);
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addServiceProperty(HTTP_PORT, this.getServiceConfigValue(serviceConfig, HTTP_PORT));
        model.addServiceProperty(HTTPS_PORT, this.getServiceConfigValue(serviceConfig, HTTPS_PORT));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, sslEnabled);
        return model;
    }
}

