/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;

class PropertyFunctionFactoryAuto
implements PropertyFunctionFactory {
    private final Class<?> extClass;

    PropertyFunctionFactoryAuto(Class<?> xClass) {
        this.extClass = xClass;
        if (!PropertyFunction.class.isAssignableFrom(xClass)) {
            throw new ARQInternalErrorException("No PropertyFunction interface for " + Lib.classShortName(xClass));
        }
    }

    @Override
    public PropertyFunction create(String uri) {
        try {
            return (PropertyFunction)this.extClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new QueryBuildException("Can't instantiate PropertyFunction for " + uri, e2);
        }
    }

    public Class<?> getAutoClass() {
        return this.extClass;
    }
}

