/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.sparql.core.DatasetGraph;

public abstract class ActionREST
extends ActionService {
    @Override
    public void execute(HttpAction action) {
        String method;
        switch (method = Lib.uppercase(action.getRequestMethod())) {
            case "GET": {
                this.doGet$(action);
                break;
            }
            case "HEAD": {
                this.doHead$(action);
                break;
            }
            case "POST": {
                this.doPost$(action);
                break;
            }
            case "PATCH": {
                this.doPatch$(action);
                break;
            }
            case "PUT": {
                this.doPut$(action);
                break;
            }
            case "DELETE": {
                this.doDelete$(action);
                break;
            }
            case "OPTIONS": {
                this.doOptions$(action);
                break;
            }
            case "TRACE": {
                this.doTrace$(action);
                break;
            }
            default: {
                ServletOps.errorNotImplemented("Unknown method: " + method);
            }
        }
    }

    protected DatasetGraph decideDataset(HttpAction action) {
        return action.getActiveDSG();
    }

    private final void doGet$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPget);
        try {
            this.doGet(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPgetGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPgetBad);
            throw ex;
        }
    }

    private final void doHead$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPhead);
        try {
            this.doHead(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPheadGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPheadBad);
            throw ex;
        }
    }

    private final void doPost$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpost);
        try {
            this.doPost(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpostGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpostBad);
            throw ex;
        }
    }

    private final void doPatch$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpatch);
        try {
            this.doPatch(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpatchGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpatchBad);
            throw ex;
        }
    }

    private final void doDelete$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPdelete);
        try {
            this.doDelete(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPdeleteGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPdeleteBad);
            throw ex;
        }
    }

    private final void doPut$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPput);
        try {
            this.doPut(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPputGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPputBad);
            throw ex;
        }
    }

    private final void doOptions$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPoptions);
        try {
            this.doOptions(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPoptionsGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPoptionsBad);
            throw ex;
        }
    }

    private final void doTrace$(HttpAction action) {
        ServletOps.errorMethodNotAllowed("TRACE");
    }

    protected abstract void doGet(HttpAction var1);

    protected abstract void doHead(HttpAction var1);

    protected abstract void doPost(HttpAction var1);

    protected abstract void doPut(HttpAction var1);

    protected abstract void doDelete(HttpAction var1);

    protected abstract void doPatch(HttpAction var1);

    protected abstract void doOptions(HttpAction var1);

    @Override
    public void process(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void execAny(String methodName, HttpAction action) {
        this.executeLifecycle(action);
    }
}

