/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Consumer;
import org.apache.commons.cli.Option;
import org.apache.rat.utils.DefaultLog;

public final class DeprecationReporter {
    private DeprecationReporter() {
    }

    public static Consumer<Option> getLogReporter() {
        return o -> {
            StringBuilder buff = new StringBuilder();
            if (o.getOpt() != null) {
                buff.append("-").append(o.getOpt());
                if (o.getLongOpt() != null) {
                    buff.append(", --").append(o.getLongOpt());
                }
            } else {
                buff.append("--").append(o.getLongOpt());
            }
            DefaultLog.getInstance().warn(String.format("Option [%s] used. %s", buff, o.getDeprecated().toString()));
        };
    }

    public static void logDeprecated(Class<?> clazz) {
        if (clazz.getAnnotation(Deprecated.class) != null) {
            StringBuilder sb = new StringBuilder(String.format("Deprecated class used: %s ", clazz));
            Info info = clazz.getAnnotation(Info.class);
            if (info != null) {
                if (info.forRemoval()) {
                    sb.append("  Scheduled for removal");
                    if (!info.since().isEmpty()) {
                        sb.append(" since ").append(info.since());
                    }
                    sb.append(".");
                } else if (!info.since().isEmpty()) {
                    sb.append(" Deprecated since ").append(info.since()).append(".");
                }
                if (!info.use().isEmpty()) {
                    sb.append(" Use ").append(info.use()).append(" instead.");
                }
            }
            DefaultLog.getInstance().warn(sb.toString());
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Info {
        public String since() default "";

        public boolean forRemoval() default false;

        public String use() default "";
    }
}

