/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.analysis.matchers.AbstractHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;

public final class SPDXMatcherFactory {
    private static final Map<String, Match> MATCHER_MAP = new HashMap<String, Match>();
    public static final SPDXMatcherFactory INSTANCE = new SPDXMatcherFactory();
    static final String LICENSE_IDENTIFIER = "SPDX-License-Identifier:";
    private static final Pattern GROUP_SELECTOR = Pattern.compile(".*SPDX-License-Identifier:\\s([A-Za-z0-9\\.\\-]+)");
    private final Set<String> lastMatch = new HashSet<String>();
    private boolean checked;

    private SPDXMatcherFactory() {
    }

    private void reset() {
        this.lastMatch.clear();
        this.checked = false;
    }

    public Match create(String spdxId) {
        if (StringUtils.isBlank(spdxId)) {
            throw new ConfigurationException("'SPDX' type matcher requires a name");
        }
        Match matcher = MATCHER_MAP.get(spdxId);
        if (matcher == null) {
            matcher = new Match(spdxId);
            MATCHER_MAP.put(spdxId, matcher);
        }
        return matcher;
    }

    private boolean check(String documentText, Match caller) {
        if (!this.checked) {
            this.checked = true;
            if (documentText.contains(LICENSE_IDENTIFIER)) {
                Matcher matcher = GROUP_SELECTOR.matcher(documentText);
                while (matcher.find()) {
                    this.lastMatch.add(matcher.group(1));
                }
            }
        }
        return this.lastMatch.contains(caller.spdxId);
    }

    @ConfigComponent(type=ComponentType.MATCHER, name="spdx", desc="Matches SPDX enclosed license identifier.")
    public class Match
    extends AbstractHeaderMatcher {
        @ConfigComponent(type=ComponentType.PARAMETER, name="name", desc="The SPDX identifier string")
        private final String spdxId;

        public String getName() {
            return this.spdxId;
        }

        Match(String spdxId) {
            super("SPDX:" + spdxId);
            Objects.requireNonNull(spdxId, "SpdxId is required");
            this.spdxId = spdxId;
        }

        @Override
        public boolean matches(IHeaders headers) {
            return SPDXMatcherFactory.this.check(headers.raw(), this);
        }

        @Override
        public void reset() {
            super.reset();
            SPDXMatcherFactory.this.reset();
        }
    }
}

