/*
 * Define default path names for the terraintool.properties file and the data cache. This
 * class is platform-agnostic. Use an os-specific implementation of Pathnames interface to
 * force files into os-dependent locations. See for example DebianPathnames.
 */
package uk.co.mccombe.terrain;

/**
 *
 * @author Mike
 */
public class DefaultPathnames implements Pathnames {

    @Override
    public String propertiesPath() {
        if (isUnix()) {
            if (CONFIGHOME != null) {
                return CONFIGHOME + SEP + "terraintool" + SEP;
            } else {
                return HOME + SEP + ".config" + SEP + "terraintool" + SEP;
            }

        }
        return HOME + SEP + SUBDIR + SEP; //If not Linux variant, assume to be Windows
    }

    @Override
    public String dataPath() {
        if (isUnix()) {
            if (DATAHOME != null) {
                return DATAHOME + SEP + "terraintool" + SEP;
            } else {
                return HOME + SEP + ".local" + SEP + "share" + SEP + "terraintool" + SEP;
            }
        }
        return HOME + SEP + SUBDIR + SEP ;//If not Linux variant, assume to be Windows
    }

    protected boolean isUnix() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("linux");
    }
    private static final String HOME = System.getProperty("user.home");
    private static final String SEP = System.getProperty("file.separator");
    private static final String SUBDIR = ".terraintool";
    private static final String CONFIGHOME = System.getenv("$XDG_CONFIG_HOME");
    private static final String DATAHOME = System.getenv("$XDG_DATA_HOME");

}
