# Changelog

## 2.2.7

- BugFix: Fix `malloc` implementation from being just wrong to being right (I think?)
- BugFix: Fix `MMU.translate_address` to actually return the best match (wow!)
- Feature: The instruction trace now contains register and symbol values starting at verbosity level 3
- BugFix: RVDebug got better at finding out if a float or int register was meant

## 2.2.6

 - Feature: Canonicalize register names when parsing, converting e.g. `x0 -> zero` or `fp -> s0`.
 - Feature: Added support for `fcvt.d.w[u]` and `fcvt.w[u].d` instructions
 - BugFix: Fixed that registers were treated as UInt32s instead of Int32 (this may have caused subtle bugs before)
 - Feature: Added the remainder of the `M` extension
 - BugFix: Fixed a bug in the overflow behavior of `mulh`
 - BugFix: Fix faulty length assertion in `jalr`

## 2.2.5

 - BugFix: Fix missed import in core.simple_instruction

## 2.2.4

 - BugFix: Found and added some missing floating point registers (`ft8` to `ft11`)
 - Feature: Add frep support to the snitch emulation
 - Feature: Add support for 64-bit floats to the snitch Xssr emulation

## 2.2.3

 - Feature: Adding support for 64 bit floating point operations
 - BugFix: Fix a bug where `-o libc` would fail with packaged versions of riscemu
 - BugFix: Fix `__all__` to now properly work (use name strings instead of values)

## 2.2.2

 - Dev: Add `__all__` to `riscemu.{core,instructions,decoder}` modules to make pyright in other projects happy
 - Perf: very minor fix related to not converting values twice when loaded from memory

## 2.2.1

Version bump to re-trigger CI run.

## 2.2.0

 - Feature: Added Zicsr extension and with that support for CSRs
 - Feature: Starting to add support for Snitch architecture (Xssr)
 - Feature: Add support for `.p2align` assembler directive
 - Rework: Improve handling of immediates, so that `beq a0, a1, 1b` and `beq a0, a1, -16` can both can be handled correctly.
 - BugFix: Fix some more errors in the RV32F implementation
 - Dev: Move to poetry for project development environment
 - Dev: Module refactoring, core datastructures now mostly live inside riscemu.core
 - Perf: Improved performance by around 1.8x

## 2.1.1

 - Bugfix: Fix some errors in the RV32F implementation (thanks @adutilleul)
 - Bugfix: Fix how floats are printed in the register view (thanks @KGrykiel)
 - Bugfix: Fix missing support for infinite registers in load/store ins (thanks @superlopuh)

## 2.1.0

 - Added a very basic libc containing a `crt0.s`, and a few functions
   such as `malloc`, `rand`, and `memcpy`.
 - Added a subset of the `mmap2` syscall (code 192) to allocate new memory
 - Refactored the launching code to improve using riscemu from code
 - Added an option to start with the provided libc: `-o libc`
 - Added floating point support (enabled by default). The RV32F extension is now available

## 2.0.5

 - Added unlimited register mode with `-o unlimited_regs`

## 2.0.4

 - Bugfix: fix a sign issue in instruction parsing for `rd, rs, rs` format
 - Bugfix: respect `conf.debug_instruction` setting

## 2.0.3 - 2022-04-18

 - Syscalls: cleaned up formatting and added instructions for extensions
 - Parser: fixed error when labels where used outside of sections
 - Cleaned up and improved memory dumping code
 - Fixed a bug with hex literal recognition in instruction parse code
 - Fixed bug where wrong parts of section would be printed in mmu.dump()
 - Removed tests for bind_twos_complement as the function is now redundant with the introduction of Int32
 - Fixed address translation error for sections without symbols
 - Changed verbosity level at which start and end of CPU are printed, added prints for start and stack loading

## 2.0.2

 - Added implicit declaration of .text section when a file starts with assembly instructions without declaring a section first
 - Fixed a regression where the cpu's exit code would no longer be the exit code of the emulator. Now the emulator exits with the cpu's exit code
 - Added the changelog

## 2.0.1

 - Fixed type annotations in parser code that prevented running unprivileged code

## 2.0.0

 - Correct handling of 32 bit overflows and underflows
 - Complete revamp of internal data structures
 - Completely reworked how assembly is parsed
