/* This file is part of the 'stringi' project.
 * Copyright (c) 2013-2022, Marek Gagolewski <https://www.gagolewski.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef __stri_external_h
#define __stri_external_h


#ifdef  U_CHARSET_IS_UTF8
// do not enable this (must be unset before including ICU headers):
#undef  U_CHARSET_IS_UTF8
#define U_CHARSET_IS_UTF8 0
#endif

//#ifndef NDEBUG
//#define U_HIDE_DRAFT_API
//#define U_HIDE_DEPRECATED_API
//#endif

#define  UNISTR_FROM_CHAR_EXPLICIT   explicit
#define  UNISTR_FROM_STRING_EXPLICIT explicit


#include <unicode/ptypes.h>
#include <unicode/uchar.h>
#include <unicode/utypes.h>
#include <unicode/ucnv.h>
#include <unicode/ustring.h>
#include <unicode/stringpiece.h>
#include <unicode/utf8.h>
#include <unicode/utf16.h>
#include <unicode/brkiter.h>
#include <unicode/rbbi.h>
#include <unicode/timezone.h>
using namespace icu;

// #define USE_RINTERNALS  removed 2021-08-12 - do not use anymore
// #define R_NO_REMAP      removed 2021-08-12 - do not use anymore
#include <R.h>
#include <Rversion.h>
#include <Rinternals.h>
#include <Rmath.h>
#include <Rdefines.h>
#include <R_ext/Rdynload.h>

#if R_VERSION >= R_Version(3, 5, 0)

#else
/* ALTREP is R>=3.5.0 */
#define ALTREP(x) (0)
#endif


#endif
